//===-- StdSpecialSymbolMap.inc ---------------------------------*- C++ -*-===//
//
// This is a hand-curated list for C++ symbols that cannot be parsed/extracted
// via the include-mapping tool (gen_std.py).
//
//===----------------------------------------------------------------------===//

// Symbols that can be provided by any of the headers, ordered by the header
// preference.
// cppreference mentions the <locale> header is an alternative for these symbols,
// but they are not per the standard.
SYMBOL(consume_header, std::, <codecvt>)
SYMBOL(generate_header, std::, <codecvt>)
SYMBOL(little_endian, std::, <codecvt>)

SYMBOL(mbstate_t, std::, <cwchar>)
SYMBOL(mbstate_t, std::, <cuchar>)
SYMBOL(size_t, std::, <cstddef>)
SYMBOL(size_t, std::, <cstdlib>)
SYMBOL(size_t, std::, <cstring>)
SYMBOL(size_t, std::, <cwchar>)
SYMBOL(size_t, std::, <cuchar>)
SYMBOL(size_t, std::, <ctime>)
SYMBOL(size_t, std::, <cstdio>)
SYMBOL(size_t, None, <cstddef>)
SYMBOL(size_t, None, <cstdlib>)
SYMBOL(size_t, None, <cstring>)
SYMBOL(size_t, None, <cwchar>)
SYMBOL(size_t, None, <cuchar>)
SYMBOL(size_t, None, <ctime>)
SYMBOL(size_t, None, <cstdio>)
SYMBOL(size_t, None, <stddef.h>)
SYMBOL(size_t, None, <stdlib.h>)
SYMBOL(size_t, None, <string.h>)
SYMBOL(size_t, None, <wchar.h>)
SYMBOL(size_t, None, <uchar.h>)
SYMBOL(size_t, None, <time.h>)
SYMBOL(size_t, None, <stdio.h>)
SYMBOL(unwrap_ref_decay, std::, <type_traits>)
SYMBOL(unwrap_ref_decay, std::, <functional>)
SYMBOL(unwrap_reference, std::, <type_traits>)
SYMBOL(unwrap_reference, std::, <functional>)
SYMBOL(unwrap_ref_decay_t, std::, <type_traits>)
SYMBOL(unwrap_ref_decay_t, std::, <functional>)
SYMBOL(wint_t, std::, <cwctype>)
SYMBOL(wint_t, std::, <cwchar>)
SYMBOL(swap, std::, <utility>)
SYMBOL(swap, std::, <algorithm>) // until C++11
// C++ [string.view.synop 23.3.2]: The function templates defined in
// [utility.swap] ... are available when <string_­view> is included.
SYMBOL(swap, std::, <string_view>) // since C++17
// C++ [tuple.helper 22.4.7]: In addition to being available via inclusion of
// the <tuple> header, ... any of the headers <array>, <ranges>, or <utility>
// are included.
SYMBOL(tuple_size, std::, <tuple>)
SYMBOL(tuple_size, std::, <array>)
SYMBOL(tuple_size, std::, <ranges>)
SYMBOL(tuple_size, std::, <utility>)
SYMBOL(tuple_element, std::, <tuple>)
SYMBOL(tuple_element, std::, <array>)
SYMBOL(tuple_element, std::, <ranges>)
SYMBOL(tuple_element, std::, <utility>)
// C++ [iterator.range 25.7]: In addition to being available via inclusion of
// the <iterator> header, the function templates in [iterator.range] are
// available when any of the following headers are included: <array>, <deque>,
// <forward_­list>, ... and <vector>.
SYMBOL(begin, std::, <iterator>)
SYMBOL(begin, std::, <array>)
SYMBOL(begin, std::, <deque>)
SYMBOL(begin, std::, <forward_list>)
SYMBOL(begin, std::, <list>)
SYMBOL(begin, std::, <map>)
SYMBOL(begin, std::, <regex>)
SYMBOL(begin, std::, <set>)
SYMBOL(begin, std::, <span>)
SYMBOL(begin, std::, <string>)
SYMBOL(begin, std::, <string_view>)
SYMBOL(begin, std::, <unordered_map>)
SYMBOL(begin, std::, <unordered_set>)
SYMBOL(begin, std::, <vector>)
SYMBOL(cbegin, std::, <iterator>)
SYMBOL(cbegin, std::, <array>)
SYMBOL(cbegin, std::, <deque>)
SYMBOL(cbegin, std::, <forward_list>)
SYMBOL(cbegin, std::, <list>)
SYMBOL(cbegin, std::, <map>)
SYMBOL(cbegin, std::, <regex>)
SYMBOL(cbegin, std::, <set>)
SYMBOL(cbegin, std::, <span>)
SYMBOL(cbegin, std::, <string>)
SYMBOL(cbegin, std::, <string_view>)
SYMBOL(cbegin, std::, <unordered_map>)
SYMBOL(cbegin, std::, <unordered_set>)
SYMBOL(cbegin, std::, <vector>)
SYMBOL(cend, std::, <iterator>)
SYMBOL(cend, std::, <array>)
SYMBOL(cend, std::, <deque>)
SYMBOL(cend, std::, <forward_list>)
SYMBOL(cend, std::, <list>)
SYMBOL(cend, std::, <map>)
SYMBOL(cend, std::, <regex>)
SYMBOL(cend, std::, <set>)
SYMBOL(cend, std::, <span>)
SYMBOL(cend, std::, <string>)
SYMBOL(cend, std::, <string_view>)
SYMBOL(cend, std::, <unordered_map>)
SYMBOL(cend, std::, <unordered_set>)
SYMBOL(cend, std::, <vector>)
SYMBOL(crbegin, std::, <iterator>)
SYMBOL(crbegin, std::, <array>)
SYMBOL(crbegin, std::, <deque>)
SYMBOL(crbegin, std::, <forward_list>)
SYMBOL(crbegin, std::, <list>)
SYMBOL(crbegin, std::, <map>)
SYMBOL(crbegin, std::, <regex>)
SYMBOL(crbegin, std::, <set>)
SYMBOL(crbegin, std::, <span>)
SYMBOL(crbegin, std::, <string>)
SYMBOL(crbegin, std::, <string_view>)
SYMBOL(crbegin, std::, <unordered_map>)
SYMBOL(crbegin, std::, <unordered_set>)
SYMBOL(crbegin, std::, <vector>)
SYMBOL(crend, std::, <iterator>)
SYMBOL(crend, std::, <array>)
SYMBOL(crend, std::, <deque>)
SYMBOL(crend, std::, <forward_list>)
SYMBOL(crend, std::, <list>)
SYMBOL(crend, std::, <map>)
SYMBOL(crend, std::, <regex>)
SYMBOL(crend, std::, <set>)
SYMBOL(crend, std::, <span>)
SYMBOL(crend, std::, <string>)
SYMBOL(crend, std::, <string_view>)
SYMBOL(crend, std::, <unordered_map>)
SYMBOL(crend, std::, <unordered_set>)
SYMBOL(crend, std::, <vector>)
SYMBOL(data, std::, <iterator>)
SYMBOL(data, std::, <array>)
SYMBOL(data, std::, <deque>)
SYMBOL(data, std::, <forward_list>)
SYMBOL(data, std::, <list>)
SYMBOL(data, std::, <map>)
SYMBOL(data, std::, <regex>)
SYMBOL(data, std::, <set>)
SYMBOL(data, std::, <span>)
SYMBOL(data, std::, <string>)
SYMBOL(data, std::, <string_view>)
SYMBOL(data, std::, <unordered_map>)
SYMBOL(data, std::, <unordered_set>)
SYMBOL(data, std::, <vector>)
SYMBOL(empty, std::, <iterator>)
SYMBOL(empty, std::, <array>)
SYMBOL(empty, std::, <deque>)
SYMBOL(empty, std::, <forward_list>)
SYMBOL(empty, std::, <list>)
SYMBOL(empty, std::, <map>)
SYMBOL(empty, std::, <regex>)
SYMBOL(empty, std::, <set>)
SYMBOL(empty, std::, <span>)
SYMBOL(empty, std::, <string>)
SYMBOL(empty, std::, <string_view>)
SYMBOL(empty, std::, <unordered_map>)
SYMBOL(empty, std::, <unordered_set>)
SYMBOL(empty, std::, <vector>)
SYMBOL(end, std::, <iterator>)
SYMBOL(end, std::, <array>)
SYMBOL(end, std::, <deque>)
SYMBOL(end, std::, <forward_list>)
SYMBOL(end, std::, <list>)
SYMBOL(end, std::, <map>)
SYMBOL(end, std::, <regex>)
SYMBOL(end, std::, <set>)
SYMBOL(end, std::, <span>)
SYMBOL(end, std::, <string>)
SYMBOL(end, std::, <string_view>)
SYMBOL(end, std::, <unordered_map>)
SYMBOL(end, std::, <unordered_set>)
SYMBOL(end, std::, <vector>)
SYMBOL(rbegin, std::, <iterator>)
SYMBOL(rbegin, std::, <array>)
SYMBOL(rbegin, std::, <deque>)
SYMBOL(rbegin, std::, <forward_list>)
SYMBOL(rbegin, std::, <list>)
SYMBOL(rbegin, std::, <map>)
SYMBOL(rbegin, std::, <regex>)
SYMBOL(rbegin, std::, <set>)
SYMBOL(rbegin, std::, <span>)
SYMBOL(rbegin, std::, <string>)
SYMBOL(rbegin, std::, <string_view>)
SYMBOL(rbegin, std::, <unordered_map>)
SYMBOL(rbegin, std::, <unordered_set>)
SYMBOL(rbegin, std::, <vector>)
SYMBOL(rend, std::, <iterator>)
SYMBOL(rend, std::, <array>)
SYMBOL(rend, std::, <deque>)
SYMBOL(rend, std::, <forward_list>)
SYMBOL(rend, std::, <list>)
SYMBOL(rend, std::, <map>)
SYMBOL(rend, std::, <regex>)
SYMBOL(rend, std::, <set>)
SYMBOL(rend, std::, <span>)
SYMBOL(rend, std::, <string>)
SYMBOL(rend, std::, <string_view>)
SYMBOL(rend, std::, <unordered_map>)
SYMBOL(rend, std::, <unordered_set>)
SYMBOL(rend, std::, <vector>)
SYMBOL(size, std::, <iterator>)
SYMBOL(size, std::, <array>)
SYMBOL(size, std::, <deque>)
SYMBOL(size, std::, <forward_list>)
SYMBOL(size, std::, <list>)
SYMBOL(size, std::, <map>)
SYMBOL(size, std::, <regex>)
SYMBOL(size, std::, <set>)
SYMBOL(size, std::, <span>)
SYMBOL(size, std::, <string>)
SYMBOL(size, std::, <string_view>)
SYMBOL(size, std::, <unordered_map>)
SYMBOL(size, std::, <unordered_set>)
SYMBOL(size, std::, <vector>)
SYMBOL(ssize, std::, <iterator>)
SYMBOL(ssize, std::, <array>)
SYMBOL(ssize, std::, <deque>)
SYMBOL(ssize, std::, <forward_list>)
SYMBOL(ssize, std::, <list>)
SYMBOL(ssize, std::, <map>)
SYMBOL(ssize, std::, <regex>)
SYMBOL(ssize, std::, <set>)
SYMBOL(ssize, std::, <span>)
SYMBOL(ssize, std::, <string>)
SYMBOL(ssize, std::, <string_view>)
SYMBOL(ssize, std::, <unordered_map>)
SYMBOL(ssize, std::, <unordered_set>)
SYMBOL(ssize, std::, <vector>)
// C++ [range.access.general]: ... the customization point objects
// in [range.access] are available when the header <iterator> is included.
// (see https://eel.is/c++draft/range.access#general)
SYMBOL(begin, std::ranges::, <ranges>)
SYMBOL(begin, std::ranges::, <iterator>)
SYMBOL(end, std::ranges::, <ranges>)
SYMBOL(end, std::ranges::, <iterator>)
SYMBOL(cbegin, std::ranges::, <ranges>)
SYMBOL(cbegin, std::ranges::, <iterator>)
SYMBOL(cend, std::ranges::, <ranges>)
SYMBOL(cend, std::ranges::, <iterator>)
SYMBOL(rbegin, std::ranges::, <ranges>)
SYMBOL(rbegin, std::ranges::, <iterator>)
SYMBOL(rend, std::ranges::, <ranges>)
SYMBOL(rend, std::ranges::, <iterator>)
SYMBOL(crbegin, std::ranges::, <ranges>)
SYMBOL(crbegin, std::ranges::, <iterator>)
SYMBOL(crend, std::ranges::, <ranges>)
SYMBOL(crend, std::ranges::, <iterator>)
SYMBOL(size, std::ranges::, <ranges>)
SYMBOL(size, std::ranges::, <iterator>)
SYMBOL(ssize, std::ranges::, <ranges>)
SYMBOL(ssize, std::ranges::, <iterator>)
SYMBOL(empty, std::ranges::, <ranges>)
SYMBOL(empty, std::ranges::, <iterator>)
SYMBOL(data, std::ranges::, <ranges>)
SYMBOL(data, std::ranges::, <iterator>)
SYMBOL(cdata, std::ranges::, <ranges>)
SYMBOL(cdata, std::ranges::, <iterator>)
// https://eel.is/c++draft/tuple.general#2:
// In addition to being available via inclusion of the <tuple> header,
// ignore ... is available when <utility> ... is included.
SYMBOL(ignore, std::, <tuple>)
SYMBOL(ignore, std::, <utility>)

// Ignore specializations
SYMBOL(hash, std::, <functional>)

// Add headers for generic integer-type abs.
// Ignore other variants (std::complex, std::valarray, std::intmax_t)
SYMBOL(abs, std::, <cstdlib>)
SYMBOL(abs, std::, <cmath>)
SYMBOL(abs, None, <cstdlib>)
SYMBOL(abs, None, <stdlib.h>)
SYMBOL(abs, None, <cmath>)
SYMBOL(abs, None, <math.h>)

// Only add headers for the generic atomic template.
// Ignore variants (std::weak_ptr, std::shared_ptr).
SYMBOL(atomic, std::, <atomic>)
// atomic_* family symbols. <stdatomic.h> is for C compatibility.
SYMBOL(atomic_bool, std::, <atomic>)
SYMBOL(atomic_bool, None, <atomic>)
SYMBOL(atomic_bool, None, <stdatomic.h>)
SYMBOL(atomic_char, std::, <atomic>)
SYMBOL(atomic_char, None, <atomic>)
SYMBOL(atomic_char, None, <stdatomic.h>)
SYMBOL(atomic_char16_t, std::, <atomic>)
SYMBOL(atomic_char16_t, None, <atomic>)
SYMBOL(atomic_char16_t, None, <stdatomic.h>)
SYMBOL(atomic_char32_t, std::, <atomic>)
SYMBOL(atomic_char32_t, None, <atomic>)
SYMBOL(atomic_char32_t, None, <stdatomic.h>)
SYMBOL(atomic_char8_t, std::, <atomic>)
SYMBOL(atomic_char8_t, None, <atomic>)
SYMBOL(atomic_char8_t, None, <stdatomic.h>)
SYMBOL(atomic_int, std::, <atomic>)
SYMBOL(atomic_int, None, <atomic>)
SYMBOL(atomic_int, None, <stdatomic.h>)
SYMBOL(atomic_int16_t, std::, <atomic>)
SYMBOL(atomic_int16_t, None, <atomic>)
SYMBOL(atomic_int16_t, None, <stdatomic.h>)
SYMBOL(atomic_int32_t, std::, <atomic>)
SYMBOL(atomic_int32_t, None, <atomic>)
SYMBOL(atomic_int32_t, None, <stdatomic.h>)
SYMBOL(atomic_int64_t, std::, <atomic>)
SYMBOL(atomic_int64_t, None, <atomic>)
SYMBOL(atomic_int64_t, None, <stdatomic.h>)
SYMBOL(atomic_int8_t, std::, <atomic>)
SYMBOL(atomic_int8_t, None, <atomic>)
SYMBOL(atomic_int8_t, None, <stdatomic.h>)
SYMBOL(atomic_int_fast16_t, std::, <atomic>)
SYMBOL(atomic_int_fast16_t, None, <atomic>)
SYMBOL(atomic_int_fast16_t, None, <stdatomic.h>)
SYMBOL(atomic_int_fast32_t, std::, <atomic>)
SYMBOL(atomic_int_fast32_t, None, <atomic>)
SYMBOL(atomic_int_fast32_t, None, <stdatomic.h>)
SYMBOL(atomic_int_fast64_t, std::, <atomic>)
SYMBOL(atomic_int_fast64_t, None, <atomic>)
SYMBOL(atomic_int_fast64_t, None, <stdatomic.h>)
SYMBOL(atomic_int_fast8_t, std::, <atomic>)
SYMBOL(atomic_int_fast8_t, None, <atomic>)
SYMBOL(atomic_int_fast8_t, None, <stdatomic.h>)
SYMBOL(atomic_int_least16_t, std::, <atomic>)
SYMBOL(atomic_int_least16_t, None, <atomic>)
SYMBOL(atomic_int_least16_t, None, <stdatomic.h>)
SYMBOL(atomic_int_least32_t, std::, <atomic>)
SYMBOL(atomic_int_least32_t, None, <atomic>)
SYMBOL(atomic_int_least32_t, None, <stdatomic.h>)
SYMBOL(atomic_int_least64_t, std::, <atomic>)
SYMBOL(atomic_int_least64_t, None, <atomic>)
SYMBOL(atomic_int_least64_t, None, <stdatomic.h>)
SYMBOL(atomic_int_least8_t, std::, <atomic>)
SYMBOL(atomic_int_least8_t, None, <atomic>)
SYMBOL(atomic_int_least8_t, None, <stdatomic.h>)
SYMBOL(atomic_intmax_t, std::, <atomic>)
SYMBOL(atomic_intmax_t, None, <atomic>)
SYMBOL(atomic_intmax_t, None, <stdatomic.h>)
SYMBOL(atomic_intptr_t, std::, <atomic>)
SYMBOL(atomic_intptr_t, None, <atomic>)
SYMBOL(atomic_intptr_t, None, <stdatomic.h>)
SYMBOL(atomic_llong, std::, <atomic>)
SYMBOL(atomic_llong, None, <atomic>)
SYMBOL(atomic_llong, None, <stdatomic.h>)
SYMBOL(atomic_long, std::, <atomic>)
SYMBOL(atomic_long, None, <atomic>)
SYMBOL(atomic_long, None, <stdatomic.h>)
SYMBOL(atomic_ptrdiff_t, std::, <atomic>)
SYMBOL(atomic_ptrdiff_t, None, <atomic>)
SYMBOL(atomic_ptrdiff_t, None, <stdatomic.h>)
SYMBOL(atomic_schar, std::, <atomic>)
SYMBOL(atomic_schar, None, <atomic>)
SYMBOL(atomic_schar, None, <stdatomic.h>)
SYMBOL(atomic_short, std::, <atomic>)
SYMBOL(atomic_short, None, <atomic>)
SYMBOL(atomic_short, None, <stdatomic.h>)
SYMBOL(atomic_signed_lock_free, std::, <atomic>)
SYMBOL(atomic_signed_lock_free, None, <atomic>)
SYMBOL(atomic_signed_lock_free, None, <stdatomic.h>)
SYMBOL(atomic_size_t, std::, <atomic>)
SYMBOL(atomic_size_t, None, <atomic>)
SYMBOL(atomic_size_t, None, <stdatomic.h>)
SYMBOL(atomic_uchar, std::, <atomic>)
SYMBOL(atomic_uchar, None, <atomic>)
SYMBOL(atomic_uchar, None, <stdatomic.h>)
SYMBOL(atomic_uint, std::, <atomic>)
SYMBOL(atomic_uint, None, <atomic>)
SYMBOL(atomic_uint, None, <stdatomic.h>)
SYMBOL(atomic_uint16_t, std::, <atomic>)
SYMBOL(atomic_uint16_t, None, <atomic>)
SYMBOL(atomic_uint16_t, None, <stdatomic.h>)
SYMBOL(atomic_uint32_t, std::, <atomic>)
SYMBOL(atomic_uint32_t, None, <atomic>)
SYMBOL(atomic_uint32_t, None, <stdatomic.h>)
SYMBOL(atomic_uint64_t, std::, <atomic>)
SYMBOL(atomic_uint64_t, None, <atomic>)
SYMBOL(atomic_uint64_t, None, <stdatomic.h>)
SYMBOL(atomic_uint8_t, std::, <atomic>)
SYMBOL(atomic_uint8_t, None, <atomic>)
SYMBOL(atomic_uint8_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_fast16_t, std::, <atomic>)
SYMBOL(atomic_uint_fast16_t, None, <atomic>)
SYMBOL(atomic_uint_fast16_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_fast32_t, std::, <atomic>)
SYMBOL(atomic_uint_fast32_t, None, <atomic>)
SYMBOL(atomic_uint_fast32_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_fast64_t, std::, <atomic>)
SYMBOL(atomic_uint_fast64_t, None, <atomic>)
SYMBOL(atomic_uint_fast64_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_fast8_t, std::, <atomic>)
SYMBOL(atomic_uint_fast8_t, None, <atomic>)
SYMBOL(atomic_uint_fast8_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_least16_t, std::, <atomic>)
SYMBOL(atomic_uint_least16_t, None, <atomic>)
SYMBOL(atomic_uint_least16_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_least32_t, std::, <atomic>)
SYMBOL(atomic_uint_least32_t, None, <atomic>)
SYMBOL(atomic_uint_least32_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_least64_t, std::, <atomic>)
SYMBOL(atomic_uint_least64_t, None, <atomic>)
SYMBOL(atomic_uint_least64_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_least8_t, std::, <atomic>)
SYMBOL(atomic_uint_least8_t, None, <atomic>)
SYMBOL(atomic_uint_least8_t, None, <stdatomic.h>)
SYMBOL(atomic_uintmax_t, std::, <atomic>)
SYMBOL(atomic_uintmax_t, None, <atomic>)
SYMBOL(atomic_uintmax_t, None, <stdatomic.h>)
SYMBOL(atomic_uintptr_t, std::, <atomic>)
SYMBOL(atomic_uintptr_t, None, <atomic>)
SYMBOL(atomic_uintptr_t, None, <stdatomic.h>)
SYMBOL(atomic_ullong, std::, <atomic>)
SYMBOL(atomic_ullong, None, <atomic>)
SYMBOL(atomic_ullong, None, <stdatomic.h>)
SYMBOL(atomic_ulong, std::, <atomic>)
SYMBOL(atomic_ulong, None, <atomic>)
SYMBOL(atomic_ulong, None, <stdatomic.h>)
SYMBOL(atomic_unsigned_lock_free, std::, <atomic>)
SYMBOL(atomic_unsigned_lock_free, None, <atomic>)
SYMBOL(atomic_unsigned_lock_free, None, <stdatomic.h>)
SYMBOL(atomic_ushort, std::, <atomic>)
SYMBOL(atomic_ushort, None, <atomic>)
SYMBOL(atomic_ushort, None, <stdatomic.h>)
SYMBOL(atomic_wchar_t, std::, <atomic>)
SYMBOL(atomic_wchar_t, None, <atomic>)
SYMBOL(atomic_wchar_t, None, <stdatomic.h>)

// std::get has a few variants for different types (tuple, array, pair etc)
// which is tricky to disambiguate without type information.
// Don't set any header for it, as it comes with the type header.
SYMBOL(get, std::, /*no headers*/)
// Similarly make_error_{code,condition} also have different overloads (errc,
// io_errc, future_errc) and each of them are provided by relevant headers
// providing the type.
SYMBOL(make_error_code, std::, /*no headers*/)
SYMBOL(make_error_condition, std::, /*no headers*/)
// Similar to std::get, has variants for multiple containers
// (vector, deque, list, etc.)
SYMBOL(erase, std::, /*no headers*/)
SYMBOL(erase_if, std::, /*no headers*/)

// Symbols missing from the generated symbol map as reported by users.
// Remove when the generator starts producing them.
SYMBOL(div, std::, <cstdlib>)
SYMBOL(abort, std::, <cstdlib>)

SYMBOL(binary_search, std::ranges::, <algorithm>)
SYMBOL(equal_range, std::ranges::, <algorithm>)
SYMBOL(lower_bound, std::ranges::, <algorithm>)
SYMBOL(upper_bound, std::ranges::, <algorithm>)

SYMBOL(unwrap_reference_t, std::, <type_traits>)

// These are C symbols that are not under std namespace.
SYMBOL(localtime_r, None, <ctime>)
SYMBOL(localtime_r, None, <time.h>)
SYMBOL(localtime_s, None, <ctime>)
SYMBOL(localtime_s, None, <time.h>)
SYMBOL(gmtime_r, None, <ctime>)
SYMBOL(gmtime_r, None, <time.h>)
SYMBOL(gmtime_s, None, <ctime>)
SYMBOL(gmtime_s, None, <time.h>)

// The std::placeholder symbols (_1, ..., _N) are listed in the cppreference
// placeholder.html, but the index only contains a single entry with "_1, _2, ..., _N"
// text, which are not handled by the script.
// N is an implementation-defined number (10 for libc++; 29 for libstdc++).
SYMBOL(_1, std::placeholders::, <functional>)
SYMBOL(_2, std::placeholders::, <functional>)
SYMBOL(_3, std::placeholders::, <functional>)
SYMBOL(_4, std::placeholders::, <functional>)
SYMBOL(_5, std::placeholders::, <functional>)
SYMBOL(_6, std::placeholders::, <functional>)
SYMBOL(_7, std::placeholders::, <functional>)
SYMBOL(_8, std::placeholders::, <functional>)
SYMBOL(_9, std::placeholders::, <functional>)
SYMBOL(_10, std::placeholders::, <functional>)
SYMBOL(_11, std::placeholders::, <functional>)
SYMBOL(_12, std::placeholders::, <functional>)
SYMBOL(_13, std::placeholders::, <functional>)
SYMBOL(_14, std::placeholders::, <functional>)
SYMBOL(_15, std::placeholders::, <functional>)
SYMBOL(_16, std::placeholders::, <functional>)
SYMBOL(_17, std::placeholders::, <functional>)
SYMBOL(_18, std::placeholders::, <functional>)
SYMBOL(_19, std::placeholders::, <functional>)
SYMBOL(_20, std::placeholders::, <functional>)
SYMBOL(_21, std::placeholders::, <functional>)
SYMBOL(_22, std::placeholders::, <functional>)
SYMBOL(_23, std::placeholders::, <functional>)
SYMBOL(_24, std::placeholders::, <functional>)
SYMBOL(_25, std::placeholders::, <functional>)
SYMBOL(_26, std::placeholders::, <functional>)
SYMBOL(_27, std::placeholders::, <functional>)
SYMBOL(_28, std::placeholders::, <functional>)
SYMBOL(_29, std::placeholders::, <functional>)

// Macros
SYMBOL(NULL, None, <cstddef>)
SYMBOL(NULL, None, <stddef.h>)
SYMBOL(NULL, None, <cstdlib>)
SYMBOL(NULL, None, <stdlib.h>)
SYMBOL(NULL, None, <cstring>)
SYMBOL(NULL, None, <string.h>)
SYMBOL(NULL, None, <cwchar>)
SYMBOL(NULL, None, <wchar.h>)
SYMBOL(NULL, None, <ctime>)
SYMBOL(NULL, None, <time.h>)
SYMBOL(NULL, None, <clocale>)
SYMBOL(NULL, None, <locale.h>)
SYMBOL(NULL, None, <cstdio>)
SYMBOL(NULL, None, <stdio.h>)

// Theres are macros that not spelled out in page linked from the index.
// Extracted from https://en.cppreference.com/w/cpp/header/cinttypes
SYMBOL(PRId8, None, <cinttypes>)
SYMBOL(PRId8, None, <inttypes.h>)
SYMBOL(PRId16, None, <cinttypes>)
SYMBOL(PRId16, None, <inttypes.h>)
SYMBOL(PRId32, None, <cinttypes>)
SYMBOL(PRId32, None, <inttypes.h>)
SYMBOL(PRId64, None, <cinttypes>)
SYMBOL(PRId64, None, <inttypes.h>)
SYMBOL(PRIdLEAST8, None, <cinttypes>)
SYMBOL(PRIdLEAST8, None, <inttypes.h>)
SYMBOL(PRIdLEAST16, None, <cinttypes>)
SYMBOL(PRIdLEAST16, None, <inttypes.h>)
SYMBOL(PRIdLEAST32, None, <cinttypes>)
SYMBOL(PRIdLEAST32, None, <inttypes.h>)
SYMBOL(PRIdLEAST64, None, <cinttypes>)
SYMBOL(PRIdLEAST64, None, <inttypes.h>)
SYMBOL(PRIdFAST8, None, <cinttypes>)
SYMBOL(PRIdFAST8, None, <inttypes.h>)
SYMBOL(PRIdFAST16, None, <cinttypes>)
SYMBOL(PRIdFAST16, None, <inttypes.h>)
SYMBOL(PRIdFAST32, None, <cinttypes>)
SYMBOL(PRIdFAST32, None, <inttypes.h>)
SYMBOL(PRIdFAST64, None, <cinttypes>)
SYMBOL(PRIdFAST64, None, <inttypes.h>)
SYMBOL(PRIdMAX, None, <cinttypes>)
SYMBOL(PRIdMAX, None, <inttypes.h>)
SYMBOL(PRIdPTR, None, <cinttypes>)
SYMBOL(PRIdPTR, None, <inttypes.h>)
SYMBOL(PRIi8, None, <cinttypes>)
SYMBOL(PRIi8, None, <inttypes.h>)
SYMBOL(PRIi16, None, <cinttypes>)
SYMBOL(PRIi16, None, <inttypes.h>)
SYMBOL(PRIi32, None, <cinttypes>)
SYMBOL(PRIi32, None, <inttypes.h>)
SYMBOL(PRIi64, None, <cinttypes>)
SYMBOL(PRIi64, None, <inttypes.h>)
SYMBOL(PRIiLEAST8, None, <cinttypes>)
SYMBOL(PRIiLEAST8, None, <inttypes.h>)
SYMBOL(PRIiLEAST16, None, <cinttypes>)
SYMBOL(PRIiLEAST16, None, <inttypes.h>)
SYMBOL(PRIiLEAST32, None, <cinttypes>)
SYMBOL(PRIiLEAST32, None, <inttypes.h>)
SYMBOL(PRIiLEAST64, None, <cinttypes>)
SYMBOL(PRIiLEAST64, None, <inttypes.h>)
SYMBOL(PRIiFAST8, None, <cinttypes>)
SYMBOL(PRIiFAST8, None, <inttypes.h>)
SYMBOL(PRIiFAST16, None, <cinttypes>)
SYMBOL(PRIiFAST16, None, <inttypes.h>)
SYMBOL(PRIiFAST32, None, <cinttypes>)
SYMBOL(PRIiFAST32, None, <inttypes.h>)
SYMBOL(PRIiFAST64, None, <cinttypes>)
SYMBOL(PRIiFAST64, None, <inttypes.h>)
SYMBOL(PRIiMAX, None, <cinttypes>)
SYMBOL(PRIiMAX, None, <inttypes.h>)
SYMBOL(PRIiPTR, None, <cinttypes>)
SYMBOL(PRIiPTR, None, <inttypes.h>)
SYMBOL(PRIu8, None, <cinttypes>)
SYMBOL(PRIu8, None, <inttypes.h>)
SYMBOL(PRIu16, None, <cinttypes>)
SYMBOL(PRIu16, None, <inttypes.h>)
SYMBOL(PRIu32, None, <cinttypes>)
SYMBOL(PRIu32, None, <inttypes.h>)
SYMBOL(PRIu64, None, <cinttypes>)
SYMBOL(PRIu64, None, <inttypes.h>)
SYMBOL(PRIuLEAST8, None, <cinttypes>)
SYMBOL(PRIuLEAST8, None, <inttypes.h>)
SYMBOL(PRIuLEAST16, None, <cinttypes>)
SYMBOL(PRIuLEAST16, None, <inttypes.h>)
SYMBOL(PRIuLEAST32, None, <cinttypes>)
SYMBOL(PRIuLEAST32, None, <inttypes.h>)
SYMBOL(PRIuLEAST64, None, <cinttypes>)
SYMBOL(PRIuLEAST64, None, <inttypes.h>)
SYMBOL(PRIuFAST8, None, <cinttypes>)
SYMBOL(PRIuFAST8, None, <inttypes.h>)
SYMBOL(PRIuFAST16, None, <cinttypes>)
SYMBOL(PRIuFAST16, None, <inttypes.h>)
SYMBOL(PRIuFAST32, None, <cinttypes>)
SYMBOL(PRIuFAST32, None, <inttypes.h>)
SYMBOL(PRIuFAST64, None, <cinttypes>)
SYMBOL(PRIuFAST64, None, <inttypes.h>)
SYMBOL(PRIuMAX, None, <cinttypes>)
SYMBOL(PRIuMAX, None, <inttypes.h>)
SYMBOL(PRIuPTR, None, <cinttypes>)
SYMBOL(PRIuPTR, None, <inttypes.h>)
SYMBOL(PRIo8, None, <cinttypes>)
SYMBOL(PRIo8, None, <inttypes.h>)
SYMBOL(PRIo16, None, <cinttypes>)
SYMBOL(PRIo16, None, <inttypes.h>)
SYMBOL(PRIo32, None, <cinttypes>)
SYMBOL(PRIo32, None, <inttypes.h>)
SYMBOL(PRIo64, None, <cinttypes>)
SYMBOL(PRIo64, None, <inttypes.h>)
SYMBOL(PRIoLEAST8, None, <cinttypes>)
SYMBOL(PRIoLEAST8, None, <inttypes.h>)
SYMBOL(PRIoLEAST16, None, <cinttypes>)
SYMBOL(PRIoLEAST16, None, <inttypes.h>)
SYMBOL(PRIoLEAST32, None, <cinttypes>)
SYMBOL(PRIoLEAST32, None, <inttypes.h>)
SYMBOL(PRIoLEAST64, None, <cinttypes>)
SYMBOL(PRIoLEAST64, None, <inttypes.h>)
SYMBOL(PRIoFAST8, None, <cinttypes>)
SYMBOL(PRIoFAST8, None, <inttypes.h>)
SYMBOL(PRIoFAST16, None, <cinttypes>)
SYMBOL(PRIoFAST16, None, <inttypes.h>)
SYMBOL(PRIoFAST32, None, <cinttypes>)
SYMBOL(PRIoFAST32, None, <inttypes.h>)
SYMBOL(PRIoFAST64, None, <cinttypes>)
SYMBOL(PRIoFAST64, None, <inttypes.h>)
SYMBOL(PRIoMAX, None, <cinttypes>)
SYMBOL(PRIoMAX, None, <inttypes.h>)
SYMBOL(PRIoPTR, None, <cinttypes>)
SYMBOL(PRIoPTR, None, <inttypes.h>)
SYMBOL(PRIx8, None, <cinttypes>)
SYMBOL(PRIx8, None, <inttypes.h>)
SYMBOL(PRIx16, None, <cinttypes>)
SYMBOL(PRIx16, None, <inttypes.h>)
SYMBOL(PRIx32, None, <cinttypes>)
SYMBOL(PRIx32, None, <inttypes.h>)
SYMBOL(PRIx64, None, <cinttypes>)
SYMBOL(PRIx64, None, <inttypes.h>)
SYMBOL(PRIxLEAST8, None, <cinttypes>)
SYMBOL(PRIxLEAST8, None, <inttypes.h>)
SYMBOL(PRIxLEAST16, None, <cinttypes>)
SYMBOL(PRIxLEAST16, None, <inttypes.h>)
SYMBOL(PRIxLEAST32, None, <cinttypes>)
SYMBOL(PRIxLEAST32, None, <inttypes.h>)
SYMBOL(PRIxLEAST64, None, <cinttypes>)
SYMBOL(PRIxLEAST64, None, <inttypes.h>)
SYMBOL(PRIxFAST8, None, <cinttypes>)
SYMBOL(PRIxFAST8, None, <inttypes.h>)
SYMBOL(PRIxFAST16, None, <cinttypes>)
SYMBOL(PRIxFAST16, None, <inttypes.h>)
SYMBOL(PRIxFAST32, None, <cinttypes>)
SYMBOL(PRIxFAST32, None, <inttypes.h>)
SYMBOL(PRIxFAST64, None, <cinttypes>)
SYMBOL(PRIxFAST64, None, <inttypes.h>)
SYMBOL(PRIxMAX, None, <cinttypes>)
SYMBOL(PRIxMAX, None, <inttypes.h>)
SYMBOL(PRIxPTR, None, <cinttypes>)
SYMBOL(PRIxPTR, None, <inttypes.h>)
SYMBOL(PRIX8, None, <cinttypes>)
SYMBOL(PRIX8, None, <inttypes.h>)
SYMBOL(PRIX16, None, <cinttypes>)
SYMBOL(PRIX16, None, <inttypes.h>)
SYMBOL(PRIX32, None, <cinttypes>)
SYMBOL(PRIX32, None, <inttypes.h>)
SYMBOL(PRIX64, None, <cinttypes>)
SYMBOL(PRIX64, None, <inttypes.h>)
SYMBOL(PRIXLEAST8, None, <cinttypes>)
SYMBOL(PRIXLEAST8, None, <inttypes.h>)
SYMBOL(PRIXLEAST16, None, <cinttypes>)
SYMBOL(PRIXLEAST16, None, <inttypes.h>)
SYMBOL(PRIXLEAST32, None, <cinttypes>)
SYMBOL(PRIXLEAST32, None, <inttypes.h>)
SYMBOL(PRIXLEAST64, None, <cinttypes>)
SYMBOL(PRIXLEAST64, None, <inttypes.h>)
SYMBOL(PRIXFAST8, None, <cinttypes>)
SYMBOL(PRIXFAST8, None, <inttypes.h>)
SYMBOL(PRIXFAST16, None, <cinttypes>)
SYMBOL(PRIXFAST16, None, <inttypes.h>)
SYMBOL(PRIXFAST32, None, <cinttypes>)
SYMBOL(PRIXFAST32, None, <inttypes.h>)
SYMBOL(PRIXFAST64, None, <cinttypes>)
SYMBOL(PRIXFAST64, None, <inttypes.h>)
SYMBOL(PRIXMAX, None, <cinttypes>)
SYMBOL(PRIXMAX, None, <inttypes.h>)
SYMBOL(PRIXPTR, None, <cinttypes>)
SYMBOL(PRIXPTR, None, <inttypes.h>)
SYMBOL(SCNd8, None, <cinttypes>)
SYMBOL(SCNd8, None, <inttypes.h>)
SYMBOL(SCNd16, None, <cinttypes>)
SYMBOL(SCNd16, None, <inttypes.h>)
SYMBOL(SCNd32, None, <cinttypes>)
SYMBOL(SCNd32, None, <inttypes.h>)
SYMBOL(SCNd64, None, <cinttypes>)
SYMBOL(SCNd64, None, <inttypes.h>)
SYMBOL(SCNdLEAST8, None, <cinttypes>)
SYMBOL(SCNdLEAST8, None, <inttypes.h>)
SYMBOL(SCNdLEAST16, None, <cinttypes>)
SYMBOL(SCNdLEAST16, None, <inttypes.h>)
SYMBOL(SCNdLEAST32, None, <cinttypes>)
SYMBOL(SCNdLEAST32, None, <inttypes.h>)
SYMBOL(SCNdLEAST64, None, <cinttypes>)
SYMBOL(SCNdLEAST64, None, <inttypes.h>)
SYMBOL(SCNdFAST8, None, <cinttypes>)
SYMBOL(SCNdFAST8, None, <inttypes.h>)
SYMBOL(SCNdFAST16, None, <cinttypes>)
SYMBOL(SCNdFAST16, None, <inttypes.h>)
SYMBOL(SCNdFAST32, None, <cinttypes>)
SYMBOL(SCNdFAST32, None, <inttypes.h>)
SYMBOL(SCNdFAST64, None, <cinttypes>)
SYMBOL(SCNdFAST64, None, <inttypes.h>)
SYMBOL(SCNdMAX, None, <cinttypes>)
SYMBOL(SCNdMAX, None, <inttypes.h>)
SYMBOL(SCNdPTR, None, <cinttypes>)
SYMBOL(SCNdPTR, None, <inttypes.h>)
SYMBOL(SCNi8, None, <cinttypes>)
SYMBOL(SCNi8, None, <inttypes.h>)
SYMBOL(SCNi16, None, <cinttypes>)
SYMBOL(SCNi16, None, <inttypes.h>)
SYMBOL(SCNi32, None, <cinttypes>)
SYMBOL(SCNi32, None, <inttypes.h>)
SYMBOL(SCNi64, None, <cinttypes>)
SYMBOL(SCNi64, None, <inttypes.h>)
SYMBOL(SCNiLEAST8, None, <cinttypes>)
SYMBOL(SCNiLEAST8, None, <inttypes.h>)
SYMBOL(SCNiLEAST16, None, <cinttypes>)
SYMBOL(SCNiLEAST16, None, <inttypes.h>)
SYMBOL(SCNiLEAST32, None, <cinttypes>)
SYMBOL(SCNiLEAST32, None, <inttypes.h>)
SYMBOL(SCNiLEAST64, None, <cinttypes>)
SYMBOL(SCNiLEAST64, None, <inttypes.h>)
SYMBOL(SCNiFAST8, None, <cinttypes>)
SYMBOL(SCNiFAST8, None, <inttypes.h>)
SYMBOL(SCNiFAST16, None, <cinttypes>)
SYMBOL(SCNiFAST16, None, <inttypes.h>)
SYMBOL(SCNiFAST32, None, <cinttypes>)
SYMBOL(SCNiFAST32, None, <inttypes.h>)
SYMBOL(SCNiFAST64, None, <cinttypes>)
SYMBOL(SCNiFAST64, None, <inttypes.h>)
SYMBOL(SCNiMAX, None, <cinttypes>)
SYMBOL(SCNiMAX, None, <inttypes.h>)
SYMBOL(SCNiPTR, None, <cinttypes>)
SYMBOL(SCNiPTR, None, <inttypes.h>)
SYMBOL(SCNu8, None, <cinttypes>)
SYMBOL(SCNu8, None, <inttypes.h>)
SYMBOL(SCNu16, None, <cinttypes>)
SYMBOL(SCNu16, None, <inttypes.h>)
SYMBOL(SCNu32, None, <cinttypes>)
SYMBOL(SCNu32, None, <inttypes.h>)
SYMBOL(SCNu64, None, <cinttypes>)
SYMBOL(SCNu64, None, <inttypes.h>)
SYMBOL(SCNuLEAST8, None, <cinttypes>)
SYMBOL(SCNuLEAST8, None, <inttypes.h>)
SYMBOL(SCNuLEAST16, None, <cinttypes>)
SYMBOL(SCNuLEAST16, None, <inttypes.h>)
SYMBOL(SCNuLEAST32, None, <cinttypes>)
SYMBOL(SCNuLEAST32, None, <inttypes.h>)
SYMBOL(SCNuLEAST64, None, <cinttypes>)
SYMBOL(SCNuLEAST64, None, <inttypes.h>)
SYMBOL(SCNuFAST8, None, <cinttypes>)
SYMBOL(SCNuFAST8, None, <inttypes.h>)
SYMBOL(SCNuFAST16, None, <cinttypes>)
SYMBOL(SCNuFAST16, None, <inttypes.h>)
SYMBOL(SCNuFAST32, None, <cinttypes>)
SYMBOL(SCNuFAST32, None, <inttypes.h>)
SYMBOL(SCNuFAST64, None, <cinttypes>)
SYMBOL(SCNuFAST64, None, <inttypes.h>)
SYMBOL(SCNuMAX, None, <cinttypes>)
SYMBOL(SCNuMAX, None, <inttypes.h>)
SYMBOL(SCNuPTR, None, <cinttypes>)
SYMBOL(SCNuPTR, None, <inttypes.h>)
SYMBOL(SCNo8, None, <cinttypes>)
SYMBOL(SCNo8, None, <inttypes.h>)
SYMBOL(SCNo16, None, <cinttypes>)
SYMBOL(SCNo16, None, <inttypes.h>)
SYMBOL(SCNo32, None, <cinttypes>)
SYMBOL(SCNo32, None, <inttypes.h>)
SYMBOL(SCNo64, None, <cinttypes>)
SYMBOL(SCNo64, None, <inttypes.h>)
SYMBOL(SCNoLEAST8, None, <cinttypes>)
SYMBOL(SCNoLEAST8, None, <inttypes.h>)
SYMBOL(SCNoLEAST16, None, <cinttypes>)
SYMBOL(SCNoLEAST16, None, <inttypes.h>)
SYMBOL(SCNoLEAST32, None, <cinttypes>)
SYMBOL(SCNoLEAST32, None, <inttypes.h>)
SYMBOL(SCNoLEAST64, None, <cinttypes>)
SYMBOL(SCNoLEAST64, None, <inttypes.h>)
SYMBOL(SCNoFAST8, None, <cinttypes>)
SYMBOL(SCNoFAST8, None, <inttypes.h>)
SYMBOL(SCNoFAST16, None, <cinttypes>)
SYMBOL(SCNoFAST16, None, <inttypes.h>)
SYMBOL(SCNoFAST32, None, <cinttypes>)
SYMBOL(SCNoFAST32, None, <inttypes.h>)
SYMBOL(SCNoFAST64, None, <cinttypes>)
SYMBOL(SCNoFAST64, None, <inttypes.h>)
SYMBOL(SCNoMAX, None, <cinttypes>)
SYMBOL(SCNoMAX, None, <inttypes.h>)
SYMBOL(SCNoPTR, None, <cinttypes>)
SYMBOL(SCNoPTR, None, <inttypes.h>)
SYMBOL(SCNx8, None, <cinttypes>)
SYMBOL(SCNx8, None, <inttypes.h>)
SYMBOL(SCNx16, None, <cinttypes>)
SYMBOL(SCNx16, None, <inttypes.h>)
SYMBOL(SCNx32, None, <cinttypes>)
SYMBOL(SCNx32, None, <inttypes.h>)
SYMBOL(SCNx64, None, <cinttypes>)
SYMBOL(SCNx64, None, <inttypes.h>)
SYMBOL(SCNxLEAST8, None, <cinttypes>)
SYMBOL(SCNxLEAST8, None, <inttypes.h>)
SYMBOL(SCNxLEAST16, None, <cinttypes>)
SYMBOL(SCNxLEAST16, None, <inttypes.h>)
SYMBOL(SCNxLEAST32, None, <cinttypes>)
SYMBOL(SCNxLEAST32, None, <inttypes.h>)
SYMBOL(SCNxLEAST64, None, <cinttypes>)
SYMBOL(SCNxLEAST64, None, <inttypes.h>)
SYMBOL(SCNxFAST8, None, <cinttypes>)
SYMBOL(SCNxFAST8, None, <inttypes.h>)
SYMBOL(SCNxFAST16, None, <cinttypes>)
SYMBOL(SCNxFAST16, None, <inttypes.h>)
SYMBOL(SCNxFAST32, None, <cinttypes>)
SYMBOL(SCNxFAST32, None, <inttypes.h>)
SYMBOL(SCNxFAST64, None, <cinttypes>)
SYMBOL(SCNxFAST64, None, <inttypes.h>)
SYMBOL(SCNxMAX, None, <cinttypes>)
SYMBOL(SCNxMAX, None, <inttypes.h>)
SYMBOL(SCNxPTR, None, <cinttypes>)
SYMBOL(SCNxPTR, None, <inttypes.h>)

// These macros trigger ambiguity when parsing cppreference index.
// Taken from https://en.cppreference.com/w/cpp/types/integer.
SYMBOL(INT8_C, None, <cstdint>)
SYMBOL(INT8_C, None, <stdint.h>)
SYMBOL(INT16_C, None, <cstdint>)
SYMBOL(INT16_C, None, <stdint.h>)
SYMBOL(INT32_C, None, <cstdint>)
SYMBOL(INT32_C, None, <stdint.h>)
SYMBOL(INT64_C, None, <cstdint>)
SYMBOL(INT64_C, None, <stdint.h>)
SYMBOL(INTMAX_C, None, <cstdint>)
SYMBOL(INTMAX_C, None, <stdint.h>)

SYMBOL(UINT8_C, None, <cstdint>)
SYMBOL(UINT8_C, None, <stdint.h>)
SYMBOL(UINT16_C, None, <cstdint>)
SYMBOL(UINT16_C, None, <stdint.h>)
SYMBOL(UINT32_C, None, <cstdint>)
SYMBOL(UINT32_C, None, <stdint.h>)
SYMBOL(UINT64_C, None, <cstdint>)
SYMBOL(UINT64_C, None, <stdint.h>)
SYMBOL(UINTMAX_C, None, <cstdint>)
SYMBOL(UINTMAX_C, None, <stdint.h>)
