/* Header for module SYSDEVS, generated by p2c */
#ifndef SYSDEVS_H
#define SYSDEVS_H



#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif



#ifdef SYSDEVS_G
# define vextern
#else
# define vextern extern
#endif



/** DUMMY DECLARATIONS ***********************************/
/** CRT **************************************************/
/****** THIS SECTION HAS HARD OFFSET REFERENCES **********/
/*      IN MODULES CRTB (ASSY FILE GASSM)                */



/* 3/25/85 */
/* 3/25/85 */
/*built in crt*/
/* CRT CONTROL CHARS */
/* CRT INFO & INPUT CHARS */

typedef union CRTWORD {
    struct {
	Char HIGHLIGHTBYTE, CHARACTER;
    } U1;
    short WHOLEWORD;
} CRTWORD;

typedef enum {
    CLLPUT, CLLSHIFTL, CLLSHIFTR, CLLCLEAR, CLLDISPLAY, PUTSTATUS
} CRTLLOPS;

typedef enum {
    DBINFO, DBEXCG, DBGOTOXY, DBPUT, DBINIT, DBCLEAR, DBCLINE, DBSCROLLUP,
    DBSCROLLDN, DBSCROLLL, DBSCROLLR, DBHIGHL
} DBCRTOPS;

typedef struct DBCINFO {
    Char *SAVEAREA;
    long SAVESIZE, DCURSORADDR;
    short XMIN, XMAX, YMIN, YMAX, CURSX, CURSY;
    Char C;
    boolean AREAISDBCRT, CHARISMAPPED;
    short DEBUGHIGHLIGHT;
} DBCINFO;

typedef uchar crtconsttype[12];

typedef struct crtfrec {
    unsigned nobreak : 1, stupid : 1, slowterm : 1, hasxycrt : 1,
	     haslccrt : 1, hasclock : 1, canupscroll : 1, candownscroll : 1;
} crtfrec;

typedef unsigned short b9;

typedef unsigned short b14;

typedef struct crtcrec {
    Char rlf, ndfs, eraseeol, eraseeos, home, escape, backspace;
    uchar fillcount;
    Char clearscreen, clearline;
    unsigned short prefixed;
} crtcrec;

typedef struct crtirec {
    short width, height;
    long crtmemaddr, crtcontroladdr, keybufferaddr, progstateinfoaddr;
    short keybuffersize;
    crtconsttype crtcon;
    Char right, left, down, up, badch, chardel, stop, break_, flush, eof,
	 altmode, linedel, backspace, etx, prefix;
    unsigned short prefixed;
    long cursormask, spare;
} crtirec;

typedef struct environ {
    crtfrec miscinfo;
    long crttype;
    crtcrec crtctrl;
    crtirec crtinfo;
} environ;

typedef enum {
    NOCRT, ALPHATYPE, BITMAPTYPE, SPECIALCRT1, SPECIALCRT2
} crtkinds;



/* CURSOR X POSITION */
/* CURSOR Y POSITION */
/* ACTIVE ALPHA DRIVER TYPE */
/* ADDRESS OF BITMAP CONTROL SPACE */
/* ADDRESS OF BITMAP FRAME BUFFER */
/* REGISTER COPIES FOR BITMAP DISPLAY */
/* MUST BE IN GLOBALS BECAUSE REGISTERS */
/* ARE NOT READABLE -- MAY BE UNDEFINED */
/** KEYBOARD ********************************************/
#define KBD_ENABLE      0
#define KBD_DISABLE     1
#define SET_AUTO_DELAY  2
#define SET_AUTO_REPEAT 3
#define GET_AUTO_DELAY  4
#define GET_AUTO_REPEAT 5
#define SET_KBDTYPE     6
#define SET_KBDLANG     7



/*ADDED FOR 3.1--SFB-5/22/85*/

typedef enum {
    NOKBD, LARGEKBD, SMALLKBD, ITFKBD, SPECIALKBD1, SPECIALKBD2
} KEYBOARDTYPE;

typedef enum {
    NO_KBD, FINISH_KBD, BELGIAN_KBD, CDN_ENG_KBD, CDN_FR_KBD, NORWEGIAN_KBD,
    DANISH_KBD, DUTCH_KBD, SWISS_GR_KBD, SWISS_FR_KBD, SPANISH_EUR_KBD,
    SPANISH_LATIN_KBD, UK_KBD, ITALIAN_KBD, FRENCH_KBD, GERMAN_KBD,
    SWEDISH_KBD, SPANISH_KBD, KATAKANA_KBD, US_KBD, ROMAN8_KBD, NS1_KBD,
    NS2_KBD, NS3_KBD, SWISS_GR_B_KBD, SWISS_FR_B_KBD
} LANGTYPE;

typedef enum {
    M_NONE, M_SYSNORM, M_SYSSHIFT, M_U1, M_U2, M_U3, M_U4
} MENUTYPE;



/* KEYBOARD CONFIGURATION JUMPER */
/** ENABLE / DISABLE *************************************/
#define KBDMASK         1
#define RESETMASK       2
#define TIMERMASK       4
#define PSIMASK         8
#define FHIMASK         16



/* ENABLE, DISABLE */
/** BEEPER ***********************************************/
/** RPG **************************************************/
#define RPG_ENABLE      0
#define RPG_DISABLE     1
#define SET_RPG_RATE    2
#define GET_RPG_RATE    3



/** BATTERY **********************************************/



/** CLOCK ************************************************/
/*CUPDATE ADDED FOR BOBCAT 4/11/85 SFB*/

typedef struct RTCTIME {
    long PACKEDTIME, PACKEDDATE;
} RTCTIME;

typedef enum {
    CGETDATE, CGETTIME, CSETDATE, CSETTIME
} CLOCKFUNC;

typedef enum {
    CGET, CSET, CUPDATE
} CLOCKOP;

typedef union CLOCKDATA {
    timerec TIMETYPE;
    daterec DATETYPE;
} CLOCKDATA;



/* CLOCK MODULE INTERFACE */
/* CARD DRIVER INTERFACE */
/** TIMER ************************************************/

typedef enum {
    CYCLICT, PERIODICT, DELAYT, DELAY7T, MATCHT
} TIMERTYPES;

typedef enum {
    SETT, READT, GETTINFO
} TIMEROPTYPE;

typedef union TIMERDATA {
    long COUNT;
    timerec MATCH;
    struct {
	long RESOLUTION, RANGE;
    } U2;
} TIMERDATA;



/** KEYBUFFER ********************************************/
#define KMAXBUFSIZE     255



typedef enum {
    KGETCHAR, KAPPEND, KNONADVANCE, KCLEAR, KDISPLAY, KGETLAST, KPUTFIRST
} KOPTYPE;

typedef Char KBUFTYPE[KMAXBUFSIZE + 1];

typedef struct KBUFREC {
    boolean ECHO;
    Char NON_CHAR;
    long MAXSIZE, SIZE, INP, OUTP;
    Char *BUFFER;
} KBUFREC;



/*0  s or f = STEP/FLASH IN PROGRESS (WAITING FOR TRAP #0)*/
/*1..5  last executed/current line number */
/*6  S=SYSTEM  U=USER  DEFINITION FOR ITF SOFT KEYS*/
/*   BLANK FOR NON ITF KEYBOARDS */
/*7  RUNLIGHT */
/** KEY TRANSLATION SERVICES *********************************/
/* ADDED NONA_ALPHA_KEY 5/9/84 RQ/SFB */

typedef enum {
    KPASSTHRU, KSHIFT_EXTC, KPASS_EXTC
} KEYTRANSTYPE;

typedef enum {
    ALPHA_KEY, NONADV_KEY, SPECIAL_KEY, IGNORED_KEY, NONA_ALPHA_KEY
} KEYTYPE;

typedef struct LANGCOMREC {
    uchar STATUS, DATA;
    Char KEY;
    KEYTYPE RESULT;
    boolean SHIFT, CONTROL, EXTENSION;
} LANGCOMREC;

typedef struct LANGKEYREC {
    boolean NO_CAPSLOCK, NO_SHIFT, NO_CONTROL, NO_EXTENSION;
    KEYTYPE KEYCLASS;
    Char KEYS[2];
} LANGKEYREC;

typedef struct LANGRECORD {
    boolean CAN_NONADV;
    LANGTYPE LANGCODE;
    _PROCEDURE SEMANTICS;
    LANGKEYREC KEYTABLE[128];
} LANGRECORD;



/** HPHIL ************************************************/
/*MOVED INTO SYSDEVS 4/6/84 SFB*/
#define le_configured   0x80
#define le_error        0x81
#define le_timeout      0x82
#define le_loopdown     0x84
#define lmaxdevices     7



/*UNINIT ADDED 4/8/85 SFB*/
/*HPHILOP DEFINED AS NEW TYPE 4/6/84 SFB*/
/*5 PROCEDURES HOOKED AS TYPE HPHILCMDPROC 4/6/84 SFB*/
/* DEVICE DESCRIBE RECORD */
/* reserved : 0..3;        {DELETED 3/25/85 SFB*/
/*3/27/85 SFB*/
/*3/26/85 SFB*/
/*ADDED 3/15/85 SFB*/
/*ADDED 3/15/85 SFB*/
/*REDEFINED AS RECORD - 4/6/84 SFB*/
/* last loop command sent */
/* data bye in / out */
/* error occured on last operation */
/* now doing reconfigure */
/* last sent command is done */
/* loop is configured */
/* reading poll data */
/* 3.0 BUG #39 3/17/84 */

typedef enum {
    datastarting, dataended, resetdevice, uninitdevice
} loopdvrop;

typedef enum {
    RAWSHIFTOP, NORMSHIFTOP, CHECKLOOPOP, CONFIGUREOP, LCOMMANDOP
} HPHILOP;

typedef union descriprec {
    struct {
	uchar id;
	unsigned twosets : 1, abscoords : 1, size16 : 1, hasprompts : 1,
		 ext_desc : 1, security : 1, numaxes : 2;
	Signed int counts : 16, maxcountx : 16, maxcounty : 16,
		   maxcountz : 16;
	unsigned promptack : 1, nprompts : 3, proximity : 1, nbuttons : 3;
    } U1;
    Char darray[11];
} descriprec;

typedef struct devicerec {
    long devstate;
    descriprec descrip;
    _PROCEDURE opsproc;
    _PROCEDURE dataproc;
} devicerec;

typedef struct loopdriverrec {
    uchar lowid, highid, daddr;
    _PROCEDURE opsproc;
    _PROCEDURE dataproc;
    struct loopdriverrec *next;
} loopdriverrec;

typedef struct LOOPCONTROLREC {
    boolean rawmode;
    devicerec loopdevices[lmaxdevices];
    char loopdevice;
    uchar loopcmd, loopdata;
    boolean looperror, loopinconfig, loopcmddone, loopisok, loopdevreading;
} LOOPCONTROLREC;



/*NEW TO END OF HPHIL_COMM_REC TYPE 3/26/85 SFB*/
/*DRIVER TYPES*/
#define NODRIVER        0
#define ABSLOCATOR      1

/*range 1..15 reserved for DGL*/
/*CODETYPES FROM POLLBLOCK (OR OTHER HPHIL OPCODE)*/
#define NOCODES         0
#define ASCIICODES      1
#define SET1CODES       2
#define SET2CODES       3



/*3/25/85 SFB*/
/*3/25/85 SFB*/
/*stop updating data after button press/event*/
/*capture data in ISR*/
/*dvr_comm_rec busy, delay update from ISR*/
/*bit/loopaddress that driver should service */
/*                                    put 0 where driver should NOT service device */
/*                                    with this dvr_comm_rec !*/
/*call update to flush delayed poll data update*/
/*next comm record*/
/*for extensibility use as pointer/datarec*/
/*HPHIL intrinsic data types from poll/command*/
/*describes content of codes*/
/*extensible for variant*/

typedef union HPHIL_COMM_REC_TYPE {
    struct {
	short dvr_type;
	char dev_addr;
	boolean latch, active, reading;
	uchar devices;
	_PROCEDURE update;
	union HPHIL_COMM_REC_TYPE *link;
	long extend;
	short xloc, yloc, zloc, codetype, ncodes;
	Char codes[16];
    } U1;
    Char barray[54];
} HPHIL_COMM_REC_TYPE;



vextern environ *SYSCOM;
vextern boolean ALPHASTATE, GRAPHICSTATE;
vextern _PROCEDURE CRTIOHOOK;
vextern _PROCEDURE TOGGLEALPHAHOOK;
vextern _PROCEDURE TOGGLEGRAPHICSHOOK;
vextern _PROCEDURE DUMPALPHAHOOK;
vextern _PROCEDURE DUMPGRAPHICSHOOK;
vextern _PROCEDURE UPDATECURSORHOOK;
vextern _PROCEDURE CRTINITHOOK;
vextern _PROCEDURE CRTLLHOOK;
vextern _PROCEDURE DBCRTHOOK;
vextern short XPOS, YPOS;
vextern crtkinds CURRENTCRT;
vextern long BITMAPADDR, FRAMEADDR;
vextern short REPLREGCOPY, WINDOWREGCOPY, WRITEREGCOPY;
vextern _PROCEDURE KBDREQHOOK;
vextern _PROCEDURE KBDIOHOOK;
vextern _PROCEDURE KBDISRHOOK;
vextern _PROCEDURE KBDPOLLHOOK;
vextern KEYBOARDTYPE KBDTYPE;
vextern uchar KBDCONFIG;
vextern LANGTYPE KBDLANG;
vextern Char *SYSMENU, *SYSMENUSHIFT;
vextern MENUTYPE MENUSTATE;
vextern _PROCEDURE MASKOPSHOOK, BEEPERHOOK;
vextern uchar BFREQUENCY, BDURATION;
vextern _PROCEDURE RPGREQHOOK;
vextern _PROCEDURE RPGISRHOOK;
vextern boolean BATTERYPRESENT;
vextern _PROCEDURE BATCMDHOOK;
vextern _PROCEDURE BATREADHOOK;
vextern _PROCEDURE CLOCKREQHOOK;
vextern _PROCEDURE CLOCKIOHOOK;
vextern _PROCEDURE TIMERIOHOOK;
vextern _PROCEDURE TIMERISRHOOK;
vextern KBUFREC *KEYBUFFER;
vextern _PROCEDURE KBDWAITHOOK;
vextern _PROCEDURE KBDRELEASEHOOK;
vextern Char STATUSLINE[8];
vextern LANGCOMREC LANGCOM;
vextern LANGRECORD *LANGTABLE[2];
vextern char LANGINDEX;
vextern _PROCEDURE KBDTRANSHOOK;
vextern KEYTRANSTYPE TRANSMODE;
vextern boolean KBDSYSMODE, KBDALTLOCK, KBDCAPSLOCK;
vextern loopdriverrec *loopdriverlist;
vextern LOOPCONTROLREC *LOOPCONTROL;
vextern _PROCEDURE HPHILCMDHOOK;
vextern HPHIL_COMM_REC_TYPE *HPHIL_DATA_LINK;



/*4/6/84 SFB*/
/*4/6/84 SFB*/
/*3/13/85 SFB*/
/*-----------------------------------------------------------------------------*/
extern Void SYSDEV_INIT PV( );

/** BEEPER ***********************************************/
extern Void BEEP PV( );
extern Void BEEPER PP((int FREQUENCY, int DURATION));

/** RPG **************************************************/
extern Void SETRPGRATE PP((int RATE));

/** KEYBOARD *********************************************/
extern Void KBDSETUP PP((int CMD, int VALUE));
extern Void KBDIO PP((fib *FP, int REQUEST, Char *BUFFER, long BUFSIZE,
		      long POSITION));
extern Void lockedaction PP((_PROCEDURE a));

/** CRT **************************************************/
extern Void CRTIO PP((fib *FP, int REQUEST, Char *BUFFER, long BUFSIZE,
		      long POSITION));
extern Void DUMMYCRTLL PP((int OP, long *POSITION, int C));

/** BATTERY **********************************************/
extern Void BATCOMMAND PP((int CMD, long NUMDATA, int B1, int B2, int B3,
			   int B4, int B5));
extern uchar BATBYTERECEIVED PV( );

/** CLOCK ************************************************/
extern long sysclock PV( );

/*centiseconds from midnight*/
extern Void sysdate PP((daterec *thedate));
extern Void systime PP((timerec *thetime));
extern Void setsysdate PP((daterec thedate));
extern Void setsystime PP((timerec thetime));

/** KEYBUFFER ********************************************/
extern Void KEYBUFOPS PP((int OP, Char *C));

/** STATUSLINE *******************************************/
extern Void SETSTATUS PP((long N, int C));
extern Char RUNLIGHT PV( );
extern Void SETRUNLIGHT PP((int C));



#undef vextern

#endif /*SYSDEVS_H*/

/* End. */

