/* @(#)find.h	1.11 06/10/07 Copyright 2006 J. Schilling */
/*
 *
 */
/*
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * See the file CDDL.Schily.txt in this distribution for details.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file CDDL.Schily.txt from this distribution.
 */

#ifndef	_FIND_H
#define	_FIND_H

#ifndef _SCHILY_MCONFIG_H
#include <schily/mconfig.h>
#endif
#ifndef _SCHILY_STANDARD_H
#include <schily/standard.h>
#endif
#ifndef _SCHILY_STAT_H
#include <schily/stat.h>
#endif

typedef struct find_args {
	int	Argc;
	char	**Argv;
	int	primtype;
	BOOL	found_action;
	int	patlen;
	int	walkflags;
	int	maxdepth;
	int	mindepth;
	struct plusargs *plusp;
} finda_t;

/*
 * finda_t->primtype is set to ENDARGS by find_parse() if a complete expression
 * could be parsed.
 */
#define	ENDARGS	1000	/* Found End of Arg Vector */

/*
 * Flags used for struct WALK->pflags:
 */
#define	PF_ACL		0x00001	/* Check ACL from struct WALK->pflags	*/
#define	PF_HAS_ACL	0x10000	/* This file has ACL			*/
#define	PF_XATTR	0x00002	/* Check XATTR from struct WALK->pflags	*/
#define	PF_HAS_XATTR	0x20000	/* This file has XATTR			*/


extern	void	find_argsinit	__PR((finda_t *fap));
extern	void	find_timeinit	__PR((time_t __now));
extern	void	*find_printnode	__PR((void));
extern	void	*find_addprint	__PR((void *np));
extern	int	find_token	__PR((char *word));
extern	char	*find_tname	__PR((int op));
#ifdef	FIND_NODE
extern	node	*find_parse	__PR((finda_t *fap));
#else
extern	void	*find_parse	__PR((finda_t *fap));
#endif
extern	void	find_firstprim	__PR((int *pac, char *const **pav));

#ifdef	FIND_NODE
/*extern	BOOL	find_primary	__PR((node *t, int op));*/
/*extern	BOOL	find_pname	__PR((node *t, char *word));*/
#else
extern	BOOL	find_primary	__PR((void *t, int op));
extern	BOOL	find_pname	__PR((void *t, char *word));
#endif

#ifdef	FIND_NODE
/*EXPORT	BOOL	find_expr	__PR((char *f, char *ff, struct stat *fs, struct WALK *state, node *t));*/
#else
extern	BOOL	find_expr	__PR((char *f, char *ff, struct stat *fs, struct WALK *state, void *t));
#endif

extern	int	find_plusflush	__PR((void *p, struct WALK *state));
extern	void	find_usage	__PR((int ret));

#endif	/* _FIND_H */
