#!/bin/sh
DEVNAME="$1"
TESTNAME="cdrom.$RANDOM"

. /etc/udev/udev.conf

LOCKFILE="${udev_root}cdrom-lockfile"
PERM_RULES="${udev_rules}/75-optical-devices.rules"
TEMP_RULES="${udev_root}75-optical-devices.rules"

getlock() {
        until ( mkdir $LOCKFILE ) 2>/dev/null
        do
           sleep 1
        done
}

givelock() {
	if [ -e $LOCKFILE ]; then
        	rm -rf $LOCKFILE
	fi
}

checkrules() {
        if grep "$1" ${udev_rules}/*.rules &>/dev/null ; then
                return 0
        fi
        if grep "$1" ${udev_root}/*.rules &>/dev/null ; then
                return 0
        fi
        return 1
}

testwrite() {
	if ln -s /dev/null ${udev_rules}/$TESTNAME 2>/dev/null ; then
		rm -rf ${udev_rules}/$TESTNAME
		RW=1
		if [ -e $TEMP_RULES ]; then
			mv $TEMP_RULES $PERM_RULES
		fi
		UDEV_RULES="$PERM_RULES"
	else
		if [ -e $PERM_RULES ] && [ ! -e $TEMP_RULES ]; then
			cp $PERM_RULES $TEMP_RULES
		fi
		UDEV_RULES="$TEMP_RULES"
	fi
}

write_cd_rule() {
	if [ -n "$2" ]; then
		LINK=${1}${2}
		echo "${MATCH_RULE}, SYMLINK+=\"${LINK}\"" >> $UDEV_RULES
		if ! [ -e ${udev_root}${LINK} ]; then
			ln -s ${udev_root}${DEVNAME} ${udev_root}${LINK} 2>/dev/null
		fi
		if ! checkrules "SYMLINK+=\"$1\"" ; then
			write_cd_rule $1
		fi
	else
		LINK=${1}
		echo "${MATCH_RULE}, SYMLINK+=\"${LINK}\"" >> $UDEV_RULES
		if ! [ -e ${udev_root}${LINK} ]; then
			ln -s ${udev_root}${DEVNAME} ${udev_root}/${LINK} 2>/dev/null
		fi
	fi
}

if [ -z "$DEVPATH" ]; then
	echo "Missing \$DEVPATH." >&2
	exit 1
fi

if [ -z "$ID_CDROM" ]; then
	echo "$DEVPATH is not a CD reader." >&2
	exit 1
fi

case "$ID_BUS" in
	usb|ieee1394)
	        if [ "$ID_SERIAL" ]; then
                	MATCH_RULE="ENV{ID_SERIAL}==\"$ID_SERIAL\""
        	elif [ "$ID_MODEL" -a "$ID_REVISION" ]; then
                	MATCH_RULE="ENV{ID_MODEL}==\"$ID_MODEL\", ENV{ID_REVISION}==\"$ID_REVISION\""
		else
			exit 1
		fi
	;;
	*)
		MATCH_RULE="ENV{ID_PATH}==\"$ID_PATH\""
	;;
esac

getlock

if ! checkrules "$MATCH_RULE" ; then
	MATCH_RULE="ENV{ID_CDROM}==\"?*\", $MATCH_RULE" 
	# Test if the root filesystem is mounted RW
	testwrite
                                      
	if ! [ -e $UDEV_RULES ]; then
		echo "# Local optical devices rules to make links to your 
# optical devices 
#
# These rules were generated by cdrom-symlinks.sh, but you
# can customize them.
#
# You may edit them as needed.
# (If, for example, your machine has more than one CD or
# DVD drive and you need to be sure they will always be
# given the same symlinks.) 
#
# If you delete this file, /lib/udev/cdrom-symlinks.sh will
# try to generate it again the next time udev is started.
" > $UDEV_RULES
	fi

	if checkrules "\"cdrom0\"" ; then
		NUMBER=`grep -c "SYMLINK+=\"cdrom.\"" $UDEV_RULES`
		while [ `grep -c "\"cdrom${NUMBER}\"" \
			 $UDEV_RULES` -ne 0 ]; do
			NUMBER=$(($NUMBER+1))
		done
	else
		NUMBER="0"
	fi


	write_cd_rule cdrom $NUMBER

	if [ "$ID_CDROM_DVD" ]; then
		write_cd_rule dvd $NUMBER
		if [ "$ID_CDROM_DVD_R" -o "$ID_CDROM_DVD_RW" -o "$ID_CDROM_DVD_RAM" ]; then
			write_cd_rule dvdrw $NUMBER
			write_cd_rule dvdwriter $NUMBER
		fi
	fi

	if [ "$ID_CDROM_CD_R" ]; then
		write_cd_rule cdr $NUMBER
		if [ "$ID_CDROM_CD_RW" ]; then
			write_cd_rule cdrw $NUMBER
			write_cd_rule cdwriter $NUMBER
			if ! checkrules "\"writer\"" ; then
				write_cd_rule writer
			fi
		fi
	fi
fi

givelock

exit 0
