/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MouseInfo;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.peer.TrayIconPeer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.BreakIterator;
import java.util.concurrent.ArrayBlockingQueue;
import sun.awt.SunToolkit;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XEmbeddedFrame;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XSystemTrayPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;

public class XTrayIconPeer
implements TrayIconPeer {
    TrayIcon target;
    TrayIconEventProxy eventProxy;
    XTrayIconEmbeddedFrame eframe;
    TrayIconCanvas canvas;
    Balloon balloon;
    Tooltip tooltip;
    PopupMenu popup;
    String tooltipString;
    boolean isTrayIconDisplayed;
    long eframeParentID;
    final XEventDispatcher parentXED;
    final XEventDispatcher eframeXED;
    volatile boolean isDisposed;
    int old_x;
    int old_y;
    int ex_width;
    int ex_height;
    static final int TRAY_ICON_WIDTH = 24;
    static final int TRAY_ICON_HEIGHT = 24;
    static Field f_isTrayIconWindow = XToolkit.getField(Window.class, "isTrayIconWindow");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XTrayIconPeer(TrayIcon trayIcon) throws AWTException {
        this.target = trayIcon;
        this.eventProxy = new TrayIconEventProxy(this);
        this.canvas = new TrayIconCanvas(trayIcon, 24, 24);
        this.eframe = new XTrayIconEmbeddedFrame();
        this.eframe.setSize(24, 24);
        this.eframe.add(this.canvas);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                XTrayIconPeer.this.eframe.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
                return null;
            }
        });
        this.parentXED = new XEventDispatcher(){

            public void dispatchEvent(XEvent xEvent) {
                if (XTrayIconPeer.this.isDisposed() || xEvent.get_type() != 22) {
                    return;
                }
                XConfigureEvent xConfigureEvent = xEvent.get_xconfigure();
                if (xConfigureEvent.get_height() > 24) {
                    XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, xConfigureEvent.get_x(), xConfigureEvent.get_y() + xConfigureEvent.get_height() / 2 - 12, 24, 24);
                    XTrayIconPeer.this.ex_height = xConfigureEvent.get_height();
                    XTrayIconPeer.this.ex_width = 0;
                } else if (xConfigureEvent.get_width() > 24) {
                    XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, xConfigureEvent.get_x() + xConfigureEvent.get_width() / 2 - 12, xConfigureEvent.get_y(), 24, 24);
                    XTrayIconPeer.this.ex_width = xConfigureEvent.get_width();
                    XTrayIconPeer.this.ex_height = 0;
                } else if (xConfigureEvent.get_x() != XTrayIconPeer.this.old_x && xConfigureEvent.get_y() != XTrayIconPeer.this.old_y) {
                    if (XTrayIconPeer.this.ex_height != 0) {
                        XlibWrapper.XMoveWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, xConfigureEvent.get_x(), xConfigureEvent.get_y() + XTrayIconPeer.this.ex_height / 2 - 12);
                    } else if (XTrayIconPeer.this.ex_width != 0) {
                        XlibWrapper.XMoveWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, xConfigureEvent.get_x() + XTrayIconPeer.this.ex_width / 2 - 12, xConfigureEvent.get_y());
                    }
                }
                XTrayIconPeer.this.old_x = xConfigureEvent.get_x();
                XTrayIconPeer.this.old_y = xConfigureEvent.get_y();
            }
        };
        this.eframeXED = new XEventDispatcher(){
            XTrayIconPeer xtiPeer;
            {
                this.xtiPeer = XTrayIconPeer.this;
            }

            public void dispatchEvent(XEvent xEvent) {
                if (XTrayIconPeer.this.isDisposed() || xEvent.get_type() != 21) {
                    return;
                }
                XReparentEvent xReparentEvent = xEvent.get_xreparent();
                XTrayIconPeer.this.eframeParentID = xReparentEvent.get_parent();
                if (XTrayIconPeer.this.eframeParentID == XToolkit.getDefaultRootWindow()) {
                    if (XTrayIconPeer.this.isTrayIconDisplayed) {
                        SunToolkit.executeOnEventHandlerThread(this.xtiPeer.target, new Runnable(){

                            public void run() {
                                SystemTray.getSystemTray().remove(xtiPeer.target);
                            }
                        });
                    }
                    return;
                }
                if (!XTrayIconPeer.this.isTrayIconDisplayed) {
                    XTrayIconPeer.this.addXED(XTrayIconPeer.this.eframeParentID, XTrayIconPeer.this.parentXED, 131072L);
                    XTrayIconPeer.this.isTrayIconDisplayed = true;
                    XToolkit.awtLockNotifyAll();
                }
            }
        };
        XToolkit.awtLock();
        try {
            XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
            xSetWindowAttributes.set_override_redirect(true);
            XlibWrapper.XChangeWindowAttributes(XToolkit.getDisplay(), this.getWindow(), 512L, xSetWindowAttributes.pData);
            XlibWrapper.XFlush(XToolkit.getDisplay());
            xSetWindowAttributes.dispose();
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.addXED(this.getWindow(), this.eframeXED, 131072L);
        XSystemTrayPeer.getPeerInstance().addTrayIcon(this);
        long l = System.currentTimeMillis();
        XToolkit.awtLock();
        try {
            while (!this.isTrayIconDisplayed) {
                try {
                    XToolkit.awtLockWait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (System.currentTimeMillis() - l <= 2000L) continue;
                break;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        if (!this.isTrayIconDisplayed || this.eframeParentID == 0L || this.eframeParentID == XToolkit.getDefaultRootWindow()) {
            throw new AWTException("TrayIcon couldn't be displayed.");
        }
        this.eframe.setVisible(true);
        this.updateImage();
        this.balloon = new Balloon(this, this.eframe);
        this.tooltip = new Tooltip(this, this.eframe);
        this.addListeners();
    }

    public void dispose() {
        if (SunToolkit.isDispatchThreadForAppContext(this.target)) {
            this.disposeOnEDT();
        } else {
            try {
                SunToolkit.executeOnEDTAndWait(this.target, new Runnable(){

                    public void run() {
                        XTrayIconPeer.this.disposeOnEDT();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private void disposeOnEDT() {
        XToolkit.awtLock();
        this.isDisposed = true;
        XToolkit.awtUnlock();
        this.removeXED(this.getWindow(), this.eframeXED);
        this.removeXED(this.eframeParentID, this.parentXED);
        this.eframe.realDispose();
        this.balloon.dispose();
        this.isTrayIconDisplayed = false;
        XToolkit.targetDisposedPeer(this.target, this);
    }

    public static void suppressWarningString(Window window) {
        try {
            f_isTrayIconWindow.setBoolean(window, true);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void setToolTip(String string) {
        this.tooltipString = string;
    }

    public void updateImage() {
        Runnable runnable = new Runnable(){

            public void run() {
                XTrayIconPeer.this.canvas.updateImage(XTrayIconPeer.this.target.getImage());
            }
        };
        if (!SunToolkit.isDispatchThreadForAppContext(this.target)) {
            SunToolkit.executeOnEventHandlerThread(this.target, runnable);
        } else {
            runnable.run();
        }
    }

    public void displayMessage(String string, String string2, String string3) {
        this.balloon.display(string, string2, string3);
    }

    public void showPopupMenu(int n, int n2) {
        if (this.isDisposed()) {
            return;
        }
        assert (SunToolkit.isDispatchThreadForAppContext(this.target));
        PopupMenu popupMenu = this.target.getPopupMenu();
        if (this.popup != popupMenu) {
            if (this.popup != null) {
                this.eframe.remove(this.popup);
            }
            if (popupMenu != null) {
                this.eframe.add(popupMenu);
            }
            this.popup = popupMenu;
        }
        if (this.popup != null) {
            Point point = ((XBaseWindow)((Object)this.eframe.getPeer())).toLocal(new Point(n, n2));
            this.popup.show(this.eframe, point.x, point.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addXED(long l, XEventDispatcher xEventDispatcher, long l2) {
        if (l == 0L) {
            return;
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, l2);
        }
        finally {
            XToolkit.awtUnlock();
        }
        XToolkit.addEventDispatcher(l, xEventDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeXED(long l, XEventDispatcher xEventDispatcher) {
        if (l == 0L) {
            return;
        }
        XToolkit.awtLock();
        try {
            XToolkit.removeEventDispatcher(l, xEventDispatcher);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private Point getLocationOnScreen() {
        return this.eframe.getLocationOnScreen();
    }

    private Rectangle getBounds() {
        Point point = this.getLocationOnScreen();
        return new Rectangle(point.x, point.y, point.x + 24, point.y + 24);
    }

    void addListeners() {
        this.canvas.addMouseListener(this.eventProxy);
        this.canvas.addMouseMotionListener(this.eventProxy);
    }

    long getWindow() {
        return ((XEmbeddedFramePeer)this.eframe.getPeer()).getWindow();
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    static class Balloon
    extends InfoWindow {
        static final int BALLOON_SHOW_TIME = 10000;
        static final int BALLOON_TEXT_MAX_LENGTH = 256;
        static final int BALLOON_WORD_LINE_MAX_LENGTH = 16;
        static final int BALLOON_WORD_LINE_MAX_COUNT = 4;
        static final int BALLOON_ICON_WIDTH = 32;
        static final int BALLOON_ICON_HEIGHT = 32;
        static final int BALLOON_TRAY_ICON_INDENT = 0;
        static final Color BALLOON_CAPTION_BACKGROUND_COLOR = new Color(200, 200, 255);
        static final Font BALLOON_CAPTION_FONT = new Font("Dialog", 1, 12);
        XTrayIconPeer xtiPeer;
        Panel mainPanel = new Panel();
        Panel captionPanel = new Panel();
        Label captionLabel = new Label("");
        Button closeButton = new Button("X");
        Panel textPanel = new Panel();
        IconCanvas iconCanvas = new IconCanvas(32, 32);
        Label[] lineLabels = new Label[4];
        ActionPerformer ap = new ActionPerformer();
        Image iconImage;
        Image errorImage;
        Image warnImage;
        Image infoImage;
        boolean gtkImagesLoaded;
        Displayer displayer = new Displayer();

        Balloon(XTrayIconPeer xTrayIconPeer, Frame frame) {
            super(frame, new Color(90, 80, 190));
            this.xtiPeer = xTrayIconPeer;
            XTrayIconPeer.suppressWarningString(this);
            this.setCloser(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (Balloon.this.textPanel != null) {
                        Balloon.this.textPanel.removeAll();
                        Balloon.this.textPanel.setSize(0, 0);
                        Balloon.this.iconCanvas.setSize(0, 0);
                        XToolkit.awtLock();
                        try {
                            Balloon.this.displayer.isDisplayed = false;
                            XToolkit.awtLockNotifyAll();
                        }
                        finally {
                            XToolkit.awtUnlock();
                        }
                    }
                }
            }, 10000);
            this.add(this.mainPanel);
            this.captionLabel.setFont(BALLOON_CAPTION_FONT);
            this.captionLabel.addMouseListener(this.ap);
            this.captionPanel.setLayout(new BorderLayout());
            this.captionPanel.add((Component)this.captionLabel, "West");
            this.captionPanel.add((Component)this.closeButton, "East");
            this.captionPanel.setBackground(BALLOON_CAPTION_BACKGROUND_COLOR);
            this.captionPanel.addMouseListener(this.ap);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Balloon.this.hide();
                }
            });
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBackground(Color.white);
            this.mainPanel.add((Component)this.captionPanel, "North");
            this.mainPanel.add((Component)this.iconCanvas, "West");
            this.mainPanel.add((Component)this.textPanel, "Center");
            this.iconCanvas.addMouseListener(this.ap);
            for (int i = 0; i < 4; ++i) {
                this.lineLabels[i] = new Label();
                this.lineLabels[i].addMouseListener(this.ap);
                this.lineLabels[i].setBackground(Color.white);
            }
            this.displayer.start();
        }

        void display(String string, String string2, String string3) {
            if (!this.gtkImagesLoaded) {
                this.loadGtkImages();
            }
            this.displayer.display(string, string2, string3);
        }

        private void _display(String string, String string2, String string3) {
            this.captionLabel.setText(string);
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            if (string2 != null) {
                int n;
                breakIterator.setText(string2);
                int n2 = breakIterator.first();
                int n3 = 0;
                do {
                    if ((n = breakIterator.next()) == -1 || string2.substring(n2, n).length() >= 50) {
                        this.lineLabels[n3].setText(string2.substring(n2, n == -1 ? breakIterator.last() : n));
                        this.textPanel.add(this.lineLabels[n3++]);
                        n2 = n;
                    }
                    if (n3 != 4) continue;
                    if (n == -1) break;
                    this.lineLabels[n3 - 1].setText(new String(this.lineLabels[n3 - 1].getText() + " ..."));
                    break;
                } while (n != -1);
                this.textPanel.setLayout(new GridLayout(n3, 1));
            }
            this.iconImage = "ERROR".equals(string3) ? this.errorImage : ("WARNING".equals(string3) ? this.warnImage : ("INFO".equals(string3) ? this.infoImage : null));
            if (this.iconImage != null) {
                Dimension dimension = this.textPanel.getSize();
                this.iconCanvas.setSize(32, 32 > dimension.height ? 32 : dimension.height);
            }
            SunToolkit.executeOnEventHandlerThread(this.xtiPeer.target, new Runnable(){

                public void run() {
                    if (Balloon.this.xtiPeer.isDisposed()) {
                        return;
                    }
                    Point point = Balloon.this.getParent().getLocationOnScreen();
                    Dimension dimension = Balloon.this.getParent().getSize();
                    Balloon.this.show(new Point(point.x + dimension.width / 2, point.y + dimension.height / 2), 0);
                    if (Balloon.this.iconImage != null) {
                        Balloon.this.iconCanvas.updateImage(Balloon.this.iconImage);
                    }
                }
            });
        }

        public void dispose() {
            this.displayer.interrupt();
            super.dispose();
        }

        void loadGtkImages() {
            if (!this.gtkImagesLoaded) {
                this.errorImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-error.6.rtl");
                this.warnImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-warning.6.rtl");
                this.infoImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-info.6.rtl");
                this.gtkImagesLoaded = true;
            }
        }

        class ActionPerformer
        extends MouseAdapter {
            ActionPerformer() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Balloon.this.hide();
                if (mouseEvent.getButton() == 1) {
                    ActionEvent actionEvent = new ActionEvent(Balloon.this.xtiPeer.target, 1001, Balloon.this.xtiPeer.target.getActionCommand(), mouseEvent.getWhen(), mouseEvent.getModifiers());
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
                }
            }
        }

        class Displayer
        extends Thread {
            final int MAX_CONCURRENT_MSGS = 10;
            ArrayBlockingQueue<Message> messageQueue = new ArrayBlockingQueue(10);
            boolean isDisplayed;

            Displayer() {
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Message message = null;
                    try {
                        message = this.messageQueue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    XToolkit.awtLock();
                    try {
                        while (this.isDisplayed) {
                            try {
                                XToolkit.awtLockWait();
                            }
                            catch (InterruptedException interruptedException) {
                                XToolkit.awtUnlock();
                                return;
                            }
                        }
                        this.isDisplayed = true;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                    Balloon.this._display(message.caption, message.text, message.messageType);
                }
            }

            void display(String string, String string2, String string3) {
                this.messageQueue.offer(new Message(string, string2, string3));
            }
        }

        class Message {
            String caption;
            String text;
            String messageType;

            Message(String string, String string2, String string3) {
                this.caption = string;
                this.text = string2;
                this.messageType = string3;
            }
        }
    }

    static class IconCanvas
    extends Canvas {
        volatile Image image;
        IconObserver observer;
        int width;
        int height;
        int curW;
        int curH;

        IconCanvas(int n, int n2) {
            this.width = this.curW = n;
            this.height = this.curH = n2;
        }

        public void updateImage(Image image) {
            this.image = image;
            if (this.observer == null) {
                this.observer = new IconObserver();
            }
            this.repaintImage(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void repaintImage(boolean bl) {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                try {
                    if (this.isVisible()) {
                        if (bl) {
                            this.update(graphics);
                        } else {
                            this.paint(graphics);
                        }
                    }
                }
                finally {
                    graphics.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            BufferedImage bufferedImage;
            Graphics2D graphics2D;
            if (graphics != null && this.curW > 0 && this.curH > 0 && (graphics2D = (bufferedImage = new BufferedImage(this.curW, this.curH, 2)).createGraphics()) != null) {
                try {
                    graphics2D.setColor(this.getBackground());
                    graphics2D.fillRect(0, 0, this.curW, this.curH);
                    graphics2D.drawImage(this.image, 0, 0, this.curW, this.curH, this.observer);
                    graphics2D.dispose();
                    graphics.drawImage(bufferedImage, 0, 0, this.curW, this.curH, null);
                }
                finally {
                    graphics2D.dispose();
                }
            }
        }

        class IconObserver
        implements ImageObserver {
            IconObserver() {
            }

            public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                if (image != IconCanvas.this.image || !IconCanvas.this.isVisible()) {
                    return false;
                }
                if ((n & 0x33) != 0) {
                    SunToolkit.executeOnEventHandlerThread(IconCanvas.this, new Runnable(){

                        public void run() {
                            IconCanvas.this.repaintImage(false);
                        }
                    });
                }
                return (n & 0x20) == 0;
            }
        }
    }

    static class InfoWindow
    extends Window {
        Container container = new Container(){

            public Insets getInsets() {
                return new Insets(1, 1, 1, 1);
            }
        };
        Closer closer;

        InfoWindow(Frame frame, Color color) {
            super(frame);
            this.setLayout(new BorderLayout());
            this.setBackground(color);
            this.add((Component)this.container, "Center");
            this.container.setLayout(new BorderLayout());
            this.closer = new Closer();
        }

        public Component add(Component component) {
            this.container.add(component, "Center");
            return component;
        }

        void setCloser(Runnable runnable, int n) {
            this.closer.set(runnable, n);
        }

        protected void show(Point point, int n) {
            assert (SunToolkit.isDispatchThreadForAppContext(this));
            this.pack();
            Dimension dimension = this.getSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            if (point.x < dimension2.width / 2 && point.y < dimension2.height / 2) {
                this.setLocation(point.x + n, point.y + n);
            } else if (point.x >= dimension2.width / 2 && point.y < dimension2.height / 2) {
                this.setLocation(point.x - n - dimension.width, point.y + n);
            } else if (point.x < dimension2.width / 2 && point.y >= dimension2.height / 2) {
                this.setLocation(point.x + n, point.y - n - dimension.height);
            } else if (point.x >= dimension2.width / 2 && point.y >= dimension2.height / 2) {
                this.setLocation(point.x - n - dimension.width, point.y - n - dimension.height);
            }
            InfoWindow.super.show();
            this.closer.schedule();
        }

        public void hide() {
            this.closer.close();
        }

        class Closer
        implements Runnable {
            Runnable action;
            int time;

            Closer() {
            }

            public void run() {
                this.doClose();
            }

            void set(Runnable runnable, int n) {
                this.action = runnable;
                this.time = n;
            }

            void schedule() {
                XToolkit.schedule(this, this.time);
            }

            void close() {
                XToolkit.remove(this);
                this.doClose();
            }

            private void doClose() {
                SunToolkit.executeOnEventHandlerThread(InfoWindow.this, new Runnable(){

                    public void run() {
                        InfoWindow.super.hide();
                        InfoWindow.this.invalidate();
                        if (Closer.this.action != null) {
                            Closer.this.action.run();
                        }
                    }
                });
            }
        }
    }

    static class Tooltip
    extends InfoWindow {
        XTrayIconPeer xtiPeer;
        Label textLabel = new Label("");
        Runnable starter = new Runnable(){

            public void run() {
                Tooltip.this.display();
            }
        };
        static final int TOOLTIP_SHOW_TIME = 10000;
        static final int TOOLTIP_START_DELAY_TIME = 1000;
        static final int TOOLTIP_MAX_LENGTH = 64;
        static final int TOOLTIP_MOUSE_CURSOR_INDENT = 5;
        static final Color TOOLTIP_BACKGROUND_COLOR = new Color(255, 255, 220);
        static final Font TOOLTIP_TEXT_FONT = XWindow.defaultFont;

        Tooltip(XTrayIconPeer xTrayIconPeer, Frame frame) {
            super(frame, Color.black);
            this.xtiPeer = xTrayIconPeer;
            XTrayIconPeer.suppressWarningString(this);
            this.setCloser(null, 10000);
            this.textLabel.setBackground(TOOLTIP_BACKGROUND_COLOR);
            this.textLabel.setFont(TOOLTIP_TEXT_FONT);
            this.add(this.textLabel);
        }

        void display() {
            String string = this.xtiPeer.tooltipString;
            if (string == null) {
                return;
            }
            if (string.length() > 64) {
                this.textLabel.setText(string.substring(0, 64));
            } else {
                this.textLabel.setText(string);
            }
            SunToolkit.executeOnEventHandlerThread(this.xtiPeer.target, new Runnable(){

                public void run() {
                    if (Tooltip.this.xtiPeer.isDisposed()) {
                        return;
                    }
                    Point point = (Point)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            if (!Tooltip.this.isPointerOverTrayIcon(Tooltip.this.xtiPeer.getBounds())) {
                                return null;
                            }
                            return MouseInfo.getPointerInfo().getLocation();
                        }
                    });
                    if (point == null) {
                        return;
                    }
                    Tooltip.this.show(new Point(point.x, point.y), 5);
                }
            });
        }

        void enter() {
            XToolkit.schedule(this.starter, 1000L);
        }

        void exit() {
            XToolkit.remove(this.starter);
            if (this.isVisible()) {
                this.hide();
            }
        }

        boolean isPointerOverTrayIcon(Rectangle rectangle) {
            Point point = MouseInfo.getPointerInfo().getLocation();
            return point.x >= rectangle.x && point.x <= rectangle.x + rectangle.width && point.y >= rectangle.y && point.y <= rectangle.y + rectangle.height;
        }
    }

    static class TrayIconCanvas
    extends IconCanvas {
        TrayIcon target;
        boolean autosize;

        TrayIconCanvas(TrayIcon trayIcon, int n, int n2) {
            super(n, n2);
            this.target = trayIcon;
        }

        protected void repaintImage(boolean bl) {
            boolean bl2 = this.autosize;
            this.autosize = this.target.isImageAutoSize();
            this.curW = this.autosize ? this.width : this.image.getWidth(this.observer);
            this.curH = this.autosize ? this.height : this.image.getHeight(this.observer);
            super.repaintImage(bl || bl2 != this.autosize);
        }
    }

    static class TrayIconEventProxy
    implements MouseListener,
    MouseMotionListener {
        XTrayIconPeer xtiPeer;

        TrayIconEventProxy(XTrayIconPeer xTrayIconPeer) {
            this.xtiPeer = xTrayIconPeer;
        }

        public void handleEvent(MouseEvent mouseEvent) {
            if (this.xtiPeer.isDisposed()) {
                return;
            }
            Point point = XBaseWindow.toOtherWindow(this.xtiPeer.getWindow(), XToolkit.getDefaultRootWindow(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
            mouseEvent.setSource(this.xtiPeer.target);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getClickCount() > 1 || this.xtiPeer.balloon.isVisible()) && mouseEvent.getButton() == 1) {
                ActionEvent actionEvent = new ActionEvent(this.xtiPeer.target, 1001, this.xtiPeer.target.getActionCommand(), mouseEvent.getWhen(), mouseEvent.getModifiers());
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
            }
            if (this.xtiPeer.balloon.isVisible()) {
                this.xtiPeer.balloon.hide();
            }
            this.handleEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.xtiPeer.tooltip.enter();
            this.handleEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.xtiPeer.tooltip.exit();
            this.handleEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }
    }

    private static class XTrayIconEmbeddedFrame
    extends XEmbeddedFrame {
        public XTrayIconEmbeddedFrame() {
            super(XToolkit.getDefaultRootWindow(), true, true);
        }

        public boolean isUndecorated() {
            return true;
        }

        public boolean isResizable() {
            return false;
        }

        public void dispose() {
        }

        public void realDispose() {
            super.dispose();
        }
    }
}

