#!/usr/bin/env python

# Qt tutorial 9.

import sys
import qt


class LCDRange(qt.QVBox):
    def __init__(self, parent=None, name=None):
        qt.QVBox.__init__(self, parent, name)

        lcd = qt.QLCDNumber(2, self, "lcd")
        self.slider = qt.QSlider(qt.Qt.Horizontal, self, "slider")
        self.slider.setRange(0, 99)
        self.slider.setValue(0)
        self.connect(self.slider, qt.SIGNAL("valueChanged(int)"), lcd, qt.SLOT("display(int)"))
        self.connect(self.slider, qt.SIGNAL("valueChanged(int)"), self, qt.PYSIGNAL("valueChanged(int)"))

        self.setFocusProxy(self.slider)

    def value(self):
        return self.slider.value()

    def setValue(self, value):
        self.slider.setValue(value)

    def setRange(self, minVal, maxVal):
        if minVal < 0 or maxVal > 99 or minVal > maxVal:
            raise ValueError,  "LCDRange.setRange(): invalid range"
        self.slider.setRange(minVal, maxVal)


class CannonField(qt.QWidget):
    def __init__(self, parent=None, name=None):
        qt.QWidget.__init__(self, parent, name)

        self.ang = 45
        self.setPalette(qt.QPalette(qt.QColor(250, 250, 200)))

    def angle(self):
        return self.ang

    def setAngle(self, degrees):
        if degrees < 5:
            degrees = 5
        if degrees > 70:
            degrees = 70
        if self.ang == degrees:
            return
        self.ang = degrees
        self.repaint()
        self.emit(qt.PYSIGNAL("angleChanged(int)"), (self.ang, ))

    def paintEvent(self, ev):
        p = qt.QPainter(self)

        p.setBrush(qt.Qt.blue)
        p.setPen(qt.Qt.NoPen)

        p.translate(0, self.rect().bottom())
        p.drawPie(qt.QRect(-35, -35, 70, 70), 0, 90 * 16)
        p.rotate(-self.ang)
        p.drawRect(qt.QRect(33, -4, 15, 8))

    def sizePolicy(self):
        return qt.QSizePolicy(qt.QSizePolicy.Expanding, qt.QSizePolicy.Expanding)


class MyWidget(qt.QWidget):
    def __init__(self, parent=None, name=None):
        qt.QWidget.__init__(self, parent, name)

        quit = qt.QPushButton("&Quit", self, "quit")
        quit.setFont(qt.QFont("Times", 18, qt.QFont.Bold))
        self.connect(quit, qt.SIGNAL("clicked()"), qt.qApp, qt.SLOT("quit()"))

        self.angle = LCDRange(self, "angle")
        self.angle.setRange(5, 70)

        self.cannonField = CannonField(self, "cannonField")

        self.connect(self.angle, qt.PYSIGNAL("valueChanged(int)"), self.cannonField.setAngle)
        self.connect(self.cannonField, qt.PYSIGNAL("angleChanged(int)"), self.angle.setValue)

        grid = qt.QGridLayout(self, 2, 2, 10)

        grid.addWidget(quit, 0, 0)
        grid.addWidget(self.angle, 1, 0, qt.Qt.AlignTop)
        grid.addWidget(self.cannonField, 1, 1)
        grid.setColStretch(1, 10)

        self.angle.setValue(60)
        self.angle.setFocus()


qt.QApplication.setColorSpec(qt.QApplication.CustomColor)
a = qt.QApplication(sys.argv)

w = MyWidget()
w.setGeometry(100, 100, 500, 355)
a.setMainWidget(w)
w.show()
sys.exit(a.exec_loop())
