/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;

public class CertPathBuilder {
    private static final String CERT_PATH_BUILDER = "CertPathBuilder";
    private CertPathBuilderSpi cpbSpi;
    private Provider provider;
    private String algorithm;

    protected CertPathBuilder(CertPathBuilderSpi cpbSpi, Provider provider, String algorithm) {
        this.cpbSpi = cpbSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static final String getDefaultType() {
        String type = Security.getProperty("certpathbuilder.type");
        if (type == null) {
            type = "PKIX";
        }
        return type;
    }

    public static CertPathBuilder getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            try {
                return CertPathBuilder.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static CertPathBuilder getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return CertPathBuilder.getInstance(algorithm, p);
    }

    public static CertPathBuilder getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("null provider");
        }
        try {
            return new CertPathBuilder((CertPathBuilderSpi)Engine.getInstance(CERT_PATH_BUILDER, algorithm, provider), provider, algorithm);
        }
        catch (InvocationTargetException ite) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(algorithm);
        }
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final CertPathBuilderResult build(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        return this.cpbSpi.engineBuild(params);
    }
}

