/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketPermission;
import java.util.Enumeration;

public class MulticastSocket
extends DatagramSocket {
    public MulticastSocket() throws IOException {
        this(new InetSocketAddress(0));
    }

    public MulticastSocket(int port) throws IOException {
        this(new InetSocketAddress(port));
    }

    public MulticastSocket(SocketAddress address) throws IOException {
        super((SocketAddress)null);
        this.setReuseAddress(true);
        if (address != null) {
            this.bind(address);
        }
    }

    public InetAddress getInterface() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        return (InetAddress)this.getImpl().getOption(16);
    }

    public byte getTTL() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        return this.getImpl().getTTL();
    }

    public int getTimeToLive() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        return this.getImpl().getTimeToLive();
    }

    public void setInterface(InetAddress addr) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(16, addr);
    }

    public void setNetworkInterface(NetworkInterface netIf) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Enumeration e = netIf.getInetAddresses();
        if (!e.hasMoreElements()) {
            throw new SocketException("no network devices found");
        }
        InetAddress address = (InetAddress)e.nextElement();
        this.getImpl().setOption(16, address);
    }

    public NetworkInterface getNetworkInterface() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        InetAddress address = (InetAddress)this.getImpl().getOption(16);
        NetworkInterface netIf = NetworkInterface.getByInetAddress(address);
        return netIf;
    }

    public void setLoopbackMode(boolean disable) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(18, new Boolean(disable));
    }

    public boolean getLoopbackMode() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object buf = this.getImpl().getOption(18);
        if (buf instanceof Boolean) {
            return (Boolean)buf;
        }
        throw new SocketException("unexpected type");
    }

    public void setTTL(byte ttl) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setTTL(ttl);
    }

    public void setTimeToLive(int ttl) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (ttl <= 0 || ttl > 255) {
            throw new IllegalArgumentException("Invalid ttl: " + ttl);
        }
        this.getImpl().setTimeToLive(ttl);
    }

    public void joinGroup(InetAddress mcastaddr) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!mcastaddr.isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkMulticast(mcastaddr);
        }
        this.getImpl().join(mcastaddr);
    }

    public void leaveGroup(InetAddress mcastaddr) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!mcastaddr.isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkMulticast(mcastaddr);
        }
        this.getImpl().leave(mcastaddr);
    }

    public void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!(mcastaddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("SocketAddress type not supported");
        }
        InetSocketAddress tmp = (InetSocketAddress)mcastaddr;
        if (!tmp.getAddress().isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkMulticast(tmp.getAddress());
        }
        this.getImpl().joinGroup(mcastaddr, netIf);
    }

    public void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        InetSocketAddress tmp = (InetSocketAddress)mcastaddr;
        if (!tmp.getAddress().isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkMulticast(tmp.getAddress());
        }
        this.getImpl().leaveGroup(mcastaddr, netIf);
    }

    public synchronized void send(DatagramPacket p, byte ttl) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            InetAddress addr = p.getAddress();
            if (addr.isMulticastAddress()) {
                s.checkPermission(new SocketPermission(addr.getHostName() + p.getPort(), "accept,connect"));
            } else {
                s.checkConnect(addr.getHostAddress(), p.getPort());
            }
        }
        int oldttl = this.getImpl().getTimeToLive();
        this.getImpl().setTimeToLive(ttl & 0xFF);
        this.getImpl().send(p);
        this.getImpl().setTimeToLive(oldttl);
    }
}

