#!/usr/bin/env kjscmd

// Populates the sidebar listview
function setup_sidebar( special, qt, kde, all )
{
    var qobjects = Factory.constructors().sort();

    for ( var i=0; i < qobjects.length ; i++ ) {
	all.insertItem( qobjects[i] );

	if ( /^Q/.test(qobjects[i]) )
	    qt.insertItem( qobjects[i] );
	else if ( /^K/.test(qobjects[i]) )
	    kde.insertItem( qobjects[i] );
	else
	    special.insertItem( qobjects[i] );
    }
}

//
// Main
//

// Create the UI
var mw = new KMainWindow();
var ac = mw.actionCollection();

var split = new QSplitter( mw );
mw.setCentralWidget( split );

//
// Load the sidebar
//

var side = new QTabWidget( split, 'sidebar' );

var specialside = new KListView( side, 'specialsidebar' );
specialside.addColumn('Class');

var qtside = new KListView( side, 'qtsidebar' );
qtside.addColumn('Class');

var kdeside = new KListView( side, 'kdesidebar' );
kdeside.addColumn('Class');

var allside = new KListView( side, 'allsidebar' );
allside.addColumn('Class');

side.addTab( specialside, 'Special' );
side.addTab( qtside, 'Qt' );
side.addTab( kdeside, 'KDE' );
side.addTab( allside, 'All' );

setup_sidebar( specialside, qtside, kdeside, allside );

//
// Load the views
//

var views = new QLabel( split );
views.text = 'xxxx';

// JS docs

//
// Activate XMLGUI and show the window
//
mw.createGUI( 'stdactionsui.rc' );
side.maximumWidth = 200;
mw.resize( 700, 500 );

mw.show();
