/***************************************************************************
                            Range.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef RANGE_H
#define RANGE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**
*/
@class DOMNode; 
@class DOMDocument;
@class DocumentFragment; 


@interface  Range : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- initWithDocument: (DOMDocument*)rootContainer;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)startContainer startOffset: (long)startOffset endContainer: (DOMNode*)endContainer endOffset: (long)endOffset;
- (void) dealloc;

/** 
 Node within which the range begins

     
*/
- (DOMNode*) startContainer;

/** 
 Offset within the starting node of the range.

     
*/
- (long) startOffset;

/** 
 Node within which the range ends

     
*/
- (DOMNode*) endContainer;

/** 
 Offset within the ending node of the range.

     
*/
- (long) endOffset;

/** 
 TRUE if the range is collapsed

     
*/
- (BOOL) collapsed;

/** 
 Gets the common ancestor container of the range's two end-points.
 Also sets it.

     
*/
- (DOMNode*) commonAncestorContainer;

/** 
 Sets the attributes describing the start of the range.

  INVALID_NODE_TYPE_ERR: Raised if <code> refNode </code> or an
 ancestor of <code> refNode </code> is an Attr, Entity,
 Notation, or DocumentType node.

  If an offset is out-of-bounds, should it just be fixed up or
 should an exception be raised.

     
*/
- setStart: (DOMNode*)refNode offset: (long)offset;

/** 
 Sets the attributes describing the end of a range.

  INVALID_NODE_TYPE_ERR: Raised if <code> refNode </code> or an
 ancestor of <code> refNode </code> is an Attr, Entity,
 Notation, or DocumentType node.

     
*/
- setEnd: (DOMNode*)refNode offset: (long)offset;

/** 
 Sets the start position to be before a node

     
*/
- setStartBefore: (DOMNode*)refNode;

/** 
 Sets the start position to be after a node

     
*/
- setStartAfter: (DOMNode*)refNode;

/** 
 Sets the end position to be before a node.

     
*/
- setEndBefore: (DOMNode*)refNode;

/** 
 Sets the end of a range to be after a node

     
*/
- setEndAfter: (DOMNode*)refNode;

/** 
 Collapse a range onto one of its end-points

     
*/
- collapse: (BOOL)toStart;

/** 
 Select a node and its contents

     
*/
- selectNode: (DOMNode*)refNode;

/** 
 Select the contents within a node

     
*/
- selectNodeContents: (DOMNode*)refNode;

/** 
 Compare the end-points of two ranges in a document.

     
*/
- (short) compareBoundaryPoints: (int)how sourceRange: (Range*)sourceRange;

/** 

 not part of the DOM

 Compare the boundary-points of a range.

 Return true if the startContainer is before the endContainer,
 or if they are equal.
 Return false if the startContainer is after the endContainer.

     
*/
- (BOOL) boundaryPointsValid;

/** 
 Removes the contents of a range from the containing document or
 document fragment without returning a reference to the removed
 content.

     
*/
- deleteContents;

/** 
 Moves the contents of a range from the containing document or
 document fragment to a new DocumentFragment.

  HIERARCHY_REQUEST_ERR: Raised if a DocumentType node would be
 extracted into the new DocumentFragment.

     
*/
- (DocumentFragment*) extractContents;

/** 
 Duplicates the contents of a range

     
*/
- (DocumentFragment*) cloneContents;

/** 
 Inserts a node into the document or document fragment at the
 start of the range.

  WRONG_DOCUMENT_ERR: Raised if <code> newNode </code> and the
 container of the start of the Range were not created from the
 same document.

  HIERARCHY_REQUEST_ERR: Raised if the container of the start of
 the Range is of a type that does not allow children of the type
 of <code> newNode </code> or if <code> newNode </code> is an
 ancestor of the container .

     
*/
- insertNode: (DOMNode*)newNode;

/** 
 Reparents the contents of the range to the given node and
 inserts the node at the position of the start of the range.

  WRONG_DOCUMENT_ERR: Raised if <code> newParent </code> and the
 container of the start of the Range were not created from the
 same document.

  HIERARCHY_REQUEST_ERR: Raised if the container of the start of
 the Range is of a type that does not allow children of the type
 of <code> newParent </code> or if <code> newParent </code> is
 an ancestor of the container or if <code> node </code> would
 end up with a child node of a type not allowed by the type of
 <code> node </code> .

  INVALID_NODE_TYPE_ERR: Raised if <code> node </code> is an
 Attr, Entity, DocumentType, Notation, Document, or
 DocumentFragment node.

     
*/
- surroundContents: (DOMNode*)newParent;

/** 
 Produces a new range whose end-points are equal to the
 end-points of the range.

     
*/
- (Range*) cloneRange;

/** 
 Returns the contents of a range as a string.

     
*/
- (NSString *) toString;

/** 

     
*/
- (NSString *) toHTML;

/** 
 Called to indicate that the range is no longer in use and that
 the implementation may relinquish any resources associated with
 this range. Subsequent calls to any methods or attribute getters
 on this range will result in a DOMException being thrown with an
 error code of INVALID_STATE_ERR.

     
*/
- detach;

/** 
 not part of the DOM
 TRUE if the range is detached

     
*/
- (BOOL) isDetached;
- (BOOL) isNull;
+ (int) START_TO_START;
+ (int) START_TO_END;
+ (int) END_TO_END;
+ (int) END_TO_START;
@end

#endif
