/***************************************************************************
                            KFileDialog.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEDIALOG_H
#define KFILEDIALOG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialogBase.h>

/**

 Provides a user (and developer) friendly way to
 select files and directories.

 The widget can be used as a drop in replacement for the
 @ref  QFileDialog widget, but has greater functionality and a nicer GUI.

 You will usually want to use one of the static methods
 @ref -getOpenFileName, @ref -getSaveFileName, @ref -getOpenURL
 or for multiple files @ref -getOpenFileNames or @ref -getOpenURLs.

 The dialog has been designed to allow applications to customise it
 by subclassing. It uses geometry management to ensure that subclasses
 can easily add children that will be incorporated into the layout.

 @author Richard J. Moore <rich@kde.org>, Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A file selection dialog.

*/

@class KURL;
@class KPreviewWidgetBase;
@class KToolBar;
@class KPushButton;
@class KActionCollection;
@class KFileItem;
@class KConfig;
@class Job;

@interface KFileDialog : KDialogBase 

/** 
 Constructs a file dialog.

*/
- initWithText: (NSString *)startDir filter: (NSString *)filter parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal;

/** 
 Destructs the file dialog.
     
*/
- (void) dealloc;

/** 

*/
- (KURL*) selectedURL;

/** 

*/
- (NSArray *) selectedURLs;

/** 

*/
- (KURL*) baseURL;

/** 
 Returns the full path of the selected file in the local filesystem.
 (Local files only)
     
*/
- (NSString *) selectedFile;

/** 
 Returns a list of all selected local files.
     
*/
- (NSArray *) selectedFiles;

/** 
 Sets the directory to view.

*/
- setURL: (KURL*)url clearforward: (BOOL)clearforward;
- setURL: (KURL*)url ;

/** 
 Sets the file name to preselect to @p name

 This takes absolute URLs and relative file names.
     
*/
- setSelection: (NSString *)name;

/** 
 Sets the operational mode of the filedialog to @p Saving, @p Opening
 or @p Other. This will set some flags that are specific to loading
 or saving files. E.g. @ref -setKeepLocation makes mostly sense for
 a save-as dialog. So setOperationMode( -[KFileDialog Saving]); sets
 setKeepLocation for example.

 The default mode is @p Other.

 Call this method right after instantiating KFileDialog.

*/
- setOperationMode: (int)arg1;

/** 

*/
- (int) operationMode;

/** 
 Sets whether the filename/url should be kept when changing directories.
 This is for example useful when having a predefined filename where
 the full path for that file is searched.

 This is implicitly set when @ref -operationMode is -[KFileDialog Saving]
 -getSaveFileName and -getSaveURL set this to true by default, so that
 you can type in the filename and change the directory without having
 to type the name again.
     
*/
- setKeepLocation: (BOOL)keep;

/** 

*/
- (BOOL) keepsLocation;

/** 
 Sets the filter to be used to @p filter.

 You can set more
 filters for the user to select seperated by '\n'. Every
 filter entry is defined through namefilter|text to diplay.
 If no | is found in the expression, just the namefilter is
 shown. Examples:

 <pre>
 -[kfile setFilter]("*.cpp|C++ Source Files\n*.h|Header files");
 -[kfile setFilter]("*.cpp");
 -[kfile setFilter]("*.cpp|Sources (*.cpp)");
 -[kfile setFilter]("*.cpp *.cc *.C|C++ Source Files\n*.h *.H|Header files");
 </pre>

 Note: The text to display is not parsed in any way. So, if you
 want to show the suffix to select by a specific filter, you must
 repeat it.

 If the filter contains a '/', a mimetype-filter is assumed. You can
 specify multiple mimetypes like this (separated with space):

 <pre>
 -[kfile setFilter]( "image/png text/html text/plain" );
 </pre>

*/
- setFilter: (NSString *)filter;

/** 
 Returns the current filter as entered by the user or one of the
 predefined set via @ref -setFilter.

*/
- (NSString *) currentFilter;

/** 
 Sets the filter up to specify the output type.

 Do not use in conjunction with @ref -setFilter

     
*/
//- setFilterMimeType: (NSString *)label types: (KMimeType_List*)types defaultType: (KMimeType_Ptr*)defaultType;

/** 
 Returns the mimetype for the desired output format.

 This is only valid if @ref -setFilterMimeType has been called
 previously.

*/
//- (KMimeType_Ptr) currentFilterMimeType;

/** 
 Sets the filter up to specify the output type.

 Do not use in conjunction with @ref -setFilter
     
*/
- setMimeFilter: (NSArray *)types defaultType: (NSString *)defaultType;
- setMimeFilter: (NSArray *)types ;

/** 
 The mimetype for the desired output format.

 This is only valid if @ref -setMimeFilter has been called
 previously.

*/
- (NSString *) currentMimeFilter;

/** 
  Clears any mime- or namefilter. Does not reload the directory.
     
*/
- clearFilter;

/** 

 Add a preview widget and enter the preview mode.

 In this mode
 the dialog is split and the right part contains your widget.
 This widget has to inherit @ref QWidget and it has to implement
 a slot @ref showPreview(const KURL &); which is called
 every time the file changes. You may want to look at
 koffice/lib/kofficecore/koFilterManager.cc for some hints :)

 Ownership is transferred to KFileDialog. You need to create the
 preview-widget with "new", i.e. on the heap.
     
*/
- setPreviewWidget: (QWidget *)w;

/** 
 Adds a preview widget and enters the preview mode.

 In this mode the dialog is split and the right part contains your
 preview widget.

 Ownership is transferred to KFileDialog. You need to create the
 preview-widget with "new", i.e. on the heap.

*/
- setPreviewWidgetBase: (KPreviewWidgetBase*)w;

/** 

     
*/
//- setMode: (int)m;

/** 
 Sets the mode of the dialog.

 The mode is defined as (in kfile.h):
 <pre>    enum Mode {
                      File         = 1,
                      Directory    = 2,
                      Files        = 4,
                      ExistingOnly = 8,
                      LocalOnly    = 16
                    };
 </pre>
 You can OR the values, e.g.
 <pre>
 -[KFile Mode]mode = static_cast<-[KFile Mode]>( -[KFile Files]|
                                              -[KFile ExistingOnly]|
                                              -[KFile LocalOnly]);
 setMode( mode );
 </pre>
     
*/
- setMode: (unsigned int)m;

/** 
 Returns the mode of the filedialog.

*/
- (int) mode;

/** 
 Sets the text to be displayed in front of the selection.

 The default is "Location".
 Most useful if you want to make clear what
 the location is used for.
     
*/
- setLocationLabel: (NSString *)text;

/** 
 Returns a pointer to the toolbar.

 You can use this to insert custom
 items into it, e.g.:
 <pre>
      yourAction = new KAction( i18n("Your Action"), 0,
                                this, SLOT( -yourSlot ),
                                this, "action name" );
      -[yourAction plug]( -[kfileDialog toolBar] );
 </pre>
     
*/
- (KToolBar*) toolBar;

/** 

*/
- (KPushButton*) okButton;

/** 

*/
- (KPushButton*) cancelButton;

/** 

*/
- (KActionCollection*) actionCollection;

/** 
 Creates a modal file dialog and return the selected
 filename or an empty string if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
+ (NSString *) getOpenFileName: (NSString *)startDir filter: (NSString *)filter parent: (QWidget *)parent caption: (NSString *)caption;

/** 
 Creates a modal file dialog and returns the selected
 filenames or an empty list if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
+ (NSArray *) getOpenFileNames: (NSString *)startDir filter: (NSString *)filter parent: (QWidget *)parent caption: (NSString *)caption;

/** 
 Creates a modal file dialog and returns the selected
 URL or an empty string if none was chosen.

 Note that with
 this method the user must select an existing URL.

*/
+ (KURL*) getOpenURL: (NSString *)startDir filter: (NSString *)filter parent: (QWidget *)parent caption: (NSString *)caption;
+ (KURL*) getOpenURL;

/** 
 Creates a modal file dialog and returns the selected
 URLs or an empty list if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
+ (NSArray *) getOpenURLs: (NSString *)startDir filter: (NSString *)filter parent: (QWidget *)parent caption: (NSString *)caption;

/** 
 Creates a modal file dialog and returns the selected
 filename or an empty string if none was chosen.

 Note that with this
 method the user need not select an existing filename.

*/
+ (NSString *) getSaveFileName: (NSString *)startDir filter: (NSString *)filter parent: (QWidget *)parent caption: (NSString *)caption;

/** 
 Creates a modal file dialog and returns the selected
 filename or an empty string if none was chosen.

 Note that with this
 method the user need not select an existing filename.

*/
+ (KURL*) getSaveURL: (NSString *)startDir filter: (NSString *)filter parent: (QWidget *)parent caption: (NSString *)caption;
+ (KURL*) getSaveURL;

/** 
 Creates a modal file dialog and returns the selected
 directory or an empty string if none was chosen.

 Note that with this
 method the user need not select an existing directory.

*/
+ (NSString *) getExistingDirectory: (NSString *)startDir parent: (QWidget *)parent caption: (NSString *)caption;

/** 
 Creates a modal file dialog with an image previewer and returns the
 selected url or an empty string if none was chosen.

*/
+ (KURL*) getImageOpenURL: (NSString *)startDir parent: (QWidget *)parent caption: (NSString *)caption;
+ (KURL*) getImageOpenURL;

/** 
 adds a entry of the current directory. If disableUpdating is set
 to true, it will care about clever updating

*/
- addDirEntry: (KFileItem*)entry disableUpdating: (BOOL)disableUpdating;

/** 
 rebuild geometry managment.

      
*/
- initGUI;

/** 
 called when an item is highlighted/selected in multiselection mode.
 handles setting the locationEdit.
     
*/
- multiSelectionChanged;

/** 
 Reads configuration and applies it (size, recent directories, ...)
     
*/
- readConfig: (KConfig*)arg1 group: (NSString *)group;
- readConfig: (KConfig*)arg1 ;

/** 
 Saves the current configuration
     
*/
- writeConfig: (KConfig*)arg1 group: (NSString *)group;
- writeConfig: (KConfig*)arg1 ;

/** 
 Reads the recent used files and inserts them into the location combobox
     
*/
- readRecentFiles: (KConfig*)arg1;

/** 
 Saves the entries from the location combobox.
     
*/
- saveRecentFiles: (KConfig*)arg1;

/** 
 Parses the string "line" for files. If line doesn't contain any ", the
 whole line will be interpreted as one file. If the number of " is odd,
 an empty list will be returned. Otherwise, all items enclosed in " "
 will be returned as correct urls.
     
*/
- (NSArray *) tokenize: (NSString *)line;
- (NSArray *) parseSelectedURLs;
- virtual_hook: (int)identifier data: (void*)data;
- urlEntered: (KURL*)arg1;
- enterURL: (KURL*)url;
- enterURLWithString: (NSString *)url;
- locationActivated: (NSString *)url;
- toolbarCallback: (int)arg1;
- slotFilterChanged;
- pathComboChanged: (NSString *)arg1;
- fileHighlighted: (KFileItem*)i;
- fileSelected: (KFileItem*)i;
- slotStatResult: (Job*)job;
- slotLoadingFinished;
- dirCompletion: (NSString *)arg1;
- fileCompletion: (NSString *)arg1;
- updateStatusLine: (int)dirs files: (int)files;
- slotOk;
- accept;
- slotCancel;
- addToRecentDocuments;
+ (int) Other;
+ (int) Opening;
+ (int) Saving;
@end

/** Override these methods in subclasses of KFileDialog to customise event handling behaviour */
@protocol KFileDialogEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
