/***************************************************************************
                            kde_KMessageBox.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KMESSAGEBOX
#define KDE_KMESSAGEBOX

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Easy message dialog box.

 Provides convenience functions for some i18n'ed standard dialogs.

 The text in message boxes is wrapped automatically. The text may either
 be plaintext or richtext. If the text is plaintext, a newline-character
 may be used to indicate the end of a paragraph.

 @author Waldo Bastian (bastian@kde.org)

 @version $Id: kde_KMessageBox.h,v 1.6 2002/12/30 14:37:06 geiseri Exp $
  
 @short *
 Easy message dialog box.
*/
#define KMESSAGEBOX_Ok	1
#define KMESSAGEBOX_Cancel	2
#define KMESSAGEBOX_Yes	3
#define KMESSAGEBOX_No	4
#define KMESSAGEBOX_Continue	5
#define KMESSAGEBOX_QuestionYesNo	1
#define KMESSAGEBOX_WarningYesNo	2
#define KMESSAGEBOX_WarningContinueCancel	3
#define KMESSAGEBOX_WarningYesNoCancel	4
#define KMESSAGEBOX_Information	5
#define KMESSAGEBOX_Sorry	7
#define KMESSAGEBOX_Error	8
#define KMESSAGEBOX_QuestionYesNoCancel	9
#define KMESSAGEBOX_Notify	1
#define KMESSAGEBOX_AllowLink	2

/** *
 Display a simple "question" dialog.

 To be used for questions like "Do you have a printer?"

 The default button is "Yes". Pressing "Esc" selects "No".
  
*/
#ifdef __cplusplus
extern   "C" {
#endif
int kde_KMessageBox_questionYesNo( qt_QWidget * parent, qt_QString * text, qt_QString * caption, kde_KGuiItem* buttonYes, kde_KGuiItem* buttonNo, qt_QString * dontAskAgainName, int options);

/** *
 Display a simple "question" dialog.

 To be used for questions like "Do you want to discard the message or save it for later?",

 The default button is "Yes". Pressing "Esc" selects "Cancel".

 NOTE: The cancel button will always have the i18n'ed text '&Cancel'.
  
*/
int kde_KMessageBox_questionYesNoCancel( qt_QWidget * parent, qt_QString * text, qt_QString * caption, kde_KGuiItem* buttonYes, kde_KGuiItem* buttonNo, qt_QString * dontAskAgainName, int options);

/** *
 Display a "question" dialog with a listbox to show information to the user

 To be used for questions like "Do you really want to delete these files?"
 And show the user exactly which files are going to be deleted in case
 he presses "Yes"

 The default button is "Yes". Pressing "Esc" selects "No".
  
*/
int kde_KMessageBox_questionYesNoList( qt_QWidget * parent, qt_QString * text, qt_QStringList* strlist, qt_QString * caption, kde_KGuiItem* buttonYes, kde_KGuiItem* buttonNo, qt_QString * dontAskAgainName, int options);

/** *
 Display a "warning" dialog.

 To be used for questions "Shall I update your configuration?"
 The text should explain the implication of both options.

 The default button is "No". Pressing "Esc" selects "No".
  
*/
int kde_KMessageBox_warningYesNo( qt_QWidget * parent, qt_QString * text, qt_QString * caption, kde_KGuiItem* buttonYes, kde_KGuiItem* buttonNo, qt_QString * dontAskAgainName, int options);

/** *
 Display a "warning" dialog.

 The second button always has the text "Cancel".

 To be used for questions like "You are about to Print. Are you sure?"
 the continueButton should then be labeled "Print".

 The default button is buttonContinue. Pressing "Esc" selects "Cancel".
  
*/
int kde_KMessageBox_warningContinueCancel( qt_QWidget * parent, qt_QString * text, qt_QString * caption, kde_KGuiItem* buttonContinue, qt_QString * dontAskAgainName, int options);

/** *
 Display a "warning" dialog with a listbox to show information to the user.

 The second button always has the text "Cancel".

 To be used for questions like "You are about to Print. Are you sure?"
 the continueButton should then be labeled "Print".

 The default button is buttonContinue. Pressing "Esc" selects "Cancel".
  
*/
int kde_KMessageBox_warningContinueCancelList( qt_QWidget * parent, qt_QString * text, qt_QStringList* strlist, qt_QString * caption, kde_KGuiItem* buttonContinue, qt_QString * dontAskAgainName, int options);

/** *
 Display a Yes/No/Cancel "warning" dialog.

 To be used for questions "Do you want to save your changes?"
 The text should explain the implication of choosing 'No'.

 The default button is "Yes". Pressing "Esc" selects "Cancel"

 NOTE: The cancel button will always have the i18n'ed text '&Cancel'.
  
*/
int kde_KMessageBox_warningYesNoCancel( qt_QWidget * parent, qt_QString * text, qt_QString * caption, kde_KGuiItem* buttonYes, kde_KGuiItem* buttonNo, qt_QString * dontAskAgainName, int options);

/** *
 Display an "Error" dialog.

 Your program messed up and now it's time to inform the user.
 To be used for important things like "Sorry, I deleted your hard disk."

 If your program detects the action specified by the user is somehow
 not allowed, this should never be reported with error(). Use sorry()
 instead to explain to the user that this action is not allowed.

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The OK button will always have the i18n'ed text '&OK'.
  
*/
void kde_KMessageBox_error( qt_QWidget * parent, qt_QString * text, qt_QString * caption, int options);

/** *
 Displays an "Error" dialog with a "Details >>" button.

 Your program messed up and now it's time to inform the user.
 To be used for important things like "Sorry, I deleted your hard disk."

 The @p details message can conatin additional information about
 the problem and can be shown on request to advanced/interested users.

 If your program detects the action specified by the user is somehow
 not allowed, this should never be reported with error(). Use sorry()
 instead to explain to the user that this action is not allowed.

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The OK button will always have the i18n'ed text '&OK'.
  
*/
void kde_KMessageBox_detailedError( qt_QWidget * parent, qt_QString * text, qt_QString * details, qt_QString * caption, int options);

/** *
 Like @ref detailedError

 This function will return immediately, the messagebox will be shown
 once the application enters an event loop and no other messagebox
 is being shown.

 Note that if the parent gets deleted, the messagebox will not be
 shown.
   
*/
void kde_KMessageBox_queuedDetailedError( qt_QWidget * parent, qt_QString * text, qt_QString * details, qt_QString * caption);

/** *
 Display an "Sorry" dialog.

 Either your program messed up and asks for understanding
 or your user did something stupid.

 To be used for small problems like
 "Sorry, I can't find the file you specified."

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The ok button will always have the i18n'ed text '&OK'.
  
*/
void kde_KMessageBox_sorry( qt_QWidget * parent, qt_QString * text, qt_QString * caption, int options);

/** *
 Displays a "Sorry" dialog with a "Details >>" button.

 Either your program messed up and asks for understanding
 or your user did something stupid.

 To be used for small problems like
 "Sorry, I can't find the file you specified."

 And then @p details can contain something like
 "foobar.txt was not found in any of
  the following directories:
  /usr/bin,/usr/local/bin,/usr/sbin"

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The ok button will always have the i18n'ed text '&OK'.
  
*/
void kde_KMessageBox_detailedSorry( qt_QWidget * parent, qt_QString * text, qt_QString * details, qt_QString * caption, int options);

/** *
 Display an "Information" dialog.

 Your program wants to tell the user something.
 To be used for things like:
 "Your bookmarks have been rearranged."

 The default button is "&OK". Pressing "Esc" selects the OK-button.

  NOTE: The OK button will always have the i18n'ed text '&OK'.
  
*/
void kde_KMessageBox_information( qt_QWidget * parent, qt_QString * text, qt_QString * caption, qt_QString * dontShowAgainName, int options);

/** *
 Display an "Information" dialog with a listbox.

 Your program wants to tell the user something.
 To be used for things like:
 "The following bookmarks have been rearranged:"

 The default button is "&OK". Pressing "Esc" selects the OK-button.

  NOTE: The OK button will always have the i18n'ed text '&OK'.

*/
void kde_KMessageBox_informationList( qt_QWidget * parent, qt_QString * text, qt_QStringList* strlist, qt_QString * caption, qt_QString * dontShowAgainName, int options);

/** *
 Enable all messages which have been turned off with the
 @p dontShowAgainName feature of the information dialog.
   
*/
void kde_KMessageBox_enableAllMessages( );

/** *
 Display an "About" dialog.

 Your program wants to show some general information about the application
 like the authors's names and email addresses.

 The default button is "&OK".

  NOTE: The ok button will always have the i18n'ed text '&OK'.
   
*/
void kde_KMessageBox_about( qt_QWidget * parent, qt_QString * text, qt_QString * caption, int options);

/** *
 Alternate method to show a messagebox:

*/
int kde_KMessageBox_messageBox( qt_QWidget * parent, int type, qt_QString * text, qt_QString * caption, kde_KGuiItem* buttonYes, kde_KGuiItem* buttonNo, int options);
void kde_KMessageBox_queuedMessageBox( qt_QWidget * parent, int type, qt_QString * text, qt_QString * caption, int options);

/** *
 @overload

 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function.
     
*/
void kde_KMessageBox_queuedMessageBox1( qt_QWidget * parent, int type, qt_QString * text, qt_QString * caption);

#ifdef __cplusplus
}
#endif
#endif
