/***************************************************************************
                            kde_KIconButton.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KICONBUTTON
#define KDE_KICONBUTTON

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A pushbutton for choosing an icon. Pressing on the button will open a
 KIconDialog for the user to select an icon. The current icon will be
 displayed on the button.

 @short A push button that allows selection of an icon.
 
*/

/** *
 Constructs a KIconButton using the global iconloader.
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KIconButton * kde_new_KIconButton(qt_QWidget * parent, char* name);

/** *
 Constructs a KIconButton using a specific KIconLoader.
     
*/
kde_KIconButton * kde_new_KIconButton1(kde_KIconLoader* loader, qt_QWidget * parent, char* name);

/** *
 Destructs the button.
     
*/
void kde_del_KIconButton( kde_KIconButton* p );

/** *
 Sets a strict icon size policy for allowed icons. When true,
 only icons of the specified group's size in setIconType are allowed,
 and only icons of that size will be shown in the icon dialog.
     
*/
void kde_KIconButton_setStrictIconSize(kde_KIconButton* instPointer,int b);

/** *
 Returns true if a strict icon size policy is set.
     
*/
int kde_KIconButton_strictIconSize(kde_KIconButton* instPointer);

/** *
 Sets the icon group and context. Use KIcon::NoGroup if you want to
 allow icons for any group in the given context.
     
*/
void kde_KIconButton_setIconType(kde_KIconButton* instPointer,int group, int context, int user);

/** *
 Sets the button's initial icon.
     
*/
void kde_KIconButton_setIcon(kde_KIconButton* instPointer,qt_QString * icon);

/** *
 Resets the icon (reverts to an empty button).
     
*/
void kde_KIconButton_resetIcon(kde_KIconButton* instPointer);

/** *
 Returns the name of the selected icon.
     
*/
qt_QString * kde_KIconButton_icon(kde_KIconButton* instPointer);

/** *
 Sets the size of the icon to be shown / selected.

*/
void kde_KIconButton_setIconSize(kde_KIconButton* instPointer,int size);

/** *
 Returns the iconsize set via @ref setIconSize() or 0, if the default
 iconsize will be used.
     
*/
int kde_KIconButton_iconSize(kde_KIconButton* instPointer);

#ifdef __cplusplus
}
#endif
#endif
