/* Copyright (C) 2002 
	 Mickael Marchand <marchand@kde.org>

	 This program is free software; you can redistribute it and/or
	 modify it under the terms of the GNU General Public
	 License as published by the Free Software Foundation; either
	 version 2 of the License, or (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	 General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; see the file COPYING.  If not, write to
	 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	 Boston, MA 02111-1307, USA.
	 */
#include "vimdcop.h"
#include <dcopclient.h>
#include <kdebug.h>

using namespace Vim;

VimDCOP::VimDCOP(Document *parent) : DCOPObject() {
	mDoc = parent;
	connectDCOPSignal(0,0,"keyboardEvent(QCString,QCString,int,int)","keyboardEvent(QCString,QCString,int,int)",false);
	connectDCOPSignal(0,0,"mousePEvent(QCString,int,int,int,int)","mousePEvent(QCString,int,int,int,int)",false);
	connectDCOPSignal(0,0,"mouseWhlEvent(QCString,int,int,int,int)","mouseWhlEvent(QCString,int,int,int,int)",false);
	connectDCOPSignal(0,0,"mouseDblClickEvent(QCString,int,int,int,int)","mouseDblClickEvent(QCString,int,int,int,int)",false);
}

VimDCOP::~VimDCOP() {
	kdDebug() << "~VimDCOP disconnecting signals" << endl;
	disconnectDCOPSignal(0,0,"keyboardEvent(QCString,QCString,int,int)","keyboardEvent(QCString,QCString,int,int)");
	disconnectDCOPSignal(0,0,"mousePEvent(QCString,int,int,int,int)","mousePEvent(QCString,int,int,int,int)");
	disconnectDCOPSignal(0,0,"mouseWhlEvent(QCString,int,int,int,int)","mouseWhlEvent(QCString,int,int,int,int)");
	disconnectDCOPSignal(0,0,"mouseDblClickEvent(QCString,int,int,int,int)","mouseDblClickEvent(QCString,int,int,int,int)");
}

bool VimDCOP::process(const QCString &fun, const QByteArray &data, QCString &replyType, QByteArray &/*replyData*/) {
	QCString sender;

	if (fun == "keyboardEvent(QCString,QCString,int,int)") {
		kdDebug() << "Process keyboardEvent" << endl;
		QDataStream arg(data, IO_ReadOnly);
		QCString string;
		int col,row;
		arg >> sender >> string >> row >> col;
		keyboardEvent(sender,string,col,row);
		replyType="void";
		return true;
	}
	if (fun == "mousePEvent(QCString,int,int,int,int)") {
		kdDebug() << "Process mousePEvent" << endl;
		QDataStream arg(data, IO_ReadOnly);
		int in1,in2,col,row;
		arg >> sender >> in1 >> in2 >> row >> col;
		mousePEvent(sender,in1,in2,col,row);
		replyType="void";
		return true;
	}
	if (fun == "mouseDblClickEvent(QCString,int,int,int,int)") {
		kdDebug() << "Process mouseDblClickEvent" << endl;
		QDataStream arg(data, IO_ReadOnly);
		int in1,in2,col,row;
		arg >> sender >> in1 >> in2 >> row >> col;
		mouseDblClickEvent(sender,in1,in2,col,row);
		replyType="void";
		return true;
	}
	if (fun == "mouseWhlEvent(QCString,int,int,int,int)") {
		kdDebug() << "Process mouseWhlEvent" << endl;
		QDataStream arg(data, IO_ReadOnly);
		int in1,in2, col, row;
		arg >> sender >> in1 >> in2 >> row >> col;
		mouseWhlEvent(sender,in1,in2,col,row);
		replyType="void";
		return true;
	}
	return false;
}

void VimDCOP::keyboardEvent(QCString sender, QCString string, int col, int row) {
	if (QString(sender) != mDoc->getServerName()) return;
	kdDebug() << "VimDCOP keyboardEvent" << endl;
	mDoc->keyboardEvent(string,col,row);
}

void VimDCOP::mousePEvent(QCString sender,int in1,int in2, int col, int row) {
	if (QString(sender) != mDoc->getServerName()) return;
	kdDebug() << "VimDCOP mousePEvent" << endl;
	mDoc->mousePEvent(in1,in2,col,row);
}

void VimDCOP::mouseWhlEvent(QCString sender,int in1,int in2, int col, int row) {
	if (QString(sender) != mDoc->getServerName()) return;
	kdDebug() << "VimDCOP mouseWhlEvent" << endl;
	mDoc->mouseWhlEvent(in1,in2,col,row);
}

void VimDCOP::mouseDblClickEvent(QCString sender,int in1,int in2,int col,int row) {
	if (QString(sender) != mDoc->getServerName()) return;
	kdDebug() << "VimDCOP mouseDblClickEvent" << endl;
	mDoc->mouseDblClickEvent(in1,in2,col,row);
}

