#
# System Makefile for:
#	UNIX and a Bourne Shell that does error-checking
#
#ifndef .MACHINE
#if exists(/usr/bin/arch)
.MACHINE != /usr/bin/arch
#elif exists(/usr/ucb/arch)
.MACHINE != /usr/ucb/arch
#elif exists(/bin/machine)
.MACHINE != /bin/machine
#elif exists(/bin/uname)
.MACHINE != /bin/uname -m
#elif exists(/NextApps)
.MACHINE = next
#endif
#
# Unless invoked with .MACHINE=, don't export to other hosts
#
.EXPORT: SAME
#endif .MACHINE

#ifdef .MACHINE
#include <sys-$(.MACHINE:S@/@-@g).mk>
#endif


.SUFFIXES : .out .a .ln .o .c .cc .F .f .e .r .y .l .s .cl .p .h .i \
	    .c,v .cc,v .y,v .l,v .s,v .h,v
.INCLUDES : .h
.LIBS	: .a

#ifdef SVR4
.SUFFIXES : .so
.LIBS   : .so
#endif


#
# Assume files without suffix are executables
#
#ifndef NONULL
.NULL	: .out
#endif

# Use absolute paths whenever possible. This greatly reduces server load
# once pmake has created parallel jobs all over the network ...
YACC	?= /usr/bin/yacc
YFLAGS	?=
LEX	?= /usr/bin/lex
LFLAGS	?=
CC	?= /bin/cc
CXX	?= CC
RM	?= /bin/rm -f
MV	?= /bin/mv
AS	?= /bin/as
PC	?= /usr/ucb/pc
PFLAGS	?=
CFLAGS	?=
CXXFLAGS?=
AFLAGS	?=
RC	?= /usr/bin/f77
RFLAGS	?=
FC	?= /usr/bin/f77
EFLAGS	?=
FFLAGS	?=
LOADLIBES ?=
CO	?= co
COFLAGS	?=
CI	?= ci
CIFLAGS	?=
AR	?= /bin/ar
ARFLAGS	?= r
#ifdef SYSV
RANLIB	?= /bin/true
#else
RANLIB	?= ranlib
#endif
LD	?= /bin/ld
LINT	?= /usr/bin/lint
MKDEP	?= makedepend

.c,v.c .y,v.y .l,v.l .s,v.s .h,v.h :
	$(CO) $(COFLAGS) $(.IMPSRC) $(.TARGET)

.c.o :
	$(CC) $(CFLAGS) -c $(.IMPSRC)

.cc.o :
	$(CXX) $(CXXFLAGS) -c $(.IMPSRC)

.p.o :
	$(PC) $(PFLAGS) -c $(.IMPSRC)

.cl.o :
	class -c $(.IMPSRC)

.e.o .r.o .F.o .f.o :
	$(FC) $(RFLAGS) $(EFLAGS) $(FFLAGS) -c $(.IMPSRC)

.s.o :
	$(AS) $(AFLAGS) -o $(.TARGET) $(.IMPSRC)

.y.o :
	$(YACC) $(YFLAGS) $(.IMPSRC)
	$(CC) $(CFLAGS) -c y.tab.c
	$(RM) y.tab.c
	$(MV) y.tab.o $(.TARGET)

.l.o :
	$(LEX) $(LFLAGS) $(.IMPSRC)
	$(CC) $(CFLAGS) -c lex.yy.c
	$(RM) lex.yy.c
	$(MV) lex.yy.o $(.TARGET)

.y.c :
	$(YACC) $(YFLAGS) $(.IMPSRC)
	$(MV) y.tab.c $(.TARGET)

.l.c :
	$(LEX) $(LFLAGS) $(.IMPSRC)
	$(MV) lex.yy.c $(.TARGET)

.s.out .c.out .o.out :
	$(CC) $(CFLAGS) $(.IMPSRC) $(LOADLIBES) -o $(.TARGET)

.f.out .F.out .r.out .e.out :
	$(FC) $(EFLAGS) $(RFLAGS) $(FFLAGS) $(.IMPSRC) \
		$(LOADLIBES) -o $(.TARGET)
	$(RM) $(.PREFIX:T).o

.y.out :
	$(YACC) $(YFLAGS) $(.IMPSRC)
	$(CC) $(CFLAGS) y.tab.c $(LOADLIBES) -ly -o $(.TARGET)
	$(RM) y.tab.c

.l.out :
	$(LEX) $(LFLAGS) $(.IMPSRC)
	$(CC) $(CFLAGS) lex.yy.c $(LOADLIBES) -ll -o $(.TARGET)
	$(RM) lex.yy.c

.c.i :
	$(CC) $(CFLAGS) -E $(.IMPSRC) > $(.TARGET)

#
# System search-path specifications.
#
.PATH.h: /usr/include
.PATH.a: /usr/local/lib /usr/lib
#ifdef SVR4
.PATH.so: /usr/local/lib /usr/lib
#endif

