This repository contains the crypto-policies data and scripts used in
Fedora.

|Release|Status|
|:-----:|:----:|
|master|[![build status](https://gitlab.com/redhat-crypto/fedora-crypto-policies/badges/master/pipeline.svg)](https://gitlab.com/redhat-crypto/fedora-crypto-policies/commits/master)|
|f32-updates|[![build status](https://gitlab.com/redhat-crypto/fedora-crypto-policies/badges/f32-updates/pipeline.svg)](https://gitlab.com/redhat-crypto/fedora-crypto-policies/commits/f32-updates)|
|rhel8|[![build status](https://gitlab.com/redhat-crypto/fedora-crypto-policies/badges/rhel8/pipeline.svg)](https://gitlab.com/redhat-crypto/fedora-crypto-policies/commits/rhel8)|

# Purpose

The purpose is to unify the crypto policies used by different applications
and libraries. That is allow setting a consistent security level for crypto
on all applications in a Fedora system, irrespective of the crypto library
in use.

# Description

The idea is to have few predefined security policies such as LEGACY, DEFAULT
and FUTURE which are set system-wide by the administrator. Then applications
that have no special needs will follow these policies by default. That
way the management of the various crypto applications and libraries used in a
system simplifies significantly.

The current implementations works by setting the desired policy in
/etc/crypto-policies/config. After this file is changed the script
'update-crypto-policies' should be executed, and the new policies
will activate.

The supported back ends in Fedora are:
 * GnuTLS
 * OpenSSL
 * NSS
 * BIND
 * libkrb5
 * OpenSSH
 * Java via OpenJDK
 * libssh

The documentation of crypto policies is at [update-crypto-policies.8.txt](update-crypto-policies.8.txt).

# Generating the policies

The policies are described in a simple policy language at `policies/POLICYFILE.pol`,
and they operate on strings defined at the beginning of `python/cryptopolicies.py`.
Individual application configuration generators are present in `python/policygenerators`.

To generate the policies per application use the script `python/build-crypto-policies.py
policydir DESTDIR` or `make install`.

For testing purpose the generated policies per application with the current
config are placed in `tests/outputs` and `make check` will verify whether the
generated policies match the stored. To reset the outputs use `make
reset-outputs` and `make check` to regenerate them.

# Contributing

See [our contribution guide](CONTRIBUTING.md).
