/*
 * Decompiled with CFR 0.152.
 */
package adql.parser.grammar;

import adql.parser.ADQLParser;
import adql.parser.ADQLQueryFactory;
import adql.parser.grammar.ADQLGrammar;
import adql.parser.grammar.ParseException;
import adql.parser.grammar.Token;
import adql.query.ADQLQuery;
import adql.query.TextPosition;
import java.io.InputStream;
import java.util.Stack;

public abstract class ADQLGrammarBase
implements ADQLGrammar {
    protected ADQLQueryFactory queryFactory = new ADQLQueryFactory();
    protected ADQLQuery query = null;
    protected Stack<ADQLQuery> stackQuery = new Stack();

    @Override
    public final ADQLQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    @Override
    public final void setQueryFactory(ADQLQueryFactory factory) throws NullPointerException {
        if (factory == null) {
            throw new NullPointerException("Missing new ADQLQueryFactory! An ADQLGrammar can not work without a query factory.");
        }
        this.queryFactory = factory;
    }

    @Override
    public final void reset(InputStream inputADQLExpression) throws Exception {
        if (inputADQLExpression == null) {
            throw new NullPointerException("Missing ADQL expression to parse!");
        }
        this.stackQuery.clear();
        this.ReInit(inputADQLExpression);
    }

    public abstract void ReInit(InputStream var1);

    @Override
    public final boolean isRegularIdentifier(String idCandidate) {
        return idCandidate != null && idCandidate.matches("[a-zA-Z]+[a-zA-Z0-9_]*");
    }

    @Override
    public final void testRegularIdentifier(Token token) throws ParseException {
        if (token == null) {
            throw new ParseException("Impossible to test whether NULL is a valid ADQL regular identifier!");
        }
        if (!this.isRegularIdentifier(token.image)) {
            String message = "Invalid ADQL regular identifier: \"" + token.image + "\"!";
            message = this.getVersion() == ADQLParser.ADQLVersion.V2_0 && token.image.matches("0[Xx][0-9a-fA-F]+") ? message + System.getProperty("line.separator", "\n") + "(HINT: hexadecimal values are not supported in ADQL-2.0. You should upgrade your ADQL parser to support at least ADQL-2.1.)" : message + System.getProperty("line.separator", "\n") + " (HINT: If it aims to be a column/table name/alias, you should write it between double quotes.)";
            throw new ParseException(message, new TextPosition(token));
        }
    }

    @Override
    public boolean isEnd(Token token) {
        return token == null || token.kind == 0 || token.kind == 7;
    }

    @Override
    public final ParseException generateParseException(Exception ex) {
        if (!(ex instanceof ParseException)) {
            ParseException pex = ex instanceof IllegalArgumentException ? new ParseException("Incorrect argument: " + ex.getMessage()) : new ParseException("[" + ex.getClass().getName() + "] " + ex.getMessage());
            pex.setStackTrace(ex.getStackTrace());
            return pex;
        }
        return (ParseException)ex;
    }
}

