/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLObject;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class CentroidFunction
extends GeometryFunction {
    public static final LanguageFeature FEATURE = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo", "CENTROID", true, "Compute the centroid of a given geometry and returns a POINT. Note: the CENTROID of a POINT is that POINT.");
    protected GeometryFunction.GeometryValue<GeometryFunction> parameter;

    public CentroidFunction(GeometryFunction.GeometryValue<GeometryFunction> param) throws NullPointerException {
        if (param == null) {
            throw new NullPointerException("The ADQL function CENTROID must have exactly one parameter!");
        }
        this.parameter = param;
    }

    public CentroidFunction(CentroidFunction toCopy) throws Exception {
        this.parameter = (GeometryFunction.GeometryValue)toCopy.parameter.getCopy();
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new CentroidFunction(this);
    }

    @Override
    public String getName() {
        return "CENTROID";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.parameter.getValue()};
    }

    @Override
    public int getNbParameters() {
        return 1;
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (index == 0) {
            return this.parameter.getValue();
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (index == 0) {
            ADQLOperand replaced = null;
            if (replacer == null) {
                throw new NullPointerException("Impossible to remove the only required parameter of the " + this.getName() + " function!");
            }
            if (replacer instanceof GeometryFunction.GeometryValue) {
                this.parameter = (GeometryFunction.GeometryValue)replacer;
            } else if (replacer instanceof ADQLColumn) {
                this.parameter.setColumn((ADQLColumn)replacer);
            } else if (replacer instanceof GeometryFunction) {
                this.parameter.setGeometry((GeometryFunction)replacer);
            } else {
                throw new Exception("Impossible to replace a GeometryValue/Column/GeometryFunction by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
            }
            this.setPosition(null);
            return replaced;
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
    }
}

