require "yaml"

# We are going to chdir in the so we need absolute paths for the libs
$:.collect! { |p| p.start_with?('debian/') ? File.expand_path(p) : p }

libs = []

%w{rspec spec-core rspec-expectations rspec-mocks rspec-support}.each do |x|
  libs << File.expand_path("debian/ruby-#{x}/usr/lib/ruby/vendor_ruby")
end

LIBS = %w{rspec-core rspec-expectations rspec-mocks rspec-support}

EXC_TESTS = [
  # require 'syntax' gem
  'spec/rspec/core/formatters/text_mate_formatter_spec.rb',
  'spec/rspec/core/formatters/html_formatter_spec.rb',
]

success=true

LIBS.each do |lib|
  fork do
    Dir.chdir(lib) do
      require "rspec/core"

      RSpec.configure do |c|
        c.libs= libs
      end
      exit(RSpec::Core::Runner.run( Dir["spec/rspec/**/*_spec.rb"] - EXC_TESTS + ["-I#{libs.join(':')}"], $stderr, $stdout))
    end
  end
  Process.wait
  #exit($?.exitstatus) if $?.exitstatus != 0
  success &= ($?.exitstatus == 0)
end

exit(1) unless success
