r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Twilio - Autopilot
    This is the public Twilio REST API.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""


from typing import Any, Dict, Optional, Union
from twilio.base import serialize, values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version


class DefaultsInstance(InstanceResource):

    """
    :ivar account_sid: The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Defaults resource.
    :ivar assistant_sid: The SID of the [Assistant](https://www.twilio.com/docs/autopilot/api/assistant) that is the parent of the resource.
    :ivar url: The absolute URL of the Defaults resource.
    :ivar data: The JSON string that describes the default task links for the `assistant_initiation`, `collect`, and `fallback` situations.
    """

    def __init__(self, version: Version, payload: Dict[str, Any], assistant_sid: str):
        super().__init__(version)

        self.account_sid: Optional[str] = payload.get("account_sid")
        self.assistant_sid: Optional[str] = payload.get("assistant_sid")
        self.url: Optional[str] = payload.get("url")
        self.data: Optional[Dict[str, object]] = payload.get("data")

        self._solution = {
            "assistant_sid": assistant_sid,
        }
        self._context: Optional[DefaultsContext] = None

    @property
    def _proxy(self) -> "DefaultsContext":
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions. All instance actions are proxied to the context

        :returns: DefaultsContext for this DefaultsInstance
        """
        if self._context is None:
            self._context = DefaultsContext(
                self._version,
                assistant_sid=self._solution["assistant_sid"],
            )
        return self._context

    def fetch(self) -> "DefaultsInstance":
        """
        Fetch the DefaultsInstance


        :returns: The fetched DefaultsInstance
        """
        return self._proxy.fetch()

    async def fetch_async(self) -> "DefaultsInstance":
        """
        Asynchronous coroutine to fetch the DefaultsInstance


        :returns: The fetched DefaultsInstance
        """
        return await self._proxy.fetch_async()

    def update(
        self, defaults: Union[object, object] = values.unset
    ) -> "DefaultsInstance":
        """
        Update the DefaultsInstance

        :param defaults: A JSON string that describes the default task links for the `assistant_initiation`, `collect`, and `fallback` situations.

        :returns: The updated DefaultsInstance
        """
        return self._proxy.update(
            defaults=defaults,
        )

    async def update_async(
        self, defaults: Union[object, object] = values.unset
    ) -> "DefaultsInstance":
        """
        Asynchronous coroutine to update the DefaultsInstance

        :param defaults: A JSON string that describes the default task links for the `assistant_initiation`, `collect`, and `fallback` situations.

        :returns: The updated DefaultsInstance
        """
        return await self._proxy.update_async(
            defaults=defaults,
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Autopilot.V1.DefaultsInstance {}>".format(context)


class DefaultsContext(InstanceContext):
    def __init__(self, version: Version, assistant_sid: str):
        """
        Initialize the DefaultsContext

        :param version: Version that contains the resource
        :param assistant_sid: The SID of the [Assistant](https://www.twilio.com/docs/autopilot/api/assistant) that is the parent of the resource to update.
        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "assistant_sid": assistant_sid,
        }
        self._uri = "/Assistants/{assistant_sid}/Defaults".format(**self._solution)

    def fetch(self) -> DefaultsInstance:
        """
        Fetch the DefaultsInstance


        :returns: The fetched DefaultsInstance
        """

        payload = self._version.fetch(
            method="GET",
            uri=self._uri,
        )

        return DefaultsInstance(
            self._version,
            payload,
            assistant_sid=self._solution["assistant_sid"],
        )

    async def fetch_async(self) -> DefaultsInstance:
        """
        Asynchronous coroutine to fetch the DefaultsInstance


        :returns: The fetched DefaultsInstance
        """

        payload = await self._version.fetch_async(
            method="GET",
            uri=self._uri,
        )

        return DefaultsInstance(
            self._version,
            payload,
            assistant_sid=self._solution["assistant_sid"],
        )

    def update(
        self, defaults: Union[object, object] = values.unset
    ) -> DefaultsInstance:
        """
        Update the DefaultsInstance

        :param defaults: A JSON string that describes the default task links for the `assistant_initiation`, `collect`, and `fallback` situations.

        :returns: The updated DefaultsInstance
        """
        data = values.of(
            {
                "Defaults": serialize.object(defaults),
            }
        )

        payload = self._version.update(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return DefaultsInstance(
            self._version, payload, assistant_sid=self._solution["assistant_sid"]
        )

    async def update_async(
        self, defaults: Union[object, object] = values.unset
    ) -> DefaultsInstance:
        """
        Asynchronous coroutine to update the DefaultsInstance

        :param defaults: A JSON string that describes the default task links for the `assistant_initiation`, `collect`, and `fallback` situations.

        :returns: The updated DefaultsInstance
        """
        data = values.of(
            {
                "Defaults": serialize.object(defaults),
            }
        )

        payload = await self._version.update_async(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return DefaultsInstance(
            self._version, payload, assistant_sid=self._solution["assistant_sid"]
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Autopilot.V1.DefaultsContext {}>".format(context)


class DefaultsList(ListResource):
    def __init__(self, version: Version, assistant_sid: str):
        """
        Initialize the DefaultsList

        :param version: Version that contains the resource
        :param assistant_sid: The SID of the [Assistant](https://www.twilio.com/docs/autopilot/api/assistant) that is the parent of the resource to fetch.

        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "assistant_sid": assistant_sid,
        }

    def get(self) -> DefaultsContext:
        """
        Constructs a DefaultsContext

        """
        return DefaultsContext(
            self._version, assistant_sid=self._solution["assistant_sid"]
        )

    def __call__(self) -> DefaultsContext:
        """
        Constructs a DefaultsContext

        """
        return DefaultsContext(
            self._version, assistant_sid=self._solution["assistant_sid"]
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Autopilot.V1.DefaultsList>"
