"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2018-2019 The OpenZipkin Authors

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the License
is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
or implied. See the License for the specific language governing permissions and limitations under
the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Span(google.protobuf.message.Message):
    """A span is a single-host view of an operation. A trace is a series of spans
    (often RPC calls) which nest to form a latency tree. Spans are in the same
    trace when they share the same trace ID. The parent_id field establishes the
    position of one span in the tree.

    The root span is where parent_id is Absent and usually has the longest
    duration in the trace. However, nested asynchronous work can materialize as
    child spans whose duration exceed the root span.

    Spans usually represent remote activity such as RPC calls, or messaging
    producers and consumers. However, they can also represent in-process
    activity in any position of the trace. For example, a root span could
    represent a server receiving an initial client request. A root span could
    also represent a scheduled job that has no remote context.

    Encoding notes:

    Epoch timestamp are encoded fixed64 as varint would also be 8 bytes, and more
    expensive to encode and size. Duration is stored uint64, as often the numbers
    are quite small.

    Default values are ok, as only natural numbers are used. For example, zero is
    an invalid timestamp and an invalid duration, false values for debug or shared
    are ignorable, and zero-length strings also coerce to null.

    The next id is 14.

    Note fields up to 15 take 1 byte to encode. Take care when adding new fields
    https://developers.google.com/protocol-buffers/docs/proto3#assigning-tags
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Kind:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _KindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Span._Kind.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SPAN_KIND_UNSPECIFIED: Span._Kind.ValueType  # 0
        """Default value interpreted as absent."""
        CLIENT: Span._Kind.ValueType  # 1
        """The span represents the client side of an RPC operation, implying the
        following:

        timestamp is the moment a request was sent to the server.
        duration is the delay until a response or an error was received.
        remote_endpoint is the server.
        """
        SERVER: Span._Kind.ValueType  # 2
        """The span represents the server side of an RPC operation, implying the
        following:

        timestamp is the moment a client request was received.
        duration is the delay until a response was sent or an error.
        remote_endpoint is the client.
        """
        PRODUCER: Span._Kind.ValueType  # 3
        """The span represents production of a message to a remote broker, implying
        the following:

        timestamp is the moment a message was sent to a destination.
        duration is the delay sending the message, such as batching.
        remote_endpoint is the broker.
        """
        CONSUMER: Span._Kind.ValueType  # 4
        """The span represents consumption of a message from a remote broker, not
        time spent servicing it. For example, a message processor would be an
        in-process child span of a consumer. Consumer spans imply the following:

        timestamp is the moment a message was received from an origin.
        duration is the delay consuming the message, such as from backlog.
        remote_endpoint is the broker.
        """

    class Kind(_Kind, metaclass=_KindEnumTypeWrapper):
        """When present, kind clarifies timestamp, duration and remote_endpoint. When
        absent, the span is local or incomplete. Unlike client and server, there
        is no direct critical path latency relationship between producer and
        consumer spans.
        """

    SPAN_KIND_UNSPECIFIED: Span.Kind.ValueType  # 0
    """Default value interpreted as absent."""
    CLIENT: Span.Kind.ValueType  # 1
    """The span represents the client side of an RPC operation, implying the
    following:

    timestamp is the moment a request was sent to the server.
    duration is the delay until a response or an error was received.
    remote_endpoint is the server.
    """
    SERVER: Span.Kind.ValueType  # 2
    """The span represents the server side of an RPC operation, implying the
    following:

    timestamp is the moment a client request was received.
    duration is the delay until a response was sent or an error.
    remote_endpoint is the client.
    """
    PRODUCER: Span.Kind.ValueType  # 3
    """The span represents production of a message to a remote broker, implying
    the following:

    timestamp is the moment a message was sent to a destination.
    duration is the delay sending the message, such as batching.
    remote_endpoint is the broker.
    """
    CONSUMER: Span.Kind.ValueType  # 4
    """The span represents consumption of a message from a remote broker, not
    time spent servicing it. For example, a message processor would be an
    in-process child span of a consumer. Consumer spans imply the following:

    timestamp is the moment a message was received from an origin.
    duration is the delay consuming the message, such as from backlog.
    remote_endpoint is the broker.
    """

    class TagsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TRACE_ID_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    KIND_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    LOCAL_ENDPOINT_FIELD_NUMBER: builtins.int
    REMOTE_ENDPOINT_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    DEBUG_FIELD_NUMBER: builtins.int
    SHARED_FIELD_NUMBER: builtins.int
    trace_id: builtins.bytes
    """Randomly generated, unique identifier for a trace, set on all spans within
    it.

    This field is required and encoded as 8 or 16 bytes, in big endian byte
    order.
    """
    parent_id: builtins.bytes
    """The parent span ID or absent if this the root span in a trace."""
    id: builtins.bytes
    """Unique identifier for this operation within the trace.

    This field is required and encoded as 8 opaque bytes.
    """
    kind: global___Span.Kind.ValueType
    """When present, used to interpret remote_endpoint"""
    name: builtins.str
    """The logical operation this span represents in lowercase (e.g. rpc method).
    Leave absent if unknown.

    As these are lookup labels, take care to ensure names are low cardinality.
    For example, do not embed variables into the name.
    """
    timestamp: builtins.int
    """Epoch microseconds of the start of this span, possibly absent if
    incomplete.

    For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC

    This value should be set directly by instrumentation, using the most
    precise value possible. For example, gettimeofday or multiplying epoch
    millis by 1000.

    There are three known edge-cases where this could be reported absent.
    - A span was allocated but never started (ex not yet received a timestamp)
    - The span's start event was lost
    - Data about a completed span (ex tags) were sent after the fact
    """
    duration: builtins.int
    """Duration in microseconds of the critical path, if known. Durations of less
    than one are rounded up. Duration of children can be longer than their
    parents due to asynchronous operations.

    For example 150 milliseconds is 150000 microseconds.
    """
    @property
    def local_endpoint(self) -> global___Endpoint:
        """The host that recorded this span, primarily for query by service name.

        Instrumentation should always record this. Usually, absent implies late
        data. The IP address corresponding to this is usually the site local or
        advertised service address. When present, the port indicates the listen
        port.
        """
    @property
    def remote_endpoint(self) -> global___Endpoint:
        """When an RPC (or messaging) span, indicates the other side of the
        connection.

        By recording the remote endpoint, your trace will contain network context
        even if the peer is not tracing. For example, you can record the IP from
        the "X-Forwarded-For" header or the service name and socket of a remote
        peer.
        """
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Annotation]:
        """Associates events that explain latency with the time they happened."""
    @property
    def tags(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Tags give your span context for search, viewing and analysis.

        For example, a key "your_app.version" would let you lookup traces by
        version. A tag "sql.query" isn't searchable, but it can help in debugging
        when viewing a trace.
        """
    debug: builtins.bool
    """True is a request to store this span even if it overrides sampling policy.

    This is true when the "X-B3-Flags" header has a value of 1.
    """
    shared: builtins.bool
    """True if we are contributing to a span started by another tracer (ex on a
    different host).
    """
    def __init__(
        self,
        *,
        trace_id: builtins.bytes = ...,
        parent_id: builtins.bytes = ...,
        id: builtins.bytes = ...,
        kind: global___Span.Kind.ValueType = ...,
        name: builtins.str = ...,
        timestamp: builtins.int = ...,
        duration: builtins.int = ...,
        local_endpoint: global___Endpoint | None = ...,
        remote_endpoint: global___Endpoint | None = ...,
        annotations: collections.abc.Iterable[global___Annotation] | None = ...,
        tags: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        debug: builtins.bool = ...,
        shared: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["local_endpoint", b"local_endpoint", "remote_endpoint", b"remote_endpoint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "debug", b"debug", "duration", b"duration", "id", b"id", "kind", b"kind", "local_endpoint", b"local_endpoint", "name", b"name", "parent_id", b"parent_id", "remote_endpoint", b"remote_endpoint", "shared", b"shared", "tags", b"tags", "timestamp", b"timestamp", "trace_id", b"trace_id"]) -> None: ...

global___Span = Span

class Endpoint(google.protobuf.message.Message):
    """The network context of a node in the service graph.

    The next id is 5.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SERVICE_NAME_FIELD_NUMBER: builtins.int
    IPV4_FIELD_NUMBER: builtins.int
    IPV6_FIELD_NUMBER: builtins.int
    PORT_FIELD_NUMBER: builtins.int
    service_name: builtins.str
    """Lower-case label of this node in the service graph, such as "favstar".
    Leave absent if unknown.

    This is a primary label for trace lookup and aggregation, so it should be
    intuitive and consistent. Many use a name from service discovery.
    """
    ipv4: builtins.bytes
    """4 byte representation of the primary IPv4 address associated with this
    connection. Absent if unknown.
    """
    ipv6: builtins.bytes
    """16 byte representation of the primary IPv6 address associated with this
    connection. Absent if unknown.

    Prefer using the ipv4 field for mapped addresses.
    """
    port: builtins.int
    """Depending on context, this could be a listen port or the client-side of a
    socket. Absent if unknown.
    """
    def __init__(
        self,
        *,
        service_name: builtins.str = ...,
        ipv4: builtins.bytes = ...,
        ipv6: builtins.bytes = ...,
        port: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["ipv4", b"ipv4", "ipv6", b"ipv6", "port", b"port", "service_name", b"service_name"]) -> None: ...

global___Endpoint = Endpoint

class Annotation(google.protobuf.message.Message):
    """Associates an event that explains latency with a timestamp.
    Unlike log statements, annotations are often codes. Ex. "ws" for WireSend

    The next id is 3.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Epoch microseconds of this event.

    For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC

    This value should be set directly by instrumentation, using the most
    precise value possible. For example, gettimeofday or multiplying epoch
    millis by 1000.
    """
    value: builtins.str
    """Usually a short tag indicating an event, like "error"

    While possible to add larger data, such as garbage collection details, low
    cardinality event names both keep the size of spans down and also are easy
    to search against.
    """
    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["timestamp", b"timestamp", "value", b"value"]) -> None: ...

global___Annotation = Annotation

class ListOfSpans(google.protobuf.message.Message):
    """A list of spans with possibly different trace ids, in no particular order.

    This is used for all transports: POST, Kafka messages etc. No other fields
    are expected, This message facilitates the mechanics of encoding a list, as
    a field number is required. The name of this type is the same in the OpenApi
    aka Swagger specification. https://zipkin.io/zipkin-api/#/default/post_spans
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPANS_FIELD_NUMBER: builtins.int
    @property
    def spans(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Span]: ...
    def __init__(
        self,
        *,
        spans: collections.abc.Iterable[global___Span] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["spans", b"spans"]) -> None: ...

global___ListOfSpans = ListOfSpans

class ReportResponse(google.protobuf.message.Message):
    """Response for SpanService/Report RPC. This response currently does not return
    any information beyond indicating that the request has finished. That said,
    it may be extended in the future.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ReportResponse = ReportResponse
