# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network.aio import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementNetworkManagersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_network_managers_get(self, resource_group):
        response = await self.client.network_managers.get(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_network_managers_create_or_update(self, resource_group):
        response = await self.client.network_managers.create_or_update(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            parameters={
                "description": "str",
                "etag": "str",
                "id": "str",
                "location": "str",
                "name": "str",
                "networkManagerScopeAccesses": ["str"],
                "networkManagerScopes": {
                    "crossTenantScopes": [{"managementGroups": ["str"], "subscriptions": ["str"], "tenantId": "str"}],
                    "managementGroups": ["str"],
                    "subscriptions": ["str"],
                },
                "provisioningState": "str",
                "resourceGuid": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_network_managers_begin_delete(self, resource_group):
        response = await (
            await self.client.network_managers.begin_delete(
                resource_group_name=resource_group.name,
                network_manager_name="str",
                api_version="2024-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_network_managers_patch(self, resource_group):
        response = await self.client.network_managers.patch(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_network_managers_list_by_subscription(self, resource_group):
        response = self.client.network_managers.list_by_subscription(
            api_version="2024-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_network_managers_list(self, resource_group):
        response = self.client.network_managers.list(
            resource_group_name=resource_group.name,
            api_version="2024-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
