# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CheckNameAvailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible reasons for a name not being available."""

    INVALID = "Invalid"
    """Name is invalid."""
    ALREADY_EXISTS = "AlreadyExists"
    """Name already exists."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class CreateMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode that the Mongo Cluster is created with."""

    DEFAULT = "Default"
    """Create a new mongo cluster."""
    POINT_IN_TIME_RESTORE = "PointInTimeRestore"
    """Create a mongo cluster from a restore point-in-time."""
    GEO_REPLICA = "GeoReplica"
    """Create a replica cluster in distinct geographic region from the source cluster."""
    REPLICA = "Replica"
    """Create a replica cluster in the same geographic region as the source cluster."""


class HighAvailabilityMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The high availability modes for a cluster."""

    DISABLED = "Disabled"
    """High availability mode is disabled. This mode is can see availability impact during faults or
    maintenance and is not recommended for production."""
    SAME_ZONE = "SameZone"
    """High availability mode is enabled, where each server in a shard is placed in the same
    availability zone."""
    ZONE_REDUNDANT_PREFERRED = "ZoneRedundantPreferred"
    """High availability mode is enabled and preferences ZoneRedundant if availability zones capacity
    is available in the region, otherwise falls-back to provisioning with SameZone."""


class MongoClusterStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the Mongo cluster resource."""

    READY = "Ready"
    """The mongo cluster resource is ready for use."""
    PROVISIONING = "Provisioning"
    """The mongo cluster resource is being provisioned."""
    UPDATING = "Updating"
    """The mongo cluster resource is being updated."""
    STARTING = "Starting"
    """The mongo cluster resource is being started."""
    STOPPING = "Stopping"
    """The mongo cluster resource is being stopped."""
    STOPPED = "Stopped"
    """The mongo cluster resource is stopped."""
    DROPPING = "Dropping"
    """The mongo cluster resource is being dropped."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PreviewFeature(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Preview features that can be enabled on a mongo cluster."""

    GEO_REPLICAS = "GeoReplicas"
    """Enables geo replicas preview feature. The feature must be set at create-time on new cluster to
    enable linking a geo-replica cluster to it."""


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    """Connection has been provisioned"""
    CREATING = "Creating"
    """Connection is being created"""
    DELETING = "Deleting"
    """Connection is being deleted"""
    FAILED = "Failed"
    """Connection provisioning has failed"""


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    """Connectionaiting for approval or rejection"""
    APPROVED = "Approved"
    """Connection approved"""
    REJECTED = "Rejected"
    """Connection Rejected"""


class PromoteMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode to apply to a promote operation."""

    SWITCHOVER = "Switchover"
    """Promotion will switch the current replica cluster to the primary role and the original primary
    will be switched to a replica role, maintaining the replication link."""


class PromoteOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The option to apply to a promote operation."""

    FORCED = "Forced"
    """Promote option forces the promotion without waiting for the replica to be caught up to the
    primary. This can result in data-loss so should only be used during disaster recovery
    scenarios."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the last accepted operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    IN_PROGRESS = "InProgress"
    """An operation is in-progress on the resource."""
    UPDATING = "Updating"
    """An update operation is in-progress on the resource."""
    DROPPING = "Dropping"
    """A drop operation is in-progress on the resource."""


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether or not public endpoint access is allowed for this Mongo cluster.  Value is optional and
    default value is 'Enabled'.
    """

    ENABLED = "Enabled"
    """If set, mongo cluster can be accessed through private and public methods."""
    DISABLED = "Disabled"
    """If set, the private endpoints are the exclusive access method."""


class ReplicationRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Replication role of the mongo cluster."""

    PRIMARY = "Primary"
    """The cluster is a primary replica."""
    ASYNC_REPLICA = "AsyncReplica"
    """The cluster is a local asynchronous replica."""
    GEO_ASYNC_REPLICA = "GeoAsyncReplica"
    """The cluster is a geo-asynchronous replica."""


class ReplicationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the replication link between the replica and source cluster."""

    ACTIVE = "Active"
    """Replication link is active."""
    CATCHUP = "Catchup"
    """Replica is catching-up with the primary. This can occur after the replica is created or after a
    promotion is triggered."""
    PROVISIONING = "Provisioning"
    """Replica and replication link to the primary is being created."""
    UPDATING = "Updating"
    """Replication link is being updated due to a change on the replica or an upgrade."""
    BROKEN = "Broken"
    """Replication link is broken and the replica may need to be recreated."""
    RECONFIGURING = "Reconfiguring"
    """Replication link is re-configuring due to a promotion event."""
