# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackendProxyContract(Model):
    """Details of the Backend WebProxy Server to use in the Request to Backend.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. WebProxy Server AbsoluteUri property which includes
     the entire URI stored in the Uri instance, including all fragments and
     query strings.
    :type url: str
    :param username: Username to connect to the WebProxy server
    :type username: str
    :param password: Password to connect to the WebProxy Server
    :type password: str
    """

    _validation = {
        'url': {'required': True, 'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BackendProxyContract, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
