# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClusterUpgradePolicy(Model):
    """Cluster upgrade policy.

    :param override_user_upgrade_policy: Use the user defined upgrade policy
     or not
    :type override_user_upgrade_policy: bool
    :param force_restart: Force node to restart or not
    :type force_restart: bool
    :param upgrade_replica_set_check_timeout: Timeout for replica set upgrade
     to complete,it represents .Net TimeSpan
    :type upgrade_replica_set_check_timeout: str
    :param health_check_wait_duration: The length of time to wait after
     completing an upgrade domain before performing health checks, it
     represents .Net TimeSpan
    :type health_check_wait_duration: str
    :param health_check_stable_duration: The length of time that health checks
     must pass continuously,it represents .Net TimeSpan
    :type health_check_stable_duration: str
    :param health_check_retry_timeout: The length of time that health checks
     can fail continuously,it represents .Net TimeSpan
    :type health_check_retry_timeout: str
    :param upgrade_timeout: The upgrade timeout,it represents .Net TimeSpan
    :type upgrade_timeout: str
    :param upgrade_domain_timeout: The timeout for any upgrade domain,it
     represents .Net TimeSpan
    :type upgrade_domain_timeout: str
    :param health_policy: Cluster health Policy
    :type health_policy: :class:`ClusterHealthPolicy
     <azure.mgmt.servicefabric.models.ClusterHealthPolicy>`
    :param delta_health_policy: Delta health policy
    :type delta_health_policy: :class:`ClusterUpgradeDeltaHealthPolicy
     <azure.mgmt.servicefabric.models.ClusterUpgradeDeltaHealthPolicy>`
    """

    _validation = {
        'upgrade_replica_set_check_timeout': {'required': True},
        'health_check_wait_duration': {'required': True},
        'health_check_stable_duration': {'required': True},
        'health_check_retry_timeout': {'required': True},
        'upgrade_timeout': {'required': True},
        'upgrade_domain_timeout': {'required': True},
        'health_policy': {'required': True},
    }

    _attribute_map = {
        'override_user_upgrade_policy': {'key': 'overrideUserUpgradePolicy', 'type': 'bool'},
        'force_restart': {'key': 'forceRestart', 'type': 'bool'},
        'upgrade_replica_set_check_timeout': {'key': 'upgradeReplicaSetCheckTimeout', 'type': 'str'},
        'health_check_wait_duration': {'key': 'healthCheckWaitDuration', 'type': 'str'},
        'health_check_stable_duration': {'key': 'healthCheckStableDuration', 'type': 'str'},
        'health_check_retry_timeout': {'key': 'healthCheckRetryTimeout', 'type': 'str'},
        'upgrade_timeout': {'key': 'upgradeTimeout', 'type': 'str'},
        'upgrade_domain_timeout': {'key': 'upgradeDomainTimeout', 'type': 'str'},
        'health_policy': {'key': 'healthPolicy', 'type': 'ClusterHealthPolicy'},
        'delta_health_policy': {'key': 'deltaHealthPolicy', 'type': 'ClusterUpgradeDeltaHealthPolicy'},
    }

    def __init__(self, upgrade_replica_set_check_timeout, health_check_wait_duration, health_check_stable_duration, health_check_retry_timeout, upgrade_timeout, upgrade_domain_timeout, health_policy, override_user_upgrade_policy=None, force_restart=None, delta_health_policy=None):
        self.override_user_upgrade_policy = override_user_upgrade_policy
        self.force_restart = force_restart
        self.upgrade_replica_set_check_timeout = upgrade_replica_set_check_timeout
        self.health_check_wait_duration = health_check_wait_duration
        self.health_check_stable_duration = health_check_stable_duration
        self.health_check_retry_timeout = health_check_retry_timeout
        self.upgrade_timeout = upgrade_timeout
        self.upgrade_domain_timeout = upgrade_domain_timeout
        self.health_policy = health_policy
        self.delta_health_policy = delta_health_policy
