# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DeepCreatedOrigin(Model):
    """Origin to be added when creating a CDN endpoint.

    :param name: Origin name
    :type name: str
    :param host_name: The address of the origin. It can be a domain names,
     IPv4 address, or IPv6 address.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and
     65535
    :type https_port: int
    """

    _validation = {
        'name': {'required': True},
        'host_name': {'required': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
    }

    def __init__(self, name, host_name, http_port=None, https_port=None):
        self.name = name
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
