# Generated: 2011-12-19
# doi:10.1063/1.2162161, experimental geometries if available, dimers only
from numpy import array, nan
data = {
    'H': {'charges': None,
          'database': 'TMFP06D',
          'magmoms': [1.0],
          'name': 'H',
          'positions': array([[ 0.,  0.,  0.]]),
          'symbols': 'H'},
    'N': {'charges': None,
          'database': 'TMFP06D',
          'magmoms': [3.0],
          'name': 'N',
          'positions': array([[ 0.,  0.,  0.]]),
          'symbols': 'N'},
    'O': {'charges': None,
          'database': 'TMFP06D',
          'magmoms': [2.0],
          'name': 'O',
          'positions': array([[ 0.,  0.,  0.]]),
          'symbols': 'O'},
    'F': {'charges': None,
          'database': 'TMFP06D',
          'magmoms': [1.0],
          'name': 'F',
          'positions': array([[ 0.,  0.,  0.]]),
          'symbols': 'F'},
    #
    'K': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [1.0],
           'name': 'K',
           'positions': array([[ 0.,  0.,  0.]]),
           'symbols': 'K'},
    'Ca': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0],
           'name': 'Ca',
           'positions': array([[ 0.,  0.,  0.]]),
           'symbols': 'Ca'},
    'Sc': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [1.0],
           'name': 'Sc',
           'positions': array([[ 0.,  0.,  0.]]),
           'symbols': 'Sc'},
    'Ti': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [2.0],
           'name': 'Ti',
           'positions': array([[ 0.,  0.,  0.]]),
           'symbols': 'Ti'},
    'V': {'charges': None,
          'database': 'TMFP06D',
          'magmoms': [3.0],
          'name': 'V',
          'positions': array([[ 0.,  0.,  0.]]),
          'symbols': 'V'},
    'Cr': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [6.0],
           'name': 'Cr',
           'positions': array([[ 0.,  0.,  0.]]),
           'symbols': 'Cr'},
    'Mn': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [5.0],
           'name': 'Mn',
           'positions': array([[ 0.,  0.,  0.]]),
           'symbols': 'Mn'},
    'Fe': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [4.0],
           'name': 'Fe',
           'positions': array([[ 0.,  0.,  0.]]),
           'symbols': 'Fe'},
    'Co': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [3.0],
           'name': 'Co',
           'positions': array([[ 0.,  0.,  0.]]),
           'symbols': 'Co'},
    'Ni': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [2.0],
           'name': 'Ni',
           'positions': array([[ 0.,  0.,  0.]]),
           'symbols': 'Ni'},
    'Cu': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [1.0],
           'name': 'Cu',
           'positions': array([[ 0.,  0.,  0.]]),
           'symbols': 'Cu'},
    'Zn': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0],
           'name': 'Zn',
           'positions': array([[ 0.,  0.,  0.]]),
           'symbols': 'Zn'},
    #
    'K2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'K2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  3.905],
                              ]),
           'dissociation energy': 12.0,
           'harmonic frequency': 92,
           'symbols': 'KK'},
    'Ca2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'Ca2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  4.277],
                              ]),
           'dissociation energy': 3.1,
           'harmonic frequency': 65,
           'symbols': 'CaCa'},
    'Sc2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [2.0, 2.0],
           'name': 'Sc2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  2.74], # from 10.1063/1.480546 (MRSDQCI)
                              ]),
           'dissociation energy': 38.4,
           'harmonic frequency': 239,
           'symbols': 'ScSc'},
    'Ti2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [1.0, 1.0],
           'name': 'Ti2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.943],
                              ]),
           'dissociation energy': 36.1,
           'harmonic frequency': 408,
           'symbols': 'TiTi'},
    'V2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [1.0, 1.0],
           'name': 'V2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.77], # ref. a
                              ]),
           'dissociation energy': 64.3,
           'harmonic frequency': 538,
           'symbols': 'VV'},
    'Cr2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'Cr2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.679],
                              ]),
           'dissociation energy': 33.9,
           'harmonic frequency': 481,
           'symbols': 'CrCr'},
    'Mn2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [5.0, 5.0],
           'name': 'Mn2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  3.40],
                              ]),
           'dissociation energy': 18.8,
           'harmonic frequency': 340,
           'symbols': 'MnMn'},
    'Fe2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [3.0, 3.0],
           'name': 'Fe2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  2.02],
                              ]),
           'dissociation energy': 26.9,
           'harmonic frequency': 300,
           'symbols': 'FeFe'},
    # exp. geometry not given in ref.
    'Co2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [2.0, 2.0],
           'name': 'Co2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.98], # calculated doi:10.1063/1.1788656
                              ]),
           'dissociation energy': 39.4,
           'harmonic frequency': 297,
           'symbols': 'CoCo'},
    'Ni2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [1.0, 1.0],
           'name': 'Ni2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  2.155],
                              ]),
           'dissociation energy': 48.1,
           'harmonic frequency': 259,
           'symbols': 'NiNi'},
    'Cu2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'Cu2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  2.219],
                              ]),
           'dissociation energy': 46.7,
           'harmonic frequency': 266,
           'symbols': 'CuCu'},
    'Zn2': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'Zn2',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  2.35], # ref. j
                              ]),
           'dissociation energy': 0.80,
           'harmonic frequency': 25.9,
           'symbols': 'ZnZn'},
    #
    'KH': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'KH',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  2.243],
                              ]),
           'dissociation energy': 42.2,
           'harmonic frequency': 707,
           'symbols': 'KH'},
    'CaH': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.7, 0.3],
           'name': 'CaH',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  2.003],
                              ]),
           'dissociation energy': 41.0,
           'harmonic frequency': 1298,
           'symbols': 'CaH'},
    # exp. geometry not given in ref.
    'ScH': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'ScH',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.775], # doi: 10.1063/1.3489110
                              ]),
           'dissociation energy': 47.5,
           'harmonic frequency': nan,
           'symbols': 'ScH'},
    'TiH': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [2.9, 0.1],
           'name': 'TiH',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.779],
                              ]),
           'dissociation energy': 50.0,
           'harmonic frequency': 1405,
           'symbols': 'TiH'},
    'CrH': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [4.9, 0.1],
           'name': 'CrH',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.656],
                              ]),
           'dissociation energy': 46.8,
           'harmonic frequency': 1581,
           'symbols': 'CrH'},
    'MnH': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [5.9, 0.1],
           'name': 'MnH',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.731],
                              ]),
           'dissociation energy': 31.1,
           'harmonic frequency': 1548,
           'symbols': 'MnH'},
    'FeH': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [2.9, 0.1],
           'name': 'FeH',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.589],
                              ]),
           'dissociation energy': 39.2,
           'harmonic frequency': 1827,
           'symbols': 'FeH'},
    'CoH': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [1.9, 0.1],
           'name': 'CoH',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.52],
                              ]),
           'dissociation energy': 48.4,
           'harmonic frequency': 1925,
           'symbols': 'CoH'},
    'NiH': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.9, 0.1],
           'name': 'NiH',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.475],
                              ]),
           'dissociation energy': 61.3,
           'harmonic frequency': 1927,
           'symbols': 'NiH'},
    'CuH': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'CuH',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.463],
                              ]),
           'dissociation energy': 63.4,
           'harmonic frequency': 1941,
           'symbols': 'CuH'},
    #
    'ScN': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'ScN',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.687],
                              ]),
           'dissociation energy': 113,
           'harmonic frequency': 795,
           'symbols': 'ScN'},
    'TiN': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.9, 0.1],
           'name': 'TiN',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.57],
                              ]),
           'dissociation energy': 124,
           'harmonic frequency': 1033,
           'symbols': 'TiN'},
    'VN': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [1.9, 0.1],
           'name': 'VN',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.57],
                              ]),
           'dissociation energy': 117,
           'harmonic frequency': 1033,
           'symbols': 'VN'},
    'CrN': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [2.9, 0.1],
           'name': 'CrN',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.563],
                              ]),
           'dissociation energy': 97,
           'harmonic frequency': 1050,
           'symbols': 'CrN'},
    #
    'CaO': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'CaO',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.822],
                              ]),
           'dissociation energy': 110.8,
           'harmonic frequency': 732,
            'symbols': 'CaO'},
    'ScO': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.9, 0.1],
           'name': 'ScO',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.668],
                              ]),
           'dissociation energy': 163.0,
           'harmonic frequency': 965,
            'symbols': 'ScO'},
    'TiO': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [1.9, 0.1],
           'name': 'TiO',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.620],
                              ]),
           'dissociation energy': 161.0,
           'harmonic frequency': 1009,
            'symbols': 'TiO'},
    'VO': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [2.9, 0.1],
           'name': 'VO',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.589],
                              ]),
           'dissociation energy': 150.0,
           'harmonic frequency': 1011,
            'symbols': 'VO'},
    'CrO': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [3.9, 0.1],
           'name': 'CrO',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.615],
                              ]),
           'dissociation energy': 103.0,
           'harmonic frequency': 898,
            'symbols': 'CrO'},
    'MnO': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [4.9, 0.1],
           'name': 'MnO',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.646],
                              ]),
           'dissociation energy': 89.5,
           'harmonic frequency': 840,
            'symbols': 'MnO'},
    'FeO': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [3.9, 0.1],
           'name': 'FeO',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.616],
                              ]),
           'dissociation energy': 97.4,
           'harmonic frequency': 880,
            'symbols': 'FeO'},
    'CoO': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [2.5, 0.5],
           'name': 'CoO',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.629],
                              ]),
           'dissociation energy': 92.1,
           'harmonic frequency': 853,
            'symbols': 'CoO'},
    'NiO': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [1.0, 1.0],
           'name': 'NiO',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.627],
                              ]),
           'dissociation energy': 90.4,
           'harmonic frequency': 838,
            'symbols': 'NiO'},
    'CuO': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.5, 0.5],
           'name': 'CuO',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.724],
                              ]),
           'dissociation energy': 66.6,
           'harmonic frequency': 640,
            'symbols': 'CuO'},
    # ZnO not in ref. Taken for completeness from doi: 10.1063/1.3489110
    'ZnO': {'charges': None,
           'database': 'TMKM11',
           'magmoms': [0.0, 0.0],
           'name': 'ZnO',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.724],
                              ]),
           'dissociation energy': nan,
           'harmonic frequency': nan,
           'symbols': 'ZnO'},
    #
    'KF': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'KF',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  2.171],
                              ]),
           'dissociation energy': 117.5,
           'harmonic frequency': 428,
            'symbols': 'KF'},
    'CaF': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.9, 0.1],
           'name': 'CaF',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.967],
                              ]),
           'dissociation energy': 127.2,
           'harmonic frequency': 581,
            'symbols': 'CaF'},
    'ScF': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'ScF',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.788],
                              ]),
           'dissociation energy': 143.3,
           'harmonic frequency': 736,
            'symbols': 'ScF'},
    'TiF': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [2.9, 0.1],
           'name': 'TiF',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.834],
                              ]),
           'dissociation energy': 137,
           'harmonic frequency': nan,
            'symbols': 'TiF'},
    'CrF': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [4.9, 0.1],
           'name': 'CrF',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.784],
                              ]),
           'dissociation energy': 106.3,
           'harmonic frequency': 664,
            'symbols': 'CrF'},
    'FeF': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [4.9, 0.1],
           'name': 'FeF',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.780],
                              ]),
           'dissociation energy': nan,
           'harmonic frequency': 663,
            'symbols': 'FeF'},
    'CuF': {'charges': None,
           'database': 'TMFP06D',
           'magmoms': [0.0, 0.0],
           'name': 'CuF',
           'positions': array([
                              [ 0.,  0.,  0.],
                              [ 0.,  0.,  1.745],
                              ]),
           'dissociation energy': 102.8,
           'harmonic frequency': 623,
            'symbols': 'CuF'},
    }
