# Node Foundation CTC Meeting 2015-10-28

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/ctc-meeting-2015-10-28
* **GitHub Issue**: https://github.com/nodejs/node/issues/3561
* **Minutes Google Doc**: <https://docs.google.com/document/d/1GsTF3no6bimA20hi9i5aTBudBSM8jzPvuODR01hOltc>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1ad8Xlza_B-iWexdlAd1Z5muzBy_HH88t_iSD31OUepA>_

## Present

* Rod Vagg (CTC)
* Brian White (CTC)
* James Snell (CTC)
* Chris Dickinson (CTC)
* Ben Noordhuis (CTC)
* Jeremiah Senkpiel (CTC)
* Trevor Norris (CTC)
* Alexis Campailla (CTC)
* Mikeal Rogers (observer)
* Shigeki Ohtsu (CTC)
* Seth Thompson (observer)
* Bert Belder (CTC)
* Fedor Indutny (CTC)
* Ben Noordhuis (CTC)
* Colin Ihrig (CTC)

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests in the nodejs org prior to meeting.

### nodejs/node

* Load JSON-LD in the same way as JSON [#3502](https://github.com/nodejs/node/pull/3502)
* fs: decode filenames using UTF-8 in fs.watch [#3401](https://github.com/nodejs/node/pull/3401)
* WG: Considering a new HTTP WG [#3214](https://github.com/nodejs/node/issues/3214)

## Minutes

### Review of previous meeting

* governance: add new collaborators #VIII [#3472](https://github.com/nodejs/node/issues/3472)
* detect "full-icu" module [#3460](https://github.com/nodejs/node/issues/3460)
* WG: Considering a new HTTP WG [#3214](https://github.com/nodejs/node/issues/3214)
* node: deprecate public access to `process.binding` [#2768](https://github.com/nodejs/node/pull/2768)
* node: make listen address configurable [#3316](https://github.com/nodejs/node/pull/3316)

### Standup

* Rod Vagg (CTC): Traveling, rc for v5.x, going to put another rc out today, comfortable with it getting released tomorrow. If it slips we’ll put it off until next week. Just need to do more smoke testing on this.
* Brian White (CTC): Not a whole lot this week — triaging, responding to issues.
* James Snell (CTC): Getting HTTP parser up to v2.6; getting 4.2.2 LTS update ready to go. open issue on LTS repo, would love eyes on it, to verify that the commits going into 4.2.2 look good. (https://github.com/nodejs/LTS/issues/50) working with Miles on getting CITGM updated.
* Chris Dickinson (CTC): Some silly build stuff
* Jeremiah Senkpiel (CTC): Not much — computer was dead since last Friday, ): but repaired now.
* Trevor Norris (CTC): Bugs and issues — couple of outstanding PRs around asyncwrap, one done at Fedor’s request to make AsyncWrap public, in order to make JSStream class public
* Alexis Campailla (CTC): Meetings; first API WG meeting, defining scope of the work for the WG, we want to address engine abstraction and native module API and some performance issues; small work in CI to add diagnostics; progress on module build service, going to post finding soon to get feedback
* Mikeal Rogers (observer): getting a lot of interest on a certification program for node, for alternative implementations, looking at notes for API WG (thanks for taking great notes! that was awesome) I reached out to a few people that may contribute as well
* Seth Thompson (observer): No updates this week.
* Bert Belder (CTC): nothing noteworthy
* Ben Noordhuis (CTC): Fixed debugger bugs, reviewed a lot of pull requests.
* Colin Ihrig (CTC): Trying to help out with issue tracker, anticipate in another week ½ I should have significantly more time to work on core.

### Load JSON-LD in the same way as JSON [#3502](https://github.com/nodejs/node/pull/3502)

* adds .jsonld files to require.extensions so that they’d load using json loader

Rod: I raised this to CTC. I see this as a slippery slope, adding anything more to require.extensions. I don’t see how this won’t turn into XML — turns into bloat in formats that folks want to support. My preference would be to let the ecosystem figure this out and let folks write their own JSON loaders.

Jeremiah: also probably belongs in npm

James: .jsonld is just a json file with a special syntax internally. I have a module that loads it. It’s very easy to work around. Rename the file to use a json extension. I don’t see the harm in landing it, but if we don’t want to go that route,

Mikeal: is the patch to add the extension or to give you your own serializer (extension)

Bert: It seems harmless, but 6 months from now what if someone shows up and says “hey you’re not validating it properly” and then we have to add a validator … I’m very sensitive to slippery slope argument

Alexis: Is it a different syntax?

Bert: is every json document a valid jsonld document?

James: no.

Mikeal: we’re using a parser from npm, are we going to get a war between parsers, swapping them out?

James: this doesn’t do any special parsing for jsonld, it just aliases json and uses the existing process.

Trevor: the problem is what it opens us up to. invariably this leads to more PRs. this patch I don’t have a problem with, but I have a problem with this kind of patch in the future

Bert: I think we’re reaching consensus here, which is: reject this patch. is anyone here strongly in favor.

Ben: not in favor. one argument is jsonld is now a standard. but I too am sensitive to the slippery slope argument, so I’m perfectly fine with rejecting it.

James: when rejecting it, it would be worthwhile to note how to work around it. I can do this.

Jeremiah: require.extensions is not going to change anytime soon, so folks can write their own.

Bert: I think we can go to the next issue.

### fs: decode filenames using UTF-8 in fs.watch [#3401](https://github.com/nodejs/node/pull/3401)

See also [#3519](https://github.com/nodejs/node/issues/3519)

Bert: this is Ben’s issue.

Ben: I wouldn’t say it’s my issue, but I’ve been involved
the thing is that filenames are frequently (but not always) utf8, the problem is now that node in one or two places it doesn’t encode utf8 [Ben, post meeting addition: For background: I thought we had some file logic baked into node::Environment and the dtrace/etw/lttng/systemtap subsystems but turns out that's not the case.]

Bert: where else are we encoding differently?

Ben: I can answer this in a few seconds. At least, I think there are more places. Maybe I’m mistaken, also a possibility!

Jeremiah: I think someone else said it was only fs.watch too.

Bert: I’ve seen the discussion but I haven’t commented. I think there’s a problem with assuming that all files are all utf8, but it seems inconsequential to assume this everywhere but this one place

Ben: this is not the best issue to link to, I agree it’s inconsistent to do utf8 in most places and latin1 in only one place. There’s a link to another issue 3519. my beef with the PR is not that it’s a terrible fix, it’s more that decoding to utf8 is not always the right thing to do because not all fs are utf-8. If we’re going to do this it has to be a semver major, and if we’re going to do a semver major, then it may as well be a full fix, which I’ve outlined in 3519.

Bert: there’s actually some discussions we need to have around these things. Your suggestion is to not land this PR, and instead fix this the right way. Do you think it’s likely that 3519 will see attention any time soon?

Ben: It’s on my todo list. I should mention that the way node deals with file names has been a thorn in my side for a long time now, I’ve been planning to do something about it for a long time, so take this as you will.

Bert: my question is: do we take this PR now, ahead of

Bert: customizable decoding

Mikeal: is the other one going to be a breaking change?

Ben: yes

Bert: or it could be a bugfix?

Mikeal: so it would make sense to buffer as many changes around that as possible.

Jeremiah: we could land the semver-major fix on master which would go into 6.x, then if we have time before 6.x we could do the proper fix. maybe that keeps us from fixing it entirely though?

Ben: that’s my problem, it’s a bandaid that lets us truck on for a another couple of years.

James?: I don’t really like quick fixes, but …

Trevor: on the fs doc page, a lot of those calls reference the system level call, on unix do those use utf8

Ben: how do you mean?

Trevor: for example, stat, first arg is char* pathname, if i were to take a utf8 string and read that in… what encoding does it use?

Ben: syscall is agnostic. kernel treats as string of bytes. in node, we call fs.stat in javascript, string is decoded to utf8, then passed on to the kernel.

Trevor: if i have a file that’s latin1, I’d have to turn that into a buffer as a binary buffer then tostring it to a utf8 string in order for the file to be open?

[multiple people are talking]

Ben: yes.

Ben: sometimes it’s not possible to open files with funny characters in their names.

Trevor: if there were a file with invalid utf8 characters it’d be impossible to open those, right?

Ben: yep.

James: I’m not a fan of the quick fix. I am okay with incremental so long as the larger task gets done, but …

Bert: I am in favor of the quick fix, it restores consistency in the way node does things. practically speaking, almost all fs are going to be utf-8. it fixes the problem where fs.watch tells you “hey a file changed” but you go to look and the file’s not there due to the encoding scheme. I’d like to make a little improvement. the problem has been known since at least 2011, and we’ve never gotten around to it. I would not be surprised if it takes another 4 years for someone to take a stab at it.

Brian: is it possible to get the user’s LOCALE and convert to that before sending it off?

Ben: that’s worse than what we have now.

James: the LOCALE often lies.

Bert: are we going to land the patch to fs.watch? I’d like to have a quick references.

Trevor: it’s not going to land in 5, we could leave it open until near v6 and land it then if no one is able to get around to the full fix. there’s 5-6 months between 5 and 6…

Rod: that sounds like a nice compromise.

### WG: Considering a new HTTP WG [#3214](https://github.com/nodejs/node/issues/3214)

Rod: I left this on because I thought it’d be nice to get a report from the WG on how it went.

James: [cd: I am missing folk here]: Jeremiah, Eran Hammer, Doug Wilson, Myles Borins Brian White, Patrick Mueller, and myself.

We talked about the charter. Looking into what improvements can be made to better support the ecosystem. Making existing impl hookable so that modules could swap out parts of the implementation with their own. Like replacing the parser, or header specific handling. The charter covers that aspect of it, but emphasizes that existing systems are not broken. We have a number of issues that we’ve created to start discussing these. I’ll get these into the doc.

That’s the short version. Still really early to tell what all will come of it and what kind of schedule it’ll be on. 5th, at [cd: TIME?]
We’ll be drawing up a charter and bringing it back to this group.

Any other questions?

Rod: could we get a report on the API WG?

Trevor: the discussion was mainly around the native api. it went in a direction I wasn’t expecting. I explained my JS API proposal, then it went into a module discussion. ABI compat is straight out, it went in the direction of NAN (API compat, but occasional recompiles). Some discussion arose around abstracting node, like v8 completely. to replace with another VM. How do you handle specific difference like features that are available in one vm or another? or JS features that are/aren’t available between VMs. To target all vms, you end up having to use ES5. I was kind of losing where they were going with it. there are a lot of smart people. We’ll just have to have a discussion about feasibility.

Ben: Was there any talk about who’s going to do the actual work?

Trevor: No — it was more theoretical. It was more like the ES committee — develop features then say “go make these.” IF I bring it up I’m sure I can get some solid answers.

Alexis: I’m trying to push for the Chakra folks to do some of this work.

Mikeal: [cd: sorry, I missed this.]

Rod: What companies are involved? Did MS show up?

Trevor: Yes, I think so. JXCore, IBM was there, can’t remember offhand.

Bert: JXCore is also secretly MS?

Alexis: Not a secret! They’re on contract for an industrial IoT project.

Alexis: IBM was there, Nodesource.

Mikeal: Looking for someone from samsung’s jerryscript team to join.

Trevor: My initial proposal was to get something usable. I’ll be out of there if it turns into WASM — if it blows up in size.

Mikeal: The whole point is to be smaller than the current API, right?

Bert: Well, not smaller, but … let’s not talk about technical issues

Alexis: We’ve discussed multiple approaches, and we can tackle the problem from multiple sides. Trevor is tackling it by reducing the size of core. The approach I want to take is FFI interface into native modules. All of these approaches can help us tackle this huge beast into a manageable problem. They’re not competing solutions.

Bert: We want to avoid scope creep. If the WG comes up with a HUGE proposal with 20 points of view, then no one will ever go do it.

Trevor: I want to simplify the JS API, and get it to a point where all of the existing api can sit on top of it. If someone wants to do the work of replacing V8, they’ll have a clean entry point into the JS. And then write a set of compliance tests that specify what every entry point does. Writing a bunch for native code without JS tests to back it up would be futile.

Bert: Restricting it to API design, that in theory, the sort of design goal, is for the API to be sufficient for Node to use.

Alexis: This would include the native module api?

Rod: It sounds like HTTP attacked charter first, maybe the API WG needs to do the same, to combat growth of scope. Maybe anyone else on this call that wants to could join and try to define scope? Is there another call scheduled, Trevor?

Trevor: we’re still collecting times. I’ll mention the ctc in the issue.

Rod: we should make a new @ctc GH group.

Bert: which is going to be more fun?

Rod: The CTC

Bert: when are we going to split up?

Rod: Mikeal is organizing another meeting.

Mikeal: It’s tomorrow at this time slot.

### node-gyp: Windows users are not happy. [node-gyp#629](https://github.com/nodejs/node-gyp/issues/629)


Jeremiah: Do we want to talk about the windows issue?

Rod?: it kind of contains all of the windows problems.

Alexis: I was asking about guidance on this.

Rod: there’s a strategy of giving folks a place to vent, keeping it from spilling over elsewhere. Without this issue, it might explode into a bunch more issues.

Alexis: We’re working on a module build service. The other thing is that MS is going to release a smaller SKU of the compiler, that might be able to be included with node-gyp.

Rod: Next visual studio is going to be shipping with clang.

Trevor: Yes for AST stuff. [cd: might have gotten this wrong]

Rod: Alexis, you should post in there, but I think it’s going to always catch folks googling for the problem. I’m not sure you can resolve it by closing or locking it. Folks will go there and not see a proper resolution.

Mikeal: make sure there are issues for everything in the thread, then close and lock. Make sure there are resolutions (even if it’s “move hte conversation”).

Rod: I’m happy for Alexis to take the lead on this.

Rod: Maybe change the title to “Windows users are happy?”

Alexis: Maybe change to “Unix users are unhappy.”

Rod: that’d be an epic troll.

## Next Meeting

November 4, 2015
