/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.gjt.jclasslib.util.GUIHelper;
import org.gjt.jclasslib.util.ProgressDialog;

public class ProgressDialog
extends JDialog {
    private static final int PROGRESS_BAR_WIDTH = 200;
    private Runnable runnable;
    private JProgressBar progressBar;
    private JLabel lblMessage;

    public ProgressDialog(JFrame jFrame, Runnable runnable, String string) {
        super(jFrame);
        this.init(runnable, string);
    }

    public ProgressDialog(JDialog jDialog, Runnable runnable, String string) {
        super(jDialog);
        this.init(runnable, string);
    }

    public void setMessage(String string) {
        this.lblMessage.setText(string);
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.progressBar.setIndeterminate(true);
            GUIHelper.centerOnParentWindow(this, this.getOwner());
        } else {
            this.progressBar.setIndeterminate(false);
        }
        super.setVisible(bl);
    }

    private void init(Runnable runnable, String string) {
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
        this.setMessage(string);
        this.setRunnable(runnable);
    }

    private void setupControls() {
        this.progressBar = new JProgressBar();
        Dimension dimension = this.progressBar.getPreferredSize();
        dimension.width = 200;
        this.progressBar.setPreferredSize(dimension);
        this.lblMessage = new JLabel(" ");
    }

    private void setupComponent() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.lblMessage, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.progressBar, gridBagConstraints);
        this.setTitle("jclasslib");
        this.setModal(true);
        this.pack();
    }

    private void setupEventHandlers() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                Thread thread = new Thread(ProgressDialog.this.runnable);
                thread.start();
                new Thread(this, thread){
                    private final /* synthetic */ Thread val$task;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$task = thread;
                    }

                    public void run() {
                        try {
                            this.val$task.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                1.access$200(2.access$100(this.this$2)).setVisible(false);
                            }
                        });
                    }

                    static /* synthetic */ 1 access$100(2 var0) {
                        return var0.this$1;
                    }
                }.start();
            }

            static /* synthetic */ ProgressDialog access$200(1 var0) {
                return var0.ProgressDialog.this;
            }
        });
    }
}

