/* Preferences.h - Header for Preferences 
   window class and support functions for the
   Macintosh OS X SDL port of Atari800
   Mark Grebe <atarimac@cox.net>
   
   Based on the Preferences pane of the
   TextEdit application.

*/
#import <Cocoa/Cocoa.h>

/* Keys in the dictionary... */   
#define FullScreen @"FullScreen"
#define LockFullscreenSize @"LockFullscreenSize"
#define ScaleFactor @"ScaleFactor"
#define DoubleSize @"DoubleSize"
#define WidthMode @"WidthMode"
#define TvMode @"TvMode"
#define RefreshRatio @"RefreshRatio"
#define ArtifactingMode @"ArtifactingMode"
#define UseBuiltinPalette @"UseBuiltinPalette"
#define AdjustPalette @"AdjustPalette"
#define BlackLevel @"BlackLevel"
#define WhiteLevel @"WhiteLevel"
#define Intensity @"Instensity"
#define ColorShift @"ColorShift"
#define PaletteFile @"PaletteFile"
#define ShowFPS @"ShowFPS"
#define AtariType @"AtariType"
#define DisableBasic @"DisableBasic"
#define EnableSioPatch @"EnableSioPatch"
#define EnableHPatch @"EnableHPatch"
#define EnablePPatch @"EnablePPatch"
#define EnableRPatch @"EnableRPatch"
#define RPatchPort @"RPatchPort"
#define PrintCommand @"PrintCommand"
#define BootFromCassette @"BootFromCassette"
#define SpeedLimit @"SpeedLimit"
#define EnableSound @"EnableSound"
#define EnableHifiSound @"EnableHifiSound"
#define EnableMultijoy @"EnableMultijoy"
#define IgnoreHeaderWriteprotect @"IgnoreHeaderWriteprotect"
#define HardDiskDir1 @"HardDiskDir1"
#define HardDiskDir2 @"HardDiskDir2"
#define HardDiskDir3 @"HardDiskDir3"
#define HardDiskDir4 @"HardDiskDir4"
#define HardDrivesReadOnly @"HardDrivesReadOnly"
#define HPath @"HPath"
#define OsARomFile @"OsARomFile"
#define OsBRomFile @"OsBRomFile"
#define XlRomFile @"XlRomFile"
#define BasicRomFile @"BasicRomFile"
#define A5200RomFile @"A5200RomFile"
#define DiskImageDir @"DiskImageDir"
#define DiskSetDir @"DiskSetDir"
#define CartImageDir @"CartImageDir"
#define CassImageDir @"CassImageDir"
#define ExeFileDir @"ExeFileDir"
#define SavedStateDir @"SavedStateDir"
#define D1File @"D1File"
#define D2File @"D2File"
#define D3File @"D3File"
#define D4File @"D4File"
#define D5File @"D5File"
#define D6File @"D6File"
#define D7File @"D7File"
#define D8File @"D8File"
#define CartFile @"CartFile"
#define ExeFile @"ExeFile"
#define CassFile @"CassFile"
#define D1FileEnabled @"D1FileEnabled"
#define D2FileEnabled @"D2FileEnabled"
#define D3FileEnabled @"D3FileEnabled"
#define D4FileEnabled @"D4FileEnabled"
#define D5FileEnabled @"D5FileEnabled"
#define D6FileEnabled @"D6FileEnabled"
#define D7FileEnabled @"D7FileEnabled"
#define D8FileEnabled @"D8FileEnabled"
#define CartFileEnabled @"CartFileEnabled"
#define ExeFileEnabled @"ExeFileEnabled"
#define CassFileEnabled @"CassFileEnabled"
#define Joystick1Mode @"Joystick1Mode_v13"
#define Joystick2Mode @"Joystick2Mode_v13"
#define Joystick3Mode @"Joystick3Mode_v13"
#define Joystick4Mode @"Joystick4Mode_v13"
#define Joystick1Autofire @"Joystick1Autofire"
#define Joystick2Autofire @"Joystick2Autofire"
#define Joystick3Autofire @"Joystick3Autofire"
#define Joystick4Autofire @"Joystick4Autofire"
#define MouseDevice @"MouseDevice"
#define MouseSpeed @"MouseSpeed"
#define MouseMinVal @"MouseMinVal"
#define MouseMaxVal @"MouseMaxVal"
#define MouseHOffset @"MouseHOffset"
#define MouseVOffset @"MouseVOffset"
#define MouseInertia @"MouseInertia"
#define ButtonAssignment @"ButtonAssignment"
#define Button5200Assignment @"Button5200Assignment"
#define Joystick1Type @"Joystick1Type"
#define Joystick2Type @"Joystick2Type"
#define Joystick3Type @"Joystick3Type"
#define Joystick4Type @"Joystick4Type"
#define Joystick1Num @"Joystick1Num"
#define Joystick2Num @"Joystick2Num"
#define Joystick3Num @"Joystick3Num"
#define Joystick4Num @"Joystick4Num"
#define PaddlesXAxisOnly @"PaddlesXAxisOnly"
#define GamepadConfigArray @"GamepadConfigArray"
#define GamepadConfigCurrent @"GamepadConfigCurrent"
#define Gamepad1ConfigCurrent @"Gamepad1ConfigCurrent"
#define Gamepad2ConfigCurrent @"Gamepad2ConfigCurrent"
#define Gamepad3ConfigCurrent @"Gamepad3ConfigCurrent"
#define Gamepad4ConfigCurrent @"Gamepad4ConfigCurrent"
#define ButtonAssignmentPrefix @"ButtonAssignment."
#define Button5200AssignmentPrefix @"Button5200Assignment."
#define StandardConfigString @"Standard"
#define LeftJoyUp @"LeftJoyUp"
#define LeftJoyDown @"LeftJoyDown"
#define LeftJoyLeft @"LeftJoyLeft"
#define LeftJoyRight @"LeftJoyRight"
#define LeftJoyUpLeft @"LeftJoyUpLeft"
#define LeftJoyUpRight @"LeftJoyUpRight"
#define LeftJoyDownLeft @"LeftJoyDownLeft"
#define LeftJoyDownRight @"LeftJoyDownRight"
#define LeftJoyFire @"LeftJoyFire"
#define LeftJoyAltFire @"LeftJoyAltFire"
#define PadJoyUp @"PadJoyUp"
#define PadJoyDown @"PadJoyDown"
#define PadJoyLeft @"PadJoyLeft"
#define PadJoyRight @"PadJoyRight"
#define PadJoyUpLeft @"PadJoyUpLeft"
#define PadJoyUpRight @"PadJoyUpRight"
#define PadJoyDownLeft @"PadJoyDownLeft"
#define PadJoyDownRight @"PadJoyDownRight"
#define PadJoyFire @"PadJoyFire"
#define PadJoyAltFire @"PadJoyAltFire"

@interface Preferences : NSObject {
    IBOutlet id prefTabView;
    IBOutlet id a5200RomFileField;
    IBOutlet id adjustPaletteButton;
    IBOutlet id artifactingPulldown;
    IBOutlet id atariTypePulldown;
    IBOutlet id basicRomFileField;
    IBOutlet id blackLevelField;
    IBOutlet id cartImageDirField;
    IBOutlet id cassImageDirField;
    IBOutlet id colorShiftField;
    IBOutlet id disableBasicButton;
    IBOutlet id diskImageDirField;
    IBOutlet id diskSetDirField;
    IBOutlet id doubleSizeMatrix;
    IBOutlet id lockFullscreenSizeButton;
    IBOutlet id scaleFactorMatrix;
    IBOutlet id enableHPatchButton;
    IBOutlet id enablePPatchButton;
    IBOutlet id enableRPatchButton;
    IBOutlet id rPatchPortField;
    IBOutlet id externalPaletteButton;
    IBOutlet id printCommandField;
    IBOutlet id enableSioPatchButton;
    IBOutlet id bootFromCassetteButton;
    IBOutlet id ignoreHeaderWriteprotectButton;
    IBOutlet id exeFileDirField;
    IBOutlet id fullScreenMatrix;
    IBOutlet id fpsButton;
    IBOutlet id hardDiskDir1Field;
    IBOutlet id hardDiskDir2Field;
    IBOutlet id hardDiskDir3Field;
    IBOutlet id hardDiskDir4Field;
    IBOutlet id hardDrivesReadOnlyButton;
    IBOutlet id hPathField;
    IBOutlet id intensityField;
    IBOutlet id osARomFileField;
    IBOutlet id osBRomFileField;
    IBOutlet id refreshRatioPulldown;
    IBOutlet id savedStateDirField;
    IBOutlet id speedLimitButton;
    IBOutlet id enableSoundButton;
    IBOutlet id enableHifiSoundButton;
    IBOutlet id enableMultijoyButton;
    IBOutlet id tvModeMatrix;
    IBOutlet id widthModeMatrix;
    IBOutlet id whiteLevelField;
    IBOutlet id xlRomFileField;
    IBOutlet id d1FileField;
    IBOutlet id d2FileField;
    IBOutlet id d3FileField;
    IBOutlet id d4FileField;
    IBOutlet id d5FileField;
    IBOutlet id d6FileField;
    IBOutlet id d7FileField;
    IBOutlet id d8FileField;
    IBOutlet id cartFileField;
    IBOutlet id exeFileField;
    IBOutlet id cassFileField;
    IBOutlet id d1FileEnabledButton;
    IBOutlet id d2FileEnabledButton;
    IBOutlet id d3FileEnabledButton;
    IBOutlet id d4FileEnabledButton;
    IBOutlet id d5FileEnabledButton;
    IBOutlet id d6FileEnabledButton;
    IBOutlet id d7FileEnabledButton;
    IBOutlet id d8FileEnabledButton;
    IBOutlet id cartFileEnabledButton;
    IBOutlet id exeFileEnabledButton;
    IBOutlet id cassFileEnabledButton;
    IBOutlet id joystick1Pulldown;
    IBOutlet id joystick2Pulldown;
    IBOutlet id joystick3Pulldown;
    IBOutlet id joystick4Pulldown;
    IBOutlet id joy1AutofirePulldown;
    IBOutlet id joy2AutofirePulldown;
    IBOutlet id joy3AutofirePulldown;
    IBOutlet id joy4AutofirePulldown;
    IBOutlet id mouseDevicePulldown;
    IBOutlet id mouseSpeedField;
    IBOutlet id mouseMinValField;
    IBOutlet id mouseMaxValField;
    IBOutlet id mouseHOffsetField;
    IBOutlet id mouseVOffsetField;
    IBOutlet id mouseInertiaField;
    IBOutlet id paletteChooseButton;
    IBOutlet id paletteField;
    IBOutlet id gamepadConfigPulldown;
    IBOutlet id gamepad1IdentifyButton;
    IBOutlet id gamepad2IdentifyButton;
    IBOutlet id gamepad3IdentifyButton;
    IBOutlet id gamepad4IdentifyButton;
    IBOutlet id gamepad1ConfigPulldown;
    IBOutlet id gamepad2ConfigPulldown;
    IBOutlet id gamepad3ConfigPulldown;
    IBOutlet id gamepad4ConfigPulldown;
    IBOutlet id gamepadButtonPulldown;
    IBOutlet id gamepadAssignmentPulldown;
    IBOutlet id gamepad5200AssignmentPulldown;
    IBOutlet id joystick1TypePulldown;
    IBOutlet id joystick2TypePulldown;
    IBOutlet id joystick3TypePulldown;
    IBOutlet id joystick4TypePulldown;
    IBOutlet id joystick1NumPulldown;
    IBOutlet id joystick2NumPulldown;
    IBOutlet id joystick3NumPulldown;
    IBOutlet id joystick4NumPulldown;
    IBOutlet id paddlesXAxisOnlyButton;
    IBOutlet id gamepadButton1;
    IBOutlet id gamepadButton2;
    IBOutlet id gamepadButton3;
    IBOutlet id gamepadButton4;
    IBOutlet id gamepadButton5;
    IBOutlet id gamepadButton6;
    IBOutlet id gamepadButton7;
    IBOutlet id gamepadButton8;
    IBOutlet id gamepadButton9;
    IBOutlet id gamepadButton10;
    IBOutlet id gamepadButton11;
    IBOutlet id gamepadButton12;
    IBOutlet id gamepadButton13;
    IBOutlet id gamepadButton14;
    IBOutlet id gamepadButton15;
    IBOutlet id gamepadButton16;
    IBOutlet id gamepadButton17;
    IBOutlet id gamepadButton18;
    IBOutlet id gamepadButton19;
    IBOutlet id gamepadButton20;
    IBOutlet id gamepadButton21;
    IBOutlet id gamepadButton22;
    IBOutlet id gamepadButton23;
    IBOutlet id gamepadButton24;
    IBOutlet id errorOKButton;
    IBOutlet id configNameField;
    IBOutlet id leftJoyUpPulldown;
    IBOutlet id leftJoyDownPulldown;
    IBOutlet id leftJoyLeftPulldown;
    IBOutlet id leftJoyRightPulldown;
    IBOutlet id leftJoyUpLeftPulldown;
    IBOutlet id leftJoyUpRightPulldown;
    IBOutlet id leftJoyDownLeftPulldown;
    IBOutlet id leftJoyDownRightPulldown;
    IBOutlet id leftJoyFirePulldown;
    IBOutlet id leftJoyAltFirePulldown;
    IBOutlet id padJoyUpPulldown;
    IBOutlet id padJoyDownPulldown;
    IBOutlet id padJoyLeftPulldown;
    IBOutlet id padJoyRightPulldown;
    IBOutlet id padJoyUpLeftPulldown;
    IBOutlet id padJoyUpRightPulldown;
    IBOutlet id padJoyDownLeftPulldown;
    IBOutlet id padJoyDownRightPulldown;
    IBOutlet id padJoyFirePulldown;
    IBOutlet id padJoyAltFirePulldown;
    IBOutlet id gamepadNameField;
    IBOutlet id gamepadNumButtonsField;
    IBOutlet id gamepadNumSticksField;
    IBOutlet id gamepadNumHatsField;

    int padNum; /* Remember number of gamepad for ID */
    
    NSMutableDictionary *curValues;	// Current, confirmed values for the preferences
    NSDictionary *origValues;	// Values read from preferences at startup
    NSMutableDictionary *displayedValues;	// Values displayed in the UI
}

+ (id)objectForKey:(id)key;	/* Convenience for getting global preferences */
+ (void)saveDefaults;		/* Convenience for saving global preferences */
- (void)saveDefaults;		/* Save the current preferences */

+ (Preferences *)sharedInstance;

+ (void)setWorkingDirectory:(char *)dir;  /* Save the base directory of the application */

- (NSDictionary *)preferences;	/* The current preferences; contains values for the documented keys */

- (void)showPanel:(id)sender;	/* Shows the panel */

- (void)updateUI;		/* Updates the displayed values in the UI */
- (void)updateJoyNumMenus;	/* Updates the joystick Number menus, based on joystick type */
- (void)commitDisplayedValues;	/* The displayed values are made current */
- (void)discardDisplayedValues;	/* The displayed values are replaced with current prefs and updateUI is called */

- (void)revert:(id)sender;	/* Reverts the displayed values to the current preferences */
- (void)ok:(id)sender;		/* Calls commitUI to commit the displayed values as current */
- (void)revertToDefault:(id)sender;    

- (void)miscChanged:(id)sender;	/* Action message for most of the misc items in the UI to get displayedValues  */
- (void)browsePalette:(id)sender; 
- (void)browseHardDisk1:(id)sender; 
- (void)browseHardDisk2:(id)sender; 
- (void)browseHardDisk3:(id)sender; 
- (void)browseHardDisk4:(id)sender; 
- (void)browseOsARom:(id)sender; 
- (void)browseOsBRom:(id)sender; 
- (void)browseXlRom:(id)sender; 
- (void)browseBasicRom:(id)sender; 
- (void)browse5200Rom:(id)sender; 
- (void)browseDiskDir:(id)sender; 
- (void)browseDiskSetDir:(id)sender; 
- (void)browseCartDir:(id)sender; 
- (void)browseCassDir:(id)sender; 
- (void)browseExeDir:(id)sender; 
- (void)browseStateDir:(id)sender; 
- (void)browseD1File:(id)sender; 
- (void)browseD2File:(id)sender; 
- (void)browseD3File:(id)sender; 
- (void)browseD4File:(id)sender; 
- (void)browseD5File:(id)sender; 
- (void)browseD6File:(id)sender; 
- (void)browseD7File:(id)sender; 
- (void)browseD8File:(id)sender; 
- (void)browseCartFile:(id)sender; 
- (void)browseExeFile:(id)sender; 
- (void)browseCassFile:(id)sender; 
- (void)transferValuesToEmulator;
- (void)windowWillClose:(NSNotification *)notification;
- (void)gamepadConfigChange:(id)sender;
- (void)gamepadButtonChange:(id)sender;
- (void)buttonAssign:(id)sender; 
- (void)button5200Assign:(id)sender; 
- (void)identifyGamepad:(id)sender; 
- (void)configNameOK:(id)sender;
- (void)errorOK:(id)sender;
- (void)leftJoyConfigure:(id)sender;
- (void)leftJoyOK:(id)sender;
- (void)padJoyConfigure:(id)sender;
- (void)padJoyOK:(id)sender;

+ (NSDictionary *)preferencesFromDefaults;
+ (void)savePreferencesToDefaults:(NSDictionary *)dict;

- (void) releaseCmdKeys:(NSString *)character:(int)keyCode;

@end
