/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.XPathException;

public class AttributeSet
extends Procedure
implements InstructionInfoProvider {
    StructuredQName attributeSetName;
    private AttributeSet[] useAttributeSets;

    public AttributeSet() {
        this.setHostLanguage(50);
    }

    public void setName(StructuredQName attributeSetName) {
        this.attributeSetName = attributeSetName;
    }

    public void setUseAttributeSets(AttributeSet[] useAttributeSets) {
        this.useAttributeSets = useAttributeSets;
    }

    public void setStackFrameMap(SlotManager stackFrameMap) {
        if (stackFrameMap != null && stackFrameMap.getNumberOfVariables() > 0) {
            super.setStackFrameMap(stackFrameMap);
        }
    }

    public int getFocusDependencies() {
        int d = 0;
        if (this.body != null) {
            d |= this.body.getDependencies() & 0x1E;
        }
        if (this.useAttributeSets != null) {
            for (int i = 0; i < this.useAttributeSets.length; ++i) {
                d |= this.useAttributeSets[i].getFocusDependencies();
            }
        }
        return d;
    }

    public void expand(XPathContext context) throws XPathException {
        if (this.useAttributeSets != null) {
            AttributeSet.expand(this.useAttributeSets, context);
        }
        if (this.getStackFrameMap() != null) {
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            c2.openStackFrame(this.getStackFrameMap());
            this.getBody().process(c2);
        } else {
            this.getBody().process(context);
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails details = new InstructionDetails();
        details.setConstructType(132);
        details.setObjectName(this.attributeSetName);
        details.setSystemId(this.getSystemId());
        details.setLineNumber(this.getLineNumber());
        details.setProperty("attribute-set", this);
        return details;
    }

    protected static void expand(AttributeSet[] asets, XPathContext context) throws XPathException {
        for (int i = 0; i < asets.length; ++i) {
            asets[i].expand(context);
        }
    }
}

