#! /bin/sh
# Copyright 2006 Kari Pahula <kaol@debian.org>
# May be used and distributed under GNU GPL version 2 or later,
# as published by Free Software Foundation.

set -e

test -n "$BINARYNAME"
test -n "$PACKAGE"

cat <<EOF
#! /bin/sh
# Copyright 2006 Kari Pahula <kaol@debian.org>
# May be used and distributed under GNU GPL version 2 or later,
# as published by Free Software Foundation.
#
# As an exception, if this file is created by calling make-klone-project,
# then it can be used without restriction.

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/$BINARYNAME
NAME=$PACKAGE
DESC=$PACKAGE

test -x $DAEMON || exit 0

if [ -f /etc/default/$PACKAGE ] ; then
	. /etc/default/$PACKAGE
fi

set -e

case "\$1" in
  start)
	echo -n "Starting \$DESC: "
	if start-stop-daemon --start --quiet --exec \$DAEMON -- \$DAEMON_OPTS ; then
	    echo "\$NAME."
	else
	    echo "failed."
	    exit 1
	fi
	;;
  stop)
	echo -n "Stopping \$DESC: "
	if start-stop-daemon --stop --quiet --exec \$DAEMON ; then
	    echo "\$NAME."
	else
	    echo "not running."
	fi
	;;
  restart|force-reload)
	echo -n "Restarting \$DESC: "
	start-stop-daemon --oknodo --stop --quiet --exec \$DAEMON
	sleep 1
	start-stop-daemon --start --quiet --exec \$DAEMON -- \$DAEMON_OPTS
	echo "\$NAME."
	;;
  *)
	N=/etc/init.d/\$NAME
	echo "Usage: \$N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
EOF
