/*
 * Decompiled with CFR 0.152.
 */
package adql.parser;

import adql.parser.grammar.Token;
import adql.query.IdentifierField;
import adql.query.TextPosition;

public class IdentifierItems {
    private IdentifierItem[] identifiers = new IdentifierItem[4];
    private int count = 0;
    private boolean tableIdent = false;

    public IdentifierItems(boolean tableIdentifier) {
        this.tableIdent = tableIdentifier;
    }

    public void append(IdentifierItem item) {
        if (this.count >= 4) {
            return;
        }
        this.identifiers[this.count++] = item;
    }

    public int size() {
        return this.count;
    }

    public IdentifierItem get(int ind) {
        return ind < 0 || this.identifiers[ind] == null ? null : this.identifiers[ind];
    }

    public String getIdentifier(int ind) {
        return ind < 0 || this.identifiers[ind] == null ? null : this.identifiers[ind].identifier;
    }

    public String getCatalog() {
        return this.getIdentifier(this.tableIdent ? this.count - 3 : this.count - 4);
    }

    public String getSchema() {
        return this.getIdentifier(this.tableIdent ? this.count - 2 : this.count - 3);
    }

    public String getTable() {
        return this.getIdentifier(this.tableIdent ? this.count - 1 : this.count - 2);
    }

    public String getColumn() {
        return this.getIdentifier(this.tableIdent ? -1 : this.count - 1);
    }

    public int getBeginLine() {
        return this.count == 0 || this.identifiers[0] == null ? -1 : this.identifiers[0].position.beginLine;
    }

    public int getEndLine() {
        return this.count == 0 || this.identifiers[this.count - 1] == null ? -1 : this.identifiers[this.count - 1].position.endLine;
    }

    public int getBeginColumn() {
        return this.count == 0 || this.identifiers[0] == null ? -1 : this.identifiers[0].position.beginColumn;
    }

    public int getEndColumn() {
        return this.count == 0 || this.identifiers[this.count - 1] == null ? -1 : this.identifiers[this.count - 1].position.endColumn;
    }

    public TextPosition getPosition() {
        return new TextPosition(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
    }

    public byte getCaseSensitivity() {
        byte sensitivity = IdentifierField.getFullCaseSensitive(false);
        if (this.count == 0) {
            return sensitivity;
        }
        int ind = this.count - 1;
        if (!this.tableIdent) {
            if (this.identifiers[ind] != null) {
                sensitivity = IdentifierField.COLUMN.setCaseSensitive(sensitivity, this.identifiers[ind].caseSensitivity);
            }
            --ind;
        }
        if (ind < 0) {
            return sensitivity;
        }
        if (this.identifiers[ind] != null) {
            sensitivity = IdentifierField.TABLE.setCaseSensitive(sensitivity, this.identifiers[ind].caseSensitivity);
        }
        if (--ind < 0) {
            return sensitivity;
        }
        if (this.identifiers[ind] != null) {
            sensitivity = IdentifierField.SCHEMA.setCaseSensitive(sensitivity, this.identifiers[ind].caseSensitivity);
        }
        if (--ind < 0) {
            return sensitivity;
        }
        if (this.identifiers[ind] != null) {
            sensitivity = IdentifierField.CATALOG.setCaseSensitive(sensitivity, this.identifiers[ind].caseSensitivity);
        }
        return sensitivity;
    }

    public boolean getColumnCaseSensitivity() {
        if (this.count == 0 || this.tableIdent || this.identifiers[this.count - 1] == null) {
            return false;
        }
        return this.identifiers[this.count - 1].caseSensitivity;
    }

    public String join(String delim) {
        if (this.count == 0) {
            return null;
        }
        if (delim == null) {
            delim = "";
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            if (this.identifiers[i] == null) continue;
            if (str.length() > 0) {
                str.append(delim);
            }
            str.append(this.identifiers[i] == null ? "" : this.identifiers[i].identifier);
        }
        return str.toString();
    }

    public String toString() {
        return this.join(".");
    }

    public static class IdentifierItem {
        public String identifier = null;
        public boolean caseSensitivity = false;
        public TextPosition position = null;

        public IdentifierItem(Token token, boolean caseSensitive) {
            this.identifier = token.image.replaceAll("\"\"", "\"");
            this.caseSensitivity = caseSensitive;
            this.position = new TextPosition(token);
        }

        public String toString() {
            return this.identifier;
        }
    }
}

