# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class AllowedEnvironmentType(Resource):
    """Represents an allowed environment type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar display_name: The display name of the allowed environment type.
    :vartype display_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "display_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.display_name = None


class AllowedEnvironmentTypeListResult(_serialization.Model):
    """Result of the allowed environment type list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.AllowedEnvironmentType]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AllowedEnvironmentType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class AttachedNetworkConnection(Resource):
    """Represents an attached NetworkConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar network_connection_id: The resource ID of the NetworkConnection you want to attach.
    :vartype network_connection_id: str
    :ivar network_connection_location: The geo-location where the NetworkConnection resource
     specified in 'networkConnectionResourceId' property lives.
    :vartype network_connection_location: str
    :ivar health_check_status: Health check status values. Known values are: "Unknown", "Pending",
     "Running", "Passed", "Warning", and "Failed".
    :vartype health_check_status: str or ~azure.mgmt.devcenter.models.HealthCheckStatus
    :ivar domain_join_type: AAD Join type of the network. This is populated based on the referenced
     Network Connection. Known values are: "HybridAzureADJoin" and "AzureADJoin".
    :vartype domain_join_type: str or ~azure.mgmt.devcenter.models.DomainJoinType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "network_connection_location": {"readonly": True},
        "health_check_status": {"readonly": True},
        "domain_join_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "network_connection_id": {"key": "properties.networkConnectionId", "type": "str"},
        "network_connection_location": {"key": "properties.networkConnectionLocation", "type": "str"},
        "health_check_status": {"key": "properties.healthCheckStatus", "type": "str"},
        "domain_join_type": {"key": "properties.domainJoinType", "type": "str"},
    }

    def __init__(self, *, network_connection_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword network_connection_id: The resource ID of the NetworkConnection you want to attach.
        :paramtype network_connection_id: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.network_connection_id = network_connection_id
        self.network_connection_location = None
        self.health_check_status = None
        self.domain_join_type = None


class AttachedNetworkListResult(_serialization.Model):
    """Results of the Attached Networks list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.AttachedNetworkConnection]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AttachedNetworkConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Capability(_serialization.Model):
    """A name/value pair to describe a capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the capability.
    :vartype name: str
    :ivar value: Value of the capability.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class Catalog(Resource):  # pylint: disable=too-many-instance-attributes
    """Represents a catalog.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar git_hub: Properties for a GitHub catalog type.
    :vartype git_hub: ~azure.mgmt.devcenter.models.GitCatalog
    :ivar ado_git: Properties for an Azure DevOps catalog type.
    :vartype ado_git: ~azure.mgmt.devcenter.models.GitCatalog
    :ivar sync_type: Indicates the type of sync that is configured for the catalog. Known values
     are: "Manual" and "Scheduled".
    :vartype sync_type: str or ~azure.mgmt.devcenter.models.CatalogSyncType
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar sync_state: The synchronization state of the catalog. Known values are: "Succeeded",
     "InProgress", "Failed", and "Canceled".
    :vartype sync_state: str or ~azure.mgmt.devcenter.models.CatalogSyncState
    :ivar last_sync_stats: Stats of the latest synchronization.
    :vartype last_sync_stats: ~azure.mgmt.devcenter.models.SyncStats
    :ivar connection_state: The connection state of the catalog. Known values are: "Connected" and
     "Disconnected".
    :vartype connection_state: str or ~azure.mgmt.devcenter.models.CatalogConnectionState
    :ivar last_connection_time: When the catalog was last connected.
    :vartype last_connection_time: ~datetime.datetime
    :ivar last_sync_time: When the catalog was last synced.
    :vartype last_sync_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "sync_state": {"readonly": True},
        "last_sync_stats": {"readonly": True},
        "connection_state": {"readonly": True},
        "last_connection_time": {"readonly": True},
        "last_sync_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "git_hub": {"key": "properties.gitHub", "type": "GitCatalog"},
        "ado_git": {"key": "properties.adoGit", "type": "GitCatalog"},
        "sync_type": {"key": "properties.syncType", "type": "str"},
        "tags": {"key": "properties.tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sync_state": {"key": "properties.syncState", "type": "str"},
        "last_sync_stats": {"key": "properties.lastSyncStats", "type": "SyncStats"},
        "connection_state": {"key": "properties.connectionState", "type": "str"},
        "last_connection_time": {"key": "properties.lastConnectionTime", "type": "iso-8601"},
        "last_sync_time": {"key": "properties.lastSyncTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        git_hub: Optional["_models.GitCatalog"] = None,
        ado_git: Optional["_models.GitCatalog"] = None,
        sync_type: Optional[Union[str, "_models.CatalogSyncType"]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword git_hub: Properties for a GitHub catalog type.
        :paramtype git_hub: ~azure.mgmt.devcenter.models.GitCatalog
        :keyword ado_git: Properties for an Azure DevOps catalog type.
        :paramtype ado_git: ~azure.mgmt.devcenter.models.GitCatalog
        :keyword sync_type: Indicates the type of sync that is configured for the catalog. Known values
         are: "Manual" and "Scheduled".
        :paramtype sync_type: str or ~azure.mgmt.devcenter.models.CatalogSyncType
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.git_hub = git_hub
        self.ado_git = ado_git
        self.sync_type = sync_type
        self.tags = tags
        self.provisioning_state = None
        self.sync_state = None
        self.last_sync_stats = None
        self.connection_state = None
        self.last_connection_time = None
        self.last_sync_time = None


class CatalogConflictError(_serialization.Model):
    """An individual conflict error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar path: The path of the file that has a conflicting name.
    :vartype path: str
    :ivar name: Name of the conflicting catalog item.
    :vartype name: str
    """

    _validation = {
        "path": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.path = None
        self.name = None


class CatalogErrorDetails(_serialization.Model):
    """Catalog error details.

    :ivar code: An identifier for the error.
    :vartype code: str
    :ivar message: A message describing the error.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: An identifier for the error.
        :paramtype code: str
        :keyword message: A message describing the error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class CatalogListResult(_serialization.Model):
    """Results of the catalog list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.Catalog]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Catalog]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class CatalogUpdateProperties(_serialization.Model):
    """Properties of a catalog. These properties can be updated after the resource has been created.

    :ivar git_hub: Properties for a GitHub catalog type.
    :vartype git_hub: ~azure.mgmt.devcenter.models.GitCatalog
    :ivar ado_git: Properties for an Azure DevOps catalog type.
    :vartype ado_git: ~azure.mgmt.devcenter.models.GitCatalog
    :ivar sync_type: Indicates the type of sync that is configured for the catalog. Known values
     are: "Manual" and "Scheduled".
    :vartype sync_type: str or ~azure.mgmt.devcenter.models.CatalogSyncType
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "git_hub": {"key": "gitHub", "type": "GitCatalog"},
        "ado_git": {"key": "adoGit", "type": "GitCatalog"},
        "sync_type": {"key": "syncType", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        git_hub: Optional["_models.GitCatalog"] = None,
        ado_git: Optional["_models.GitCatalog"] = None,
        sync_type: Optional[Union[str, "_models.CatalogSyncType"]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword git_hub: Properties for a GitHub catalog type.
        :paramtype git_hub: ~azure.mgmt.devcenter.models.GitCatalog
        :keyword ado_git: Properties for an Azure DevOps catalog type.
        :paramtype ado_git: ~azure.mgmt.devcenter.models.GitCatalog
        :keyword sync_type: Indicates the type of sync that is configured for the catalog. Known values
         are: "Manual" and "Scheduled".
        :paramtype sync_type: str or ~azure.mgmt.devcenter.models.CatalogSyncType
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.git_hub = git_hub
        self.ado_git = ado_git
        self.sync_type = sync_type
        self.tags = tags


class CatalogProperties(CatalogUpdateProperties):
    """Properties of a catalog.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar git_hub: Properties for a GitHub catalog type.
    :vartype git_hub: ~azure.mgmt.devcenter.models.GitCatalog
    :ivar ado_git: Properties for an Azure DevOps catalog type.
    :vartype ado_git: ~azure.mgmt.devcenter.models.GitCatalog
    :ivar sync_type: Indicates the type of sync that is configured for the catalog. Known values
     are: "Manual" and "Scheduled".
    :vartype sync_type: str or ~azure.mgmt.devcenter.models.CatalogSyncType
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar sync_state: The synchronization state of the catalog. Known values are: "Succeeded",
     "InProgress", "Failed", and "Canceled".
    :vartype sync_state: str or ~azure.mgmt.devcenter.models.CatalogSyncState
    :ivar last_sync_stats: Stats of the latest synchronization.
    :vartype last_sync_stats: ~azure.mgmt.devcenter.models.SyncStats
    :ivar connection_state: The connection state of the catalog. Known values are: "Connected" and
     "Disconnected".
    :vartype connection_state: str or ~azure.mgmt.devcenter.models.CatalogConnectionState
    :ivar last_connection_time: When the catalog was last connected.
    :vartype last_connection_time: ~datetime.datetime
    :ivar last_sync_time: When the catalog was last synced.
    :vartype last_sync_time: ~datetime.datetime
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "sync_state": {"readonly": True},
        "last_sync_stats": {"readonly": True},
        "connection_state": {"readonly": True},
        "last_connection_time": {"readonly": True},
        "last_sync_time": {"readonly": True},
    }

    _attribute_map = {
        "git_hub": {"key": "gitHub", "type": "GitCatalog"},
        "ado_git": {"key": "adoGit", "type": "GitCatalog"},
        "sync_type": {"key": "syncType", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "sync_state": {"key": "syncState", "type": "str"},
        "last_sync_stats": {"key": "lastSyncStats", "type": "SyncStats"},
        "connection_state": {"key": "connectionState", "type": "str"},
        "last_connection_time": {"key": "lastConnectionTime", "type": "iso-8601"},
        "last_sync_time": {"key": "lastSyncTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        git_hub: Optional["_models.GitCatalog"] = None,
        ado_git: Optional["_models.GitCatalog"] = None,
        sync_type: Optional[Union[str, "_models.CatalogSyncType"]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword git_hub: Properties for a GitHub catalog type.
        :paramtype git_hub: ~azure.mgmt.devcenter.models.GitCatalog
        :keyword ado_git: Properties for an Azure DevOps catalog type.
        :paramtype ado_git: ~azure.mgmt.devcenter.models.GitCatalog
        :keyword sync_type: Indicates the type of sync that is configured for the catalog. Known values
         are: "Manual" and "Scheduled".
        :paramtype sync_type: str or ~azure.mgmt.devcenter.models.CatalogSyncType
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(git_hub=git_hub, ado_git=ado_git, sync_type=sync_type, tags=tags, **kwargs)
        self.provisioning_state = None
        self.sync_state = None
        self.last_sync_stats = None
        self.connection_state = None
        self.last_connection_time = None
        self.last_sync_time = None


class CatalogResourceValidationErrorDetails(_serialization.Model):
    """List of validator error details. Populated when changes are made to the resource or its
    dependent resources that impact the validity of the Catalog resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar errors: Errors associated with resources synchronized from the catalog.
    :vartype errors: list[~azure.mgmt.devcenter.models.CatalogErrorDetails]
    """

    _validation = {
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[CatalogErrorDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.errors = None


class CatalogSyncError(_serialization.Model):
    """An individual synchronization error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar path: The path of the file the error is associated with.
    :vartype path: str
    :ivar error_details: Errors associated with the file.
    :vartype error_details: list[~azure.mgmt.devcenter.models.CatalogErrorDetails]
    """

    _validation = {
        "path": {"readonly": True},
        "error_details": {"readonly": True},
    }

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "error_details": {"key": "errorDetails", "type": "[CatalogErrorDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.path = None
        self.error_details = None


class CatalogUpdate(_serialization.Model):
    """The catalog's properties for partial update. Properties not provided in the update request will
    not be changed.

    :ivar git_hub: Properties for a GitHub catalog type.
    :vartype git_hub: ~azure.mgmt.devcenter.models.GitCatalog
    :ivar ado_git: Properties for an Azure DevOps catalog type.
    :vartype ado_git: ~azure.mgmt.devcenter.models.GitCatalog
    :ivar sync_type: Indicates the type of sync that is configured for the catalog. Known values
     are: "Manual" and "Scheduled".
    :vartype sync_type: str or ~azure.mgmt.devcenter.models.CatalogSyncType
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "git_hub": {"key": "properties.gitHub", "type": "GitCatalog"},
        "ado_git": {"key": "properties.adoGit", "type": "GitCatalog"},
        "sync_type": {"key": "properties.syncType", "type": "str"},
        "tags": {"key": "properties.tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        git_hub: Optional["_models.GitCatalog"] = None,
        ado_git: Optional["_models.GitCatalog"] = None,
        sync_type: Optional[Union[str, "_models.CatalogSyncType"]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword git_hub: Properties for a GitHub catalog type.
        :paramtype git_hub: ~azure.mgmt.devcenter.models.GitCatalog
        :keyword ado_git: Properties for an Azure DevOps catalog type.
        :paramtype ado_git: ~azure.mgmt.devcenter.models.GitCatalog
        :keyword sync_type: Indicates the type of sync that is configured for the catalog. Known values
         are: "Manual" and "Scheduled".
        :paramtype sync_type: str or ~azure.mgmt.devcenter.models.CatalogSyncType
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.git_hub = git_hub
        self.ado_git = ado_git
        self.sync_type = sync_type
        self.tags = tags


class CheckNameAvailabilityRequest(_serialization.Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the resource for which availability needs to be checked.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponse(_serialization.Model):
    """The check availability result.

    :ivar name_available: Indicates if the resource name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the given name is not available. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.devcenter.models.CheckNameAvailabilityReason
    :ivar message: Detailed reason why the given name is available.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Indicates if the resource name is available.
        :paramtype name_available: bool
        :keyword reason: The reason why the given name is not available. Known values are: "Invalid"
         and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.devcenter.models.CheckNameAvailabilityReason
        :keyword message: Detailed reason why the given name is available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class CheckScopedNameAvailabilityRequest(_serialization.Model):
    """The scoped name check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar scope: The resource id to scope the name check.
    :vartype scope: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, type: Optional[str] = None, scope: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the resource for which availability needs to be checked.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        :keyword scope: The resource id to scope the name check.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.scope = scope


class CustomerManagedKeyEncryption(_serialization.Model):
    """All Customer-managed key encryption properties for the resource.

    :ivar key_encryption_key_identity: All identity configuration for Customer-managed key settings
     defining which identity should be used to auth to Key Vault.
    :vartype key_encryption_key_identity:
     ~azure.mgmt.devcenter.models.CustomerManagedKeyEncryptionKeyIdentity
    :ivar key_encryption_key_url: key encryption key Url, versioned or non-versioned. Ex:
     https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or
     https://contosovault.vault.azure.net/keys/contosokek.
    :vartype key_encryption_key_url: str
    """

    _attribute_map = {
        "key_encryption_key_identity": {
            "key": "keyEncryptionKeyIdentity",
            "type": "CustomerManagedKeyEncryptionKeyIdentity",
        },
        "key_encryption_key_url": {"key": "keyEncryptionKeyUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_encryption_key_identity: Optional["_models.CustomerManagedKeyEncryptionKeyIdentity"] = None,
        key_encryption_key_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_encryption_key_identity: All identity configuration for Customer-managed key
         settings defining which identity should be used to auth to Key Vault.
        :paramtype key_encryption_key_identity:
         ~azure.mgmt.devcenter.models.CustomerManagedKeyEncryptionKeyIdentity
        :keyword key_encryption_key_url: key encryption key Url, versioned or non-versioned. Ex:
         https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or
         https://contosovault.vault.azure.net/keys/contosokek.
        :paramtype key_encryption_key_url: str
        """
        super().__init__(**kwargs)
        self.key_encryption_key_identity = key_encryption_key_identity
        self.key_encryption_key_url = key_encryption_key_url


class CustomerManagedKeyEncryptionKeyIdentity(_serialization.Model):
    """All identity configuration for Customer-managed key settings defining which identity should be
    used to auth to Key Vault.

    :ivar identity_type: Values can be systemAssignedIdentity or userAssignedIdentity. Known values
     are: "systemAssignedIdentity", "userAssignedIdentity", and "delegatedResourceIdentity".
    :vartype identity_type: str or ~azure.mgmt.devcenter.models.IdentityType
    :ivar user_assigned_identity_resource_id: user assigned identity to use for accessing key
     encryption key Url. Ex:
     /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/:code:`<resource
     group>`/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive
     with identityType systemAssignedIdentity and delegatedResourceIdentity.
    :vartype user_assigned_identity_resource_id: str
    :ivar delegated_identity_client_id: delegated identity to use for accessing key encryption key
     Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/:code:`<resource
     group>`/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive
     with identityType systemAssignedIdentity and userAssignedIdentity - internal use only.
    :vartype delegated_identity_client_id: str
    """

    _attribute_map = {
        "identity_type": {"key": "identityType", "type": "str"},
        "user_assigned_identity_resource_id": {"key": "userAssignedIdentityResourceId", "type": "str"},
        "delegated_identity_client_id": {"key": "delegatedIdentityClientId", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity_type: Optional[Union[str, "_models.IdentityType"]] = None,
        user_assigned_identity_resource_id: Optional[str] = None,
        delegated_identity_client_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity_type: Values can be systemAssignedIdentity or userAssignedIdentity. Known
         values are: "systemAssignedIdentity", "userAssignedIdentity", and "delegatedResourceIdentity".
        :paramtype identity_type: str or ~azure.mgmt.devcenter.models.IdentityType
        :keyword user_assigned_identity_resource_id: user assigned identity to use for accessing key
         encryption key Url. Ex:
         /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/:code:`<resource
         group>`/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive
         with identityType systemAssignedIdentity and delegatedResourceIdentity.
        :paramtype user_assigned_identity_resource_id: str
        :keyword delegated_identity_client_id: delegated identity to use for accessing key encryption
         key Url. Ex:
         /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/:code:`<resource
         group>`/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive
         with identityType systemAssignedIdentity and userAssignedIdentity - internal use only.
        :paramtype delegated_identity_client_id: str
        """
        super().__init__(**kwargs)
        self.identity_type = identity_type
        self.user_assigned_identity_resource_id = user_assigned_identity_resource_id
        self.delegated_identity_client_id = delegated_identity_client_id


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class DevBoxDefinition(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Represents a definition for a Developer Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar image_reference: Image reference information.
    :vartype image_reference: ~azure.mgmt.devcenter.models.ImageReference
    :ivar sku: The SKU for Dev Boxes created using this definition.
    :vartype sku: ~azure.mgmt.devcenter.models.Sku
    :ivar os_storage_type: The storage type used for the Operating System disk of Dev Boxes created
     using this definition.
    :vartype os_storage_type: str
    :ivar hibernate_support: Indicates whether Dev Boxes created with this definition are capable
     of hibernation. Not all images are capable of supporting hibernation. To find out more see
     https://aka.ms/devbox/hibernate. Known values are: "Disabled" and "Enabled".
    :vartype hibernate_support: str or ~azure.mgmt.devcenter.models.HibernateSupport
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar image_validation_status: Validation status of the configured image. Known values are:
     "Unknown", "Pending", "Succeeded", "Failed", and "TimedOut".
    :vartype image_validation_status: str or ~azure.mgmt.devcenter.models.ImageValidationStatus
    :ivar image_validation_error_details: Details for image validator error. Populated when the
     image validation is not successful.
    :vartype image_validation_error_details:
     ~azure.mgmt.devcenter.models.ImageValidationErrorDetails
    :ivar validation_status: Validation status for the Dev Box Definition. Known values are:
     "Unknown", "Pending", "Succeeded", and "Failed".
    :vartype validation_status: str or ~azure.mgmt.devcenter.models.CatalogResourceValidationStatus
    :ivar active_image_reference: Image reference information for the currently active image (only
     populated during updates).
    :vartype active_image_reference: ~azure.mgmt.devcenter.models.ImageReference
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "image_validation_status": {"readonly": True},
        "image_validation_error_details": {"readonly": True},
        "validation_status": {"readonly": True},
        "active_image_reference": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "image_reference": {"key": "properties.imageReference", "type": "ImageReference"},
        "sku": {"key": "properties.sku", "type": "Sku"},
        "os_storage_type": {"key": "properties.osStorageType", "type": "str"},
        "hibernate_support": {"key": "properties.hibernateSupport", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "image_validation_status": {"key": "properties.imageValidationStatus", "type": "str"},
        "image_validation_error_details": {
            "key": "properties.imageValidationErrorDetails",
            "type": "ImageValidationErrorDetails",
        },
        "validation_status": {"key": "properties.validationStatus", "type": "str"},
        "active_image_reference": {"key": "properties.activeImageReference", "type": "ImageReference"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        image_reference: Optional["_models.ImageReference"] = None,
        sku: Optional["_models.Sku"] = None,
        os_storage_type: Optional[str] = None,
        hibernate_support: Optional[Union[str, "_models.HibernateSupport"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword image_reference: Image reference information.
        :paramtype image_reference: ~azure.mgmt.devcenter.models.ImageReference
        :keyword sku: The SKU for Dev Boxes created using this definition.
        :paramtype sku: ~azure.mgmt.devcenter.models.Sku
        :keyword os_storage_type: The storage type used for the Operating System disk of Dev Boxes
         created using this definition.
        :paramtype os_storage_type: str
        :keyword hibernate_support: Indicates whether Dev Boxes created with this definition are
         capable of hibernation. Not all images are capable of supporting hibernation. To find out more
         see https://aka.ms/devbox/hibernate. Known values are: "Disabled" and "Enabled".
        :paramtype hibernate_support: str or ~azure.mgmt.devcenter.models.HibernateSupport
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.image_reference = image_reference
        self.sku = sku
        self.os_storage_type = os_storage_type
        self.hibernate_support = hibernate_support
        self.provisioning_state = None
        self.image_validation_status = None
        self.image_validation_error_details = None
        self.validation_status = None
        self.active_image_reference = None


class DevBoxDefinitionListResult(_serialization.Model):
    """Results of the Dev Box definition list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.DevBoxDefinition]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DevBoxDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class DevBoxDefinitionUpdateProperties(_serialization.Model):
    """Properties of a Dev Box definition. These properties can be updated after the resource has been
    created.

    :ivar image_reference: Image reference information.
    :vartype image_reference: ~azure.mgmt.devcenter.models.ImageReference
    :ivar sku: The SKU for Dev Boxes created using this definition.
    :vartype sku: ~azure.mgmt.devcenter.models.Sku
    :ivar os_storage_type: The storage type used for the Operating System disk of Dev Boxes created
     using this definition.
    :vartype os_storage_type: str
    :ivar hibernate_support: Indicates whether Dev Boxes created with this definition are capable
     of hibernation. Not all images are capable of supporting hibernation. To find out more see
     https://aka.ms/devbox/hibernate. Known values are: "Disabled" and "Enabled".
    :vartype hibernate_support: str or ~azure.mgmt.devcenter.models.HibernateSupport
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "sku": {"key": "sku", "type": "Sku"},
        "os_storage_type": {"key": "osStorageType", "type": "str"},
        "hibernate_support": {"key": "hibernateSupport", "type": "str"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        sku: Optional["_models.Sku"] = None,
        os_storage_type: Optional[str] = None,
        hibernate_support: Optional[Union[str, "_models.HibernateSupport"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_reference: Image reference information.
        :paramtype image_reference: ~azure.mgmt.devcenter.models.ImageReference
        :keyword sku: The SKU for Dev Boxes created using this definition.
        :paramtype sku: ~azure.mgmt.devcenter.models.Sku
        :keyword os_storage_type: The storage type used for the Operating System disk of Dev Boxes
         created using this definition.
        :paramtype os_storage_type: str
        :keyword hibernate_support: Indicates whether Dev Boxes created with this definition are
         capable of hibernation. Not all images are capable of supporting hibernation. To find out more
         see https://aka.ms/devbox/hibernate. Known values are: "Disabled" and "Enabled".
        :paramtype hibernate_support: str or ~azure.mgmt.devcenter.models.HibernateSupport
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.sku = sku
        self.os_storage_type = os_storage_type
        self.hibernate_support = hibernate_support


class DevBoxDefinitionProperties(DevBoxDefinitionUpdateProperties):
    """Properties of a Dev Box definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar image_reference: Image reference information.
    :vartype image_reference: ~azure.mgmt.devcenter.models.ImageReference
    :ivar sku: The SKU for Dev Boxes created using this definition.
    :vartype sku: ~azure.mgmt.devcenter.models.Sku
    :ivar os_storage_type: The storage type used for the Operating System disk of Dev Boxes created
     using this definition.
    :vartype os_storage_type: str
    :ivar hibernate_support: Indicates whether Dev Boxes created with this definition are capable
     of hibernation. Not all images are capable of supporting hibernation. To find out more see
     https://aka.ms/devbox/hibernate. Known values are: "Disabled" and "Enabled".
    :vartype hibernate_support: str or ~azure.mgmt.devcenter.models.HibernateSupport
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar image_validation_status: Validation status of the configured image. Known values are:
     "Unknown", "Pending", "Succeeded", "Failed", and "TimedOut".
    :vartype image_validation_status: str or ~azure.mgmt.devcenter.models.ImageValidationStatus
    :ivar image_validation_error_details: Details for image validator error. Populated when the
     image validation is not successful.
    :vartype image_validation_error_details:
     ~azure.mgmt.devcenter.models.ImageValidationErrorDetails
    :ivar validation_status: Validation status for the Dev Box Definition. Known values are:
     "Unknown", "Pending", "Succeeded", and "Failed".
    :vartype validation_status: str or ~azure.mgmt.devcenter.models.CatalogResourceValidationStatus
    :ivar active_image_reference: Image reference information for the currently active image (only
     populated during updates).
    :vartype active_image_reference: ~azure.mgmt.devcenter.models.ImageReference
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "image_validation_status": {"readonly": True},
        "image_validation_error_details": {"readonly": True},
        "validation_status": {"readonly": True},
        "active_image_reference": {"readonly": True},
    }

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "sku": {"key": "sku", "type": "Sku"},
        "os_storage_type": {"key": "osStorageType", "type": "str"},
        "hibernate_support": {"key": "hibernateSupport", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "image_validation_status": {"key": "imageValidationStatus", "type": "str"},
        "image_validation_error_details": {"key": "imageValidationErrorDetails", "type": "ImageValidationErrorDetails"},
        "validation_status": {"key": "validationStatus", "type": "str"},
        "active_image_reference": {"key": "activeImageReference", "type": "ImageReference"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        sku: Optional["_models.Sku"] = None,
        os_storage_type: Optional[str] = None,
        hibernate_support: Optional[Union[str, "_models.HibernateSupport"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_reference: Image reference information.
        :paramtype image_reference: ~azure.mgmt.devcenter.models.ImageReference
        :keyword sku: The SKU for Dev Boxes created using this definition.
        :paramtype sku: ~azure.mgmt.devcenter.models.Sku
        :keyword os_storage_type: The storage type used for the Operating System disk of Dev Boxes
         created using this definition.
        :paramtype os_storage_type: str
        :keyword hibernate_support: Indicates whether Dev Boxes created with this definition are
         capable of hibernation. Not all images are capable of supporting hibernation. To find out more
         see https://aka.ms/devbox/hibernate. Known values are: "Disabled" and "Enabled".
        :paramtype hibernate_support: str or ~azure.mgmt.devcenter.models.HibernateSupport
        """
        super().__init__(
            image_reference=image_reference,
            sku=sku,
            os_storage_type=os_storage_type,
            hibernate_support=hibernate_support,
            **kwargs
        )
        self.provisioning_state = None
        self.image_validation_status = None
        self.image_validation_error_details = None
        self.validation_status = None
        self.active_image_reference = None


class TrackedResourceUpdate(_serialization.Model):
    """Base tracked resource type for PATCH updates.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class DevBoxDefinitionUpdate(TrackedResourceUpdate):
    """Partial update of a Dev Box definition resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar image_reference: Image reference information.
    :vartype image_reference: ~azure.mgmt.devcenter.models.ImageReference
    :ivar sku: The SKU for Dev Boxes created using this definition.
    :vartype sku: ~azure.mgmt.devcenter.models.Sku
    :ivar os_storage_type: The storage type used for the Operating System disk of Dev Boxes created
     using this definition.
    :vartype os_storage_type: str
    :ivar hibernate_support: Indicates whether Dev Boxes created with this definition are capable
     of hibernation. Not all images are capable of supporting hibernation. To find out more see
     https://aka.ms/devbox/hibernate. Known values are: "Disabled" and "Enabled".
    :vartype hibernate_support: str or ~azure.mgmt.devcenter.models.HibernateSupport
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "image_reference": {"key": "properties.imageReference", "type": "ImageReference"},
        "sku": {"key": "properties.sku", "type": "Sku"},
        "os_storage_type": {"key": "properties.osStorageType", "type": "str"},
        "hibernate_support": {"key": "properties.hibernateSupport", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        image_reference: Optional["_models.ImageReference"] = None,
        sku: Optional["_models.Sku"] = None,
        os_storage_type: Optional[str] = None,
        hibernate_support: Optional[Union[str, "_models.HibernateSupport"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword image_reference: Image reference information.
        :paramtype image_reference: ~azure.mgmt.devcenter.models.ImageReference
        :keyword sku: The SKU for Dev Boxes created using this definition.
        :paramtype sku: ~azure.mgmt.devcenter.models.Sku
        :keyword os_storage_type: The storage type used for the Operating System disk of Dev Boxes
         created using this definition.
        :paramtype os_storage_type: str
        :keyword hibernate_support: Indicates whether Dev Boxes created with this definition are
         capable of hibernation. Not all images are capable of supporting hibernation. To find out more
         see https://aka.ms/devbox/hibernate. Known values are: "Disabled" and "Enabled".
        :paramtype hibernate_support: str or ~azure.mgmt.devcenter.models.HibernateSupport
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.image_reference = image_reference
        self.sku = sku
        self.os_storage_type = os_storage_type
        self.hibernate_support = hibernate_support


class DevCenter(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Represents a devcenter resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Managed identity properties.
    :vartype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
    :ivar encryption: Encryption settings to be used for server-side encryption for proprietary
     content (such as catalogs, logs, customizations).
    :vartype encryption: ~azure.mgmt.devcenter.models.Encryption
    :ivar display_name: The display name of the devcenter.
    :vartype display_name: str
    :ivar project_catalog_settings: Dev Center settings to be used when associating a project with
     a catalog.
    :vartype project_catalog_settings: ~azure.mgmt.devcenter.models.DevCenterProjectCatalogSettings
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar dev_center_uri: The URI of the Dev Center.
    :vartype dev_center_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "dev_center_uri": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "project_catalog_settings": {
            "key": "properties.projectCatalogSettings",
            "type": "DevCenterProjectCatalogSettings",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "dev_center_uri": {"key": "properties.devCenterUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        encryption: Optional["_models.Encryption"] = None,
        display_name: Optional[str] = None,
        project_catalog_settings: Optional["_models.DevCenterProjectCatalogSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed identity properties.
        :paramtype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
        :keyword encryption: Encryption settings to be used for server-side encryption for proprietary
         content (such as catalogs, logs, customizations).
        :paramtype encryption: ~azure.mgmt.devcenter.models.Encryption
        :keyword display_name: The display name of the devcenter.
        :paramtype display_name: str
        :keyword project_catalog_settings: Dev Center settings to be used when associating a project
         with a catalog.
        :paramtype project_catalog_settings:
         ~azure.mgmt.devcenter.models.DevCenterProjectCatalogSettings
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.encryption = encryption
        self.display_name = display_name
        self.project_catalog_settings = project_catalog_settings
        self.provisioning_state = None
        self.dev_center_uri = None


class DevCenterListResult(_serialization.Model):
    """Result of the list devcenters operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.DevCenter]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DevCenter]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class DevCenterProjectCatalogSettings(_serialization.Model):
    """Project catalog settings for project catalogs under a project associated to this dev center.

    :ivar catalog_item_sync_enable_status: Whether project catalogs associated with projects in
     this dev center can be configured to sync catalog items. Known values are: "Enabled" and
     "Disabled".
    :vartype catalog_item_sync_enable_status: str or
     ~azure.mgmt.devcenter.models.CatalogItemSyncEnableStatus
    """

    _attribute_map = {
        "catalog_item_sync_enable_status": {"key": "catalogItemSyncEnableStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        catalog_item_sync_enable_status: Optional[Union[str, "_models.CatalogItemSyncEnableStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword catalog_item_sync_enable_status: Whether project catalogs associated with projects in
         this dev center can be configured to sync catalog items. Known values are: "Enabled" and
         "Disabled".
        :paramtype catalog_item_sync_enable_status: str or
         ~azure.mgmt.devcenter.models.CatalogItemSyncEnableStatus
        """
        super().__init__(**kwargs)
        self.catalog_item_sync_enable_status = catalog_item_sync_enable_status


class DevCenterUpdateProperties(_serialization.Model):
    """Properties of the devcenter. These properties can be updated after the resource has been
    created.

    :ivar encryption: Encryption settings to be used for server-side encryption for proprietary
     content (such as catalogs, logs, customizations).
    :vartype encryption: ~azure.mgmt.devcenter.models.Encryption
    :ivar display_name: The display name of the devcenter.
    :vartype display_name: str
    :ivar project_catalog_settings: Dev Center settings to be used when associating a project with
     a catalog.
    :vartype project_catalog_settings: ~azure.mgmt.devcenter.models.DevCenterProjectCatalogSettings
    """

    _attribute_map = {
        "encryption": {"key": "encryption", "type": "Encryption"},
        "display_name": {"key": "displayName", "type": "str"},
        "project_catalog_settings": {"key": "projectCatalogSettings", "type": "DevCenterProjectCatalogSettings"},
    }

    def __init__(
        self,
        *,
        encryption: Optional["_models.Encryption"] = None,
        display_name: Optional[str] = None,
        project_catalog_settings: Optional["_models.DevCenterProjectCatalogSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encryption: Encryption settings to be used for server-side encryption for proprietary
         content (such as catalogs, logs, customizations).
        :paramtype encryption: ~azure.mgmt.devcenter.models.Encryption
        :keyword display_name: The display name of the devcenter.
        :paramtype display_name: str
        :keyword project_catalog_settings: Dev Center settings to be used when associating a project
         with a catalog.
        :paramtype project_catalog_settings:
         ~azure.mgmt.devcenter.models.DevCenterProjectCatalogSettings
        """
        super().__init__(**kwargs)
        self.encryption = encryption
        self.display_name = display_name
        self.project_catalog_settings = project_catalog_settings


class DevCenterProperties(DevCenterUpdateProperties):
    """Properties of the devcenter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar encryption: Encryption settings to be used for server-side encryption for proprietary
     content (such as catalogs, logs, customizations).
    :vartype encryption: ~azure.mgmt.devcenter.models.Encryption
    :ivar display_name: The display name of the devcenter.
    :vartype display_name: str
    :ivar project_catalog_settings: Dev Center settings to be used when associating a project with
     a catalog.
    :vartype project_catalog_settings: ~azure.mgmt.devcenter.models.DevCenterProjectCatalogSettings
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar dev_center_uri: The URI of the Dev Center.
    :vartype dev_center_uri: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "dev_center_uri": {"readonly": True},
    }

    _attribute_map = {
        "encryption": {"key": "encryption", "type": "Encryption"},
        "display_name": {"key": "displayName", "type": "str"},
        "project_catalog_settings": {"key": "projectCatalogSettings", "type": "DevCenterProjectCatalogSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "dev_center_uri": {"key": "devCenterUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        encryption: Optional["_models.Encryption"] = None,
        display_name: Optional[str] = None,
        project_catalog_settings: Optional["_models.DevCenterProjectCatalogSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encryption: Encryption settings to be used for server-side encryption for proprietary
         content (such as catalogs, logs, customizations).
        :paramtype encryption: ~azure.mgmt.devcenter.models.Encryption
        :keyword display_name: The display name of the devcenter.
        :paramtype display_name: str
        :keyword project_catalog_settings: Dev Center settings to be used when associating a project
         with a catalog.
        :paramtype project_catalog_settings:
         ~azure.mgmt.devcenter.models.DevCenterProjectCatalogSettings
        """
        super().__init__(
            encryption=encryption,
            display_name=display_name,
            project_catalog_settings=project_catalog_settings,
            **kwargs
        )
        self.provisioning_state = None
        self.dev_center_uri = None


class Sku(_serialization.Model):
    """The resource model definition representing SKU.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the SKU. Ex - P3. It is typically a letter+number code. Required.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
     "Standard", and "Premium".
    :vartype tier: str or ~azure.mgmt.devcenter.models.SkuTier
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SKU. Ex - P3. It is typically a letter+number code. Required.
        :paramtype name: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
         "Standard", and "Premium".
        :paramtype tier: str or ~azure.mgmt.devcenter.models.SkuTier
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity


class DevCenterSku(Sku):
    """The resource model definition representing SKU for DevCenter resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the SKU. Ex - P3. It is typically a letter+number code. Required.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
     "Standard", and "Premium".
    :vartype tier: str or ~azure.mgmt.devcenter.models.SkuTier
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    :ivar resource_type: The name of the resource type.
    :vartype resource_type: str
    :ivar locations: SKU supported locations.
    :vartype locations: list[str]
    :ivar capabilities: Collection of name/value pairs to describe the SKU capabilities.
    :vartype capabilities: list[~azure.mgmt.devcenter.models.Capability]
    """

    _validation = {
        "name": {"required": True},
        "resource_type": {"readonly": True},
        "locations": {"readonly": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[Capability]"},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SKU. Ex - P3. It is typically a letter+number code. Required.
        :paramtype name: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
         "Standard", and "Premium".
        :paramtype tier: str or ~azure.mgmt.devcenter.models.SkuTier
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        """
        super().__init__(name=name, tier=tier, size=size, family=family, capacity=capacity, **kwargs)
        self.resource_type = None
        self.locations = None
        self.capabilities = None


class DevCenterUpdate(TrackedResourceUpdate):
    """The devcenter resource for partial updates. Properties not provided in the update request will
    not be changed.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed identity properties.
    :vartype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
    :ivar encryption: Encryption settings to be used for server-side encryption for proprietary
     content (such as catalogs, logs, customizations).
    :vartype encryption: ~azure.mgmt.devcenter.models.Encryption
    :ivar display_name: The display name of the devcenter.
    :vartype display_name: str
    :ivar project_catalog_settings: Dev Center settings to be used when associating a project with
     a catalog.
    :vartype project_catalog_settings: ~azure.mgmt.devcenter.models.DevCenterProjectCatalogSettings
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "project_catalog_settings": {
            "key": "properties.projectCatalogSettings",
            "type": "DevCenterProjectCatalogSettings",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        encryption: Optional["_models.Encryption"] = None,
        display_name: Optional[str] = None,
        project_catalog_settings: Optional["_models.DevCenterProjectCatalogSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed identity properties.
        :paramtype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
        :keyword encryption: Encryption settings to be used for server-side encryption for proprietary
         content (such as catalogs, logs, customizations).
        :paramtype encryption: ~azure.mgmt.devcenter.models.Encryption
        :keyword display_name: The display name of the devcenter.
        :paramtype display_name: str
        :keyword project_catalog_settings: Dev Center settings to be used when associating a project
         with a catalog.
        :paramtype project_catalog_settings:
         ~azure.mgmt.devcenter.models.DevCenterProjectCatalogSettings
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.encryption = encryption
        self.display_name = display_name
        self.project_catalog_settings = project_catalog_settings


class Encryption(_serialization.Model):
    """Encryption.

    :ivar customer_managed_key_encryption: All Customer-managed key encryption properties for the
     resource.
    :vartype customer_managed_key_encryption:
     ~azure.mgmt.devcenter.models.CustomerManagedKeyEncryption
    """

    _attribute_map = {
        "customer_managed_key_encryption": {
            "key": "customerManagedKeyEncryption",
            "type": "CustomerManagedKeyEncryption",
        },
    }

    def __init__(
        self, *, customer_managed_key_encryption: Optional["_models.CustomerManagedKeyEncryption"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword customer_managed_key_encryption: All Customer-managed key encryption properties for
         the resource.
        :paramtype customer_managed_key_encryption:
         ~azure.mgmt.devcenter.models.CustomerManagedKeyEncryption
        """
        super().__init__(**kwargs)
        self.customer_managed_key_encryption = customer_managed_key_encryption


class EndpointDependency(_serialization.Model):
    """A domain name and connection details used to access a dependency.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar domain_name: The domain name of the dependency. Domain names may be fully qualified or
     may contain a * wildcard.
    :vartype domain_name: str
    :ivar description: Human-readable supplemental information about the dependency and when it is
     applicable.
    :vartype description: str
    :ivar endpoint_details: The list of connection details for this endpoint.
    :vartype endpoint_details: list[~azure.mgmt.devcenter.models.EndpointDetail]
    """

    _validation = {
        "domain_name": {"readonly": True},
        "description": {"readonly": True},
        "endpoint_details": {"readonly": True},
    }

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "endpoint_details": {"key": "endpointDetails", "type": "[EndpointDetail]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.domain_name = None
        self.description = None
        self.endpoint_details = None


class EndpointDetail(_serialization.Model):
    """Details about the connection between the Batch service and the endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    """

    _validation = {
        "port": {"readonly": True},
    }

    _attribute_map = {
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.port = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    """


class EnvironmentDefinition(ProxyResource):
    """Represents an environment definition catalog item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar description: A short description of the environment definition.
    :vartype description: str
    :ivar parameters: Input parameters passed to an environment.
    :vartype parameters: list[~azure.mgmt.devcenter.models.EnvironmentDefinitionParameter]
    :ivar template_path: Path to the Environment Definition entrypoint file.
    :vartype template_path: str
    :ivar validation_status: Validation status for the environment definition. Known values are:
     "Unknown", "Pending", "Succeeded", and "Failed".
    :vartype validation_status: str or ~azure.mgmt.devcenter.models.CatalogResourceValidationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "description": {"readonly": True},
        "parameters": {"readonly": True},
        "template_path": {"readonly": True},
        "validation_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "[EnvironmentDefinitionParameter]"},
        "template_path": {"key": "properties.templatePath", "type": "str"},
        "validation_status": {"key": "properties.validationStatus", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.description = None
        self.parameters = None
        self.template_path = None
        self.validation_status = None


class EnvironmentDefinitionListResult(_serialization.Model):
    """Results of the environment definition list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.EnvironmentDefinition]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EnvironmentDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class EnvironmentDefinitionParameter(_serialization.Model):
    """Properties of an Environment Definition parameter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Unique ID of the parameter.
    :vartype id: str
    :ivar name: Display name of the parameter.
    :vartype name: str
    :ivar description: Description of the parameter.
    :vartype description: str
    :ivar type: A string of one of the basic JSON types (number, integer, array, object, boolean,
     string). Known values are: "array", "boolean", "integer", "number", "object", and "string".
    :vartype type: str or ~azure.mgmt.devcenter.models.ParameterType
    :ivar read_only: Whether or not this parameter is read-only.  If true, default should have a
     value.
    :vartype read_only: bool
    :ivar required: Whether or not this parameter is required.
    :vartype required: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "description": {"readonly": True},
        "type": {"readonly": True},
        "read_only": {"readonly": True},
        "required": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "read_only": {"key": "readOnly", "type": "bool"},
        "required": {"key": "required", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.description = None
        self.type = None
        self.read_only = None
        self.required = None


class EnvironmentRole(_serialization.Model):
    """A role that can be assigned to a user.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar role_name: The common name of the Role Assignment. This is a descriptive name such as
     'AcrPush'.
    :vartype role_name: str
    :ivar description: This is a description of the Role Assignment.
    :vartype description: str
    """

    _validation = {
        "role_name": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "role_name": {"key": "roleName", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.role_name = None
        self.description = None


class EnvironmentType(Resource):
    """Represents an environment type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar display_name: The display name of the environment type.
    :vartype display_name: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, display_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword display_name: The display name of the environment type.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.display_name = display_name
        self.provisioning_state = None


class EnvironmentTypeListResult(_serialization.Model):
    """Result of the environment type list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.EnvironmentType]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EnvironmentType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class EnvironmentTypeUpdateProperties(_serialization.Model):
    """Properties of an environment type. These properties can be updated after the resource has been
    created.

    :ivar display_name: The display name of the environment type.
    :vartype display_name: str
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(self, *, display_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword display_name: The display name of the environment type.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.display_name = display_name


class EnvironmentTypeProperties(EnvironmentTypeUpdateProperties):
    """Properties of an environment type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: The display name of the environment type.
    :vartype display_name: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, *, display_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword display_name: The display name of the environment type.
        :paramtype display_name: str
        """
        super().__init__(display_name=display_name, **kwargs)
        self.provisioning_state = None


class EnvironmentTypeUpdate(_serialization.Model):
    """The environment type for partial update. Properties not provided in the update request will not
    be changed.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar display_name: The display name of the environment type.
    :vartype display_name: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "display_name": {"key": "properties.displayName", "type": "str"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, display_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword display_name: The display name of the environment type.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.display_name = display_name


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.devcenter.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.devcenter.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.devcenter.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.devcenter.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Gallery(Resource):
    """Represents a gallery.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar gallery_resource_id: The resource ID of the backing Azure Compute Gallery.
    :vartype gallery_resource_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gallery_resource_id": {"key": "properties.galleryResourceId", "type": "str"},
    }

    def __init__(self, *, gallery_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword gallery_resource_id: The resource ID of the backing Azure Compute Gallery.
        :paramtype gallery_resource_id: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.gallery_resource_id = gallery_resource_id


class GalleryListResult(_serialization.Model):
    """Results of the gallery list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.Gallery]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Gallery]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class GitCatalog(_serialization.Model):
    """Properties for a Git repository catalog.

    :ivar uri: Git URI.
    :vartype uri: str
    :ivar branch: Git branch.
    :vartype branch: str
    :ivar secret_identifier: A reference to the Key Vault secret containing a security token to
     authenticate to a Git repository.
    :vartype secret_identifier: str
    :ivar path: The folder where the catalog items can be found inside the repository.
    :vartype path: str
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
        "branch": {"key": "branch", "type": "str"},
        "secret_identifier": {"key": "secretIdentifier", "type": "str"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        branch: Optional[str] = None,
        secret_identifier: Optional[str] = None,
        path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword uri: Git URI.
        :paramtype uri: str
        :keyword branch: Git branch.
        :paramtype branch: str
        :keyword secret_identifier: A reference to the Key Vault secret containing a security token to
         authenticate to a Git repository.
        :paramtype secret_identifier: str
        :keyword path: The folder where the catalog items can be found inside the repository.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.uri = uri
        self.branch = branch
        self.secret_identifier = secret_identifier
        self.path = path


class HealthCheck(_serialization.Model):
    """An individual health check item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the health check item. Known values are: "Unknown", "Pending",
     "Running", "Passed", "Warning", and "Failed".
    :vartype status: str or ~azure.mgmt.devcenter.models.HealthCheckStatus
    :ivar display_name: The display name of this health check item.
    :vartype display_name: str
    :ivar start_date_time: Start time of health check item.
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: End time of the health check item.
    :vartype end_date_time: ~datetime.datetime
    :ivar error_type: The type of error that occurred during this health check.
    :vartype error_type: str
    :ivar recommended_action: The recommended action to fix the corresponding error.
    :vartype recommended_action: str
    :ivar additional_details: Additional details about the health check or the recommended action.
    :vartype additional_details: str
    """

    _validation = {
        "status": {"readonly": True},
        "display_name": {"readonly": True},
        "start_date_time": {"readonly": True},
        "end_date_time": {"readonly": True},
        "error_type": {"readonly": True},
        "recommended_action": {"readonly": True},
        "additional_details": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "start_date_time": {"key": "startDateTime", "type": "iso-8601"},
        "end_date_time": {"key": "endDateTime", "type": "iso-8601"},
        "error_type": {"key": "errorType", "type": "str"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
        "additional_details": {"key": "additionalDetails", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.display_name = None
        self.start_date_time = None
        self.end_date_time = None
        self.error_type = None
        self.recommended_action = None
        self.additional_details = None


class HealthCheckStatusDetails(Resource):
    """Health Check details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar start_date_time: Start time of last execution of the health checks.
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: End time of last execution of the health checks.
    :vartype end_date_time: ~datetime.datetime
    :ivar health_checks: Details for each health check item.
    :vartype health_checks: list[~azure.mgmt.devcenter.models.HealthCheck]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "start_date_time": {"readonly": True},
        "end_date_time": {"readonly": True},
        "health_checks": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "start_date_time": {"key": "properties.startDateTime", "type": "iso-8601"},
        "end_date_time": {"key": "properties.endDateTime", "type": "iso-8601"},
        "health_checks": {"key": "properties.healthChecks", "type": "[HealthCheck]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.start_date_time = None
        self.end_date_time = None
        self.health_checks = None


class HealthCheckStatusDetailsListResult(_serialization.Model):
    """Result of the network health check list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.HealthCheckStatusDetails]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HealthCheckStatusDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class HealthStatusDetail(_serialization.Model):
    """Pool health status detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: An identifier for the issue.
    :vartype code: str
    :ivar message: A message describing the issue, intended to be suitable for display in a user
     interface.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None


class Image(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Represents an image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar description: The description of the image.
    :vartype description: str
    :ivar publisher: The publisher of the image.
    :vartype publisher: str
    :ivar offer: The name of the image offer.
    :vartype offer: str
    :ivar sku: The SKU name for the image.
    :vartype sku: str
    :ivar recommended_machine_configuration: The recommended machine configuration to use with the
     image.
    :vartype recommended_machine_configuration:
     ~azure.mgmt.devcenter.models.RecommendedMachineConfiguration
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar hibernate_support: Indicates whether this image has hibernate enabled. Not all images are
     capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate. Known
     values are: "Disabled" and "Enabled".
    :vartype hibernate_support: str or ~azure.mgmt.devcenter.models.HibernateSupport
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "description": {"readonly": True},
        "publisher": {"readonly": True},
        "offer": {"readonly": True},
        "sku": {"readonly": True},
        "recommended_machine_configuration": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "hibernate_support": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "offer": {"key": "properties.offer", "type": "str"},
        "sku": {"key": "properties.sku", "type": "str"},
        "recommended_machine_configuration": {
            "key": "properties.recommendedMachineConfiguration",
            "type": "RecommendedMachineConfiguration",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "hibernate_support": {"key": "properties.hibernateSupport", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.description = None
        self.publisher = None
        self.offer = None
        self.sku = None
        self.recommended_machine_configuration = None
        self.provisioning_state = None
        self.hibernate_support = None


class ImageListResult(_serialization.Model):
    """Results of the image list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.Image]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Image]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ImageReference(_serialization.Model):
    """Image reference information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Image ID, or Image version ID. When Image ID is provided, its latest version will be
     used.
    :vartype id: str
    :ivar exact_version: The actual version of the image after use. When id references a gallery
     image latest version, this will indicate the actual version in use.
    :vartype exact_version: str
    """

    _validation = {
        "exact_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "exact_version": {"key": "exactVersion", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Image ID, or Image version ID. When Image ID is provided, its latest version will
         be used.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.exact_version = None


class ImageValidationErrorDetails(_serialization.Model):
    """Image validation error details.

    :ivar code: An identifier for the error.
    :vartype code: str
    :ivar message: A message describing the error.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: An identifier for the error.
        :paramtype code: str
        :keyword message: A message describing the error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ImageVersion(ProxyResource):
    """Represents an image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar name_properties_name: The semantic version string.
    :vartype name_properties_name: str
    :ivar published_date: The datetime that the backing image version was published.
    :vartype published_date: ~datetime.datetime
    :ivar exclude_from_latest: If the version should be excluded from being treated as the latest
     version.
    :vartype exclude_from_latest: bool
    :ivar os_disk_image_size_in_gb: The size of the OS disk image, in GB.
    :vartype os_disk_image_size_in_gb: int
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "name_properties_name": {"readonly": True},
        "published_date": {"readonly": True},
        "exclude_from_latest": {"readonly": True},
        "os_disk_image_size_in_gb": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "published_date": {"key": "properties.publishedDate", "type": "iso-8601"},
        "exclude_from_latest": {"key": "properties.excludeFromLatest", "type": "bool"},
        "os_disk_image_size_in_gb": {"key": "properties.osDiskImageSizeInGb", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name_properties_name = None
        self.published_date = None
        self.exclude_from_latest = None
        self.os_disk_image_size_in_gb = None
        self.provisioning_state = None


class ImageVersionListResult(_serialization.Model):
    """Results of the image version list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.ImageVersion]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ImageVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListUsagesResult(_serialization.Model):
    """List of Core Usages.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The array page of Usages.
    :vartype value: list[~azure.mgmt.devcenter.models.Usage]
    :ivar next_link: The link to get the next page of Usage result.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.devcenter.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.devcenter.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.devcenter.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.devcenter.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class NetworkConnection(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Network related settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar subnet_id: The subnet to attach Virtual Machines to.
    :vartype subnet_id: str
    :ivar domain_name: Active Directory domain name.
    :vartype domain_name: str
    :ivar organization_unit: Active Directory domain Organization Unit (OU).
    :vartype organization_unit: str
    :ivar domain_username: The username of an Active Directory account (user or service account)
     that has permissions to create computer objects in Active Directory. Required format:
     admin@contoso.com.
    :vartype domain_username: str
    :ivar domain_password: The password for the account used to join domain.
    :vartype domain_password: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar health_check_status: Overall health status of the network connection. Health checks are
     run on creation, update, and periodically to validate the network connection. Known values are:
     "Unknown", "Pending", "Running", "Passed", "Warning", and "Failed".
    :vartype health_check_status: str or ~azure.mgmt.devcenter.models.HealthCheckStatus
    :ivar networking_resource_group_name: The name for resource group where NICs will be placed.
    :vartype networking_resource_group_name: str
    :ivar domain_join_type: AAD Join type. Known values are: "HybridAzureADJoin" and "AzureADJoin".
    :vartype domain_join_type: str or ~azure.mgmt.devcenter.models.DomainJoinType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "health_check_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "subnet_id": {"key": "properties.subnetId", "type": "str"},
        "domain_name": {"key": "properties.domainName", "type": "str"},
        "organization_unit": {"key": "properties.organizationUnit", "type": "str"},
        "domain_username": {"key": "properties.domainUsername", "type": "str"},
        "domain_password": {"key": "properties.domainPassword", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "health_check_status": {"key": "properties.healthCheckStatus", "type": "str"},
        "networking_resource_group_name": {"key": "properties.networkingResourceGroupName", "type": "str"},
        "domain_join_type": {"key": "properties.domainJoinType", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        subnet_id: Optional[str] = None,
        domain_name: Optional[str] = None,
        organization_unit: Optional[str] = None,
        domain_username: Optional[str] = None,
        domain_password: Optional[str] = None,
        networking_resource_group_name: Optional[str] = None,
        domain_join_type: Optional[Union[str, "_models.DomainJoinType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword subnet_id: The subnet to attach Virtual Machines to.
        :paramtype subnet_id: str
        :keyword domain_name: Active Directory domain name.
        :paramtype domain_name: str
        :keyword organization_unit: Active Directory domain Organization Unit (OU).
        :paramtype organization_unit: str
        :keyword domain_username: The username of an Active Directory account (user or service account)
         that has permissions to create computer objects in Active Directory. Required format:
         admin@contoso.com.
        :paramtype domain_username: str
        :keyword domain_password: The password for the account used to join domain.
        :paramtype domain_password: str
        :keyword networking_resource_group_name: The name for resource group where NICs will be placed.
        :paramtype networking_resource_group_name: str
        :keyword domain_join_type: AAD Join type. Known values are: "HybridAzureADJoin" and
         "AzureADJoin".
        :paramtype domain_join_type: str or ~azure.mgmt.devcenter.models.DomainJoinType
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.subnet_id = subnet_id
        self.domain_name = domain_name
        self.organization_unit = organization_unit
        self.domain_username = domain_username
        self.domain_password = domain_password
        self.provisioning_state = None
        self.health_check_status = None
        self.networking_resource_group_name = networking_resource_group_name
        self.domain_join_type = domain_join_type


class NetworkConnectionListResult(_serialization.Model):
    """Result of the network connection list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.NetworkConnection]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class NetworkConnectionUpdate(TrackedResourceUpdate):
    """The network connection properties for partial update. Properties not provided in the update
    request will not be changed.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar subnet_id: The subnet to attach Virtual Machines to.
    :vartype subnet_id: str
    :ivar domain_name: Active Directory domain name.
    :vartype domain_name: str
    :ivar organization_unit: Active Directory domain Organization Unit (OU).
    :vartype organization_unit: str
    :ivar domain_username: The username of an Active Directory account (user or service account)
     that has permissions to create computer objects in Active Directory. Required format:
     admin@contoso.com.
    :vartype domain_username: str
    :ivar domain_password: The password for the account used to join domain.
    :vartype domain_password: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "subnet_id": {"key": "properties.subnetId", "type": "str"},
        "domain_name": {"key": "properties.domainName", "type": "str"},
        "organization_unit": {"key": "properties.organizationUnit", "type": "str"},
        "domain_username": {"key": "properties.domainUsername", "type": "str"},
        "domain_password": {"key": "properties.domainPassword", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        subnet_id: Optional[str] = None,
        domain_name: Optional[str] = None,
        organization_unit: Optional[str] = None,
        domain_username: Optional[str] = None,
        domain_password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword subnet_id: The subnet to attach Virtual Machines to.
        :paramtype subnet_id: str
        :keyword domain_name: Active Directory domain name.
        :paramtype domain_name: str
        :keyword organization_unit: Active Directory domain Organization Unit (OU).
        :paramtype organization_unit: str
        :keyword domain_username: The username of an Active Directory account (user or service account)
         that has permissions to create computer objects in Active Directory. Required format:
         admin@contoso.com.
        :paramtype domain_username: str
        :keyword domain_password: The password for the account used to join domain.
        :paramtype domain_password: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.subnet_id = subnet_id
        self.domain_name = domain_name
        self.organization_unit = organization_unit
        self.domain_username = domain_username
        self.domain_password = domain_password


class NetworkConnectionUpdateProperties(_serialization.Model):
    """Properties of network connection. These properties can be updated after the resource has been
    created.

    :ivar subnet_id: The subnet to attach Virtual Machines to.
    :vartype subnet_id: str
    :ivar domain_name: Active Directory domain name.
    :vartype domain_name: str
    :ivar organization_unit: Active Directory domain Organization Unit (OU).
    :vartype organization_unit: str
    :ivar domain_username: The username of an Active Directory account (user or service account)
     that has permissions to create computer objects in Active Directory. Required format:
     admin@contoso.com.
    :vartype domain_username: str
    :ivar domain_password: The password for the account used to join domain.
    :vartype domain_password: str
    """

    _attribute_map = {
        "subnet_id": {"key": "subnetId", "type": "str"},
        "domain_name": {"key": "domainName", "type": "str"},
        "organization_unit": {"key": "organizationUnit", "type": "str"},
        "domain_username": {"key": "domainUsername", "type": "str"},
        "domain_password": {"key": "domainPassword", "type": "str"},
    }

    def __init__(
        self,
        *,
        subnet_id: Optional[str] = None,
        domain_name: Optional[str] = None,
        organization_unit: Optional[str] = None,
        domain_username: Optional[str] = None,
        domain_password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subnet_id: The subnet to attach Virtual Machines to.
        :paramtype subnet_id: str
        :keyword domain_name: Active Directory domain name.
        :paramtype domain_name: str
        :keyword organization_unit: Active Directory domain Organization Unit (OU).
        :paramtype organization_unit: str
        :keyword domain_username: The username of an Active Directory account (user or service account)
         that has permissions to create computer objects in Active Directory. Required format:
         admin@contoso.com.
        :paramtype domain_username: str
        :keyword domain_password: The password for the account used to join domain.
        :paramtype domain_password: str
        """
        super().__init__(**kwargs)
        self.subnet_id = subnet_id
        self.domain_name = domain_name
        self.organization_unit = organization_unit
        self.domain_username = domain_username
        self.domain_password = domain_password


class NetworkProperties(NetworkConnectionUpdateProperties):
    """Network properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar subnet_id: The subnet to attach Virtual Machines to.
    :vartype subnet_id: str
    :ivar domain_name: Active Directory domain name.
    :vartype domain_name: str
    :ivar organization_unit: Active Directory domain Organization Unit (OU).
    :vartype organization_unit: str
    :ivar domain_username: The username of an Active Directory account (user or service account)
     that has permissions to create computer objects in Active Directory. Required format:
     admin@contoso.com.
    :vartype domain_username: str
    :ivar domain_password: The password for the account used to join domain.
    :vartype domain_password: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar health_check_status: Overall health status of the network connection. Health checks are
     run on creation, update, and periodically to validate the network connection. Known values are:
     "Unknown", "Pending", "Running", "Passed", "Warning", and "Failed".
    :vartype health_check_status: str or ~azure.mgmt.devcenter.models.HealthCheckStatus
    :ivar networking_resource_group_name: The name for resource group where NICs will be placed.
    :vartype networking_resource_group_name: str
    :ivar domain_join_type: AAD Join type. Required. Known values are: "HybridAzureADJoin" and
     "AzureADJoin".
    :vartype domain_join_type: str or ~azure.mgmt.devcenter.models.DomainJoinType
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "health_check_status": {"readonly": True},
        "domain_join_type": {"required": True},
    }

    _attribute_map = {
        "subnet_id": {"key": "subnetId", "type": "str"},
        "domain_name": {"key": "domainName", "type": "str"},
        "organization_unit": {"key": "organizationUnit", "type": "str"},
        "domain_username": {"key": "domainUsername", "type": "str"},
        "domain_password": {"key": "domainPassword", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "health_check_status": {"key": "healthCheckStatus", "type": "str"},
        "networking_resource_group_name": {"key": "networkingResourceGroupName", "type": "str"},
        "domain_join_type": {"key": "domainJoinType", "type": "str"},
    }

    def __init__(
        self,
        *,
        domain_join_type: Union[str, "_models.DomainJoinType"],
        subnet_id: Optional[str] = None,
        domain_name: Optional[str] = None,
        organization_unit: Optional[str] = None,
        domain_username: Optional[str] = None,
        domain_password: Optional[str] = None,
        networking_resource_group_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subnet_id: The subnet to attach Virtual Machines to.
        :paramtype subnet_id: str
        :keyword domain_name: Active Directory domain name.
        :paramtype domain_name: str
        :keyword organization_unit: Active Directory domain Organization Unit (OU).
        :paramtype organization_unit: str
        :keyword domain_username: The username of an Active Directory account (user or service account)
         that has permissions to create computer objects in Active Directory. Required format:
         admin@contoso.com.
        :paramtype domain_username: str
        :keyword domain_password: The password for the account used to join domain.
        :paramtype domain_password: str
        :keyword networking_resource_group_name: The name for resource group where NICs will be placed.
        :paramtype networking_resource_group_name: str
        :keyword domain_join_type: AAD Join type. Required. Known values are: "HybridAzureADJoin" and
         "AzureADJoin".
        :paramtype domain_join_type: str or ~azure.mgmt.devcenter.models.DomainJoinType
        """
        super().__init__(
            subnet_id=subnet_id,
            domain_name=domain_name,
            organization_unit=organization_unit,
            domain_username=domain_username,
            domain_password=domain_password,
            **kwargs
        )
        self.provisioning_state = None
        self.health_check_status = None
        self.networking_resource_group_name = networking_resource_group_name
        self.domain_join_type = domain_join_type


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.devcenter.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.devcenter.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.devcenter.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.devcenter.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.devcenter.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar resource_id: Fully qualified ID of the resource against which the original async
     operation was started.
    :vartype resource_id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.devcenter.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.devcenter.models.ErrorDetail
    """

    _validation = {
        "resource_id": {"readonly": True},
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.devcenter.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.devcenter.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.resource_id = None
        self.name = name
        self.status = status
        self.percent_complete = percent_complete
        self.start_time = start_time
        self.end_time = end_time
        self.operations = operations
        self.error = error


class OperationStatus(OperationStatusResult):
    """The current status of an async operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar resource_id: Fully qualified ID of the resource against which the original async
     operation was started.
    :vartype resource_id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.devcenter.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.devcenter.models.ErrorDetail
    :ivar properties: Custom operation properties, populated only for a successful operation.
    :vartype properties: JSON
    """

    _validation = {
        "resource_id": {"readonly": True},
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetail"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.devcenter.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.devcenter.models.ErrorDetail
        """
        super().__init__(
            id=id,
            name=name,
            status=status,
            percent_complete=percent_complete,
            start_time=start_time,
            end_time=end_time,
            operations=operations,
            error=error,
            **kwargs
        )
        self.properties = None


class OutboundEnvironmentEndpoint(_serialization.Model):
    """A collection of related endpoints from the same service for which the agent requires outbound
    access.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar category: The type of service that the agent connects to.
    :vartype category: str
    :ivar endpoints: The endpoints for this service for which the agent requires outbound access.
    :vartype endpoints: list[~azure.mgmt.devcenter.models.EndpointDependency]
    """

    _validation = {
        "category": {"readonly": True},
        "endpoints": {"readonly": True},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[EndpointDependency]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.category = None
        self.endpoints = None


class OutboundEnvironmentEndpointCollection(_serialization.Model):
    """Values returned by the List operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The collection of outbound network dependency endpoints returned by the listing
     operation.
    :vartype value: list[~azure.mgmt.devcenter.models.OutboundEnvironmentEndpoint]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OutboundEnvironmentEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The continuation token.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Pool(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A pool of Virtual Machines.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar dev_box_definition_name: Name of a Dev Box definition in parent Project of this Pool.
    :vartype dev_box_definition_name: str
    :ivar network_connection_name: Name of a Network Connection in parent Project of this Pool.
    :vartype network_connection_name: str
    :ivar license_type: Specifies the license type indicating the caller has already acquired
     licenses for the Dev Boxes that will be created. "Windows_Client"
    :vartype license_type: str or ~azure.mgmt.devcenter.models.LicenseType
    :ivar local_administrator: Indicates whether owners of Dev Boxes in this pool are added as
     local administrators on the Dev Box. Known values are: "Disabled" and "Enabled".
    :vartype local_administrator: str or ~azure.mgmt.devcenter.models.LocalAdminStatus
    :ivar stop_on_disconnect: Stop on disconnect configuration settings for Dev Boxes created in
     this pool.
    :vartype stop_on_disconnect: ~azure.mgmt.devcenter.models.StopOnDisconnectConfiguration
    :ivar single_sign_on_status: Indicates whether Dev Boxes in this pool are created with single
     sign on enabled. The also requires that single sign on be enabled on the tenant. Known values
     are: "Disabled" and "Enabled".
    :vartype single_sign_on_status: str or ~azure.mgmt.devcenter.models.SingleSignOnStatus
    :ivar display_name: The display name of the pool.
    :vartype display_name: str
    :ivar virtual_network_type: Indicates whether the pool uses a Virtual Network managed by
     Microsoft or a customer provided network. Known values are: "Managed" and "Unmanaged".
    :vartype virtual_network_type: str or ~azure.mgmt.devcenter.models.VirtualNetworkType
    :ivar managed_virtual_network_regions: The regions of the managed virtual network (required
     when managedNetworkType is Managed).
    :vartype managed_virtual_network_regions: list[str]
    :ivar health_status: Overall health status of the Pool. Indicates whether or not the Pool is
     available to create Dev Boxes. Known values are: "Unknown", "Pending", "Healthy", "Warning",
     and "Unhealthy".
    :vartype health_status: str or ~azure.mgmt.devcenter.models.HealthStatus
    :ivar health_status_details: Details on the Pool health status to help diagnose issues. This is
     only populated when the pool status indicates the pool is in a non-healthy state.
    :vartype health_status_details: list[~azure.mgmt.devcenter.models.HealthStatusDetail]
    :ivar dev_box_count: Indicates the number of provisioned Dev Boxes in this pool.
    :vartype dev_box_count: int
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "health_status": {"readonly": True},
        "health_status_details": {"readonly": True},
        "dev_box_count": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "dev_box_definition_name": {"key": "properties.devBoxDefinitionName", "type": "str"},
        "network_connection_name": {"key": "properties.networkConnectionName", "type": "str"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "local_administrator": {"key": "properties.localAdministrator", "type": "str"},
        "stop_on_disconnect": {"key": "properties.stopOnDisconnect", "type": "StopOnDisconnectConfiguration"},
        "single_sign_on_status": {"key": "properties.singleSignOnStatus", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "virtual_network_type": {"key": "properties.virtualNetworkType", "type": "str"},
        "managed_virtual_network_regions": {"key": "properties.managedVirtualNetworkRegions", "type": "[str]"},
        "health_status": {"key": "properties.healthStatus", "type": "str"},
        "health_status_details": {"key": "properties.healthStatusDetails", "type": "[HealthStatusDetail]"},
        "dev_box_count": {"key": "properties.devBoxCount", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        dev_box_definition_name: Optional[str] = None,
        network_connection_name: Optional[str] = None,
        license_type: Optional[Union[str, "_models.LicenseType"]] = None,
        local_administrator: Optional[Union[str, "_models.LocalAdminStatus"]] = None,
        stop_on_disconnect: Optional["_models.StopOnDisconnectConfiguration"] = None,
        single_sign_on_status: Optional[Union[str, "_models.SingleSignOnStatus"]] = None,
        display_name: Optional[str] = None,
        virtual_network_type: Optional[Union[str, "_models.VirtualNetworkType"]] = None,
        managed_virtual_network_regions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword dev_box_definition_name: Name of a Dev Box definition in parent Project of this Pool.
        :paramtype dev_box_definition_name: str
        :keyword network_connection_name: Name of a Network Connection in parent Project of this Pool.
        :paramtype network_connection_name: str
        :keyword license_type: Specifies the license type indicating the caller has already acquired
         licenses for the Dev Boxes that will be created. "Windows_Client"
        :paramtype license_type: str or ~azure.mgmt.devcenter.models.LicenseType
        :keyword local_administrator: Indicates whether owners of Dev Boxes in this pool are added as
         local administrators on the Dev Box. Known values are: "Disabled" and "Enabled".
        :paramtype local_administrator: str or ~azure.mgmt.devcenter.models.LocalAdminStatus
        :keyword stop_on_disconnect: Stop on disconnect configuration settings for Dev Boxes created in
         this pool.
        :paramtype stop_on_disconnect: ~azure.mgmt.devcenter.models.StopOnDisconnectConfiguration
        :keyword single_sign_on_status: Indicates whether Dev Boxes in this pool are created with
         single sign on enabled. The also requires that single sign on be enabled on the tenant. Known
         values are: "Disabled" and "Enabled".
        :paramtype single_sign_on_status: str or ~azure.mgmt.devcenter.models.SingleSignOnStatus
        :keyword display_name: The display name of the pool.
        :paramtype display_name: str
        :keyword virtual_network_type: Indicates whether the pool uses a Virtual Network managed by
         Microsoft or a customer provided network. Known values are: "Managed" and "Unmanaged".
        :paramtype virtual_network_type: str or ~azure.mgmt.devcenter.models.VirtualNetworkType
        :keyword managed_virtual_network_regions: The regions of the managed virtual network (required
         when managedNetworkType is Managed).
        :paramtype managed_virtual_network_regions: list[str]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.dev_box_definition_name = dev_box_definition_name
        self.network_connection_name = network_connection_name
        self.license_type = license_type
        self.local_administrator = local_administrator
        self.stop_on_disconnect = stop_on_disconnect
        self.single_sign_on_status = single_sign_on_status
        self.display_name = display_name
        self.virtual_network_type = virtual_network_type
        self.managed_virtual_network_regions = managed_virtual_network_regions
        self.health_status = None
        self.health_status_details = None
        self.dev_box_count = None
        self.provisioning_state = None


class PoolListResult(_serialization.Model):
    """Results of the machine pool list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.Pool]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Pool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PoolUpdateProperties(_serialization.Model):
    """Properties of a Pool. These properties can be updated after the resource has been created.

    :ivar dev_box_definition_name: Name of a Dev Box definition in parent Project of this Pool.
    :vartype dev_box_definition_name: str
    :ivar network_connection_name: Name of a Network Connection in parent Project of this Pool.
    :vartype network_connection_name: str
    :ivar license_type: Specifies the license type indicating the caller has already acquired
     licenses for the Dev Boxes that will be created. "Windows_Client"
    :vartype license_type: str or ~azure.mgmt.devcenter.models.LicenseType
    :ivar local_administrator: Indicates whether owners of Dev Boxes in this pool are added as
     local administrators on the Dev Box. Known values are: "Disabled" and "Enabled".
    :vartype local_administrator: str or ~azure.mgmt.devcenter.models.LocalAdminStatus
    :ivar stop_on_disconnect: Stop on disconnect configuration settings for Dev Boxes created in
     this pool.
    :vartype stop_on_disconnect: ~azure.mgmt.devcenter.models.StopOnDisconnectConfiguration
    :ivar single_sign_on_status: Indicates whether Dev Boxes in this pool are created with single
     sign on enabled. The also requires that single sign on be enabled on the tenant. Known values
     are: "Disabled" and "Enabled".
    :vartype single_sign_on_status: str or ~azure.mgmt.devcenter.models.SingleSignOnStatus
    :ivar display_name: The display name of the pool.
    :vartype display_name: str
    :ivar virtual_network_type: Indicates whether the pool uses a Virtual Network managed by
     Microsoft or a customer provided network. Known values are: "Managed" and "Unmanaged".
    :vartype virtual_network_type: str or ~azure.mgmt.devcenter.models.VirtualNetworkType
    :ivar managed_virtual_network_regions: The regions of the managed virtual network (required
     when managedNetworkType is Managed).
    :vartype managed_virtual_network_regions: list[str]
    """

    _attribute_map = {
        "dev_box_definition_name": {"key": "devBoxDefinitionName", "type": "str"},
        "network_connection_name": {"key": "networkConnectionName", "type": "str"},
        "license_type": {"key": "licenseType", "type": "str"},
        "local_administrator": {"key": "localAdministrator", "type": "str"},
        "stop_on_disconnect": {"key": "stopOnDisconnect", "type": "StopOnDisconnectConfiguration"},
        "single_sign_on_status": {"key": "singleSignOnStatus", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "virtual_network_type": {"key": "virtualNetworkType", "type": "str"},
        "managed_virtual_network_regions": {"key": "managedVirtualNetworkRegions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        dev_box_definition_name: Optional[str] = None,
        network_connection_name: Optional[str] = None,
        license_type: Optional[Union[str, "_models.LicenseType"]] = None,
        local_administrator: Optional[Union[str, "_models.LocalAdminStatus"]] = None,
        stop_on_disconnect: Optional["_models.StopOnDisconnectConfiguration"] = None,
        single_sign_on_status: Optional[Union[str, "_models.SingleSignOnStatus"]] = None,
        display_name: Optional[str] = None,
        virtual_network_type: Optional[Union[str, "_models.VirtualNetworkType"]] = None,
        managed_virtual_network_regions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dev_box_definition_name: Name of a Dev Box definition in parent Project of this Pool.
        :paramtype dev_box_definition_name: str
        :keyword network_connection_name: Name of a Network Connection in parent Project of this Pool.
        :paramtype network_connection_name: str
        :keyword license_type: Specifies the license type indicating the caller has already acquired
         licenses for the Dev Boxes that will be created. "Windows_Client"
        :paramtype license_type: str or ~azure.mgmt.devcenter.models.LicenseType
        :keyword local_administrator: Indicates whether owners of Dev Boxes in this pool are added as
         local administrators on the Dev Box. Known values are: "Disabled" and "Enabled".
        :paramtype local_administrator: str or ~azure.mgmt.devcenter.models.LocalAdminStatus
        :keyword stop_on_disconnect: Stop on disconnect configuration settings for Dev Boxes created in
         this pool.
        :paramtype stop_on_disconnect: ~azure.mgmt.devcenter.models.StopOnDisconnectConfiguration
        :keyword single_sign_on_status: Indicates whether Dev Boxes in this pool are created with
         single sign on enabled. The also requires that single sign on be enabled on the tenant. Known
         values are: "Disabled" and "Enabled".
        :paramtype single_sign_on_status: str or ~azure.mgmt.devcenter.models.SingleSignOnStatus
        :keyword display_name: The display name of the pool.
        :paramtype display_name: str
        :keyword virtual_network_type: Indicates whether the pool uses a Virtual Network managed by
         Microsoft or a customer provided network. Known values are: "Managed" and "Unmanaged".
        :paramtype virtual_network_type: str or ~azure.mgmt.devcenter.models.VirtualNetworkType
        :keyword managed_virtual_network_regions: The regions of the managed virtual network (required
         when managedNetworkType is Managed).
        :paramtype managed_virtual_network_regions: list[str]
        """
        super().__init__(**kwargs)
        self.dev_box_definition_name = dev_box_definition_name
        self.network_connection_name = network_connection_name
        self.license_type = license_type
        self.local_administrator = local_administrator
        self.stop_on_disconnect = stop_on_disconnect
        self.single_sign_on_status = single_sign_on_status
        self.display_name = display_name
        self.virtual_network_type = virtual_network_type
        self.managed_virtual_network_regions = managed_virtual_network_regions


class PoolProperties(PoolUpdateProperties):  # pylint: disable=too-many-instance-attributes
    """Properties of a Pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar dev_box_definition_name: Name of a Dev Box definition in parent Project of this Pool.
    :vartype dev_box_definition_name: str
    :ivar network_connection_name: Name of a Network Connection in parent Project of this Pool.
    :vartype network_connection_name: str
    :ivar license_type: Specifies the license type indicating the caller has already acquired
     licenses for the Dev Boxes that will be created. "Windows_Client"
    :vartype license_type: str or ~azure.mgmt.devcenter.models.LicenseType
    :ivar local_administrator: Indicates whether owners of Dev Boxes in this pool are added as
     local administrators on the Dev Box. Known values are: "Disabled" and "Enabled".
    :vartype local_administrator: str or ~azure.mgmt.devcenter.models.LocalAdminStatus
    :ivar stop_on_disconnect: Stop on disconnect configuration settings for Dev Boxes created in
     this pool.
    :vartype stop_on_disconnect: ~azure.mgmt.devcenter.models.StopOnDisconnectConfiguration
    :ivar single_sign_on_status: Indicates whether Dev Boxes in this pool are created with single
     sign on enabled. The also requires that single sign on be enabled on the tenant. Known values
     are: "Disabled" and "Enabled".
    :vartype single_sign_on_status: str or ~azure.mgmt.devcenter.models.SingleSignOnStatus
    :ivar display_name: The display name of the pool.
    :vartype display_name: str
    :ivar virtual_network_type: Indicates whether the pool uses a Virtual Network managed by
     Microsoft or a customer provided network. Known values are: "Managed" and "Unmanaged".
    :vartype virtual_network_type: str or ~azure.mgmt.devcenter.models.VirtualNetworkType
    :ivar managed_virtual_network_regions: The regions of the managed virtual network (required
     when managedNetworkType is Managed).
    :vartype managed_virtual_network_regions: list[str]
    :ivar health_status: Overall health status of the Pool. Indicates whether or not the Pool is
     available to create Dev Boxes. Known values are: "Unknown", "Pending", "Healthy", "Warning",
     and "Unhealthy".
    :vartype health_status: str or ~azure.mgmt.devcenter.models.HealthStatus
    :ivar health_status_details: Details on the Pool health status to help diagnose issues. This is
     only populated when the pool status indicates the pool is in a non-healthy state.
    :vartype health_status_details: list[~azure.mgmt.devcenter.models.HealthStatusDetail]
    :ivar dev_box_count: Indicates the number of provisioned Dev Boxes in this pool.
    :vartype dev_box_count: int
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    """

    _validation = {
        "health_status": {"readonly": True},
        "health_status_details": {"readonly": True},
        "dev_box_count": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "dev_box_definition_name": {"key": "devBoxDefinitionName", "type": "str"},
        "network_connection_name": {"key": "networkConnectionName", "type": "str"},
        "license_type": {"key": "licenseType", "type": "str"},
        "local_administrator": {"key": "localAdministrator", "type": "str"},
        "stop_on_disconnect": {"key": "stopOnDisconnect", "type": "StopOnDisconnectConfiguration"},
        "single_sign_on_status": {"key": "singleSignOnStatus", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "virtual_network_type": {"key": "virtualNetworkType", "type": "str"},
        "managed_virtual_network_regions": {"key": "managedVirtualNetworkRegions", "type": "[str]"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "health_status_details": {"key": "healthStatusDetails", "type": "[HealthStatusDetail]"},
        "dev_box_count": {"key": "devBoxCount", "type": "int"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        dev_box_definition_name: Optional[str] = None,
        network_connection_name: Optional[str] = None,
        license_type: Optional[Union[str, "_models.LicenseType"]] = None,
        local_administrator: Optional[Union[str, "_models.LocalAdminStatus"]] = None,
        stop_on_disconnect: Optional["_models.StopOnDisconnectConfiguration"] = None,
        single_sign_on_status: Optional[Union[str, "_models.SingleSignOnStatus"]] = None,
        display_name: Optional[str] = None,
        virtual_network_type: Optional[Union[str, "_models.VirtualNetworkType"]] = None,
        managed_virtual_network_regions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dev_box_definition_name: Name of a Dev Box definition in parent Project of this Pool.
        :paramtype dev_box_definition_name: str
        :keyword network_connection_name: Name of a Network Connection in parent Project of this Pool.
        :paramtype network_connection_name: str
        :keyword license_type: Specifies the license type indicating the caller has already acquired
         licenses for the Dev Boxes that will be created. "Windows_Client"
        :paramtype license_type: str or ~azure.mgmt.devcenter.models.LicenseType
        :keyword local_administrator: Indicates whether owners of Dev Boxes in this pool are added as
         local administrators on the Dev Box. Known values are: "Disabled" and "Enabled".
        :paramtype local_administrator: str or ~azure.mgmt.devcenter.models.LocalAdminStatus
        :keyword stop_on_disconnect: Stop on disconnect configuration settings for Dev Boxes created in
         this pool.
        :paramtype stop_on_disconnect: ~azure.mgmt.devcenter.models.StopOnDisconnectConfiguration
        :keyword single_sign_on_status: Indicates whether Dev Boxes in this pool are created with
         single sign on enabled. The also requires that single sign on be enabled on the tenant. Known
         values are: "Disabled" and "Enabled".
        :paramtype single_sign_on_status: str or ~azure.mgmt.devcenter.models.SingleSignOnStatus
        :keyword display_name: The display name of the pool.
        :paramtype display_name: str
        :keyword virtual_network_type: Indicates whether the pool uses a Virtual Network managed by
         Microsoft or a customer provided network. Known values are: "Managed" and "Unmanaged".
        :paramtype virtual_network_type: str or ~azure.mgmt.devcenter.models.VirtualNetworkType
        :keyword managed_virtual_network_regions: The regions of the managed virtual network (required
         when managedNetworkType is Managed).
        :paramtype managed_virtual_network_regions: list[str]
        """
        super().__init__(
            dev_box_definition_name=dev_box_definition_name,
            network_connection_name=network_connection_name,
            license_type=license_type,
            local_administrator=local_administrator,
            stop_on_disconnect=stop_on_disconnect,
            single_sign_on_status=single_sign_on_status,
            display_name=display_name,
            virtual_network_type=virtual_network_type,
            managed_virtual_network_regions=managed_virtual_network_regions,
            **kwargs
        )
        self.health_status = None
        self.health_status_details = None
        self.dev_box_count = None
        self.provisioning_state = None


class PoolUpdate(TrackedResourceUpdate):  # pylint: disable=too-many-instance-attributes
    """The pool properties for partial update. Properties not provided in the update request will not
    be changed.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar dev_box_definition_name: Name of a Dev Box definition in parent Project of this Pool.
    :vartype dev_box_definition_name: str
    :ivar network_connection_name: Name of a Network Connection in parent Project of this Pool.
    :vartype network_connection_name: str
    :ivar license_type: Specifies the license type indicating the caller has already acquired
     licenses for the Dev Boxes that will be created. "Windows_Client"
    :vartype license_type: str or ~azure.mgmt.devcenter.models.LicenseType
    :ivar local_administrator: Indicates whether owners of Dev Boxes in this pool are added as
     local administrators on the Dev Box. Known values are: "Disabled" and "Enabled".
    :vartype local_administrator: str or ~azure.mgmt.devcenter.models.LocalAdminStatus
    :ivar stop_on_disconnect: Stop on disconnect configuration settings for Dev Boxes created in
     this pool.
    :vartype stop_on_disconnect: ~azure.mgmt.devcenter.models.StopOnDisconnectConfiguration
    :ivar single_sign_on_status: Indicates whether Dev Boxes in this pool are created with single
     sign on enabled. The also requires that single sign on be enabled on the tenant. Known values
     are: "Disabled" and "Enabled".
    :vartype single_sign_on_status: str or ~azure.mgmt.devcenter.models.SingleSignOnStatus
    :ivar display_name: The display name of the pool.
    :vartype display_name: str
    :ivar virtual_network_type: Indicates whether the pool uses a Virtual Network managed by
     Microsoft or a customer provided network. Known values are: "Managed" and "Unmanaged".
    :vartype virtual_network_type: str or ~azure.mgmt.devcenter.models.VirtualNetworkType
    :ivar managed_virtual_network_regions: The regions of the managed virtual network (required
     when managedNetworkType is Managed).
    :vartype managed_virtual_network_regions: list[str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "dev_box_definition_name": {"key": "properties.devBoxDefinitionName", "type": "str"},
        "network_connection_name": {"key": "properties.networkConnectionName", "type": "str"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "local_administrator": {"key": "properties.localAdministrator", "type": "str"},
        "stop_on_disconnect": {"key": "properties.stopOnDisconnect", "type": "StopOnDisconnectConfiguration"},
        "single_sign_on_status": {"key": "properties.singleSignOnStatus", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "virtual_network_type": {"key": "properties.virtualNetworkType", "type": "str"},
        "managed_virtual_network_regions": {"key": "properties.managedVirtualNetworkRegions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        dev_box_definition_name: Optional[str] = None,
        network_connection_name: Optional[str] = None,
        license_type: Optional[Union[str, "_models.LicenseType"]] = None,
        local_administrator: Optional[Union[str, "_models.LocalAdminStatus"]] = None,
        stop_on_disconnect: Optional["_models.StopOnDisconnectConfiguration"] = None,
        single_sign_on_status: Optional[Union[str, "_models.SingleSignOnStatus"]] = None,
        display_name: Optional[str] = None,
        virtual_network_type: Optional[Union[str, "_models.VirtualNetworkType"]] = None,
        managed_virtual_network_regions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword dev_box_definition_name: Name of a Dev Box definition in parent Project of this Pool.
        :paramtype dev_box_definition_name: str
        :keyword network_connection_name: Name of a Network Connection in parent Project of this Pool.
        :paramtype network_connection_name: str
        :keyword license_type: Specifies the license type indicating the caller has already acquired
         licenses for the Dev Boxes that will be created. "Windows_Client"
        :paramtype license_type: str or ~azure.mgmt.devcenter.models.LicenseType
        :keyword local_administrator: Indicates whether owners of Dev Boxes in this pool are added as
         local administrators on the Dev Box. Known values are: "Disabled" and "Enabled".
        :paramtype local_administrator: str or ~azure.mgmt.devcenter.models.LocalAdminStatus
        :keyword stop_on_disconnect: Stop on disconnect configuration settings for Dev Boxes created in
         this pool.
        :paramtype stop_on_disconnect: ~azure.mgmt.devcenter.models.StopOnDisconnectConfiguration
        :keyword single_sign_on_status: Indicates whether Dev Boxes in this pool are created with
         single sign on enabled. The also requires that single sign on be enabled on the tenant. Known
         values are: "Disabled" and "Enabled".
        :paramtype single_sign_on_status: str or ~azure.mgmt.devcenter.models.SingleSignOnStatus
        :keyword display_name: The display name of the pool.
        :paramtype display_name: str
        :keyword virtual_network_type: Indicates whether the pool uses a Virtual Network managed by
         Microsoft or a customer provided network. Known values are: "Managed" and "Unmanaged".
        :paramtype virtual_network_type: str or ~azure.mgmt.devcenter.models.VirtualNetworkType
        :keyword managed_virtual_network_regions: The regions of the managed virtual network (required
         when managedNetworkType is Managed).
        :paramtype managed_virtual_network_regions: list[str]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.dev_box_definition_name = dev_box_definition_name
        self.network_connection_name = network_connection_name
        self.license_type = license_type
        self.local_administrator = local_administrator
        self.stop_on_disconnect = stop_on_disconnect
        self.single_sign_on_status = single_sign_on_status
        self.display_name = display_name
        self.virtual_network_type = virtual_network_type
        self.managed_virtual_network_regions = managed_virtual_network_regions


class Project(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Represents a project resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Managed identity properties.
    :vartype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
    :ivar dev_center_id: Resource Id of an associated DevCenter.
    :vartype dev_center_id: str
    :ivar description: Description of the project.
    :vartype description: str
    :ivar max_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a single
     user can create across all pools in the project. This will have no effect on existing Dev Boxes
     when reduced.
    :vartype max_dev_boxes_per_user: int
    :ivar display_name: The display name of the project.
    :vartype display_name: str
    :ivar catalog_settings: Settings to be used when associating a project with a catalog.
    :vartype catalog_settings: ~azure.mgmt.devcenter.models.ProjectCatalogSettings
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar dev_center_uri: The URI of the Dev Center resource this project is associated with.
    :vartype dev_center_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "max_dev_boxes_per_user": {"minimum": 0},
        "provisioning_state": {"readonly": True},
        "dev_center_uri": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "dev_center_id": {"key": "properties.devCenterId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "max_dev_boxes_per_user": {"key": "properties.maxDevBoxesPerUser", "type": "int"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "catalog_settings": {"key": "properties.catalogSettings", "type": "ProjectCatalogSettings"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "dev_center_uri": {"key": "properties.devCenterUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        dev_center_id: Optional[str] = None,
        description: Optional[str] = None,
        max_dev_boxes_per_user: Optional[int] = None,
        display_name: Optional[str] = None,
        catalog_settings: Optional["_models.ProjectCatalogSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed identity properties.
        :paramtype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
        :keyword dev_center_id: Resource Id of an associated DevCenter.
        :paramtype dev_center_id: str
        :keyword description: Description of the project.
        :paramtype description: str
        :keyword max_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a
         single user can create across all pools in the project. This will have no effect on existing
         Dev Boxes when reduced.
        :paramtype max_dev_boxes_per_user: int
        :keyword display_name: The display name of the project.
        :paramtype display_name: str
        :keyword catalog_settings: Settings to be used when associating a project with a catalog.
        :paramtype catalog_settings: ~azure.mgmt.devcenter.models.ProjectCatalogSettings
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.dev_center_id = dev_center_id
        self.description = description
        self.max_dev_boxes_per_user = max_dev_boxes_per_user
        self.display_name = display_name
        self.catalog_settings = catalog_settings
        self.provisioning_state = None
        self.dev_center_uri = None


class ProjectCatalogSettings(_serialization.Model):
    """Settings to be used when associating a project with a catalog.

    :ivar catalog_item_sync_types: Indicates catalog item types that can be synced.
    :vartype catalog_item_sync_types: list[str or ~azure.mgmt.devcenter.models.CatalogItemType]
    """

    _attribute_map = {
        "catalog_item_sync_types": {"key": "catalogItemSyncTypes", "type": "[str]"},
    }

    def __init__(
        self, *, catalog_item_sync_types: Optional[List[Union[str, "_models.CatalogItemType"]]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword catalog_item_sync_types: Indicates catalog item types that can be synced.
        :paramtype catalog_item_sync_types: list[str or ~azure.mgmt.devcenter.models.CatalogItemType]
        """
        super().__init__(**kwargs)
        self.catalog_item_sync_types = catalog_item_sync_types


class ProjectEnvironmentType(Resource):  # pylint: disable=too-many-instance-attributes
    """Represents an environment type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed identity properties.
    :vartype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
    :ivar location: The geo-location for the environment type.
    :vartype location: str
    :ivar deployment_target_id: Id of a subscription that the environment type will be mapped to.
     The environment's resources will be deployed into this subscription.
    :vartype deployment_target_id: str
    :ivar display_name: The display name of the project environment type.
    :vartype display_name: str
    :ivar status: Defines whether this Environment Type can be used in this Project. Known values
     are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.devcenter.models.EnvironmentTypeEnableStatus
    :ivar creator_role_assignment: The role definition assigned to the environment creator on
     backing resources.
    :vartype creator_role_assignment:
     ~azure.mgmt.devcenter.models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment
    :ivar user_role_assignments: Role Assignments created on environment backing resources. This is
     a mapping from a user object ID to an object of role definition IDs.
    :vartype user_role_assignments: dict[str, ~azure.mgmt.devcenter.models.UserRoleAssignmentValue]
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar environment_count: The number of environments of this type.
    :vartype environment_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "environment_count": {"readonly": True, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "location": {"key": "location", "type": "str"},
        "deployment_target_id": {"key": "properties.deploymentTargetId", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "creator_role_assignment": {
            "key": "properties.creatorRoleAssignment",
            "type": "ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment",
        },
        "user_role_assignments": {"key": "properties.userRoleAssignments", "type": "{UserRoleAssignmentValue}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "environment_count": {"key": "properties.environmentCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        location: Optional[str] = None,
        deployment_target_id: Optional[str] = None,
        display_name: Optional[str] = None,
        status: Optional[Union[str, "_models.EnvironmentTypeEnableStatus"]] = None,
        creator_role_assignment: Optional["_models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment"] = None,
        user_role_assignments: Optional[Dict[str, "_models.UserRoleAssignmentValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed identity properties.
        :paramtype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
        :keyword location: The geo-location for the environment type.
        :paramtype location: str
        :keyword deployment_target_id: Id of a subscription that the environment type will be mapped
         to. The environment's resources will be deployed into this subscription.
        :paramtype deployment_target_id: str
        :keyword display_name: The display name of the project environment type.
        :paramtype display_name: str
        :keyword status: Defines whether this Environment Type can be used in this Project. Known
         values are: "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.devcenter.models.EnvironmentTypeEnableStatus
        :keyword creator_role_assignment: The role definition assigned to the environment creator on
         backing resources.
        :paramtype creator_role_assignment:
         ~azure.mgmt.devcenter.models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment
        :keyword user_role_assignments: Role Assignments created on environment backing resources. This
         is a mapping from a user object ID to an object of role definition IDs.
        :paramtype user_role_assignments: dict[str,
         ~azure.mgmt.devcenter.models.UserRoleAssignmentValue]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.location = location
        self.deployment_target_id = deployment_target_id
        self.display_name = display_name
        self.status = status
        self.creator_role_assignment = creator_role_assignment
        self.user_role_assignments = user_role_assignments
        self.provisioning_state = None
        self.environment_count = None


class ProjectEnvironmentTypeListResult(_serialization.Model):
    """Result of the project environment type list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.ProjectEnvironmentType]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProjectEnvironmentType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ProjectEnvironmentTypeUpdateProperties(_serialization.Model):
    """Properties of a project environment type. These properties can be updated after the resource
    has been created.

    :ivar deployment_target_id: Id of a subscription that the environment type will be mapped to.
     The environment's resources will be deployed into this subscription.
    :vartype deployment_target_id: str
    :ivar display_name: The display name of the project environment type.
    :vartype display_name: str
    :ivar status: Defines whether this Environment Type can be used in this Project. Known values
     are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.devcenter.models.EnvironmentTypeEnableStatus
    :ivar creator_role_assignment: The role definition assigned to the environment creator on
     backing resources.
    :vartype creator_role_assignment:
     ~azure.mgmt.devcenter.models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment
    :ivar user_role_assignments: Role Assignments created on environment backing resources. This is
     a mapping from a user object ID to an object of role definition IDs.
    :vartype user_role_assignments: dict[str, ~azure.mgmt.devcenter.models.UserRoleAssignmentValue]
    """

    _attribute_map = {
        "deployment_target_id": {"key": "deploymentTargetId", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "creator_role_assignment": {
            "key": "creatorRoleAssignment",
            "type": "ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment",
        },
        "user_role_assignments": {"key": "userRoleAssignments", "type": "{UserRoleAssignmentValue}"},
    }

    def __init__(
        self,
        *,
        deployment_target_id: Optional[str] = None,
        display_name: Optional[str] = None,
        status: Optional[Union[str, "_models.EnvironmentTypeEnableStatus"]] = None,
        creator_role_assignment: Optional["_models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment"] = None,
        user_role_assignments: Optional[Dict[str, "_models.UserRoleAssignmentValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword deployment_target_id: Id of a subscription that the environment type will be mapped
         to. The environment's resources will be deployed into this subscription.
        :paramtype deployment_target_id: str
        :keyword display_name: The display name of the project environment type.
        :paramtype display_name: str
        :keyword status: Defines whether this Environment Type can be used in this Project. Known
         values are: "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.devcenter.models.EnvironmentTypeEnableStatus
        :keyword creator_role_assignment: The role definition assigned to the environment creator on
         backing resources.
        :paramtype creator_role_assignment:
         ~azure.mgmt.devcenter.models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment
        :keyword user_role_assignments: Role Assignments created on environment backing resources. This
         is a mapping from a user object ID to an object of role definition IDs.
        :paramtype user_role_assignments: dict[str,
         ~azure.mgmt.devcenter.models.UserRoleAssignmentValue]
        """
        super().__init__(**kwargs)
        self.deployment_target_id = deployment_target_id
        self.display_name = display_name
        self.status = status
        self.creator_role_assignment = creator_role_assignment
        self.user_role_assignments = user_role_assignments


class ProjectEnvironmentTypeProperties(ProjectEnvironmentTypeUpdateProperties):
    """Properties of a project environment type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar deployment_target_id: Id of a subscription that the environment type will be mapped to.
     The environment's resources will be deployed into this subscription.
    :vartype deployment_target_id: str
    :ivar display_name: The display name of the project environment type.
    :vartype display_name: str
    :ivar status: Defines whether this Environment Type can be used in this Project. Known values
     are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.devcenter.models.EnvironmentTypeEnableStatus
    :ivar creator_role_assignment: The role definition assigned to the environment creator on
     backing resources.
    :vartype creator_role_assignment:
     ~azure.mgmt.devcenter.models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment
    :ivar user_role_assignments: Role Assignments created on environment backing resources. This is
     a mapping from a user object ID to an object of role definition IDs.
    :vartype user_role_assignments: dict[str, ~azure.mgmt.devcenter.models.UserRoleAssignmentValue]
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar environment_count: The number of environments of this type.
    :vartype environment_count: int
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "environment_count": {"readonly": True, "minimum": 0},
    }

    _attribute_map = {
        "deployment_target_id": {"key": "deploymentTargetId", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "creator_role_assignment": {
            "key": "creatorRoleAssignment",
            "type": "ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment",
        },
        "user_role_assignments": {"key": "userRoleAssignments", "type": "{UserRoleAssignmentValue}"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "environment_count": {"key": "environmentCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        deployment_target_id: Optional[str] = None,
        display_name: Optional[str] = None,
        status: Optional[Union[str, "_models.EnvironmentTypeEnableStatus"]] = None,
        creator_role_assignment: Optional["_models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment"] = None,
        user_role_assignments: Optional[Dict[str, "_models.UserRoleAssignmentValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword deployment_target_id: Id of a subscription that the environment type will be mapped
         to. The environment's resources will be deployed into this subscription.
        :paramtype deployment_target_id: str
        :keyword display_name: The display name of the project environment type.
        :paramtype display_name: str
        :keyword status: Defines whether this Environment Type can be used in this Project. Known
         values are: "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.devcenter.models.EnvironmentTypeEnableStatus
        :keyword creator_role_assignment: The role definition assigned to the environment creator on
         backing resources.
        :paramtype creator_role_assignment:
         ~azure.mgmt.devcenter.models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment
        :keyword user_role_assignments: Role Assignments created on environment backing resources. This
         is a mapping from a user object ID to an object of role definition IDs.
        :paramtype user_role_assignments: dict[str,
         ~azure.mgmt.devcenter.models.UserRoleAssignmentValue]
        """
        super().__init__(
            deployment_target_id=deployment_target_id,
            display_name=display_name,
            status=status,
            creator_role_assignment=creator_role_assignment,
            user_role_assignments=user_role_assignments,
            **kwargs
        )
        self.provisioning_state = None
        self.environment_count = None


class ProjectEnvironmentTypeUpdate(_serialization.Model):
    """The project environment type for partial update. Properties not provided in the update request
    will not be changed.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed identity properties.
    :vartype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
    :ivar deployment_target_id: Id of a subscription that the environment type will be mapped to.
     The environment's resources will be deployed into this subscription.
    :vartype deployment_target_id: str
    :ivar display_name: The display name of the project environment type.
    :vartype display_name: str
    :ivar status: Defines whether this Environment Type can be used in this Project. Known values
     are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.devcenter.models.EnvironmentTypeEnableStatus
    :ivar creator_role_assignment: The role definition assigned to the environment creator on
     backing resources.
    :vartype creator_role_assignment:
     ~azure.mgmt.devcenter.models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment
    :ivar user_role_assignments: Role Assignments created on environment backing resources. This is
     a mapping from a user object ID to an object of role definition IDs.
    :vartype user_role_assignments: dict[str, ~azure.mgmt.devcenter.models.UserRoleAssignmentValue]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "deployment_target_id": {"key": "properties.deploymentTargetId", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "creator_role_assignment": {
            "key": "properties.creatorRoleAssignment",
            "type": "ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment",
        },
        "user_role_assignments": {"key": "properties.userRoleAssignments", "type": "{UserRoleAssignmentValue}"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        deployment_target_id: Optional[str] = None,
        display_name: Optional[str] = None,
        status: Optional[Union[str, "_models.EnvironmentTypeEnableStatus"]] = None,
        creator_role_assignment: Optional["_models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment"] = None,
        user_role_assignments: Optional[Dict[str, "_models.UserRoleAssignmentValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed identity properties.
        :paramtype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
        :keyword deployment_target_id: Id of a subscription that the environment type will be mapped
         to. The environment's resources will be deployed into this subscription.
        :paramtype deployment_target_id: str
        :keyword display_name: The display name of the project environment type.
        :paramtype display_name: str
        :keyword status: Defines whether this Environment Type can be used in this Project. Known
         values are: "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.devcenter.models.EnvironmentTypeEnableStatus
        :keyword creator_role_assignment: The role definition assigned to the environment creator on
         backing resources.
        :paramtype creator_role_assignment:
         ~azure.mgmt.devcenter.models.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment
        :keyword user_role_assignments: Role Assignments created on environment backing resources. This
         is a mapping from a user object ID to an object of role definition IDs.
        :paramtype user_role_assignments: dict[str,
         ~azure.mgmt.devcenter.models.UserRoleAssignmentValue]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.deployment_target_id = deployment_target_id
        self.display_name = display_name
        self.status = status
        self.creator_role_assignment = creator_role_assignment
        self.user_role_assignments = user_role_assignments


class ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The role definition assigned to the environment creator on backing resources.

    :ivar roles: A map of roles to assign to the environment creator.
    :vartype roles: dict[str, ~azure.mgmt.devcenter.models.EnvironmentRole]
    """

    _attribute_map = {
        "roles": {"key": "roles", "type": "{EnvironmentRole}"},
    }

    def __init__(self, *, roles: Optional[Dict[str, "_models.EnvironmentRole"]] = None, **kwargs: Any) -> None:
        """
        :keyword roles: A map of roles to assign to the environment creator.
        :paramtype roles: dict[str, ~azure.mgmt.devcenter.models.EnvironmentRole]
        """
        super().__init__(**kwargs)
        self.roles = roles


class ProjectListResult(_serialization.Model):
    """Results of the project list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.Project]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Project]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ProjectUpdateProperties(_serialization.Model):
    """Properties of a project. These properties can be updated after the resource has been created.

    :ivar dev_center_id: Resource Id of an associated DevCenter.
    :vartype dev_center_id: str
    :ivar description: Description of the project.
    :vartype description: str
    :ivar max_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a single
     user can create across all pools in the project. This will have no effect on existing Dev Boxes
     when reduced.
    :vartype max_dev_boxes_per_user: int
    :ivar display_name: The display name of the project.
    :vartype display_name: str
    :ivar catalog_settings: Settings to be used when associating a project with a catalog.
    :vartype catalog_settings: ~azure.mgmt.devcenter.models.ProjectCatalogSettings
    """

    _validation = {
        "max_dev_boxes_per_user": {"minimum": 0},
    }

    _attribute_map = {
        "dev_center_id": {"key": "devCenterId", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "max_dev_boxes_per_user": {"key": "maxDevBoxesPerUser", "type": "int"},
        "display_name": {"key": "displayName", "type": "str"},
        "catalog_settings": {"key": "catalogSettings", "type": "ProjectCatalogSettings"},
    }

    def __init__(
        self,
        *,
        dev_center_id: Optional[str] = None,
        description: Optional[str] = None,
        max_dev_boxes_per_user: Optional[int] = None,
        display_name: Optional[str] = None,
        catalog_settings: Optional["_models.ProjectCatalogSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dev_center_id: Resource Id of an associated DevCenter.
        :paramtype dev_center_id: str
        :keyword description: Description of the project.
        :paramtype description: str
        :keyword max_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a
         single user can create across all pools in the project. This will have no effect on existing
         Dev Boxes when reduced.
        :paramtype max_dev_boxes_per_user: int
        :keyword display_name: The display name of the project.
        :paramtype display_name: str
        :keyword catalog_settings: Settings to be used when associating a project with a catalog.
        :paramtype catalog_settings: ~azure.mgmt.devcenter.models.ProjectCatalogSettings
        """
        super().__init__(**kwargs)
        self.dev_center_id = dev_center_id
        self.description = description
        self.max_dev_boxes_per_user = max_dev_boxes_per_user
        self.display_name = display_name
        self.catalog_settings = catalog_settings


class ProjectProperties(ProjectUpdateProperties):
    """Properties of a project.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar dev_center_id: Resource Id of an associated DevCenter.
    :vartype dev_center_id: str
    :ivar description: Description of the project.
    :vartype description: str
    :ivar max_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a single
     user can create across all pools in the project. This will have no effect on existing Dev Boxes
     when reduced.
    :vartype max_dev_boxes_per_user: int
    :ivar display_name: The display name of the project.
    :vartype display_name: str
    :ivar catalog_settings: Settings to be used when associating a project with a catalog.
    :vartype catalog_settings: ~azure.mgmt.devcenter.models.ProjectCatalogSettings
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    :ivar dev_center_uri: The URI of the Dev Center resource this project is associated with.
    :vartype dev_center_uri: str
    """

    _validation = {
        "max_dev_boxes_per_user": {"minimum": 0},
        "provisioning_state": {"readonly": True},
        "dev_center_uri": {"readonly": True},
    }

    _attribute_map = {
        "dev_center_id": {"key": "devCenterId", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "max_dev_boxes_per_user": {"key": "maxDevBoxesPerUser", "type": "int"},
        "display_name": {"key": "displayName", "type": "str"},
        "catalog_settings": {"key": "catalogSettings", "type": "ProjectCatalogSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "dev_center_uri": {"key": "devCenterUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        dev_center_id: Optional[str] = None,
        description: Optional[str] = None,
        max_dev_boxes_per_user: Optional[int] = None,
        display_name: Optional[str] = None,
        catalog_settings: Optional["_models.ProjectCatalogSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dev_center_id: Resource Id of an associated DevCenter.
        :paramtype dev_center_id: str
        :keyword description: Description of the project.
        :paramtype description: str
        :keyword max_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a
         single user can create across all pools in the project. This will have no effect on existing
         Dev Boxes when reduced.
        :paramtype max_dev_boxes_per_user: int
        :keyword display_name: The display name of the project.
        :paramtype display_name: str
        :keyword catalog_settings: Settings to be used when associating a project with a catalog.
        :paramtype catalog_settings: ~azure.mgmt.devcenter.models.ProjectCatalogSettings
        """
        super().__init__(
            dev_center_id=dev_center_id,
            description=description,
            max_dev_boxes_per_user=max_dev_boxes_per_user,
            display_name=display_name,
            catalog_settings=catalog_settings,
            **kwargs
        )
        self.provisioning_state = None
        self.dev_center_uri = None


class ProjectUpdate(TrackedResourceUpdate):
    """The project properties for partial update. Properties not provided in the update request will
    not be changed.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed identity properties.
    :vartype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
    :ivar dev_center_id: Resource Id of an associated DevCenter.
    :vartype dev_center_id: str
    :ivar description: Description of the project.
    :vartype description: str
    :ivar max_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a single
     user can create across all pools in the project. This will have no effect on existing Dev Boxes
     when reduced.
    :vartype max_dev_boxes_per_user: int
    :ivar display_name: The display name of the project.
    :vartype display_name: str
    :ivar catalog_settings: Settings to be used when associating a project with a catalog.
    :vartype catalog_settings: ~azure.mgmt.devcenter.models.ProjectCatalogSettings
    """

    _validation = {
        "max_dev_boxes_per_user": {"minimum": 0},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "dev_center_id": {"key": "properties.devCenterId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "max_dev_boxes_per_user": {"key": "properties.maxDevBoxesPerUser", "type": "int"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "catalog_settings": {"key": "properties.catalogSettings", "type": "ProjectCatalogSettings"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        dev_center_id: Optional[str] = None,
        description: Optional[str] = None,
        max_dev_boxes_per_user: Optional[int] = None,
        display_name: Optional[str] = None,
        catalog_settings: Optional["_models.ProjectCatalogSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed identity properties.
        :paramtype identity: ~azure.mgmt.devcenter.models.ManagedServiceIdentity
        :keyword dev_center_id: Resource Id of an associated DevCenter.
        :paramtype dev_center_id: str
        :keyword description: Description of the project.
        :paramtype description: str
        :keyword max_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a
         single user can create across all pools in the project. This will have no effect on existing
         Dev Boxes when reduced.
        :paramtype max_dev_boxes_per_user: int
        :keyword display_name: The display name of the project.
        :paramtype display_name: str
        :keyword catalog_settings: Settings to be used when associating a project with a catalog.
        :paramtype catalog_settings: ~azure.mgmt.devcenter.models.ProjectCatalogSettings
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.dev_center_id = dev_center_id
        self.description = description
        self.max_dev_boxes_per_user = max_dev_boxes_per_user
        self.display_name = display_name
        self.catalog_settings = catalog_settings


class RecommendedMachineConfiguration(_serialization.Model):
    """Properties for a recommended machine configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar memory: Recommended memory range.
    :vartype memory: ~azure.mgmt.devcenter.models.ResourceRange
    :ivar v_cp_us: Recommended vCPU range.
    :vartype v_cp_us: ~azure.mgmt.devcenter.models.ResourceRange
    """

    _validation = {
        "memory": {"readonly": True},
        "v_cp_us": {"readonly": True},
    }

    _attribute_map = {
        "memory": {"key": "memory", "type": "ResourceRange"},
        "v_cp_us": {"key": "vCPUs", "type": "ResourceRange"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.memory = None
        self.v_cp_us = None


class ResourceRange(_serialization.Model):
    """Properties for a range of values.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar min: Minimum value.
    :vartype min: int
    :ivar max: Maximum value.
    :vartype max: int
    """

    _validation = {
        "min": {"readonly": True},
        "max": {"readonly": True},
    }

    _attribute_map = {
        "min": {"key": "min", "type": "int"},
        "max": {"key": "max", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.min = None
        self.max = None


class Schedule(Resource):  # pylint: disable=too-many-instance-attributes
    """Represents a Schedule to execute a task.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.devcenter.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar type_properties_type: Supported type this scheduled task represents. "StopDevBox"
    :vartype type_properties_type: str or ~azure.mgmt.devcenter.models.ScheduledType
    :ivar frequency: The frequency of this scheduled task. "Daily"
    :vartype frequency: str or ~azure.mgmt.devcenter.models.ScheduledFrequency
    :ivar time: The target time to trigger the action. The format is HH:MM.
    :vartype time: str
    :ivar time_zone: The IANA timezone id at which the schedule should execute.
    :vartype time_zone: str
    :ivar state: Indicates whether or not this scheduled task is enabled. Known values are:
     "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.devcenter.models.ScheduleEnableStatus
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "properties.tags", "type": "{str}"},
        "location": {"key": "properties.location", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "frequency": {"key": "properties.frequency", "type": "str"},
        "time": {"key": "properties.time", "type": "str"},
        "time_zone": {"key": "properties.timeZone", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        type_properties_type: Optional[Union[str, "_models.ScheduledType"]] = None,
        frequency: Optional[Union[str, "_models.ScheduledFrequency"]] = None,
        time: Optional[str] = None,
        time_zone: Optional[str] = None,
        state: Optional[Union[str, "_models.ScheduleEnableStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword type_properties_type: Supported type this scheduled task represents. "StopDevBox"
        :paramtype type_properties_type: str or ~azure.mgmt.devcenter.models.ScheduledType
        :keyword frequency: The frequency of this scheduled task. "Daily"
        :paramtype frequency: str or ~azure.mgmt.devcenter.models.ScheduledFrequency
        :keyword time: The target time to trigger the action. The format is HH:MM.
        :paramtype time: str
        :keyword time_zone: The IANA timezone id at which the schedule should execute.
        :paramtype time_zone: str
        :keyword state: Indicates whether or not this scheduled task is enabled. Known values are:
         "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.devcenter.models.ScheduleEnableStatus
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.type_properties_type = type_properties_type
        self.frequency = frequency
        self.time = time
        self.time_zone = time_zone
        self.state = state
        self.provisioning_state = None


class ScheduleListResult(_serialization.Model):
    """Result of the schedule list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.Schedule]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Schedule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ScheduleUpdateProperties(TrackedResourceUpdate):
    """Updatable properties of a Schedule.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar type: Supported type this scheduled task represents. "StopDevBox"
    :vartype type: str or ~azure.mgmt.devcenter.models.ScheduledType
    :ivar frequency: The frequency of this scheduled task. "Daily"
    :vartype frequency: str or ~azure.mgmt.devcenter.models.ScheduledFrequency
    :ivar time: The target time to trigger the action. The format is HH:MM.
    :vartype time: str
    :ivar time_zone: The IANA timezone id at which the schedule should execute.
    :vartype time_zone: str
    :ivar state: Indicates whether or not this scheduled task is enabled. Known values are:
     "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.devcenter.models.ScheduleEnableStatus
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frequency": {"key": "frequency", "type": "str"},
        "time": {"key": "time", "type": "str"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        type: Optional[Union[str, "_models.ScheduledType"]] = None,
        frequency: Optional[Union[str, "_models.ScheduledFrequency"]] = None,
        time: Optional[str] = None,
        time_zone: Optional[str] = None,
        state: Optional[Union[str, "_models.ScheduleEnableStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword type: Supported type this scheduled task represents. "StopDevBox"
        :paramtype type: str or ~azure.mgmt.devcenter.models.ScheduledType
        :keyword frequency: The frequency of this scheduled task. "Daily"
        :paramtype frequency: str or ~azure.mgmt.devcenter.models.ScheduledFrequency
        :keyword time: The target time to trigger the action. The format is HH:MM.
        :paramtype time: str
        :keyword time_zone: The IANA timezone id at which the schedule should execute.
        :paramtype time_zone: str
        :keyword state: Indicates whether or not this scheduled task is enabled. Known values are:
         "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.devcenter.models.ScheduleEnableStatus
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.type = type
        self.frequency = frequency
        self.time = time
        self.time_zone = time_zone
        self.state = state


class ScheduleProperties(ScheduleUpdateProperties):
    """The Schedule properties defining when and what to execute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar type: Supported type this scheduled task represents. "StopDevBox"
    :vartype type: str or ~azure.mgmt.devcenter.models.ScheduledType
    :ivar frequency: The frequency of this scheduled task. "Daily"
    :vartype frequency: str or ~azure.mgmt.devcenter.models.ScheduledFrequency
    :ivar time: The target time to trigger the action. The format is HH:MM.
    :vartype time: str
    :ivar time_zone: The IANA timezone id at which the schedule should execute.
    :vartype time_zone: str
    :ivar state: Indicates whether or not this scheduled task is enabled. Known values are:
     "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.devcenter.models.ScheduleEnableStatus
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "NotSpecified", "Accepted", "Running", "Creating", "Created", "Updating", "Updated",
     "Deleting", "Deleted", "Succeeded", "Failed", "Canceled", "MovingResources",
     "TransientFailure", "RolloutInProgress", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or ~azure.mgmt.devcenter.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frequency": {"key": "frequency", "type": "str"},
        "time": {"key": "time", "type": "str"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        type: Optional[Union[str, "_models.ScheduledType"]] = None,
        frequency: Optional[Union[str, "_models.ScheduledFrequency"]] = None,
        time: Optional[str] = None,
        time_zone: Optional[str] = None,
        state: Optional[Union[str, "_models.ScheduleEnableStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword type: Supported type this scheduled task represents. "StopDevBox"
        :paramtype type: str or ~azure.mgmt.devcenter.models.ScheduledType
        :keyword frequency: The frequency of this scheduled task. "Daily"
        :paramtype frequency: str or ~azure.mgmt.devcenter.models.ScheduledFrequency
        :keyword time: The target time to trigger the action. The format is HH:MM.
        :paramtype time: str
        :keyword time_zone: The IANA timezone id at which the schedule should execute.
        :paramtype time_zone: str
        :keyword state: Indicates whether or not this scheduled task is enabled. Known values are:
         "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.devcenter.models.ScheduleEnableStatus
        """
        super().__init__(
            tags=tags,
            location=location,
            type=type,
            frequency=frequency,
            time=time,
            time_zone=time_zone,
            state=state,
            **kwargs
        )
        self.provisioning_state = None


class ScheduleUpdate(_serialization.Model):
    """The schedule properties for partial update. Properties not provided in the update request will
    not be changed.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar type: Supported type this scheduled task represents. "StopDevBox"
    :vartype type: str or ~azure.mgmt.devcenter.models.ScheduledType
    :ivar frequency: The frequency of this scheduled task. "Daily"
    :vartype frequency: str or ~azure.mgmt.devcenter.models.ScheduledFrequency
    :ivar time: The target time to trigger the action. The format is HH:MM.
    :vartype time: str
    :ivar time_zone: The IANA timezone id at which the schedule should execute.
    :vartype time_zone: str
    :ivar state: Indicates whether or not this scheduled task is enabled. Known values are:
     "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.devcenter.models.ScheduleEnableStatus
    """

    _attribute_map = {
        "tags": {"key": "properties.tags", "type": "{str}"},
        "location": {"key": "properties.location", "type": "str"},
        "type": {"key": "properties.type", "type": "str"},
        "frequency": {"key": "properties.frequency", "type": "str"},
        "time": {"key": "properties.time", "type": "str"},
        "time_zone": {"key": "properties.timeZone", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        type: Optional[Union[str, "_models.ScheduledType"]] = None,
        frequency: Optional[Union[str, "_models.ScheduledFrequency"]] = None,
        time: Optional[str] = None,
        time_zone: Optional[str] = None,
        state: Optional[Union[str, "_models.ScheduleEnableStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword type: Supported type this scheduled task represents. "StopDevBox"
        :paramtype type: str or ~azure.mgmt.devcenter.models.ScheduledType
        :keyword frequency: The frequency of this scheduled task. "Daily"
        :paramtype frequency: str or ~azure.mgmt.devcenter.models.ScheduledFrequency
        :keyword time: The target time to trigger the action. The format is HH:MM.
        :paramtype time: str
        :keyword time_zone: The IANA timezone id at which the schedule should execute.
        :paramtype time_zone: str
        :keyword state: Indicates whether or not this scheduled task is enabled. Known values are:
         "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.devcenter.models.ScheduleEnableStatus
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.type = type
        self.frequency = frequency
        self.time = time
        self.time_zone = time_zone
        self.state = state


class SkuListResult(_serialization.Model):
    """Results of the Microsoft.DevCenter SKU list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Current page of results.
    :vartype value: list[~azure.mgmt.devcenter.models.DevCenterSku]
    :ivar next_link: URL to get the next set of results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DevCenterSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class StopOnDisconnectConfiguration(_serialization.Model):
    """Stop on disconnect configuration settings for Dev Boxes created in this pool.

    :ivar status: Whether the feature to stop the Dev Box on disconnect once the grace period has
     lapsed is enabled. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.devcenter.models.StopOnDisconnectEnableStatus
    :ivar grace_period_minutes: The specified time in minutes to wait before stopping a Dev Box
     once disconnect is detected.
    :vartype grace_period_minutes: int
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "grace_period_minutes": {"key": "gracePeriodMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.StopOnDisconnectEnableStatus"]] = None,
        grace_period_minutes: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Whether the feature to stop the Dev Box on disconnect once the grace period
         has lapsed is enabled. Known values are: "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.devcenter.models.StopOnDisconnectEnableStatus
        :keyword grace_period_minutes: The specified time in minutes to wait before stopping a Dev Box
         once disconnect is detected.
        :paramtype grace_period_minutes: int
        """
        super().__init__(**kwargs)
        self.status = status
        self.grace_period_minutes = grace_period_minutes


class SyncErrorDetails(_serialization.Model):
    """Synchronization error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar operation_error: Error information for the overall synchronization operation.
    :vartype operation_error: ~azure.mgmt.devcenter.models.CatalogErrorDetails
    :ivar conflicts: Catalog items that have conflicting names.
    :vartype conflicts: list[~azure.mgmt.devcenter.models.CatalogConflictError]
    :ivar errors: Errors that occured during synchronization.
    :vartype errors: list[~azure.mgmt.devcenter.models.CatalogSyncError]
    """

    _validation = {
        "operation_error": {"readonly": True},
        "conflicts": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "operation_error": {"key": "operationError", "type": "CatalogErrorDetails"},
        "conflicts": {"key": "conflicts", "type": "[CatalogConflictError]"},
        "errors": {"key": "errors", "type": "[CatalogSyncError]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.operation_error = None
        self.conflicts = None
        self.errors = None


class SyncStats(_serialization.Model):
    """Stats of the synchronization.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar added: Count of catalog items added during synchronization.
    :vartype added: int
    :ivar updated: Count of catalog items updated during synchronization.
    :vartype updated: int
    :ivar unchanged: Count of catalog items that were unchanged during synchronization.
    :vartype unchanged: int
    :ivar removed: Count of catalog items removed during synchronization.
    :vartype removed: int
    :ivar validation_errors: Count of catalog items that had validation errors during
     synchronization.
    :vartype validation_errors: int
    :ivar synchronization_errors: Count of synchronization errors that occured during
     synchronization.
    :vartype synchronization_errors: int
    :ivar synced_catalog_item_types: Indicates catalog item types that were synced.
    :vartype synced_catalog_item_types: list[str or ~azure.mgmt.devcenter.models.CatalogItemType]
    """

    _validation = {
        "added": {"readonly": True, "minimum": 0},
        "updated": {"readonly": True, "minimum": 0},
        "unchanged": {"readonly": True, "minimum": 0},
        "removed": {"readonly": True, "minimum": 0},
        "validation_errors": {"readonly": True, "minimum": 0},
        "synchronization_errors": {"readonly": True, "minimum": 0},
    }

    _attribute_map = {
        "added": {"key": "added", "type": "int"},
        "updated": {"key": "updated", "type": "int"},
        "unchanged": {"key": "unchanged", "type": "int"},
        "removed": {"key": "removed", "type": "int"},
        "validation_errors": {"key": "validationErrors", "type": "int"},
        "synchronization_errors": {"key": "synchronizationErrors", "type": "int"},
        "synced_catalog_item_types": {"key": "syncedCatalogItemTypes", "type": "[str]"},
    }

    def __init__(
        self, *, synced_catalog_item_types: Optional[List[Union[str, "_models.CatalogItemType"]]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword synced_catalog_item_types: Indicates catalog item types that were synced.
        :paramtype synced_catalog_item_types: list[str or ~azure.mgmt.devcenter.models.CatalogItemType]
        """
        super().__init__(**kwargs)
        self.added = None
        self.updated = None
        self.unchanged = None
        self.removed = None
        self.validation_errors = None
        self.synchronization_errors = None
        self.synced_catalog_item_types = synced_catalog_item_types


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.devcenter.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.devcenter.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.devcenter.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.devcenter.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Usage(_serialization.Model):
    """The core usage details.

    :ivar current_value: The current usage.
    :vartype current_value: int
    :ivar limit: The limit integer.
    :vartype limit: int
    :ivar unit: The unit details. "Count"
    :vartype unit: str or ~azure.mgmt.devcenter.models.UsageUnit
    :ivar name: The name.
    :vartype name: ~azure.mgmt.devcenter.models.UsageName
    :ivar id: The fully qualified arm resource id.
    :vartype id: str
    """

    _attribute_map = {
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
        "name": {"key": "name", "type": "UsageName"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        unit: Optional[Union[str, "_models.UsageUnit"]] = None,
        name: Optional["_models.UsageName"] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword current_value: The current usage.
        :paramtype current_value: int
        :keyword limit: The limit integer.
        :paramtype limit: int
        :keyword unit: The unit details. "Count"
        :paramtype unit: str or ~azure.mgmt.devcenter.models.UsageUnit
        :keyword name: The name.
        :paramtype name: ~azure.mgmt.devcenter.models.UsageName
        :keyword id: The fully qualified arm resource id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.current_value = current_value
        self.limit = limit
        self.unit = unit
        self.name = name
        self.id = id


class UsageName(_serialization.Model):
    """The Usage Names.

    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    :ivar value: The name of the resource.
    :vartype value: str
    """

    _attribute_map = {
        "localized_value": {"key": "localizedValue", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, localized_value: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword localized_value: The localized name of the resource.
        :paramtype localized_value: str
        :keyword value: The name of the resource.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.localized_value = localized_value
        self.value = value


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserRoleAssignmentValue(_serialization.Model):
    """Mapping of user object ID to role assignments.

    :ivar roles: A map of roles to assign to the parent user.
    :vartype roles: dict[str, ~azure.mgmt.devcenter.models.EnvironmentRole]
    """

    _attribute_map = {
        "roles": {"key": "roles", "type": "{EnvironmentRole}"},
    }

    def __init__(self, *, roles: Optional[Dict[str, "_models.EnvironmentRole"]] = None, **kwargs: Any) -> None:
        """
        :keyword roles: A map of roles to assign to the parent user.
        :paramtype roles: dict[str, ~azure.mgmt.devcenter.models.EnvironmentRole]
        """
        super().__init__(**kwargs)
        self.roles = roles
