/***********************************************************************************
* Run Command: Simple plasmoid to run commands with support for runners.
* Copyright (C) 2008 - 2012 Michal Dutkiewicz aka Emdek <emdeck@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef RUNCOMMANDITEM_HEADER
#define RUNCOMMANDITEM_HEADER

#include <QtGui/QIcon>
#include <QtGui/QLabel>
#include <QtGui/QPainter>
#include <QtGui/QKeyEvent>
#include <QtGui/QFocusEvent>
#include <QtGui/QMouseEvent>
#include <QtGui/QPaintEvent>
#include <QtGui/QToolButton>
#include <QtGui/QContextMenuEvent>

#include <Plasma/QueryMatch>

class RunCommandItem : public QWidget
{
    Q_OBJECT

    public:
        RunCommandItem(const Plasma::QueryMatch &match, QList<QAction*> actions, QWidget *parent);

    public slots:
        void toggleOptions();

    protected:
        void paintEvent(QPaintEvent *event);
        void focusInEvent(QFocusEvent *event);
        void focusOutEvent(QFocusEvent *event);
        void enterEvent(QEvent *event);
        void leaveEvent(QEvent *event);
        void mouseReleaseEvent(QMouseEvent *event);
        void keyPressEvent(QKeyEvent *event);
        void contextMenuEvent(QContextMenuEvent *event);

    private:
        Plasma::QueryMatch m_match;
        QList<QAction*> m_actions;
        QWidget *m_optionsWidget;
        QLabel *m_iconLabel;
        QToolButton *m_optionsButton;

    signals:
        void run(Plasma::QueryMatch match);
        void sizeChanged();
};

#endif
