#! /bin/sh

### BEGIN INIT INFO
# Provides:          pgpool2
# Required-Start:    $remote_fs $syslog
# Required-Stop:     $remote_fs $syslog
# Should-Start:      postgresql
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: start pgpool-II
# Description: pgpool-II is a connection pool server and replication
#              proxy for PostgreSQL.
### END INIT INFO


PATH=/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/pgpool
PIDFILE=/var/run/postgresql/pgpool.pid

test -x $DAEMON || exit 5

# Include pgpool defaults if available
if [ -f /etc/default/pgpool2 ] ; then
	. /etc/default/pgpool2
fi

OPTS=""
if [ x"$PGPOOL_LOG_DEBUG" = x"yes" ]; then
	OPTS="$OPTS -d"
fi

. /lib/lsb/init-functions


is_running() {
	pidofproc -p $PIDFILE $DAEMON >/dev/null
}


d_start() {
	if ! test -d /var/run/postgresql; then
		install -d -m 2775 -o postgres -g postgres /var/run/postgresql
	fi

	if is_running; then
		:
	else
		su -c "$DAEMON -n $OPTS 2>&1 </dev/null | logger -t pgpool -p ${PGPOOL_SYSLOG_FACILITY:-local0}.info >/dev/null 2>&1 &" - postgres
	fi
}


d_stop() {
	killproc -p $PIDFILE $DAEMON -INT
	status=$?
	[ $status -eq 0 ] || [ $status -eq 3 ]
	return $?
}


case "$1" in
    start)
	log_daemon_msg "Starting pgpool-II" pgpool
	d_start
	log_end_msg $?
	;;
    stop)
	log_daemon_msg "Stopping pgpool-II" pgpool
	d_stop
	log_end_msg $?
	;;
    status)
	is_running
	status=$?
	if [ $status -eq 0 ]; then
		log_success_msg "pgpool-II is running."
	else
		log_failure_msg "pgpool-II is not running."
	fi
	exit $status
	;;
    restart|force-reload)
	log_daemon_msg "Restarting pgpool-II" pgpool
	d_stop && sleep 1 && d_start
	log_end_msg $?
	;;
    try-restart)
	if $0 status >/dev/null; then
		$0 restart
	else
		exit 0
	fi
	;;
    reload)
	exit 3
	;;
    *)
	log_failure_msg "Usage: $0 {start|stop|status|restart|try-restart|reload|force-reload}"
	exit 2
	;;
esac
