#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
PACKAGE=$(dpkg-parsechangelog -S Source)
VERSION=$2
TAR=../${PACKAGE}_${VERSION}.orig.tar.xz
DIR=${PACKAGE}-${VERSION}

# clean up the upstream tarball
svn export http://svn.terracotta.org/svn/quartz/tags/quartz-${VERSION} $DIR
XZ_OPT=--best tar -c -J -v -f $TAR --exclude '.settings' --exclude '*.jar' --exclude '*/docs/*' $DIR
rm -rf $3 $DIR
