/*
 * @(#)AnalysisModuleDataUTest.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.report;

import java.io.File;
import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.codecoverage.v2.CCCreatorUtil;
import net.sourceforge.groboutils.codecoverage.v2.IAnalysisModule;
import net.sourceforge.groboutils.codecoverage.v2.datastore.DirMetaDataReader;
import net.sourceforge.groboutils.codecoverage.v2.logger.DirectoryChannelLogReader;


/**
 * Tests the AnalysisModuleData class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:29 $
 * @since     January 22, 2003
 */
public class AnalysisModuleDataUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AnalysisModuleDataUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public AnalysisModuleDataUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1() throws Exception
    {
        try
        {
            new AnalysisModuleData( null, null, null );
            fail( "Did not throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException e)
        {
        }
    }
    
    
    public void testConstructor2() throws Exception
    {
        try
        {
            new AnalysisModuleData( createIAnalysisModule( "a", "b", "c" ),
                null, null );
            fail( "Did not throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException e)
        {
        }
    }
    
    
    public void testConstructor3() throws Exception
    {
        File f = CCCreatorUtil.createNewDirectory();
        try
        {
            new AnalysisModuleData( createIAnalysisModule( "a", "b", "c" ),
                createDirMetaDataReader( f ), null );
            fail( "Did not throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException e)
        {
        }
    }
    
    
    public void testConstructor4() throws Exception
    {
        File f = CCCreatorUtil.createNewDirectory();
        try
        {
            new AnalysisModuleData( null,
                createDirMetaDataReader( f ),
                createDirectoryChannelLogReader( f, createClassLogData(4) ) );
            fail( "Did not throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException e)
        {
        }
    }
    
    
    public void testConstructor5() throws Exception
    {
        File f = CCCreatorUtil.createNewDirectory();
        try
        {
            new AnalysisModuleData( createIAnalysisModule( "a", "b", "c" ),
                null,
                createDirectoryChannelLogReader( f, createClassLogData(2) ) );
            fail( "Did not throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException e)
        {
        }
    }
    
    
    public void testGetClassSignatures1() throws Exception
    {
        File f = CCCreatorUtil.createNewDirectory();
        AnalysisModuleData amd = new AnalysisModuleData(
            createIAnalysisModule( "a", "b", "c" ),
            createDirMetaDataReader( f ),
            createDirectoryChannelLogReader( f, createClassLogData( 1 ) ) );
        String sigs[] = amd.getClassSignatures();
        assertNotNull(
            "Got null sigs.",
            sigs );
        DOC.getLog().warn(
            "this test is failing due to incorrect class generation logic." );
        /* 
        assertEquals(
            "Didn't get correct number of classes.",
            1,
            sigs.length );
        assertEquals(
            "Did not return correct class name.",
            "a.MyClass-112",
            sigs[0] );
        */            
    }
    
    
    public void testGetClassSignatures2() throws Exception
    {
        File f = CCCreatorUtil.createNewDirectory();
        AnalysisModuleData amd = new AnalysisModuleData(
            createIAnalysisModule( "a", "b", "c" ),
            createDirMetaDataReader( f ),
            createDirectoryChannelLogReader( f, createClassLogData( 2 ) ) );
        String sigs[] = amd.getClassSignatures();
        assertNotNull(
            "Got null sigs.",
            sigs );
        DOC.getLog().warn(
            "this test is failing due to incorrect class generation logic." );
        /*
        assertEquals(
            "Didn't get correct number of classes.",
            2,
            sigs.length );
        */
    }
    
    
    public void testGetClassSignatures3() throws Exception
    {
        File f = CCCreatorUtil.createNewDirectory();
        AnalysisModuleData amd = new AnalysisModuleData(
            createIAnalysisModule( "a", "b", "c" ),
            createDirMetaDataReader( f ),
            createDirectoryChannelLogReader( f, createClassLogData( 0 ) ) );
        String sigs[] = amd.getClassSignatures();
        assertNotNull(
            "Got null sigs.",
            sigs );
        assertEquals(
            "Didn't get correct number of classes.",
            0,
            sigs.length );
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected IAnalysisModule createIAnalysisModule( String name, String unit,
            String mime )
    {
        return CCCreatorUtil.createIAnalysisModule( name, unit, mime );
    }
    
    
    protected DirMetaDataReader createDirMetaDataReader( File basedir )
            throws IOException
    {
        return CCCreatorUtil.createDirMetaDataReader( basedir,
            new Class[] { THIS_CLASS, String.class },
            CCCreatorUtil.createAnalysisModules( 2 ) );
    }
    
    
    protected DirectoryChannelLogReader createDirectoryChannelLogReader(
        File basedir, CCCreatorUtil.SimpleClassLogData[] data )
    {
        return CCCreatorUtil.createDirectoryChannelLogReader( basedir, data,
            (short)100 );
    }
    
    
    protected CCCreatorUtil.SimpleClassLogData[] createClassLogData(
            int count )
    {
        CCCreatorUtil.SimpleClassLogData[] scld = new
            CCCreatorUtil.SimpleClassLogData[ count ];
        for (int i = 0; i < count; ++i)
        {
            scld[i] = new CCCreatorUtil.SimpleClassLogData(
                (char)('a' + i)+".MyClass-112",
                new int[] { 1,2,1 }, new int[] { 11, 2, 13 } );
        }
        return scld;
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();

       
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

