/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

/**
 * Given a list of filenames, tests their well-formedness.
 * This class is for end-to-end testing for the XmlReader class.
 *
 * @see XmlReader
 * @author Elias Ross
 * @version 1.0
 */
public class XmlTester
{
	public XmlTester(String filename)
		throws IOException, XmlException
	{
		Reader r = new InputStreamReader(new FileInputStream(filename));
		XmlReader xr = new XmlReader(r);
		DefaultResolver dr = new DefaultResolver();
		File f = new File(filename);
		dr.addSearchPath(f.getParent());
		xr.setResolver(dr);
		xr.document(); 
		while (xr.Misc(null));
		if (xr.hasMoreData())
			throw new XmlException("Data leftover");
		xr.close();
	}

	public static void main(String[] args) {
		if (args.length == 0) {
			System.err.println("Usage: java net.noderunner.exml.XmlTester files ...");
		}
		for (int i = 0; i < args.length; i++) {
			String fname = args[i];
			try {
				new XmlTester(fname);
				System.out.println("File passed: " + fname);
			} catch (IOException io) {
				System.out.println("File failed: " + fname);
				System.out.println("IO Reason: " + io);
				//io.printStackTrace(System.out);
			} catch (XmlException re) {
				System.out.println("File failed: " + fname);
				System.out.println("Reason: " + re);
				//re.printStackTrace(System.out);
			}
		}
	}
}
