using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

#region Google Spreadsheets specific imports
using Google.GData.Client;
using Google.GData.Extensions;
using Google.GData.Spreadsheets;
using Google.GData.Tools;
#endregion

namespace Google_SpreadsheetApplication
{
    public partial class Form1 : Form
    {

        private String googleAuthToken = null;
        private SpreadsheetsService spreadsheetService = null;

        public Form1()
        {
            InitializeComponent();

            this.spreadsheetService = new SpreadsheetsService("GoogleSpreadsheetsSample");

            if (this.googleAuthToken == null)
            {
                GoogleClientLogin loginDialog = new GoogleClientLogin(this.spreadsheetService, "youremailhere@gmail.com");
                if (loginDialog.ShowDialog() == DialogResult.OK)
                {
                    this.googleAuthToken = loginDialog.AuthenticationToken;
                    if (this.googleAuthToken != null)
                    {
                        this.spreadsheetService.SetAuthenticationToken(this.googleAuthToken);
                        this.Text = "Successfully logged in";

                        SpreadsheetQuery q = new SpreadsheetQuery();
                        SpreadsheetFeed feed = this.spreadsheetService.Query(q);

                        foreach (SpreadsheetEntry entry in feed.Entries)
                        {
                            ListViewItem item = new ListViewItem(entry.Title.Text);
                            item.Tag = entry;
                            this.listView.Items.Add(item);
                        }
                        this.listView.Update();
                    }
                }
            }
        }
    }
}