// ----------------------------------------------------------------------------
// Copyright (C) 2014
//              David Freese, W1HKJ
//
// This file is part of flmsg
//
// flrig is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// flrig is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
// ----------------------------------------------------------------------------

#include <config.h>

// This file contains custom icons, icons from gtk, and possibly other sources.


// audio-card from gnome icon theme

/* XPM */
const char *audio_card_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 102 2",
"   c #3A3E00",
".  c #3A3F00",
"X  c #3B3F00",
"o  c #2F3536",
"O  c #303634",
"+  c #303735",
"@  c #303637",
"#  c #363D32",
"$  c #323835",
"%  c #313836",
"&  c #333936",
"*  c #323937",
"=  c #343936",
"-  c #383E31",
";  c #3B4000",
":  c #3D4104",
">  c #3E4206",
",  c #657000",
"<  c #677300",
"1  c #687400",
"2  c #687502",
"3  c #687505",
"4  c #6B7704",
"5  c #6B7901",
"6  c #6C7900",
"7  c #6C7801",
"8  c #6D7A00",
"9  c #6C7A02",
"0  c #6F7D01",
"q  c #707E02",
"w  c #707E07",
"e  c #404630",
"r  c #3D5B50",
"t  c #38595E",
"y  c #38595F",
"u  c #395A5F",
"i  c #365761",
"p  c #405C4F",
"a  c #545650",
"s  c #545652",
"d  c #555753",
"f  c #565852",
"g  c #565853",
"h  c #565854",
"j  c #575955",
"k  c #585A56",
"l  c #5A5C58",
"z  c #5D5E5B",
"x  c #5E5F5C",
"c  c #426050",
"v  c #426251",
"b  c #646662",
"n  c #656663",
"m  c #666864",
"M  c #676965",
"N  c #696A67",
"B  c #696B67",
"V  c #6E6F6D",
"C  c #6E706C",
"Z  c #6F716D",
"A  c #758201",
"S  c #748202",
"D  c #798708",
"F  c #7F8839",
"G  c #A3B31A",
"H  c #A4B31A",
"J  c #A4B419",
"K  c #AABA1A",
"L  c #858E39",
"P  c #848D3B",
"I  c #878F3D",
"U  c #87903B",
"Y  c #8A9539",
"T  c #8C9638",
"R  c #919C38",
"E  c #949E39",
"W  c #959F3A",
"Q  c #959F3B",
"!  c #929D3C",
"~  c #939E3C",
"^  c #959F3D",
"/  c #95A03C",
"(  c #96A03C",
")  c #97A03C",
"_  c #97A13C",
"`  c #97A23D",
"'  c #D8EB31",
"]  c #DBEF33",
"[  c #DFF234",
"{  c #E0F338",
"}  c #E4F839",
"|  c #E8FB38",
" . c #EBFF39",
".. c #EFFF65",
"X. c #B7B9B5",
"o. c #C4C6C2",
"O. c #C6C8C4",
"+. c #C7C9C5",
"@. c #C8CAC6",
"#. c #D0D2CE",
"$. c #D4D6D2",
"%. c None",
/* pixels */
"%.%.%.%.%.%.%.%.%.%.%.%.j k j %.",
"%.%.%.%.%.%.%.%.%.%.%.d O.#.X.d ",
"X                     a $.d d %.",
"  E W W W Q Q ( ( ( ^ f $.d %.%.",
"  ` e * * % % + # c v f $.d l x ",
"  ` + V Z Z Z C & y u f $.d o.d ",
"  ` + Z d d d N = 3 8 f $.d h g ",
"  _ + B M m n b $ p t f $.d %.%.",
"  ) - @ o o o o O r i f $.d k z ",
"  / A q 0 9 5 2 1 < , f $.d @.d ",
"  ~ K S J 6 H 7 G U I f $.d d h ",
"  ! { D ' 4 ] w [ P : a $.d %.%.",
"  T ..R } L | Y  .F > s $.d %.%.",
"; X X X X X X . . . . s +.d %.%.",
"%.%.%.%.%.%.%.%.%.%.%.d d d %.%.",
"%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%."
};

// help-about from gnome

/* XPM */
const char *help_about_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 76 1",
"  c #C4A001",
". c #C5A101",
"X c #C5A102",
"o c #C6A202",
"O c #C6A203",
"+ c #C7A403",
"@ c #C7A404",
"# c #C7A405",
"$ c #C7A406",
"% c #C7A407",
"& c #C7A507",
"* c #C8A508",
"= c #C9A70B",
"- c #C9A80D",
"; c #CAA80C",
": c #C9A810",
"> c #CCAC12",
", c #CCAC14",
"< c #CDAE1B",
"1 c #CFB11C",
"2 c #D0B11F",
"3 c #CFB021",
"4 c #D2B522",
"5 c #D3B62C",
"6 c #D2B62F",
"7 c #F6E132",
"8 c #F6E235",
"9 c #F5E038",
"0 c #F7E23A",
"q c #F8E33C",
"w c #F8E43E",
"e c #D9C04A",
"r c #E4CE4C",
"t c #E4CE4F",
"y c #E7D041",
"u c #E7D247",
"i c #EBD755",
"p c #EBD756",
"a c #ECD85A",
"s c #F8E441",
"d c #F9E644",
"f c #F6E349",
"g c #FBE74A",
"h c #F9E74D",
"j c #F7E75F",
"k c #F8E75A",
"l c #FBE95C",
"z c #E9D668",
"x c #EAD86C",
"c c #F6E664",
"v c #F6E667",
"b c #F8E864",
"n c #F8E865",
"m c #F9E96B",
"M c #FAEB71",
"N c #F9EB73",
"B c #F8EA7B",
"V c #FAEC7C",
"C c #F9EC7F",
"Z c #EEDF83",
"A c #EEDF85",
"S c #F7E981",
"D c #F8EC88",
"F c #F9ED89",
"G c #FAED8B",
"H c #F8EB8F",
"J c #F9EE9B",
"K c #FBF097",
"L c #FCF2A6",
"P c #FCF3AA",
"I c #FDF6BC",
"U c #FCF7CF",
"Y c #FDF8D1",
"T c #FDF9DF",
"R c #FEFCEE",
"E c None",
/* pixels */
"EEEEEEE.EEEEEEEE",
"EEEEEE@e@EEEEEEE",
"EEEEEE3T<EEEEEEE",
"EEEEE+ARZ+EEEEEE",
"EEEEE%UVYOEEEEEE",
"EEE+OxLdIzo+EEEE",
"E$:rHKhglPJt-@EE",
"X6DCf8wddwkGS5XE",
"E&2aBn0qsNFi1#EE",
"EEE#;pj7mp=+EEEE",
"EEEEE*c9v@EEEEEE",
"EEEEE#uby@EEEEEE",
"EEEEEE,M>EEEEEEE",
"EEEEEE&4&EEEEEEE",
"EEEEEEE EEEEEEEE",
"EEEEEEEEEEEEEEEE"
};

// insert link icon from gnome

/* XPM */
const char *insert_link_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 97 2",
"   c #2E3436",
".  c #2F3536",
"X  c #363C3D",
"o  c #373D3E",
"O  c #464A48",
"+  c #464B4C",
"@  c #4F524F",
"#  c #545652",
"$  c #555753",
"%  c #575955",
"&  c #585A56",
"*  c #595B57",
"=  c #5A5B57",
"-  c #5A5C58",
";  c #5B5D58",
":  c #5C5D59",
">  c #62645F",
",  c #656763",
"<  c #6B6D69",
"1  c #6E6F6B",
"2  c #6F716D",
"3  c #71726F",
"4  c #767773",
"5  c #777875",
"6  c #7C7E79",
"7  c #7C7F79",
"8  c #CF5F04",
"9  c #D06106",
"0  c #D86605",
"q  c #D86706",
"w  c #F47A03",
"e  c #F47A04",
"r  c #F47D0B",
"t  c #E97910",
"y  c #E97911",
"u  c #7E807D",
"i  c #EA9D4C",
"p  c #F4B15E",
"a  c #F5B364",
"s  c #FDC97D",
"d  c #838580",
"f  c #8A8C87",
"g  c #979B96",
"h  c #989B95",
"j  c #9FA19D",
"k  c #B3B4B0",
"l  c #B4B7B0",
"z  c #B7B7B1",
"x  c #B5B7B2",
"c  c #B5B8B2",
"v  c #BABDB6",
"b  c #BBBEB7",
"n  c #BBBEB8",
"m  c #BDBEBB",
"M  c #C0C0BC",
"N  c #C2C3BF",
"B  c #FBD7AA",
"V  c #FBD9AE",
"C  c #C4C6C0",
"Z  c #C5C7C1",
"A  c #CBCEC8",
"S  c #CCCEC9",
"D  c #D0D1CE",
"F  c #D1D3CE",
"G  c #D4D4D0",
"H  c #D6D7D6",
"J  c #D9DAD8",
"K  c #DBDCDB",
"L  c #DEDEDA",
"P  c #DFDFDD",
"I  c #FDE6C4",
"U  c #FEE9CA",
"Y  c #FEEACC",
"T  c #E0E0DC",
"R  c #E0E0DD",
"E  c #E2E3E2",
"W  c #E4E4E1",
"Q  c #E6E6E4",
"!  c #E7E8E6",
"~  c #E9E9E6",
"^  c #E8E9E8",
"/  c #EDEDEB",
"(  c #EDEDEC",
")  c #EDEEED",
"_  c #EEEEEC",
"`  c #EFF0EE",
"'  c #F1F1F0",
"]  c #F3F3F1",
"[  c #F3F3F2",
"{  c #F4F5F4",
"}  c #F5F5F4",
"|  c #F6F6F5",
" . c #F6F6F6",
".. c #F8F8F7",
"X. c #F9F9F9",
"o. c #FDFDFD",
"O. c None",
/* pixels */
"O.# # # # ; O.O.O.O.O.O.O.O.; # ",
"O. .{ [ ` J u - O.O.O.O.- H ) o.",
"O.v v v b C F < # $ $ # 5 / A n ",
"O.# * $ * 7 b h 1 m m 1 x Z 6 % ",
"O.O.& R Q 2 $ $ $ $ $ $ $ $ 3 K ",
"O.O.: z L ] }  ...X.| ' ( ^ ! E ",
"O.O @ 4 M G T W ~ _ P D N k j f ",
"O.S c d , = $ $ $ $ $ $ $ $ & > ",
"O.v v v l g + X O.O.O.O.X + g l ",
"O.      . o O.O.O.O.O.O.O.O.o . ",
"O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.",
"O.O.O.O.O.w e r r r r r e w O.O.",
"O.O.O.O.O.O.y V Y I U B t O.O.O.",
"O.O.O.O.O.O.O.q a s p 0 O.O.O.O.",
"O.O.O.O.O.O.O.O.9 i 9 O.O.O.O.O.",
"O.O.O.O.O.O.O.O.O.8 O.O.O.O.O.O."
};
 
 // close icon from default gtk theme

/* XPM */
const char *close_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 74 1",
"  c #5A5C58",
". c #5C5E5B",
"X c #5C5F5B",
"o c #5D5F5B",
"O c #5E5F5B",
"+ c #5E5F5C",
"@ c #5D605A",
"# c #5D605B",
"$ c #5C615B",
"% c #5F605A",
"& c #5E615B",
"* c #5E605C",
"= c #5F605C",
"- c #5E615C",
"; c #5F615C",
": c #5E605D",
"> c #5E615D",
", c #5F625C",
"< c #5F625D",
"1 c #5F615E",
"2 c #5F625E",
"3 c #60615B",
"4 c #60625D",
"5 c #60615E",
"6 c #60625E",
"7 c #61625E",
"8 c #61645F",
"9 c #7D807A",
"0 c #7E817B",
"q c #80827B",
"w c #80837E",
"e c #82847D",
"r c #82857E",
"t c #838680",
"y c #848681",
"u c #848781",
"i c #868983",
"p c #878983",
"a c #868984",
"s c #888A85",
"d c #898C86",
"f c #898D86",
"g c #8A8C86",
"h c #8A8D88",
"j c #8D9089",
"k c #8E908A",
"l c #8E918B",
"z c #8F928C",
"x c #8F928D",
"c c #91938E",
"v c #92948F",
"b c #949590",
"n c #949691",
"m c #959892",
"M c #959992",
"N c #969994",
"B c #979B95",
"V c #B1B4AC",
"C c #B4B7AF",
"Z c #B8BBB3",
"A c #B9BCB4",
"S c #BABDB5",
"D c #BDC0B8",
"F c #BDC1B9",
"G c #BFC3BB",
"H c #C1C4BC",
"J c #C3C6BE",
"K c #C3C7BF",
"L c #C4C8C0",
"P c #C5C9C1",
"I c #CACEC6",
"U c #CBCEC6",
"Y c #CDD1C9",
"T c None",
/* pixels */
"TTTTTTTTTTTTTTTT",
"TTTTTTTTTTTTTTTT",
"TT681TTTTTT ,5TT",
"TT5Ll2TTTT=wZ:TT",
"TT4fUx7TT4aDu;TT",
"TTT3jYz<;dHs+TTT",
"TTTT>kINmJh=TTTT",
"TTTTT>BPKM*TTTTT",
"TTTTT-vHGc+TTTTT",
"TTTT-uFnbSr.TTTT",
"TTT=eAg%#iCq$TTT",
"TT:9Cp@TTXyV0;TT",
"TT;Vp@TTTTOtVoTT",
"TT44&TTTTTT&O4TT",
"TTTTTTTTTTTTTTTT",
"TTTTTTTTTTTTTTTT"
};

// enter key icon from KDE's crystal theme

/* XPM */
const char *enter_key_icon[] = {
/* columns rows colors chars-per-pixel */
"16 16 91 1",
"  c #5C5C5C",
". c #626262",
"X c #666666",
"o c #696969",
"O c #6B6B6B",
"+ c #6C6C6C",
"@ c #6E6E6E",
"# c #6F6F6F",
"$ c #717171",
"% c #737373",
"& c #747474",
"* c #838383",
"= c #8D8D8D",
"- c #92928F",
"; c #939393",
": c #A3A3A2",
"> c #A7A7A5",
", c #A7A7A6",
"< c #A7A7A7",
"1 c #A9A9A8",
"2 c #A9A9A9",
"3 c #AEAEAD",
"4 c #B0B0AE",
"5 c #B1B1AF",
"6 c #B2B2B0",
"7 c #B4B4B2",
"8 c #B5B5B3",
"9 c #B7B7B6",
"0 c #B7B7B7",
"q c #B9B9B7",
"w c #BABAB9",
"e c #BBBBBB",
"r c #BCBCBB",
"t c #BEBEBC",
"y c #C2C2C1",
"u c #C4C4C0",
"i c #C4C4C4",
"p c #C5C5C5",
"a c #C6C6C4",
"s c #C7C7C7",
"d c #C9C9C6",
"f c #CBCBC8",
"g c #CACACA",
"h c #CFCFCD",
"j c #D0D0CE",
"k c #D1D1CF",
"l c #D0D0D0",
"z c #D1D1D1",
"x c #D2D2D0",
"c c #D3D3D1",
"v c #D2D2D2",
"b c #D3D3D2",
"n c #D3D3D3",
"m c #D4D4D3",
"M c #D4D4D4",
"N c #D5D5D5",
"B c #D7D7D6",
"V c #D7D7D7",
"C c #D8D8D8",
"Z c #D9D9D8",
"A c #D9D9D9",
"S c #DADAD9",
"D c #DADADA",
"F c #DCDCDC",
"G c #DDDDDD",
"H c #DEDEDE",
"J c #DFDFDF",
"K c #E0E0E0",
"L c #E2E2E2",
"P c #E3E3E3",
"I c #E4E4E4",
"U c #E5E5E5",
"Y c #E7E7E7",
"T c #E8E8E8",
"R c #E9E9E9",
"E c #EBEBEB",
"W c #ECECEC",
"Q c #EDEDED",
"! c #EFEFEF",
"~ c #F0F0F0",
"^ c #F3F3F3",
"/ c #F4F4F4",
"( c #F5F5F5",
") c #F6F6F6",
"_ c #F7F7F7",
"` c #F8F8F8",
"' c #F9F9F9",
"] c #FAFAFA",
"[ c #FCFCFC",
"{ c #FDFDFD",
"} c None",
/* pixels */
"}}}}}}}}}}}}}}}}",
"}}}}}}fSFFFFFSd}",
"}}}}}}c{[[[[['a}",
"}}}}}}x]_`'`_`t}",
"}}}}}}x)^(p`^/r}",
"}}}}}}k^!!%'!!w}",
"}}}}}}j~WQ#`EWq}",
"}}}}}}yWTR@(TR9}",
"}Z)))_/YIU+~PI8}",
"}BLHKH<zLPOWJK7}",
"}mHGD= 2siXTFG6}",
"}bDApo$&**;HCC4}",
"}bVMA0.eDDCNMN3}",
"}hvlzngzllllll1}",
"}u5>,,,,,,,,,:-}",
"}}}}}}}}}}}}}}}}"
};

// question icon from default gtk theme

/* XPM */
const char *dialog_question_48_icon[] = {
"48 48 215 2",
"  	c None",
". 	c #3768A6",
"+ 	c #3968A7",
"@ 	c #3A6AA7",
"# 	c #386BA6",
"$ 	c #3968A5",
"% 	c #A7BEDA",
"& 	c #F4F7FB",
"* 	c #F4F8FB",
"= 	c #A5BDD9",
"- 	c #3769A6",
"; 	c #3869A6",
"> 	c #BBCEE4",
", 	c #FFFFFF",
"' 	c #FEFEFF",
") 	c #BBCDE3",
"! 	c #F9FBFD",
"~ 	c #98B9DC",
"{ 	c #99B9DC",
"] 	c #729FCF",
"^ 	c #97B8DB",
"/ 	c #BACDE3",
"( 	c #719ECE",
"_ 	c #709DCD",
": 	c #709DCE",
"< 	c #6F9CCD",
"[ 	c #6F9CCC",
"} 	c #95B6DA",
"| 	c #B9CDE3",
"1 	c #6E9CCC",
"2 	c #6E9BCC",
"3 	c #6D9BCC",
"4 	c #6D9ACB",
"5 	c #94B5D9",
"6 	c #B9CCE3",
"7 	c #78A2D0",
"8 	c #709CCC",
"9 	c #6C9ACB",
"0 	c #6C99CA",
"a 	c #6B99CA",
"b 	c #93B4D8",
"c 	c #B9CCE2",
"d 	c #739FCE",
"e 	c #A1BEDE",
"f 	c #C9DAEC",
"g 	c #EBF1F8",
"h 	c #FAFCFD",
"i 	c #E7EEF6",
"j 	c #B7CDE6",
"k 	c #759FCE",
"l 	c #6B98CA",
"m 	c #6A98C9",
"n 	c #6A97C9",
"o 	c #92B3D8",
"p 	c #B9CBE2",
"q 	c #80A8D3",
"r 	c #E8EFF7",
"s 	c #6997C9",
"t 	c #6996C8",
"u 	c #6896C8",
"v 	c #91B2D7",
"w 	c #B8CBE2",
"x 	c #7FA7D2",
"y 	c #FDFDFE",
"z 	c #E9F0F7",
"A 	c #EFF4F9",
"B 	c #BBD0E7",
"C 	c #6895C8",
"D 	c #6795C7",
"E 	c #6794C7",
"F 	c #8FB1D6",
"G 	c #B8CBE1",
"H 	c #7EA6D1",
"I 	c #F2F6FA",
"J 	c #ADC6E1",
"K 	c #749FCD",
"L 	c #6A98CA",
"M 	c #AFC7E2",
"N 	c #E1EAF4",
"O 	c #6694C7",
"P 	c #6694C6",
"Q 	c #6593C6",
"R 	c #8EAFD5",
"S 	c #B7CBE1",
"T 	c #96B7DA",
"U 	c #6C99CB",
"V 	c #709CCB",
"W 	c #719DCC",
"X 	c #7FA5D0",
"Y 	c #6693C6",
"Z 	c #6592C6",
"` 	c #6492C5",
" .	c #6391C5",
"..	c #8DAFD4",
"+.	c #B0C7E2",
"@.	c #CBDBEC",
"#.	c #6391C4",
"$.	c #6290C4",
"%.	c #8CADD3",
"&.	c #B7CAE1",
"*.	c #3768A5",
"=.	c #396AA7",
"-.	c #A4BCD8",
";.	c #96B6D8",
">.	c #FDFEFE",
",.	c #85A9D2",
"'.	c #6290C3",
").	c #618FC3",
"!.	c #608EC3",
"~.	c #8BADD3",
"{.	c #A0B8D6",
"].	c #3768A7",
"^.	c #FEFFFF",
"/.	c #99B8DA",
"(.	c #A4BFDD",
"_.	c #608EC2",
":.	c #5F8DC2",
"<.	c #5F8DC1",
"[.	c #8AABD2",
"}.	c #3868A6",
"|.	c #396AA6",
"1.	c #87AAD2",
"2.	c #FBFCFE",
"3.	c #A1BDDC",
"4.	c #5F8EC2",
"5.	c #5E8DC1",
"6.	c #5E8CC1",
"7.	c #89AAD1",
"8.	c #3767A6",
"9.	c #3969A6",
"0.	c #92B4D8",
"a.	c #D0DEEE",
"b.	c #B1C8E2",
"c.	c #5D8CC1",
"d.	c #5D8BC0",
"e.	c #87AAD1",
"f.	c #F9FAFD",
"g.	c #79A0CC",
"h.	c #5C8BC0",
"i.	c #87A9D0",
"j.	c #F9FAFC",
"k.	c #B6C9E0",
"l.	c #3767A5",
"m.	c #90B2D6",
"n.	c #6B97C7",
"o.	c #6C97C8",
"p.	c #6C97C7",
"q.	c #6C96C7",
"r.	c #5C8AC0",
"s.	c #5B8ABF",
"t.	c #87A8D0",
"u.	c #3668A4",
"v.	c #8FB0D6",
"w.	c #5C8ABF",
"x.	c #5B89BF",
"y.	c #86A8D0",
"z.	c #B6CAE1",
"A.	c #8DAFD5",
"B.	c #ECF1F8",
"C.	c #5A89BF",
"D.	c #5A89BE",
"E.	c #85A7CF",
"F.	c #F8FAFC",
"G.	c #B6CAE0",
"H.	c #BACDE2",
"I.	c #8BADD4",
"J.	c #F6F8FB",
"K.	c #5A88BE",
"L.	c #5988BE",
"M.	c #5987BD",
"N.	c #84A7CE",
"O.	c #89ABD3",
"P.	c #EBF1F7",
"Q.	c #5887BD",
"R.	c #84A6CE",
"S.	c #88ABD1",
"T.	c #5886BD",
"U.	c #5786BC",
"V.	c #83A6CE",
"W.	c #82A5CE",
"X.	c #3667A4",
"Y.	c #85A8D0",
"Z.	c #5785BC",
"`.	c #5685BC",
" +	c #82A4CD",
".+	c #B6C8E0",
"++	c #3767A3",
"@+	c #85A8CF",
"#+	c #5685BB",
"$+	c #5584BB",
"%+	c #3667A3",
"&+	c #B8CAE1",
"*+	c #5684BB",
"=+	c #81A4CC",
"-+	c #B5C8E0",
";+	c #3566A2",
">+	c #82A5CD",
",+	c #5483BA",
"'+	c #B7C9E0",
")+	c #81A4CD",
"!+	c #5382BA",
"~+	c #80A3CB",
"{+	c #B5C8DF",
"]+	c #80A3CC",
"^+	c #5382B9",
"/+	c #7FA2CB",
"(+	c #B4C8DF",
"_+	c #9DB5D3",
":+	c #F1F5F9",
"<+	c #F0F4F9",
"[+	c #9CB4D3",
"}+	c #3565A1",
"|+	c #305D95",
"1+	c #3666A3",
"2+	c #305D96",
"                                                                                                ",
"                                                                                                ",
"                                            . + @ #                                             ",
"                                          $ % & * = -                                           ",
"                                        ; > , ' ' , ) ;                                         ",
"                                      ; > , ! ~ { ! , ) ;                                       ",
"                                    ; > , ! ~ ] ] ~ ! , ) ;                                     ",
"                                  ; > , ! ~ ] ] ] ] ~ ! , ) ;                                   ",
"                                ; > , ! ~ ] ] ] ] ] ] ~ ! , ) ;                                 ",
"                              ; > , ! ~ ] ] ] ] ] ] ] ] ~ ! , ) -                               ",
"                            ; > , ! ~ ] ] ] ] ] ] ] ] ] ] ^ ! , / -                             ",
"                          ; > , ! ~ ] ] ] ] ] ] ] ] ] ( ( _ ^ ! , / -                           ",
"                        ; > , ! ~ ] ] ] ] ] ] ] ( ( : _ < < [ } ! , | -                         ",
"                      ; > , ! ~ ] ] ] ] ] ] ( ( _ _ < < 1 2 3 4 5 ! , 6 -                       ",
"                    ; > , ! ~ ] ] ] ] ( ( : _ < 7 8 2 2 4 4 9 0 a b ! , c -                     ",
"                  ; > , ! ~ ] ] ] ( ( d e f g h , ' i j k a a l m n o ! , p -                   ",
"                ; > , ! ~ ] ( ( : _ < q , , , , , , , , r k n n s t u v ! , w -                 ",
"              ; > , ! ~ ( ( _ _ < < 1 x , , y z A , , , , B t u u C D E F ! , G -               ",
"            ; > , ! ^ : _ < < [ 2 2 4 H I J K l L M , , , N C D D O P Q Q R ! , S -             ",
"          ; > , ! T _ < < 1 2 3 4 9 U V W l m n s X , , , i E O Y Q Z ` `  ...! , S -           ",
"        $ > , ! } < [ 2 2 4 4 9 0 a l L n n s t u +., , , @.Q Q Z ` `  .#.$.$.%.! , &.*.        ",
"      =.-., ! } 1 2 3 4 9 U 0 a l m n s t u u C ;.>., , >.,.` `  .#.$.$.'.).).!.~.! , {.].      ",
"      . & ^.} 2 4 4 9 0 a l L n n s t u C D D /.y , , ^.(.`  .#.$.$.).).)._._.:.<.[.' I }.      ",
"      |.& ^.5 9 U 0 a l m n s t u u C D E O 1.2., , ^.3.#.$.$.'.).).!._.4.:.5.6.6.7.' I 8.      ",
"      9.-., ! 0.l L n n s t u C D D O P Q Q a., , , b.$.$.).).)._._.:.<.6.6.c.d.e.f., {.8.      ",
"        *./ , ! v s t u u C D E O Y Q Q ` ` r , , , g.).).!._.4.:.5.6.6.d.d.h.i.j., k.l.        ",
"          - ) , ! m.C D D O P Q Q Z ` `  .#.n.o.p.q.'._._.:.<.6.6.c.d.h.r.s.t.j., k.u.          ",
"            - ) , ! v.O Y Q Q ` `  .#.$.$.'.).).!._.4.:.5.6.6.d.d.h.w.s.x.y.j., z.u.            ",
"              - / , ! A.Z ` `  .#.$.$.'.).).B.& & & 6.6.c.d.h.r.s.x.C.D.E.F., G.u.              ",
"                - H., ! I.#.$.$.'.).).!._.4.J., , , d.d.h.w.s.x.C.D.K.E.F., k.u.                ",
"                  - c , ! ~.'.).)._._.:.<.6.J., , , r.s.x.x.D.K.L.M.N.F., k.u.                  ",
"                    - c , ! O._.4.:.5.6.6.d.P.& & & x.C.D.K.L.M.Q.R.F., k.u.                    ",
"                      - p , ! S.5.6.c.d.h.r.s.x.x.D.K.L.M.Q.T.U.V.F., k.u.                      ",
"                        l.w , f.i.d.h.w.s.x.C.D.K.L.M.Q.T.U.U.W.F., k.X.                        ",
"                          l.G , f.Y.x.x.D.K.L.M.Q.T.U.U.Z.`. +F., .+X.                          ",
"                            ++G , j.@+K.L.M.Q.T.U.U.`.#+$+ +F., .+%+                            ",
"                              %+&+, F.V.T.U.U.Z.`.*+$+$+=+F., -+%+                              ",
"                                ;+&., F.>+`.#+$+$+,+,+=+F., -+;+                                ",
"                                  ;+'+, F.)+$+,+,+!+~+F., {+;+                                  ",
"                                    ;+k., F.]+!+^+/+F., {+;+                                    ",
"                                      ;+k., F./+~+F., (+;+                                      ",
"                                        %+k., ^.^., (+%+                                        ",
"                                          ;+_+:+<+[+}+                                          ",
"                                            |+}+1+2+                                            ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                "
};

/* XPM */
const char *clear_sq_icon[] = {
"16 16 1 1",
"     c None",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                "
};

const char *clear_row_icon[] = {
"16 1 1 1",
"     c None",
"                "
};

// The lightning bolt icons are based on gmfsk's rx.xpm and tx.xpm

/* XPM */
const char *rx1_icon[] = {
"16 16 4 1",
" 	c None",
".	c #0F1F01",
"+	c #4E9A06",
"@	c #888A85",
"                ",
"     .........  ",
"     .++++++.@  ",
"    .++++++.@   ",
"    .+++++.@    ",
"   .+++++.@     ",
"   .++++.....   ",
"  .++++++++.@   ",
"  .....+++.@    ",
"   @@.+++.@     ",
"     .++.@      ",
"    .++.@       ",
"    .+.@        ",
"   .+.@         ",
"   ..@          ",
"                "
};

/* XPM */
const char *tx1_icon[] = {
"16 16 4 1",
" 	c None",
".	c #210000",
"+	c #A40000",
"@	c #888A85",
"                ",
"     .........  ",
"     .++++++.@  ",
"    .++++++.@   ",
"    .+++++.@    ",
"   .+++++.@     ",
"   .++++.....   ",
"  .++++++++.@   ",
"  .....+++.@    ",
"   @@.+++.@     ",
"     .++.@      ",
"    .++.@       ",
"    .+.@        ",
"   .+.@         ",
"   ..@          ",
"                "
};

/* XPM */
const char *rx2_icon[] = {
"16 16 3 1",
" 	c None",
".	c #0F1F01",
"+	c #4E9A06",
"                ",
"     .........  ",
"     .++++++.   ",
"    .++++++.    ",
"    .+++++.     ",
"   .+++++.      ",
"   .++++.....   ",
"  .++++++++.    ",
"  .....+++.     ",
"     .+++.      ",
"     .++.       ",
"    .++.        ",
"    .+.         ",
"   .+.          ",
"   ..           ",
"                "
};

/* XPM */
const char *tx2_icon[] = {
"16 16 3 1",
" 	c None",
".	c #210000",
"+	c #A40000",
"                ",
"     .........  ",
"     .++++++.   ",
"    .++++++.    ",
"    .+++++.     ",
"   .+++++.      ",
"   .++++.....   ",
"  .++++++++.    ",
"  .....+++.     ",
"     .+++.      ",
"     .++.       ",
"    .++.        ",
"    .+.         ",
"   .+.          ",
"   ..           ",
"                "
};

/* XPM */
const char *rx_icon[] = {
"16 16 38 1",
" 	c None",
".	c #0F1F01",
"+	c #64B517",
"@	c #62B315",
"#	c #61B014",
"$	c #5EAE12",
"%	c #5CAC11",
"&	c #5AA90F",
"*	c #68BA1B",
"=	c #66B719",
"-	c #65B517",
";	c #63B315",
">	c #60B014",
",	c #5EAD13",
"'	c #6ABD1C",
")	c #69BA1A",
"!	c #66B718",
"~	c #64B418",
"{	c #6FC11F",
"]	c #6CBF1E",
"^	c #6ABC1C",
"/	c #70C421",
"(	c #6CBE1E",
"_	c #6BBC1C",
":	c #75C824",
"<	c #72C622",
"[	c #6EC11F",
"}	c #6CBE1D",
"|	c #67B819",
"1	c #6DBF1E",
"2	c #73C622",
"3	c #70C321",
"4	c #74C924",
"5	c #72C522",
"6	c #79CD27",
"7	c #76CA26",
"8	c #7ACF28",
"9	c #7FD42B",
"                ",
"     .........  ",
"     .+@#$%&.   ",
"    .*=-;>,.    ",
"    .')!~@.     ",
"   .{]^)=.      ",
"   ./{(_.....   ",
"  .:</[}^*|.    ",
"  .....{1_.     ",
"     .23[.      ",
"     .45.       ",
"    .67.        ",
"    .8.         ",
"   .9.          ",
"   ..           ",
"                "
};

/* XPM */
const char *tx_icon[] = {
"16 16 34 1",
" 	c None",
".	c #210000",
"+	c #C11010",
"@	c #BE0E0E",
"#	c #BB0D0C",
"$	c #B90B0C",
"%	c #B60A0A",
"&	c #B40908",
"*	c #C51212",
"=	c #C31111",
"-	c #C00F0F",
";	c #BC0C0D",
">	c #B90C0B",
",	c #C81313",
"'	c #C10F10",
")	c #CC1617",
"!	c #CA1515",
"~	c #C71313",
"{	c #CF1818",
"]	c #CC1616",
"^	c #D41A1A",
"/	c #D11819",
"(	c #CF1718",
"_	c #C71414",
":	c #CA1514",
"<	c #C81413",
"[	c #D21919",
"}	c #CF1817",
"|	c #CD1616",
"1	c #D11818",
"2	c #D81D1D",
"3	c #D61B1B",
"4	c #DB1E1E",
"5	c #E02121",
"                ",
"     .........  ",
"     .+@#$%&.   ",
"    .*=-@;>.    ",
"    .,*='@.     ",
"   .)!~*=.      ",
"   .{]!,.....   ",
"  .^/(]!_*=.    ",
"  .....]:<.     ",
"     .[}|.      ",
"     .^1.       ",
"    .23.        ",
"    .4.         ",
"   .5.          ",
"   ..           ",
"                "};

// pskreporter.info "favicon"

/* XPM */
const char *pskr_icon[] = {
"16 16 3 1",
" 	c None",
".	c #FF0000",
"+	c #FFFF00",
"      ..        ",
"      ...       ",
"      .....     ",
"    .....+..    ",
".  ...++++...   ",
".. ..+++++. ..  ",
"....++++++..+.  ",
"..+++++++++++.. ",
"..+++++++.++++. ",
"....+++++..++.. ",
".. ..+++++....  ",
".   ..+++++..   ",
"     ...+...    ",
"      ....      ",
"       ..       ",
"       .        "};

/* XPM */
const char * flmsg_icon[] = {
"48 48 1044 2",
"  	c #FDFCFC",
". 	c #F3F2F1",
"+ 	c #F9F7F4",
"@ 	c #EBECEE",
"# 	c #FFFFFF",
"$ 	c #FFFFFE",
"% 	c #FEFEFF",
"& 	c #FFFEFD",
"* 	c #EFF2F4",
"= 	c #F9F9F8",
"- 	c #EAEAEA",
"; 	c #F5F5F5",
"> 	c #F8F8F9",
", 	c #F0EFED",
"' 	c #FEFFFF",
") 	c #ECEAEA",
"! 	c #F6F8F9",
"~ 	c #FEFEFE",
"{ 	c #FFFDFB",
"] 	c #FDFFFF",
"^ 	c #F1EEED",
"/ 	c #FBFBFA",
"( 	c #EBEAEA",
"_ 	c #F3F5F6",
": 	c #F9FAFA",
"< 	c #F7F7F7",
"[ 	c #F3F3F3",
"} 	c #F8F7F5",
"| 	c #7F786A",
"1 	c #4F6377",
"2 	c #AAA59B",
"3 	c #686B6D",
"4 	c #EFF3F8",
"5 	c #B8B2AE",
"6 	c #545860",
"7 	c #FBFBF9",
"8 	c #B09D8A",
"9 	c #52575C",
"0 	c #BEBFBF",
"a 	c #5D6366",
"b 	c #D4E5F6",
"c 	c #E1E0DC",
"d 	c #4F4B46",
"e 	c #A9B5C1",
"f 	c #FFFEF4",
"g 	c #7A7065",
"h 	c #B5C0BF",
"i 	c #837E7C",
"j 	c #8495A7",
"k 	c #C2BCB4",
"l 	c #656E76",
"m 	c #747270",
"n 	c #D9DFE0",
"o 	c #B6AF9F",
"p 	c #444452",
"q 	c #B5B8B6",
"r 	c #54575A",
"s 	c #CAD4E2",
"t 	c #EAEAEC",
"u 	c #525253",
"v 	c #ECEDF0",
"w 	c #D4C3B6",
"x 	c #3D3636",
"y 	c #96AFC6",
"z 	c #F9F9FA",
"A 	c #8E7C71",
"B 	c #484C4E",
"C 	c #CDD6DA",
"D 	c #7A6B59",
"E 	c #103963",
"F 	c #FAF0EA",
"G 	c #000000",
"H 	c #D2D8DD",
"I 	c #FFFAF2",
"J 	c #B99C77",
"K 	c #C7D8E9",
"L 	c #C8A47E",
"M 	c #161E28",
"N 	c #57311B",
"O 	c #293641",
"P 	c #160C01",
"Q 	c #CBE1F2",
"R 	c #9B9184",
"S 	c #000813",
"T 	c #ECD1B8",
"U 	c #030000",
"V 	c #DFEAEC",
"W 	c #090704",
"X 	c #A6B7C3",
"Y 	c #BCB4AE",
"Z 	c #DFE4E4",
"` 	c #DACCBB",
" .	c #000010",
"..	c #737C89",
"+.	c #E6C69F",
"@.	c #080602",
"#.	c #8599AD",
"$.	c #D4BFB5",
"%.	c #916A40",
"&.	c #1B2530",
"*.	c #A5B0A3",
"=.	c #050A0E",
"-.	c #EAF9FF",
";.	c #7A6C5D",
">.	c #081D32",
",.	c #453725",
"'.	c #768C9E",
").	c #D4D6D9",
"!.	c #707282",
"~.	c #433423",
"{.	c #40546A",
"].	c #C09E7B",
"^.	c #1E252E",
"/.	c #FDFDFD",
"(.	c #9E7E4D",
"_.	c #171B20",
":.	c #1F140A",
"<.	c #C8D5E0",
"[.	c #7C6753",
"}.	c #1D2C45",
"|.	c #FFFFEA",
"1.	c #1E1508",
"2.	c #85B2D5",
"3.	c #D7DCDE",
"4.	c #F9F8F8",
"5.	c #CEC9C5",
"6.	c #E1E8F0",
"7.	c #D6C7B7",
"8.	c #01010C",
"9.	c #615647",
"0.	c #2D3B4A",
"a.	c #393645",
"b.	c #9A8C7D",
"c.	c #010E1C",
"d.	c #B9A193",
"e.	c #FCF4EB",
"f.	c #050507",
"g.	c #28334C",
"h.	c #F3E2BE",
"i.	c #050A10",
"j.	c #E7F5FE",
"k.	c #7E6D5A",
"l.	c #14426F",
"m.	c #E6CEB2",
"n.	c #03111C",
"o.	c #FCFFFF",
"p.	c #B59D7F",
"q.	c #71726D",
"r.	c #80857C",
"s.	c #040505",
"t.	c #E6F0FB",
"u.	c #D5AD83",
"v.	c #161F2A",
"w.	c #3A210E",
"x.	c #2E4A64",
"y.	c #180D02",
"z.	c #CDE4F6",
"A.	c #B6AB94",
"B.	c #CFB59D",
"C.	c #E9F4F6",
"D.	c #23190E",
"E.	c #98AEBD",
"F.	c #4B2E16",
"G.	c #6381A9",
"H.	c #E6D4C0",
"I.	c #00001A",
"J.	c #FFFDF0",
"K.	c #C1D3DC",
"L.	c #D7C1AB",
"M.	c #747A7A",
"N.	c #757A7D",
"O.	c #0E0C06",
"P.	c #A7C5D4",
"Q.	c #DCBCA6",
"R.	c #FBF2EF",
"S.	c #927656",
"T.	c #394D65",
"U.	c #00040A",
"V.	c #F2FFFF",
"W.	c #F3F0ED",
"X.	c #72675C",
"Y.	c #585E63",
"Z.	c #E1F2FE",
"`.	c #918675",
" +	c #797C7F",
".+	c #6B6665",
"++	c #F0FDFF",
"@+	c #EDDDCE",
"#+	c #505152",
"$+	c #90989D",
"%+	c #85817D",
"&+	c #606163",
"*+	c #818385",
"=+	c #AFB8BE",
"-+	c #EAF3FB",
";+	c #C9C5C0",
">+	c #5A5855",
",+	c #858A8F",
"'+	c #FFFEFA",
")+	c #CEC7C2",
"!+	c #8A8683",
"~+	c #91959C",
"{+	c #D1D4DA",
"]+	c #EDEAE6",
"^+	c #A4A19D",
"/+	c #848588",
"(+	c #AFB2B4",
"_+	c #ECF0F5",
":+	c #958473",
"<+	c #525152",
"[+	c #BDD5EB",
"}+	c #BFB29E",
"|+	c #61656D",
"1+	c #6E655C",
"2+	c #C9DAF1",
"3+	c #FFFDF4",
"4+	c #6A6764",
"5+	c #6E7177",
"6+	c #98999A",
"7+	c #808182",
"8+	c #EFEDED",
"9+	c #A19F9C",
"0+	c #555556",
"a+	c #ACB2B7",
"b+	c #FBFCFC",
"c+	c #FBFBFB",
"d+	c #E5E9EC",
"e+	c #DFE9F0",
"f+	c #DCD9D8",
"g+	c #C4C8CF",
"h+	c #F6F5F8",
"i+	c #F8FAF9",
"j+	c #F7FAFE",
"k+	c #FAFFFF",
"l+	c #DEE1E4",
"m+	c #F4F1EE",
"n+	c #EBEBED",
"o+	c #FEFCFA",
"p+	c #FCFBF8",
"q+	c #CCCED0",
"r+	c #DAD4D0",
"s+	c #D7E0E9",
"t+	c #C4C4C4",
"u+	c #DBE6EB",
"v+	c #E2E9EF",
"w+	c #D8DCDC",
"x+	c #D8D5D0",
"y+	c #CDD2D7",
"z+	c #FBFAF7",
"A+	c #EDE8DF",
"B+	c #C9D2DC",
"C+	c #FFFFFD",
"D+	c #EFF7FD",
"E+	c #D3D7D7",
"F+	c #E5E7EB",
"G+	c #F9F4EF",
"H+	c #DAE0E5",
"I+	c #FFFDFC",
"J+	c #FDFEFE",
"K+	c #FCFCFC",
"L+	c #FCFDFD",
"M+	c #C0A188",
"N+	c #B3C8D5",
"O+	c #A58271",
"P+	c #91979A",
"Q+	c #F4FBF0",
"R+	c #36363C",
"S+	c #BAA994",
"T+	c #8792A7",
"U+	c #89796A",
"V+	c #88A6C2",
"W+	c #525050",
"X+	c #D0DBE5",
"Y+	c #958877",
"Z+	c #9AABC1",
"`+	c #DAC6B2",
" @	c #5F84A2",
".@	c #82655B",
"+@	c #CCC4C1",
"@@	c #A3A0A5",
"#@	c #877D7F",
"$@	c #C0AAA0",
"%@	c #CDD3D8",
"&@	c #645447",
"*@	c #8699AE",
"=@	c #717880",
"-@	c #936E4D",
";@	c #C1E4FE",
">@	c #7B6B58",
",@	c #CCD5DF",
"'@	c #826251",
")@	c #7D8485",
"!@	c #CBD6DA",
"~@	c #4E3D36",
"{@	c #9FAAB0",
"]@	c #C1BDB6",
"^@	c #5D7393",
"/@	c #FCFCFD",
"(@	c #243044",
"_@	c #D0DCE4",
":@	c #9A958D",
"<@	c #888C95",
"[@	c #918B7C",
"}@	c #8C9EB3",
"|@	c #FEFBF8",
"1@	c #665C60",
"2@	c #A49F8E",
"3@	c #778BA5",
"4@	c #493E3D",
"5@	c #587D9A",
"6@	c #C3C1C1",
"7@	c #7C7E83",
"8@	c #7B7D7D",
"9@	c #E2D1BF",
"0@	c #618BAF",
"a@	c #AA8A7B",
"b@	c #877D78",
"c@	c #C3BCBC",
"d@	c #82736F",
"e@	c #B2A09B",
"f@	c #DADFDF",
"g@	c #160A08",
"h@	c #B5C5D2",
"i@	c #757677",
"j@	c #261613",
"k@	c #D6DEE7",
"l@	c #6E513E",
"m@	c #95ABB8",
"n@	c #7E5B47",
"o@	c #858A88",
"p@	c #ABBCC2",
"q@	c #3A271B",
"r@	c #99A1A1",
"s@	c #D6DADB",
"t@	c #2E364B",
"u@	c #FEFEFD",
"v@	c #FDFCFB",
"w@	c #B8ABA3",
"x@	c #FFFCFA",
"y@	c #C3C1BE",
"z@	c #C3D1D9",
"A@	c #F3F4EE",
"B@	c #BDBFC5",
"C@	c #FCF4EC",
"D@	c #EAFFFF",
"E@	c #D0CFCC",
"F@	c #A6ABB2",
"G@	c #FFFFFA",
"H@	c #C5C7CA",
"I@	c #C2B5AE",
"J@	c #F7FFFF",
"K@	c #C1C0C3",
"L@	c #D9D4CF",
"M@	c #BEC9D3",
"N@	c #D6CDC8",
"O@	c #DAD7D6",
"P@	c #B0B3B8",
"Q@	c #DCD6CC",
"R@	c #B7C3CF",
"S@	c #E9E7E0",
"T@	c #D2CECA",
"U@	c #AAB2BB",
"V@	c #B6B7B8",
"W@	c #FFF9E9",
"X@	c #9EB3C7",
"Y@	c #ABB0B6",
"Z@	c #C3B9B2",
"`@	c #B1B7BE",
" #	c #FBFCF7",
".#	c #B0AEAF",
"+#	c #DBDDE3",
"@#	c #BFB8AF",
"##	c #F1FFFF",
"$#	c #FEFDFE",
"%#	c #FFFEFE",
"&#	c #F8F8F8",
"*#	c #E3E2E1",
"=#	c #A1A5AB",
"-#	c #FFFEF9",
";#	c #E9E2DE",
">#	c #F6F6F4",
",#	c #F2F3F3",
"'#	c #DCDCDE",
")#	c #FBFAF9",
"!#	c #F3F3F5",
"~#	c #E2E4E6",
"{#	c #E9E3E4",
"]#	c #F9FFFE",
"^#	c #E5E0E1",
"/#	c #F8FAFB",
"(#	c #EDEBE7",
"_#	c #E4E8EC",
":#	c #949595",
"<#	c #EBE6E2",
"[#	c #E8EDF1",
"}#	c #E0DCE0",
"|#	c #FAF8F3",
"1#	c #EEF0F2",
"2#	c #AEAEAE",
"3#	c #F2EEED",
"4#	c #F6F7F6",
"5#	c #E6E9EE",
"6#	c #F7F7F6",
"7#	c #E2DBD3",
"8#	c #FBFCFB",
"9#	c #EDE9E5",
"0#	c #F1F1F1",
"a#	c #706D70",
"b#	c #797877",
"c#	c #D8C1B2",
"d#	c #CBC2B0",
"e#	c #E0E8EA",
"f#	c #6D6A6C",
"g#	c #ACAEB3",
"h#	c #F2F0EF",
"i#	c #D7D3C8",
"j#	c #C6C8CC",
"k#	c #93B5C8",
"l#	c #5F2C1E",
"m#	c #C3D4D5",
"n#	c #806162",
"o#	c #D0D0CB",
"p#	c #B5B3B6",
"q#	c #B0BDC9",
"r#	c #A4A3A0",
"s#	c #7D89A3",
"t#	c #DAE5EE",
"u#	c #775045",
"v#	c #C2D1D7",
"w#	c #E7EBF0",
"x#	c #A39E9B",
"y#	c #5B3F37",
"z#	c #F1F6EB",
"A#	c #6683A9",
"B#	c #BBAE9A",
"C#	c #C6D7E4",
"D#	c #BDB6B1",
"E#	c #D9D6CF",
"F#	c #EEECE9",
"G#	c #73849B",
"H#	c #D1CAB5",
"I#	c #E9ECE8",
"J#	c #DECDB4",
"K#	c #F8FFFF",
"L#	c #C6BFB9",
"M#	c #797A82",
"N#	c #E0E6EF",
"O#	c #D2D1CC",
"P#	c #CCD5DC",
"Q#	c #A5C4D9",
"R#	c #713B34",
"S#	c #D3EEF0",
"T#	c #795659",
"U#	c #D9DED1",
"V#	c #CAD0D0",
"W#	c #6F809A",
"X#	c #A4A29F",
"Y#	c #657087",
"Z#	c #EDFDFF",
"`#	c #744F4F",
" $	c #A9AEA6",
".$	c #D7E0EC",
"+$	c #A19D9B",
"@$	c #9B8889",
"#$	c #6C91BF",
"$$	c #FFF0D9",
"%$	c #DFE2E3",
"&$	c #6B5750",
"*$	c #D2D8D7",
"=$	c #DBD1C8",
"-$	c #F0F0F0",
";$	c #DCDDDD",
">$	c #B6B0AA",
",$	c #CACCD2",
"'$	c #F6F3F1",
")$	c #D2D5DA",
"!$	c #E8E4E0",
"~$	c #D7DCE1",
"{$	c #F3F1F0",
"]$	c #F2F1F1",
"^$	c #F6F4F2",
"/$	c #D7D3D1",
"($	c #EFEFEF",
"_$	c #D6DBDC",
":$	c #E6E3E2",
"<$	c #CFD1CF",
"[$	c #E8EAEE",
"}$	c #D2D0CF",
"|$	c #F1F1F0",
"1$	c #F2F2F2",
"2$	c #979797",
"3$	c #F6F5F4",
"4$	c #D8D7D6",
"5$	c #DFE0DD",
"6$	c #EBEEF3",
"7$	c #E1DEDA",
"8$	c #F3F3F2",
"9$	c #F1F1F2",
"0$	c #F4F4F4",
"a$	c #F0F0F1",
"b$	c #EFEFEE",
"c$	c #A7A4A3",
"d$	c #F4F3ED",
"e$	c #CFCDC9",
"f$	c #C4C3C4",
"g$	c #F0F1F1",
"h$	c #DDDEDD",
"i$	c #EBE9E8",
"j$	c #D6DBDF",
"k$	c #D7D7D7",
"l$	c #CCCCCB",
"m$	c #98999B",
"n$	c #E5E6E0",
"o$	c #BBBEC4",
"p$	c #D8D5D4",
"q$	c #BCBFC3",
"r$	c #D5D5D3",
"s$	c #BDBDBC",
"t$	c #C0C1C3",
"u$	c #C8CACE",
"v$	c #CACDD2",
"w$	c #D4CCC4",
"x$	c #CFD5DA",
"y$	c #DAD9D9",
"z$	c #D8D8D7",
"A$	c #DBDBDC",
"B$	c #D4D5D6",
"C$	c #DADADA",
"D$	c #9C9C9C",
"E$	c #D5D9DE",
"F$	c #D6DCE0",
"G$	c #C0BDBD",
"H$	c #C0BFBB",
"I$	c #CDCDCE",
"J$	c #C4C9CB",
"K$	c #D7D4D0",
"L$	c #C1C0BE",
"M$	c #DDDAD7",
"N$	c #D6D6D6",
"O$	c #A4A3A2",
"P$	c #D3D4D5",
"Q$	c #BEBFC0",
"R$	c #CBC9C6",
"S$	c #CBCDCC",
"T$	c #C9CAC7",
"U$	c #B9BCC6",
"V$	c #D1CECB",
"W$	c #B8B7B6",
"X$	c #F4F7F8",
"Y$	c #694F4C",
"Z$	c #A69693",
"`$	c #F5F7FA",
" %	c #B5A696",
".%	c #E7EEE5",
"+%	c #A6A0A5",
"@%	c #8599B2",
"#%	c #BEA392",
"$%	c #A0ADA9",
"%%	c #ECF2F1",
"&%	c #927B6B",
"*%	c #97989A",
"=%	c #DDCBB8",
"-%	c #A2AEBE",
";%	c #A27E76",
">%	c #D6E9ED",
",%	c #978A88",
"'%	c #EEEFEF",
")%	c #DCD2CA",
"!%	c #CDEAFF",
"~%	c #9F9B99",
"{%	c #BCA79C",
"]%	c #59648C",
"^%	c #FEFDF3",
"/%	c #ECF5F7",
"(%	c #868E87",
"_%	c #BFCEE4",
":%	c #E7E6E5",
"<%	c #F2F6F7",
"[%	c #63443E",
"}%	c #636A7A",
"|%	c #DBDEE2",
"1%	c #A6AAAC",
"2%	c #EAEDF0",
"3%	c #8B8489",
"4%	c #EEEEE3",
"5%	c #819DBD",
"6%	c #CEB696",
"7%	c #D8F6F8",
"8%	c #67889F",
"9%	c #E1B58E",
"0%	c #EBF8FF",
"a%	c #A1A19F",
"b%	c #777270",
"c%	c #C8C8C0",
"d%	c #735358",
"e%	c #E9E8D6",
"f%	c #837B86",
"g%	c #D6D8D6",
"h%	c #E7E4E3",
"i%	c #F7F4F3",
"j%	c #EBE9E1",
"k%	c #94B7D9",
"l%	c #989492",
"m%	c #CBBAB6",
"n%	c #4B517C",
"o%	c #FAFBF2",
"p%	c #C1CFD0",
"q%	c #F8F6F2",
"r%	c #93B1C5",
"s%	c #767278",
"t%	c #ECF1F7",
"u%	c #F9F9F9",
"v%	c #E6E7E6",
"w%	c #726F6F",
"x%	c #FFFFFB",
"y%	c #929CA7",
"z%	c #8E8982",
"A%	c #D1D3D3",
"B%	c #A09C9D",
"C%	c #C6C6C3",
"D%	c #A8B0B5",
"E%	c #C0BCB9",
"F%	c #C9CDD3",
"G%	c #B9AFAA",
"H%	c #EAF2F9",
"I%	c #8D8A86",
"J%	c #DEEFF7",
"K%	c #D1D5DC",
"L%	c #9F9999",
"M%	c #E0EAF5",
"N%	c #ACA39E",
"O%	c #B6BBBC",
"P%	c #BEBDBF",
"Q%	c #F7EEE5",
"R%	c #B8B2AD",
"S%	c #F3FCFF",
"T%	c #F9F9F7",
"U%	c #F6F6F6",
"V%	c #918E8C",
"W%	c #D9D7D5",
"X%	c #A6A7AE",
"Y%	c #F1F0F0",
"Z%	c #817E85",
"`%	c #F4F0E7",
" &	c #B2B9C4",
".&	c #EDEFF3",
"+&	c #EBECEA",
"@&	c #FDFDFC",
"#&	c #FDFEFF",
"$&	c #FEFDFC",
"%&	c #F6F6F7",
"&&	c #BCBCBC",
"*&	c #BEBEBE",
"=&	c #9F9F9F",
"-&	c #C7C8C8",
";&	c #C4C6C7",
">&	c #C2C4C6",
",&	c #C1C0BF",
"'&	c #C1C1C1",
")&	c #C6C6C6",
"!&	c #BFBFBF",
"~&	c #C3C3C3",
"{&	c #C6C6C7",
"]&	c #BEBEBF",
"^&	c #BEC0C1",
"/&	c #C0BEBD",
"(&	c #C5C5C6",
"_&	c #C1C1C2",
":&	c #C1BFBF",
"<&	c #C4C5C6",
"[&	c #C3C2C0",
"}&	c #BEBDBD",
"|&	c #C3C4C6",
"1&	c #9D9E9E",
"2&	c #B8AFB1",
"3&	c #BCB0A3",
"4&	c #D9C8BC",
"5&	c #E8F1F8",
"6&	c #E5E3E0",
"7&	c #BAB5B5",
"8&	c #F2F4F5",
"9&	c #D3D5D5",
"0&	c #FEFBFA",
"a&	c #F4F6F5",
"b&	c #BEB9B8",
"c&	c #F8F8F6",
"d&	c #FDF2E5",
"e&	c #F0FCFF",
"f&	c #C4BCBB",
"g&	c #DFDFDD",
"h&	c #D4D0D0",
"i&	c #E5F2F7",
"j&	c #C6BEB8",
"k&	c #CDDCE9",
"l&	c #E6E5E2",
"m&	c #D1DEEF",
"n&	c #D3C6BD",
"o&	c #999999",
"p&	c #CEC2BC",
"q&	c #928172",
"r&	c #EFC9A8",
"s&	c #767C84",
"t&	c #A7ABB1",
"u&	c #938788",
"v&	c #E4E0D7",
"w&	c #5D6876",
"x&	c #F1F2F4",
"y&	c #DDE2E7",
"z&	c #161927",
"A&	c #E4E4E4",
"B&	c #73747C",
"C&	c #B1B8C1",
"D&	c #9E908B",
"E&	c #E2E0DE",
"F&	c #A1897E",
"G&	c #E0F4F2",
"H&	c #8CAED9",
"I&	c #A88473",
"J&	c #D4CFCC",
"K&	c #E5DED5",
"L&	c #A1927E",
"M&	c #7C7075",
"N&	c #989797",
"O&	c #E8E0DB",
"P&	c #A59D97",
"Q&	c #E8C8AE",
"R&	c #C4CED8",
"S&	c #C9C7C7",
"T&	c #958D8D",
"U&	c #EAEFEF",
"V&	c #BCB0A7",
"W&	c #EEE8E5",
"X&	c #DCE0E4",
"Y&	c #AAA7A6",
"Z&	c #D7D3CA",
"`&	c #E8E5DF",
" *	c #D1CAC4",
".*	c #89858B",
"+*	c #D8D7D3",
"@*	c #A19593",
"#*	c #DFF2F4",
"$*	c #888B95",
"%*	c #A6B2C3",
"&*	c #E3E7EF",
"**	c #F9F5EE",
"=*	c #ABBDCE",
"-*	c #A9958C",
";*	c #FAFBFB",
">*	c #F9FBFC",
",*	c #F7FBFE",
"'*	c #FAFAFA",
")*	c #F7F6F6",
"!*	c #F8F9FB",
"~*	c #F6F7F8",
"{*	c #F7F6F5",
"]*	c #FDFDFE",
"^*	c #F7F8F9",
"/*	c #F5F6F7",
"(*	c #F8F9FA",
"_*	c #F9F6F5",
":*	c #FFFEFB",
"<*	c #F5F4F3",
"[*	c #F4F5F6",
"}*	c #FDFAF7",
"|*	c #989897",
"1*	c #FCFBFB",
"2*	c #FCFCFB",
"3*	c #FBFCFD",
"4*	c #9A9C9D",
"5*	c #CEC4B7",
"6*	c #828C94",
"7*	c #E0DDD8",
"8*	c #A6A6A7",
"9*	c #BCB8B4",
"0*	c #B3BEC6",
"a*	c #EFEBE5",
"b*	c #716561",
"c*	c #D5E9F3",
"d*	c #928683",
"e*	c #EFF1F3",
"f*	c #888584",
"g*	c #C7BEB6",
"h*	c #B6C1CA",
"i*	c #B4A799",
"j*	c #B1BBBF",
"k*	c #E6DFD4",
"l*	c #979FAB",
"m*	c #A6A4A4",
"n*	c #BCCAD9",
"o*	c #B6ADA5",
"p*	c #D2DBE1",
"q*	c #B6BCB1",
"r*	c #DFDFDF",
"s*	c #AE9F9B",
"t*	c #F8FCF9",
"u*	c #FAF0EC",
"v*	c #FFEBC9",
"w*	c #496797",
"x*	c #E2AA84",
"y*	c #858C91",
"z*	c #617C9D",
"A*	c #F3F1F3",
"B*	c #C5C8C1",
"C*	c #E8E4DD",
"D*	c #CEC8C4",
"E*	c #5076A5",
"F*	c #E0CFBC",
"G*	c #CEECFB",
"H*	c #6A5662",
"I*	c #C7CFD1",
"J*	c #9A9B9C",
"K*	c #D1C9BD",
"L*	c #949BA0",
"M*	c #C3BDB3",
"N*	c #74797F",
"O*	c #B0ADAF",
"P*	c #989895",
"Q*	c #A29E9C",
"R*	c #8F7F75",
"S*	c #A9B8CC",
"T*	c #A68C7E",
"U*	c #71767E",
"V*	c #A69A91",
"W*	c #929FAD",
"X*	c #D2C6BA",
"Y*	c #BCC4CC",
"Z*	c #B5B4B1",
"`*	c #B2B0B0",
" =	c #AEADA9",
".=	c #A8A5AD",
"+=	c #92867E",
"@=	c #BBC4CC",
"#=	c #FAF8F6",
"$=	c #E6E8EB",
"%=	c #FBFAF8",
"&=	c #EEEBE8",
"*=	c #999A9B",
"==	c #E5DFD5",
"-=	c #9DA4A1",
";=	c #D8DDE2",
">=	c #E9E8E6",
",=	c #C5C4C9",
"'=	c #FBF7EC",
")=	c #BEC5D4",
"!=	c #C0BFC1",
"~=	c #F4F4F6",
"{=	c #D3CFC3",
"]=	c #727A84",
"^=	c #B8B2AC",
"/=	c #CAC5BF",
"(=	c #D9D2D0",
"_=	c #E7EDEE",
":=	c #CECECF",
"<=	c #C4C6CA",
"[=	c #CFCCD1",
"}=	c #DFCEC2",
"|=	c #ECE7E2",
"1=	c #989898",
"2=	c #F6F6DE",
"3=	c #D1CFBE",
"4=	c #878F9E",
"5=	c #C1B1A5",
"6=	c #7F8B9D",
"7=	c #C1C7C5",
"8=	c #6A7689",
"9=	c #F2EDE8",
"0=	c #D9F3F9",
"a=	c #A98467",
"b=	c #C0CFD5",
"c=	c #8A8789",
"d=	c #908277",
"e=	c #839DB7",
"f=	c #A39187",
"g=	c #918C87",
"h=	c #2E2E4A",
"i=	c #ECECE0",
"j=	c #9A9A9B",
"k=	c #E3DACE",
"l=	c #949EA8",
"m=	c #F7F8FD",
"n=	c #A4A2A2",
"o=	c #D3D5DC",
"p=	c #CFC9C1",
"q=	c #F9F8F6",
"r=	c #A29FA3",
"s=	c #FBFEFF",
"t=	c #CFC7BF",
"u=	c #E3EBF6",
"v=	c #BEB1A6",
"w=	c #EAF2F7",
"x=	c #CBBDB1",
"y=	c #E4EEF4",
"z=	c #B7B2B0",
"A=	c #B5B6B9",
"B=	c #A9ACB5",
"C=	c #D2D1D2",
"D=	c #EEEDEF",
"E=	c #C4C1C9",
"F=	c #FFF8EC",
"G=	c #D8E2ED",
"H=	c #D2D4D7",
"I=	c #FDF9F6",
"J=	c #E1E6E6",
"K=	c #DBD2C6",
"L=	c #FCFCF6",
"M=	c #B8CED9",
"N=	c #F4EEE8",
"O=	c #EAE4E1",
"P=	c #D6DAD9",
"Q=	c #D4C9B9",
"R=	c #9FACBA",
"S=	c #CFCBC5",
"T=	c #C3C6CD",
"U=	c #DCD4D5",
"V=	c #9A7F83",
"W=	c #9AACC2",
"X=	c #E2BFA1",
"Y=	c #84868D",
"Z=	c #A6B4C2",
"`=	c #FEFDF9",
" -	c #B0C1D2",
".-	c #686E77",
"+-	c #95A7AE",
"@-	c #5C7F9A",
"#-	c #937657",
"$-	c #98A4AC",
"%-	c #62615B",
"&-	c #949B9E",
"*-	c #828A91",
"=-	c #95857C",
"--	c #EFE1B8",
";-	c #C1C5CB",
">-	c #113253",
",-	c #B6B7BB",
"'-	c #D9D4C7",
")-	c #E0D7D9",
"!-	c #A1898B",
"~-	c #9CABBF",
"{-	c #D9B79B",
"]-	c #A8B1C1",
"^-	c #97948F",
"/-	c #8D7C83",
"(-	c #E0DEDD",
"_-	c #7A7E86",
":-	c #E3F8F8",
"<-	c #525876",
"[-	c #C0A583",
"}-	c #C9D7DC",
"|-	c #868E90",
"1-	c #E6EAEB",
"2-	c #384054",
"3-	c #737781",
"4-	c #E7D6AA",
"5-	c #F1F3E7",
"6-	c #4E5F79",
"7-	c #D4CCBE",
"8-	c #E0EAEF",
"9-	c #FFFFF3",
"0-	c #CFDDEA",
"a-	c #F7EEE4",
"b-	c #DEE4EB",
"c-	c #F8F5F0",
"d-	c #FAF8F7",
"e-	c #D9E1E5",
"f-	c #E3DFDE",
"g-	c #C5C6C6",
"h-	c #CBCED5",
"i-	c #DFE1E5",
"j-	c #DDD6CE",
"k-	c #C9CED1",
"l-	c #F1ECE6",
"m-	c #E9EEF4",
"n-	c #E1DAD7",
"o-	c #D5DCE9",
"p-	c #D7CAC3",
"q-	c #E0D5CC",
"r-	c #DDE7F0",
"s-	c #A0A1A1",
"t-	c #746363",
"u-	c #705F4C",
"v-	c #DFE8F0",
"w-	c #F7F0D5",
"x-	c #E7F2FE",
"y-	c #897E7C",
"z-	c #B39F8D",
"A-	c #B5AEA7",
"B-	c #C4C1BD",
"C-	c #899DB1",
"D-	c #8C705F",
"E-	c #9AAEB9",
"F-	c #83756D",
"G-	c #E8DFDA",
"H-	c #BBA694",
"I-	c #908186",
"J-	c #E2DFCE",
"K-	c #808D9D",
"L-	c #848580",
"M-	c #E0D7CA",
"N-	c #A4B9C6",
"O-	c #5978A0",
"P-	c #9C9898",
"Q-	c #9294A1",
"R-	c #BFC9CE",
"S-	c #AB9E9D",
"T-	c #9C958C",
"U-	c #E6E9E8",
"V-	c #8290A3",
"W-	c #FFFBF5",
"X-	c #CDC4BF",
"Y-	c #EBE4E0",
"Z-	c #BDB0A4",
"`-	c #A0A3B1",
" ;	c #E3E4E7",
".;	c #AAB3BD",
"+;	c #BDB7B5",
"@;	c #D1D2C8",
"#;	c #D5E1EF",
"$;	c #B58E67",
"%;	c #CEE3F6",
"&;	c #C4BFBD",
"*;	c #FFFCF5",
"=;	c #D0CECA",
"-;	c #D0CBC7",
";;	c #A09EA1",
">;	c #E0E1E2",
",;	c #E9ECEE",
"';	c #CCC7CA",
");	c #EEEBE0",
"!;	c #7F7081",
"~;	c #F0F5F7",
"{;	c #C8D3DF",
"];	c #EEE2D5",
"^;	c #F5F4F4",
"/;	c #F8F7F6",
"(;	c #FDFDFF",
"_;	c #F6F8FA",
":;	c #CDCBCC",
"<;	c #FCF9F8",
"[;	c #EAE8E9",
"};	c #FFFEFC",
"|;	c #FCFEFF",
"1;	c #F8F6F5",
"2;	c #F6F5F5",
"3;	c #FAFAFC",
"  . + @ # # # $ # % & * = - # # ; > , ' # ) ! # ~ # { - ] # ^ / ( # # # $ # % # _ : # # # < [ # ",
"} | 1 2 3 4 ' 5 6 # 7 8 9 0 a b c d e f g h i j # k l 0 m n o p q r s ~ t u v $ w x y z A B C # ",
"# D E F G H I J G K ' L M # N O # P Q R S # T U V W X # Y Z `  .# G ..# +.@.#.# $.%.&.# *.=.-.# ",
"# ;.>.,.'.# ).!.~.{.# ].^./.(._.% :.<.[.}./.|.1.2.G 3.4.5.6.7.8.9.0.# # a.b.c.# d.e.f.g.h.i.j.# ",
"# k.l.m.n.o.p.q.r.s.t.u.v.# w.x.# y.z.A.G # B.G C.D.E.# F.G.H.I.J.G K.L.M.N.O.P.Q.R.S.T.# U.V.# ",
"W.X.Y.Z.`. +.+++@+#+$+%+&+*+=+-+;+>+,+'+)+!+~+{+# ]+^+/+(+_+:+<+[+}+|+1+2+3+4+5+6+7+] 8+9+0+a+# ",
"# # # # # # # # # # # # # # # b+# # # $ # # # # # # # # # /.# # # ' # # # # # # # # b+~ # # # # ",
"# c+c+' d+e+f+g+h+i+: c+j+k+l+# m+n+o+p+q+r+s+t+u+v+w+x+y+# z+A+B+C+D+b+E+F+G+H+I+q+# J+K+c+L+# ",
"# # # # M+N+O+P+Q+R+# # S+T+U+V+W+X+Y+Z+`+ @.@+@@@#@$@%@&@*@$ =@-@;@>@,@'@)@!@~@{@]@^@% /.# # # ",
"# # # /@# (@_@:@<@[@}@|@1@2@3@4@5@6@7@8@9@0@a@b@c@d@e@f@g@h@# i@j@k@l@m@n@o@p@q@r@s@t@# K+# # # ",
"# # # u@v@w@x@y@z@A@B@C@D@E@F@G@H@I@J@K@L@M@N@O@P@Q@R@S@T@U@~ V@W@X@# Y@Z@`@ #.#+#@#### # # # # ",
"# # # # # # # # # # # # $ # # ' # # # # # # # # # # # # # # # # # # $## # # # # # # $ # # # # # ",
"# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # ",
"# # # ~ /.# # # # # # # # # # # # # # # # # # K+# # # # # # # # # # # # # # # /.# # # # # # # # ",
"# # # # # # # # # % # # # # # ~ # %## # # # # # ~ # ~ # # # # # # # # # # # # # ~ # ' # $ # # # ",
"&#&#< *#=#-#;#>#,#'#)#[ !#~## {#]#^#/#(#_#< # :#<#[#}#|#1#< &#&#&#&#&#&#&#; # 2#3#4#5#6#7#8#* 9#",
"# # # 0#a#b#c#d#e#f#g#h#i#j#k#l#m#n#o#p#q## # r#s#t#u#v#w## # # # # # # # ~ # x#y#z#A## B#C#D#E#",
"# # ~ F#G#H#I#J#K#L#M#N#O#P#Q#R#S#T#U#V#W## # X#Y#Z#`# $.$~ # # # # # # # L+# +$@$K+#$$$%$&$*$=$",
"0#0#-$;$>$,$'$)$!$~${$]$^$/$($_$:$<$[$}$|$($1$2$3$4$5$6$7$8$0#9$0$a$0#0#0#b$1$c$d+d$e$f$g$h$i$j$",
"k$k$k$l$m$n$`@o$p$q$r$s$t$u$v$w$x$y$z$A$B$k$C$D$E$F$G$H$I$J$k$K$L$M$k$z$k$N$C$O$P$Q$R$S$T$U$V$W$",
"# # # X$Y$Z$`$ %.%+%# @%#%$%%%&%# # # # # # # *%=%-%;%>%,%'%# G@)%!%# # # # # ~%{%]%^%/%# (%_%:%",
"# # # <%[%}%|%1%2%3%4%5%6%7%8%9%0%# # # # ~ # a%b%c%d%e%f%g%h%i%j%k%# ' # ~ # l%m%n%o%p%q%r%s%t%",
"u%u%&#v%w%x%y%z%A%B%C%D%E%F%' G%H%u%u%u%u%< # I%J%K%L%M%N%O%P%Q%R%S%T%u%u%U%# V%W%X%Y%Z%`% &.&+&",
"/././.u%c+% # # # # # # # # @&# & /././././.# '%# # # C+# # # #&# $&/././.K+# %&# # ~ # #&# %#% ",
"# # # # # # # # # # # # # # # # # # # # # # # ~ # # # # # # # # # # # # # # # # # # # # # # # # ",
"/././././././././././././././././././././././.K+/./././././././././././././././././././././././.",
"# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # ",
"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*&=&-&;&>&,&'&)&!&~&*&!&{&]&^&/&(&_&~&:&<&[&}&'&[&|&",
"# # # # # # # # # # # # # # # # # # # # # # # 1&2&3&4&5&6&7&8&9&0&a&b&c&d&e&f&g&h&i&j&k&] l&m&n&",
"~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ /.~ o&p&q&r&s&t&u&v&w&x&y&z&A&B&C&D&E&F&G&H&I&J&K&L&M&",
"# # # # # # # # # # # # # # # # # # # # # # # N&O&P&Q&R&S&T&U&V&W&X&Y&Z&`& *.*+*@*#*$*%*&***=*-*",
"; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; [ /.o&;*>*,*} '*# )*!*~*{*]*^*/*(*# &## _*# :*<*[*}*# ",
"c+c+c+c+c+c+c+c+c+c+c+c+c+c+c+c+c+c+c+c+c+'*~ |*# u@/.# /.& K+# 1*# u%# c+# 2*# & 3*# '*#   # / ",
"# # # # # # # # # # # # # # # # # # # # # /.# 4*5*6*7*8*9*0*a*b*c*d*e*f*# g*h*i*j*k*l*# m*n*o*p*",
"# # # # # # # # # # # # # # # # # # # # # ~ # 2$x%q*# r*s*t*u*v*w*x*y*z*# A*B*C*D*E*F*# G*H*' I*",
"# # # # # # # # # # # # # # # # # # # # # ~ # J*K*L*M*N*O*P*Q*R*S*T*Y%U*# V*W*X*Y*Z*`*#  =.=+=@=",
"# # # # # # # # # # # # # # # # # # # # # ~ # o&#=$=# # # # # # # %=&=# # # # # # # # # # # # # ",
"# # # # # # # # # # # # # # # # # # # # # ~ # *===-=;=>=,='=)=!=~={=]=^=/=(=_=:=<=[=}=|=  /.1*/.",
"# # # # # # # # # # # # # # # # # # # # # ~ # 1=# 2=3=4=5=6=7=8=9=' 0=a=b=c=d=e=f=g=h=i=# # # # ",
"# # # # # # # # # # # # # # # # # # # # # ~ # j=k=l=m=n=o=p=q=r=s=t=u=v=w=x=y=z=A=B=H.C=# # # # ",
"# # # # # # # # # # # # # # # # # # # # # ~ # 2$D=E=F=G=# H=I=J=K=L=M=# N=# O=P=# # Q=# R=~ S=T=",
"# # # # # # # # # # # # # # # # # # # # # ~ # 2$U=V=W=X=Y=Z=`= -.-# +-@-#-$-%-&-*-=---;->-# ,-'-",
"# # # # # # # # # # # # # # # # # # # # # ~ # 2$)-!-~-{-]-^-# /-(-_-:-<-[-}-|-1-2-3-4-5-6-/.,-7-",
"# # # # # # # # # # # # # # # # # # # # # ~ # 2$# 8-9-0-a-b-~ c-d-e-f-g-h-i-j-k-l-m-n-o-p-# q-r-",
"# # # # # # # # # # # # # # # # # # # # # ~ # s-t-u-v-# # # # # # # # # w-x-y-' # z-A-B-C-D-E-F-",
"# # # # # # # # # # # # # # # # # # # # # ~ # 2$G-H-I-J-K-L-M-N-O-P-# # Q-R-S-# )*# T-U-V-W-X-# ",
"# # # # # # # # # # # # # # # # # # # # # ~ # 1=Y-Z-`- ;.;+;@;#;$;%;&;*;=;-;;;>;,;';);; !;~;{;];",
"# # # # # # # # # # # # # # # # # # # # # ~ # 1=# /*# ^;# /;(;_;:;<;[;};' 2*< ; |;1;2;/ ' # # 3;"};
