/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.addressing.AddressingHeaders;
import org.codehaus.xfire.addressing.AddressingHeadersFactory;
import org.codehaus.xfire.addressing.AddressingHeadersFactory200408;
import org.codehaus.xfire.addressing.AddressingHeadersFactory200508;
import org.codehaus.xfire.addressing.AddressingOperationInfo;
import org.codehaus.xfire.addressing.EndpointReference;
import org.codehaus.xfire.addressing.RandomGUID;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.dead.DeadLetterTransport;
import org.jdom.Attribute;
import org.jdom.Element;

public class AddressingInHandler
extends AbstractHandler {
    public static final Object ADRESSING_HEADERS = "xfire-ws-adressing-headers";
    public static final Object ADRESSING_FACTORY = "xfire-ws-adressing-factory";
    private List factories = new ArrayList();

    public AddressingInHandler() {
        this.setPhase("pre-dispatch");
        this.createFactories();
    }

    public void createFactories() {
        this.factories.add(new AddressingHeadersFactory200508());
        this.factories.add(new AddressingHeadersFactory200408());
    }

    public List getFactories() {
        return this.factories;
    }

    public void invoke(MessageContext context) throws Exception {
        Iterator itr = this.factories.iterator();
        while (itr.hasNext()) {
            AddressingHeadersFactory factory = (AddressingHeadersFactory)itr.next();
            InMessage msg = context.getInMessage();
            Element header = msg.getHeader();
            if (header == null || !factory.hasHeaders(header)) continue;
            AddressingHeaders headers = null;
            try {
                headers = factory.createHeaders(header);
                msg.setProperty(ADRESSING_HEADERS, headers);
                msg.setProperty(ADRESSING_FACTORY, factory);
                context.setId(headers.getRelatesTo());
                Service service = this.getService(headers, context);
                if (service != null) {
                    context.setService(service);
                } else {
                    service = context.getService();
                }
                OperationInfo op = context.getExchange().getOperation();
                AddressingOperationInfo aop = AddressingOperationInfo.getOperationByInAction(service.getServiceInfo(), headers.getAction());
                if (aop == null && (aop = AddressingOperationInfo.getOperationByOutAction(service.getServiceInfo(), headers.getAction())) != null) {
                    context.setId(headers.getRelatesTo());
                    return;
                }
                if (aop == null) {
                    throw new XFireFault("Action '" + headers.getAction() + "' was not found for service " + headers.getTo(), XFireFault.SENDER);
                }
                MessageExchange exchange = context.getExchange();
                exchange.setOperation(aop.getOperationInfo());
                EndpointReference faultTo = headers.getFaultTo();
                OutMessage faultMsg = null;
                faultMsg = faultTo != null ? this.processEPR(context, faultTo, aop, headers, factory) : this.createDefaultMessage(context, aop, headers, factory);
                exchange.setFaultMessage(faultMsg);
                EndpointReference replyTo = headers.getReplyTo();
                OutMessage outMessage = null;
                outMessage = replyTo != null ? this.processEPR(context, replyTo, aop, headers, factory) : this.createDefaultMessage(context, aop, headers, factory);
                exchange.setOutMessage(outMessage);
            }
            catch (XFireFault fault) {
                AbstractMessage faultMsg = context.getExchange().getFaultMessage();
                AddressingHeaders outHeaders = (AddressingHeaders)faultMsg.getProperty(ADRESSING_HEADERS);
                if (outHeaders == null) {
                    outHeaders = new AddressingHeaders();
                    if (headers != null) {
                        outHeaders.setRelatesTo(headers.getMessageID());
                    }
                    outHeaders.setAction("http://www.w3.org/2005/08/addressing/fault");
                    faultMsg.setProperty(ADRESSING_HEADERS, outHeaders);
                    faultMsg.setProperty(ADRESSING_FACTORY, factory);
                }
                throw fault;
            }
        }
    }

    private OutMessage createDefaultMessage(MessageContext context, AddressingOperationInfo aoi, AddressingHeaders inHeaders, AddressingHeadersFactory factory) {
        OutMessage outMessage = context.getOutMessage();
        AddressingHeaders headers = new AddressingHeaders();
        headers.setTo(factory.getAnonymousUri());
        headers.setRelatesTo(inHeaders.getMessageID());
        headers.setAction(aoi.getOutAction());
        outMessage.setProperty(ADRESSING_HEADERS, headers);
        outMessage.setProperty(ADRESSING_FACTORY, factory);
        return outMessage;
    }

    private boolean isNoneAddress(AddressingHeadersFactory factory, String addr) {
        return factory.getNoneUri() != null && factory.getNoneUri().equals(addr);
    }

    protected OutMessage processEPR(MessageContext context, EndpointReference epr, AddressingOperationInfo aoi, AddressingHeaders inHeaders, AddressingHeadersFactory factory) throws XFireFault, Exception {
        String addr = epr.getAddress();
        OutMessage outMessage = null;
        boolean isFault = epr.getName().equals("FaultTo");
        Transport t = null;
        Channel c = null;
        if (addr == null) {
            throw new XFireFault("Invalid ReplyTo address.", XFireFault.SENDER);
        }
        if (addr.equals(factory.getAnonymousUri())) {
            outMessage = new OutMessage("urn:xfire:channel:backchannel");
            c = context.getInMessage().getChannel();
            t = c.getTransport();
        } else if (this.isNoneAddress(factory, addr)) {
            t = new DeadLetterTransport();
            outMessage = new OutMessage(addr);
            c = t.createChannel();
        } else {
            outMessage = new OutMessage(addr);
            t = context.getXFire().getTransportManager().getTransportForUri(addr);
            c = t.createChannel();
        }
        outMessage.setChannel(c);
        outMessage.setSoapVersion(context.getExchange().getInMessage().getSoapVersion());
        if (t == null) {
            throw new XFireFault("URL was not recognized: " + addr, XFireFault.SENDER);
        }
        AddressingHeaders headers = new AddressingHeaders();
        if (!isFault) {
            headers.setTo(addr);
            headers.setAction(aoi.getOutAction());
        } else {
            headers.setAction("http://www.w3.org/2005/08/addressing/fault");
        }
        headers.setMessageID("urn:uuid:" + new RandomGUID(false).toString());
        headers.setRelatesTo(inHeaders.getMessageID());
        Element refParam = epr.getReferenceParametersElement();
        if (refParam != null) {
            List refs = refParam.cloneContent();
            ArrayList<Element> params = new ArrayList<Element>();
            for (int i = 0; i < refs.size(); ++i) {
                if (!(refs.get(i) instanceof Element)) continue;
                Element e = (Element)refs.get(i);
                e.setAttribute(new Attribute("isReferenceParameter", "true", epr.getNamespace()));
                params.add(e);
            }
            headers.setReferenceParameters(params);
        }
        outMessage.setProperty(ADRESSING_HEADERS, headers);
        outMessage.setProperty(ADRESSING_FACTORY, factory);
        return outMessage;
    }

    protected Service getService(AddressingHeaders headers, MessageContext context) {
        String serviceName = null;
        if (headers.getTo() != null) {
            int i = headers.getTo().lastIndexOf(47);
            serviceName = headers.getTo().substring(i + 1);
        }
        if (serviceName == null) {
            return null;
        }
        return context.getXFire().getServiceRegistry().getService(serviceName);
    }
}

