/*
 * Copyright 2005-2019 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * In applying this licence, ECMWF does not waive the privileges and immunities granted to it by
 * virtue of its status as an intergovernmental organisation nor does it submit to any jurisdiction.
 */

#include "grib_api.h"

/*
 * Test that second order packing sets the correct numberOfValues
 * philippe.marguinaud@meteo.fr, 2016/02
 */

static double values[] = {
        0.101300032966540894E+06,       0.101300537463512766E+06,       0.101300575340236785E+06,       0.101300006392703450E+06,       0.101298681683129777E+06,
        0.101296357626198034E+06,       0.101291429037962458E+06,       0.101285211396584113E+06,       0.101277811769244916E+06,       0.101269604202318660E+06,
        0.101261086325391967E+06,       0.101252536774223816E+06,       0.101244258202072262E+06,       0.101236292863086681E+06,       0.101228818038673067E+06,
        0.101222576320632390E+06,       0.101217951101617422E+06,       0.101215281498123208E+06,       0.101214831830208335E+06,       0.101216756641191008E+06,
        0.101220329473252321E+06,       0.101229814720005656E+06,       0.101242852565120862E+06,       0.101257243179816374E+06,       0.101272242223526715E+06,
        0.101287023899284890E+06,       0.101300727324330161E+06,       0.101312508880994021E+06,       0.101321304787958841E+06,       0.101323045492054458E+06,
        0.101323689235454440E+06,       0.101322654817980932E+06,       0.101318546143449697E+06,       0.101311446435368038E+06,       0.101301582670344171E+06,
        0.101289313645048256E+06,       0.101272976739770951E+06,       0.101254670123119533E+06,       0.101236204711241953E+06,       0.101218525147353255E+06,
        0.101203644914472199E+06,       0.101191859002529978E+06,       0.101183427645969176E+06,       0.101178788732659857E+06,       0.101176248776911350E+06,
        0.101174781987763519E+06,       0.101173755414963452E+06,       0.101172549028196707E+06,       0.101170596810517556E+06,       0.101164899003713479E+06,
        0.101158419589045283E+06,       0.101152491572940358E+06,       0.101147843517789603E+06,       0.101145017464391334E+06,       0.101144350744426047E+06,
        0.101145965622140546E+06,       0.101150160852645960E+06,       0.101156489280060341E+06,       0.101164999288937499E+06,       0.101174680757722846E+06,
        0.101184614700939375E+06,       0.101194476866903220E+06,       0.101203847071805940E+06,       0.101212793693367261E+06,       0.101221210811864396E+06,
        0.101228967667653473E+06,       0.101235941297612240E+06,       0.101241825830798407E+06,       0.101246384813952725E+06,       0.101250233289149895E+06,
        0.101253625288606709E+06,       0.101256829767974210E+06,       0.101260135466684485E+06,       0.101263922730170481E+06,       0.101268258457290780E+06,
        0.101273173871677092E+06,       0.101278603318462468E+06,       0.101284438572224244E+06,       0.101291451901038017E+06,       0.101298825789695678E+06,
        0.101305583597361008E+06,       0.101311198590170257E+06,       0.101313106869633571E+06,       0.101311964918650119E+06,       0.101309609217350633E+06,
        0.101306588009722152E+06,       0.101303789827421686E+06,       0.101303204229508177E+06,       0.101302539808644782E+06,       0.101301748136565366E+06,
        0.101300889588588965E+06,       0.101301524026314495E+06,       0.101302253276609670E+06,       0.101302463210049027E+06,       0.101302292202795681E+06,
        0.101298302559037387E+06,       0.101291449427361382E+06,       0.101283550209983820E+06,       0.101275343284659903E+06,       0.101268451030137920E+06,
        0.101263440167506284E+06,       0.101259681043976845E+06,       0.101257275584439689E+06,       0.101255817294926324E+06,       0.101255329151085723E+06,
        0.101256832423130865E+06,       0.101260699063277454E+06,       0.101270225601657599E+06,       0.101287312191364559E+06,       0.101303455630186116E+06,
        0.101316029699689170E+06,       0.101320758891846766E+06,       0.101311100182774215E+06,       0.101294901290088586E+06,       0.101273081896347416E+06,
        0.101246397937256072E+06,       0.101214175532589943E+06,       0.101180475299171711E+06,       0.101147446887522659E+06,       0.101117364487217361E+06,
        0.101093085915674965E+06,       0.101075700452174933E+06,       0.101066299886712630E+06,       0.101066158368806296E+06,       0.101078251612071312E+06,
        0.101107333429588485E+06,       0.101145577197960345E+06,       0.101190184433163799E+06,       0.101238249723994639E+06,       0.101280682092796589E+06,
        0.101316576899162261E+06,       0.101349617253023622E+06,       0.101379226791601075E+06,       0.101404833281466810E+06,       0.101426608723689307E+06,
        0.101443265324151027E+06,       0.101453984963411596E+06,       0.101458728599400347E+06,       0.101457810163301183E+06,       0.101452773264225369E+06,
        0.101443352159658025E+06,       0.101428700824100233E+06,       0.101409534671443689E+06,       0.101387066094169772E+06,       0.101362901532581192E+06,
        0.101342428907368536E+06,       0.101323657976273273E+06,       0.101307125752964450E+06,       0.101293183514770688E+06,       0.101280868902945120E+06,
        0.101268909632403243E+06,       0.101254864133468844E+06,       0.101241751785266810E+06,       0.101229873732095890E+06,       0.101219507414652238E+06,
        0.101210854622372586E+06,       0.101203998200015136E+06,       0.101202118817604176E+06,       0.101204115282818020E+06,       0.101207394659720041E+06,
        0.101211469101194845E+06,       0.101215801913933246E+06,       0.101219837912576768E+06,       0.101222821880958276E+06,       0.101223619521153145E+06,
        0.101223119359168049E+06,       0.101279933976388784E+06,       0.101280230886902951E+06,       0.101280173829517254E+06,       0.101279628905657766E+06,
        0.101278452724477320E+06,       0.101276500130166445E+06,       0.101273279706602567E+06,       0.101267225127293903E+06,       0.101259879400551043E+06,
        0.101251952874409501E+06,       0.101243674039727790E+06,       0.101235303075196876E+06,       0.101227122345847776E+06,       0.101219423613287974E+06,
        0.101212178882549546E+06,       0.101205696806113177E+06,       0.101200710454399567E+06,       0.101197550054666615E+06,       0.101196424920055710E+06,
        0.101196682426928426E+06,       0.101199196544638864E+06,       0.101204111882830854E+06,       0.101214864879095490E+06,       0.101228568680570461E+06,
        0.101243289081509487E+06,       0.101258220436669624E+06,       0.101272521063369320E+06,       0.101285366950491778E+06,       0.101296012419061328E+06,
        0.101305658540617282E+06,       0.101309682063797125E+06,       0.101310624244857565E+06,       0.101308433795484656E+06,       0.101303210985482059E+06,
        0.101295198335334237E+06,       0.101284767756201632E+06,       0.101272403737592205E+06,       0.101256113788140079E+06,       0.101238847669926457E+06,
        0.101222589159180454E+06,       0.101208629956686913E+06,       0.101197517909479167E+06,       0.101189497449897433E+06,       0.101184456694785782E+06,
        0.101181649500138068E+06,       0.101179750491125887E+06,       0.101178046404878522E+06,       0.101175885037415414E+06,       0.101168022154143066E+06,
        0.101159966065713801E+06,       0.101152331174549618E+06,       0.101145627588820978E+06,       0.101140536375719617E+06,       0.101137554875074289E+06,
        0.101136964384819003E+06,       0.101138821605761070E+06,       0.101143054186604160E+06,       0.101151654753774303E+06,       0.101161075130481171E+06,
        0.101170963288776737E+06,       0.101180942106852366E+06,       0.101190660642090996E+06,       0.101199851697929174E+06,       0.101208579711314771E+06,
        0.101216763897321827E+06,       0.101224252677880388E+06,       0.101230718188980885E+06,       0.101236243573164116E+06,       0.101240451206177866E+06,
        0.101243892699987075E+06,       0.101246988344102370E+06,       0.101250044906442185E+06,       0.101253348298035868E+06,       0.101257374370298217E+06,
        0.101262251561231329E+06,       0.101267895803787687E+06,       0.101275473367753089E+06,       0.101283709026768585E+06,       0.101292283625024313E+06,
        0.101300598737905675E+06,       0.101308093199018083E+06,       0.101314220495369867E+06,       0.101317565250665139E+06,       0.101316383038650820E+06,
        0.101313738332474823E+06,       0.101310203262582130E+06,       0.101306334680532935E+06,       0.101304140173899126E+06,       0.101302185066315011E+06,
        0.101301166929963205E+06,       0.101300627409982437E+06,       0.101301442301666364E+06,       0.101302674870566902E+06,       0.101303021785214194E+06,
        0.101301874610097177E+06,       0.101297234163742920E+06,       0.101289212662159043E+06,       0.101280201810217695E+06,       0.101271153345172788E+06,
        0.101264093160240271E+06,       0.101259964551924568E+06,       0.101257527008254954E+06,       0.101256779297676592E+06,       0.101257083402693010E+06,
        0.101258345876766994E+06,       0.101261741195912517E+06,       0.101267637196925745E+06,       0.101280255542587736E+06,       0.101300219472217796E+06,
        0.101318811431023903E+06,       0.101333064281329105E+06,       0.101337822826176372E+06,       0.101329633927901843E+06,       0.101313842956693508E+06,
        0.101291773913463257E+06,       0.101264248822328038E+06,       0.101231681402834831E+06,       0.101198711256044262E+06,       0.101165944729817566E+06,
        0.101135663129340406E+06,       0.101112149821393570E+06,       0.101094336258872077E+06,       0.101083754934829689E+06,       0.101081962838100400E+06,
        0.101094161177945804E+06,       0.101119463798994111E+06,       0.101153379508463855E+06,       0.101193466772876971E+06,       0.101236864297787688E+06,
        0.101271319749684611E+06,       0.101304810719710440E+06,       0.101336529049048593E+06,       0.101365547226062699E+06,       0.101391403447243065E+06,
        0.101414233987549960E+06,       0.101431699751902197E+06,       0.101443249701215464E+06,       0.101448694379159249E+06,       0.101448342945639379E+06,
        0.101444949497289897E+06,       0.101434983683722516E+06,       0.101420339588228075E+06,       0.101400782009497547E+06,       0.101377357223598548E+06,
        0.101353445824612878E+06,       0.101331105881366500E+06,       0.101310391048972291E+06,       0.101292023316921361E+06,       0.101276408630823629E+06,
        0.101263594338449708E+06,       0.101249134886344415E+06,       0.101234892154251414E+06,       0.101221982151018121E+06,       0.101210641209280395E+06,
        0.101201103409364907E+06,       0.101193542381486463E+06,       0.101189530184913005E+06,       0.101188943141927884E+06,       0.101190369535781749E+06,
        0.101194174658495293E+06,       0.101198877046582638E+06,       0.101203781726436631E+06,       0.101208345081553751E+06,       0.101210641923420510E+06,
        0.101211907924376195E+06,       0.101211894158448660E+06,       0.101261542396602526E+06,       0.101261524602459496E+06,       0.101261271962264684E+06,
        0.101260655467705859E+06,       0.101259535677996173E+06,       0.101257770460092695E+06,       0.101254858567248273E+06,       0.101250130827152869E+06,
        0.101243199529206220E+06,       0.101235660710148513E+06,       0.101227727082598372E+06,       0.101219642017676335E+06,       0.101211669747645647E+06,
        0.101204082204654842E+06,       0.101197142166519814E+06,       0.101190828836761386E+06,       0.101185622952613427E+06,       0.101182084994122983E+06,
        0.101179819644487143E+06,       0.101179386785722192E+06,       0.101181037231546885E+06,       0.101184921544816825E+06,       0.101191071708805684E+06,
        0.101202963344456002E+06,       0.101217214661309525E+06,       0.101232127096539611E+06,       0.101246868435665092E+06,       0.101260623299959872E+06,
        0.101275012912500446E+06,       0.101287927630361359E+06,       0.101297156607966986E+06,       0.101300022279744313E+06,       0.101299658882873831E+06,
        0.101296185125092088E+06,       0.101289860769760111E+06,       0.101281072853932870E+06,       0.101270317685887567E+06,       0.101257849866728764E+06,
        0.101241620969336713E+06,       0.101226620289076629E+06,       0.101213719159152053E+06,       0.101203448100139896E+06,       0.101196030165699893E+06,
        0.101191332050565718E+06,       0.101188825460235021E+06,       0.101186627930786824E+06,       0.101183177496864155E+06,       0.101175055095382006E+06,
        0.101166325451567565E+06,       0.101157506572639366E+06,       0.101149141784503256E+06,       0.101141882059824522E+06,       0.101136611424843984E+06,
        0.101133780517071078E+06,       0.101133612778250375E+06,       0.101137015702474586E+06,       0.101144048000326933E+06,       0.101152946100252506E+06,
        0.101162592544671337E+06,       0.101172594122147348E+06,       0.101182525914593833E+06,       0.101192006688188281E+06,       0.101200731545306888E+06,
        0.101208949653701755E+06,       0.101216776035106115E+06,       0.101223643986761963E+06,       0.101229495275078225E+06,       0.101234397106283810E+06,
        0.101238325186287970E+06,       0.101241245958931366E+06,       0.101243986310471693E+06,       0.101246885079730608E+06,       0.101250239965938381E+06,
        0.101254497783043873E+06,       0.101260948534770170E+06,       0.101268693386766550E+06,       0.101277410860750868E+06,       0.101286673004684562E+06,
        0.101296037156777587E+06,       0.101304973100759889E+06,       0.101312836471203336E+06,       0.101319077100166265E+06,       0.101323200714451756E+06,
        0.101322250124293394E+06,       0.101319426400325508E+06,       0.101315327879672026E+06,       0.101311379409400208E+06,       0.101308929715621984E+06,
        0.101307576201749136E+06,       0.101306752066909641E+06,       0.101306276681202202E+06,       0.101306450951061837E+06,       0.101306928825287003E+06,
        0.101306304370611891E+06,       0.101304071949983219E+06,       0.101298726444911401E+06,       0.101289556844688181E+06,       0.101279573549734007E+06,
        0.101269900918276995E+06,       0.101262737639210711E+06,       0.101259533404357528E+06,       0.101258456904325285E+06,       0.101259373853730853E+06,
        0.101261455254273096E+06,       0.101264486663057716E+06,       0.101269671494430630E+06,       0.101277337091813301E+06,       0.101292476984397377E+06,
        0.101314252890570002E+06,       0.101334243526143560E+06,       0.101349257112687643E+06,       0.101353348220742904E+06,       0.101345316081726181E+06,
        0.101329205683580891E+06,       0.101306196398575121E+06,       0.101276157501052992E+06,       0.101241050683782683E+06,       0.101205878990180805E+06,
        0.101173117425566874E+06,       0.101145231775263543E+06,       0.101124829234029152E+06,       0.101110142836540865E+06,       0.101099009983212847E+06,
        0.101095931793603289E+06,       0.101107937055714152E+06,       0.101129557639286853E+06,       0.101159016947845914E+06,       0.101194290171214365E+06,
        0.101229194191076458E+06,       0.101259884907642350E+06,       0.101290909335772027E+06,       0.101321534960278805E+06,       0.101350933609778935E+06,
        0.101378619763291339E+06,       0.101402515553940961E+06,       0.101421126437325220E+06,       0.101433759893184542E+06,       0.101440081432142906E+06,
        0.101442774222367792E+06,       0.101440175371796868E+06,       0.101430382938397539E+06,       0.101414195446914280E+06,       0.101393183882853962E+06,
        0.101368556280786899E+06,       0.101342857987377705E+06,       0.101318002031737051E+06,       0.101294900480304379E+06,       0.101274304523903862E+06,
        0.101256697091383176E+06,       0.101240541623616038E+06,       0.101225909818463362E+06,       0.101213299349493405E+06,       0.101200928172660904E+06,
        0.101190501742025459E+06,       0.101182213405811461E+06,       0.101176901403817319E+06,       0.101175245583661221E+06,       0.101175762446152599E+06,
        0.101178005333581008E+06,       0.101181392651505157E+06,       0.101186087494527630E+06,       0.101191405412103719E+06,       0.101195091837111089E+06,
        0.101197730891759726E+06,       0.101199364382066880E+06,       0.101199730209935369E+06,       0.101245004040932326E+06,       0.101244559135352756E+06,
        0.101244006361693333E+06,       0.101243220164091719E+06,       0.101242063426875131E+06,       0.101239785127296316E+06,       0.101236357261140554E+06,
        0.101232655165141550E+06,       0.101227802625625860E+06,       0.101220780822386791E+06,       0.101213322053334618E+06,       0.101205654745465290E+06,
        0.101198027406206093E+06,       0.101190695138277268E+06,       0.101183902374283105E+06,       0.101177861446733092E+06,       0.101172715839318174E+06,
        0.101168727915036332E+06,       0.101166083677619172E+06,       0.101165120300427254E+06,       0.101166097664782996E+06,       0.101169176642534818E+06,
        0.101174400762938254E+06,       0.101181681695578300E+06,       0.101194628149370954E+06,       0.101209354172510837E+06,       0.101224384543212596E+06,
        0.101241003377192639E+06,       0.101256971279536912E+06,       0.101271325762838256E+06,       0.101283302907598583E+06,       0.101290837888259193E+06,
        0.101292188600320253E+06,       0.101290316399723524E+06,       0.101285500501916889E+06,       0.101278145707370568E+06,       0.101268063741988299E+06,
        0.101255992666718317E+06,       0.101243630289196284E+06,       0.101230020660095543E+06,       0.101218300352418431E+06,       0.101208996070145775E+06,
        0.101202318103285957E+06,       0.101198115125068754E+06,       0.101195865072430563E+06,       0.101192485973754709E+06,       0.101184883550562605E+06,
        0.101176252043943983E+06,       0.101167064140836461E+06,       0.101157837055866650E+06,       0.101149111932572778E+06,       0.101141425669095363E+06,
        0.101136096494374695E+06,       0.101133772515929886E+06,       0.101136278536261714E+06,       0.101141790910123251E+06,       0.101149565058361550E+06,
        0.101159158826086161E+06,       0.101169280924233710E+06,       0.101179364339541717E+06,       0.101189214375348573E+06,       0.101198419330631325E+06,
        0.101206662421100802E+06,       0.101214110977152406E+06,       0.101221277683224456E+06,       0.101227361193735371E+06,       0.101232391962857888E+06,
        0.101236456240121115E+06,       0.101239696448804534E+06,       0.101242131415364871E+06,       0.101244485321801025E+06,       0.101247206329288369E+06,
        0.101250813340918423E+06,       0.101256254483921584E+06,       0.101263638654577793E+06,       0.101272420586206106E+06,       0.101282081390786785E+06,
        0.101292093147014763E+06,       0.101301886889219619E+06,       0.101311011635127215E+06,       0.101318745388787589E+06,       0.101324552511834278E+06,
        0.101327137099599713E+06,       0.101325798652594996E+06,       0.101322370281172494E+06,       0.101318873214067411E+06,       0.101316033453167009E+06,
        0.101314254241750285E+06,       0.101313290040590538E+06,       0.101312777489808956E+06,       0.101312426972162124E+06,       0.101312077043907979E+06,
        0.101311637613854371E+06,       0.101309930679532728E+06,       0.101306604219150962E+06,       0.101300708574919438E+06,       0.101290667766194849E+06,
        0.101280103453056901E+06,       0.101270238174615952E+06,       0.101263265305097812E+06,       0.101261210282368877E+06,       0.101261635280168994E+06,
        0.101264259503469541E+06,       0.101268188459234763E+06,       0.101273120782915241E+06,       0.101280081032422138E+06,       0.101289326234345950E+06,
        0.101306137507821695E+06,       0.101328331726916280E+06,       0.101348454606262691E+06,       0.101363243724620203E+06,       0.101365228148856142E+06,
        0.101355701191101674E+06,       0.101338137535693226E+06,       0.101313442343172661E+06,       0.101279893686959578E+06,       0.101241766771608411E+06,
        0.101204166019317592E+06,       0.101170013105795253E+06,       0.101142432350644231E+06,       0.101122231791865343E+06,       0.101108816561727523E+06,
        0.101102229721379510E+06,       0.101103813368451665E+06,       0.101116580337189007E+06,       0.101134920647456835E+06,       0.101160141230191730E+06,
        0.101190695983823272E+06,       0.101217581338673946E+06,       0.101244990949544663E+06,       0.101273917316553634E+06,       0.101303572896501239E+06,
        0.101333544453130846E+06,       0.101364877370781323E+06,       0.101391063816659895E+06,       0.101411237101045277E+06,       0.101425278782258334E+06,
        0.101433519934200929E+06,       0.101439158935259431E+06,       0.101436999045160905E+06,       0.101426916105024720E+06,       0.101409617969188068E+06,
        0.101386542831537823E+06,       0.101358099179373283E+06,       0.101329104321193983E+06,       0.101301390131810738E+06,       0.101275584184176812E+06,
        0.101252450915750233E+06,       0.101231887457535791E+06,       0.101212090768716560E+06,       0.101196447068532798E+06,       0.101185068443023629E+06,
        0.101177384135667060E+06,       0.101168309967723544E+06,       0.101161992541140848E+06,       0.101159852630578913E+06,       0.101159796489626082E+06,
        0.101161597602608847E+06,       0.101164838510229980E+06,       0.101168957886595192E+06,       0.101173308450019656E+06,       0.101177043737997461E+06,
        0.101180725542300570E+06,       0.101183638211952741E+06,       0.101185541375514644E+06,       0.101186177771331219E+06,       0.101231389269493171E+06,
        0.101229452023944614E+06,       0.101228492450459045E+06,       0.101227437857730562E+06,       0.101225272919369032E+06,       0.101222115782736248E+06,
        0.101218895852368762E+06,       0.101215584732123752E+06,       0.101212116636056322E+06,       0.101207354097621472E+06,       0.101200521838921966E+06,
        0.101193426713001274E+06,       0.101186304142571476E+06,       0.101179395677309934E+06,       0.101172931379861388E+06,       0.101167151828382484E+06,
        0.101162308500518877E+06,       0.101158300144806009E+06,       0.101155408258388663E+06,       0.101154070184498851E+06,       0.101154559752015484E+06,
        0.101157052466433044E+06,       0.101161607131965604E+06,       0.101168151354609319E+06,       0.101176471448160533E+06,       0.101190446255643255E+06,
        0.101207546249739040E+06,       0.101224869025537133E+06,       0.101241629266362957E+06,       0.101257034534386199E+06,       0.101270300423290071E+06,
        0.101280701804350014E+06,       0.101286032850469506E+06,       0.101285592385854572E+06,       0.101282085195034277E+06,       0.101274697798302746E+06,
        0.101264580591891121E+06,       0.101253728075986262E+06,       0.101242929317346643E+06,       0.101232485866013521E+06,       0.101222025672053554E+06,
        0.101213765521939480E+06,       0.101207908438247250E+06,       0.101204284122239580E+06,       0.101199927839590950E+06,       0.101194734819518329E+06,
        0.101188456889903726E+06,       0.101179666542616309E+06,       0.101170394407501270E+06,       0.101161163472120141E+06,       0.101152520749703152E+06,
        0.101145006252468942E+06,       0.101139495861547286E+06,       0.101140801932908304E+06,       0.101144658005535239E+06,       0.101150950782672968E+06,
        0.101159402010231061E+06,       0.101169516352869221E+06,       0.101180618870833394E+06,       0.101190857796199096E+06,       0.101200641550543587E+06,
        0.101209362327359180E+06,       0.101217130139796180E+06,       0.101224049008589936E+06,       0.101230122753387783E+06,       0.101235212462695199E+06,
        0.101239229954162147E+06,       0.101242277095199534E+06,       0.101244507835626879E+06,       0.101246153185945266E+06,       0.101247135672995661E+06,
        0.101249606832741643E+06,       0.101254017340448758E+06,       0.101260512682501125E+06,       0.101268912159280037E+06,       0.101278581961162170E+06,
        0.101288935630890279E+06,       0.101299344634514127E+06,       0.101309165575948311E+06,       0.101317556887074039E+06,       0.101323172703937016E+06,
        0.101326358447397986E+06,       0.101327232302474091E+06,       0.101325894572504010E+06,       0.101322706535794525E+06,       0.101319932108380584E+06,
        0.101318115839731938E+06,       0.101317374329348502E+06,       0.101316802412196412E+06,       0.101316539167573457E+06,       0.101316220872659469E+06,
        0.101315472541661889E+06,       0.101313988991298058E+06,       0.101311143303248988E+06,       0.101306823565026949E+06,       0.101300909517459571E+06,
        0.101291139156745485E+06,       0.101281432901143096E+06,       0.101272931024738762E+06,       0.101267480423988032E+06,       0.101267406598649904E+06,
        0.101269963384954986E+06,       0.101274800002130170E+06,       0.101281233237463195E+06,       0.101288842618392577E+06,       0.101297886975346977E+06,
        0.101308296387334616E+06,       0.101325624485844790E+06,       0.101346166178142783E+06,       0.101363441252856501E+06,       0.101374801583022883E+06,
        0.101371478339382054E+06,       0.101357965915636902E+06,       0.101337616663800756E+06,       0.101310513973449386E+06,       0.101272307541573202E+06,
        0.101230865550039016E+06,       0.101190791911869368E+06,       0.101155350687670492E+06,       0.101129224427448615E+06,       0.101110583343861392E+06,
        0.101099020700267734E+06,       0.101094724119735372E+06,       0.101099023269690821E+06,       0.101111662707600757E+06,       0.101130628382792580E+06,
        0.101154442701152686E+06,       0.101179514522985817E+06,       0.101201379997560478E+06,       0.101226265787734679E+06,       0.101253796882664625E+06,
        0.101283225572595169E+06,       0.101317124967778669E+06,       0.101350989077608407E+06,       0.101379921717535108E+06,       0.101402381642000008E+06,
        0.101417742462739217E+06,       0.101429901727416946E+06,       0.101436203470310473E+06,       0.101434079341425662E+06,       0.101423164600191842E+06,
        0.101404037685293821E+06,       0.101376818918793375E+06,       0.101344589194113520E+06,       0.101311531147971255E+06,       0.101279820675164505E+06,
        0.101251153362574143E+06,       0.101225285333396270E+06,       0.101199764562447148E+06,       0.101178262360150809E+06,       0.101161772194779478E+06,
        0.101150434481179953E+06,       0.101143909494338062E+06,       0.101141390141577620E+06,       0.101140639767941699E+06,       0.101140632648710569E+06,
        0.101142372620975060E+06,       0.101145663398052158E+06,       0.101150107990777600E+06,       0.101155154940690569E+06,       0.101159369531278891E+06,
        0.101162295247948568E+06,       0.101164893804552295E+06,       0.101168002876310085E+06,       0.101170082535517562E+06,       0.101170879828210964E+06,
        0.101219861459639709E+06,       0.101217353733850920E+06,       0.101214813662341927E+06,       0.101212272616671195E+06,       0.101208980334428372E+06,
        0.101205795685889956E+06,       0.101202734659769427E+06,       0.101199769990954403E+06,       0.101196834984741159E+06,       0.101193828164992272E+06,
        0.101189376363543503E+06,       0.101183028116295318E+06,       0.101176590659241221E+06,       0.101170295511546516E+06,       0.101164459781001147E+06,
        0.101159272837843542E+06,       0.101154626508349247E+06,       0.101150830978481536E+06,       0.101147940393322046E+06,       0.101146374185143752E+06,
        0.101146551350105059E+06,       0.101148666345078062E+06,       0.101152796928674230E+06,       0.101158889620899077E+06,       0.101166802022490039E+06,
        0.101178035305259487E+06,       0.101194860122035752E+06,       0.101212325551695918E+06,       0.101229507831180323E+06,       0.101245588075390231E+06,
        0.101259749204794090E+06,       0.101271227064842373E+06,       0.101279354568716226E+06,       0.101282023041620065E+06,       0.101277735417878983E+06,
        0.101270065940430606E+06,       0.101260942221718724E+06,       0.101251183302667749E+06,       0.101241580790420048E+06,       0.101232817663754860E+06,
        0.101224865544509375E+06,       0.101217678236240463E+06,       0.101212672610467605E+06,       0.101207368061914924E+06,       0.101202142949429748E+06,
        0.101197200360827206E+06,       0.101192321056135959E+06,       0.101185312042045203E+06,       0.101176366919002583E+06,       0.101167575306740793E+06,
        0.101159499887747690E+06,       0.101153693581619635E+06,       0.101151632492099627E+06,       0.101152648343697670E+06,       0.101157198969257923E+06,
        0.101164178808173063E+06,       0.101173247856793882E+06,       0.101183857272265639E+06,       0.101195294072408884E+06,       0.101206439742155373E+06,
        0.101215821840872028E+06,       0.101224223508709707E+06,       0.101231582323487324E+06,       0.101237823030360581E+06,       0.101242874318770337E+06,
        0.101246774089702827E+06,       0.101249620201836733E+06,       0.101251514633922707E+06,       0.101250998739460556E+06,       0.101250350564701104E+06,
        0.101251192192736547E+06,       0.101254126969565099E+06,       0.101259362363834385E+06,       0.101266888172729494E+06,       0.101276372037240624E+06,
        0.101286838617996444E+06,       0.101297573246049607E+06,       0.101307533698699568E+06,       0.101315884770704040E+06,       0.101322262940598855E+06,
        0.101325965760392661E+06,       0.101327074410681467E+06,       0.101325913256045969E+06,       0.101323124870245505E+06,       0.101319702236701676E+06,
        0.101317199019545646E+06,       0.101315951598744505E+06,       0.101315806747022463E+06,       0.101315575437492836E+06,       0.101314907982108765E+06,
        0.101313877512845647E+06,       0.101312479697057366E+06,       0.101309803618787570E+06,       0.101306072028328548E+06,       0.101301517809186698E+06,
        0.101296222398532715E+06,       0.101287978736962512E+06,       0.101280134483104775E+06,       0.101273858730883643E+06,       0.101270559684999607E+06,
        0.101272646114663905E+06,       0.101277445816036910E+06,       0.101284587711525965E+06,       0.101293877343276210E+06,       0.101304839668757166E+06,
        0.101316528257227954E+06,       0.101328366576771165E+06,       0.101345969486117698E+06,       0.101364186088572969E+06,       0.101377148495963469E+06,
        0.101382093829553254E+06,       0.101370766337072331E+06,       0.101349741353763951E+06,       0.101321811510905638E+06,       0.101288468123698593E+06,
        0.101244965303345511E+06,       0.101202004776977919E+06,       0.101162860285996649E+06,       0.101126851606302604E+06,       0.101104372225545885E+06,
        0.101088557676466924E+06,       0.101079807482518576E+06,       0.101078498448923550E+06,       0.101085445131155400E+06,       0.101098827324377111E+06,
        0.101117379276230466E+06,       0.101139770652544976E+06,       0.101160113557297649E+06,       0.101180387504904938E+06,       0.101203886596317709E+06,
        0.101230902181368132E+06,       0.101261803558958476E+06,       0.101300608660476937E+06,       0.101337274184836075E+06,       0.101369125977644289E+06,
        0.101394267041929546E+06,       0.101413158265606093E+06,       0.101427330114929093E+06,       0.101432361057773902E+06,       0.101429910859225725E+06,
        0.101417624134461643E+06,       0.101395314188587567E+06,       0.101362172145086661E+06,       0.101325960646168634E+06,       0.101289070977803320E+06,
        0.101253544677021608E+06,       0.101220938962399465E+06,       0.101189935258524172E+06,       0.101161696612905507E+06,       0.101138721820111517E+06,
        0.101121644349305658E+06,       0.101110649141410599E+06,       0.101105415636551304E+06,       0.101106709372907222E+06,       0.101112684473039320E+06,
        0.101118393699309789E+06,       0.101122164751330070E+06,       0.101127188453840165E+06,       0.101133080620089138E+06,       0.101138746974859983E+06,
        0.101142873479913527E+06,       0.101146389620966002E+06,       0.101149025184660437E+06,       0.101150587859464547E+06,       0.101152755345234560E+06,
        0.101153603260132426E+06,       0.101210525717246186E+06,       0.101207548474999538E+06,       0.101202904596832290E+06,       0.101197951386655157E+06,
        0.101194386519771622E+06,       0.101191122015514105E+06,       0.101188175657561296E+06,       0.101185519945178385E+06,       0.101183085746111174E+06,
        0.101180766773284515E+06,       0.101178424993241424E+06,       0.101174517040993989E+06,       0.101168962341147722E+06,       0.101163714253363345E+06,
        0.101158948557658077E+06,       0.101154261182255184E+06,       0.101149950932639709E+06,       0.101146327181315632E+06,       0.101143687040794233E+06,
        0.101142126337276364E+06,       0.101142152044085655E+06,       0.101144083527112423E+06,       0.101148021171421016E+06,       0.101154000779215450E+06,
        0.101162760282120405E+06,       0.101173711396198050E+06,       0.101186611484798021E+06,       0.101203854792520258E+06,       0.101221108630801245E+06,
        0.101237514909808757E+06,       0.101252212005649548E+06,       0.101264385838287199E+06,       0.101273313773670612E+06,       0.101275991122254636E+06,
        0.101272633847169331E+06,       0.101265839223746094E+06,       0.101257619395513131E+06,       0.101248828329997094E+06,       0.101240269262524962E+06,
        0.101232609922544550E+06,       0.101226305719316471E+06,       0.101221001261636731E+06,       0.101215325578545016E+06,       0.101210148330884782E+06,
        0.101205386910296002E+06,       0.101200913609812837E+06,       0.101196557499459639E+06,       0.101192094621711993E+06,       0.101184939627293686E+06,
        0.101177056092112194E+06,       0.101171384998373789E+06,       0.101168077457142164E+06,       0.101167062491365999E+06,       0.101168742847490139E+06,
        0.101173481015017140E+06,       0.101181062252591364E+06,       0.101190688726292763E+06,       0.101201754487460537E+06,       0.101213053590803727E+06,
        0.101224458950927612E+06,       0.101234613260145692E+06,       0.101242743726390036E+06,       0.101249595831817132E+06,       0.101255046289272010E+06,
        0.101258984767052723E+06,       0.101261363785577109E+06,       0.101261779254400128E+06,       0.101259695740838331E+06,       0.101257723355522670E+06,
        0.101256712782620496E+06,       0.101257390131988577E+06,       0.101260812728128207E+06,       0.101266865110914150E+06,       0.101275356425384583E+06,
        0.101285757165198593E+06,       0.101297005109519319E+06,       0.101307222441895385E+06,       0.101316130802742104E+06,       0.101323131432448601E+06,
        0.101327755554835458E+06,       0.101329091060690815E+06,       0.101327426676222676E+06,       0.101323405755774875E+06,       0.101317808009742424E+06,
        0.101312695092861308E+06,       0.101309644418928467E+06,       0.101307843097245379E+06,       0.101307258014776118E+06,       0.101306396062738830E+06,
        0.101304392989299769E+06,       0.101302318926388383E+06,       0.101300146974100906E+06,       0.101296693003163877E+06,       0.101292171838443071E+06,
        0.101287472873098537E+06,       0.101282787197424317E+06,       0.101276691890622955E+06,       0.101271343380570586E+06,       0.101267971439309680E+06,
        0.101267491024100920E+06,       0.101272069334797809E+06,       0.101279335267968272E+06,       0.101288917788163279E+06,       0.101301241225878053E+06,
        0.101315819189724789E+06,       0.101330320177330534E+06,       0.101343606724499783E+06,       0.101360277666390102E+06,       0.101374651937569957E+06,
        0.101381948044541350E+06,       0.101379139254734604E+06,       0.101357829215456179E+06,       0.101327280040149271E+06,       0.101289941888269532E+06,
        0.101246108522415467E+06,       0.101194796632095546E+06,       0.101146024288208340E+06,       0.101103656741928615E+06,       0.101073141515266252E+06,
        0.101057806173447316E+06,       0.101051682514418280E+06,       0.101049406076037965E+06,       0.101052339673225651E+06,       0.101063115066462298E+06,
        0.101078506068417060E+06,       0.101097590566484258E+06,       0.101118771179471136E+06,       0.101135489318013730E+06,       0.101154758424584812E+06,
        0.101177654242688412E+06,       0.101205061131610448E+06,       0.101242230976538951E+06,       0.101283647903067162E+06,       0.101323242160821901E+06,
        0.101358087742294330E+06,       0.101385937955843910E+06,       0.101409794381458749E+06,       0.101425117131910592E+06,       0.101429997042675925E+06,
        0.101424225668113679E+06,       0.101409012607044147E+06,       0.101378645916584719E+06,       0.101341017521829854E+06,       0.101300635121866770E+06,
        0.101259780015675904E+06,       0.101220490612824302E+06,       0.101183385014229250E+06,       0.101147969487759023E+06,       0.101117685992608021E+06,
        0.101093539937281050E+06,       0.101076195561657238E+06,       0.101065910310074483E+06,       0.101063435753359998E+06,       0.101067804628520898E+06,
        0.101076221687106154E+06,       0.101087269872699864E+06,       0.101098388777976448E+06,       0.101105436139853176E+06,       0.101112874451142532E+06,
        0.101118849015061031E+06,       0.101124113984576659E+06,       0.101128454272832299E+06,       0.101131632912711430E+06,       0.101133440671438293E+06,
        0.101133742258942963E+06,       0.101133420481460824E+06,       0.101203377126110252E+06,       0.101198268613597073E+06,       0.101192518049139719E+06,
        0.101186803252296639E+06,       0.101181813758537333E+06,       0.101178421999043727E+06,       0.101175553435103371E+06,       0.101173179030172672E+06,
        0.101171225754259809E+06,       0.101169580857152410E+06,       0.101168097072006873E+06,       0.101166598871645896E+06,       0.101163936200708034E+06,
        0.101160319529115644E+06,       0.101156350070871646E+06,       0.101152298957045554E+06,       0.101148469397518347E+06,       0.101145174878879858E+06,
        0.101142716121090431E+06,       0.101141356671128422E+06,       0.101141393983984628E+06,       0.101143318014807519E+06,       0.101147349641468565E+06,
        0.101153926105170540E+06,       0.101162646354183598E+06,       0.101173404206242340E+06,       0.101185918183552916E+06,       0.101199863730921250E+06,
        0.101216872253279580E+06,       0.101233295276471807E+06,       0.101248215030952546E+06,       0.101260757021715341E+06,       0.101267495548934719E+06,
        0.101269706371902867E+06,       0.101268204478453976E+06,       0.101262805085999877E+06,       0.101255380826612120E+06,       0.101247430865831397E+06,
        0.101239780825202557E+06,       0.101233090454269026E+06,       0.101227802760140185E+06,       0.101223571816330572E+06,       0.101219066722623626E+06,
        0.101214540599785731E+06,       0.101210406057645538E+06,       0.101206592274863258E+06,       0.101202981532469319E+06,       0.101199400726594919E+06,
        0.101195627874287937E+06,       0.101191227720762778E+06,       0.101187565739316706E+06,       0.101185464827996155E+06,       0.101185511851585936E+06,
        0.101188073018881041E+06,       0.101193228150490002E+06,       0.101201132185450770E+06,       0.101211253103469411E+06,       0.101221691007216708E+06,
        0.101232930515629778E+06,       0.101244622455395234E+06,       0.101256099137093290E+06,       0.101264336488988658E+06,       0.101270613718010951E+06,
        0.101275186944850837E+06,       0.101277911712320536E+06,       0.101275720871891084E+06,       0.101272701050287156E+06,       0.101269530015498065E+06,
        0.101266916775846155E+06,       0.101265667085305176E+06,       0.101266412423480491E+06,       0.101269963618393420E+06,       0.101276824074798991E+06,
        0.101286538984123661E+06,       0.101297754584716895E+06,       0.101309268788473608E+06,       0.101319049570761636E+06,       0.101326688370924327E+06,
        0.101331858743319128E+06,       0.101334118663267698E+06,       0.101332850026087355E+06,       0.101327763563889297E+06,       0.101320054486635490E+06,
        0.101310581963123463E+06,       0.101301464042469088E+06,       0.101296071475081029E+06,       0.101292351628835357E+06,       0.101290169534329834E+06,
        0.101288302766939916E+06,       0.101284014152439850E+06,       0.101279941996829206E+06,       0.101276061598442378E+06,       0.101271538120976256E+06,
        0.101266097326113042E+06,       0.101261239127189925E+06,       0.101257245251898741E+06,       0.101253483641709958E+06,       0.101251125639619684E+06,
        0.101251189762292764E+06,       0.101253695416316186E+06,       0.101260342754598576E+06,       0.101269818597965233E+06,       0.101281786685942599E+06,
        0.101297267888598697E+06,       0.101315752383087500E+06,       0.101333588295053938E+06,       0.101349152940472399E+06,       0.101363783604825469E+06,
        0.101372978867465237E+06,       0.101373889912201208E+06,       0.101361962340075130E+06,       0.101329656482126462E+06,       0.101288577681367635E+06,
        0.101241353955692000E+06,       0.101187015186283301E+06,       0.101128342669573714E+06,       0.101074249019373397E+06,       0.101029162958810339E+06,
        0.101000523612843142E+06,       0.100987089359594960E+06,       0.100984958621042068E+06,       0.100992130612266148E+06,       0.101008448898443559E+06,
        0.101030521667859153E+06,       0.101051007866767963E+06,       0.101071664234935859E+06,       0.101090175915114785E+06,       0.101106549855269026E+06,
        0.101125443846952985E+06,       0.101148128478478480E+06,       0.101176649869573142E+06,       0.101219367480301720E+06,       0.101264169410245595E+06,
        0.101307902998138612E+06,       0.101345704641115881E+06,       0.101377820901637606E+06,       0.101403851472658702E+06,       0.101419708524997433E+06,
        0.101423957150136412E+06,       0.101416125366734399E+06,       0.101392821386149662E+06,       0.101354118286926780E+06,       0.101311952791900418E+06,
        0.101267586958551430E+06,       0.101222923148393995E+06,       0.101179984606825063E+06,       0.101137775123404324E+06,       0.101100052058991307E+06,
        0.101068211877007227E+06,       0.101043182495123227E+06,       0.101025887119877370E+06,       0.101017441028948917E+06,       0.101018646999727091E+06,
        0.101025249625575729E+06,       0.101036067916060245E+06,       0.101049702828005305E+06,       0.101064676552964025E+06,       0.101079565938465035E+06,
        0.101088532594576784E+06,       0.101096312478571519E+06,       0.101102983223382442E+06,       0.101108374984337381E+06,       0.101112280329396730E+06,
        0.101114507038743657E+06,       0.101114428830065517E+06,       0.101111055246130432E+06,       0.101196406538596522E+06,       0.101190461736979341E+06,
        0.101184419171533169E+06,       0.101178438759959274E+06,       0.101172694307587532E+06,       0.101168042459568693E+06,       0.101165224780188713E+06,
        0.101163116738625147E+06,       0.101161640044718297E+06,       0.101160673934197897E+06,       0.101160060130737882E+06,       0.101160308872814785E+06,
        0.101161160328086728E+06,       0.101159852318196237E+06,       0.101156811572228151E+06,       0.101153532829243355E+06,       0.101150328623015521E+06,
        0.101147521674777250E+06,       0.101145421670737880E+06,       0.101144300600728122E+06,       0.101144366524547018E+06,       0.101146453358106490E+06,
        0.101151154760197140E+06,       0.101157852536650826E+06,       0.101166593375939396E+06,       0.101177254193880435E+06,       0.101189538295227583E+06,
        0.101202976381101937E+06,       0.101217143841964367E+06,       0.101233326011591271E+06,       0.101248211830283530E+06,       0.101258376645531374E+06,
        0.101264582921753405E+06,       0.101267070734474910E+06,       0.101266001194085227E+06,       0.101261820132445268E+06,       0.101255225790946322E+06,
        0.101247986960119670E+06,       0.101241132826118715E+06,       0.101235589817356347E+06,       0.101231742691396459E+06,       0.101228190519347510E+06,
        0.101224868811623688E+06,       0.101221346956982394E+06,       0.101217966212733285E+06,       0.101214970532675288E+06,       0.101212299627427041E+06,
        0.101209926653408853E+06,       0.101209182347595939E+06,       0.101208894928154026E+06,       0.101206557077161851E+06,       0.101205653829090777E+06,
        0.101206766501731909E+06,       0.101210234953384323E+06,       0.101216093544594405E+06,       0.101223864474518923E+06,       0.101233270650245788E+06,
        0.101243919236364745E+06,       0.101255411905531102E+06,       0.101267215651558581E+06,       0.101278589053053409E+06,       0.101288326667672663E+06,
        0.101293977254483369E+06,       0.101295988963460462E+06,       0.101293942850610052E+06,       0.101290379977981182E+06,       0.101286211796570817E+06,
        0.101282157951643720E+06,       0.101279101833166642E+06,       0.101277814046354848E+06,       0.101278807487432292E+06,       0.101282938226413549E+06,
        0.101291273361035273E+06,       0.101301583582921769E+06,       0.101312849202165788E+06,       0.101324002651453309E+06,       0.101333489244781522E+06,
        0.101339488921891199E+06,       0.101342369325021820E+06,       0.101341720289730991E+06,       0.101337127319298394E+06,       0.101327791615567519E+06,
        0.101315437423608601E+06,       0.101301282640627105E+06,       0.101286811802460725E+06,       0.101276747879297676E+06,       0.101269331760055575E+06,
        0.101263643990522745E+06,       0.101258989523824217E+06,       0.101251456119543334E+06,       0.101244182196566340E+06,       0.101237348106484831E+06,
        0.101228692607444944E+06,       0.101218585751885927E+06,       0.101210928314959441E+06,       0.101206232353375613E+06,       0.101203871455940549E+06,
        0.101203999533384937E+06,       0.101207475042430247E+06,       0.101214320092416674E+06,       0.101224147807091678E+06,       0.101236699974733609E+06,
        0.101251676274940794E+06,       0.101270825632959895E+06,       0.101293545270099348E+06,       0.101314419599624249E+06,       0.101330994497954525E+06,
        0.101343242305169362E+06,       0.101347429834497641E+06,       0.101341255518135789E+06,       0.101319524205864262E+06,       0.101278200143226626E+06,
        0.101228562906559484E+06,       0.101174212317573372E+06,       0.101112623030610339E+06,       0.101048222350508891E+06,       0.100990099190183420E+06,
        0.100943211786408705E+06,       0.100918044317067266E+06,       0.100907611661432689E+06,       0.100910107183064712E+06,       0.100923917070401818E+06,
        0.100948850301936414E+06,       0.100978281786140433E+06,       0.101008728042257979E+06,       0.101037658211344344E+06,       0.101057364399701371E+06,
        0.101074391235513976E+06,       0.101093594285308805E+06,       0.101116488413099345E+06,       0.101150558690399863E+06,       0.101193914933389984E+06,
        0.101239758121016799E+06,       0.101285323747319708E+06,       0.101327925492475028E+06,       0.101365565138565944E+06,       0.101392573640838629E+06,
        0.101408539383438299E+06,       0.101411604282492801E+06,       0.101400582930128410E+06,       0.101366946069406418E+06,       0.101324287192622069E+06,
        0.101276101666633986E+06,       0.101226619258282910E+06,       0.101178585432356136E+06,       0.101130984262627506E+06,       0.101086307783769356E+06,
        0.101046851053375387E+06,       0.101014063196888950E+06,       0.100988908271188513E+06,       0.100971785835137707E+06,       0.100968245753203373E+06,
        0.100971380696101813E+06,       0.100980060807918417E+06,       0.100993169646215858E+06,       0.101009312468744305E+06,       0.101026966655764860E+06,
        0.101044366184895640E+06,       0.101060339563627815E+06,       0.101071158866529076E+06,       0.101079488812984200E+06,       0.101086153913575283E+06,
        0.101090971172654899E+06,       0.101093525999388585E+06,       0.101092846852564820E+06,       0.101089780957355411E+06,       0.101191123249149765E+06,
        0.101184975896710632E+06,       0.101178781171733193E+06,       0.101172687284701038E+06,       0.101166856628363908E+06,       0.101161463025241668E+06,
        0.101157556719236236E+06,       0.101155715658911155E+06,       0.101154729896713383E+06,       0.101154469238441612E+06,       0.101155775624535832E+06,
        0.101158121462038107E+06,       0.101160042093184384E+06,       0.101161344855236384E+06,       0.101160448275110015E+06,       0.101158071590188309E+06,
        0.101155631532086059E+06,       0.101153465356088433E+06,       0.101151897289994900E+06,       0.101151213659422618E+06,       0.101151737576582789E+06,
        0.101154199170773107E+06,       0.101158985005759008E+06,       0.101165841396522868E+06,       0.101174673234837159E+06,       0.101185340894024586E+06,
        0.101197532040988634E+06,       0.101210762902995120E+06,       0.101224385238204501E+06,       0.101237894404589199E+06,       0.101250772227856185E+06,
        0.101260411029266310E+06,       0.101266591706174368E+06,       0.101269204187456722E+06,       0.101268397182717250E+06,       0.101264588122030676E+06,
        0.101258438511883942E+06,       0.101251623403392019E+06,       0.101246063118456994E+06,       0.101242417800723517E+06,       0.101239166549985050E+06,
        0.101236254306650939E+06,       0.101233631773944420E+06,       0.101231248894982156E+06,       0.101228825720597553E+06,       0.101226772928204024E+06,
        0.101225473798737570E+06,       0.101225516278296083E+06,       0.101226043519455008E+06,       0.101227093486833808E+06,       0.101228289760449348E+06,
        0.101228546951147655E+06,       0.101230707510254171E+06,       0.101235093253586310E+06,       0.101241126677553519E+06,       0.101248645598633651E+06,
        0.101258142018320970E+06,       0.101268933306888299E+06,       0.101280513500391826E+06,       0.101292262732881034E+06,       0.101303355465601169E+06,
        0.101312817264586003E+06,       0.101316400177874268E+06,       0.101315483458758521E+06,       0.101312277984593762E+06,       0.101307698621808959E+06,
        0.101302673951913355E+06,       0.101298053010945936E+06,       0.101294840530663249E+06,       0.101294065839099727E+06,       0.101296783533959431E+06,
        0.101302065639223511E+06,       0.101310033568624291E+06,       0.101320378178744606E+06,       0.101331366932783130E+06,       0.101341800425977897E+06,
        0.101350415611308272E+06,       0.101354800042096002E+06,       0.101354718500839095E+06,       0.101350294315183972E+06,       0.101341487001001398E+06,
        0.101327926160731338E+06,       0.101310260858651716E+06,       0.101290273767883307E+06,       0.101269495556410489E+06,       0.101251846238950835E+06,
        0.101238682635122401E+06,       0.101227174341821534E+06,       0.101213482647208613E+06,       0.101195603009729079E+06,       0.101177872156641286E+06,
        0.101162325618075352E+06,       0.101149982165601716E+06,       0.101139852149278217E+06,       0.101134024565056650E+06,       0.101132753824598782E+06,
        0.101135032680571021E+06,       0.101140084766430024E+06,       0.101148877574289698E+06,       0.101161005262514984E+06,       0.101174747769146576E+06,
        0.101190713232751208E+06,       0.101208811802622309E+06,       0.101231640660711972E+06,       0.101258571723189729E+06,       0.101282336017681446E+06,
        0.101299629439163051E+06,       0.101308040998087759E+06,       0.101305555171365690E+06,       0.101290435343250807E+06,       0.101256519799893256E+06,
        0.101204322883293091E+06,       0.101144321216045384E+06,       0.101080811870748948E+06,       0.101014238668434729E+06,       0.100950513534181708E+06,
        0.100894391363170798E+06,       0.100851829575523923E+06,       0.100832142921501421E+06,       0.100825615789308096E+06,       0.100832955840479583E+06,
        0.100854821405899405E+06,       0.100888239967709887E+06,       0.100925422763286362E+06,       0.100962602314510819E+06,       0.100994687767612981E+06,
        0.101018445383155631E+06,       0.101039638130810010E+06,       0.101060824122542370E+06,       0.101084945514884181E+06,       0.101122354145820311E+06,
        0.101165147778325379E+06,       0.101210847657910417E+06,       0.101256682236652778E+06,       0.101301382158490291E+06,       0.101341411155713809E+06,
        0.101372219111328362E+06,       0.101389231784620119E+06,       0.101390880863434664E+06,       0.101369226261351185E+06,       0.101331834231281726E+06,
        0.101285779545129859E+06,       0.101234345503529141E+06,       0.101180743690781746E+06,       0.101127223607977256E+06,       0.101076620915575957E+06,
        0.101030138146362922E+06,       0.100989582250385356E+06,       0.100956503181212684E+06,       0.100931937764084651E+06,       0.100920299784557195E+06,
        0.100918057371207338E+06,       0.100922770743209869E+06,       0.100933261994784887E+06,       0.100948483778151451E+06,       0.100967026543898348E+06,
        0.100987282070977919E+06,       0.101007276882737569E+06,       0.101025807002176851E+06,       0.101042092544874176E+06,       0.101053732614110791E+06,
        0.101061889868345606E+06,       0.101067702910314212E+06,       0.101070224192290465E+06,       0.101070263142884942E+06,       0.101067836061994312E+06,
        0.101188101877120876E+06,       0.101181904204517952E+06,       0.101175721080675750E+06,       0.101169689701016847E+06,       0.101163962332899173E+06,
        0.101158703372389791E+06,       0.101154083105507743E+06,       0.101151357736191479E+06,       0.101150899044327409E+06,       0.101152824487497259E+06,
        0.101156224838871945E+06,       0.101159507416219887E+06,       0.101162417168140935E+06,       0.101164756494849746E+06,       0.101166400553546104E+06,
        0.101165982684454619E+06,       0.101164433293333408E+06,       0.101163049411835455E+06,       0.101162175585306977E+06,       0.101162128095756125E+06,
        0.101163361425100273E+06,       0.101166227742201969E+06,       0.101170937924715152E+06,       0.101177913034471421E+06,       0.101186917319165936E+06,
        0.101197704545258457E+06,       0.101209946031686050E+06,       0.101223141837685776E+06,       0.101236628019135329E+06,       0.101248564959035430E+06,
        0.101259061289307880E+06,       0.101268404236147617E+06,       0.101274449875235630E+06,       0.101277082514349167E+06,       0.101276437786749404E+06,
        0.101272910152209646E+06,       0.101267124457491314E+06,       0.101260716984134080E+06,       0.101256743164844607E+06,       0.101253604663335806E+06,
        0.101250897345323741E+06,       0.101248591593381454E+06,       0.101246654559015689E+06,       0.101245041613427515E+06,       0.101243680788220503E+06,
        0.101243097273199470E+06,       0.101243781512439353E+06,       0.101244948599458978E+06,       0.101246597302939059E+06,       0.101248747416430124E+06,
        0.101251423906546814E+06,       0.101254153427662954E+06,       0.101257318705204321E+06,       0.101261887373189515E+06,       0.101267979989058746E+06,
        0.101275948774720324E+06,       0.101285713213097159E+06,       0.101296774828760288E+06,       0.101308302668075557E+06,       0.101319850467473152E+06,
        0.101329837083710619E+06,       0.101335921303205963E+06,       0.101339123113933456E+06,       0.101337898637374194E+06,       0.101333773323031986E+06,
        0.101328456667992868E+06,       0.101322897112772887E+06,       0.101317900606162963E+06,       0.101315889108461066E+06,       0.101316599306327043E+06,
        0.101319758730558635E+06,       0.101325424301052059E+06,       0.101333284991047447E+06,       0.101343211873693581E+06,       0.101353644944564134E+06,
        0.101363021317380320E+06,       0.101370049287251401E+06,       0.101372596455484265E+06,       0.101369268865042672E+06,       0.101360883616870342E+06,
        0.101347449435595729E+06,       0.101329133164082014E+06,       0.101305327141900649E+06,       0.101278380398203022E+06,       0.101249743471045615E+06,
        0.101219239546209603E+06,       0.101192352888002861E+06,       0.101165652475197479E+06,       0.101139697586887822E+06,       0.101114494511137265E+06,
        0.101090858686180072E+06,       0.101071576294283674E+06,       0.101057575297732197E+06,       0.101048074783742806E+06,       0.101044336258060692E+06,
        0.101046551193469917E+06,       0.101053556962642004E+06,       0.101063713831673056E+06,       0.101077829626709223E+06,       0.101095071852015652E+06,
        0.101113125151151267E+06,       0.101132720710483336E+06,       0.101154045391176667E+06,       0.101180390285880436E+06,       0.101211142948122884E+06,
        0.101237614514436951E+06,       0.101255726302408526E+06,       0.101259492448119025E+06,       0.101250509056824711E+06,       0.101227395084634161E+06,
        0.101182035261948520E+06,       0.101119630114631931E+06,       0.101050635848782738E+06,       0.100979922793482459E+06,       0.100910697623495973E+06,
        0.100847357213499476E+06,       0.100794166368117731E+06,       0.100758894445481623E+06,       0.100744322296544080E+06,       0.100745120848886974E+06,
        0.100759352059448109E+06,       0.100791294801023934E+06,       0.100833112039419531E+06,       0.100877562571698305E+06,       0.100920779246866339E+06,
        0.100955025798225848E+06,       0.100982525754081420E+06,       0.101006044587505748E+06,       0.101028143007870822E+06,       0.101055611280174300E+06,
        0.101091320427340703E+06,       0.101132355621430252E+06,       0.101176767088174020E+06,       0.101222102616479577E+06,       0.101267504098879013E+06,
        0.101307233300950669E+06,       0.101337730007502250E+06,       0.101356132691262712E+06,       0.101355517504656993E+06,       0.101326703347885734E+06,
        0.101286746249401243E+06,       0.101238373176205030E+06,       0.101184685036191077E+06,       0.101128907484998796E+06,       0.101073391747240559E+06,
        0.101019454525129811E+06,       0.100970871910515343E+06,       0.100929826661987419E+06,       0.100897105571455861E+06,       0.100876831879007659E+06,
        0.100867962906273533E+06,       0.100867330421829305E+06,       0.100873728684090966E+06,       0.100885749735442761E+06,       0.100902849954122852E+06,
        0.100924138951177738E+06,       0.100946961851234868E+06,       0.100969279025770302E+06,       0.100990033557581031E+06,       0.101008477654044342E+06,
        0.101024214908302165E+06,       0.101035732998499894E+06,       0.101041912961714450E+06,       0.101045642366251923E+06,       0.101046792406885972E+06,
        0.101045365333532347E+06,       0.101187355100872199E+06,       0.101181283838042174E+06,       0.101175299671037268E+06,       0.101169529662610788E+06,
        0.101164117431673949E+06,       0.101159220075809775E+06,       0.101155001817589582E+06,       0.101151624022777440E+06,       0.101152497595067340E+06,
        0.101156451659840226E+06,       0.101160648061411019E+06,       0.101164790528929152E+06,       0.101168618147906396E+06,       0.101171926049179310E+06,
        0.101174580360364256E+06,       0.101176526712674633E+06,       0.101176736224529814E+06,       0.101176257363116325E+06,       0.101176166983752380E+06,
        0.101176807287626842E+06,       0.101178681128324213E+06,       0.101182078251181316E+06,       0.101187204570596310E+06,       0.101194163269585537E+06,
        0.101203334524264646E+06,       0.101214364937736551E+06,       0.101226809413448165E+06,       0.101240149829298927E+06,       0.101253261358725853E+06,
        0.101265100089497806E+06,       0.101275120974395875E+06,       0.101282996940042518E+06,       0.101288828111014154E+06,       0.101291420149586207E+06,
        0.101290897222999163E+06,       0.101287639377078289E+06,       0.101283002528089506E+06,       0.101278193857728707E+06,       0.101273020512430914E+06,
        0.101269901051284018E+06,       0.101267678623295869E+06,       0.101265950449211479E+06,       0.101264703039611326E+06,       0.101263900879826906E+06,
        0.101263923607509249E+06,       0.101265004562038375E+06,       0.101266684912193334E+06,       0.101268855296950496E+06,       0.101271506964180182E+06,
        0.101274640173084292E+06,       0.101278241537383161E+06,       0.101282245825992912E+06,       0.101286353240369135E+06,       0.101291355828485597E+06,
        0.101297931619035255E+06,       0.101306253371424813E+06,       0.101316214078965480E+06,       0.101327380285913983E+06,       0.101338920669929619E+06,
        0.101349293450103680E+06,       0.101357122930671496E+06,       0.101362252520088790E+06,       0.101364464771970830E+06,       0.101363785192026829E+06,
        0.101359089181177871E+06,       0.101353368594169064E+06,       0.101348059285105599E+06,       0.101344504609358351E+06,       0.101342802273270747E+06,
        0.101343694674300015E+06,       0.101347186594235303E+06,       0.101353156284255645E+06,       0.101361135003142495E+06,       0.101370388484892959E+06,
        0.101380640458787442E+06,       0.101388946718752617E+06,       0.101393651801589484E+06,       0.101393499019751704E+06,       0.101386884558896083E+06,
        0.101374143979384535E+06,       0.101355609362859250E+06,       0.101331626780358332E+06,       0.101301083582183201E+06,       0.101263353354839783E+06,
        0.101221306897352624E+06,       0.101176993466944725E+06,       0.101136539903244993E+06,       0.101098204242251013E+06,       0.101061761330862719E+06,
        0.101028266665796909E+06,       0.100998589290583972E+06,       0.100975333400938267E+06,       0.100959068131358043E+06,       0.100949766177223195E+06,
        0.100947806353674678E+06,       0.100952626346498961E+06,       0.100962758032929953E+06,       0.100976213788639361E+06,       0.100993663080123253E+06,
        0.101014486892675981E+06,       0.101035822837299012E+06,       0.101058579399157214E+06,       0.101083303211150094E+06,       0.101113186489526008E+06,
        0.101147351565124962E+06,       0.101176652682216401E+06,       0.101196193972918787E+06,       0.101198569776344622E+06,       0.101186160134931008E+06,
        0.101157868126258880E+06,       0.101103141394806822E+06,       0.101031831614193070E+06,       0.100956733996206865E+06,       0.100882403087983286E+06,
        0.100813473138545116E+06,       0.100752516407046714E+06,       0.100703757785565627E+06,       0.100676218536944187E+06,       0.100667431274046598E+06,
        0.100674873519601999E+06,       0.100697658618489222E+06,       0.100739841159568794E+06,       0.100789068474863947E+06,       0.100839720710070338E+06,
        0.100886379550526690E+06,       0.100923029883014446E+06,       0.100953143284320337E+06,       0.100977639241319004E+06,       0.100999128395021136E+06,
        0.101024581691416737E+06,       0.101055845921262473E+06,       0.101093715024692676E+06,       0.101137145750038864E+06,       0.101181709309337297E+06,
        0.101225325474523444E+06,       0.101263559713032722E+06,       0.101292474677031365E+06,       0.101308682549641118E+06,       0.101297475120822361E+06,
        0.101271409211849808E+06,       0.101232040601299872E+06,       0.101182869285470704E+06,       0.101128290980360704E+06,       0.101072929755581790E+06,
        0.101016889073163620E+06,       0.100962491541966170E+06,       0.100912327910715336E+06,       0.100869361400221751E+06,       0.100839775977090918E+06,
        0.100823441492130820E+06,       0.100816113342184137E+06,       0.100817094874734074E+06,       0.100825233759279654E+06,       0.100839074432490510E+06,
        0.100858082771811969E+06,       0.100882174552001874E+06,       0.100906977487573211E+06,       0.100931151837540980E+06,       0.100953671595204651E+06,
        0.100973813441941427E+06,       0.100991208365737388E+06,       0.101004593996319396E+06,       0.101014464426847393E+06,       0.101019840305871679E+06,
        0.101022516216040211E+06,       0.101022479820383916E+06,       0.101189306237606637E+06,       0.101183099563423224E+06,       0.101177524645541649E+06,
        0.101172236435105573E+06,       0.101167371532973528E+06,       0.101163082020276575E+06,       0.101159529060147339E+06,       0.101159316447558173E+06,
        0.101160894564677219E+06,       0.101164348300187223E+06,       0.101169261422140553E+06,       0.101174195290734366E+06,       0.101178879818970003E+06,
        0.101183100812083387E+06,       0.101186714675334646E+06,       0.101189656703835382E+06,       0.101191942124414170E+06,       0.101192917377320977E+06,
        0.101193593575982464E+06,       0.101195069630171711E+06,       0.101197693383898673E+06,       0.101201751769885639E+06,       0.101207449602623747E+06,
        0.101214890679059696E+06,       0.101224061589853489E+06,       0.101235336912347877E+06,       0.101248190104239126E+06,       0.101262427935202722E+06,
        0.101275786221996692E+06,       0.101287697523967043E+06,       0.101297635973110140E+06,       0.101305160473319178E+06,       0.101310051693956630E+06,
        0.101312576731523863E+06,       0.101312178530984005E+06,       0.101309704462442271E+06,       0.101306154021924303E+06,       0.101301740366064056E+06,
        0.101296951709652378E+06,       0.101292269396465854E+06,       0.101290108113855764E+06,       0.101288928548419208E+06,       0.101288387917089291E+06,
        0.101288777866387623E+06,       0.101290116771842790E+06,       0.101292139767421628E+06,       0.101294723268304471E+06,       0.101297795211849851E+06,
        0.101301366709605994E+06,       0.101305420330384557E+06,       0.101309869927812077E+06,       0.101314312823006214E+06,       0.101319116997910372E+06,
        0.101324617109151222E+06,       0.101331532615370001E+06,       0.101340103637168490E+06,       0.101350201834497682E+06,       0.101361344371531173E+06,
        0.101372418886796950E+06,       0.101381948875157381E+06,       0.101388923839096911E+06,       0.101393136106285616E+06,       0.101394429864949576E+06,
        0.101392894622174237E+06,       0.101388710803148075E+06,       0.101383777236252092E+06,       0.101379295952832908E+06,       0.101375940276367168E+06,
        0.101374441230547527E+06,       0.101375326622697306E+06,       0.101379093018278771E+06,       0.101385343361571824E+06,       0.101393971058482173E+06,
        0.101404050563811383E+06,       0.101413309721598285E+06,       0.101419590399406094E+06,       0.101421556394179410E+06,       0.101418021431235960E+06,
        0.101407974515161055E+06,       0.101390537479077990E+06,       0.101366032709315157E+06,       0.101334626683717870E+06,       0.101295933958054040E+06,
        0.101248443893183838E+06,       0.101195557967522065E+06,       0.101139585544601810E+06,       0.101085211343045346E+06,       0.101035266930195139E+06,
        0.100988241812145512E+06,       0.100945367896748721E+06,       0.100910497202633036E+06,       0.100884702886764164E+06,       0.100866517649476897E+06,
        0.100856014684083144E+06,       0.100852787000617667E+06,       0.100856653557479323E+06,       0.100867163372326730E+06,       0.100881111266454434E+06,
        0.100900315195405696E+06,       0.100923976750114074E+06,       0.100948598119614544E+06,       0.100974781704195004E+06,       0.101003202157587060E+06,
        0.101036407590628412E+06,       0.101073193182310031E+06,       0.101104736474453239E+06,       0.101125695287679831E+06,       0.101129453279073452E+06,
        0.101117773581594010E+06,       0.101089185532541305E+06,       0.101034032199054171E+06,       0.100963945545633382E+06,       0.100886699328991119E+06,
        0.100810636627241329E+06,       0.100740715610179395E+06,       0.100679191246166200E+06,       0.100632989251138570E+06,       0.100613781871159343E+06,
        0.100610871530594683E+06,       0.100624379990977119E+06,       0.100656925116010229E+06,       0.100705935141557828E+06,       0.100761070879974053E+06,
        0.100816622699684551E+06,       0.100864793595773081E+06,       0.100902967646118850E+06,       0.100932714749620762E+06,       0.100956310150092322E+06,
        0.100973624358999965E+06,       0.100992241483773090E+06,       0.101016637765204548E+06,       0.101048154107647293E+06,       0.101087466334016062E+06,
        0.101132339254048915E+06,       0.101174823812832328E+06,       0.101210761915469266E+06,       0.101237271423401384E+06,       0.101243002885737078E+06,
        0.101230131791106003E+06,       0.101203940299668466E+06,       0.101166656487591579E+06,       0.101121119041289232E+06,       0.101069073832594047E+06,
        0.101014700223724387E+06,       0.100959265268248433E+06,       0.100905468112225586E+06,       0.100856040902612105E+06,       0.100814460428244129E+06,
        0.100787259237540056E+06,       0.100772005863003345E+06,       0.100765985352267919E+06,       0.100768479113289053E+06,       0.100778366997407138E+06,
        0.100794945598743492E+06,       0.100817620478677374E+06,       0.100842147859125718E+06,       0.100867955315801722E+06,       0.100893394586128459E+06,
        0.100917107047287223E+06,       0.100938380004807230E+06,       0.100955347801049342E+06,       0.100970101009214006E+06,       0.100982904354844184E+06,
        0.100992784717252944E+06,       0.100997426697573173E+06,       0.100999203666720758E+06,       0.101193726602745155E+06,       0.101187754050723946E+06,
        0.101182357442443288E+06,       0.101177791388126643E+06,       0.101173723996436573E+06,       0.101170304719806183E+06,       0.101170612153776412E+06,
        0.101172440371721386E+06,       0.101174837075875621E+06,       0.101177672254314428E+06,       0.101182161160034389E+06,       0.101187828651191783E+06,
        0.101193320301503438E+06,       0.101198410730358519E+06,       0.101202946144533795E+06,       0.101206852558810875E+06,       0.101210007801575470E+06,
        0.101212489910168282E+06,       0.101214469378389869E+06,       0.101216878002924321E+06,       0.101220363461237575E+06,       0.101225214136769951E+06,
        0.101231637580600829E+06,       0.101239741560505950E+06,       0.101249517808410572E+06,       0.101260983023677167E+06,       0.101275957870551239E+06,
        0.101290656294668952E+06,       0.101304333702323362E+06,       0.101316427532517599E+06,       0.101326426428850100E+06,       0.101333915035895625E+06,
        0.101338611708287717E+06,       0.101340492859798338E+06,       0.101340362563395611E+06,       0.101338449476013702E+06,       0.101335257523435517E+06,
        0.101331249861504504E+06,       0.101326886093198918E+06,       0.101322617484757109E+06,       0.101318867500197564E+06,       0.101317900452591755E+06,
        0.101318314786954928E+06,       0.101319723768116164E+06,       0.101321959881412520E+06,       0.101324889048512938E+06,       0.101328347647524672E+06,
        0.101332174840765205E+06,       0.101336616060312401E+06,       0.101341556829236884E+06,       0.101346573413864826E+06,       0.101351603295543347E+06,
        0.101356815104860521E+06,       0.101362438373961399E+06,       0.101369371088361426E+06,       0.101378082295762331E+06,       0.101388314410706720E+06,
        0.101399372327800622E+06,       0.101410061836120745E+06,       0.101419580351030396E+06,       0.101425913537260407E+06,       0.101429293259021812E+06,
        0.101429804412116951E+06,       0.101427672924137820E+06,       0.101424080437455879E+06,       0.101419619212416699E+06,       0.101415230974183942E+06,
        0.101412067965185430E+06,       0.101410791086110883E+06,       0.101411739073867124E+06,       0.101415639705951602E+06,       0.101423312622668134E+06,
        0.101432474045874798E+06,       0.101442051195699867E+06,       0.101450469188552204E+06,       0.101454491373749755E+06,       0.101453440137517347E+06,
        0.101446281387837167E+06,       0.101431595048405667E+06,       0.101408886711617088E+06,       0.101378784184722594E+06,       0.101341184770978914E+06,
        0.101295889547724786E+06,       0.101240328400627433E+06,       0.101177652284460986E+06,       0.101111150684114546E+06,       0.101044053118300144E+06,
        0.100984918740243505E+06,       0.100930374090685815E+06,       0.100881582472409573E+06,       0.100841112633375247E+06,       0.100809768362702191E+06,
        0.100786799243457121E+06,       0.100772143085301912E+06,       0.100764968278141983E+06,       0.100765770745809103E+06,       0.100774102380776618E+06,
        0.100787701814049200E+06,       0.100807502103195773E+06,       0.100832717694658859E+06,       0.100860249536352872E+06,       0.100889852423407749E+06,
        0.100921848628126099E+06,       0.100957861355781963E+06,       0.100996433916241411E+06,       0.101029829562515966E+06,       0.101052485930506547E+06,
        0.101058372937639273E+06,       0.101049548410078569E+06,       0.101024243456762211E+06,       0.100972590760278690E+06,       0.100908281417167527E+06,
        0.100837060983074800E+06,       0.100768161325613342E+06,       0.100704714640766149E+06,       0.100649980401007386E+06,       0.100610226186345069E+06,
        0.100590748020045430E+06,       0.100587436259410169E+06,       0.100600313080586799E+06,       0.100641206195168561E+06,       0.100694783185600594E+06,
        0.100753395339411843E+06,       0.100811221255729251E+06,       0.100860359364136690E+06,       0.100899824043495319E+06,       0.100928315410134717E+06,
        0.100945425133485944E+06,       0.100949685705930868E+06,       0.100959203677864440E+06,       0.100974757114044391E+06,       0.100998131833821230E+06,
        0.101033920715517670E+06,       0.101074219109624129E+06,       0.101114091820176982E+06,       0.101149405994865883E+06,       0.101170348641579942E+06,
        0.101169807298637141E+06,       0.101156298476682292E+06,       0.101130628971099330E+06,       0.101094643437300154E+06,       0.101052492078486888E+06,
        0.101007253119503090E+06,       0.100955907017813224E+06,       0.100902084595712833E+06,       0.100849827379669470E+06,       0.100802083544595851E+06,
        0.100765913220995702E+06,       0.100739572869835451E+06,       0.100723779479156976E+06,       0.100718506421119528E+06,       0.100722320980193326E+06,
        0.100734436110120514E+06,       0.100755329206052033E+06,       0.100779519272158068E+06,       0.100805173540144926E+06,       0.100830784490592530E+06,
        0.100856189170746162E+06,       0.100880432886013805E+06,       0.100899949784039432E+06,       0.100917438620547167E+06,       0.100933522862752710E+06,
        0.100948109352301544E+06,       0.100961044329522949E+06,       0.100971373211325132E+06,       0.100975423948777170E+06,       0.101200152192834488E+06,
        0.101194982325493736E+06,       0.101190103263664205E+06,       0.101186138559247396E+06,       0.101183134221834189E+06,       0.101184216681154692E+06,
        0.101186521041798725E+06,       0.101189436060083317E+06,       0.101192802546943451E+06,       0.101196478796712297E+06,       0.101200354354545649E+06,
        0.101205668611732151E+06,       0.101211929159398627E+06,       0.101217855930562437E+06,       0.101223284560094209E+06,       0.101227968215825720E+06,
        0.101231889676374194E+06,       0.101235394681567603E+06,       0.101238691342655846E+06,       0.101242180145337508E+06,       0.101246637252434826E+06,
        0.101252408136256170E+06,       0.101259706939182157E+06,       0.101268648761024378E+06,       0.101279505402642011E+06,       0.101294343975882977E+06,
        0.101309563533686218E+06,       0.101324641711895500E+06,       0.101338688391072021E+06,       0.101351044389960793E+06,       0.101361207159967045E+06,
        0.101368783445243811E+06,       0.101373529077171552E+06,       0.101374957490127519E+06,       0.101374464042535998E+06,       0.101372814207710297E+06,
        0.101369991240096075E+06,       0.101366429702577938E+06,       0.101362562430391059E+06,       0.101358815668015828E+06,       0.101355589086463762E+06,
        0.101353446673457220E+06,       0.101354379072032898E+06,       0.101356568662050558E+06,       0.101359675232751892E+06,       0.101363521918530183E+06,
        0.101367901119934351E+06,       0.101372596354978567E+06,       0.101377679630817802E+06,       0.101383555064504282E+06,       0.101389214201889146E+06,
        0.101394747283543154E+06,       0.101400304955646759E+06,       0.101406085277459220E+06,       0.101412285840230092E+06,       0.101421118963008921E+06,
        0.101431763041225102E+06,       0.101442507714153820E+06,       0.101452705296310087E+06,       0.101461587946274274E+06,       0.101468308697248838E+06,
        0.101470980618346424E+06,       0.101470729759961876E+06,       0.101468260238464049E+06,       0.101464485269084631E+06,       0.101460142280246233E+06,
        0.101455922507406227E+06,       0.101452998879112638E+06,       0.101452045655453316E+06,       0.101454002525278673E+06,       0.101458795222069632E+06,
        0.101466167386261062E+06,       0.101474834484365027E+06,       0.101483448321051124E+06,       0.101490293297485317E+06,       0.101492761571887779E+06,
        0.101487122913431667E+06,       0.101474656695076628E+06,       0.101456224507296021E+06,       0.101430664509854570E+06,       0.101396241168372988E+06,
        0.101353344458271313E+06,       0.101301873429881321E+06,       0.101240809982906721E+06,       0.101170237649192510E+06,       0.101096056635001150E+06,
        0.101022326149495057E+06,       0.100954494264510751E+06,       0.100892663983306251E+06,       0.100837194485465618E+06,       0.100789854158125687E+06,
        0.100752681688232609E+06,       0.100724050472389747E+06,       0.100703743253736306E+06,       0.100691513151292049E+06,       0.100687489061012806E+06,
        0.100691112445670500E+06,       0.100703488782601926E+06,       0.100723515984008409E+06,       0.100749686437924174E+06,       0.100779862035053753E+06,
        0.100812870466228749E+06,       0.100848356219152789E+06,       0.100886618033728999E+06,       0.100925814700154908E+06,       0.100959913340029161E+06,
        0.100983841408427761E+06,       0.100992708938197888E+06,       0.100988038726636543E+06,       0.100967451749821237E+06,       0.100923773661071609E+06,
        0.100869154347678006E+06,       0.100808293671752166E+06,       0.100749950128448239E+06,       0.100695742144580625E+06,       0.100650055466795442E+06,
        0.100620543751264457E+06,       0.100607774629359716E+06,       0.100609856499218455E+06,       0.100627731512123690E+06,       0.100665827330432643E+06,
        0.100713727303578300E+06,       0.100768972922192886E+06,       0.100825101449405265E+06,       0.100873709631678183E+06,       0.100911910907812446E+06,
        0.100937425920985901E+06,       0.100943826278808614E+06,       0.100938923612846338E+06,       0.100932772703382885E+06,       0.100933209681834254E+06,
        0.100949942917228545E+06,       0.100978390439217677E+06,       0.101012218238497939E+06,       0.101047001443362271E+06,       0.101078030320958118E+06,
        0.101092528178749781E+06,       0.101092763600199483E+06,       0.101079667768304178E+06,       0.101055363093306296E+06,       0.101021923023798488E+06,
        0.100985043918944197E+06,       0.100942576674115116E+06,       0.100896142310934607E+06,       0.100846740359288175E+06,       0.100796745756417309E+06,
        0.100754281013923188E+06,       0.100719661969801513E+06,       0.100694202095497239E+06,       0.100678990016565542E+06,       0.100674159552381345E+06,
        0.100679144362130333E+06,       0.100696517057853678E+06,       0.100718723297862292E+06,       0.100743828966135392E+06,       0.100770038155539907E+06,
        0.100795879753092362E+06,       0.100820314666932885E+06,       0.100840279171251284E+06,       0.100859249879902098E+06,       0.100877455365052447E+06,
        0.100894767625869688E+06,       0.100911051050858092E+06,       0.100926113687447752E+06,       0.100939677540915931E+06,       0.100954098051095163E+06,
        0.101208266074669766E+06,       0.101204147301312958E+06,       0.101200416332034234E+06,       0.101197391022381067E+06,       0.101199181271863577E+06,
        0.101202094479608772E+06,       0.101205718922681015E+06,       0.101209868079757638E+06,       0.101214363087133126E+06,       0.101219049217859545E+06,
        0.101223809934456556E+06,       0.101228578149758148E+06,       0.101234563424877633E+06,       0.101241302361129114E+06,       0.101247428820028508E+06,
        0.101252833705618847E+06,       0.101257741214607289E+06,       0.101262268791874914E+06,       0.101266621965163562E+06,       0.101271104202253337E+06,
        0.101276449761759577E+06,       0.101283261996570189E+06,       0.101291578552841063E+06,       0.101301921001578070E+06,       0.101316864610287244E+06,
        0.101332633397110185E+06,       0.101348565409528048E+06,       0.101363970375545556E+06,       0.101378339950166031E+06,       0.101391005184961628E+06,
        0.101401390238182328E+06,       0.101409118811233842E+06,       0.101412813852507519E+06,       0.101413916622343488E+06,       0.101413648249779086E+06,
        0.101412262363096830E+06,       0.101409843816287481E+06,       0.101406792118611833E+06,       0.101403515263375913E+06,       0.101400419883465394E+06,
        0.101397648089374270E+06,       0.101396200071828469E+06,       0.101396462464251483E+06,       0.101399249041504649E+06,       0.101403242459244415E+06,
        0.101408064521844237E+06,       0.101413460579763079E+06,       0.101419299541355576E+06,       0.101425515902185769E+06,       0.101431872156549493E+06,
        0.101438092345517420E+06,       0.101444082593329236E+06,       0.101449980221889302E+06,       0.101455962961780679E+06,       0.101462741205452243E+06,
        0.101470817291088752E+06,       0.101480892587434573E+06,       0.101491089133211004E+06,       0.101500643428374140E+06,       0.101508817670985038E+06,
        0.101514860224122342E+06,       0.101517434476198061E+06,       0.101516541747761323E+06,       0.101513815068472235E+06,       0.101509904719619197E+06,
        0.101505507654049128E+06,       0.101501313463842132E+06,       0.101498849002981064E+06,       0.101499159934514231E+06,       0.101501693020130377E+06,
        0.101506338552975649E+06,       0.101512651659291208E+06,       0.101520288072555239E+06,       0.101527432009874057E+06,       0.101531192551327069E+06,
        0.101528423709889583E+06,       0.101519435532333911E+06,       0.101504734513441072E+06,       0.101484004484384001E+06,       0.101456280732745858E+06,
        0.101419035179553714E+06,       0.101371837096264266E+06,       0.101315248944149382E+06,       0.101249891741609565E+06,       0.101174205010685138E+06,
        0.101095025216710172E+06,       0.101016603839094241E+06,       0.100942714517862012E+06,       0.100875651961458614E+06,       0.100815206600637175E+06,
        0.100762266129504540E+06,       0.100719792923412402E+06,       0.100688381242510412E+06,       0.100664315202569429E+06,       0.100646899315571907E+06,
        0.100636389190856382E+06,       0.100633921317728295E+06,       0.100640986745192960E+06,       0.100657927960284273E+06,       0.100683603999329847E+06,
        0.100715139361547874E+06,       0.100750464071587950E+06,       0.100789001781336541E+06,       0.100828980626378441E+06,       0.100867904881876937E+06,
        0.100901941917073651E+06,       0.100927518925117751E+06,       0.100941703370720032E+06,       0.100943313763502156E+06,       0.100929483993483183E+06,
        0.100897899422321643E+06,       0.100855144068640948E+06,       0.100806216832129357E+06,       0.100757963881253396E+06,       0.100713882396988687E+06,
        0.100678037239657642E+06,       0.100660578064393208E+06,       0.100655660139403961E+06,       0.100663394611081239E+06,       0.100687757803070126E+06,
        0.100726360544964817E+06,       0.100771737117872792E+06,       0.100819550423355045E+06,       0.100863789606076709E+06,       0.100903960982124961E+06,
        0.100937933974381580E+06,       0.100955929021348216E+06,       0.100950002084778927E+06,       0.100936336168784517E+06,       0.100920611799506456E+06,
        0.100908792443247541E+06,       0.100909956087163751E+06,       0.100924519937428529E+06,       0.100950317855032117E+06,       0.100978637481090613E+06,
        0.101001785171553231E+06,       0.101014600980588948E+06,       0.101015533816949537E+06,       0.101004399554267075E+06,       0.100982402170127083E+06,
        0.100954472767269413E+06,       0.100920498290662959E+06,       0.100881272186000555E+06,       0.100838252143924561E+06,       0.100793001524282852E+06,
        0.100749722238879811E+06,       0.100710007831689465E+06,       0.100676561452258436E+06,       0.100651754156739727E+06,       0.100637016515992684E+06,
        0.100632797680647462E+06,       0.100643122435673547E+06,       0.100662040946369423E+06,       0.100684765371038040E+06,       0.100710073382574032E+06,
        0.100736158886730540E+06,       0.100761558107963079E+06,       0.100780935166741401E+06,       0.100798370121153508E+06,       0.100816555152162895E+06,
        0.100835390903751701E+06,       0.100853847765655024E+06,       0.100871757501481305E+06,       0.100888895778612612E+06,       0.100908175229415137E+06,
        0.100925669047910487E+06,       0.101217702072300162E+06,       0.101214879429494846E+06,       0.101212918203238412E+06,       0.101215072363802130E+06,
        0.101218250672383481E+06,       0.101222522132735277E+06,       0.101227622288938786E+06,       0.101233167267756522E+06,       0.101238956389902218E+06,
        0.101244820309774892E+06,       0.101250635435466815E+06,       0.101256335683556361E+06,       0.101261921151622766E+06,       0.101268342600560762E+06,
        0.101275163933372678E+06,       0.101281497833931266E+06,       0.101287383286156546E+06,       0.101292932525330558E+06,       0.101298347923196663E+06,
        0.101303932128846092E+06,       0.101310090422888767E+06,       0.101317693616226330E+06,       0.101327652607175361E+06,       0.101342480557763687E+06,
        0.101358556451299402E+06,       0.101375279086523937E+06,       0.101391978870831925E+06,       0.101407971443584844E+06,       0.101422613121423448E+06,
        0.101435506823643867E+06,       0.101446124078218185E+06,       0.101452234738676838E+06,       0.101455284023688801E+06,       0.101456737369482420E+06,
        0.101456865445288451E+06,       0.101455916182255954E+06,       0.101454121953738781E+06,       0.101451661773156113E+06,       0.101449081947506013E+06,
        0.101446228059309360E+06,       0.101444208961239303E+06,       0.101443612932188233E+06,       0.101444705011359765E+06,       0.101447541270001515E+06,
        0.101452383501387390E+06,       0.101458282693875270E+06,       0.101464997464114887E+06,       0.101472100710916289E+06,       0.101479273864667499E+06,
        0.101486350419971670E+06,       0.101493152086614995E+06,       0.101499576717366377E+06,       0.101505843270561643E+06,       0.101512436676125639E+06,
        0.101519641676807107E+06,       0.101527434410592061E+06,       0.101535644765811841E+06,       0.101545029301612725E+06,       0.101553754432012545E+06,
        0.101560956040866411E+06,       0.101564550165702050E+06,       0.101566892094339870E+06,       0.101567035078111294E+06,       0.101564167039659485E+06,
        0.101560257949168226E+06,       0.101555969226616333E+06,       0.101552313766367617E+06,       0.101550452021603851E+06,       0.101550963150145908E+06,
        0.101553454481203808E+06,       0.101557594737071355E+06,       0.101562591960326725E+06,       0.101568055832384678E+06,       0.101570018237429336E+06,
        0.101568806715803599E+06,       0.101563796324326468E+06,       0.101553825571776295E+06,       0.101537561122490020E+06,       0.101515230788797810E+06,
        0.101485862600308523E+06,       0.101448189650402157E+06,       0.101397681000099896E+06,       0.101336913516701141E+06,       0.101267241010695536E+06,
        0.101189600658946001E+06,       0.101107785950000631E+06,       0.101027329917614610E+06,       0.100951013494106854E+06,       0.100883020611558357E+06,
        0.100825246076290889E+06,       0.100775271676367163E+06,       0.100732070018118597E+06,       0.100693807828755365E+06,       0.100660471847562090E+06,
        0.100632198820324600E+06,       0.100610336348454613E+06,       0.100597445568148105E+06,       0.100596347705297740E+06,       0.100608739289963560E+06,
        0.100632312399144867E+06,       0.100664180492312080E+06,       0.100701580165578795E+06,       0.100742885809197804E+06,       0.100784251808581277E+06,
        0.100822721504335888E+06,       0.100857114729781009E+06,       0.100884974331454141E+06,       0.100904296005382625E+06,       0.100913525976403209E+06,
        0.100909880311948247E+06,       0.100892635225440783E+06,       0.100865034092500646E+06,       0.100830041776689235E+06,       0.100792635237818962E+06,
        0.100758858691726316E+06,       0.100734424708176390E+06,       0.100726153683192097E+06,       0.100729591906647329E+06,       0.100742469628359380E+06,
        0.100772373108355430E+06,       0.100810039805286127E+06,       0.100850865902025442E+06,       0.100889839249818047E+06,       0.100924291493751982E+06,
        0.100954018166122405E+06,       0.100976020229241141E+06,       0.100977598211779696E+06,       0.100962801120868462E+06,       0.100940325812200113E+06,
        0.100915300637579014E+06,       0.100897607613392654E+06,       0.100888545266499175E+06,       0.100887361365753401E+06,       0.100894417619390835E+06,
        0.100914107950286358E+06,       0.100931864535990011E+06,       0.100942729300749750E+06,       0.100943712413188565E+06,       0.100933999633237443E+06,
        0.100915953837210676E+06,       0.100891962587812566E+06,       0.100861290497928669E+06,       0.100825794229352119E+06,       0.100786805648525173E+06,
        0.100747059949918155E+06,       0.100708052571343884E+06,       0.100670389177752746E+06,       0.100637438856290988E+06,       0.100612791553316754E+06,
        0.100598161054412602E+06,       0.100597616745557592E+06,       0.100608245258248513E+06,       0.100627589752602711E+06,       0.100652501052796259E+06,
        0.100677256390096882E+06,       0.100702485105916334E+06,       0.100721371071945381E+06,       0.100737732280855227E+06,       0.100754743779602475E+06,
        0.100772593580461515E+06,       0.100791374419969914E+06,       0.100810897025248196E+06,       0.100830367089737425E+06,       0.100852737881952431E+06,
        0.100874075837282377E+06,       0.100893534157121714E+06,       0.101228070489269143E+06,       0.101227544665406953E+06,       0.101230349746524807E+06,
        0.101234269851944497E+06,       0.101239184467959683E+06,       0.101244939450664504E+06,       0.101251545017166776E+06,       0.101258662705518451E+06,
        0.101265918196699597E+06,       0.101273125560589353E+06,       0.101280152736103031E+06,       0.101286933875186733E+06,       0.101293407125996848E+06,
        0.101299586824039099E+06,       0.101306376779591956E+06,       0.101313623028716072E+06,       0.101320476967868250E+06,       0.101327043370354135E+06,
        0.101333520713772232E+06,       0.101340211822319048E+06,       0.101347526837547412E+06,       0.101356523012281294E+06,       0.101370533287668499E+06,
        0.101386582740267011E+06,       0.101403758993542797E+06,       0.101421430602220105E+06,       0.101438909393433467E+06,       0.101455505881131437E+06,
        0.101470586854150286E+06,       0.101483635012064580E+06,       0.101492144560654036E+06,       0.101497362403152074E+06,       0.101500801900675287E+06,
        0.101502736875093309E+06,       0.101503413235270535E+06,       0.101503062612840484E+06,       0.101501914512809366E+06,       0.101500206465205003E+06,
        0.101497831592138784E+06,       0.101495767534276791E+06,       0.101494714546066039E+06,       0.101495119352637426E+06,       0.101497237786485115E+06,
        0.101501125674684867E+06,       0.101506644060371764E+06,       0.101514150312748505E+06,       0.101522320784248848E+06,       0.101530563331544297E+06,
        0.101538706294350879E+06,       0.101546559377466736E+06,       0.101553946547580461E+06,       0.101560765945043371E+06,       0.101567653265792658E+06,
        0.101574587210003941E+06,       0.101581752742970988E+06,       0.101589174518686996E+06,       0.101596642355671458E+06,       0.101603818859754785E+06,
        0.101610799838750623E+06,       0.101614811522755466E+06,       0.101617790546373333E+06,       0.101619757440904345E+06,       0.101620562545717650E+06,
        0.101618884459059045E+06,       0.101615191240677028E+06,       0.101611483339551589E+06,       0.101608375965291722E+06,       0.101606589668011176E+06,
        0.101606767311590491E+06,       0.101608967585915860E+06,       0.101612347393029107E+06,       0.101614810665037265E+06,       0.101614446811429036E+06,
        0.101613127583126843E+06,       0.101609516694027276E+06,       0.101602475273863849E+06,       0.101591105455035053E+06,       0.101574139304303288E+06,
        0.101552261616850359E+06,       0.101522964529426812E+06,       0.101483809256113498E+06,       0.101431803333729331E+06,       0.101367984772122625E+06,
        0.101295216781381270E+06,       0.101216180859079337E+06,       0.101134418945842335E+06,       0.101057719484696820E+06,       0.100987761361816083E+06,
        0.100925129407695815E+06,       0.100869076127166059E+06,       0.100819148307903684E+06,       0.100772602660554068E+06,       0.100726367887494707E+06,
        0.100682387602061091E+06,       0.100642046686646194E+06,       0.100608073036628615E+06,       0.100583165331615121E+06,       0.100571567333927058E+06,
        0.100579161681519065E+06,       0.100599831523424771E+06,       0.100631457444745640E+06,       0.100671162741316628E+06,       0.100715517300559659E+06,
        0.100759196447210823E+06,       0.100798644466533326E+06,       0.100834218092755124E+06,       0.100864022068452279E+06,       0.100886844670119492E+06,
        0.100903072952249466E+06,       0.100910324635737983E+06,       0.100907110564502160E+06,       0.100894913649374212E+06,       0.100873485872527890E+06,
        0.100847908218072756E+06,       0.100825028815845202E+06,       0.100812235195442801E+06,       0.100811789392154620E+06,       0.100821477468724654E+06,
        0.100842188280174509E+06,       0.100874882105417564E+06,       0.100910352034741096E+06,       0.100944613694273561E+06,       0.100970573806106200E+06,
        0.100992876564753780E+06,       0.101010256709896377E+06,       0.101017365734439736E+06,       0.101004642180764087E+06,       0.100981216767300502E+06,
        0.100950670557522288E+06,       0.100918693714911191E+06,       0.100893168282002865E+06,       0.100873786774855747E+06,       0.100862092518860401E+06,
        0.100858765389723776E+06,       0.100863848594959985E+06,       0.100872455106490743E+06,       0.100880727391939872E+06,       0.100881060958518239E+06,
        0.100871581642927995E+06,       0.100854982629453050E+06,       0.100833968938175327E+06,       0.100809126941723182E+06,       0.100777926015906574E+06,
        0.100744862813125714E+06,       0.100711030659190204E+06,       0.100674920663551122E+06,       0.100638665812651045E+06,       0.100604613640158801E+06,
        0.100577951755037328E+06,       0.100565299257314167E+06,       0.100564490794773781E+06,       0.100574070775104672E+06,       0.100592267906427369E+06,
        0.100616576592620535E+06,       0.100643954138155808E+06,       0.100661679785274406E+06,       0.100676519993234426E+06,       0.100692101751513052E+06,
        0.100708845098980164E+06,       0.100726890359751837E+06,       0.100746088291053093E+06,       0.100766274118497415E+06,       0.100790485020117267E+06,
        0.100814283052694198E+06,       0.100836998900601233E+06,       0.100857834251143926E+06,       0.101239951294366925E+06,       0.101243511198018721E+06,
        0.101248266604097182E+06,       0.101254120739513630E+06,       0.101260940255995316E+06,       0.101268566543099048E+06,       0.101276830453567702E+06,
        0.101285622454819968E+06,       0.101294523809254446E+06,       0.101303237484829937E+06,       0.101311620976720500E+06,       0.101319644374765689E+06,
        0.101327259549206297E+06,       0.101334480948853117E+06,       0.101341388354789131E+06,       0.101348710884544664E+06,       0.101356521517190282E+06,
        0.101364093945627537E+06,       0.101371621643877312E+06,       0.101379408199202080E+06,       0.101388443315429948E+06,       0.101401687552132498E+06,
        0.101416572004818678E+06,       0.101433189992554107E+06,       0.101451428970825116E+06,       0.101470024045938291E+06,       0.101488255659360628E+06,
        0.101505416028128879E+06,       0.101520868917434069E+06,       0.101531842805264969E+06,       0.101539245769958565E+06,       0.101544605958666289E+06,
        0.101548569302459247E+06,       0.101551134535491103E+06,       0.101552518676128384E+06,       0.101552933361419549E+06,       0.101552598628048305E+06,
        0.101551346091754502E+06,       0.101549620534837697E+06,       0.101548503290274006E+06,       0.101548531268210281E+06,       0.101550086213979870E+06,
        0.101553415865284071E+06,       0.101558574308658994E+06,       0.101566141420655156E+06,       0.101575323430362041E+06,       0.101584790524686381E+06,
        0.101594148506046142E+06,       0.101603272905442951E+06,       0.101611945735174741E+06,       0.101619979003416622E+06,       0.101627204805596586E+06,
        0.101634427668451928E+06,       0.101641404911077247E+06,       0.101648381901037224E+06,       0.101655340222651532E+06,       0.101662034474683896E+06,
        0.101666783103935741E+06,       0.101669591715802919E+06,       0.101672592019255666E+06,       0.101674896474706766E+06,       0.101676486613950226E+06,
        0.101677173545713507E+06,       0.101676735064566892E+06,       0.101674421820609132E+06,       0.101671063643987713E+06,       0.101668202552547300E+06,
        0.101666520557556054E+06,       0.101666348434875123E+06,       0.101667923680669555E+06,       0.101669351667803800E+06,       0.101668978131977754E+06,
        0.101666110028333933E+06,       0.101660538752964931E+06,       0.101654594444694463E+06,       0.101645738692219165E+06,       0.101634351733125281E+06,
        0.101619445806351592E+06,       0.101597486529762551E+06,       0.101566963080607631E+06,       0.101526313623151611E+06,       0.101474414132893216E+06,
        0.101408806070782084E+06,       0.101334676336432865E+06,       0.101255967485764850E+06,       0.101177930379907673E+06,       0.101105923487214692E+06,
        0.101041528067973224E+06,       0.100984421243628807E+06,       0.100931366999700622E+06,       0.100882259035952666E+06,       0.100834318510275116E+06,
        0.100780975023316409E+06,       0.100725029283105585E+06,       0.100672125573187601E+06,       0.100626333648281943E+06,       0.100591108252538659E+06,
        0.100571154519613207E+06,       0.100572764811242494E+06,       0.100590644123334263E+06,       0.100622114840101916E+06,       0.100663170419413218E+06,
        0.100711109304953105E+06,       0.100759450274770090E+06,       0.100803668821019484E+06,       0.100843723009858411E+06,       0.100878065056743988E+06,
        0.100905193898488564E+06,       0.100924238150348683E+06,       0.100935705112497482E+06,       0.100940040808540827E+06,       0.100938611611957211E+06,
        0.100929132041696241E+06,       0.100917754954705204E+06,       0.100905818223427166E+06,       0.100905472653716875E+06,       0.100913513200435162E+06,
        0.100929234171202479E+06,       0.100956672791980032E+06,       0.100989933744260285E+06,       0.101021721049159081E+06,       0.101045261345619481E+06,
        0.101056484086316414E+06,       0.101064376750130497E+06,       0.101068662292293593E+06,       0.101058850049314118E+06,       0.101036734626105259E+06,
        0.101005396099047648E+06,       0.100967551751069492E+06,       0.100930584068150943E+06,       0.100895049839971194E+06,       0.100865689126530953E+06,
        0.100843766391791884E+06,       0.100833519035555830E+06,       0.100830429319700765E+06,       0.100830534716874317E+06,       0.100831218872075027E+06,
        0.100828733033744793E+06,       0.100816736999957517E+06,       0.100801115692818625E+06,       0.100782650624359696E+06,       0.100761638271208169E+06,
        0.100739079948099330E+06,       0.100715508303584225E+06,       0.100685570121976882E+06,       0.100651926936336182E+06,       0.100616808436076797E+06,
        0.100582738088950529E+06,       0.100553609533300842E+06,       0.100536151852068826E+06,       0.100533191840017098E+06,       0.100540563795043839E+06,
        0.100556547268302660E+06,       0.100578647827983019E+06,       0.100597845282151320E+06,       0.100615643951716338E+06,       0.100629644958407152E+06,
        0.100644649717624998E+06,       0.100661314686951257E+06,       0.100679739011681770E+06,       0.100699923738231213E+06,       0.100724000291545439E+06,
        0.100748935934403649E+06,       0.100773460147275109E+06,       0.100796886100017015E+06,       0.100818431742268527E+06,       0.101253250319671861E+06,
        0.101258941275491015E+06,       0.101265825984074268E+06,       0.101273785992740712E+06,       0.101282673338371926E+06,       0.101292322337458594E+06,
        0.101302564811119126E+06,       0.101313249084015886E+06,       0.101324039732978374E+06,       0.101334420443956798E+06,       0.101344441355969844E+06,
        0.101353937804033951E+06,       0.101362853548466621E+06,       0.101371239996888005E+06,       0.101379195223571107E+06,       0.101386868114858662E+06,
        0.101394863418320267E+06,       0.101403421459721620E+06,       0.101411971625535502E+06,       0.101421328676152989E+06,       0.101434052612144369E+06,
        0.101448448578493975E+06,       0.101464428560022046E+06,       0.101481780318751698E+06,       0.101500377161328623E+06,       0.101519861969620310E+06,
        0.101538794301281392E+06,       0.101556432572582416E+06,       0.101569913275213607E+06,       0.101580111679331065E+06,       0.101588077608188687E+06,
        0.101593761388586005E+06,       0.101597743292873696E+06,       0.101601111211300595E+06,       0.101603375473686290E+06,       0.101604722386775393E+06,
        0.101605277974446421E+06,       0.101605137189286179E+06,       0.101604583774228318E+06,       0.101604027662526438E+06,       0.101605032612257637E+06,
        0.101607890648949600E+06,       0.101612610274943596E+06,       0.101620190413487217E+06,       0.101629709918692257E+06,       0.101640274485895483E+06,
        0.101651366271263018E+06,       0.101662017372317307E+06,       0.101672127532921921E+06,       0.101681639836175294E+06,       0.101689695653715113E+06,
        0.101697371401130935E+06,       0.101704816287710346E+06,       0.101711959261812881E+06,       0.101718592829194225E+06,       0.101724976617920722E+06,
        0.101729049321389990E+06,       0.101731107282530153E+06,       0.101732743234520705E+06,       0.101734177642089810E+06,       0.101735792298410903E+06,
        0.101737051523103568E+06,       0.101737813506062157E+06,       0.101737771770358304E+06,       0.101736766611527375E+06,       0.101733998643601444E+06,
        0.101731285447018498E+06,       0.101729657615879667E+06,       0.101729463824108592E+06,       0.101730467776220365E+06,       0.101730634889909721E+06,
        0.101728530424326527E+06,       0.101723478773003560E+06,       0.101715128998538450E+06,       0.101705173881448645E+06,       0.101697065128410613E+06,
        0.101686174729378530E+06,       0.101670746397321127E+06,       0.101648602916028351E+06,       0.101617289856162359E+06,       0.101575677936215157E+06,
        0.101523549414822643E+06,       0.101459384090740117E+06,       0.101385766535040675E+06,       0.101307806220871105E+06,       0.101230532040925333E+06,
        0.101163615695121596E+06,       0.101105144301163149E+06,       0.101053953064553687E+06,       0.101004506092646785E+06,       0.100954394425546445E+06,
        0.100903265851270029E+06,       0.100843568326323351E+06,       0.100779909310060830E+06,       0.100718507897475429E+06,       0.100663227538561507E+06,
        0.100619196470881463E+06,       0.100590878309716514E+06,       0.100585918330994056E+06,       0.100599670235220139E+06,       0.100629367268692309E+06,
        0.100671559948193928E+06,       0.100722625470161831E+06,       0.100775876461740903E+06,       0.100826307692812305E+06,       0.100872731273009820E+06,
        0.100911769660482067E+06,       0.100942401025764135E+06,       0.100964392752327054E+06,       0.100978678374194351E+06,       0.100986716960824007E+06,
        0.100990258819483715E+06,       0.100986859094204920E+06,       0.100984358423690996E+06,       0.100986880945730183E+06,       0.101001308030144719E+06,
        0.101021911204537639E+06,       0.101045314756852677E+06,       0.101079374563270016E+06,       0.101112057664106265E+06,       0.101138492426304845E+06,
        0.101147264582452117E+06,       0.101146181575950890E+06,       0.101139597898295426E+06,       0.101126956426191653E+06,       0.101104207044017559E+06,
        0.101074184746976593E+06,       0.101036351784390296E+06,       0.100994839802225833E+06,       0.100951701131987342E+06,       0.100907802015808338E+06,
        0.100866623322513595E+06,       0.100836261177509557E+06,       0.100817609325104844E+06,       0.100806057949370603E+06,       0.100799101756952587E+06,
        0.100794178922864405E+06,       0.100782586521973222E+06,       0.100770278560914870E+06,       0.100755730874395027E+06,       0.100740174567162278E+06,
        0.100724221891415305E+06,       0.100711960802472036E+06,       0.100695201938734870E+06,       0.100670904548085469E+06,       0.100639130264881242E+06,
        0.100604667725497551E+06,       0.100569533181772116E+06,       0.100538827586813903E+06,       0.100515863557522040E+06,       0.100504283432544311E+06,
        0.100508208880423437E+06,       0.100520846592849106E+06,       0.100533319890499857E+06,       0.100546979620563667E+06,       0.100563406036921282E+06,
        0.100581336883139578E+06,       0.100596479945475046E+06,       0.100613263609396352E+06,       0.100632606505272503E+06,       0.100655737101977575E+06,
        0.100680377627359165E+06,       0.100705693019706334E+06,       0.100730567542817560E+06,       0.100753963268230000E+06,       0.100775475443369112E+06,
        0.101264306669592683E+06,       0.101273005643247234E+06,       0.101282212261941575E+06,       0.101292455230279535E+06,       0.101303569666892407E+06,
        0.101315379627821021E+06,       0.101327713762651794E+06,       0.101340424766245633E+06,       0.101353413011349316E+06,       0.101366215214067837E+06,
        0.101378003241061873E+06,       0.101389048142805594E+06,       0.101399358057326695E+06,       0.101408993909155237E+06,       0.101418071350073515E+06,
        0.101426765747085621E+06,       0.101435320572288721E+06,       0.101444230417056518E+06,       0.101454115342003613E+06,       0.101466281775386233E+06,
        0.101480018815107192E+06,       0.101495370152025978E+06,       0.101512249092142942E+06,       0.101530457200416044E+06,       0.101549717357720714E+06,
        0.101569710093644739E+06,       0.101589282549966229E+06,       0.101605011230739328E+06,       0.101617835360473735E+06,       0.101628768238586897E+06,
        0.101637571031423722E+06,       0.101644166338589697E+06,       0.101648697806602591E+06,       0.101651881208006424E+06,       0.101655220484862148E+06,
        0.101657859335835557E+06,       0.101659761085947117E+06,       0.101661032940759702E+06,       0.101661921699332699E+06,       0.101662809971163108E+06,
        0.101664227024246793E+06,       0.101667989933228542E+06,       0.101675508452427108E+06,       0.101685268933038969E+06,       0.101696374945899413E+06,
        0.101708376350831662E+06,       0.101720741353243910E+06,       0.101732914311869565E+06,       0.101744191311434886E+06,       0.101753679207339199E+06,
        0.101762383198229145E+06,       0.101770484632283566E+06,       0.101778058653469430E+06,       0.101785052189110153E+06,       0.101791286685933344E+06,
        0.101795171487182030E+06,       0.101797156941597103E+06,       0.101798421280143026E+06,       0.101799261614609830E+06,       0.101799803038408485E+06,
        0.101800210895802447E+06,       0.101801683280290250E+06,       0.101802630829050468E+06,       0.101802543397740184E+06,       0.101801482357017914E+06,
        0.101799624587932572E+06,       0.101797066559983883E+06,       0.101795799625004249E+06,       0.101795785922852519E+06,       0.101796374037248344E+06,
        0.101796548441705847E+06,       0.101793091799900605E+06,       0.101786346983049574E+06,       0.101776575607877137E+06,       0.101765049283969143E+06,
        0.101754303368654233E+06,       0.101742481241294314E+06,       0.101726517364683619E+06,       0.101704526213350880E+06,       0.101673251963278643E+06,
        0.101631549642581842E+06,       0.101579630218674371E+06,       0.101517751331919892E+06,       0.101445587957413649E+06,       0.101369276534187840E+06,
        0.101293749197962985E+06,       0.101228845743408630E+06,       0.101175974072217723E+06,       0.101128069068520213E+06,       0.101080672101220363E+06,
        0.101030554297062597E+06,       0.100978255877595599E+06,       0.100917786384446328E+06,       0.100848380590802917E+06,       0.100779685419598463E+06,
        0.100716993576480047E+06,       0.100665449877585226E+06,       0.100628730188585745E+06,       0.100616768912061103E+06,       0.100625017647516172E+06,
        0.100651010955717982E+06,       0.100693983128488617E+06,       0.100748028718061119E+06,       0.100807126354548294E+06,       0.100865743222122503E+06,
        0.100920280263948240E+06,       0.100963697339721592E+06,       0.100996625031755175E+06,       0.101020588466931018E+06,       0.101034801756696354E+06,
        0.101044107550953762E+06,       0.101050001068824189E+06,       0.101053046373654055E+06,       0.101058552912032319E+06,       0.101072171257776601E+06,
        0.101095588999532294E+06,       0.101124462408449937E+06,       0.101159998252541394E+06,       0.101199939829214418E+06,       0.101233511940909040E+06,
        0.101250548981260363E+06,       0.101245238633873159E+06,       0.101231967019851887E+06,       0.101212524735667932E+06,       0.101187116747768814E+06,
        0.101155254569723096E+06,       0.101117728069520774E+06,       0.101075849861174778E+06,       0.101031454770778844E+06,       0.100982633468066182E+06,
        0.100931817382534617E+06,       0.100883044212189372E+06,       0.100842431678571462E+06,       0.100810753030772234E+06,       0.100790307235783985E+06,
        0.100775641660991605E+06,       0.100758065719658363E+06,       0.100742431929372280E+06,       0.100730276589137924E+06,       0.100719950891765460E+06,
        0.100707897196450547E+06,       0.100704034450479885E+06,       0.100696304475012279E+06,       0.100682955042842383E+06,       0.100662970635189646E+06,
        0.100635257255516670E+06,       0.100598919177042175E+06,       0.100561998994079375E+06,       0.100529207116205667E+06,       0.100503120931424841E+06,
        0.100485371253469493E+06,       0.100478084387816067E+06,       0.100480161528695491E+06,       0.100486330170588408E+06,       0.100497656033703854E+06,
        0.100512793940874559E+06,       0.100530267502319883E+06,       0.100548674998529634E+06,       0.100566870164484106E+06,       0.100588713074028346E+06,
        0.100612035752629497E+06,       0.100636570551070865E+06,       0.100661555413946771E+06,       0.100685975940573393E+06,       0.100708805081237850E+06,
        0.100728426698084644E+06,       0.101271996036762896E+06,       0.101284449704480561E+06,       0.101296689346213228E+06,       0.101309400454198360E+06,
        0.101322901055611903E+06,       0.101337001192974072E+06,       0.101351521575208899E+06,       0.101366313393139906E+06,       0.101382034494546009E+06,
        0.101397351776588475E+06,       0.101411443443270473E+06,       0.101424117470686309E+06,       0.101435883616085790E+06,       0.101446811616959909E+06,
        0.101457033181746156E+06,       0.101466747751913790E+06,       0.101476231696805597E+06,       0.101486021283400187E+06,       0.101497396375811921E+06,
        0.101510400207985600E+06,       0.101524923388815208E+06,       0.101540994381505661E+06,       0.101558520228044814E+06,       0.101577305318149651E+06,
        0.101597084529118074E+06,       0.101617572913645636E+06,       0.101635935716414897E+06,       0.101650985317801838E+06,       0.101664666828709975E+06,
        0.101676613583561295E+06,       0.101686531498022989E+06,       0.101694300750966708E+06,       0.101700039232711759E+06,       0.101704155496819658E+06,
        0.101707559871844016E+06,       0.101711706616868032E+06,       0.101715220819953611E+06,       0.101718183769718671E+06,       0.101720797579619655E+06,
        0.101723413797095534E+06,       0.101726548168837966E+06,       0.101732421109602874E+06,       0.101741180387240456E+06,       0.101752626090808626E+06,
        0.101765327683930620E+06,       0.101778794125947126E+06,       0.101792465254962983E+06,       0.101805759257347163E+06,       0.101817578749370528E+06,
        0.101828002210067600E+06,       0.101837310759124710E+06,       0.101845770211075462E+06,       0.101853420566787143E+06,       0.101860181736826940E+06,
        0.101864213062694500E+06,       0.101866574115216965E+06,       0.101867875008511299E+06,       0.101868524705411764E+06,       0.101868825959176160E+06,
        0.101868919433276926E+06,       0.101869678539425964E+06,       0.101870695483190138E+06,       0.101871330785532584E+06,       0.101870979213963699E+06,
        0.101869675931957303E+06,       0.101867574002842535E+06,       0.101865625644742016E+06,       0.101864444239763863E+06,       0.101864129871809724E+06,
        0.101864253411905665E+06,       0.101863863423935647E+06,       0.101861147095331355E+06,       0.101853046503827805E+06,       0.101842469691830149E+06,
        0.101829793173113096E+06,       0.101815148158582204E+06,       0.101801721489973846E+06,       0.101784969966993638E+06,       0.101762516553084497E+06,
        0.101733198141890345E+06,       0.101692387931239413E+06,       0.101641579160683832E+06,       0.101581604629232388E+06,       0.101513447361368249E+06,
        0.101440920474624741E+06,       0.101370696075984946E+06,       0.101305428265875380E+06,       0.101254160309156374E+06,       0.101207383873920160E+06,
        0.101161789898628529E+06,       0.101111489873579616E+06,       0.101058073620173833E+06,       0.100998431410120465E+06,       0.100925178881860134E+06,
        0.100851277940204382E+06,       0.100782887728638991E+06,       0.100724637342850445E+06,       0.100681654247053943E+06,       0.100660743763258797E+06,
        0.100662241191619672E+06,       0.100684600997945701E+06,       0.100726431789378737E+06,       0.100783621753223240E+06,       0.100850165592330639E+06,
        0.100919393459606828E+06,       0.100984663126731160E+06,       0.101035581217426865E+06,       0.101073289555574971E+06,       0.101097883508170984E+06,
        0.101109275635634360E+06,       0.101115535689499287E+06,       0.101120721213043289E+06,       0.101127445332507938E+06,       0.101138555650677066E+06,
        0.101162386128591490E+06,       0.101193764958060041E+06,       0.101229324100487633E+06,       0.101272586038755646E+06,       0.101314017050708091E+06,
        0.101345307647537833E+06,       0.101350681405921583E+06,       0.101336274552223433E+06,       0.101312002659208913E+06,       0.101282108941999220E+06,
        0.101247511268828879E+06,       0.101208775326433519E+06,       0.101166118942493005E+06,       0.101124324087716755E+06,       0.101077097855417393E+06,
        0.101023493736806588E+06,       0.100966370678116829E+06,       0.100910649732596605E+06,       0.100860956183662900E+06,       0.100818859583747035E+06,
        0.100784487610509677E+06,       0.100755633857502806E+06,       0.100730268695456398E+06,       0.100710865638861083E+06,       0.100697679049610029E+06,
        0.100690061794109570E+06,       0.100696089852752222E+06,       0.100696921102593260E+06,       0.100692632540626320E+06,       0.100681762801710865E+06,
        0.100663264802660036E+06,       0.100633791904004815E+06,       0.100597430688150896E+06,       0.100559133196241281E+06,       0.100524051576254133E+06,
        0.100494743325319461E+06,       0.100472843717532320E+06,       0.100453469270866597E+06,       0.100441938855850953E+06,       0.100444602587366870E+06,
        0.100453700278505523E+06,       0.100467703647186674E+06,       0.100484865751373640E+06,       0.100504556800278908E+06,       0.100526747147881411E+06,
        0.100548342492759344E+06,       0.100570928110482331E+06,       0.100594499129673175E+06,       0.100618314768352022E+06,       0.100641358389098648E+06,
        0.100661048545089099E+06,       0.100674922441404182E+06,       0.101277440454925483E+06,       0.101292275045881630E+06,       0.101308217918252703E+06,
        0.101324032641650105E+06,       0.101340083417949048E+06,       0.101356599817204507E+06,       0.101373389242319026E+06,       0.101391680572806275E+06,
        0.101409655246696246E+06,       0.101426966070523806E+06,       0.101443353143514600E+06,       0.101458277199001546E+06,       0.101471528522387307E+06,
        0.101483748681189623E+06,       0.101495083125874895E+06,       0.101505752090554262E+06,       0.101516050089151657E+06,       0.101526815975076141E+06,
        0.101538795327266271E+06,       0.101552338028206417E+06,       0.101567404995926277E+06,       0.101583932457588046E+06,       0.101601812845274559E+06,
        0.101620841504076889E+06,       0.101640749378202716E+06,       0.101659290500403222E+06,       0.101676771795349603E+06,       0.101693884723980591E+06,
        0.101708998663612001E+06,       0.101722276078936207E+06,       0.101733606252533034E+06,       0.101742808520292456E+06,       0.101749958233873534E+06,
        0.101756733187784732E+06,       0.101761976313215302E+06,       0.101765600227458519E+06,       0.101770624962746049E+06,       0.101775587804667244E+06,
        0.101780223730697457E+06,       0.101784845963681015E+06,       0.101792019560120360E+06,       0.101800861910829000E+06,       0.101810238167576026E+06,
        0.101821334626365482E+06,       0.101835649384848730E+06,       0.101850599319270405E+06,       0.101865571025550424E+06,       0.101879726510542314E+06,
        0.101892673462390783E+06,       0.101903975174055988E+06,       0.101913651691837455E+06,       0.101922403262289721E+06,       0.101930066269132934E+06,
        0.101934959838625931E+06,       0.101938013574382479E+06,       0.101939867945920269E+06,       0.101940768404829549E+06,       0.101940976512875422E+06,
        0.101940974808985324E+06,       0.101941915218950715E+06,       0.101942796779357042E+06,       0.101943325071244180E+06,       0.101943321289824438E+06,
        0.101942520685581403E+06,       0.101940795734215877E+06,       0.101938328485986989E+06,       0.101936102913573559E+06,       0.101934189161022412E+06,
        0.101933270983365946E+06,       0.101932726854111810E+06,       0.101931071080041162E+06,       0.101927390375963005E+06,       0.101920782487591568E+06,
        0.101909599976852041E+06,       0.101896034018928112E+06,       0.101880121030327078E+06,       0.101861777722108454E+06,       0.101843441866567693E+06,
        0.101821175828396939E+06,       0.101793162871491804E+06,       0.101756243381197477E+06,       0.101707526053893132E+06,       0.101651390637597418E+06,
        0.101591096250860501E+06,       0.101525066978488496E+06,       0.101457842460151805E+06,       0.101392749867658815E+06,       0.101338205739929384E+06,
        0.101290789521037383E+06,       0.101243732978547458E+06,       0.101191560328100386E+06,       0.101135333560209707E+06,       0.101074991868799916E+06,
        0.101002789603246347E+06,       0.100928035016280875E+06,       0.100857779212484500E+06,       0.100794984785666602E+06,       0.100746221294778152E+06,
        0.100717266126841918E+06,       0.100710869212579069E+06,       0.100726313373954297E+06,       0.100765862955971417E+06,       0.100824009621681325E+06,
        0.100896074483335498E+06,       0.100975156087370415E+06,       0.101050862045185830E+06,       0.101108616996395343E+06,       0.101151397540630162E+06,
        0.101177118649863274E+06,       0.101187234876946401E+06,       0.101192189574432836E+06,       0.101198920872520132E+06,       0.101209271572763842E+06,
        0.101225853188380381E+06,       0.101255763867716960E+06,       0.101292205782835576E+06,       0.101333769433737034E+06,       0.101380487686360808E+06,
        0.101421196585383368E+06,       0.101445943578677994E+06,       0.101442593076884281E+06,       0.101422753739062216E+06,       0.101390520324852318E+06,
        0.101350761888702051E+06,       0.101308120360709363E+06,       0.101265074031475204E+06,       0.101223556150358476E+06,       0.101181059083197164E+06,
        0.101131282154724337E+06,       0.101073985674786556E+06,       0.101009316519365500E+06,       0.100945620806578852E+06,       0.100887564966803198E+06,
        0.100836870701820939E+06,       0.100791306568270127E+06,       0.100748587002241606E+06,       0.100714275195360678E+06,       0.100691096015225994E+06,
        0.100677036214206237E+06,       0.100679656532840978E+06,       0.100689403954963505E+06,       0.100699806241966638E+06,       0.100699758014009334E+06,
        0.100690385161567290E+06,       0.100668712287826143E+06,       0.100636906386880102E+06,       0.100599766534639755E+06,       0.100560426804608782E+06,
        0.100523011227441762E+06,       0.100490487333571364E+06,       0.100458484377625064E+06,       0.100433836484664062E+06,       0.100418321599970062E+06,
        0.100412076649917391E+06,       0.100419080629848453E+06,       0.100432241000389156E+06,       0.100450792482229837E+06,       0.100472305642769512E+06,
        0.100493869619492121E+06,       0.100514430080734746E+06,       0.100535036793476407E+06,       0.100556629184451856E+06,       0.100578314394928922E+06,
        0.100596991295179905E+06,       0.100611500340730694E+06,       0.100623274306907668E+06,       0.101280196625301396E+06,       0.101297364868656936E+06,
        0.101315860426329833E+06,       0.101335437548964052E+06,       0.101354738212366676E+06,       0.101373945822871654E+06,       0.101394704590563779E+06,
        0.101415369573864707E+06,       0.101435547066077095E+06,       0.101454900560777067E+06,       0.101473156717428967E+06,       0.101490111858949429E+06,
        0.101505426648419336E+06,       0.101518896733282789E+06,       0.101531260767964472E+06,       0.101542531309453814E+06,       0.101553164954199878E+06,
        0.101564411925864319E+06,       0.101576767311889984E+06,       0.101590613786174377E+06,       0.101606186426911474E+06,       0.101622949542643095E+06,
        0.101640870734518088E+06,       0.101659778611533140E+06,       0.101677671599300767E+06,       0.101695145189232746E+06,       0.101713022490742442E+06,
        0.101730968458130665E+06,       0.101748633328473559E+06,       0.101764332593418454E+06,       0.101777415582760368E+06,       0.101788327636173344E+06,
        0.101798745459491343E+06,       0.101807854686651277E+06,       0.101815215507054876E+06,       0.101821043040616947E+06,       0.101825884968623417E+06,
        0.101832189148969264E+06,       0.101839168448648401E+06,       0.101848045440598347E+06,       0.101858730804693652E+06,       0.101869959329435806E+06,
        0.101881533268110448E+06,       0.101893454722194554E+06,       0.101906437265534973E+06,       0.101922905509709031E+06,       0.101939197745689977E+06,
        0.101954795923734462E+06,       0.101969009671704334E+06,       0.101981310726737574E+06,       0.101991415766123711E+06,       0.101999594743156573E+06,
        0.102005976491342561E+06,       0.102010334316063047E+06,       0.102013157295944911E+06,       0.102014722383416287E+06,       0.102015313093490025E+06,
        0.102015201185307524E+06,       0.102016512237083880E+06,       0.102017510782104568E+06,       0.102018055903560264E+06,       0.102018084579591843E+06,
        0.102017466339170613E+06,       0.102015842014936527E+06,       0.102013009808558825E+06,       0.102010188377710918E+06,       0.102007504920719613E+06,
        0.102004842449303280E+06,       0.102002010784629019E+06,       0.101999472815438930E+06,       0.101995912864510945E+06,       0.101991527724094442E+06,
        0.101985699759707655E+06,       0.101975812995855114E+06,       0.101961537246313150E+06,       0.101943695019863866E+06,       0.101923033375715851E+06,
        0.101901362121280530E+06,       0.101879075837123033E+06,       0.101852284874085046E+06,       0.101819539147717020E+06,       0.101776999589703846E+06,
        0.101726785900868257E+06,       0.101671557646898407E+06,       0.101612042588822980E+06,       0.101548622762663115E+06,       0.101485284216076703E+06,
        0.101425147441038411E+06,       0.101373420817102917E+06,       0.101321191476503751E+06,       0.101266538752380700E+06,       0.101208938335707280E+06,
        0.101148533319442722E+06,       0.101080582757091557E+06,       0.101007172321080754E+06,       0.100937106866050381E+06,       0.100872650853732252E+06,
        0.100818490092161403E+06,       0.100780581038449120E+06,       0.100763989069985822E+06,       0.100769172528104478E+06,       0.100801781036641652E+06,
        0.100856282722816642E+06,       0.100929221528193739E+06,       0.101013884730459817E+06,       0.101097563707576744E+06,       0.101162534274172547E+06,
        0.101213486478638646E+06,       0.101244516559525029E+06,       0.101257648408437890E+06,       0.101263733502884890E+06,       0.101275510052246449E+06,
        0.101290762661853529E+06,       0.101314197491016195E+06,       0.101347943558257903E+06,       0.101386651316440679E+06,       0.101430443429601510E+06,
        0.101475669896804160E+06,       0.101514950055520574E+06,       0.101531515938051540E+06,       0.101524788957272292E+06,       0.101501664340208648E+06,
        0.101465580088908755E+06,       0.101421732802947983E+06,       0.101374184582676520E+06,       0.101328046898908578E+06,       0.101289807901878230E+06,
        0.101246491413997268E+06,       0.101194778317482283E+06,       0.101131646224091921E+06,       0.101060205833383836E+06,       0.100988174374432070E+06,
        0.100922370979696687E+06,       0.100863854824209222E+06,       0.100809964699915654E+06,       0.100761271524313197E+06,       0.100719104259046479E+06,
        0.100686430395430245E+06,       0.100678847862221184E+06,       0.100683138663107515E+06,       0.100693073794055832E+06,       0.100704133264039236E+06,
        0.100711587564049987E+06,       0.100702838554374641E+06,       0.100679156446423745E+06,       0.100646910483054933E+06,       0.100608627281804467E+06,
        0.100567412671928309E+06,       0.100526528285293534E+06,       0.100483943399388023E+06,       0.100448443665773972E+06,       0.100421899539395425E+06,
        0.100404924203073868E+06,       0.100397063255380912E+06,       0.100397195586259491E+06,       0.100412985650041403E+06,       0.100432834475288488E+06,
        0.100453366207182436E+06,       0.100473356439391355E+06,       0.100491742373035304E+06,       0.100507905429383289E+06,       0.100525814076571885E+06,
        0.100542096974396103E+06,       0.100555812166254138E+06,       0.100567395231908740E+06,       0.100576579149565121E+06,       0.101279908089260382E+06,
        0.101299372851355220E+06,       0.101320345227797603E+06,       0.101342568251312987E+06,       0.101366203167707048E+06,       0.101390159455080997E+06,
        0.101413541104309363E+06,       0.101436670068180945E+06,       0.101459134145086064E+06,       0.101480579621756508E+06,       0.101500717501762701E+06,
        0.101519330301993643E+06,       0.101536279443531355E+06,       0.101551434684382868E+06,       0.101564255195383463E+06,       0.101575422887434994E+06,
        0.101586445548099669E+06,       0.101597902131166629E+06,       0.101610316943178666E+06,       0.101624105975331244E+06,       0.101639540620591506E+06,
        0.101656731770743747E+06,       0.101674690803331439E+06,       0.101691335236531100E+06,       0.101707821449698851E+06,       0.101725245164068649E+06,
        0.101743396815362881E+06,       0.101762005533747782E+06,       0.101780794703432257E+06,       0.101799566956391791E+06,       0.101816729089967106E+06,
        0.101830810115947446E+06,       0.101843847767199652E+06,       0.101855309960108818E+06,       0.101865083082604426E+06,       0.101873349177960990E+06,
        0.101880647099664595E+06,       0.101887932618480903E+06,       0.101897799286328358E+06,       0.101910318475203370E+06,       0.101923741945953618E+06,
        0.101937617512615703E+06,       0.101951634884124011E+06,       0.101965709346062926E+06,       0.101980052214833602E+06,       0.101995075682068244E+06,
        0.102012705906177565E+06,       0.102029916826673259E+06,       0.102045578980748891E+06,       0.102059048316380504E+06,       0.102069947174644665E+06,
        0.102077684357740349E+06,       0.102082147312762972E+06,       0.102086500261915091E+06,       0.102089248935513198E+06,       0.102090698933738371E+06,
        0.102091178364924752E+06,       0.102092701245381337E+06,       0.102093815457381104E+06,       0.102094368575754212E+06,       0.102094331459262947E+06,
        0.102093649378548696E+06,       0.102091495160413397E+06,       0.102088077118329078E+06,       0.102085266715555787E+06,       0.102082068081696532E+06,
        0.102078934857918081E+06,       0.102075562114887900E+06,       0.102070631820974115E+06,       0.102064438122544176E+06,       0.102059414174384161E+06,
        0.102053827822841413E+06,       0.102047097203453392E+06,       0.102038205276517619E+06,       0.102023970080276820E+06,       0.102005255572377879E+06,
        0.101983545280989390E+06,       0.101959239559772468E+06,       0.101934934813177606E+06,       0.101909416211695381E+06,       0.101879530216405619E+06,
        0.101843729384204227E+06,       0.101798771374156902E+06,       0.101749131431232046E+06,       0.101696435747962270E+06,       0.101638597439857098E+06,
        0.101576958615739393E+06,       0.101514239708325505E+06,       0.101456190833159548E+06,       0.101399554349585407E+06,       0.101340424142701784E+06,
        0.101280446676456311E+06,       0.101219442303719290E+06,       0.101155802903883246E+06,       0.101085010925495619E+06,       0.101016127520053677E+06,
        0.100949559692596478E+06,       0.100889898302085116E+06,       0.100844209040313392E+06,       0.100816129681629769E+06,       0.100810501379105452E+06,
        0.100832591111220638E+06,       0.100879523722449056E+06,       0.100948063089510324E+06,       0.101031460853947981E+06,       0.101115973986060417E+06,
        0.101184231818201646E+06,       0.101240245990651732E+06,       0.101276004337181133E+06,       0.101297693264287940E+06,       0.101316108838536718E+06,
        0.101339338207326771E+06,       0.101364838726589573E+06,       0.101398212697034352E+06,       0.101435020262566584E+06,       0.101474120214935858E+06,
        0.101515374742090018E+06,       0.101554913896900893E+06,       0.101585525309637247E+06,       0.101596313029333352E+06,       0.101591763310596391E+06,
        0.101572063905601564E+06,       0.101533915795807872E+06,       0.101488864498615381E+06,       0.101440950048410057E+06,       0.101401964815710235E+06,
        0.101362939393266570E+06,       0.101319118725317487E+06,       0.101264253224874032E+06,       0.101194604583161839E+06,       0.101119529697804493E+06,
        0.101043148821796305E+06,       0.100969817218776385E+06,       0.100904222807714512E+06,       0.100845424566366739E+06,       0.100792297539129795E+06,
        0.100746429506127941E+06,       0.100716119483396033E+06,       0.100699086889567552E+06,       0.100699855109205411E+06,       0.100707310375888119E+06,
        0.100716570575528633E+06,       0.100720007898216936E+06,       0.100714797932772417E+06,       0.100695727134459230E+06,       0.100662985850684985E+06,
        0.100623495462979961E+06,       0.100579571082265902E+06,       0.100528287659914175E+06,       0.100483047690553038E+06,       0.100446858129451386E+06,
        0.100420432087088702E+06,       0.100404117469529898E+06,       0.100397105480157465E+06,       0.100403234638665162E+06,       0.100415020179178769E+06,
        0.100433067114222082E+06,       0.100451452530888302E+06,       0.100468854497717490E+06,       0.100484113018387754E+06,       0.100496513635322510E+06,
        0.100504396642556661E+06,       0.100514796346128511E+06,       0.100524493045942218E+06,       0.100532404153307187E+06,       0.100538289704171490E+06,
        0.101276336252575435E+06,       0.101298080414544456E+06,       0.101321469561098274E+06,       0.101347127563797287E+06,       0.101375017595738012E+06,
        0.101402741686854177E+06,       0.101429372639699533E+06,       0.101455094154428705E+06,       0.101479936738935212E+06,       0.101503527247806051E+06,
        0.101525558424067625E+06,       0.101545795970329476E+06,       0.101564086253569083E+06,       0.101579860400036196E+06,       0.101592656313919491E+06,
        0.101604222243081458E+06,       0.101615370617936293E+06,       0.101626717204329048E+06,       0.101638824013794816E+06,       0.101652144675515985E+06,
        0.101666986413953739E+06,       0.101683491567268982E+06,       0.101699730410034434E+06,       0.101715308981035720E+06,       0.101731361440654102E+06,
        0.101748589449732390E+06,       0.101766824698764540E+06,       0.101785841910313233E+06,       0.101805411629659066E+06,       0.101825381837012450E+06,
        0.101846839764007193E+06,       0.101867081140515147E+06,       0.101882747001865355E+06,       0.101896903928888263E+06,       0.101909362288120537E+06,
        0.101920245934517079E+06,       0.101930058238641242E+06,       0.101941637442764200E+06,       0.101954785426383867E+06,       0.101968215450878924E+06,
        0.101984710778129607E+06,       0.102001549965592465E+06,       0.102018275841846422E+06,       0.102034683222590960E+06,       0.102052401989689286E+06,
        0.102069645673240069E+06,       0.102086007650836211E+06,       0.102103768116502732E+06,       0.102121127630333416E+06,       0.102135973777942898E+06,
        0.102147987937177197E+06,       0.102156601874315427E+06,       0.102161672760610920E+06,       0.102163612354316181E+06,       0.102165768392921964E+06,
        0.102167214431077227E+06,       0.102169260247518920E+06,       0.102170746287005837E+06,       0.102171480626503515E+06,       0.102171269145651808E+06,
        0.102170214520413967E+06,       0.102167256562754847E+06,       0.102162479386098232E+06,       0.102158371150627951E+06,       0.102155244448894475E+06,
        0.102152875264177637E+06,       0.102149492287714515E+06,       0.102145495391175835E+06,       0.102139392366010521E+06,       0.102131234162350753E+06,
        0.102121845495369198E+06,       0.102114444604303775E+06,       0.102106462190456019E+06,       0.102096364075651625E+06,       0.102082958297694466E+06,
        0.102064065966768365E+06,       0.102041420899050965E+06,       0.102016297892142000E+06,       0.101989261194259234E+06,       0.101963193901333740E+06,
        0.101934697827006079E+06,       0.101902018630394974E+06,       0.101863893013675159E+06,       0.101820477410193009E+06,       0.101774528513823985E+06,
        0.101724002882111308E+06,       0.101665763047983230E+06,       0.101603648801794363E+06,       0.101540096977050402E+06,       0.101478947206942044E+06,
        0.101415470097827929E+06,       0.101351609294201058E+06,       0.101289469642166499E+06,       0.101226537327552069E+06,       0.101158605139549531E+06,
        0.101091671283985226E+06,       0.101026501778518956E+06,       0.100963906622713315E+06,       0.100912235109733156E+06,       0.100875156448926034E+06,
        0.100858092199168052E+06,       0.100869196724643829E+06,       0.100906258192389359E+06,       0.100966643545000639E+06,       0.101044871026198045E+06,
        0.101126128294873750E+06,       0.101195519846174895E+06,       0.101255659962385485E+06,       0.101297057174446716E+06,       0.101328131549875659E+06,
        0.101358621176643224E+06,       0.101392239138290606E+06,       0.101427359701943147E+06,       0.101468500213009858E+06,       0.101510703720686288E+06,
        0.101550908563824967E+06,       0.101587166287520682E+06,       0.101619760493459311E+06,       0.101640375989610111E+06,       0.101647164822681414E+06,
        0.101640476796716728E+06,       0.101620225665346763E+06,       0.101589549071868416E+06,       0.101551044697311809E+06,       0.101511563682290900E+06,
        0.101475939268223781E+06,       0.101437438003792078E+06,       0.101392805212183681E+06,       0.101332702985176016E+06,       0.101262976832194923E+06,
        0.101186444126810515E+06,       0.101108333464266703E+06,       0.101034512676034472E+06,       0.100963849818957518E+06,       0.100898562106253885E+06,
        0.100842056459041982E+06,       0.100798749608423153E+06,       0.100767148703609448E+06,       0.100745027122654850E+06,       0.100731425417328996E+06,
        0.100731821012642424E+06,       0.100734592849697350E+06,       0.100733986756515151E+06,       0.100727026999971698E+06,       0.100711618349869153E+06,
        0.100683470368124676E+06,       0.100640250766840603E+06,       0.100586314437398818E+06,       0.100534961959011474E+06,       0.100490642055552060E+06,
        0.100456264076438296E+06,       0.100432289810027520E+06,       0.100419632142970615E+06,       0.100423645734029778E+06,       0.100432024957258123E+06,
        0.100442709528904365E+06,       0.100454138069834065E+06,       0.100469282754753091E+06,       0.100483179206656147E+06,       0.100494317659240289E+06,
        0.100501048475271105E+06,       0.100503737147053136E+06,       0.100502939624753810E+06,       0.100506864511892840E+06,       0.100510205922212830E+06,
        0.100511985008099888E+06,       0.101269395817640194E+06,       0.101293433370600033E+06,       0.101320709064215349E+06,       0.101350720216622271E+06,
        0.101381363474586935E+06,       0.101411901774678990E+06,       0.101441702408660596E+06,       0.101470286272251309E+06,       0.101497612121933402E+06,
        0.101523409436511720E+06,       0.101547349710601979E+06,       0.101569178391354450E+06,       0.101588382552830284E+06,       0.101604424454005639E+06,
        0.101617806496970152E+06,       0.101629009202247544E+06,       0.101639790736640862E+06,       0.101650653799515901E+06,       0.101662034467563892E+06,
        0.101674429962589624E+06,       0.101688184881771667E+06,       0.101701776789907686E+06,       0.101715632368359467E+06,       0.101731005396025357E+06,
        0.101747619021182472E+06,       0.101764475149160600E+06,       0.101782565451806455E+06,       0.101801692572504733E+06,       0.101821649291101741E+06,
        0.101844372908615100E+06,       0.101868013490669473E+06,       0.101890926735153276E+06,       0.101912734436730447E+06,       0.101930521333358061E+06,
        0.101945955049482625E+06,       0.101959618341155976E+06,       0.101973842306752718E+06,       0.101990092943988522E+06,       0.102006492234429417E+06,
        0.102022981199823858E+06,       0.102039845835770568E+06,       0.102059553276874620E+06,       0.102079331788742449E+06,       0.102099902964415654E+06,
        0.102120532959564909E+06,       0.102140448801236460E+06,       0.102159255793075747E+06,       0.102176879448503649E+06,       0.102194365868866342E+06,
        0.102211106097444455E+06,       0.102224803244153038E+06,       0.102234823789642047E+06,       0.102240968923527806E+06,       0.102243570541519104E+06,
        0.102243519688579676E+06,       0.102244750868611838E+06,       0.102246759472131700E+06,       0.102247988131721504E+06,       0.102248209161490959E+06,
        0.102247170632681489E+06,       0.102243247319650705E+06,       0.102236753031268512E+06,       0.102230982493940493E+06,       0.102226187707310237E+06,
        0.102222666096639834E+06,       0.102220567141386651E+06,       0.102219855956292071E+06,       0.102215511479397683E+06,       0.102208434908867741E+06,
        0.102198721169081880E+06,       0.102186789184960857E+06,       0.102174609249495770E+06,       0.102164550205667154E+06,       0.102152502370517235E+06,
        0.102137501608386214E+06,       0.102118919702411848E+06,       0.102095889999392573E+06,       0.102070100404917495E+06,       0.102041997958624415E+06,
        0.102012090612610089E+06,       0.101983710969351829E+06,       0.101953137519082840E+06,       0.101920734120792738E+06,       0.101883717982373681E+06,
        0.101842973734119500E+06,       0.101798428245916861E+06,       0.101747102066966778E+06,       0.101687602338869881E+06,       0.101624664318831565E+06,
        0.101559707946739305E+06,       0.101491658640950249E+06,       0.101420567276357397E+06,       0.101354355882096454E+06,       0.101289435543346961E+06,
        0.101224098024003702E+06,       0.101159952737485408E+06,       0.101097956680038245E+06,       0.101035227047009626E+06,       0.100981546520210177E+06,
        0.100939244847484995E+06,       0.100914786575781181E+06,       0.100915867157493747E+06,       0.100942559164277671E+06,       0.100993021366280096E+06,
        0.101062207385378511E+06,       0.101136754321606641E+06,       0.101205153055716102E+06,       0.101267549676815237E+06,       0.101315566331653798E+06,
        0.101356986952566978E+06,       0.101400109049254897E+06,       0.101444047042664242E+06,       0.101488513133860251E+06,       0.101534593023339607E+06,
        0.101578862893253303E+06,       0.101617989104461085E+06,       0.101651469070145307E+06,       0.101676676962902973E+06,       0.101688426206951568E+06,
        0.101690699198194692E+06,       0.101681585082600272E+06,       0.101660802224054729E+06,       0.101632322368388574E+06,       0.101602214382015110E+06,
        0.101577248018812563E+06,       0.101546577483431887E+06,       0.101509347660459607E+06,       0.101460277851145336E+06,       0.101400695177468675E+06,
        0.101333061941295062E+06,       0.101259893373003069E+06,       0.101185498750814251E+06,       0.101111060613673137E+06,       0.101038806163680754E+06,
        0.100970853556921851E+06,       0.100913205537255504E+06,       0.100868081185120318E+06,       0.100831661076531760E+06,       0.100803490881640522E+06,
        0.100782858759036229E+06,       0.100767010800255986E+06,       0.100760517927946479E+06,       0.100755313595541767E+06,       0.100745011420950410E+06,
        0.100727337942231010E+06,       0.100696437123156371E+06,       0.100650083823098379E+06,       0.100597278983266224E+06,       0.100548413676936747E+06,
        0.100507765427222563E+06,       0.100477948430878227E+06,       0.100463614942480534E+06,       0.100466404104801695E+06,       0.100473340681007379E+06,
        0.100482742216284692E+06,       0.100492637659898319E+06,       0.100501306119762710E+06,       0.100508155310289090E+06,       0.100517896956254641E+06,
        0.100523967020314361E+06,       0.100525551437862276E+06,       0.100522692726944748E+06,       0.100516008939190593E+06,       0.100506617021169775E+06,
        0.100504130401290677E+06,       0.100500855757604397E+06,       0.101259195015618316E+06,       0.101287394131248599E+06,       0.101318624387393094E+06,
        0.101351388311065471E+06,       0.101384848445848693E+06,       0.101418230695586331E+06,       0.101450864090695264E+06,       0.101482215379592511E+06,
        0.101512000328888942E+06,       0.101540081556911420E+06,       0.101565958007626774E+06,       0.101589239793549044E+06,       0.101609354590231524E+06,
        0.101626245425942194E+06,       0.101640116415258730E+06,       0.101651384047841973E+06,       0.101660624537901342E+06,       0.101669864682349900E+06,
        0.101680046518619303E+06,       0.101691016789836227E+06,       0.101701600972581538E+06,       0.101712344116073305E+06,       0.101724596034016693E+06,
        0.101738626214170567E+06,       0.101754578760972465E+06,       0.101772464174383247E+06,       0.101790289256249525E+06,       0.101809225095436283E+06,
        0.101831409086778760E+06,       0.101855713865937665E+06,       0.101880304248738481E+06,       0.101904708267321548E+06,       0.101928659429272666E+06,
        0.101952215895369998E+06,       0.101973129343184191E+06,       0.101990492819853054E+06,       0.102009155453432861E+06,       0.102028626658851339E+06,
        0.102048465714061036E+06,       0.102068480817810836E+06,       0.102088846460710702E+06,       0.102110232566220016E+06,       0.102133295641766570E+06,
        0.102157356921516912E+06,       0.102181314870907911E+06,       0.102204374004590238E+06,       0.102226000444488978E+06,       0.102246017656184413E+06,
        0.102265607213167954E+06,       0.102282589184103534E+06,       0.102298432423255334E+06,       0.102310352702715958E+06,       0.102317999706446251E+06,
        0.102321598850661234E+06,       0.102323515138576258E+06,       0.102323197704490987E+06,       0.102322212878332677E+06,       0.102323063816814887E+06,
        0.102322646091264614E+06,       0.102319439183542258E+06,       0.102312970911412354E+06,       0.102304997794601848E+06,       0.102296841478971372E+06,
        0.102291418130089238E+06,       0.102288360395478667E+06,       0.102288552237265947E+06,       0.102287701703575425E+06,       0.102284538846590702E+06,
        0.102276897495121520E+06,       0.102265740813761135E+06,       0.102252134571836228E+06,       0.102237131022390793E+06,       0.102221272996986561E+06,
        0.102206507054624482E+06,       0.102189132554294789E+06,       0.102168602609417649E+06,       0.102145544389345145E+06,       0.102118566149667124E+06,
        0.102089083952633140E+06,       0.102057798140960163E+06,       0.102026969995698295E+06,       0.101997794023706476E+06,       0.101966743922712252E+06,
        0.101933057167765714E+06,       0.101896592945729586E+06,       0.101857371791885336E+06,       0.101815607416803119E+06,       0.101763023383776948E+06,
        0.101702407436462090E+06,       0.101635116047538351E+06,       0.101562945833011370E+06,       0.101485822606547168E+06,       0.101411005039628857E+06,
        0.101339835091662317E+06,       0.101272689532459044E+06,       0.101210368076346276E+06,       0.101154473004817381E+06,       0.101097829928473817E+06,
        0.101048482059940754E+06,       0.101007048910648111E+06,       0.100979473833055905E+06,       0.100973447727585182E+06,       0.100990584221201716E+06,
        0.101029960997994902E+06,       0.101087951257948895E+06,       0.101153695183268181E+06,       0.101219018003879406E+06,       0.101282293838312820E+06,
        0.101338465984178547E+06,       0.101391368230947162E+06,       0.101446772222011277E+06,       0.101500085973176334E+06,       0.101550853250171887E+06,
        0.101598573456663202E+06,       0.101641988898670184E+06,       0.101679214186169236E+06,       0.101710098564568776E+06,       0.101732780885386266E+06,
        0.101743179226637279E+06,       0.101740055966295447E+06,       0.101722994425650759E+06,       0.101700469255730888E+06,       0.101674123165238838E+06,
        0.101653160060864204E+06,       0.101631596453806415E+06,       0.101607075787893336E+06,       0.101574486424828559E+06,       0.101526976419999381E+06,
        0.101469612332252946E+06,       0.101404225279481514E+06,       0.101336714868594907E+06,       0.101267916935403031E+06,       0.101195492908750399E+06,
        0.101123687793417601E+06,       0.101058751346724224E+06,       0.101000171416406578E+06,       0.100947653236097554E+06,       0.100904324965127365E+06,
        0.100869022485961759E+06,       0.100838631774334179E+06,       0.100814997040174785E+06,       0.100796371893838630E+06,       0.100782994420463059E+06,
        0.100767931078048772E+06,       0.100738709347425858E+06,       0.100699551218149616E+06,       0.100657848886243373E+06,       0.100613930496747955E+06,
        0.100570328091677089E+06,       0.100536417956577148E+06,       0.100522106220241680E+06,       0.100523981788664518E+06,       0.100534576173254580E+06,
        0.100544607428678122E+06,       0.100555100707554739E+06,       0.100564477570051735E+06,       0.100571044680449282E+06,       0.100573984997784108E+06,
        0.100574098036419746E+06,       0.100574969682196417E+06,       0.100570985693230745E+06,       0.100562235725965831E+06,       0.100549403090203457E+06,
        0.100533663303323410E+06,       0.100514985690890928E+06,       0.100501506969102309E+06,       0.101247028543607215E+06,       0.101279000272323727E+06,
        0.101313044900483452E+06,       0.101348706117229129E+06,       0.101385099864543183E+06,       0.101421406335684835E+06,       0.101456908730823867E+06,
        0.101491027169870344E+06,       0.101523346965489472E+06,       0.101553641131603319E+06,       0.101581591041353255E+06,       0.101606456037034135E+06,
        0.101627802489960915E+06,       0.101645553091339185E+06,       0.101659871959589625E+06,       0.101671125963614424E+06,       0.101679833672676948E+06,
        0.101686600287344059E+06,       0.101693249899754504E+06,       0.101700828771449567E+06,       0.101708214676399468E+06,       0.101716786788727914E+06,
        0.101726994188702083E+06,       0.101739189978545895E+06,       0.101753597010140846E+06,       0.101770294478413707E+06,       0.101789229323241438E+06,
        0.101810439881563492E+06,       0.101833551125124432E+06,       0.101857745342370516E+06,       0.101882520275840274E+06,       0.101907489508364233E+06,
        0.101932461599410264E+06,       0.101957552146214075E+06,       0.101983305456973438E+06,       0.102008579834297911E+06,       0.102030494060992147E+06,
        0.102053548115608966E+06,       0.102077104427164624E+06,       0.102100783210934751E+06,       0.102124584361851768E+06,       0.102151618960978216E+06,
        0.102178487299050277E+06,       0.102203837934088209E+06,       0.102231789811787370E+06,       0.102258565924026567E+06,       0.102283435612743153E+06,
        0.102308168911264584E+06,       0.102331519967324959E+06,       0.102351306090243161E+06,       0.102367344163488393E+06,       0.102380956720203612E+06,
        0.102390540926741916E+06,       0.102396561280422888E+06,       0.102399644414793191E+06,       0.102399967479044542E+06,       0.102398097050173761E+06,
        0.102394877934586664E+06,       0.102392579382061362E+06,       0.102387437885771593E+06,       0.102380474134807795E+06,       0.102372089234619867E+06,
        0.102363087167973557E+06,       0.102355720695108947E+06,       0.102355336216227777E+06,       0.102355244528026058E+06,       0.102353863384518510E+06,
        0.102349945815737563E+06,       0.102342442703922468E+06,       0.102329934370864139E+06,       0.102314612359457431E+06,       0.102297370131901000E+06,
        0.102278388120427626E+06,       0.102257491551240819E+06,       0.102236307907230104E+06,       0.102213097347429662E+06,       0.102187800432568954E+06,
        0.102160229919730293E+06,       0.102129097981842890E+06,       0.102096889363146300E+06,       0.102063827052134482E+06,       0.102031184486610946E+06,
        0.101999264622467439E+06,       0.101966221591490219E+06,       0.101931754343580265E+06,       0.101897700536754972E+06,       0.101861993529889558E+06,
        0.101819636716650479E+06,       0.101763615901241341E+06,       0.101697976370488861E+06,       0.101620393736143524E+06,       0.101535102872161384E+06,
        0.101449253069692393E+06,       0.101374420264238244E+06,       0.101306501858255855E+06,       0.101247778577939956E+06,       0.101198381473636808E+06,
        0.101152064836353820E+06,       0.101110344624142366E+06,       0.101075281561938828E+06,       0.101049407554255304E+06,       0.101040768998780331E+06,
        0.101052199471517510E+06,       0.101082392815890635E+06,       0.101129144157533199E+06,       0.101184092780294726E+06,       0.101243772906750455E+06,
        0.101307121999288836E+06,       0.101369991062098430E+06,       0.101433698297000723E+06,       0.101498903828178067E+06,       0.101560474018943947E+06,
        0.101615857050411636E+06,       0.101665138596523073E+06,       0.101705590047241931E+06,       0.101738943786932854E+06,       0.101767114003134644E+06,
        0.101789192730629773E+06,       0.101799147989736230E+06,       0.101794735430608300E+06,       0.101777146397531964E+06,       0.101750372193384130E+06,
        0.101723141667504169E+06,       0.101702833712477848E+06,       0.101682678205011733E+06,       0.101660302359832262E+06,       0.101630633216063026E+06,
        0.101590584748240784E+06,       0.101537939783765964E+06,       0.101477184750419154E+06,       0.101412613988421668E+06,       0.101346432956553763E+06,
        0.101280354991399392E+06,       0.101215950742003886E+06,       0.101152407700542390E+06,       0.101091630971862964E+06,       0.101034381306262483E+06,
        0.100980581565512359E+06,       0.100932607474756849E+06,       0.100894526231033058E+06,       0.100863524006721316E+06,       0.100837940986693153E+06,
        0.100815616712752075E+06,       0.100783831314269482E+06,       0.100747340055464098E+06,       0.100708359519305974E+06,       0.100669700349442544E+06,
        0.100634134123292621E+06,       0.100602055798299742E+06,       0.100591037034284673E+06,       0.100590664657868474E+06,       0.100599127748830913E+06,
        0.100614596189110918E+06,       0.100634150489947802E+06,       0.100646345748706677E+06,       0.100655865724535965E+06,       0.100661116257080008E+06,
        0.100661028163947834E+06,       0.100655523835145024E+06,       0.100646490601253885E+06,       0.100636711851892294E+06,       0.100621894936014534E+06,
        0.100602810704563395E+06,       0.100576368488764041E+06,       0.100548286166395032E+06,       0.100522977180969814E+06,       0.101228903510937074E+06,
        0.101265781795862422E+06,       0.101303509185958625E+06,       0.101342284425688282E+06,       0.101381796177970391E+06,       0.101421170386188518E+06,
        0.101459636817675681E+06,       0.101496562449942183E+06,       0.101531479594885182E+06,       0.101564960000747014E+06,       0.101594803080993937E+06,
        0.101621355790812595E+06,       0.101644027594565501E+06,       0.101662677874236993E+06,       0.101677441926593165E+06,       0.101688651352830973E+06,
        0.101696785059940390E+06,       0.101702406683447451E+06,       0.101704728868073435E+06,       0.101705248359237783E+06,       0.101710033061244059E+06,
        0.101715986265950589E+06,       0.101723653592966657E+06,       0.101733480291010681E+06,       0.101745772459652580E+06,       0.101760677660607515E+06,
        0.101780220410703594E+06,       0.101803075598452182E+06,       0.101826488604444239E+06,       0.101849820362239523E+06,       0.101873892351949500E+06,
        0.101898378960095564E+06,       0.101923130766489805E+06,       0.101948518897807691E+06,       0.101975696258303404E+06,       0.102004061929304342E+06,
        0.102033460145040677E+06,       0.102061651327409054E+06,       0.102089414327740989E+06,       0.102117077133701037E+06,       0.102147883501053424E+06,
        0.102180718015203005E+06,       0.102212493723892243E+06,       0.102242559046992334E+06,       0.102271049350391899E+06,       0.102300915058795246E+06,
        0.102331227250506359E+06,       0.102361003675242988E+06,       0.102387797529886448E+06,       0.102410738749007287E+06,       0.102429543001075872E+06,
        0.102444601309541205E+06,       0.102455934113666241E+06,       0.102463826248762096E+06,       0.102468461440316110E+06,       0.102469870975073049E+06,
        0.102468446450288320E+06,       0.102464798290121791E+06,       0.102458449322550092E+06,       0.102451735051873286E+06,       0.102444849067868476E+06,
        0.102436636367539046E+06,       0.102428988993985171E+06,       0.102425331914020266E+06,       0.102421620005855337E+06,       0.102419560924305013E+06,
        0.102417115927208128E+06,       0.102411283378863518E+06,       0.102401124644854805E+06,       0.102388294546935547E+06,       0.102372130138911380E+06,
        0.102352872703988251E+06,       0.102330900792506814E+06,       0.102305906692453034E+06,       0.102278836660343848E+06,       0.102251891886031619E+06,
        0.102223352000414103E+06,       0.102193067106830058E+06,       0.102161078903831076E+06,       0.102125912821954276E+06,       0.102089510678556544E+06,
        0.102052507421496150E+06,       0.102015228902546209E+06,       0.101978931284532373E+06,       0.101944546111379605E+06,       0.101912474602996255E+06,
        0.101881505541306557E+06,       0.101847220983536259E+06,       0.101796545763435774E+06,       0.101731194445780915E+06,       0.101655521374345393E+06,
        0.101570254785904996E+06,       0.101481522317187802E+06,       0.101401331116195521E+06,       0.101332141668882890E+06,       0.101273993470810659E+06,
        0.101228638656778901E+06,       0.101190604276845741E+06,       0.101158196197344718E+06,       0.101133936056759660E+06,       0.101117981664703751E+06,
        0.101116933850947476E+06,       0.101131399795691948E+06,       0.101160604644423380E+06,       0.101201518443580746E+06,       0.101248903707713456E+06,
        0.101300592974865489E+06,       0.101357214090897702E+06,       0.101418441744321666E+06,       0.101485557443350626E+06,       0.101555445746166064E+06,
        0.101621303501475879E+06,       0.101679228518906544E+06,       0.101728241686716501E+06,       0.101766854072509333E+06,       0.101798436487011495E+06,
        0.101826906634104991E+06,       0.101847291990324695E+06,       0.101856878275200172E+06,       0.101852227620230362E+06,       0.101834698267214306E+06,
        0.101809239675292964E+06,       0.101781969547875371E+06,       0.101755152512939356E+06,       0.101732931589822008E+06,       0.101712653074247995E+06,
        0.101684830999865546E+06,       0.101647239704296619E+06,       0.101599826041378212E+06,       0.101544653396053778E+06,       0.101483464700333992E+06,
        0.101420696082338764E+06,       0.101361355157000173E+06,       0.101303077019503457E+06,       0.101242949922489031E+06,       0.101180470229611776E+06,
        0.101117365765681796E+06,       0.101054059738264114E+06,       0.100995066688862426E+06,       0.100946512981860345E+06,       0.100908291761953325E+06,
        0.100873905402216697E+06,       0.100835045455127693E+06,       0.100798873170272855E+06,       0.100762695696108858E+06,       0.100726025871425081E+06,
        0.100692734909454986E+06,       0.100668902864702948E+06,       0.100663213502720391E+06,       0.100664621390201341E+06,       0.100671374502519597E+06,
        0.100685680453359950E+06,       0.100705798123986984E+06,       0.100728995575579524E+06,       0.100751658112675097E+06,       0.100762519462763623E+06,
        0.100767027529124854E+06,       0.100764553224004907E+06,       0.100755187738630775E+06,       0.100739605979863540E+06,       0.100720551089520799E+06,
        0.100698313533178705E+06,       0.100666865056198847E+06,       0.100634031483894869E+06,       0.100601785153826728E+06,       0.100571987820731039E+06,
        0.101206374045435979E+06,       0.101245886159229500E+06,       0.101288633787391896E+06,       0.101331822184275137E+06,       0.101374720391458119E+06,
        0.101417383823794662E+06,       0.101458981013573735E+06,       0.101498818874093005E+06,       0.101538685205643225E+06,       0.101575422468180957E+06,
        0.101607594064004836E+06,       0.101634787525358639E+06,       0.101658391829702683E+06,       0.101677992927276675E+06,       0.101693216382147584E+06,
        0.101704372381742840E+06,       0.101711917535928253E+06,       0.101714961207000641E+06,       0.101714465004361307E+06,       0.101712311040969114E+06,
        0.101709673671424040E+06,       0.101711218999391320E+06,       0.101715783535561670E+06,       0.101722657082666818E+06,       0.101732238893442816E+06,
        0.101747062236834958E+06,       0.101766365174287086E+06,       0.101787109475394507E+06,       0.101808925705709073E+06,       0.101831553485340701E+06,
        0.101854101136956699E+06,       0.101876977318564983E+06,       0.101900071328279475E+06,       0.101924414875452247E+06,       0.101951462468272264E+06,
        0.101980975232741199E+06,       0.102012836826491402E+06,       0.102047258491401968E+06,       0.102083474297558190E+06,       0.102117469380506620E+06,
        0.102154658530511195E+06,       0.102192659983700083E+06,       0.102229894335694480E+06,       0.102265384438205918E+06,       0.102298947455958070E+06,
        0.102332733340180333E+06,       0.102366161911789881E+06,       0.102400223366988168E+06,       0.102430989231899657E+06,       0.102457385343324306E+06,
        0.102478953671150099E+06,       0.102497140263958892E+06,       0.102511039792962809E+06,       0.102520299291871444E+06,       0.102526846630820248E+06,
        0.102529945588383314E+06,       0.102529752833756676E+06,       0.102527108906249603E+06,       0.102521410242623388E+06,       0.102513405849115865E+06,
        0.102504764193898140E+06,       0.102498120743343170E+06,       0.102494756241843366E+06,       0.102491412904970945E+06,       0.102487349910826408E+06,
        0.102482003045019752E+06,       0.102474975478072651E+06,       0.102465362858837878E+06,       0.102453624922867719E+06,       0.102439388282147716E+06,
        0.102422313370157048E+06,       0.102401857750208626E+06,       0.102377162061003954E+06,       0.102349188460773526E+06,       0.102318424237125233E+06,
        0.102285363297180986E+06,       0.102252385208010586E+06,       0.102218029776633513E+06,       0.102181810380545387E+06,       0.102143591228429039E+06,
        0.102102341867038209E+06,       0.102057770995654748E+06,       0.102012593759546347E+06,       0.101970748503609808E+06,       0.101933725108693834E+06,
        0.101900789684666524E+06,       0.101867979870800904E+06,       0.101834235978935918E+06,       0.101794954568116285E+06,       0.101739484665823096E+06,
        0.101671789500483821E+06,       0.101593418617286006E+06,       0.101506698290483502E+06,       0.101422237896336897E+06,       0.101350833220772416E+06,
        0.101290575286891341E+06,       0.101248402171152557E+06,       0.101218529092999917E+06,       0.101197447450399108E+06,       0.101187612570890138E+06,
        0.101185871864261528E+06,       0.101196499134288402E+06,       0.101218353571942265E+06,       0.101249194623964548E+06,       0.101286372345386742E+06,
        0.101326464875508391E+06,       0.101369986766969960E+06,       0.101419749853660280E+06,       0.101476722498559480E+06,       0.101542829739890207E+06,
        0.101612522924097197E+06,       0.101678721249810798E+06,       0.101737575823144638E+06,       0.101785395492746917E+06,       0.101823368561408701E+06,
        0.101856014056084430E+06,       0.101884313206989173E+06,       0.101903695929922687E+06,       0.101912969317636380E+06,       0.101908832298462992E+06,
        0.101892237038585794E+06,       0.101866203497664581E+06,       0.101837081196005645E+06,       0.101809606048398258E+06,       0.101786840568731568E+06,
        0.101762564033379982E+06,       0.101734680154915579E+06,       0.101696592635540685E+06,       0.101650662453849189E+06,       0.101599162120752633E+06,
        0.101544343001196743E+06,       0.101488647544765059E+06,       0.101433089123172278E+06,       0.101377125096785036E+06,       0.101320042947392227E+06,
        0.101256674805424394E+06,       0.101187987297748215E+06,       0.101120641997896339E+06,       0.101056247927954246E+06,       0.100996331972370142E+06,
        0.100943232428022544E+06,       0.100895353842840079E+06,       0.100852555312220196E+06,       0.100815337064243067E+06,       0.100783799781542155E+06,
        0.100753868748835012E+06,       0.100736637044447663E+06,       0.100730650096307727E+06,       0.100733232093861763E+06,       0.100743913291446443E+06,
        0.100758835470579754E+06,       0.100778259316407013E+06,       0.100802567061591370E+06,       0.100828283762383522E+06,       0.100855135515023372E+06,
        0.100877691529341333E+06,       0.100882602938691591E+06,       0.100878787688210650E+06,       0.100866582130667157E+06,       0.100846949291204379E+06,
        0.100815418882725819E+06,       0.100780247866813195E+06,       0.100745087245795497E+06,       0.100709396490561645E+06,       0.100675020472311327E+06,
        0.100643622948665085E+06,       0.101179250397845899E+06,       0.101221149498052953E+06,       0.101266816356343159E+06,       0.101315335097978430E+06,
        0.101363838550262313E+06,       0.101410108301517408E+06,       0.101455090720967710E+06,       0.101501448789654576E+06,       0.101545139345543692E+06,
        0.101584741389399278E+06,       0.101619452976458153E+06,       0.101648772604086349E+06,       0.101672509578882498E+06,       0.101691865395895249E+06,
        0.101707555892752804E+06,       0.101718643945821881E+06,       0.101724156365132570E+06,       0.101724941937858879E+06,       0.101722568702130273E+06,
        0.101718069834871334E+06,       0.101712578971246767E+06,       0.101707223787895346E+06,       0.101704839789861668E+06,       0.101708104689497137E+06,
        0.101716865742578157E+06,       0.101731053443752840E+06,       0.101746952161869922E+06,       0.101764257279303914E+06,       0.101782706182959490E+06,
        0.101802123848941148E+06,       0.101822482313672357E+06,       0.101842936616784311E+06,       0.101860934973268697E+06,       0.101882854305976114E+06,
        0.101908552344231415E+06,       0.101937813400383588E+06,       0.101970499454458186E+06,       0.102006741063404974E+06,       0.102048298491096837E+06,
        0.102094559383243701E+06,       0.102138864116678858E+06,       0.102182980858368159E+06,       0.102226517702417070E+06,       0.102268076174545422E+06,
        0.102309052474061144E+06,       0.102352381321886001E+06,       0.102391102131696549E+06,       0.102425199358256839E+06,       0.102458541492672259E+06,
        0.102488862618142084E+06,       0.102514290917361213E+06,       0.102535791702452596E+06,       0.102552503476764061E+06,       0.102564543232835902E+06,
        0.102572720164328770E+06,       0.102578198051091356E+06,       0.102580323990135614E+06,       0.102579265394634727E+06,       0.102574962647335808E+06,
        0.102568059504060235E+06,       0.102560319977754334E+06,       0.102556118504191676E+06,       0.102553057067685237E+06,       0.102550069919232395E+06,
        0.102545676460258372E+06,       0.102538438321503912E+06,       0.102526558414006213E+06,       0.102512331043456594E+06,       0.102498934035030790E+06,
        0.102483367837719314E+06,       0.102465528571415576E+06,       0.102444019300123240E+06,       0.102417539855634386E+06,       0.102386941153851396E+06,
        0.102352803854769852E+06,       0.102315908735629360E+06,       0.102276253891919623E+06,       0.102235698643740441E+06,       0.102193754813942534E+06,
        0.102149197092732255E+06,       0.102100466547888893E+06,       0.102048387340808171E+06,       0.101995636407850165E+06,       0.101944784700201388E+06,
        0.101899202783926419E+06,       0.101857839910913841E+06,       0.101822276933475470E+06,       0.101792037001853430E+06,       0.101761456733915693E+06,
        0.101723124817417673E+06,       0.101667540093368385E+06,       0.101602052196997916E+06,       0.101524286713149719E+06,       0.101443448254745468E+06,
        0.101372151184877337E+06,       0.101312547429677303E+06,       0.101270741733953284E+06,       0.101245862300696550E+06,       0.101237403284129323E+06,
        0.101240955267019526E+06,       0.101253727619962054E+06,       0.101276647528408124E+06,       0.101307289777398546E+06,       0.101342096503173772E+06,
        0.101377440256415284E+06,       0.101410859947128090E+06,       0.101445291144028568E+06,       0.101485896954639960E+06,       0.101536034363702740E+06,
        0.101598275532425832E+06,       0.101665271864468625E+06,       0.101730455163620383E+06,       0.101789053839460757E+06,       0.101836451975671342E+06,
        0.101875114449402914E+06,       0.101909841821580325E+06,       0.101937388731349492E+06,       0.101957316621074744E+06,       0.101965726747313485E+06,
        0.101960066223235612E+06,       0.101941333444338321E+06,       0.101914153314528972E+06,       0.101884034639169928E+06,       0.101858023754631969E+06,
        0.101832589987368483E+06,       0.101805510097226972E+06,       0.101772567651719524E+06,       0.101733410070028302E+06,       0.101687946616198518E+06,
        0.101638303259297347E+06,       0.101588584508090702E+06,       0.101540424262528119E+06,       0.101488738611497931E+06,       0.101435260593399056E+06,
        0.101375735107437940E+06,       0.101312542555417007E+06,       0.101246134029601395E+06,       0.101177277643560679E+06,       0.101109587858444022E+06,
        0.101039831433180021E+06,       0.100972865937903305E+06,       0.100917142934489922E+06,       0.100872742649287640E+06,       0.100836992191858386E+06,
        0.100811317083979215E+06,       0.100803167641532855E+06,       0.100798970012812904E+06,       0.100800172827859802E+06,       0.100809159254650964E+06,
        0.100825090132632613E+06,       0.100846063732092007E+06,       0.100868925096583727E+06,       0.100895209549142979E+06,       0.100924583482422255E+06,
        0.100954767114643226E+06,       0.100982762726865476E+06,       0.101000126944911273E+06,       0.100996312696391295E+06,       0.100980278059754797E+06,
        0.100948675007578538E+06,       0.100912131109198177E+06,       0.100873893055713954E+06,       0.100836895686632663E+06,       0.100800840190763440E+06,
        0.100766824999287084E+06,       0.100736390306808840E+06,       0.101147547908848283E+06,       0.101191548413107710E+06,       0.101239813004555443E+06,
        0.101291456639815791E+06,       0.101345618815623297E+06,       0.101399848017628567E+06,       0.101452120246013321E+06,       0.101502531147260263E+06,
        0.101549713655955595E+06,       0.101592520742368200E+06,       0.101630069264663078E+06,       0.101661769202013544E+06,       0.101687336031179409E+06,
        0.101706783718499020E+06,       0.101720752729463624E+06,       0.101730352171304155E+06,       0.101734303682047248E+06,       0.101733803712048772E+06,
        0.101729673880940856E+06,       0.101722933683541196E+06,       0.101714707079396278E+06,       0.101706119415995257E+06,       0.101698183703231305E+06,
        0.101694443401773460E+06,       0.101701997679200067E+06,       0.101711622212974413E+06,       0.101722702839184887E+06,       0.101735051927557608E+06,
        0.101748506288605597E+06,       0.101762966981866150E+06,       0.101778437616403622E+06,       0.101789127619601830E+06,       0.101803967912821841E+06,
        0.101822592115495441E+06,       0.101845777685417066E+06,       0.101873478314957349E+06,       0.101905482242767845E+06,       0.101942888324591171E+06,
        0.101988404530944768E+06,       0.102038702733784274E+06,       0.102092474242398283E+06,       0.102148032734040069E+06,       0.102199248899464394E+06,
        0.102248915596860126E+06,       0.102302591874664358E+06,       0.102352656965704402E+06,       0.102397731646050539E+06,       0.102437448450124619E+06,
        0.102472449474120032E+06,       0.102503421423363616E+06,       0.102532064367287210E+06,       0.102556777288245488E+06,       0.102576671821794167E+06,
        0.102591572855277176E+06,       0.102602228863800672E+06,       0.102612279279788083E+06,       0.102616851593614643E+06,       0.102617893333235930E+06,
        0.102615765691172550E+06,       0.102610441888248854E+06,       0.102607301386114821E+06,       0.102603993592939412E+06,       0.102600663908017392E+06,
        0.102597488187445881E+06,       0.102592493791941044E+06,       0.102582466666192224E+06,       0.102569826273933562E+06,       0.102554713868615829E+06,
        0.102537648672080177E+06,       0.102521039168448478E+06,       0.102503173475915130E+06,       0.102480635537613605E+06,       0.102452652573625455E+06,
        0.102419350874903001E+06,       0.102382346399272821E+06,       0.102341612134553201E+06,       0.102297029075732309E+06,       0.102248948564059086E+06,
        0.102198720030139870E+06,       0.102145758870677353E+06,       0.102088950595530157E+06,       0.102029051584965782E+06,       0.101967199226732264E+06,
        0.101903210271600808E+06,       0.101842958311824055E+06,       0.101794271532633502E+06,       0.101756533651972539E+06,       0.101727257623922851E+06,
        0.101703822910323244E+06,       0.101679786232533574E+06,       0.101644516695705548E+06,       0.101595106427152612E+06,       0.101536504683202511E+06,
        0.101467865301457467E+06,       0.101405006154835806E+06,       0.101354849767181862E+06,       0.101317686662273423E+06,       0.101296595665381508E+06,
        0.101290414819946876E+06,       0.101298257504082198E+06,       0.101319018351106934E+06,       0.101351193190044753E+06,       0.101389882715506814E+06,
        0.101429774758297252E+06,       0.101465327153650665E+06,       0.101493697248690820E+06,       0.101519475777882981E+06,       0.101549278536429629E+06,
        0.101589674862889879E+06,       0.101644437539602266E+06,       0.101707639653092512E+06,       0.101773446880721283E+06,       0.101832627929812195E+06,
        0.101881326017934320E+06,       0.101922991773475122E+06,       0.101958375717528819E+06,       0.101986274837340650E+06,       0.102005491030983016E+06,
        0.102011686815100737E+06,       0.102002038930530602E+06,       0.101979844500374034E+06,       0.101949713592872038E+06,       0.101919794688969385E+06,
        0.101890097820657014E+06,       0.101860915631872151E+06,       0.101828511020572609E+06,       0.101792400720458652E+06,       0.101751700978283421E+06,
        0.101705424659848417E+06,       0.101656344874022790E+06,       0.101609238060088639E+06,       0.101564980684227325E+06,       0.101522208207649019E+06,
        0.101469412985671690E+06,       0.101412347630207965E+06,       0.101351832558558221E+06,       0.101288709894130297E+06,       0.101222062151738224E+06,
        0.101149874038784459E+06,       0.101078002130177440E+06,       0.101009088984990114E+06,       0.100945974661293003E+06,       0.100898762938745946E+06,
        0.100870562536964586E+06,       0.100856855516523385E+06,       0.100855450035140704E+06,       0.100864081929396765E+06,       0.100872263570757554E+06,
        0.100886283473303847E+06,       0.100905686340654982E+06,       0.100926632293872623E+06,       0.100951268783756459E+06,       0.100980364613721176E+06,
        0.101012594678026580E+06,       0.101045448177269616E+06,       0.101076054483113505E+06,       0.101101140326098612E+06,       0.101100763828566429E+06,
        0.101077946327603815E+06,       0.101047158711316821E+06,       0.101011715736067359E+06,       0.100974871631289832E+06,       0.100939265943285602E+06,
        0.100905758734950185E+06,       0.100874978764764266E+06,       0.100855175471442562E+06,       0.101111520792912168E+06,       0.101157325849907211E+06,
        0.101207855335016298E+06,       0.101262234561872421E+06,       0.101320453238625094E+06,       0.101383611932041124E+06,       0.101446021580746979E+06,
        0.101500639373333164E+06,       0.101551782605323038E+06,       0.101598222486408573E+06,       0.101638989420395039E+06,       0.101673403579343765E+06,
        0.101701089807805052E+06,       0.101721974472240297E+06,       0.101735419880771398E+06,       0.101741369945130849E+06,       0.101743897808629612E+06,
        0.101742267006478505E+06,       0.101736494037811004E+06,       0.101727612235604785E+06,       0.101716766590943007E+06,       0.101705114503249541E+06,
        0.101695691907190470E+06,       0.101691082917827283E+06,       0.101688492565094857E+06,       0.101689693834759819E+06,       0.101694319117847946E+06,
        0.101699984888099891E+06,       0.101706624023230441E+06,       0.101714209290037295E+06,       0.101714886189053461E+06,       0.101718477607258348E+06,
        0.101727166805334680E+06,       0.101741942812281210E+06,       0.101762884060961267E+06,       0.101787922016469936E+06,       0.101818124304470504E+06,
        0.101856144652932824E+06,       0.101902274632393572E+06,       0.101955219215111909E+06,       0.102013545239481187E+06,       0.102075989637765349E+06,
        0.102141825734524129E+06,       0.102209412008951840E+06,       0.102271101455590702E+06,       0.102328905451065119E+06,       0.102380997966748007E+06,
        0.102426592472327698E+06,       0.102466679017069036E+06,       0.102502492265674373E+06,       0.102531828163015132E+06,       0.102557693337524877E+06,
        0.102581562159738140E+06,       0.102599817594232780E+06,       0.102617360456048831E+06,       0.102630533755776734E+06,       0.102638413398652745E+06,
        0.102641585059017671E+06,       0.102641643207641609E+06,       0.102639909103140890E+06,       0.102637870663539637E+06,       0.102635390209430159E+06,
        0.102632452553768846E+06,       0.102629055188468876E+06,       0.102622883797323870E+06,       0.102613396703866238E+06,       0.102601167982128070E+06,
        0.102586228500797864E+06,       0.102570641502416736E+06,       0.102554342163336842E+06,       0.102534088219572732E+06,       0.102511041429401579E+06,
        0.102481963706129696E+06,       0.102447121630716501E+06,       0.102407091340582192E+06,       0.102362401740888643E+06,       0.102313427305605088E+06,
        0.102259555941640690E+06,       0.102201038299707958E+06,       0.102138783904224241E+06,       0.102073015852343407E+06,       0.102003417942998523E+06,
        0.101925865118624715E+06,       0.101850155355117560E+06,       0.101780650482480312E+06,       0.101721528392427077E+06,       0.101678592950691062E+06,
        0.101649600593305571E+06,       0.101630406458717945E+06,       0.101617445713840047E+06,       0.101603733747246617E+06,       0.101577149951594518E+06,
        0.101547743780961551E+06,       0.101507738128132827E+06,       0.101462001737325336E+06,       0.101417253659172507E+06,       0.101379673252643261E+06,
        0.101354722198341828E+06,       0.101344083982961922E+06,       0.101350090319994677E+06,       0.101372932240478462E+06,       0.101408874721438551E+06,
        0.101453217513073498E+06,       0.101497802352511892E+06,       0.101536224569247846E+06,       0.101563019361021943E+06,       0.101582620293203203E+06,
        0.101603379870639314E+06,       0.101634664417891821E+06,       0.101681132562699248E+06,       0.101739502773358443E+06,       0.101803164120008223E+06,
        0.101863683127456912E+06,       0.101917393438978630E+06,       0.101963558171047160E+06,       0.101999276960053059E+06,       0.102027732037148526E+06,
        0.102044731025719229E+06,       0.102045431775095058E+06,       0.102030705033808161E+06,       0.102003666856825570E+06,       0.101970343646836016E+06,
        0.101935360181740762E+06,       0.101900669036632447E+06,       0.101865688643875081E+06,       0.101829409780582253E+06,       0.101790176042387873E+06,
        0.101745151599830831E+06,       0.101696472660873420E+06,       0.101648060959889524E+06,       0.101603410369994090E+06,       0.101561835852602439E+06,
        0.101521855998799132E+06,       0.101482037163334768E+06,       0.101431340410975914E+06,       0.101375699870779092E+06,       0.101314779976223654E+06,
        0.101251712502201844E+06,       0.101185784883436660E+06,       0.101116517257030340E+06,       0.101049883113580014E+06,       0.100989563385332454E+06,
        0.100941765093850961E+06,       0.100916306862933794E+06,       0.100906980056579865E+06,       0.100910197269982164E+06,       0.100922958161069488E+06,
        0.100941314458770998E+06,       0.100957519326146881E+06,       0.100976831072572779E+06,       0.100999605735160003E+06,       0.101025582535843947E+06,
        0.101054164787686663E+06,       0.101087890451072817E+06,       0.101122283479534453E+06,       0.101149350938674921E+06,       0.101166873408313593E+06,
        0.101177821152178367E+06,       0.101167655432610394E+06,       0.101141220410113790E+06,       0.101110321588459745E+06,       0.101078361586283063E+06,
        0.101047967121170557E+06,       0.101023734539325480E+06,       0.101008383694813747E+06,       0.100996781521485842E+06,       0.101071681166949435E+06,
        0.101119012263039112E+06,       0.101171496350808069E+06,       0.101230050130927513E+06,       0.101294972556584413E+06,       0.101361718999132645E+06,
        0.101428515451916319E+06,       0.101493595145979649E+06,       0.101550612440880213E+06,       0.101601210858501552E+06,       0.101645666556374214E+06,
        0.101683206121268653E+06,       0.101713363718937704E+06,       0.101736031118329251E+06,       0.101750515944612693E+06,       0.101757053628392736E+06,
        0.101756382807271759E+06,       0.101751079781741602E+06,       0.101743715819909994E+06,       0.101732729519215369E+06,       0.101719316686245147E+06,
        0.101706213959027606E+06,       0.101695984176562313E+06,       0.101686190677071994E+06,       0.101677301261342131E+06,       0.101669511529871947E+06,
        0.101662644903393695E+06,       0.101659294762388396E+06,       0.101657066043437371E+06,       0.101647001805639928E+06,       0.101637372304767356E+06,
        0.101632049251178221E+06,       0.101632583495971994E+06,       0.101640198281276986E+06,       0.101655810259860154E+06,       0.101680028481804649E+06,
        0.101706638821039131E+06,       0.101742286180341995E+06,       0.101788109417502055E+06,       0.101842726554478882E+06,       0.101904504042995715E+06,
        0.101971839066862056E+06,       0.102051325178151485E+06,       0.102132183694597014E+06,       0.102209672996832567E+06,       0.102278148214885616E+06,
        0.102338448224708001E+06,       0.102390873033725249E+06,       0.102438626144456910E+06,       0.102479259552033545E+06,       0.102513206393975473E+06,
        0.102541824188105747E+06,       0.102567198188429233E+06,       0.102591367917437441E+06,       0.102612619776373147E+06,       0.102629292784196412E+06,
        0.102640555112501301E+06,       0.102646561280503796E+06,       0.102650072544106879E+06,       0.102650385076837265E+06,       0.102648623310889074E+06,
        0.102647398290377925E+06,       0.102645017994891765E+06,       0.102642292476577204E+06,       0.102637067835034904E+06,       0.102629000591322547E+06,
        0.102618729003435990E+06,       0.102606585296063713E+06,       0.102594489398555161E+06,       0.102579129366844747E+06,       0.102559288929741029E+06,
        0.102534463674515951E+06,       0.102503683064059122E+06,       0.102467677027648388E+06,       0.102425952698371388E+06,       0.102378489696413220E+06,
        0.102325464394964612E+06,       0.102266592853272959E+06,       0.102201770963158517E+06,       0.102131402230157837E+06,       0.102054746212255937E+06,
        0.101968929014764348E+06,       0.101881350922099227E+06,       0.101796528814235106E+06,       0.101718540575217223E+06,       0.101652169308423996E+06,
        0.101599956132104824E+06,       0.101567900805891448E+06,       0.101551935071902582E+06,       0.101547427861477787E+06,       0.101554419426909473E+06,
        0.101561600978615184E+06,       0.101559452993868224E+06,       0.101543318540946057E+06,       0.101516046490907509E+06,       0.101480708475794294E+06,
        0.101442199752635075E+06,       0.101409794893836297E+06,       0.101389114738180739E+06,       0.101385262237127725E+06,       0.101400028248419621E+06,
        0.101431176088229637E+06,       0.101474781214988048E+06,       0.101522572921117302E+06,       0.101566852249736243E+06,       0.101600450643120159E+06,
        0.101625889986676848E+06,       0.101647907487096571E+06,       0.101675661997654053E+06,       0.101714463575179296E+06,       0.101767306549608373E+06,
        0.101829328954263532E+06,       0.101890507206039634E+06,       0.101946066216170686E+06,       0.101992520848846892E+06,       0.102030925636120199E+06,
        0.102058119932572736E+06,       0.102069397218130180E+06,       0.102063960577488731E+06,       0.102043326123970241E+06,       0.102008553848255615E+06,
        0.101967472871147096E+06,       0.101926394136031289E+06,       0.101886043970172454E+06,       0.101846744426466306E+06,       0.101807275512743188E+06,
        0.101761955344090966E+06,       0.101713799217710359E+06,       0.101665117193273894E+06,       0.101617359026062331E+06,       0.101572592180247302E+06,
        0.101533981842693742E+06,       0.101499194744985522E+06,       0.101466415578573593E+06,       0.101432243614177438E+06,       0.101381882914991351E+06,
        0.101327735566313961E+06,       0.101272085428944469E+06,       0.101216117169049772E+06,       0.101156916040190554E+06,       0.101098197832462072E+06,
        0.101045083251186894E+06,       0.101001341900752319E+06,       0.100969631972021365E+06,       0.100962352822747649E+06,       0.100968513387743296E+06,
        0.100983909597780104E+06,       0.101002878032770619E+06,       0.101021997578890048E+06,       0.101041366902723443E+06,       0.101063829282811043E+06,
        0.101089246526039147E+06,       0.101117245287077734E+06,       0.101145180487582722E+06,       0.101169961535366980E+06,       0.101193870243324593E+06,
        0.101214945572481010E+06,       0.101231265902229890E+06,       0.101240946166576672E+06,       0.101226758959788902E+06,       0.101203801319224774E+06,
        0.101180554692105070E+06,       0.101163284364848339E+06,       0.101153028319845049E+06,       0.101150355172476586E+06,       0.101145580058182692E+06,
        0.101028800627874574E+06,       0.101077428684324259E+06,       0.101134167142638209E+06,       0.101197990565301836E+06,       0.101265722975280849E+06,
        0.101335709112544850E+06,       0.101406209334330430E+06,       0.101475487925550115E+06,       0.101541907493692343E+06,       0.101600856889744842E+06,
        0.101649573257523298E+06,       0.101690733358275495E+06,       0.101724376638615926E+06,       0.101749510141425519E+06,       0.101765791117457280E+06,
        0.101773452578481490E+06,       0.101773114885158633E+06,       0.101765715127990101E+06,       0.101752413867995332E+06,       0.101738692514285227E+06,
        0.101723904619569148E+06,       0.101710227930270819E+06,       0.101695310346281782E+06,       0.101679758838352922E+06,       0.101664029621015856E+06,
        0.101648327607929226E+06,       0.101632507008869143E+06,       0.101615973949263309E+06,       0.101591834033789346E+06,       0.101568495570761865E+06,
        0.101547691859404833E+06,       0.101531530936334253E+06,       0.101521827887484746E+06,       0.101520050854732108E+06,       0.101527313513054993E+06,
        0.101537145982894304E+06,       0.101560590862112396E+06,       0.101599562166824646E+06,       0.101645766826557534E+06,       0.101701752618078797E+06,
        0.101766692067664408E+06,       0.101846710834492522E+06,       0.101935405126349360E+06,       0.102024396175872622E+06,       0.102110867349092339E+06,
        0.102192853218211705E+06,       0.102269413494696259E+06,       0.102330281542130935E+06,       0.102383945506085889E+06,       0.102430199256480380E+06,
        0.102469066393364890E+06,       0.102501583023640342E+06,       0.102532817139689723E+06,       0.102561960069998779E+06,       0.102585754372647149E+06,
        0.102606277240311640E+06,       0.102621561801826407E+06,       0.102631876834385388E+06,       0.102638884194148588E+06,       0.102641934388380745E+06,
        0.102641959420915780E+06,       0.102640521654950935E+06,       0.102639686428696965E+06,       0.102638253506522131E+06,       0.102634465365988304E+06,
        0.102627915114268661E+06,       0.102619787557100746E+06,       0.102613378349844119E+06,       0.102603999870031650E+06,       0.102590631585167415E+06,
        0.102572103225089755E+06,       0.102547313635873026E+06,       0.102516398885249058E+06,       0.102479446900462790E+06,       0.102437237325361522E+06,
        0.102388874413479600E+06,       0.102333718028784861E+06,       0.102271049401030890E+06,       0.102201028861754414E+06,       0.102122663528859397E+06,
        0.102032876851637207E+06,       0.101938463410692304E+06,       0.101842660210214104E+06,       0.101749957344606999E+06,       0.101664764507437576E+06,
        0.101591439187819764E+06,       0.101533919460466379E+06,       0.101494271575071776E+06,       0.101478987993255127E+06,       0.101485263674090980E+06,
        0.101506279443945081E+06,       0.101532941096559764E+06,       0.101553896677561657E+06,       0.101563917085832989E+06,       0.101552692436306723E+06,
        0.101526766068070108E+06,       0.101490572300548680E+06,       0.101454740971174542E+06,       0.101425776324883132E+06,       0.101411062568111098E+06,
        0.101413866812942622E+06,       0.101435131474614493E+06,       0.101474051380900128E+06,       0.101522941427092213E+06,       0.101574152032058948E+06,
        0.101618098831177398E+06,       0.101654170137284003E+06,       0.101684054984246599E+06,       0.101716539075889523E+06,       0.101756604551361495E+06,
        0.101806467761705877E+06,       0.101862424100462653E+06,       0.101918408568819126E+06,       0.101971439624029648E+06,       0.102015800714595636E+06,
        0.102049385208646127E+06,       0.102069908714661666E+06,       0.102076032068515779E+06,       0.102064732659179368E+06,       0.102034093795762514E+06,
        0.101992630086863239E+06,       0.101944780810628261E+06,       0.101894141477159937E+06,       0.101849042057571452E+06,       0.101805808680122878E+06,
        0.101760916109816302E+06,       0.101714291793644923E+06,       0.101666393705850103E+06,       0.101619297696421156E+06,       0.101573598742667251E+06,
        0.101529420471224686E+06,       0.101490381423561645E+06,       0.101460489541744115E+06,       0.101432531917615197E+06,       0.101405679166028422E+06,
        0.101376758400729959E+06,       0.101333014356477448E+06,       0.101288061869102195E+06,       0.101243137897010267E+06,       0.101200014773099698E+06,
        0.101153035601030700E+06,       0.101107255027280131E+06,       0.101068975039667697E+06,       0.101040318598185462E+06,       0.101026239021205620E+06,
        0.101036150724925217E+06,       0.101050786638747362E+06,       0.101066960176317720E+06,       0.101082545023658342E+06,       0.101098187778212945E+06,
        0.101117678130985703E+06,       0.101139021760228803E+06,       0.101155522461091532E+06,       0.101175020122667425E+06,       0.101198265495543150E+06,
        0.101224832562545693E+06,       0.101250329820757150E+06,       0.101272684085133165E+06,       0.101289811161881575E+06,       0.101299701614067628E+06,
        0.101289739336630024E+06,       0.101279678002747503E+06,       0.101273826681569160E+06,       0.101274570526567550E+06,       0.101282465694758634E+06,
        0.101293902962443753E+06,       0.100983835656151976E+06,       0.101036388934372706E+06,       0.101096497142358145E+06,       0.101162397946509547E+06,
        0.101232608232112354E+06,       0.101305480982330599E+06,       0.101379283841868455E+06,       0.101452283197187178E+06,       0.101522834159475562E+06,
        0.101589476875808105E+06,       0.101650386759155634E+06,       0.101696210127681858E+06,       0.101733613430271813E+06,       0.101761832290367092E+06,
        0.101780569821559126E+06,       0.101789961901369534E+06,       0.101790532679209500E+06,       0.101783131653860866E+06,       0.101768849808582265E+06,
        0.101750041068809616E+06,       0.101731803246356489E+06,       0.101713921895166000E+06,       0.101693731889764837E+06,       0.101671835744684708E+06,
        0.101648705771986570E+06,       0.101624585079514640E+06,       0.101599389025969096E+06,       0.101563768387053642E+06,       0.101522704766848532E+06,
        0.101483489785699712E+06,       0.101448687013231232E+06,       0.101419615240213854E+06,       0.101397479525329196E+06,       0.101384028029676760E+06,
        0.101370836998047147E+06,       0.101368370266732833E+06,       0.101383065641375812E+06,       0.101416090998647196E+06,       0.101467290265164353E+06,
        0.101534882313080263E+06,       0.101609445319890510E+06,       0.101699733235880441E+06,       0.101794859855521834E+06,       0.101891101060966321E+06,
        0.101985315130313480E+06,       0.102075076914327306E+06,       0.102159945052938041E+06,       0.102235771297951098E+06,       0.102301477656430769E+06,
        0.102354930558367778E+06,       0.102399782724316072E+06,       0.102438694369211255E+06,       0.102476839111309280E+06,       0.102509751156878236E+06,
        0.102537521783681077E+06,       0.102560895469354815E+06,       0.102580819063130271E+06,       0.102594854584419911E+06,       0.102605160074562926E+06,
        0.102611577337313051E+06,       0.102614486702620023E+06,       0.102617674490494959E+06,       0.102619973525111447E+06,       0.102618324460179618E+06,
        0.102615416266488261E+06,       0.102610851205396946E+06,       0.102607299216665502E+06,       0.102602572628475973E+06,       0.102595515104050908E+06,
        0.102585432283621078E+06,       0.102569550312714797E+06,       0.102546496599273247E+06,       0.102517612581426918E+06,       0.102482362007529839E+06,
        0.102441544642516921E+06,       0.102393921375066857E+06,       0.102338338767732290E+06,       0.102273827698305467E+06,       0.102199580759235032E+06,
        0.102112717239415593E+06,       0.102017541011033652E+06,       0.101917267901995700E+06,       0.101815758981969469E+06,       0.101717854365049221E+06,
        0.101627270343615834E+06,       0.101547308817353100E+06,       0.101483765146806487E+06,       0.101441943712900873E+06,       0.101423999856314156E+06,
        0.101430776328316933E+06,       0.101457783973006139E+06,       0.101497023306538365E+06,       0.101538146597104598E+06,       0.101564980031804182E+06,
        0.101571345079031700E+06,       0.101556555710264554E+06,       0.101527227279379993E+06,       0.101491242458124063E+06,       0.101455431195561541E+06,
        0.101427222639413303E+06,       0.101413952789479707E+06,       0.101420016873493543E+06,       0.101448672726717166E+06,       0.101494479796940665E+06,
        0.101550679225448213E+06,       0.101607025893701604E+06,       0.101659304835337243E+06,       0.101705889950175377E+06,       0.101749787609497245E+06,
        0.101793551387452957E+06,       0.101844793551510127E+06,       0.101899113907290477E+06,       0.101951953582127840E+06,       0.101997167012573933E+06,
        0.102030191525044342E+06,       0.102053787395966574E+06,       0.102064887574337728E+06,       0.102060267944376203E+06,       0.102039749700523636E+06,
        0.102005081906476669E+06,       0.101957654047840246E+06,       0.101904801258523614E+06,       0.101850843726662788E+06,       0.101798946363995929E+06,
        0.101751878064897523E+06,       0.101705939443378287E+06,       0.101659768391705205E+06,       0.101615380159911743E+06,       0.101570783461705709E+06,
        0.101526947551755860E+06,       0.101484787939652975E+06,       0.101445231219594032E+06,       0.101413345817087800E+06,       0.101391047300393111E+06,
        0.101372584877227360E+06,       0.101355566853485740E+06,       0.101335220992961375E+06,       0.101303837716816255E+06,       0.101271525370591757E+06,
        0.101240298133351855E+06,       0.101211003024413338E+06,       0.101175839364889063E+06,       0.101146665774628709E+06,       0.101127801050420749E+06,
        0.101116214564623544E+06,       0.101115217567181709E+06,       0.101124992952320288E+06,       0.101134962605509543E+06,       0.101143290627816998E+06,
        0.101149282865567409E+06,       0.101151001731697805E+06,       0.101160080279956310E+06,       0.101174468885292459E+06,       0.101194158852267166E+06,
        0.101218629627263130E+06,       0.101247610934086246E+06,       0.101278139638903813E+06,       0.101306993640526780E+06,       0.101332857422239162E+06,
        0.101352835922766695E+06,       0.101364854062282961E+06,       0.101366215681609348E+06,       0.101371982657827277E+06,       0.101384204628605657E+06,
        0.101403123567578412E+06,       0.101427293507956012E+06,       0.100939699761507189E+06,       0.100993926545564740E+06,       0.101055617446205957E+06,
        0.101123302505147047E+06,       0.101195700951661318E+06,       0.101271150132425566E+06,       0.101347899405442047E+06,       0.101424189839355866E+06,
        0.101498339603613043E+06,       0.101568835452811982E+06,       0.101636401101424097E+06,       0.101695457584751377E+06,       0.101740082571501800E+06,
        0.101772165987128828E+06,       0.101794061760174460E+06,       0.101805821721959510E+06,       0.101807890769523758E+06,       0.101801052084176001E+06,
        0.101787222143099047E+06,       0.101769333451322513E+06,       0.101746134751190912E+06,       0.101718716143227328E+06,       0.101691356809011646E+06,
        0.101662464249923956E+06,       0.101631298348493656E+06,       0.101598170677190283E+06,       0.101554964683279206E+06,       0.101502331999436428E+06,
        0.101449056042133889E+06,       0.101396847279871756E+06,       0.101347056172201555E+06,       0.101300460882216124E+06,       0.101262584703042259E+06,
        0.101225780265849375E+06,       0.101194459775717551E+06,       0.101179417053502169E+06,       0.101183702376592380E+06,       0.101209076499852017E+06,
        0.101255909037280071E+06,       0.101326640203920455E+06,       0.101424239758254218E+06,       0.101531367651623077E+06,       0.101632910073723979E+06,
        0.101736158570445637E+06,       0.101837656744184424E+06,       0.101936360666710083E+06,       0.102029774479476604E+06,       0.102113550935132720E+06,
        0.102187275245992423E+06,       0.102251742085495353E+06,       0.102308744854441014E+06,       0.102354056548559587E+06,       0.102395496326958368E+06,
        0.102432085609497080E+06,       0.102463450245845990E+06,       0.102489865598489851E+06,       0.102514853262571502E+06,       0.102534082770129738E+06,
        0.102548592777604266E+06,       0.102559883810599669E+06,       0.102568794081739034E+06,       0.102579021392062437E+06,       0.102585007107402751E+06,
        0.102586497457448539E+06,       0.102584376842419224E+06,       0.102580903181294503E+06,       0.102577151681759657E+06,       0.102573827515381417E+06,
        0.102568538059750121E+06,       0.102560561364228692E+06,       0.102548460310359820E+06,       0.102530289426340809E+06,       0.102505861568008157E+06,
        0.102475498063954670E+06,       0.102440643792700503E+06,       0.102396241614374099E+06,       0.102341446243588929E+06,       0.102276649353635905E+06,
        0.102199862029058393E+06,       0.102111863644497949E+06,       0.102014314786398143E+06,       0.101910607455440113E+06,       0.101806306816961252E+06,
        0.101704399917697054E+06,       0.101609603981306922E+06,       0.101526211311625375E+06,       0.101459322473350869E+06,       0.101412795838567283E+06,
        0.101389618525710335E+06,       0.101393845554395113E+06,       0.101424357742906359E+06,       0.101472713797786171E+06,       0.101522607587252613E+06,
        0.101559998357663775E+06,       0.101576743781235520E+06,       0.101573310646049868E+06,       0.101549833954751783E+06,       0.101514456685338067E+06,
        0.101472694191529066E+06,       0.101434208011361596E+06,       0.101406914911600485E+06,       0.101398454904380153E+06,       0.101415253675564527E+06,
        0.101455136695375608E+06,       0.101512719547979839E+06,       0.101577237869349250E+06,       0.101641152022720256E+06,       0.101700396834169049E+06,
        0.101757567947174000E+06,       0.101815111575731135E+06,       0.101874014294397304E+06,       0.101930155420364375E+06,       0.101979578233631371E+06,
        0.102017827567168875E+06,       0.102041453032023797E+06,       0.102049181677356071E+06,       0.102042624564991027E+06,       0.102027458526470917E+06,
        0.101998856271186160E+06,       0.101958763385915998E+06,       0.101909825004560786E+06,       0.101855834630693556E+06,       0.101803471305377156E+06,
        0.101751840395667561E+06,       0.101701669671223848E+06,       0.101657371568089962E+06,       0.101614737302306821E+06,       0.101571808841198203E+06,
        0.101529035182503387E+06,       0.101487836291383923E+06,       0.101448187429775586E+06,       0.101410201287687276E+06,       0.101375725543945955E+06,
        0.101354091334976038E+06,       0.101343701275904139E+06,       0.101337958790157587E+06,       0.101334014323027164E+06,       0.101323058410853802E+06,
        0.101303680281432564E+06,       0.101285071086934273E+06,       0.101269046902558985E+06,       0.101256912292666253E+06,       0.101239485050412128E+06,
        0.101225094542196108E+06,       0.101214114558167246E+06,       0.101206300766355242E+06,       0.101205366180458252E+06,       0.101205376802251209E+06,
        0.101196436467417006E+06,       0.101184014918681118E+06,       0.101170971956995039E+06,       0.101173896703063627E+06,       0.101186778426832985E+06,
        0.101207425966799259E+06,       0.101235075391491133E+06,       0.101268299800364039E+06,       0.101308063493844020E+06,       0.101344788336284473E+06,
        0.101376389450400151E+06,       0.101402378295128001E+06,       0.101423140134659829E+06,       0.101438782026730638E+06,       0.101455746728587110E+06,
        0.101479368387625509E+06,       0.101509546030359561E+06,       0.101546739387306210E+06,       0.100893625093361974E+06,       0.100948455392464501E+06,
        0.101011317645263582E+06,       0.101080913011082172E+06,       0.101155302174425058E+06,       0.101233112731396410E+06,       0.101312551980581891E+06,
        0.101391810121618284E+06,       0.101469643740293817E+06,       0.101547894952444782E+06,       0.101619713078854009E+06,       0.101683304064554628E+06,
        0.101737232999154556E+06,       0.101779617777438179E+06,       0.101805388291197829E+06,       0.101820150398714570E+06,       0.101824280737551730E+06,
        0.101819067925622789E+06,       0.101806980910888844E+06,       0.101787436214918198E+06,       0.101761287349566453E+06,       0.101729423465328233E+06,
        0.101692622608612961E+06,       0.101651573936670728E+06,       0.101611590783753491E+06,       0.101562833006838278E+06,       0.101502364394767414E+06,
        0.101438724936641054E+06,       0.101373805958635741E+06,       0.101309369954324357E+06,       0.101246873385268977E+06,       0.101187267453513661E+06,
        0.101122914968029043E+06,       0.101055428119650373E+06,       0.101008249772026029E+06,       0.100979473982631680E+06,       0.100972177967227311E+06,
        0.100988832853860484E+06,       0.101031262783445170E+06,       0.101112202656024601E+06,       0.101211093846252057E+06,       0.101323155130905317E+06,
        0.101443212391304434E+06,       0.101565274984548159E+06,       0.101675064133449094E+06,       0.101783046764746541E+06,       0.101883427362778093E+06,
        0.101974048605326316E+06,       0.102054089915572622E+06,       0.102123916001737191E+06,       0.102185138506351650E+06,       0.102239277647944138E+06,
        0.102288043635062262E+06,       0.102329848961112002E+06,       0.102365570526105090E+06,       0.102398175565311816E+06,       0.102427118018994763E+06,
        0.102451215888181687E+06,       0.102470889959435211E+06,       0.102487322259304128E+06,       0.102507363262553656E+06,       0.102522539511451090E+06,
        0.102533202617323841E+06,       0.102538447738773189E+06,       0.102539366679125000E+06,       0.102537806325041631E+06,       0.102534134338413278E+06,
        0.102529616480806799E+06,       0.102525504718401397E+06,       0.102520340764588414E+06,       0.102512361946182253E+06,       0.102499685852779818E+06,
        0.102481370178637997E+06,       0.102461804458447645E+06,       0.102433116211535496E+06,       0.102394820498302695E+06,       0.102344806742965229E+06,
        0.102282869771580241E+06,       0.102208190347609911E+06,       0.102122230232017173E+06,       0.102026360478078772E+06,       0.101922376088166435E+06,
        0.101815964790077211E+06,       0.101712553837059808E+06,       0.101615912730210781E+06,       0.101531538428717235E+06,       0.101462015329520931E+06,
        0.101411095529211190E+06,       0.101383553801811446E+06,       0.101387868686696354E+06,       0.101419065450411930E+06,       0.101465197763774107E+06,
        0.101514122624701689E+06,       0.101554157750064871E+06,       0.101577510533460605E+06,       0.101578561408166206E+06,       0.101561717136454608E+06,
        0.101527942832344896E+06,       0.101485492708933743E+06,       0.101442040681691869E+06,       0.101407214730937660E+06,       0.101391475969427891E+06,
        0.101402057936737707E+06,       0.101438129992839313E+06,       0.101494675186752138E+06,       0.101561405991801003E+06,       0.101631832958464947E+06,
        0.101700764128050694E+06,       0.101765471244284083E+06,       0.101829298739144535E+06,       0.101891487805957440E+06,       0.101949649930012936E+06,
        0.101996983260441179E+06,       0.102028825999188412E+06,       0.102041977726062381E+06,       0.102037063043873364E+06,       0.102018484271153007E+06,
        0.101987519813082123E+06,       0.101953322744109144E+06,       0.101911210582393775E+06,       0.101863879485885569E+06,       0.101813868935175255E+06,
        0.101763558865488987E+06,       0.101714781421884982E+06,       0.101669784944327868E+06,       0.101626116114336663E+06,       0.101583855166139518E+06,
        0.101542346971029430E+06,       0.101502633877275308E+06,       0.101464939559164166E+06,       0.101426766367174598E+06,       0.101390458857219390E+06,
        0.101358471458522574E+06,       0.101334112694217969E+06,       0.101328407691393310E+06,       0.101330874497622441E+06,       0.101337110359200757E+06,
        0.101343736678259927E+06,       0.101343244142495707E+06,       0.101341300900043818E+06,       0.101339844172589394E+06,       0.101338724330486657E+06,
        0.101333664918719776E+06,       0.101322891249048946E+06,       0.101311826452015521E+06,       0.101299221594776434E+06,       0.101282571152943405E+06,
        0.101266530780531204E+06,       0.101246643011162712E+06,       0.101224150063358495E+06,       0.101202571591745436E+06,       0.101188612840670292E+06,
        0.101199966484071061E+06,       0.101222097051704724E+06,       0.101260233588647054E+06,       0.101304129252313578E+06,       0.101350161554908336E+06,
        0.101389652624068185E+06,       0.101424551417429771E+06,       0.101454274075586436E+06,       0.101479148917351384E+06,       0.101500388782067501E+06,
        0.101525545796928971E+06,       0.101562513561929518E+06,       0.101606090475506091E+06,       0.101653619386718725E+06,       0.100845507039246062E+06,
        0.100900566753226827E+06,       0.100964147998307293E+06,       0.101035004760987780E+06,       0.101111734714359307E+06,       0.101192123809297234E+06,
        0.101274156352906692E+06,       0.101357605885697238E+06,       0.101443671119726976E+06,       0.101525544557033369E+06,       0.101601182677887831E+06,
        0.101668789681363778E+06,       0.101726898348598319E+06,       0.101774441929614739E+06,       0.101810815552412794E+06,       0.101832035149566495E+06,
        0.101838765440822797E+06,       0.101835596101807649E+06,       0.101823419644672496E+06,       0.101802715728713345E+06,       0.101774151142095492E+06,
        0.101738457612419079E+06,       0.101696295926065533E+06,       0.101648104911459959E+06,       0.101590285842002006E+06,       0.101521209919707282E+06,
        0.101450839575846665E+06,       0.101376697188940336E+06,       0.101300744148618498E+06,       0.101224863840720194E+06,       0.101150697403150189E+06,
        0.101073301607053800E+06,       0.100983235760375988E+06,       0.100901684378507489E+06,       0.100833101972986929E+06,       0.100781373167571786E+06,
        0.100760772506158712E+06,       0.100768040826660945E+06,       0.100819963855216105E+06,       0.100898361962391151E+06,       0.100996401252706506E+06,
        0.101109805590524003E+06,       0.101233684034863138E+06,       0.101362757333502159E+06,       0.101494642793831357E+06,       0.101619684005633680E+06,
        0.101728129058541483E+06,       0.101825059560781054E+06,       0.101910320070122136E+06,       0.101982389350624275E+06,       0.102044412115271698E+06,
        0.102100145695870931E+06,       0.102151182120026933E+06,       0.102199014246850449E+06,       0.102244844616859526E+06,       0.102284509458517772E+06,
        0.102318215421307876E+06,       0.102347902960885476E+06,       0.102373421335254781E+06,       0.102401951332123936E+06,       0.102429181477717284E+06,
        0.102450532016644735E+06,       0.102465997336774948E+06,       0.102475777963121422E+06,       0.102478313815590023E+06,       0.102478110250759957E+06,
        0.102475657036715347E+06,       0.102471918321198871E+06,       0.102469939192222024E+06,       0.102467007436977176E+06,       0.102462490014742158E+06,
        0.102456722431479779E+06,       0.102450737615132341E+06,       0.102440335034919917E+06,       0.102420575011656954E+06,       0.102389812989896382E+06,
        0.102347122683242473E+06,       0.102292275082950306E+06,       0.102224438636867562E+06,       0.102143836217952965E+06,       0.102050866494433591E+06,
        0.101949943411085245E+06,       0.101845736377779569E+06,       0.101742816153747364E+06,       0.101647911129982123E+06,       0.101563216996056130E+06,
        0.101491604823778136E+06,       0.101437861556007003E+06,       0.101412287502927546E+06,       0.101412856551671823E+06,       0.101435247443498505E+06,
        0.101472966599928535E+06,       0.101514519271643498E+06,       0.101550307716508367E+06,       0.101572773831424129E+06,       0.101577300876503461E+06,
        0.101561783761491213E+06,       0.101528832671536744E+06,       0.101487621468217170E+06,       0.101449333621855301E+06,       0.101421572690143163E+06,
        0.101412849368901254E+06,       0.101428815273143569E+06,       0.101468452704213269E+06,       0.101526342258825374E+06,       0.101593070240422909E+06,
        0.101660293633886846E+06,       0.101724359259873541E+06,       0.101785772418607943E+06,       0.101847556062125179E+06,       0.101908363003809383E+06,
        0.101961701914240010E+06,       0.102002429874153109E+06,       0.102025185688122059E+06,       0.102030228237618969E+06,       0.102016392623057240E+06,
        0.101989203583738155E+06,       0.101954215596148948E+06,       0.101916658897302012E+06,       0.101876815696310456E+06,       0.101833071043157586E+06,
        0.101787308476072212E+06,       0.101741539193291770E+06,       0.101697630101558476E+06,       0.101654119182481736E+06,       0.101610960850170581E+06,
        0.101569179414185535E+06,       0.101528773468682877E+06,       0.101490142318063241E+06,       0.101454189911789217E+06,       0.101420537325155994E+06,
        0.101387196165512592E+06,       0.101359208745426033E+06,       0.101338989486127597E+06,       0.101329695327606096E+06,       0.101338867992364074E+06,
        0.101355871810450670E+06,       0.101375430345140587E+06,       0.101394209504973755E+06,       0.101402919751202760E+06,       0.101410688334029808E+06,
        0.101416920285657412E+06,       0.101420489242522977E+06,       0.101413658635510583E+06,       0.101399351916641783E+06,       0.101380364637205465E+06,
        0.101357315413079603E+06,       0.101331383086953632E+06,       0.101302463143222500E+06,       0.101271861027862804E+06,       0.101243797629858222E+06,
        0.101225102912379341E+06,       0.101230895188582799E+06,       0.101260967028080006E+06,       0.101301126414935963E+06,       0.101347821784489817E+06,
        0.101397550525323837E+06,       0.101444003541722705E+06,       0.101480976560253359E+06,       0.101512946357403111E+06,       0.101540212183607568E+06,
        0.101567953884550225E+06,       0.101594468785546575E+06,       0.101637676393726375E+06,       0.101688399693186482E+06,       0.101742930184759069E+06,
        0.100795882153115017E+06,       0.100850797431345025E+06,       0.100914750948998306E+06,       0.100986523708389999E+06,       0.101064741053657359E+06,
        0.101147944583867647E+06,       0.101236474647069423E+06,       0.101327593382317646E+06,       0.101416818345205553E+06,       0.101501970105562199E+06,
        0.101581006340059568E+06,       0.101652107178935606E+06,       0.101713753841424812E+06,       0.101764799350409041E+06,       0.101804529976921447E+06,
        0.101832451081090258E+06,       0.101847567048303332E+06,       0.101846442214230046E+06,       0.101834900151378431E+06,       0.101813744156519519E+06,
        0.101783490044669117E+06,       0.101744750228076155E+06,       0.101698109004179641E+06,       0.101641364118676778E+06,       0.101569583201128436E+06,
        0.101490816574609969E+06,       0.101406531256311253E+06,       0.101319625817001812E+06,       0.101233091961074242E+06,       0.101146347584902731E+06,
        0.101058989124578555E+06,       0.100953964690316512E+06,       0.100852899705475327E+06,       0.100760578698964149E+06,       0.100681685450575751E+06,
        0.100620492778267973E+06,       0.100580496608869158E+06,       0.100579462774121028E+06,       0.100625977088063315E+06,       0.100699672061534206E+06,
        0.100794647180633037E+06,       0.100907249288633233E+06,       0.101033016501104474E+06,       0.101170532820658074E+06,       0.101310202043631813E+06,
        0.101443951517617694E+06,       0.101566665342990047E+06,       0.101674561727816923E+06,       0.101762857707379371E+06,       0.101831050817027455E+06,
        0.101892059674295087E+06,       0.101947353598683054E+06,       0.101998507084363489E+06,       0.102047351014086569E+06,       0.102096770563981801E+06,
        0.102143221374936838E+06,       0.102186890306655871E+06,       0.102228196597294736E+06,       0.102264105567156759E+06,       0.102302445150954794E+06,
        0.102336246787148004E+06,       0.102363781472504663E+06,       0.102384291162903231E+06,       0.102397430622010026E+06,       0.102403312624922473E+06,
        0.102403832627536103E+06,       0.102402612769131738E+06,       0.102401390930183130E+06,       0.102401466546220196E+06,       0.102401874865610895E+06,
        0.102402100027913009E+06,       0.102404524182350739E+06,       0.102408945753433436E+06,       0.102408228479075435E+06,       0.102399207567720179E+06,
        0.102378727543360583E+06,       0.102346081419689654E+06,       0.102300584036716507E+06,       0.102242408524207058E+06,       0.102170172560628038E+06,
        0.102084827969266131E+06,       0.101990466580006148E+06,       0.101891305283198890E+06,       0.101794051647235989E+06,       0.101701758202335564E+06,
        0.101617607399452128E+06,       0.101545673956610553E+06,       0.101493920019806435E+06,       0.101463389589686616E+06,       0.101454707404169429E+06,
        0.101465784796775130E+06,       0.101489404864046577E+06,       0.101519701691131908E+06,       0.101547620610180951E+06,       0.101565576165996550E+06,
        0.101562026624260950E+06,       0.101539419490073633E+06,       0.101508015501831396E+06,       0.101475602714955035E+06,       0.101449209652947975E+06,
        0.101436251410560508E+06,       0.101442877175111498E+06,       0.101471341372345414E+06,       0.101518178052896081E+06,       0.101577355032239313E+06,
        0.101641314782584261E+06,       0.101703564541155953E+06,       0.101762362987943518E+06,       0.101818379277178246E+06,       0.101872714548978096E+06,
        0.101924119264252775E+06,       0.101966776195386803E+06,       0.101995500768842219E+06,       0.102007086660768691E+06,       0.102002030153628395E+06,
        0.101985038462701981E+06,       0.101956611217972633E+06,       0.101924174284332606E+06,       0.101890531345005773E+06,       0.101858684611865552E+06,
        0.101821867670641383E+06,       0.101781442886233301E+06,       0.101738169818174909E+06,       0.101693020445221118E+06,       0.101649533509090848E+06,
        0.101606065252630258E+06,       0.101563356987927487E+06,       0.101522196794781717E+06,       0.101483000104046587E+06,       0.101448492093986119E+06,
        0.101420196255985837E+06,       0.101395294590973572E+06,       0.101373162271020163E+06,       0.101359621762719311E+06,       0.101356933368830039E+06,
        0.101368947980949306E+06,       0.101392192190573551E+06,       0.101417779659041989E+06,       0.101442531040709990E+06,       0.101462476541542521E+06,
        0.101476476704636079E+06,       0.101486973325915984E+06,       0.101492708978460287E+06,       0.101491506327010982E+06,       0.101476163566485891E+06,
        0.101454012045195879E+06,       0.101426588508176050E+06,       0.101395767868210212E+06,       0.101361555520167341E+06,       0.101327388871009054E+06,
        0.101300667576237203E+06,       0.101284994174892112E+06,       0.101283350959747040E+06,       0.101309210052713708E+06,       0.101350688755181967E+06,
        0.101399465772761600E+06,       0.101451857069433157E+06,       0.101504338927611956E+06,       0.101548087731741456E+06,       0.101585173851711908E+06,
        0.101617418107249265E+06,       0.101645918462371425E+06,       0.101672368866688703E+06,       0.101702644054264791E+06,       0.101756834440843944E+06,
        0.101815020493009375E+06,       0.100745394112667054E+06,       0.100799832870823317E+06,       0.100863855953311213E+06,       0.100936251298315474E+06,
        0.101015648499264644E+06,       0.101104654341683374E+06,       0.101200128443110370E+06,       0.101296361142831636E+06,       0.101389195762127056E+06,
        0.101477275829104881E+06,       0.101559295351936235E+06,       0.101633387586243814E+06,       0.101697961740723156E+06,       0.101751772598623953E+06,
        0.101793901427349119E+06,       0.101823866729636080E+06,       0.101841583691637163E+06,       0.101847052782340179E+06,       0.101840097601263231E+06,
        0.101819364884434224E+06,       0.101788292383590582E+06,       0.101747405137351147E+06,       0.101695621343299601E+06,       0.101627436111935327E+06,
        0.101550322384277897E+06,       0.101465476616664964E+06,       0.101374194733789423E+06,       0.101277718928660746E+06,       0.101177047947947533E+06,
        0.101075621770040874E+06,       0.100963507971772880E+06,       0.100850151599165794E+06,       0.100741049456883455E+06,       0.100641201275214524E+06,
        0.100555640521779089E+06,       0.100489164793431541E+06,       0.100453712051746988E+06,       0.100455966233873114E+06,       0.100484341033634380E+06,
        0.100537490332318921E+06,       0.100620003905902136E+06,       0.100729309835612949E+06,       0.100858870023752374E+06,       0.101002649715674357E+06,
        0.101147678361066428E+06,       0.101287802540963821E+06,       0.101417496539417145E+06,       0.101532273896933402E+06,       0.101613683175199098E+06,
        0.101680723164626179E+06,       0.101737444859119263E+06,       0.101791182708811306E+06,       0.101841314940347904E+06,       0.101891796533315224E+06,
        0.101941590080887530E+06,       0.101990059211011772E+06,       0.102037355306302023E+06,       0.102083701488133767E+06,       0.102136891332944331E+06,
        0.102186806386969169E+06,       0.102230479823408270E+06,       0.102264774535572782E+06,       0.102290420308268731E+06,       0.102307702555592783E+06,
        0.102317766904831617E+06,       0.102321662148245741E+06,       0.102321498408406202E+06,       0.102320441248726507E+06,       0.102319523718290511E+06,
        0.102322447750704567E+06,       0.102327503158949214E+06,       0.102340754529364640E+06,       0.102353506384693246E+06,       0.102362358688122375E+06,
        0.102364445626707267E+06,       0.102355674159446760E+06,       0.102335040551811529E+06,       0.102301981999839074E+06,       0.102255676163442389E+06,
        0.102195798314690837E+06,       0.102122639698007450E+06,       0.102039086723219865E+06,       0.101949840960878224E+06,       0.101859938889724974E+06,
        0.101771880315094095E+06,       0.101689691466275064E+06,       0.101619553461018091E+06,       0.101564784382206009E+06,       0.101527063676792590E+06,
        0.101506865347517232E+06,       0.101503522390084341E+06,       0.101512744653858725E+06,       0.101529231308459130E+06,       0.101545937638918578E+06,
        0.101543746232650679E+06,       0.101529149091683401E+06,       0.101505036617385034E+06,       0.101477259643610611E+06,       0.101452985842091570E+06,
        0.101443019818922796E+06,       0.101450005107018835E+06,       0.101477223491849247E+06,       0.101523231314288976E+06,       0.101581629450517838E+06,
        0.101644098508760901E+06,       0.101703051093558723E+06,       0.101755080739197074E+06,       0.101801349748540073E+06,       0.101847343504094184E+06,
        0.101892088842664132E+06,       0.101930776572625342E+06,       0.101959972929516225E+06,       0.101973275480066382E+06,       0.101972016851233420E+06,
        0.101959747868463455E+06,       0.101940685784926434E+06,       0.101919336338791196E+06,       0.101894507185877927E+06,       0.101871113669696017E+06,
        0.101847657889249851E+06,       0.101820887903955852E+06,       0.101784170021964572E+06,       0.101741602583369866E+06,       0.101694747059338464E+06,
        0.101647292622998575E+06,       0.101600773270067424E+06,       0.101554052329806203E+06,       0.101509997350416306E+06,       0.101472107321641699E+06,
        0.101442071551669200E+06,       0.101420240877131699E+06,       0.101406891473258380E+06,       0.101396015807551084E+06,       0.101392164060749914E+06,
        0.101397198621684831E+06,       0.101410725481402653E+06,       0.101436168965154429E+06,       0.101464448461599168E+06,       0.101491134274545591E+06,
        0.101513817760506034E+06,       0.101531534488231206E+06,       0.101544658070101810E+06,       0.101551681755858954E+06,       0.101551216434335554E+06,
        0.101539195357785327E+06,       0.101514919199184893E+06,       0.101483010220912314E+06,       0.101448007466093870E+06,       0.101414858070553688E+06,
        0.101383218898751307E+06,       0.101359262217297684E+06,       0.101346709055278770E+06,       0.101347915439013712E+06,       0.101365119587774912E+06,
        0.101407924765819262E+06,       0.101458658683875430E+06,       0.101515675014729291E+06,       0.101573920518004117E+06,       0.101629788706552135E+06,
        0.101668434413804149E+06,       0.101700504314289530E+06,       0.101727848552964642E+06,       0.101752288382924846E+06,       0.101776226460626523E+06,
        0.101814361167678813E+06,       0.101872139466116685E+06,       0.100694816386903738E+06,       0.100748531064111390E+06,       0.100812413075077391E+06,
        0.100885240325433202E+06,       0.100971984589634725E+06,       0.101066079836500590E+06,       0.101163332246353209E+06,       0.101261519892330936E+06,
        0.101358385768427062E+06,       0.101451421123224791E+06,       0.101536054276749637E+06,       0.101612689419430462E+06,       0.101679641914763270E+06,
        0.101735174644287632E+06,       0.101778750617147758E+06,       0.101810665166487233E+06,       0.101830410029895895E+06,       0.101837810772118624E+06,
        0.101833022665443903E+06,       0.101816510393020842E+06,       0.101787854012666052E+06,       0.101744823421577603E+06,       0.101683938556403096E+06,
        0.101613036597664483E+06,       0.101532884942156001E+06,       0.101444504410039342E+06,       0.101349069651044396E+06,       0.101247781610335631E+06,
        0.101141708506075884E+06,       0.101021202144232695E+06,       0.100894721062327983E+06,       0.100769982600624178E+06,       0.100655427823023274E+06,
        0.100550770964121868E+06,       0.100461477319971644E+06,       0.100396193533225101E+06,       0.100370475160386210E+06,       0.100369362731624045E+06,
        0.100393088104568509E+06,       0.100440996230512974E+06,       0.100511511049115361E+06,       0.100603846780177613E+06,       0.100726574426591877E+06,
        0.100871208402494914E+06,       0.101018016887883554E+06,       0.101160944293748136E+06,       0.101294154343677379E+06,       0.101398406532467285E+06,
        0.101478074072107382E+06,       0.101546049324473512E+06,       0.101603974418745871E+06,       0.101653727077973454E+06,       0.101697954544609078E+06,
        0.101741376690074656E+06,       0.101789988330066262E+06,       0.101838680208411213E+06,       0.101887795803836605E+06,       0.101942598855672841E+06,
        0.102000837418646348E+06,       0.102056277940396962E+06,       0.102106768405713607E+06,       0.102150535774670396E+06,       0.102182996899048041E+06,
        0.102206750157000613E+06,       0.102221201245532342E+06,       0.102228757950974235E+06,       0.102230269318708335E+06,       0.102229908214737996E+06,
        0.102230221444085299E+06,       0.102233117647704858E+06,       0.102243955867660014E+06,       0.102261169827573845E+06,       0.102280623025385154E+06,
        0.102298710646779829E+06,       0.102311720481040116E+06,       0.102316483254606297E+06,       0.102310329085876278E+06,       0.102292054686377145E+06,
        0.102261582445110776E+06,       0.102217278999264774E+06,       0.102159938958497296E+06,       0.102090651836751262E+06,       0.102014420809727890E+06,
        0.101933158619991009E+06,       0.101851325383247095E+06,       0.101773700996606422E+06,       0.101704655579852813E+06,       0.101645470306280142E+06,
        0.101599387487163476E+06,       0.101568762309086727E+06,       0.101551200721109650E+06,       0.101544950055199806E+06,       0.101545234940555893E+06,
        0.101536151271568684E+06,       0.101520957074193793E+06,       0.101499514166347813E+06,       0.101472481430049040E+06,       0.101447481037651174E+06,
        0.101431698928562022E+06,       0.101432519665399988E+06,       0.101455989679772596E+06,       0.101503867701139068E+06,       0.101569707321795955E+06,
        0.101641541183263049E+06,       0.101707359784777087E+06,       0.101760909663319078E+06,       0.101802944092112913E+06,       0.101837429073186562E+06,
        0.101868490058515003E+06,       0.101895999089963501E+06,       0.101921719560774494E+06,       0.101935208629263929E+06,       0.101934734847469299E+06,
        0.101921789770189804E+06,       0.101905337918664198E+06,       0.101889233907825823E+06,       0.101876223533093609E+06,       0.101864529046626514E+06,
        0.101850666495852842E+06,       0.101835575764428810E+06,       0.101815211112956240E+06,       0.101783740571016519E+06,       0.101739678309719806E+06,
        0.101689041718466135E+06,       0.101634899667157661E+06,       0.101583884425190394E+06,       0.101535509776931387E+06,       0.101491128441498251E+06,
        0.101453011421685966E+06,       0.101428708334432333E+06,       0.101415133080661239E+06,       0.101411902195392497E+06,       0.101415741142001993E+06,
        0.101421700628259656E+06,       0.101434916879656914E+06,       0.101454096376128975E+06,       0.101478884585159176E+06,       0.101507961817356219E+06,
        0.101534772926637874E+06,       0.101557090728886120E+06,       0.101574113620330667E+06,       0.101587280909418565E+06,       0.101593317203057959E+06,
        0.101589233196906163E+06,       0.101574814776511601E+06,       0.101547332581751762E+06,       0.101514869284270651E+06,       0.101481998192358122E+06,
        0.101452150550811974E+06,       0.101427572510067519E+06,       0.101409813743047896E+06,       0.101403676308175665E+06,       0.101410943983370715E+06,
        0.101433007929108295E+06,       0.101473704830047689E+06,       0.101528968358056605E+06,       0.101588585098966272E+06,       0.101648865730780017E+06,
        0.101706538485246449E+06,       0.101754905727487509E+06,       0.101785976200502380E+06,       0.101811017148794053E+06,       0.101832089114193281E+06,
        0.101851827047180632E+06,       0.101871848271984418E+06,       0.101914442748880043E+06,       0.100645050821058583E+06,       0.100697921098829320E+06,
        0.100761591261288675E+06,       0.100844244243942405E+06,       0.100934005537327830E+06,       0.101028963380699686E+06,       0.101127123691640561E+06,
        0.101226361187462535E+06,       0.101324505036089657E+06,       0.101419431488063798E+06,       0.101509163971173737E+06,       0.101590063785101636E+06,
        0.101657671467199980E+06,       0.101713396702810118E+06,       0.101758515364488485E+06,       0.101792091325616479E+06,       0.101813481673006056E+06,
        0.101822350253392695E+06,       0.101818668615804971E+06,       0.101802702749391727E+06,       0.101774619027333058E+06,       0.101728109831474241E+06,
        0.101668908134665704E+06,       0.101597584119515159E+06,       0.101516856663981162E+06,       0.101427599824837293E+06,       0.101330896414631075E+06,
        0.101227935201261804E+06,       0.101113372919066416E+06,       0.100989129696766337E+06,       0.100861373889168084E+06,       0.100733678225485171E+06,
        0.100610105917794019E+06,       0.100495004451233079E+06,       0.100402578780181022E+06,       0.100353109983544055E+06,       0.100326440206043859E+06,
        0.100322735531117156E+06,       0.100342802276422299E+06,       0.100386646482634504E+06,       0.100453451962470805E+06,       0.100549574897853177E+06,
        0.100666205550992949E+06,       0.100795807241975184E+06,       0.100931381874395069E+06,       0.101067411193584325E+06,       0.101192762302618430E+06,
        0.101283622761741586E+06,       0.101362350787791220E+06,       0.101430423297678528E+06,       0.101489314399921583E+06,       0.101540641111512159E+06,
        0.101585585061290316E+06,       0.101627410996723280E+06,       0.101667724011934901E+06,       0.101707970653555123E+06,       0.101751269935565215E+06,
        0.101811021944586406E+06,       0.101870809774501089E+06,       0.101928469764575537E+06,       0.101981732364511379E+06,       0.102026310772180412E+06,
        0.102061898497918446E+06,       0.102089845634957077E+06,       0.102110105242362508E+06,       0.102121882127719451E+06,       0.102124061355970684E+06,
        0.102123733324673376E+06,       0.102124546125847337E+06,       0.102129219082775890E+06,       0.102145351303200790E+06,       0.102166260171440692E+06,
        0.102190433845960331E+06,       0.102216291023032318E+06,       0.102242152119835548E+06,       0.102260901292175229E+06,       0.102271019053290802E+06,
        0.102270194336435845E+06,       0.102258376332468251E+06,       0.102232740434276260E+06,       0.102193082447496578E+06,       0.102140339518538545E+06,
        0.102077291761659100E+06,       0.102007943796066291E+06,       0.101934901694509579E+06,       0.101863769251748963E+06,       0.101795867039438526E+06,
        0.101734634917306947E+06,       0.101683465453549536E+06,       0.101643719755611994E+06,       0.101613589850316028E+06,       0.101591266195843433E+06,
        0.101568063676064237E+06,       0.101544190597726789E+06,       0.101518173523634308E+06,       0.101489293133355706E+06,       0.101456969224960791E+06,
        0.101429471204937334E+06,       0.101413477375518429E+06,       0.101417790921687454E+06,       0.101450822395921219E+06,       0.101510233193849519E+06,
        0.101585841462266966E+06,       0.101664438788265412E+06,       0.101733920550829818E+06,       0.101788706066789920E+06,       0.101825829329588349E+06,
        0.101850405636027645E+06,       0.101871083937706790E+06,       0.101887382097668247E+06,       0.101896455049501354E+06,       0.101897289413654769E+06,
        0.101886248870001597E+06,       0.101867415759247539E+06,       0.101847995171556977E+06,       0.101838485076295401E+06,       0.101834100858943464E+06,
        0.101832686427819717E+06,       0.101828063075528247E+06,       0.101816399093795466E+06,       0.101796719243765314E+06,       0.101767216502717842E+06,
        0.101721966250064579E+06,       0.101668953652310433E+06,       0.101611959093829370E+06,       0.101556227036786251E+06,       0.101506414279391960E+06,
        0.101461971390057777E+06,       0.101425468706421860E+06,       0.101404163733341426E+06,       0.101399096476539751E+06,       0.101405522879150667E+06,
        0.101421050121819761E+06,       0.101438689378578158E+06,       0.101460180927881505E+06,       0.101485796004159551E+06,       0.101513713918150577E+06,
        0.101542550860272706E+06,       0.101568068025141562E+06,       0.101588331740948968E+06,       0.101600913455480535E+06,       0.101607630152187616E+06,
        0.101607407012941694E+06,       0.101598607139348926E+06,       0.101581645287700347E+06,       0.101557205094100689E+06,       0.101527626140599372E+06,
        0.101498954813168501E+06,       0.101474478229909684E+06,       0.101456851592814171E+06,       0.101447916547657107E+06,       0.101451532249133510E+06,
        0.101469023039587555E+06,       0.101500095660945575E+06,       0.101543265481331633E+06,       0.101599989966535504E+06,       0.101661394639400824E+06,
        0.101722843298708525E+06,       0.101781217785530855E+06,       0.101833962893083750E+06,       0.101869504665579036E+06,       0.101891006131465809E+06,
        0.101907724224272592E+06,       0.101922174311177543E+06,       0.101935867942354409E+06,       0.101950426065447158E+06,       0.100607098755765037E+06,
        0.100655240281701743E+06,       0.100726600376942501E+06,       0.100809356254825645E+06,       0.100899004634437370E+06,       0.100993829979357848E+06,
        0.101091906852125423E+06,       0.101191172811513417E+06,       0.101289507328918466E+06,       0.101384817108912728E+06,       0.101475128234200398E+06,
        0.101556622026723067E+06,       0.101627508170991190E+06,       0.101685968687809233E+06,       0.101732567539073978E+06,       0.101767665006896481E+06,
        0.101790488350008833E+06,       0.101800548295886649E+06,       0.101797644943693944E+06,       0.101781861361740375E+06,       0.101747873759633774E+06,
        0.101701859594637368E+06,       0.101644745116156497E+06,       0.101577648617696381E+06,       0.101501095515959882E+06,       0.101413668608079461E+06,
        0.101318547892610906E+06,       0.101214143017131020E+06,       0.101099338905386365E+06,       0.100978397278849705E+06,       0.100854041321450713E+06,
        0.100729710648106629E+06,       0.100609462614676057E+06,       0.100497826949930561E+06,       0.100414459388165211E+06,       0.100356511886266162E+06,
        0.100322777395156372E+06,       0.100316042351856522E+06,       0.100332097081535409E+06,       0.100371561029088683E+06,       0.100439298341075264E+06,
        0.100532568922400489E+06,       0.100643002914990837E+06,       0.100765387761929349E+06,       0.100893492581718543E+06,       0.101020399500629603E+06,
        0.101112706098134367E+06,       0.101194570041727216E+06,       0.101269273413618284E+06,       0.101335562528605122E+06,       0.101394060212437602E+06,
        0.101445483977905038E+06,       0.101491335215433006E+06,       0.101533800970901357E+06,       0.101574594133775521E+06,       0.101615314066683874E+06,
        0.101662259781339875E+06,       0.101713149881755875E+06,       0.101764653351764238E+06,       0.101815034877485959E+06,       0.101864609985221337E+06,
        0.101906670614871124E+06,       0.101942016196974146E+06,       0.101970135166829859E+06,       0.101990609169172516E+06,       0.101996950610404732E+06,
        0.101996810049367472E+06,       0.101996317886868128E+06,       0.101998445642552077E+06,       0.102008824591142213E+06,       0.102027635971959302E+06,
        0.102051641514833580E+06,       0.102080850665324571E+06,       0.102117904503131693E+06,       0.102157634194590821E+06,       0.102192504721610734E+06,
        0.102219235460459910E+06,       0.102236777347130861E+06,       0.102242902162718834E+06,       0.102236355155139478E+06,       0.102216651883876315E+06,
        0.102180426444035780E+06,       0.102133083528179093E+06,       0.102077034681391349E+06,       0.102016323324797893E+06,       0.101953628282518228E+06,
        0.101890856388452012E+06,       0.101830915333128054E+06,       0.101779447310396441E+06,       0.101734080624489550E+06,       0.101693870504157734E+06,
        0.101656684022070389E+06,       0.101619340499046710E+06,       0.101584139894536143E+06,       0.101548750508560886E+06,       0.101508927593507731E+06,
        0.101469477866382847E+06,       0.101436805815304979E+06,       0.101415993387059803E+06,       0.101423466131997789E+06,       0.101453632286171531E+06,
        0.101508029375078389E+06,       0.101580823336132147E+06,       0.101656593588021438E+06,       0.101722011470405239E+06,       0.101771508397742451E+06,
        0.101807913013677957E+06,       0.101834964343916130E+06,       0.101850402618856344E+06,       0.101859186985402383E+06,       0.101860587418252151E+06,
        0.101854518941434624E+06,       0.101838720084331697E+06,       0.101819824582356232E+06,       0.101803402458019846E+06,       0.101796893209118367E+06,
        0.101799592648883248E+06,       0.101802452116411427E+06,       0.101801265547130839E+06,       0.101788566176828695E+06,       0.101765879286445153E+06,
        0.101732953696931960E+06,       0.101687950182710265E+06,       0.101633167492824286E+06,       0.101575598313827417E+06,       0.101518917024984054E+06,
        0.101468456845219422E+06,       0.101425013728590406E+06,       0.101390361593186084E+06,       0.101368216911030337E+06,       0.101370279495935785E+06,
        0.101384930299833504E+06,       0.101409208395769369E+06,       0.101438468993645060E+06,       0.101467787546390668E+06,       0.101499453696433935E+06,
        0.101530518538351142E+06,       0.101558938309742618E+06,       0.101581645149348537E+06,       0.101598207551499479E+06,       0.101607649285544889E+06,
        0.101609802844516307E+06,       0.101605573988511765E+06,       0.101593037714059843E+06,       0.101573514674016667E+06,       0.101549196000671189E+06,
        0.101522849664976588E+06,       0.101498330261054754E+06,       0.101479889987571310E+06,       0.101470097853539497E+06,       0.101471225349216998E+06,
        0.101486588535369752E+06,       0.101515334980482352E+06,       0.101556357596876667E+06,       0.101607560846124834E+06,       0.101666443968593783E+06,
        0.101729419441298363E+06,       0.101791387702929569E+06,       0.101848011454613385E+06,       0.101897514583017852E+06,       0.101939642427183790E+06,
        0.101960271009820077E+06,       0.101975158780464568E+06,       0.101986424653725320E+06,       0.101995822513432664E+06,       0.102004992120982162E+06,
        0.100578411052675729E+06,       0.100635318784110554E+06,       0.100702588041198120E+06,       0.100778983082032035E+06,       0.100867372014784603E+06,
        0.100961003291497836E+06,       0.101057944061462069E+06,       0.101156164506401896E+06,       0.101253562485936651E+06,       0.101348041518852056E+06,
        0.101435305736620867E+06,       0.101514565773677881E+06,       0.101585969098869886E+06,       0.101648080408071197E+06,       0.101699676885091831E+06,
        0.101737081890784044E+06,       0.101761287426791518E+06,       0.101772434840921720E+06,       0.101770158786062922E+06,       0.101748537453835859E+06,
        0.101714770053279746E+06,       0.101669742860261249E+06,       0.101614251954373656E+06,       0.101549290791504973E+06,       0.101476027861641691E+06,
        0.101395781087328636E+06,       0.101309332351133024E+06,       0.101208930191804626E+06,       0.101100827344175617E+06,       0.100987036454510526E+06,
        0.100870048278151575E+06,       0.100753131768219901E+06,       0.100640279785382925E+06,       0.100543839073244162E+06,       0.100470119984832578E+06,
        0.100412920571785522E+06,       0.100374418672954038E+06,       0.100356321711452154E+06,       0.100359754832890321E+06,       0.100393037545625295E+06,
        0.100461456665693026E+06,       0.100548040695085903E+06,       0.100649774320544951E+06,       0.100762231735881898E+06,       0.100879810004682629E+06,
        0.100978944107382951E+06,       0.101056139035317683E+06,       0.101129122973660080E+06,       0.101197131809436498E+06,       0.101259400864402109E+06,
        0.101315369721067444E+06,       0.101366567376128267E+06,       0.101413068730518760E+06,       0.101456050767495792E+06,       0.101497394979706776E+06,
        0.101540388547235518E+06,       0.101589723482442452E+06,       0.101639287384227951E+06,       0.101688119127630343E+06,       0.101734881227949692E+06,
        0.101774055633342999E+06,       0.101806176343790416E+06,       0.101833758016756707E+06,       0.101855867301477920E+06,       0.101869669516056863E+06,
        0.101867423844660036E+06,       0.101862185064065459E+06,       0.101857648911106618E+06,       0.101857166947219768E+06,       0.101869453362050233E+06,
        0.101889395994667357E+06,       0.101917145273055416E+06,       0.101952665990595080E+06,       0.102005113066678605E+06,       0.102059201352783610E+06,
        0.102110590092891594E+06,       0.102155134120450733E+06,       0.102189008661845161E+06,       0.102212893719536674E+06,       0.102224794573552019E+06,
        0.102221917283866860E+06,       0.102203717818992911E+06,       0.102173729797711843E+06,       0.102134066117315539E+06,       0.102088155198460590E+06,
        0.102037322504280150E+06,       0.101983804157969324E+06,       0.101930882216981918E+06,       0.101882568835916391E+06,       0.101835848097687121E+06,
        0.101791045975844638E+06,       0.101745969221785286E+06,       0.101701401299452598E+06,       0.101658034247290489E+06,       0.101613792586539625E+06,
        0.101566658381616784E+06,       0.101523107840297394E+06,       0.101485865057037794E+06,       0.101467196461575470E+06,       0.101465231282475186E+06,
        0.101481792269703801E+06,       0.101521171184929379E+06,       0.101584362409188645E+06,       0.101654606382538637E+06,       0.101708085889500013E+06,
        0.101750884319908815E+06,       0.101781151271932016E+06,       0.101802265119226417E+06,       0.101814660749166302E+06,       0.101818059160636913E+06,
        0.101815376584443497E+06,       0.101808025978518664E+06,       0.101796093709958877E+06,       0.101783205967926551E+06,       0.101773519465245452E+06,
        0.101768347262196490E+06,       0.101772318875173907E+06,       0.101774032894583841E+06,       0.101769304008539359E+06,       0.101752736287782580E+06,
        0.101724576811767562E+06,       0.101687606667018787E+06,       0.101642832213384885E+06,       0.101588413046507747E+06,       0.101532052789407389E+06,
        0.101477089478998780E+06,       0.101426937636667906E+06,       0.101383983337104524E+06,       0.101350070067916895E+06,       0.101327894217902314E+06,
        0.101330294767154453E+06,       0.101349863124191863E+06,       0.101379498558547202E+06,       0.101415335536042723E+06,       0.101450570253408456E+06,
        0.101486617503024216E+06,       0.101521790468661828E+06,       0.101553679702050722E+06,       0.101576951634593526E+06,       0.101592599322586801E+06,
        0.101600882539355007E+06,       0.101601982296252419E+06,       0.101593711037322297E+06,       0.101576295595724252E+06,       0.101552760225610255E+06,
        0.101525860012702775E+06,       0.101500304746004782E+06,       0.101482529221745732E+06,       0.101472615361795470E+06,       0.101472486373178777E+06,
        0.101483501295817390E+06,       0.101509279618775763E+06,       0.101549321581216165E+06,       0.101600205319342873E+06,       0.101659295372980385E+06,
        0.101721590076149907E+06,       0.101783337171577281E+06,       0.101842427132610639E+06,       0.101897333754838794E+06,       0.101946395082493676E+06,
        0.101988236942542819E+06,       0.102017526821220177E+06,       0.102031828714653369E+06,       0.102041305631011754E+06,       0.102047936605813040E+06,
        0.102053545022376406E+06,       0.100561618890645521E+06,       0.100618675407796312E+06,       0.100685232428278308E+06,       0.100760148812781379E+06,
        0.100842043992347171E+06,       0.100930626779751663E+06,       0.101025380770443604E+06,       0.101121496737499227E+06,       0.101216863489791329E+06,
        0.101306591907260168E+06,       0.101390820508431876E+06,       0.101469198549494278E+06,       0.101540194252744899E+06,       0.101602382440106187E+06,
        0.101654511301229999E+06,       0.101695567045773627E+06,       0.101724835997739530E+06,       0.101738206502799672E+06,       0.101728469792924647E+06,
        0.101706705766990082E+06,       0.101673943944349550E+06,       0.101630654689779229E+06,       0.101577521269946941E+06,       0.101515423259462186E+06,
        0.101445417400194085E+06,       0.101369301689578249E+06,       0.101289207179891833E+06,       0.101202291357723705E+06,       0.101109840862024794E+06,
        0.101010060536526478E+06,       0.100903624985256116E+06,       0.100797206247763170E+06,       0.100697721229483854E+06,       0.100617879166639119E+06,
        0.100549334862444375E+06,       0.100494554672908853E+06,       0.100455829928310864E+06,       0.100435159192249281E+06,       0.100434140902790139E+06,
        0.100463827743078145E+06,       0.100516682399563157E+06,       0.100588924784875649E+06,       0.100677081454071609E+06,       0.100775641942890885E+06,
        0.100875619518922729E+06,       0.100945870321605689E+06,       0.101013133541299816E+06,       0.101077503451870405E+06,       0.101138697419382283E+06,
        0.101196245970018281E+06,       0.101247478059058092E+06,       0.101295381961911495E+06,       0.101341293286219021E+06,       0.101385520658941925E+06,
        0.101428507369388099E+06,       0.101477628384924552E+06,       0.101527439265766385E+06,       0.101575625370267109E+06,       0.101621502298168052E+06,
        0.101663832962092813E+06,       0.101694866512688139E+06,       0.101720503961646493E+06,       0.101740691340596662E+06,       0.101755087321406769E+06,
        0.101753809082437700E+06,       0.101741526291839808E+06,       0.101728608499199152E+06,       0.101718502985755840E+06,       0.101716703972249219E+06,
        0.101727329002141589E+06,       0.101746865685733879E+06,       0.101776394054624689E+06,       0.101821041668101156E+06,       0.101883903619016666E+06,
        0.101950707313021689E+06,       0.102016579439056790E+06,       0.102074857884153607E+06,       0.102122966684235507E+06,       0.102162229375958646E+06,
        0.102191070936530305E+06,       0.102205291241337400E+06,       0.102205781057829736E+06,       0.102194562190391560E+06,       0.102173148282368042E+06,
        0.102144343637741913E+06,       0.102108830373893230E+06,       0.102068178268037620E+06,       0.102026306869767315E+06,       0.101984352807968040E+06,
        0.101941207962857719E+06,       0.101897306791024865E+06,       0.101851675563811092E+06,       0.101805566459294409E+06,       0.101759497966033654E+06,
        0.101711369603787127E+06,       0.101663340792011426E+06,       0.101619227450208040E+06,       0.101582695699032221E+06,       0.101558695579259147E+06,
        0.101546029798913645E+06,       0.101545588074274448E+06,       0.101567771713567665E+06,       0.101607748589558381E+06,       0.101688531278736336E+06,
        0.101712604992569381E+06,       0.101743096832469848E+06,       0.101760620836449103E+06,       0.101769961191482769E+06,       0.101772822414354494E+06,
        0.101770897529126829E+06,       0.101765958574697099E+06,       0.101759443212774597E+06,       0.101753267088761611E+06,       0.101750523367411457E+06,
        0.101749706624054088E+06,       0.101749678109808025E+06,       0.101749285406108000E+06,       0.101744523322546709E+06,       0.101733022628531995E+06,
        0.101711787295703034E+06,       0.101679008351294804E+06,       0.101639130834085285E+06,       0.101593625025334943E+06,       0.101541393928166348E+06,
        0.101487105460277933E+06,       0.101434417444056598E+06,       0.101385551046964029E+06,       0.101342006161188154E+06,       0.101307140291916905E+06,
        0.101283659047930778E+06,       0.101280818499683781E+06,       0.101302531797972479E+06,       0.101335121595155433E+06,       0.101374651651055479E+06,
        0.101415853089015101E+06,       0.101456337388213346E+06,       0.101495434796083166E+06,       0.101530692665964845E+06,       0.101556780887815577E+06,
        0.101572252524485899E+06,       0.101580348283763422E+06,       0.101581288046389862E+06,       0.101573497525049606E+06,       0.101553231842264839E+06,
        0.101527699101148173E+06,       0.101500366015751919E+06,       0.101475147159402040E+06,       0.101462872833845016E+06,       0.101461553787802579E+06,
        0.101470899121458526E+06,       0.101491574771335596E+06,       0.101526109462851629E+06,       0.101575993595638676E+06,       0.101633539000189689E+06,
        0.101696017474012726E+06,       0.101760468358366721E+06,       0.101823741442191822E+06,       0.101882328042741588E+06,       0.101936367528451112E+06,
        0.101984427337493747E+06,       0.102025414498975340E+06,       0.102058638462272647E+06,       0.102075739484648249E+06,       0.102084208298001584E+06,
        0.102090352048999324E+06,       0.102097473483009948E+06,       0.100548208007167515E+06,       0.100605095427047316E+06,       0.100670706010579946E+06,
        0.100743978438203791E+06,       0.100823629545142438E+06,       0.100908178696427160E+06,       0.100995982580288008E+06,       0.101087314481146692E+06,
        0.101176414116338347E+06,       0.101262458356531424E+06,       0.101344547676157905E+06,       0.101421163164599711E+06,       0.101490796631980134E+06,
        0.101552014265238700E+06,       0.101603518886931997E+06,       0.101644210460807284E+06,       0.101673244462872826E+06,       0.101680735386759538E+06,
        0.101674706326058280E+06,       0.101655388783202914E+06,       0.101624670690422980E+06,       0.101584138623298597E+06,       0.101534372942937815E+06,
        0.101476149074961329E+06,       0.101410568098193849E+06,       0.101343974609530458E+06,       0.101270896963409337E+06,       0.101192137510717424E+06,
        0.101108880683603289E+06,       0.101022724309234283E+06,       0.100935715390839119E+06,       0.100850390680374665E+06,       0.100774745624155403E+06,
        0.100703597598235123E+06,       0.100641200968575649E+06,       0.100589854186508950E+06,       0.100551830710988637E+06,       0.100529267606730675E+06,
        0.100528295556730111E+06,       0.100549682448172025E+06,       0.100589658714417616E+06,       0.100646339245096955E+06,       0.100716647083594595E+06,
        0.100796330849082777E+06,       0.100862509969368170E+06,       0.100921980592583743E+06,       0.100978572070364797E+06,       0.101033342690100937E+06,
        0.101086524659137300E+06,       0.101137201268390738E+06,       0.101183872284207260E+06,       0.101229010938212319E+06,       0.101273109489612165E+06,
        0.101316619892713090E+06,       0.101361395459038307E+06,       0.101412097251747749E+06,       0.101462443230712757E+06,       0.101510984330326377E+06,
        0.101556016862365155E+06,       0.101593723038725308E+06,       0.101622224707454676E+06,       0.101642725690420295E+06,       0.101656123946685548E+06,
        0.101662476115757090E+06,       0.101646779923387396E+06,       0.101626132803217159E+06,       0.101605491482854268E+06,       0.101589147781629013E+06,
        0.101585251139149026E+06,       0.101593208937773641E+06,       0.101612184718608827E+06,       0.101643206312575028E+06,       0.101695818816071987E+06,
        0.101764928221785813E+06,       0.101840193899589591E+06,       0.101916494038259974E+06,       0.101982907500618603E+06,       0.102040970845980133E+06,
        0.102091837845918839E+06,       0.102134078254784647E+06,       0.102164394058369740E+06,       0.102183887971255608E+06,       0.102192909965391460E+06,
        0.102191628213096585E+06,       0.102180725302393228E+06,       0.102161729213580154E+06,       0.102136138522838941E+06,       0.102107142982990175E+06,
        0.102074807010027405E+06,       0.102039103318180598E+06,       0.102000767273371166E+06,       0.101960362993373739E+06,       0.101918302600709168E+06,
        0.101875356744285367E+06,       0.101830760544282428E+06,       0.101787058843222650E+06,       0.101746854946198102E+06,       0.101712081627763269E+06,
        0.101684170852595838E+06,       0.101663959106856215E+06,       0.101652494286064044E+06,       0.101669560085676902E+06,       0.101704444840698343E+06,
        0.101700571875176043E+06,       0.101721535240709272E+06,       0.101745779185469408E+06,       0.101743873285487498E+06,       0.101738112527286779E+06,
        0.101730354652939321E+06,       0.101722249363334777E+06,       0.101714810079808434E+06,       0.101708639567806546E+06,       0.101706113756708350E+06,
        0.101714036658689380E+06,       0.101722369687996295E+06,       0.101728359378835914E+06,       0.101725407412529981E+06,       0.101714092896974922E+06,
        0.101695958827062772E+06,       0.101670373525743838E+06,       0.101635678816692453E+06,       0.101595418488830386E+06,       0.101550830010831283E+06,
        0.101501001127021242E+06,       0.101448446456819016E+06,       0.101396954698346424E+06,       0.101348845039631386E+06,       0.101304062386825870E+06,
        0.101267451987425215E+06,       0.101242193004994537E+06,       0.101233636404356381E+06,       0.101254846780972948E+06,       0.101287816325990920E+06,
        0.101328479900242310E+06,       0.101372263340125617E+06,       0.101414617472293321E+06,       0.101455579958959497E+06,       0.101492853465017077E+06,
        0.101523278594798670E+06,       0.101540885808085994E+06,       0.101551450070809791E+06,       0.101555278183125236E+06,       0.101552538038431827E+06,
        0.101533468414678850E+06,       0.101508500675057512E+06,       0.101482796927905787E+06,       0.101462379842144772E+06,       0.101454892688142470E+06,
        0.101464325466535738E+06,       0.101484135316789325E+06,       0.101513829601535981E+06,       0.101552601163330517E+06,       0.101603687744035284E+06,
        0.101663791684624332E+06,       0.101727767774695865E+06,       0.101792762408730807E+06,       0.101856171640086162E+06,       0.101914393070144404E+06,
        0.101966522189743861E+06,       0.102012469486766611E+06,       0.102051444457628037E+06,       0.102084940153698932E+06,       0.102109046172999864E+06,
        0.102120432478447823E+06,       0.102128404810622902E+06,       0.102134103220031029E+06,       0.100537775584916468E+06,       0.100594064464056602E+06,
        0.100658361556240663E+06,       0.100729672253821584E+06,       0.100806792979668055E+06,       0.100888331818478662E+06,       0.100972640703881028E+06,
        0.101054356923499276E+06,       0.101136218305642746E+06,       0.101218059282136164E+06,       0.101297128938538604E+06,       0.101371075949467442E+06,
        0.101438396724319813E+06,       0.101497631946100053E+06,       0.101547424352719638E+06,       0.101586575081165560E+06,       0.101605344305898223E+06,
        0.101611802560867160E+06,       0.101607062825132700E+06,       0.101591492022024759E+06,       0.101565740711957988E+06,       0.101530433274754861E+06,
        0.101485334233030881E+06,       0.101432291750987933E+06,       0.101377329376169117E+06,       0.101317207789115375E+06,       0.101251671625233779E+06,
        0.101181417558871472E+06,       0.101107498655681804E+06,       0.101031350521440603E+06,       0.100954821051961742E+06,       0.100889588668171375E+06,
        0.100831564213864112E+06,       0.100778330447916189E+06,       0.100731315465427993E+06,       0.100686629349019524E+06,       0.100649847468544394E+06,
        0.100626941602005361E+06,       0.100623247975728824E+06,       0.100634858419738637E+06,       0.100661484011766472E+06,       0.100701891329741135E+06,
        0.100753800334865009E+06,       0.100807541818709986E+06,       0.100848659308669099E+06,       0.100892548219874385E+06,       0.100938268977634565E+06,
        0.100984815257879964E+06,       0.101031244555508310E+06,       0.101077229148432787E+06,       0.101120811543651638E+06,       0.101163080762204729E+06,
        0.101205133328227632E+06,       0.101247555470727515E+06,       0.101295212705033598E+06,       0.101345677435592734E+06,       0.101395414916676789E+06,
        0.101443142113523310E+06,       0.101487391928729412E+06,       0.101523112860496927E+06,       0.101551091220213115E+06,       0.101571202362138647E+06,
        0.101582765233024111E+06,       0.101580576420733298E+06,       0.101559006090641735E+06,       0.101532638260340871E+06,       0.101505636854472148E+06,
        0.101482925905383032E+06,       0.101478221569192814E+06,       0.101483749961331385E+06,       0.101500913638159356E+06,       0.101531272427147036E+06,
        0.101587537367870260E+06,       0.101657752923680528E+06,       0.101735341257440305E+06,       0.101815392189158199E+06,       0.101883415778570139E+06,
        0.101946670918334348E+06,       0.102005217869353437E+06,       0.102057696492837160E+06,       0.102103056512906318E+06,       0.102140317424393026E+06,
        0.102168554530401248E+06,       0.102186118819968382E+06,       0.102192209463688341E+06,       0.102189750578587409E+06,       0.102179864477714669E+06,
        0.102164622014063440E+06,       0.102144222519251431E+06,       0.102119031801210527E+06,       0.102090001778615697E+06,       0.102058500322085427E+06,
        0.102024456224525828E+06,       0.101988984142914618E+06,       0.101952414757101811E+06,       0.101915891308398845E+06,       0.101881589770049075E+06,
        0.101851270386932039E+06,       0.101822396029631869E+06,       0.101797879312661476E+06,       0.101778855518825338E+06,       0.101766764384149530E+06,
        0.101767117846749301E+06,       0.101765125533417420E+06,       0.101764893632733350E+06,       0.101755791518637372E+06,       0.101738415072208983E+06,
        0.101717693412627370E+06,       0.101697849566573597E+06,       0.101679653680022544E+06,       0.101666036116405725E+06,       0.101657802915804903E+06,
        0.101659358381537619E+06,       0.101675042132274451E+06,       0.101690591932105221E+06,       0.101702102691112683E+06,       0.101698890266004499E+06,
        0.101685170063431069E+06,       0.101664399827034271E+06,       0.101636981850683907E+06,       0.101602430202209493E+06,       0.101562887328751778E+06,
        0.101519409569218289E+06,       0.101470958313536248E+06,       0.101419317694792786E+06,       0.101368660117972962E+06,       0.101321145110236859E+06,
        0.101276071087296979E+06,       0.101238240695380387E+06,       0.101211277007847661E+06,       0.101197902530338179E+06,       0.101215581555680212E+06,
        0.101246094621904544E+06,       0.101284825497456564E+06,       0.101328072813235674E+06,       0.101370225701783012E+06,       0.101411514155655474E+06,
        0.101449747457354388E+06,       0.101482930506732373E+06,       0.101505336383574511E+06,       0.101520932260299305E+06,       0.101530875621757339E+06,
        0.101535660531138637E+06,       0.101527586118792417E+06,       0.101509422337400800E+06,       0.101491464951296075E+06,       0.101477501245060659E+06,
        0.101471117495995146E+06,       0.101486007619632292E+06,       0.101510757134502812E+06,       0.101544449952577212E+06,       0.101586055913800505E+06,
        0.101635695535260849E+06,       0.101695729268481853E+06,       0.101758721424995805E+06,       0.101822050355179599E+06,       0.101883639102236455E+06,
        0.101943513401448537E+06,       0.101994845858460889E+06,       0.102039591261445501E+06,       0.102076829661285185E+06,       0.102105964877399136E+06,
        0.102126794141653125E+06,       0.102139212624906431E+06,       0.102146437567661822E+06,       0.102150500772487969E+06,       0.100529766660700814E+06,
        0.100584936771645967E+06,       0.100647449978120101E+06,       0.100716367627817162E+06,       0.100790551176116554E+06,       0.100867761991881081E+06,
        0.100944392016551021E+06,       0.101022283363768598E+06,       0.101100094859150340E+06,       0.101176390860314190E+06,       0.101249683961219664E+06,
        0.101319429056106397E+06,       0.101383533080313195E+06,       0.101439851116198683E+06,       0.101486953091034593E+06,       0.101514035380600777E+06,
        0.101530274350960754E+06,       0.101536503930903316E+06,       0.101532791192708028E+06,       0.101519414459226711E+06,       0.101496896545514726E+06,
        0.101466032997577611E+06,       0.101427914819550628E+06,       0.101386928031759133E+06,       0.101339510051842895E+06,       0.101286534144961479E+06,
        0.101229073267725224E+06,       0.101167697805292846E+06,       0.101103306882333491E+06,       0.101037149535454111E+06,       0.100976699320003900E+06,
        0.100924651148493227E+06,       0.100875357695395811E+06,       0.100829790933326149E+06,       0.100789063316662927E+06,       0.100754382631035871E+06,
        0.100727001544673127E+06,       0.100712812235705482E+06,       0.100707393276471601E+06,       0.100709250582931563E+06,       0.100722573388958059E+06,
        0.100746645734061545E+06,       0.100779895700786001E+06,       0.100804396943602027E+06,       0.100830073367685545E+06,       0.100859556300720957E+06,
        0.100892387870409642E+06,       0.100927975633083144E+06,       0.100965551602012056E+06,       0.101004683619487085E+06,       0.101045330597207460E+06,
        0.101087013008305672E+06,       0.101129446011777312E+06,       0.101173089623770706E+06,       0.101224746709176397E+06,       0.101276086346010212E+06,
        0.101326149198708168E+06,       0.101374129662616979E+06,       0.101418481717269460E+06,       0.101456308681409500E+06,       0.101487100471046055E+06,
        0.101509891159304345E+06,       0.101523887972284254E+06,       0.101519085107067789E+06,       0.101499035636973305E+06,       0.101474107212159681E+06,
        0.101448532598947975E+06,       0.101428087461135481E+06,       0.101420183587270294E+06,       0.101421890388346379E+06,       0.101434924963140438E+06,
        0.101461175739645623E+06,       0.101512942173575240E+06,       0.101576674737662266E+06,       0.101648311032956131E+06,       0.101723489882150840E+06,
        0.101787480132178534E+06,       0.101850028038504926E+06,       0.101910282046108841E+06,       0.101967661149882086E+06,       0.102023524732844948E+06,
        0.102074242265323439E+06,       0.102118210977073832E+06,       0.102152171123111169E+06,       0.102173114540454029E+06,       0.102185669537254769E+06,
        0.102190716001940251E+06,       0.102189608656019511E+06,       0.102183136999173483E+06,       0.102171644521202223E+06,       0.102155743904811548E+06,
        0.102135288964191917E+06,       0.102110694874428111E+06,       0.102083194402445937E+06,       0.102053140888443799E+06,       0.102023029614340878E+06,
        0.101994305634375618E+06,       0.101968130490490352E+06,       0.101944981816832049E+06,       0.101917533305451230E+06,       0.101891792228334729E+06,
        0.101867962161627947E+06,       0.101846942835226117E+06,       0.101828399128989535E+06,       0.101808349218342468E+06,       0.101783185169399527E+06,
        0.101752129728330387E+06,       0.101717730687555537E+06,       0.101682415904166002E+06,       0.101651064189548269E+06,       0.101628214835530569E+06,
        0.101615101470726600E+06,       0.101622078677434256E+06,       0.101640462768905272E+06,       0.101659951220889372E+06,       0.101675418801938606E+06,
        0.101673225878615136E+06,       0.101661928138148622E+06,       0.101642662123728296E+06,       0.101615888022248750E+06,       0.101582080924031965E+06,
        0.101543348953446970E+06,       0.101500631267208417E+06,       0.101452586432289259E+06,       0.101401256146737229E+06,       0.101350655526253569E+06,
        0.101302884790491065E+06,       0.101258041134635379E+06,       0.101219975854280870E+06,       0.101192075948155878E+06,       0.101176911767419486E+06,
        0.101189137340948175E+06,       0.101215695508690798E+06,       0.101250828629981872E+06,       0.101291224981271953E+06,       0.101331080207125036E+06,
        0.101370380504028988E+06,       0.101408081153893057E+06,       0.101442820210735677E+06,       0.101470980944890180E+06,       0.101493569638212546E+06,
        0.101512139169726375E+06,       0.101526611096755121E+06,       0.101532495997983948E+06,       0.101522627542459595E+06,       0.101512420265735462E+06,
        0.101505304745591246E+06,       0.101504334695817597E+06,       0.101519650872094615E+06,       0.101547899391185740E+06,       0.101583965970937570E+06,
        0.101627433236286277E+06,       0.101678082609776582E+06,       0.101737298190423375E+06,       0.101799968663717998E+06,       0.101862212637869627E+06,
        0.101921525254885390E+06,       0.101975615485969174E+06,       0.102022129365600340E+06,       0.102060753757629835E+06,       0.102091435012152549E+06,
        0.102114037703653419E+06,       0.102128864386004381E+06,       0.102136712377933785E+06,       0.102141341896670521E+06,       0.102142376150148193E+06,
        0.100523535976660394E+06,       0.100577052820581303E+06,       0.100637236479140498E+06,       0.100703252727134633E+06,       0.100772552025250538E+06,
        0.100843355148487011E+06,       0.100916200005643404E+06,       0.100989978980367348E+06,       0.101063458978865412E+06,       0.101135313180651341E+06,
        0.101204158192835064E+06,       0.101268596961150513E+06,       0.101327267803054579E+06,       0.101379219393509498E+06,       0.101411658551840825E+06,
        0.101435013304419204E+06,       0.101449723991433348E+06,       0.101455671589434161E+06,       0.101452876078218949E+06,       0.101441532989260799E+06,
        0.101422046210621003E+06,       0.101395056661309005E+06,       0.101365757780455795E+06,       0.101332677387078918E+06,       0.101293673363073496E+06,
        0.101249457127459696E+06,       0.101201011753970408E+06,       0.101149108558075517E+06,       0.101094587629913221E+06,       0.101040779590145175E+06,
        0.100995382496306906E+06,       0.100951579695860622E+06,       0.100909850434587090E+06,       0.100870858422985533E+06,       0.100835419863702089E+06,
        0.100804467614276640E+06,       0.100781685669042199E+06,       0.100767335396187831E+06,       0.100759289879836622E+06,       0.100757866722066232E+06,
        0.100763078005519506E+06,       0.100774506516805646E+06,       0.100786062954307781E+06,       0.100793269206959361E+06,       0.100804822422906916E+06,
        0.100820834091496698E+06,       0.100841255618750598E+06,       0.100865889078778535E+06,       0.100894749198775666E+06,       0.100927416956011424E+06,
        0.100963395796724551E+06,       0.101002315623510774E+06,       0.101043887250100248E+06,       0.101091039191901757E+06,       0.101144066547046401E+06,
        0.101197932497966991E+06,       0.101251195535936524E+06,       0.101302429885710808E+06,       0.101350642114984890E+06,       0.101394018940216731E+06,
        0.101430608604817069E+06,       0.101459057570376521E+06,       0.101478044590623220E+06,       0.101475387865733283E+06,       0.101461856537208994E+06,
        0.101443018892087159E+06,       0.101422586718123261E+06,       0.101406882059484167E+06,       0.101400350668646613E+06,       0.101401136819027641E+06,
        0.101411047287252732E+06,       0.101432998273655045E+06,       0.101475019664207721E+06,       0.101526976345226532E+06,       0.101585936905203198E+06,
        0.101648470322235924E+06,       0.101703644183282871E+06,       0.101759331828263079E+06,       0.101814866055730265E+06,       0.101869901220545507E+06,
        0.101928914084517004E+06,       0.101985712555209233E+06,       0.102038213057230983E+06,       0.102083503006818413E+06,       0.102116318481194263E+06,
        0.102142478770143352E+06,       0.102162510227578357E+06,       0.102176745632176331E+06,       0.102185382260760132E+06,       0.102189351865029588E+06,
        0.102188985060908250E+06,       0.102181978502190381E+06,       0.102166343098074416E+06,       0.102144949217122790E+06,       0.102118539343817305E+06,
        0.102090320241642432E+06,       0.102064949154931208E+06,       0.102041510471142406E+06,       0.102020894051233234E+06,       0.102002076919490239E+06,
        0.101978687982916701E+06,       0.101949947159686926E+06,       0.101920721729201105E+06,       0.101890840787188339E+06,       0.101858502442174227E+06,
        0.101821787050020226E+06,       0.101779170614060145E+06,       0.101731633607835785E+06,       0.101683872606227975E+06,       0.101641706250363815E+06,
        0.101609757163432500E+06,       0.101594408710602715E+06,       0.101599861763739507E+06,       0.101615600568650814E+06,       0.101634792862023707E+06,
        0.101649560822422354E+06,       0.101653324074520948E+06,       0.101647718645786255E+06,       0.101632892509714380E+06,       0.101607498410070068E+06,
        0.101573604987650251E+06,       0.101534332171428061E+06,       0.101490882315485491E+06,       0.101441914985506301E+06,       0.101390598505943577E+06,
        0.101340225499994325E+06,       0.101292893172337470E+06,       0.101249121490931240E+06,       0.101212206615971038E+06,       0.101184803983927792E+06,
        0.101169090523178049E+06,       0.101177216406820677E+06,       0.101199121436619549E+06,       0.101229487274117826E+06,       0.101265433425285810E+06,
        0.101301460838134211E+06,       0.101337546551032807E+06,       0.101373572179327981E+06,       0.101408481747705810E+06,       0.101441269413672373E+06,
        0.101471589979924611E+06,       0.101499094210238720E+06,       0.101523046431578827E+06,       0.101542483002773370E+06,       0.101543831013172356E+06,
        0.101544064378257113E+06,       0.101546276856648081E+06,       0.101553107004487800E+06,       0.101570758226424994E+06,       0.101603899362922981E+06,
        0.101643466171828870E+06,       0.101688020902613556E+06,       0.101736066489577410E+06,       0.101788778651382352E+06,       0.101846229772819366E+06,
        0.101902087545993330E+06,       0.101954243560902876E+06,       0.102000912067655503E+06,       0.102040460468150268E+06,       0.102070397922830496E+06,
        0.102092123176266672E+06,       0.102106027606901625E+06,       0.102112955537274407E+06,       0.102114233430400913E+06,       0.102110160726652859E+06,
        0.102103564706523437E+06,       0.100518689604693471E+06,       0.100570188968489383E+06,       0.100627085580226092E+06,       0.100688425846865008E+06,
        0.100752801664219747E+06,       0.100819711434372482E+06,       0.100888275239485200E+06,       0.100957467842034559E+06,       0.101026141537060103E+06,
        0.101093053338000958E+06,       0.101156896762082222E+06,       0.101216338486683555E+06,       0.101270050228910055E+06,       0.101303959592322863E+06,
        0.101331155104026548E+06,       0.101351367252466414E+06,       0.101364631606699608E+06,       0.101370354947362532E+06,       0.101368511938952593E+06,
        0.101359219879845390E+06,       0.101342770712901329E+06,       0.101323279228074665E+06,       0.101301442257920979E+06,       0.101274216777385765E+06,
        0.101241963101549714E+06,       0.101205245491941663E+06,       0.101164856326946916E+06,       0.101121839477416492E+06,       0.101077512757932636E+06,
        0.101040769978266762E+06,       0.101003816768457153E+06,       0.100967482943484662E+06,       0.100932599047362921E+06,       0.100899538621347674E+06,
        0.100868835073115974E+06,       0.100841822788138859E+06,       0.100822146543393857E+06,       0.100806275342578825E+06,       0.100794425676255967E+06,
        0.100786746583171247E+06,       0.100783223558698664E+06,       0.100783580356914550E+06,       0.100777240593710594E+06,       0.100772797244677698E+06,
        0.100771995893256535E+06,       0.100775628518037935E+06,       0.100784330892865575E+06,       0.100798832415402489E+06,       0.100819830174998613E+06,
        0.100845869940026445E+06,       0.100876821716840641E+06,       0.100912505059014773E+06,       0.100952732377084161E+06,       0.101002888396750073E+06,
        0.101057716858402928E+06,       0.101114463416698447E+06,       0.101171669964558023E+06,       0.101227895955215106E+06,       0.101283382095900626E+06,
        0.101334958226825765E+06,       0.101380444142405948E+06,       0.101418245220739525E+06,       0.101446407440058887E+06,       0.101450870781566424E+06,
        0.101446840525337553E+06,       0.101437171069169228E+06,       0.101424931486162226E+06,       0.101415799787063268E+06,       0.101412071436230064E+06,
        0.101412950725123417E+06,       0.101420014842418866E+06,       0.101435968083775937E+06,       0.101466352271600088E+06,       0.101503661068658505E+06,
        0.101546063702057072E+06,       0.101591631627750539E+06,       0.101633780932880036E+06,       0.101677233535571504E+06,       0.101722001382731454E+06,
        0.101768084603012278E+06,       0.101821697636718192E+06,       0.101876504987276159E+06,       0.101929725277785576E+06,       0.101979436992402916E+06,
        0.102021048948978249E+06,       0.102058738337406423E+06,       0.102093407361196325E+06,       0.102125483850517805E+06,       0.102150396359340550E+06,
        0.102169939569479524E+06,       0.102183985952502859E+06,       0.102191376525420768E+06,       0.102185685603385369E+06,       0.102169450367412603E+06,
        0.102146358644484295E+06,       0.102119842646822071E+06,       0.102094075555721618E+06,       0.102073636097204362E+06,       0.102056299206566269E+06,
        0.102039605800132485E+06,       0.102021374390271580E+06,       0.101998770599080817E+06,       0.101970853166201807E+06,       0.101937971227922506E+06,
        0.101900413338984057E+06,       0.101857321774920129E+06,       0.101808436773914334E+06,       0.101755010517902134E+06,       0.101701108954033160E+06,
        0.101652170013780356E+06,       0.101614009141804403E+06,       0.101594396568573589E+06,       0.101591391668390439E+06,       0.101601222158549106E+06,
        0.101618244864968845E+06,       0.101635666146591233E+06,       0.101645911116270872E+06,       0.101646699642323045E+06,       0.101636431221179548E+06,
        0.101609654908569675E+06,       0.101575048385323738E+06,       0.101534330175456344E+06,       0.101489532139668852E+06,       0.101438185377782967E+06,
        0.101385959560380783E+06,       0.101335194667244825E+06,       0.101287926354806812E+06,       0.101245203663320397E+06,       0.101209646717536321E+06,
        0.101183113534233489E+06,       0.101167399256673903E+06,       0.101173255047212093E+06,       0.101191266867459737E+06,       0.101217555082850216E+06,
        0.101249738922742486E+06,       0.101282540292244405E+06,       0.101316175523455371E+06,       0.101351248733287808E+06,       0.101387035478988051E+06,
        0.101423676548066695E+06,       0.101461316613871037E+06,       0.101497507316982592E+06,       0.101531170814716766E+06,       0.101561263551730270E+06,
        0.101576206116756410E+06,       0.101586714996634080E+06,       0.101597778963160541E+06,       0.101611464789349586E+06,       0.101630169532632644E+06,
        0.101664927306783313E+06,       0.101704113353483583E+06,       0.101746416585083251E+06,       0.101790584390523509E+06,       0.101835630759291264E+06,
        0.101885286326592308E+06,       0.101932452931491775E+06,       0.101975582690834839E+06,       0.102013491689891205E+06,       0.102045391567770363E+06,
        0.102064776694095723E+06,       0.102074647376751818E+06,       0.102077355461506435E+06,       0.102073009372423272E+06,       0.102062037114194260E+06,
        0.102045197475351029E+06,       0.102032862053345467E+06,       0.100516203599419721E+06,       0.100565218916304395E+06,       0.100617260891664730E+06,
        0.100673956912948721E+06,       0.100734470974993252E+06,       0.100796865106346027E+06,       0.100860518975916333E+06,       0.100924514220946570E+06,
        0.100987769915576093E+06,       0.101049106773664753E+06,       0.101107273840837661E+06,       0.101159905161335395E+06,       0.101194545284544540E+06,
        0.101223680392232840E+06,       0.101247089234949191E+06,       0.101264590537126525E+06,       0.101276076890375974E+06,       0.101281552099694847E+06,
        0.101280982310362175E+06,       0.101273943686812767E+06,       0.101262940282394411E+06,       0.101250027136122240E+06,       0.101232503141791327E+06,
        0.101210483653828545E+06,       0.101184228737493526E+06,       0.101154165002910086E+06,       0.101120906752935975E+06,       0.101085276329601198E+06,
        0.101055059197187191E+06,       0.101026747435691374E+06,       0.100998039675420368E+06,       0.100969366867174089E+06,       0.100941239345533730E+06,
        0.100914229378812437E+06,       0.100888324815689179E+06,       0.100866108957016506E+06,       0.100846788167441075E+06,       0.100829635550168416E+06,
        0.100814589974162533E+06,       0.100801624509251793E+06,       0.100790670060632678E+06,       0.100777235449754880E+06,       0.100759761272309115E+06,
        0.100744498201414157E+06,       0.100732510380326974E+06,       0.100724806452672536E+06,       0.100722312648745443E+06,       0.100727124797232929E+06,
        0.100739250727341408E+06,       0.100757924088756554E+06,       0.100783210335334952E+06,       0.100815143464493012E+06,       0.100854893070929611E+06,
        0.100907659832364327E+06,       0.100964923673006793E+06,       0.101024919613124526E+06,       0.101086575092280807E+06,       0.101148693938726588E+06,
        0.101212491181683130E+06,       0.101273236178490639E+06,       0.101328963344270000E+06,       0.101377761563192791E+06,       0.101415272026218052E+06,
        0.101431876200949133E+06,       0.101440210101162083E+06,       0.101442472419936472E+06,       0.101441025799434588E+06,       0.101440273436921474E+06,
        0.101441412028859413E+06,       0.101444242700126299E+06,       0.101450026358596937E+06,       0.101460476599565445E+06,       0.101479171248484825E+06,
        0.101501585380914767E+06,       0.101526832551874162E+06,       0.101554045751632453E+06,       0.101581088175181358E+06,       0.101609436210866566E+06,
        0.101639553558900094E+06,       0.101671699640266219E+06,       0.101712219603055011E+06,       0.101758423241378463E+06,       0.101805738585399682E+06,
        0.101852962314692355E+06,       0.101899310754771403E+06,       0.101946265190960024E+06,       0.101994211955312698E+06,       0.102041986736160048E+06,
        0.102085797585756969E+06,       0.102118247218596109E+06,       0.102143944256965377E+06,       0.102160780837746963E+06,       0.102166943569605079E+06,
        0.102158326056491831E+06,       0.102140886616651740E+06,       0.102119658913957755E+06,       0.102098499930418155E+06,       0.102080904999102844E+06,
        0.102066516422517074E+06,       0.102054504472527260E+06,       0.102039748545332608E+06,       0.102020600907278713E+06,       0.101995196360471018E+06,
        0.101963875490564329E+06,       0.101926792596088359E+06,       0.101883686482137069E+06,       0.101834681537134267E+06,       0.101781342698296125E+06,
        0.101725325815194636E+06,       0.101672635846780700E+06,       0.101631506833831096E+06,       0.101606236395939879E+06,       0.101597475949642787E+06,
        0.101603731801431582E+06,       0.101625616805930535E+06,       0.101646355193644980E+06,       0.101660903200991379E+06,       0.101665697733909154E+06,
        0.101654090491919997E+06,       0.101628201204639379E+06,       0.101592718579965003E+06,       0.101550440364196067E+06,       0.101501865690094695E+06,
        0.101447993110863157E+06,       0.101394085224710812E+06,       0.101342099839650211E+06,       0.101293810362817196E+06,       0.101250946740538144E+06,
        0.101215426073013630E+06,       0.101188872150540003E+06,       0.101172928312290038E+06,       0.101177855232292422E+06,       0.101192799356549629E+06,
        0.101215813274799773E+06,       0.101244944643138500E+06,       0.101275131726042877E+06,       0.101307174081444085E+06,       0.101341749283816956E+06,
        0.101378289914467692E+06,       0.101417332589792815E+06,       0.101459925058367837E+06,       0.101502062670976826E+06,       0.101542401965262659E+06,
        0.101579707707947498E+06,       0.101605443608385016E+06,       0.101624638835457939E+06,       0.101643143897028465E+06,       0.101662631727210814E+06,
        0.101684583160134658E+06,       0.101717073342919160E+06,       0.101753756733753267E+06,       0.101791888041425977E+06,       0.101829704004501327E+06,
        0.101866836453342432E+06,       0.101904943611418348E+06,       0.101941838182645661E+06,       0.101974805182480457E+06,       0.102002312012851093E+06,
        0.102022951004307251E+06,       0.102034588422611414E+06,       0.102035115083442288E+06,       0.102027670824049870E+06,       0.102012988929236992E+06,
        0.101992061827493861E+06,       0.101966142466949459E+06,       0.101941390128694227E+06,       0.100514970796833106E+06,       0.100558835077606142E+06,
        0.100607260398477549E+06,       0.100659655071357542E+06,       0.100715265417817398E+06,       0.100773178786940116E+06,       0.100832331209467477E+06,
        0.100890717506978282E+06,       0.100947860531606886E+06,       0.101002917974898708E+06,       0.101052195859970219E+06,       0.101086008388641625E+06,
        0.101115273930014009E+06,       0.101139857117029198E+06,       0.101159622269959131E+06,       0.101174458955507551E+06,       0.101184310219007501E+06,
        0.101189203551941042E+06,       0.101189284643897758E+06,       0.101186114007991724E+06,       0.101181270068826241E+06,       0.101171908271853448E+06,
        0.101158297091944536E+06,       0.101141013465808763E+06,       0.101120226925708761E+06,       0.101096239397641839E+06,       0.101069503529764173E+06,
        0.101044711943530012E+06,       0.101023498931715556E+06,       0.101001656961748697E+06,       0.100979308414565210E+06,       0.100956646567351941E+06,
        0.100933930245713549E+06,       0.100911474196776457E+06,       0.100891471408871366E+06,       0.100874184642035718E+06,       0.100856582877880370E+06,
        0.100838800023023141E+06,       0.100821055717833835E+06,       0.100804211342234223E+06,       0.100787393558680691E+06,       0.100761008720101294E+06,
        0.100734732500141792E+06,       0.100710174312875781E+06,       0.100688451173672947E+06,       0.100670708926784253E+06,       0.100658093134885828E+06,
        0.100653547542059678E+06,       0.100656000772829168E+06,       0.100665921580032358E+06,       0.100683713857153736E+06,       0.100709718860814537E+06,
        0.100748801228508208E+06,       0.100801823503565058E+06,       0.100861225414351109E+06,       0.100925234962917515E+06,       0.100992162379509042E+06,
        0.101061180367843728E+06,       0.101132825200904612E+06,       0.101202551905614309E+06,       0.101268249128093084E+06,       0.101327796560415067E+06,
        0.101375435871056281E+06,       0.101404641442907785E+06,       0.101425758115715638E+06,       0.101440394650381306E+06,       0.101450217422559756E+06,
        0.101458727822546076E+06,       0.101466619611513932E+06,       0.101473463661342525E+06,       0.101480183000528341E+06,       0.101487645084924108E+06,
        0.101498004691627488E+06,       0.101508871394480026E+06,       0.101520205876727661E+06,       0.101532083912951843E+06,       0.101544647478942308E+06,
        0.101558096380653675E+06,       0.101573050568899664E+06,       0.101590428478391070E+06,       0.101613972514299414E+06,       0.101648920007989669E+06,
        0.101687381188284504E+06,       0.101728410452743919E+06,       0.101771447499673959E+06,       0.101823102602039115E+06,       0.101880173737650490E+06,
        0.101939952057504197E+06,       0.101998671132745076E+06,       0.102047778748635392E+06,       0.102081283700837084E+06,       0.102104626314851310E+06,
        0.102117132803555040E+06,       0.102118423258010647E+06,       0.102110210033883151E+06,       0.102097574911021075E+06,       0.102084451243621195E+06,
        0.102073635202554215E+06,       0.102064362043080371E+06,       0.102055076068754133E+06,       0.102042482878204013E+06,       0.102025288372749041E+06,
        0.102001685111197468E+06,       0.101971967159961292E+06,       0.101935955157193923E+06,       0.101893991729276575E+06,       0.101846831752592378E+06,
        0.101795519670136433E+06,       0.101743547706146055E+06,       0.101695867126943878E+06,       0.101657509946900449E+06,       0.101633507015335563E+06,
        0.101630312812292759E+06,       0.101646392192630388E+06,       0.101668889131485266E+06,       0.101690704618882228E+06,       0.101706951776862203E+06,
        0.101710803657395867E+06,       0.101698215938497582E+06,       0.101672792047461742E+06,       0.101636565396570542E+06,       0.101592796399993240E+06,
        0.101539557371443312E+06,       0.101482505549964961E+06,       0.101424993232468783E+06,       0.101369854642081831E+06,       0.101318588912198626E+06,
        0.101273234899637857E+06,       0.101235886605930398E+06,       0.101207937266056106E+06,       0.101192654572110885E+06,       0.101195023201913122E+06,
        0.101207165308628755E+06,       0.101227217799392965E+06,       0.101253372828479289E+06,       0.101281097568006837E+06,       0.101311856149601605E+06,
        0.101345648585710995E+06,       0.101381904947258168E+06,       0.101421272631944972E+06,       0.101465042995991040E+06,       0.101508835313142772E+06,
        0.101551196503329018E+06,       0.101590747790927970E+06,       0.101621682377021876E+06,       0.101645776231220763E+06,       0.101668026172758953E+06,
        0.101689491310640093E+06,       0.101711039834481373E+06,       0.101739312046503386E+06,       0.101772112447843610E+06,       0.101804858575323728E+06,
        0.101836540790179512E+06,       0.101866167898941654E+06,       0.101895518959796798E+06,       0.101925181845865300E+06,       0.101950074886373186E+06,
        0.101969061543749413E+06,       0.101981139844382837E+06,       0.101985462621642117E+06,       0.101977051366888656E+06,       0.101959701573010476E+06,
        0.101935377351789808E+06,       0.101905526341066099E+06,       0.101871781260336036E+06,       0.101835950124052295E+06,       0.100513581366792612E+06,
        0.100554019513422492E+06,       0.100598330045055409E+06,       0.100645982440550681E+06,       0.100696296648474527E+06,       0.100748444268485124E+06,
        0.100801453596632928E+06,       0.100854218792530621E+06,       0.100905513420273754E+06,       0.100949903492433834E+06,       0.100981652101286920E+06,
        0.101009573882022771E+06,       0.101033642379315977E+06,       0.101053802681678295E+06,       0.101069990410599494E+06,       0.101082152783372076E+06,
        0.101090271780979238E+06,       0.101094389439540580E+06,       0.101095654589873608E+06,       0.101096426446181518E+06,       0.101093666576257223E+06,
        0.101087429979991794E+06,       0.101077885304853742E+06,       0.101065339866105438E+06,       0.101050264366095507E+06,       0.101032061623940666E+06,
        0.101012844290179608E+06,       0.100996964302313558E+06,       0.100980770382518007E+06,       0.100964167390490678E+06,       0.100947108284160218E+06,
        0.100929597010366851E+06,       0.100911688070060860E+06,       0.100893582156858451E+06,       0.100881499094758808E+06,       0.100868335774262508E+06,
        0.100853829088449522E+06,       0.100837798044627038E+06,       0.100820106254778977E+06,       0.100800619132333683E+06,       0.100775042434612522E+06,
        0.100741873481754403E+06,       0.100707732498585203E+06,       0.100674198173852987E+06,       0.100642873485934600E+06,       0.100616787946543613E+06,
        0.100595574493244218E+06,       0.100580853452354946E+06,       0.100573369371954352E+06,       0.100573991194533155E+06,       0.100583507950136642E+06,
        0.100602650207284896E+06,       0.100640744734742359E+06,       0.100692244893923940E+06,       0.100751760770043053E+06,       0.100817532941637197E+06,
        0.100887787830291069E+06,       0.100962050144272376E+06,       0.101039744081827113E+06,       0.101116778936214221E+06,       0.101190892544115282E+06,
        0.101259778024939151E+06,       0.101317175633898092E+06,       0.101357978697233921E+06,       0.101390994520218446E+06,       0.101417406025828648E+06,
        0.101438439369066997E+06,       0.101456877295130529E+06,       0.101473268310223793E+06,       0.101486701484946811E+06,       0.101497860785624449E+06,
        0.101507276039524368E+06,       0.101514237723266677E+06,       0.101518949933443597E+06,       0.101522085026395580E+06,       0.101524243387710812E+06,
        0.101525990459469860E+06,       0.101528194232853784E+06,       0.101531700114421837E+06,       0.101537410817429205E+06,       0.101546492305229593E+06,
        0.101567903398293696E+06,       0.101597046994887613E+06,       0.101630996885802393E+06,       0.101669578744430226E+06,       0.101714590729228381E+06,
        0.101773403370424989E+06,       0.101836874445576148E+06,       0.101900881795697991E+06,       0.101960687121667026E+06,       0.102008686461021774E+06,
        0.102037960319300764E+06,       0.102056196723826288E+06,       0.102065273055902842E+06,       0.102066914347914004E+06,       0.102063547681288721E+06,
        0.102059509493393372E+06,       0.102055314339710254E+06,       0.102050951292832178E+06,       0.102044111461623615E+06,       0.102032193928193665E+06,
        0.102014558041099997E+06,       0.101990243188425869E+06,       0.101960364538554975E+06,       0.101925773749474116E+06,       0.101887402236031689E+06,
        0.101845900309227552E+06,       0.101802685936693102E+06,       0.101760172705529054E+06,       0.101722211673123806E+06,       0.101698120911338105E+06,
        0.101693242621827798E+06,       0.101701200555816351E+06,       0.101719376001235738E+06,       0.101743123574903206E+06,       0.101765016750218143E+06,
        0.101780249253377129E+06,       0.101783141086790420E+06,       0.101773015434274668E+06,       0.101749944711398595E+06,       0.101715364981995837E+06,
        0.101666832632786492E+06,       0.101609705385936162E+06,       0.101549151532732372E+06,       0.101488088183680564E+06,       0.101428826013168145E+06,
        0.101371975824192647E+06,       0.101321130368394268E+06,       0.101278514950626632E+06,       0.101245823084732416E+06,       0.101229713571326531E+06,
        0.101228252523962350E+06,       0.101236240082679593E+06,       0.101252202249213733E+06,       0.101274554004038626E+06,       0.101299571284751277E+06,
        0.101328619250470016E+06,       0.101360846988672172E+06,       0.101395461438518367E+06,       0.101432766703864487E+06,       0.101473307204623023E+06,
        0.101514010222445781E+06,       0.101553562190150420E+06,       0.101590717887284656E+06,       0.101621853851409600E+06,       0.101647543893485548E+06,
        0.101671058814602424E+06,       0.101693056210828203E+06,       0.101714129349830531E+06,       0.101738767714405170E+06,       0.101767638107703999E+06,
        0.101795424880191335E+06,       0.101821375190827370E+06,       0.101844797381800585E+06,       0.101865803928462847E+06,       0.101887241456978605E+06,
        0.101903742329332832E+06,       0.101914505259923375E+06,       0.101918870822307275E+06,       0.101916337996088478E+06,       0.101901784739594950E+06,
        0.101874548045828633E+06,       0.101841292001167923E+06,       0.101803678665118787E+06,       0.101762946401782145E+06,       0.101720412831625683E+06,
        0.100515408142486602E+06,       0.100551771547175376E+06,       0.100591372710722571E+06,       0.100633738189236901E+06,       0.100678255595108407E+06,
        0.100724173138854574E+06,       0.100770602351690526E+06,       0.100816524184232330E+06,       0.100854077383907817E+06,       0.100882309305546267E+06,
        0.100908312612091744E+06,       0.100931760805658370E+06,       0.100951200960303162E+06,       0.100967005250871938E+06,       0.100979637398817140E+06,
        0.100989094128378885E+06,       0.100995390483498064E+06,       0.100999335048962457E+06,       0.101003623776222332E+06,       0.101005037852830981E+06,
        0.101003566011062838E+06,       0.100999260214490059E+06,       0.100992254677997669E+06,       0.100982785569327156E+06,       0.100971211282625562E+06,
        0.100958033151982832E+06,       0.100947713227353204E+06,       0.100936845226361344E+06,       0.100925586455398079E+06,       0.100913386427886144E+06,
        0.100900970885727584E+06,       0.100888200173575184E+06,       0.100874969576689109E+06,       0.100865322504112410E+06,       0.100857431942648880E+06,
        0.100848190571948653E+06,       0.100837041611588123E+06,       0.100823522652975458E+06,       0.100807245058683751E+06,       0.100787869439158167E+06,
        0.100757391684316404E+06,       0.100722719302699363E+06,       0.100685949398277124E+06,       0.100648508643416208E+06,       0.100611886678086536E+06,
        0.100577601709138020E+06,       0.100546746024841152E+06,       0.100520863816718731E+06,       0.100501704292206879E+06,       0.100490795320886566E+06,
        0.100489573337377500E+06,       0.100499397978964334E+06,       0.100534016438231076E+06,       0.100580634795179663E+06,       0.100636771821988543E+06,
        0.100700900349775504E+06,       0.100771475161532377E+06,       0.100847971681032548E+06,       0.100928796704597553E+06,       0.101010401416626322E+06,
        0.101090599925904797E+06,       0.101167170271662733E+06,       0.101233921628300508E+06,       0.101285179817018958E+06,       0.101329796645055787E+06,
        0.101368459516926756E+06,       0.101402063972120028E+06,       0.101431554233350747E+06,       0.101457605089509292E+06,       0.101479887700559731E+06,
        0.101498521383338972E+06,       0.101513550784224833E+06,       0.101523174827992611E+06,       0.101527475564510401E+06,       0.101528428909431837E+06,
        0.101526914423630384E+06,       0.101523962459723334E+06,       0.101520309815973524E+06,       0.101516483972158181E+06,       0.101514002315449485E+06,
        0.101514722417862809E+06,       0.101522283068780089E+06,       0.101544056083037300E+06,       0.101571190634249404E+06,       0.101603956939872005E+06,
        0.101642017592925840E+06,       0.101688020789515867E+06,       0.101748771464749283E+06,       0.101810913304749745E+06,       0.101870419614457860E+06,
        0.101923449267402393E+06,       0.101967012984100948E+06,       0.101994050943781331E+06,       0.102011245751808630E+06,       0.102022174558490107E+06,
        0.102029125315834375E+06,       0.102033037791472336E+06,       0.102034394101747268E+06,       0.102032647951692605E+06,       0.102026060860393205E+06,
        0.102014286206869132E+06,       0.101997287902874697E+06,       0.101973908129249903E+06,       0.101945685744995091E+06,       0.101913755487835835E+06,
        0.101879518050633123E+06,       0.101845462413359521E+06,       0.101814438244852194E+06,       0.101787626131292665E+06,       0.101769079269016060E+06,
        0.101760662506367516E+06,       0.101763690025728793E+06,       0.101778245812273221E+06,       0.101800769364128020E+06,       0.101825464810029356E+06,
        0.101849318133198423E+06,       0.101866690516569448E+06,       0.101874423097137915E+06,       0.101868322033511577E+06,       0.101847631400323429E+06,
        0.101809657617465651E+06,       0.101759023134988529E+06,       0.101701048933469734E+06,       0.101638831844116052E+06,       0.101574555754104877E+06,
        0.101509980617449197E+06,       0.101449449533488441E+06,       0.101394594035173650E+06,       0.101347377713062888E+06,       0.101309681379202666E+06,
        0.101289625678805663E+06,       0.101280310168622382E+06,       0.101280601256181355E+06,       0.101289183040688731E+06,       0.101304405647058535E+06,
        0.101324688438220604E+06,       0.101349563357044477E+06,       0.101377976699525767E+06,       0.101409028339016470E+06,       0.101442179995567261E+06,
        0.101476777887449236E+06,       0.101511738303380160E+06,       0.101546126683052818E+06,       0.101579196765551533E+06,       0.101607991498285395E+06,
        0.101632611269017507E+06,       0.101655502605639515E+06,       0.101677080810846644E+06,       0.101697768628730599E+06,       0.101719316740837268E+06,
        0.101742656846947124E+06,       0.101764837611636452E+06,       0.101785178883928776E+06,       0.101802942432164040E+06,       0.101817351144786313E+06,
        0.101829733328404807E+06,       0.101837655847121932E+06,       0.101840093420000965E+06,       0.101836302876360205E+06,       0.101825658934804160E+06,
        0.101806477102295394E+06,       0.101772591154458947E+06,       0.101732979877375386E+06,       0.101689114392674877E+06,       0.101642472350711148E+06,
        0.101594527408217124E+06,       0.100521483098622790E+06,       0.100553034374379175E+06,       0.100587237837357708E+06,       0.100623674982973011E+06,
        0.100661797732431733E+06,       0.100700926585977664E+06,       0.100740251364819997E+06,       0.100769102422238415E+06,       0.100792034055430398E+06,
        0.100813412935669796E+06,       0.100833061354508041E+06,       0.100850766087262135E+06,       0.100866291971468818E+06,       0.100879397215573350E+06,
        0.100889850447447578E+06,       0.100896874983048474E+06,       0.100901879624732552E+06,       0.100908045012513743E+06,       0.100911845008177756E+06,
        0.100913263133695262E+06,       0.100912309117336132E+06,       0.100909033352763217E+06,       0.100903541829518552E+06,       0.100896011438153932E+06,
        0.100886705535507586E+06,       0.100878478741165993E+06,       0.100870518698868997E+06,       0.100862258577488697E+06,       0.100853850267061993E+06,
        0.100845456536039332E+06,       0.100837262111476593E+06,       0.100829483975533818E+06,       0.100823560640713331E+06,       0.100821677296257287E+06,
        0.100817550375560750E+06,       0.100812145039498006E+06,       0.100804659355862575E+06,       0.100794378660273913E+06,       0.100780665915676014E+06,
        0.100760028631593887E+06,       0.100729776405452620E+06,       0.100695664007384359E+06,       0.100658676701707998E+06,       0.100619966898071216E+06,
        0.100580820672301052E+06,       0.100542567168908456E+06,       0.100504377972890885E+06,       0.100469914337100665E+06,       0.100440979221872039E+06,
        0.100419342752137061E+06,       0.100406745142411062E+06,       0.100406705150974245E+06,       0.100432011566503701E+06,       0.100468676779983842E+06,
        0.100515495509657252E+06,       0.100571181275147042E+06,       0.100634390994595859E+06,       0.100706784795550964E+06,       0.100786680087649889E+06,
        0.100869494529497810E+06,       0.100952905038971541E+06,       0.101034572199124057E+06,       0.101109749894571214E+06,       0.101172314783061069E+06,
        0.101229755518492922E+06,       0.101282350507230105E+06,       0.101330323821815167E+06,       0.101373763209774886E+06,       0.101412160049147336E+06,
        0.101445520624250392E+06,       0.101474055469030995E+06,       0.101497872459806793E+06,       0.101516095634979050E+06,       0.101525003393313920E+06,
        0.101529087732478598E+06,       0.101529555701643461E+06,       0.101527554535439689E+06,       0.101523924716972469E+06,       0.101519184588702949E+06,
        0.101515359052858228E+06,       0.101513419431477203E+06,       0.101515061119696038E+06,       0.101524365504439338E+06,       0.101545492952323460E+06,
        0.101572260216870665E+06,       0.101604062662735640E+06,       0.101640454999672467E+06,       0.101681140705924787E+06,       0.101736471342456469E+06,
        0.101791820815604107E+06,       0.101843025813835338E+06,       0.101888338055426750E+06,       0.101926497388645425E+06,       0.101956523951729410E+06,
        0.101977389503551763E+06,       0.101992863624521677E+06,       0.102004636055621828E+06,       0.102012873990628723E+06,       0.102016923944167502E+06,
        0.102015589894533594E+06,       0.102008242524494635E+06,       0.101994805733422399E+06,       0.101975527326879805E+06,       0.101951699623577006E+06,
        0.101924648595227743E+06,       0.101896134378200717E+06,       0.101868181223228035E+06,       0.101842690796364026E+06,       0.101823518800336897E+06,
        0.101810966006917995E+06,       0.101810361562174381E+06,       0.101819625326231835E+06,       0.101837655873780983E+06,       0.101862056783833701E+06,
        0.101890848697784473E+06,       0.101919025148523811E+06,       0.101942604878219718E+06,       0.101953732079914320E+06,       0.101952348959737385E+06,
        0.101930393928014251E+06,       0.101894531594142769E+06,       0.101847206824460780E+06,       0.101792255748977870E+06,       0.101731720782488774E+06,
        0.101667410578914118E+06,       0.101601955467176056E+06,       0.101538353512944566E+06,       0.101479206063803722E+06,       0.101426875382686587E+06,
        0.101386679687780139E+06,       0.101358881267937715E+06,       0.101340978693972764E+06,       0.101332100373616413E+06,       0.101331377677835859E+06,
        0.101337757250038121E+06,       0.101350176595795769E+06,       0.101367529237839539E+06,       0.101388710034061514E+06,       0.101412656335492444E+06,
        0.101438146564572395E+06,       0.101465030990242507E+06,       0.101492743759273944E+06,       0.101520528048576030E+06,       0.101547656089289187E+06,
        0.101573646733203917E+06,       0.101598176409242311E+06,       0.101621015547307805E+06,       0.101642090999262466E+06,       0.101661344187207244E+06,
        0.101680048117579805E+06,       0.101700060142799775E+06,       0.101717676267340707E+06,       0.101732293239297534E+06,       0.101743299867593101E+06,
        0.101750084174098316E+06,       0.101754164408332057E+06,       0.101753815772929738E+06,       0.101747787368181351E+06,       0.101735699407228763E+06,
        0.101717273900884597E+06,       0.101692348035134710E+06,       0.101654861811602153E+06,       0.101610673295375120E+06,       0.101562751614357956E+06,
        0.101512638519625150E+06,       0.101461813597627668E+06,       0.100533318325900138E+06,       0.100559018706234609E+06,       0.100586667516233734E+06,
        0.100616430509356855E+06,       0.100647457772304173E+06,       0.100679140607943787E+06,       0.100698527261697847E+06,       0.100715798167830915E+06,
        0.100731931694921790E+06,       0.100746896633405166E+06,       0.100760616569955790E+06,       0.100772979417731243E+06,       0.100783848302944942E+06,
        0.100793073809534399E+06,       0.100800507571478287E+06,       0.100806483772806212E+06,       0.100813801762586605E+06,       0.100819127022868051E+06,
        0.100822124828140237E+06,       0.100822902466370797E+06,       0.100821716855826366E+06,       0.100818621189554789E+06,       0.100813702346186765E+06,
        0.100807092657524059E+06,       0.100799795563032545E+06,       0.100792638500522866E+06,       0.100785284309503724E+06,       0.100777874398839282E+06,
        0.100770527259340961E+06,       0.100763347669699418E+06,       0.100756435329570639E+06,       0.100749892793592095E+06,       0.100749373875165576E+06,
        0.100750222933888348E+06,       0.100750603463785985E+06,       0.100749864242144642E+06,       0.100747320689053289E+06,       0.100742256076426071E+06,
        0.100733920852957395E+06,       0.100715113795294979E+06,       0.100689064952966379E+06,       0.100657845711542803E+06,       0.100623250918292935E+06,
        0.100586038000497676E+06,       0.100547134348203457E+06,       0.100506028825088957E+06,       0.100462291432826620E+06,       0.100421048783818245E+06,
        0.100384122683633468E+06,       0.100353368412380165E+06,       0.100330670880394246E+06,       0.100321776442990944E+06,       0.100334624094787185E+06,
        0.100358437666044687E+06,       0.100392488442372807E+06,       0.100435977221972600E+06,       0.100488073955800399E+06,       0.100552415559277870E+06,
        0.100627255810881121E+06,       0.100707092289738357E+06,       0.100789756856378794E+06,       0.100873101113792349E+06,       0.100954216801293107E+06,
        0.101025863759345229E+06,       0.101094584610272868E+06,       0.101160235498342692E+06,       0.101222606811297053E+06,       0.101281370962640489E+06,
        0.101332163642811851E+06,       0.101376972618262807E+06,       0.101416728366496085E+06,       0.101451473910749541E+06,       0.101480959555488313E+06,
        0.101500381551832834E+06,       0.101512210195641775E+06,       0.101519514244373393E+06,       0.101523444803633465E+06,       0.101525155563451161E+06,
        0.101524617344664759E+06,       0.101522395272590235E+06,       0.101521151212846860E+06,       0.101522340865174643E+06,       0.101527072168721963E+06,
        0.101537882062393008E+06,       0.101559080181885220E+06,       0.101584526114373686E+06,       0.101614244538571933E+06,       0.101647894372795839E+06,
        0.101684681982032082E+06,       0.101726895995367770E+06,       0.101774312937747018E+06,       0.101818830342195433E+06,       0.101858335228138851E+06,
        0.101893176738273338E+06,       0.101922949034176403E+06,       0.101947508183230893E+06,       0.101967684274917294E+06,       0.101983202615811271E+06,
        0.101993442131563672E+06,       0.101998812147038072E+06,       0.101998613039324773E+06,       0.101992329378160532E+06,       0.101980249760691964E+06,
        0.101962626054339082E+06,       0.101940465078019130E+06,       0.101915907622174098E+06,       0.101890478407916715E+06,       0.101866977689826570E+06,
        0.101849754719304707E+06,       0.101837665745559920E+06,       0.101833602586389810E+06,       0.101841599729967784E+06,       0.101859775477370218E+06,
        0.101886984424902446E+06,       0.101919867690970117E+06,       0.101951746477934430E+06,       0.101978482983373731E+06,       0.101993393892969194E+06,
        0.101991412250034802E+06,       0.101974123414601141E+06,       0.101945239434022718E+06,       0.101905684392780662E+06,       0.101856949799144815E+06,
        0.101801731134592686E+06,       0.101742504741481811E+06,       0.101681038790539489E+06,       0.101619356067038418E+06,       0.101559380452289755E+06,
        0.101505641285490463E+06,       0.101461701752299428E+06,       0.101426005705293821E+06,       0.101398896334048623E+06,       0.101380282180095601E+06,
        0.101369836995025384E+06,       0.101367277170112575E+06,       0.101370986941406809E+06,       0.101379906423074499E+06,       0.101392831033495459E+06,
        0.101408554312665205E+06,       0.101424869582900283E+06,       0.101443182567207696E+06,       0.101462968409184250E+06,       0.101483671134433898E+06,
        0.101504732894123474E+06,       0.101527421913474638E+06,       0.101550095820920280E+06,       0.101571562110317216E+06,       0.101591355780169426E+06,
        0.101609078015251362E+06,       0.101625097194956237E+06,       0.101640337310256451E+06,       0.101652605117688974E+06,       0.101661397415208048E+06,
        0.101666225004107662E+06,       0.101666619975683658E+06,       0.101662556408727090E+06,       0.101653580628123964E+06,       0.101639218203126409E+06,
        0.101619381357809092E+06,       0.101594063768788052E+06,       0.101563351510846944E+06,       0.101523851133020638E+06,       0.101476807405962056E+06,
        0.101426978369828445E+06,       0.101375797428347505E+06,       0.101324598573980998E+06,       0.100551530203326562E+06,       0.100571727120900570E+06,
        0.100593051779557791E+06,       0.100614868997312486E+06,       0.100634144763448072E+06,       0.100645833089619511E+06,       0.100657235284227281E+06,
        0.100667686387769805E+06,       0.100677292913672762E+06,       0.100686112073701530E+06,       0.100694158258119947E+06,       0.100701410586929007E+06,
        0.100707821531117806E+06,       0.100713326592793543E+06,       0.100718292448464927E+06,       0.100725135313074701E+06,       0.100730736036059810E+06,
        0.100734776949494801E+06,       0.100736983079004160E+06,       0.100737142689159882E+06,       0.100735125062421313E+06,       0.100730895453973062E+06,
        0.100724936089312163E+06,       0.100718101716589372E+06,       0.100710128659467940E+06,       0.100701978143640532E+06,       0.100693854728853868E+06,
        0.100685917546278361E+06,       0.100678288281938949E+06,       0.100671058793584918E+06,       0.100664298277410649E+06,       0.100660712381595760E+06,
        0.100661723426356752E+06,       0.100663150264819735E+06,       0.100664393149270531E+06,       0.100664799968549007E+06,       0.100663672287188572E+06,
        0.100660269896986065E+06,       0.100653054372944243E+06,       0.100638919308817800E+06,       0.100620188598009743E+06,       0.100597036492593310E+06,
        0.100569788712949841E+06,       0.100538901380231502E+06,       0.100504939031211514E+06,       0.100464616545740675E+06,       0.100420082357890147E+06,
        0.100376069547844643E+06,       0.100334560389268605E+06,       0.100297550195584583E+06,       0.100267038173233668E+06,       0.100249183652606138E+06,
        0.100248031291493899E+06,       0.100256756900526307E+06,       0.100275250996069168E+06,       0.100303318888992886E+06,       0.100340733860613560E+06,
        0.100392668457859341E+06,       0.100458197469974984E+06,       0.100530344725997711E+06,       0.100607247564767138E+06,       0.100687079608666914E+06,
        0.100768076831136714E+06,       0.100845286817167653E+06,       0.100921915425536106E+06,       0.100997896081585553E+06,       0.101072548063258917E+06,
        0.101144965887108527E+06,       0.101210711249507964E+06,       0.101267759563819229E+06,       0.101319932991058231E+06,       0.101367121820533270E+06,
        0.101409115377035181E+06,       0.101445063624758288E+06,       0.101467868269852072E+06,       0.101485221941439115E+06,       0.101498187544558168E+06,
        0.101507881316604296E+06,       0.101515310949875333E+06,       0.101519599975213365E+06,       0.101522106701145909E+06,       0.101524851878856789E+06,
        0.101529230085351330E+06,       0.101536191323789782E+06,       0.101546697524065807E+06,       0.101566224388216360E+06,       0.101589918902257763E+06,
        0.101616845515287452E+06,       0.101647215589828833E+06,       0.101680341115790361E+06,       0.101715366089036543E+06,       0.101752316168779886E+06,
        0.101791176678952732E+06,       0.101827052748008107E+06,       0.101859044996505589E+06,       0.101887670526199319E+06,       0.101913122414070647E+06,
        0.101934463666524054E+06,       0.101952632860506710E+06,       0.101966700037415663E+06,       0.101975525710702976E+06,       0.101978461989723088E+06,
        0.101975173899271627E+06,       0.101964823473388897E+06,       0.101947665044748559E+06,       0.101926227690128857E+06,       0.101900561072349257E+06,
        0.101874251008341424E+06,       0.101851830347918643E+06,       0.101836189738381829E+06,       0.101828888260193082E+06,       0.101835000054969831E+06,
        0.101851733006117443E+06,       0.101877232568018531E+06,       0.101909510086827300E+06,       0.101940989073697696E+06,       0.101965528537313672E+06,
        0.101979608526400712E+06,       0.101982970036656799E+06,       0.101975240583827399E+06,       0.101955388827734365E+06,       0.101924654892196661E+06,
        0.101887578699447098E+06,       0.101842186561714494E+06,       0.101789317463778367E+06,       0.101732832688802417E+06,       0.101675288481823532E+06,
        0.101619263688587671E+06,       0.101568048094496247E+06,       0.101521062700628769E+06,       0.101479654154784279E+06,       0.101445221739311222E+06,
        0.101418076416901371E+06,       0.101399045923829544E+06,       0.101387018859001342E+06,       0.101381135963448469E+06,       0.101380650007871780E+06,
        0.101384722424981679E+06,       0.101391720295262028E+06,       0.101400396876228624E+06,       0.101411346068523795E+06,       0.101424155121034681E+06,
        0.101438457710905030E+06,       0.101453929199892154E+06,       0.101472913422971527E+06,       0.101492074099173711E+06,       0.101510560767898467E+06,
        0.101527744434993336E+06,       0.101543054611759319E+06,       0.101555675557276962E+06,       0.101564929191696821E+06,       0.101571016898623420E+06,
        0.101573544015567939E+06,       0.101572121672385867E+06,       0.101566370463087485E+06,       0.101554662308102721E+06,       0.101536629786898047E+06,
        0.101513803810128695E+06,       0.101486361735486105E+06,       0.101454563654390658E+06,       0.101418767627698660E+06,       0.101378013088347099E+06,
        0.101330707820646552E+06,       0.101282264555356756E+06,       0.101234028760920090E+06,       0.101187294700704195E+06,       0.100576965529563255E+06,
        0.100591678218711211E+06,       0.100607008383076420E+06,       0.100616323103987481E+06,       0.100620258552074985E+06,       0.100623651287353903E+06,
        0.100626463751429124E+06,       0.100628648078344573E+06,       0.100631378331016531E+06,       0.100634129163284262E+06,       0.100636562070289394E+06,
        0.100638738873227092E+06,       0.100640693964837556E+06,       0.100643049230926015E+06,       0.100648185229669587E+06,       0.100652678597624064E+06,
        0.100656261255894686E+06,       0.100658660860211399E+06,       0.100659622834889029E+06,       0.100658930196984991E+06,       0.100656421096238220E+06,
        0.100652004015325234E+06,       0.100645400203396595E+06,       0.100634943591599571E+06,       0.100623790772243461E+06,       0.100612166299320219E+06,
        0.100600323220825783E+06,       0.100589367539107639E+06,       0.100580442279124138E+06,       0.100572243324848969E+06,       0.100564857703730217E+06,
        0.100563322531964557E+06,       0.100563065402201857E+06,       0.100563607762748041E+06,       0.100564433779967017E+06,       0.100564965723689515E+06,
        0.100564572517680892E+06,       0.100562577288210698E+06,       0.100558128795487573E+06,       0.100550306656448985E+06,       0.100538784205606309E+06,
        0.100523395229331582E+06,       0.100504107960399502E+06,       0.100481009310527326E+06,       0.100454286649172413E+06,       0.100417998848613410E+06,
        0.100377654481256992E+06,       0.100336323265197076E+06,       0.100295695643989733E+06,       0.100257502669341542E+06,       0.100223497751048752E+06,
        0.100198365893325012E+06,       0.100183895883056030E+06,       0.100176748173119719E+06,       0.100177409781642637E+06,       0.100186348863375271E+06,
        0.100204071706916817E+06,       0.100236974921233719E+06,       0.100288202283773542E+06,       0.100347584962604393E+06,       0.100413567810885099E+06,
        0.100484685800612540E+06,       0.100559609376774941E+06,       0.100637786676389092E+06,       0.100719143709254829E+06,       0.100802573207076450E+06,
        0.100886953694736978E+06,       0.100970981281993736E+06,       0.101053137277853224E+06,       0.101122114850514685E+06,       0.101186021991939982E+06,
        0.101244880734986247E+06,       0.101298842483030225E+06,       0.101347976726965513E+06,       0.101388865316328054E+06,       0.101417494561782441E+06,
        0.101441011237599363E+06,       0.101460308434203442E+06,       0.101476142058636950E+06,       0.101489111828680267E+06,       0.101498177707129027E+06,
        0.101504275218907074E+06,       0.101509888353816961E+06,       0.101516205429889771E+06,       0.101524373025953057E+06,       0.101535544403108914E+06,
        0.101550771587497264E+06,       0.101572228401773711E+06,       0.101596922610232752E+06,       0.101624267341491490E+06,       0.101653892197854148E+06,
        0.101685371964174541E+06,       0.101717744368668005E+06,       0.101749825128001146E+06,       0.101781782699506482E+06,       0.101812709382600748E+06,
        0.101841353313321029E+06,       0.101867900490832937E+06,       0.101893188014203624E+06,       0.101915193984979924E+06,       0.101933169418903170E+06,
        0.101945970442238802E+06,       0.101952233644425200E+06,       0.101949989638197949E+06,       0.101938812116678397E+06,       0.101921309771955755E+06,
        0.101897306204910492E+06,       0.101870511994013577E+06,       0.101845727987357284E+06,       0.101827162893394896E+06,       0.101815741469126820E+06,
        0.101815347936997394E+06,       0.101829035456973521E+06,       0.101849227052658054E+06,       0.101873947210599901E+06,       0.101900166979187969E+06,
        0.101922501433547208E+06,       0.101938537730062933E+06,       0.101945622505927895E+06,       0.101943220759731354E+06,       0.101933233593028053E+06,
        0.101913480508279812E+06,       0.101884226864883196E+06,       0.101847880125950556E+06,       0.101805028700279145E+06,       0.101757073613196655E+06,
        0.101706590973509752E+06,       0.101656335498895467E+06,       0.101607292592687139E+06,       0.101560626743744360E+06,       0.101517500638364392E+06,
        0.101478925847553910E+06,       0.101446343700160927E+06,       0.101419879250754559E+06,       0.101398958955256283E+06,       0.101383710029623602E+06,
        0.101374588904196891E+06,       0.101370168865842439E+06,       0.101369105684779628E+06,       0.101370929669406774E+06,       0.101375271898136503E+06,
        0.101381760968333765E+06,       0.101390061699633865E+06,       0.101400585700279218E+06,       0.101414338736935577E+06,       0.101428328122293344E+06,
        0.101441772517097343E+06,       0.101453941211612226E+06,       0.101464150240094372E+06,       0.101470694861331591E+06,       0.101472993001670693E+06,
        0.101472098749250043E+06,       0.101467692245319617E+06,       0.101459459863983502E+06,       0.101447099986294808E+06,       0.101428337148487699E+06,
        0.101402273058774066E+06,       0.101372210423711062E+06,       0.101338601145403256E+06,       0.101301942982120236E+06,       0.101262793506100817E+06,
        0.101221677786233748E+06,       0.101176731503889008E+06,       0.101131973913656722E+06,       0.101088479543089110E+06,       0.101047269615024925E+06,
        0.100610222449967056E+06,       0.100619368346169198E+06,       0.100619051340248508E+06,       0.100617580194349401E+06,       0.100615500249746110E+06,
        0.100612844510783863E+06,       0.100609637715591729E+06,       0.100605899629696811E+06,       0.100601648181252385E+06,       0.100596902436962919E+06,
        0.100591685422206356E+06,       0.100587098052459361E+06,       0.100585436102778738E+06,       0.100587603438895458E+06,       0.100589520780671664E+06,
        0.100591027689952418E+06,       0.100591916118502122E+06,       0.100591952568608729E+06,       0.100590898493088505E+06,       0.100588528847269830E+06,
        0.100584648718839380E+06,       0.100579107975368854E+06,       0.100568181408087505E+06,       0.100556028233350124E+06,       0.100543329111321902E+06,
        0.100530292741429832E+06,       0.100517138305172819E+06,       0.100504104046550317E+06,       0.100491454262540399E+06,       0.100479484740824249E+06,
        0.100470155044772182E+06,       0.100463687256117119E+06,       0.100458896797118272E+06,       0.100455620879032227E+06,       0.100454260984570079E+06,
        0.100454114005490293E+06,       0.100453954401208190E+06,       0.100453246548017763E+06,       0.100453544534649671E+06,       0.100451784335522374E+06,
        0.100447402272511725E+06,       0.100439945313556469E+06,       0.100429058870933281E+06,       0.100414474145118424E+06,       0.100395971880822995E+06,
        0.100364627363950829E+06,       0.100330069619100730E+06,       0.100293517928604648E+06,       0.100256250274621154E+06,       0.100219578502905337E+06,
        0.100184821369736295E+06,       0.100153602788173128E+06,       0.100126759271301082E+06,       0.100104736505522000E+06,       0.100088530813236051E+06,
        0.100079174170628597E+06,       0.100077782208942881E+06,       0.100089384583247156E+06,       0.100124675759422840E+06,       0.100169171328412835E+06,
        0.100221720050477204E+06,       0.100281293603445694E+06,       0.100347032197583365E+06,       0.100419381954596480E+06,       0.100501100689285435E+06,
        0.100587123759395632E+06,       0.100676265830202465E+06,       0.100767041531711700E+06,       0.100857717751965523E+06,       0.100942425402787208E+06,
        0.101015252626361835E+06,       0.101084506455799405E+06,       0.101149930187516162E+06,       0.101211031351648766E+06,       0.101267093811678642E+06,
        0.101313485842090842E+06,       0.101347864445685816E+06,       0.101377348186801406E+06,       0.101401563075397265E+06,       0.101421152746379506E+06,
        0.101436703379514453E+06,       0.101448418323353719E+06,       0.101455739244278491E+06,       0.101461288984514365E+06,       0.101466634842994637E+06,
        0.101474204912937290E+06,       0.101485236375258624E+06,       0.101500599693197641E+06,       0.101519974341673922E+06,       0.101542425947491516E+06,
        0.101567705013514729E+06,       0.101595287754062447E+06,       0.101623559085342917E+06,       0.101653300863473152E+06,       0.101684268370484802E+06,
        0.101715396578327011E+06,       0.101746648790418796E+06,       0.101778157009654227E+06,       0.101810294427225992E+06,       0.101840186138904261E+06,
        0.101866664724512098E+06,       0.101888829801923304E+06,       0.101904365840783910E+06,       0.101910875981687976E+06,       0.101907623411986046E+06,
        0.101897747215346535E+06,       0.101880196785050444E+06,       0.101858268156208374E+06,       0.101836776997478300E+06,       0.101819952813389187E+06,
        0.101808320250000223E+06,       0.101803197426602317E+06,       0.101808609816872282E+06,       0.101820932164050100E+06,       0.101835981686293468E+06,
        0.101853975694054869E+06,       0.101871402202830723E+06,       0.101884750589340591E+06,       0.101893763845945417E+06,       0.101896316342375110E+06,
        0.101891679490974697E+06,       0.101879011465031377E+06,       0.101858040507289596E+06,       0.101829415896828315E+06,       0.101794099063775866E+06,
        0.101754870334758903E+06,       0.101712830221134776E+06,       0.101668524343052632E+06,       0.101623305627111258E+06,       0.101578731565899987E+06,
        0.101536822594720084E+06,       0.101498255706646247E+06,       0.101464056159653454E+06,       0.101434228357694403E+06,       0.101408947230003760E+06,
        0.101388258426133107E+06,       0.101372054750796451E+06,       0.101360489212098575E+06,       0.101352621134682369E+06,       0.101347535522944934E+06,
        0.101344862604306050E+06,       0.101344225484927229E+06,       0.101345820651379589E+06,       0.101351700849621455E+06,       0.101359530806993411E+06,
        0.101367464680662029E+06,       0.101374791985950258E+06,       0.101380818284913359E+06,       0.101384869714943547E+06,       0.101384236152984289E+06,
        0.101379411934677875E+06,       0.101371434785651902E+06,       0.101360085004396402E+06,       0.101345137105284986E+06,       0.101326366500254488E+06,
        0.101300808610161446E+06,       0.101267227431123814E+06,       0.101230448890002648E+06,       0.101191134568648122E+06,       0.101149957676138991E+06,
        0.101107616865909265E+06,       0.101064847159165423E+06,       0.101022580301005539E+06,       0.100981724783641272E+06,       0.100943032631428388E+06,
        0.100907229742725089E+06,       0.100647986354424997E+06,       0.100642715659511494E+06,       0.100636609969385099E+06,       0.100629766959429631E+06,
        0.100622273153360293E+06,       0.100614207409999959E+06,       0.100605644320867577E+06,       0.100596657511128040E+06,       0.100587322839384142E+06,
        0.100577721494929676E+06,       0.100567942994422949E+06,       0.100559032457675799E+06,       0.100552977775159990E+06,       0.100548029023239913E+06,
        0.100543925649759869E+06,       0.100540775676255420E+06,       0.100537926202230563E+06,       0.100534526225857189E+06,       0.100530349204130558E+06,
        0.100525160024924175E+06,       0.100518730289664294E+06,       0.100507262057308282E+06,       0.100493351445575739E+06,       0.100478812420309798E+06,
        0.100463863563753723E+06,       0.100448706735957079E+06,       0.100433537133342616E+06,       0.100418551953121700E+06,       0.100403957667064577E+06,
        0.100390113818734360E+06,       0.100378283224859435E+06,       0.100368019408275955E+06,       0.100359348113145898E+06,       0.100352231413445901E+06,
        0.100346572462762793E+06,       0.100342221388570266E+06,       0.100338982151060118E+06,       0.100338392782828159E+06,       0.100341188152017450E+06,
        0.100343374795880460E+06,       0.100344284175602748E+06,       0.100343279804720136E+06,       0.100339754195549598E+06,       0.100333123950383713E+06,
        0.100321286971674039E+06,       0.100297287465905509E+06,       0.100269835508128133E+06,       0.100239714419667638E+06,       0.100207741409672206E+06,
        0.100174751447097195E+06,       0.100141579771693956E+06,       0.100106755441371904E+06,       0.100069912900784475E+06,       0.100035704844720982E+06,
        0.100005528642180579E+06,       0.999808555037528422E+05,       0.999632723451110069E+05,       0.999545236439836153E+05,       0.999736658577992639E+05,
        0.100003353333015431E+06,       0.100042064117430200E+06,       0.100089071041598727E+06,       0.100143778848621456E+06,       0.100205754250853075E+06,
        0.100280664932831889E+06,       0.100364704219084786E+06,       0.100454126970714191E+06,       0.100547163719590288E+06,       0.100641885410501171E+06,
        0.100736224731986324E+06,       0.100821668363604142E+06,       0.100899090295081827E+06,       0.100973330050358534E+06,       0.101044570047650093E+06,
        0.101111101684352281E+06,       0.101171922832138123E+06,       0.101223284014747289E+06,       0.101260000146915598E+06,       0.101290169362142216E+06,
        0.101314373328620830E+06,       0.101333177003506280E+06,       0.101345070024148474E+06,       0.101353392220116293E+06,       0.101359052838648713E+06,
        0.101363820978951000E+06,       0.101369812488926094E+06,       0.101377607762478350E+06,       0.101388432240829963E+06,       0.101403721097234418E+06,
        0.101423686495689355E+06,       0.101447911692908267E+06,       0.101474956233570803E+06,       0.101501708578459278E+06,       0.101530416403443902E+06,
        0.101560731988182699E+06,       0.101592331907465996E+06,       0.101625384375889567E+06,       0.101660463766652349E+06,       0.101696287937694025E+06,
        0.101731505165402195E+06,       0.101765373671168942E+06,       0.101795889760683582E+06,       0.101821575901139222E+06,       0.101839426770240534E+06,
        0.101848304582011391E+06,       0.101850674932157766E+06,       0.101845563338820590E+06,       0.101833662450669886E+06,       0.101819729736987734E+06,
        0.101806525676924168E+06,       0.101796235624030873E+06,       0.101788878921415002E+06,       0.101786474628160606E+06,       0.101791411418041462E+06,
        0.101799155363379643E+06,       0.101808395203049906E+06,       0.101819645577764153E+06,       0.101830409662230682E+06,       0.101837554446248556E+06,
        0.101839744105951162E+06,       0.101836170755967585E+06,       0.101826399135349377E+06,       0.101810169058729633E+06,       0.101787697095879019E+06,
        0.101760376393189144E+06,       0.101728853043894385E+06,       0.101693851935638726E+06,       0.101656211520082943E+06,       0.101616790158213262E+06,
        0.101576704560053928E+06,       0.101537500986694940E+06,       0.101500335696260430E+06,       0.101465878362827381E+06,       0.101434840756723977E+06,
        0.101408292472182264E+06,       0.101385653681886775E+06,       0.101367773762272278E+06,       0.101355060936308873E+06,       0.101344865614149967E+06,
        0.101336866601978196E+06,       0.101330803221953858E+06,       0.101326445157375012E+06,       0.101323705025865274E+06,       0.101323151766299212E+06,
        0.101323317919074820E+06,       0.101323609309034800E+06,       0.101323383998279736E+06,       0.101321968519799790E+06,       0.101318674829698095E+06,
        0.101309557473271183E+06,       0.101297255318789845E+06,       0.101282004506700381E+06,       0.101263593826286131E+06,       0.101241822534985287E+06,
        0.101216505434514431E+06,       0.101183763113335532E+06,       0.101143062284304673E+06,       0.101099958082106066E+06,       0.101055260378077917E+06,
        0.101009770107324861E+06,       0.100964289722992879E+06,       0.100919631222605836E+06,       0.100878395229792455E+06,       0.100840230418695966E+06,
        0.100804814065610379E+06,       0.100772660269162792E+06,       0.100687581879727732E+06,       0.100677327145079587E+06,       0.100666160693170401E+06,
        0.100654207341057889E+06,       0.100641583937123549E+06,       0.100628402623918475E+06,       0.100614774045043421E+06,       0.100600810488184259E+06,
        0.100586628958508634E+06,       0.100572354178803900E+06,       0.100558377265734845E+06,       0.100545518784321612E+06,       0.100533722529582723E+06,
        0.100522910171807918E+06,       0.100512931196078469E+06,       0.100503576020145658E+06,       0.100494590303307457E+06,       0.100485690264560879E+06,
        0.100476578798775605E+06,       0.100466962148914608E+06,       0.100453831814755409E+06,       0.100437250927331042E+06,       0.100419883924672962E+06,
        0.100402010894887906E+06,       0.100383869790613491E+06,       0.100365667294769126E+06,       0.100347588515499185E+06,       0.100329805497802925E+06,
        0.100312484547517117E+06,       0.100295677938969020E+06,       0.100279971482571520E+06,       0.100265646792895117E+06,       0.100252835911466231E+06,
        0.100241624480511469E+06,       0.100232054881627162E+06,       0.100224130808306480E+06,       0.100217823206996967E+06,       0.100218259667894425E+06,
        0.100221888558547784E+06,       0.100225662634090608E+06,       0.100228894178654795E+06,       0.100230909476646018E+06,       0.100231046622607246E+06,
        0.100228652435841679E+06,       0.100220736457496634E+06,       0.100203006988572233E+06,       0.100182026084597936E+06,       0.100158298000477531E+06,
        0.100132350369893451E+06,       0.100104715520267695E+06,       0.100075909358704739E+06,       0.100043124770855982E+06,       0.100002028989072438E+06,
        0.999616642547620577E+05,       0.999236877809293510E+05,       0.998898266920593742E+05,       0.998618945050216280E+05,       0.998418030619178171E+05,
        0.998423833568641858E+05,       0.998594396345241257E+05,       0.998857662121956964E+05,       0.999209046169008070E+05,       0.999644862724064005E+05,
        0.100016242187354641E+06,       0.100077317810256820E+06,       0.100156061627195784E+06,       0.100241897409154641E+06,       0.100332874470688155E+06,
        0.100428637026128985E+06,       0.100526117084385623E+06,       0.100622332108951261E+06,       0.100709061724389190E+06,       0.100788527255290071E+06,
        0.100863969991383987E+06,       0.100934619610214693E+06,       0.100999507530848088E+06,       0.101057589879684849E+06,       0.101107912118639942E+06,
        0.101140898046464674E+06,       0.101165194334426677E+06,       0.101183324487668549E+06,       0.101196455912974372E+06,       0.101205787756098696E+06,
        0.101212555660780359E+06,       0.101217307428240179E+06,       0.101221221076374510E+06,       0.101226815969850082E+06,       0.101235775469520071E+06,
        0.101249089517923203E+06,       0.101267499119154090E+06,       0.101290114155802439E+06,       0.101316108973235343E+06,       0.101344864351232871E+06,
        0.101376027068939133E+06,       0.101409318557868275E+06,       0.101444185441017980E+06,       0.101479505555003896E+06,       0.101516882009007721E+06,
        0.101555258888103534E+06,       0.101593997928136538E+06,       0.101632899844262269E+06,       0.101670115604274892E+06,       0.101703897209036979E+06,
        0.101731821696663668E+06,       0.101752696747597220E+06,       0.101767805557897402E+06,       0.101776451771069726E+06,       0.101776669469582252E+06,
        0.101773409436917937E+06,       0.101768516316242836E+06,       0.101762622025664066E+06,       0.101757375988241824E+06,       0.101753826825127559E+06,
        0.101753403149395934E+06,       0.101756975828023817E+06,       0.101760728893977721E+06,       0.101764213695991348E+06,       0.101767251659026326E+06,
        0.101770663081707637E+06,       0.101770424123169345E+06,       0.101766072271416459E+06,       0.101755995409002455E+06,       0.101740345666592038E+06,
        0.101721298174118318E+06,       0.101699043646416510E+06,       0.101673714396835901E+06,       0.101645709970302123E+06,       0.101615709217670097E+06,
        0.101584438818864903E+06,       0.101549071157331651E+06,       0.101514367930820241E+06,       0.101481015481659371E+06,       0.101449616141240651E+06,
        0.101420749509000205E+06,       0.101394921878986992E+06,       0.101373676775729036E+06,       0.101359486676981818E+06,       0.101347304837422518E+06,
        0.101336841360518913E+06,       0.101328023341265842E+06,       0.101320386045212057E+06,       0.101313764510643596E+06,       0.101308434768293082E+06,
        0.101303621069785135E+06,       0.101298777855350723E+06,       0.101293531204510582E+06,       0.101287470834921696E+06,       0.101280152845400124E+06,
        0.101270201669037211E+06,       0.101254701725787949E+06,       0.101236553755882080E+06,       0.101215630660361639E+06,       0.101191802985207483E+06,
        0.101164939977834394E+06,       0.101134911067020425E+06,       0.101095221983884170E+06,       0.101047509096163092E+06,       0.100998010357585692E+06,
        0.100947641730482603E+06,       0.100897282218335793E+06,       0.100847785377602457E+06,       0.100799988650482410E+06,       0.100756067172860465E+06,
        0.100716404949108095E+06,       0.100680394601797932E+06,       0.100648426393021538E+06,       0.100745881471474568E+06,       0.100728142553068014E+06,
        0.100709625290291020E+06,       0.100690810595279676E+06,       0.100673015913888710E+06,       0.100654662696282932E+06,       0.100635883098483231E+06,
        0.100616812156066226E+06,       0.100597590570947941E+06,       0.100577923093225269E+06,       0.100558481382763435E+06,       0.100539763749561054E+06,
        0.100521848971490384E+06,       0.100504736841997088E+06,       0.100488356281683067E+06,       0.100472574428834167E+06,       0.100457206575664590E+06,
        0.100442026795809623E+06,       0.100426779086875598E+06,       0.100408173847290411E+06,       0.100384737995668649E+06,       0.100361938241868149E+06,
        0.100339809752568588E+06,       0.100318341944825661E+06,       0.100297490120403570E+06,       0.100277187624826533E+06,       0.100256847285368276E+06,
        0.100235365725066120E+06,       0.100214436988323068E+06,       0.100194015395758135E+06,       0.100174603679756343E+06,       0.100156451770575964E+06,
        0.100139783864459299E+06,       0.100124799136242582E+06,       0.100111674036540222E+06,       0.100100566149749706E+06,       0.100091646133474802E+06,
        0.100094268080595342E+06,       0.100098360646490051E+06,       0.100103245417476035E+06,       0.100108251398645036E+06,       0.100112713737688697E+06,
        0.100115972074298101E+06,       0.100117368468727698E+06,       0.100113713047268437E+06,       0.100102264314479005E+06,       0.100088001440509222E+06,
        0.100071163974188516E+06,       0.100051996036882978E+06,       0.100030726477270320E+06,       0.100007546295320470E+06,       0.999807647979038738E+05,
        0.999391989552558807E+05,       0.998969708781520749E+05,       0.998557810370234511E+05,       0.998173700956349639E+05,       0.997835138413437380E+05,
        0.997560107381300622E+05,       0.997399269866001996E+05,       0.997470920864752261E+05,       0.997634292598558095E+05,       0.997888964555621351E+05,
        0.998253139512354246E+05,       0.998703081483062851E+05,       0.999237330223304161E+05,       0.999900673422841937E+05,       0.100071098592214898E+06,
        0.100157786095159157E+06,       0.100248141148947368E+06,       0.100340095617225234E+06,       0.100431568456538211E+06,       0.100520552982271765E+06,
        0.100601957172444119E+06,       0.100676277857242458E+06,       0.100746000837763233E+06,       0.100808736668317229E+06,       0.100864485886548777E+06,
        0.100912656357667453E+06,       0.100952804425252194E+06,       0.100983458937089512E+06,       0.101002905816960556E+06,       0.101017076739301760E+06,
        0.101025919304932366E+06,       0.101031319629252597E+06,       0.101035629307633033E+06,       0.101040244934609727E+06,       0.101046393155694794E+06,
        0.101055516125687020E+06,       0.101070906234944094E+06,       0.101089614225348079E+06,       0.101111577432790844E+06,       0.101136727145279292E+06,
        0.101164845396941935E+06,       0.101195505773623969E+06,       0.101228307857940395E+06,       0.101262885478130513E+06,       0.101298695011647855E+06,
        0.101336323186784808E+06,       0.101375617863355365E+06,       0.101416132308550543E+06,       0.101458486694783467E+06,       0.101500186893265898E+06,
        0.101539835500673144E+06,       0.101576113752189529E+06,       0.101608148989054069E+06,       0.101635731083729115E+06,       0.101658502412969741E+06,
        0.101672883340000117E+06,       0.101682956248776158E+06,       0.101690136156231834E+06,       0.101694729692935623E+06,       0.101695555850151519E+06,
        0.101694985210699713E+06,       0.101693812129123311E+06,       0.101693039728607808E+06,       0.101693715283905956E+06,       0.101692868849250488E+06,
        0.101690508890417783E+06,       0.101685212790082718E+06,       0.101676311144040446E+06,       0.101666676329463662E+06,       0.101655232931092047E+06,
        0.101641717109236590E+06,       0.101625993005500495E+06,       0.101608164735537764E+06,       0.101588188219044227E+06,       0.101565919017002117E+06,
        0.101541334705616158E+06,       0.101515224870468810E+06,       0.101488328834034881E+06,       0.101461275807381404E+06,       0.101434883687913665E+06,
        0.101409484965064941E+06,       0.101385820779280519E+06,       0.101366650582102375E+06,       0.101354446840173172E+06,       0.101343919272935833E+06,
        0.101334580534699839E+06,       0.101326051033725802E+06,       0.101318025772555571E+06,       0.101310244905231491E+06,       0.101303240884958926E+06,
        0.101296508440228543E+06,       0.101288703571071324E+06,       0.101279586340018883E+06,       0.101269869694777401E+06,       0.101258981910571456E+06,
        0.101246361574452327E+06,       0.101230052909366845E+06,       0.101210205538298207E+06,       0.101187520180750522E+06,       0.101161911206820834E+06,
        0.101133290201435040E+06,       0.101101563145659631E+06,       0.101066628653128937E+06,       0.101019252959455625E+06,       0.100965746706630394E+06,
        0.100910740992734136E+06,       0.100855238817428384E+06,       0.100800186778776610E+06,       0.100746485895287333E+06,       0.100695000750680716E+06,
        0.100647864656014091E+06,       0.100605793755290593E+06,       0.100567897173808713E+06,       0.100534547818198989E+06,       0.100814127595255733E+06,
        0.100792022069682134E+06,       0.100768906676945466E+06,       0.100744859019167008E+06,       0.100719947172904969E+06,       0.100694229203288138E+06,
        0.100667752842392147E+06,       0.100641747076966523E+06,       0.100616187623394333E+06,       0.100590421603492592E+06,       0.100564843816162116E+06,
        0.100539661442132914E+06,       0.100515003622905657E+06,       0.100490925990557327E+06,       0.100467416019604236E+06,       0.100444399107853926E+06,
        0.100421745278230635E+06,       0.100399276378565366E+06,       0.100374479059296529E+06,       0.100342341387721070E+06,       0.100310819294281551E+06,
        0.100280122297496389E+06,       0.100250406051737154E+06,       0.100221779328347242E+06,       0.100194311780137796E+06,       0.100168042299398876E+06,
        0.100142987772136228E+06,       0.100119152028053810E+06,       0.100096071569344102E+06,       0.100074127372371906E+06,       0.100053458844250679E+06,
        0.100034145590099070E+06,       0.100016303683140140E+06,       0.100000086204841966E+06,       0.999856841527353536E+05,       0.999733278135488799E+05,
        0.999663531822283549E+05,       0.999693777575280983E+05,       0.999741959503276157E+05,       0.999802590538802469E+05,       0.999870378916889313E+05,
        0.999938949144795042E+05,       0.100000191518739506E+06,       0.100005286991947069E+06,       0.100006317487418550E+06,       0.100001195017387858E+06,
        0.999937624881289375E+05,       0.999840228227615153E+05,       0.999719630030743720E+05,       0.999577541117163637E+05,       0.999414190489595931E+05,
        0.999227353126357775E+05,       0.998873066933161899E+05,       0.998482442672230973E+05,       0.998092392179712187E+05,       0.997720171343442780E+05,
        0.997383602763239178E+05,       0.997100954593149654E+05,       0.996890738866330212E+05,       0.996865348971301573E+05,       0.996979284283922898E+05,
        0.997178025858917244E+05,       0.997459381653020537E+05,       0.997821174181933602E+05,       0.998261113921440992E+05,       0.998776597193271737E+05,
        0.999420283421857603E+05,       0.100017917957394646E+06,       0.100097878242084247E+06,       0.100179897231054711E+06,       0.100262024118021669E+06,
        0.100342632647495484E+06,       0.100419763744213284E+06,       0.100491241165072570E+06,       0.100554990596539108E+06,       0.100613108372608185E+06,
        0.100664964935558615E+06,       0.100710050488669251E+06,       0.100748062257432917E+06,       0.100778981129089982E+06,       0.100801136588479072E+06,
        0.100816775933362136E+06,       0.100825979191023362E+06,       0.100833035761093313E+06,       0.100839384072879693E+06,       0.100846373089390050E+06,
        0.100857951736503237E+06,       0.100872302980121356E+06,       0.100888680627202251E+06,       0.100907092306334001E+06,       0.100927501559027049E+06,
        0.100950662310288419E+06,       0.100977294658870305E+06,       0.101006277386327682E+06,       0.101036971461367139E+06,       0.101068254496147259E+06,
        0.101099848827670517E+06,       0.101133511540723193E+06,       0.101169399010245761E+06,       0.101207870174907031E+06,       0.101248846664781042E+06,
        0.101290872607848010E+06,       0.101333141189654139E+06,       0.101375246051365641E+06,       0.101416446476650075E+06,       0.101455302158143284E+06,
        0.101490839830927347E+06,       0.101520107656443550E+06,       0.101543517742126453E+06,       0.101563037513223637E+06,       0.101578855351202437E+06,
        0.101589294440855650E+06,       0.101594084692158984E+06,       0.101595811485579121E+06,       0.101594522898840631E+06,       0.101587783852875349E+06,
        0.101580434348492054E+06,       0.101571251185715577E+06,       0.101560523496472335E+06,       0.101548552694418337E+06,       0.101535867827232971E+06,
        0.101525413599061823E+06,       0.101514059084604145E+06,       0.101501599931887249E+06,       0.101487982453526070E+06,       0.101472687979190014E+06,
        0.101455256212675624E+06,       0.101436599458446668E+06,       0.101417421871714148E+06,       0.101397941747779230E+06,       0.101378563636379375E+06,
        0.101359842874464084E+06,       0.101342462840995518E+06,       0.101332246224379633E+06,       0.101325840252083945E+06,       0.101320103689658979E+06,
        0.101314877253089740E+06,       0.101310111834561045E+06,       0.101305378666758857E+06,       0.101300345803243748E+06,       0.101295776170531011E+06,
        0.101292199871251156E+06,       0.101287082936946317E+06,       0.101280060941132921E+06,       0.101270852280511215E+06,       0.101259228389922413E+06,
        0.101244988802512118E+06,       0.101227740446083306E+06,       0.101206586899449845E+06,       0.101182271497207475E+06,       0.101154765725986566E+06,
        0.101124017218970926E+06,       0.101089948851124151E+06,       0.101052459983455323E+06,       0.101011429271982197E+06,       0.100955245737388075E+06,
        0.100896292883737755E+06,       0.100836289133349041E+06,       0.100776402552628671E+06,       0.100717117782225978E+06,       0.100659365283430379E+06,
        0.100604025319315682E+06,       0.100553449734939946E+06,       0.100508407522918642E+06,       0.100467703215460322E+06,       0.100431774319843782E+06,
        0.100887777028820332E+06,       0.100861720047367722E+06,       0.100834436753951144E+06,       0.100806009321876336E+06,       0.100776515387351727E+06,
        0.100746027719175327E+06,       0.100714128174464058E+06,       0.100678835400336873E+06,       0.100643940658424166E+06,       0.100609599439615049E+06,
        0.100575890439937211E+06,       0.100542814645689868E+06,       0.100510647118237335E+06,       0.100478852228419142E+06,       0.100447427441828680E+06,
        0.100416345678542421E+06,       0.100385524391706378E+06,       0.100353710114660586E+06,       0.100313330006065604E+06,       0.100273215809488320E+06,
        0.100233726851702537E+06,       0.100195172710990315E+06,       0.100157816918484707E+06,       0.100121881575408392E+06,       0.100087552777137244E+06,
        0.100054986731522251E+06,       0.100024316458513829E+06,       0.999958188555688102E+05,       0.999694587498323526E+05,       0.999449162204764725E+05,
        0.999222572991156194E+05,       0.999015841003048117E+05,       0.998830358793447813E+05,       0.998667901084829064E+05,       0.998530636160492868E+05,
        0.998421138196279935E+05,       0.998399548826702376E+05,       0.998456341634458367E+05,       0.998536660057044792E+05,       0.998634438903502014E+05,
        0.998743637363783346E+05,       0.998858203733583359E+05,       0.998972031892049272E+05,       0.999078909209750127E+05,       0.999149362451545312E+05,
        0.999155853988857416E+05,       0.999144713123037072E+05,       0.999115094947106991E+05,       0.999066084422268032E+05,       0.998996635379296931E+05,
        0.998905505086211051E+05,       0.998791187039132201E+05,       0.998553009292081260E+05,       0.998211706427201134E+05,       0.997864909210314072E+05,
        0.997528267554746853E+05,       0.997217498141473916E+05,       0.996948180668799905E+05,       0.996735491411857802E+05,       0.996593866015884996E+05,
        0.996655234255323448E+05,       0.996793806269131601E+05,       0.997006480667150026E+05,       0.997291101032920706E+05,       0.997645101820020791E+05,
        0.998065302642879251E+05,       0.998547900089741306E+05,       0.999134103376733110E+05,       0.999816545378570445E+05,       0.100052123784172887E+06,
        0.100122995502983205E+06,       0.100192554793170464E+06,       0.100259253657548237E+06,       0.100321770579711141E+06,       0.100379066111299660E+06,
        0.100430565790236928E+06,       0.100476507405646029E+06,       0.100515199549242738E+06,       0.100547257296906639E+06,       0.100573671260601302E+06,
        0.100594920234367688E+06,       0.100611741953639648E+06,       0.100625093360959523E+06,       0.100636085854106641E+06,       0.100648539226327353E+06,
        0.100663110344216606E+06,       0.100678485576473686E+06,       0.100694991774415132E+06,       0.100712835683178113E+06,       0.100732147548005290E+06,
        0.100753127553809449E+06,       0.100775525773403977E+06,       0.100799178062266757E+06,       0.100823896465442915E+06,       0.100848973735924432E+06,
        0.100871627589741343E+06,       0.100896325593451635E+06,       0.100923508440905760E+06,       0.100953444968081341E+06,       0.100987803936626107E+06,
        0.101025452874861629E+06,       0.101064958354120550E+06,       0.101105934719207362E+06,       0.101149656229281260E+06,       0.101195955740066449E+06,
        0.101241312234646321E+06,       0.101284295970940017E+06,       0.101322838039260794E+06,       0.101354503959834561E+06,       0.101381602347716602E+06,
        0.101404011754918669E+06,       0.101421551762267889E+06,       0.101430360992792368E+06,       0.101432922117767157E+06,       0.101431497700586173E+06,
        0.101426925441668209E+06,       0.101419967655507149E+06,       0.101411983040633873E+06,       0.101402716970667971E+06,       0.101392421375849139E+06,
        0.101381472260780953E+06,       0.101370274940234522E+06,       0.101359740662010270E+06,       0.101350634658367329E+06,       0.101341143517682387E+06,
        0.101330923240958698E+06,       0.101319823874219393E+06,       0.101307931163203728E+06,       0.101295590108053555E+06,       0.101283554840952769E+06,
        0.101272503805782646E+06,       0.101264230996134676E+06,       0.101263165987784392E+06,       0.101263248071743699E+06,       0.101263968423840182E+06,
        0.101264949849351571E+06,       0.101265950281725454E+06,       0.101266859267559164E+06,       0.101267688820318188E+06,       0.101269586773692979E+06,
        0.101271200254654817E+06,       0.101270843870590616E+06,       0.101268468005190778E+06,       0.101263583383249803E+06,       0.101255809203046563E+06,
        0.101244849341628564E+06,       0.101230469880693592E+06,       0.101211897835992699E+06,       0.101189677118595791E+06,       0.101163874725058151E+06,
        0.101134452948665217E+06,       0.101101374466219480E+06,       0.101064596222306151E+06,       0.101024065194136114E+06,       0.100976094439065258E+06,
        0.100916143828112647E+06,       0.100853769181501484E+06,       0.100790071236260570E+06,       0.100726087398982490E+06,       0.100662794662010128E+06,
        0.100601113224382003E+06,       0.100541910367744073E+06,       0.100487274737311833E+06,       0.100437683864829785E+06,       0.100392394095480457E+06,
        0.100351867577605750E+06,       0.100962168045125494E+06,       0.100932365352918903E+06,       0.100901110935450168E+06,       0.100868480358099798E+06,
        0.100834547574790442E+06,       0.100796703363587934E+06,       0.100755267960995203E+06,       0.100713570472402876E+06,       0.100671854726096004E+06,
        0.100630308500112806E+06,       0.100589060133053688E+06,       0.100548176434007823E+06,       0.100507661857319457E+06,       0.100467458892467330E+06,
        0.100427449603971385E+06,       0.100387458241177985E+06,       0.100347067293918182E+06,       0.100298654635154177E+06,       0.100250789888946878E+06,
        0.100203094461237808E+06,       0.100156000274838036E+06,       0.100109901773151054E+06,       0.100065158238268661E+06,       0.100022096993949221E+06,
        0.999810174333996401E+05,       0.999421958115488960E+05,       0.999058907435752189E+05,       0.998749313841952826E+05,       0.998464722705311870E+05,
        0.998203417981312523E+05,       0.997966268545406929E+05,       0.997754458911707188E+05,       0.997569500594004494E+05,       0.997413241542494943E+05,
        0.997287873670089612E+05,       0.997195938347852207E+05,       0.997219848697613779E+05,       0.997302647271703609E+05,       0.997413201843605202E+05,
        0.997545532545877795E+05,       0.997693575270145375E+05,       0.997851155398511037E+05,       0.998011953959217790E+05,       0.998169466903843859E+05,
        0.998299082101016102E+05,       0.998356142670790869E+05,       0.998398422284621047E+05,       0.998424522644160897E+05,       0.998432923817324918E+05,
        0.998421955048720556E+05,       0.998389770375031076E+05,       0.998334333807975636E+05,       0.998233671652358898E+05,       0.997961670290865004E+05,
        0.997678973047597101E+05,       0.997399010170866677E+05,       0.997134966342892585E+05,       0.996899556689095043E+05,       0.996704759993049811E+05,
        0.996561506699569145E+05,       0.996500136858785991E+05,       0.996586427100675064E+05,       0.996741311696416087E+05,       0.996962994894855947E+05,
        0.997249142503650510E+05,       0.997596639024193428E+05,       0.998001312580039958E+05,       0.998457643772705051E+05,       0.998968741052847909E+05,
        0.999554058789066621E+05,       0.100014421175045645E+06,       0.100072433938662172E+06,       0.100128122411163247E+06,       0.100180369857232887E+06,
        0.100226565707743983E+06,       0.100267364450542242E+06,       0.100303437234851634E+06,       0.100335667091963755E+06,       0.100364067822408935E+06,
        0.100388352892750874E+06,       0.100408979571248361E+06,       0.100426614584295938E+06,       0.100443740449263758E+06,       0.100461134998395326E+06,
        0.100478174321635088E+06,       0.100495256991003844E+06,       0.100512619944850769E+06,       0.100530318011748270E+06,       0.100548816195507636E+06,
        0.100568537852548383E+06,       0.100588688433695279E+06,       0.100609168368209503E+06,       0.100629814904332350E+06,       0.100650416237038749E+06,
        0.100665634418575515E+06,       0.100681296503981284E+06,       0.100698501345687095E+06,       0.100717920340627403E+06,       0.100740215249176472E+06,
        0.100766890514599916E+06,       0.100796657224606606E+06,       0.100829306693609207E+06,       0.100864641226465828E+06,       0.100904494038338991E+06,
        0.100948883593760926E+06,       0.100993670283464584E+06,       0.101037518284592399E+06,       0.101079215492193092E+06,       0.101115268009655614E+06,
        0.101146790223207165E+06,       0.101174201341284715E+06,       0.101197180680782549E+06,       0.101215405063571248E+06,       0.101223672236876388E+06,
        0.101227039458753206E+06,       0.101226892310118274E+06,       0.101223972224575875E+06,       0.101218953111666357E+06,       0.101212937481870860E+06,
        0.101205841402347578E+06,       0.101198438153766576E+06,       0.101191337677150907E+06,       0.101184775501605473E+06,       0.101178859738651910E+06,
        0.101173861836438504E+06,       0.101169688625135837E+06,       0.101165295165053874E+06,       0.101160720689472480E+06,       0.101156205118519152E+06,
        0.101153904081471745E+06,       0.101157778313312563E+06,       0.101162376363148098E+06,       0.101167695990116554E+06,       0.101174407609201837E+06,
        0.101181289698729292E+06,       0.101187910343826748E+06,       0.101193938755009076E+06,       0.101199145593254492E+06,       0.101206932922006279E+06,
        0.101215167455344184E+06,       0.101221538641997948E+06,       0.101225600948191553E+06,       0.101227025345643400E+06,       0.101225591909201801E+06,
        0.101221179118605258E+06,       0.101213750568578733E+06,       0.101199646966405868E+06,       0.101180697627794187E+06,       0.101158105995225807E+06,
        0.101131732247750042E+06,       0.101101468150223940E+06,       0.101067227518597691E+06,       0.101028937999906033E+06,       0.100986534229694924E+06,
        0.100931637537634888E+06,       0.100870116212888723E+06,       0.100806172230221506E+06,       0.100740814221331588E+06,       0.100675010844437245E+06,
        0.100609686876287946E+06,       0.100545721239012084E+06,       0.100483946382944894E+06,       0.100426130298766730E+06,       0.100372432821891009E+06,
        0.100322757504134090E+06,       0.100277638455664739E+06,       0.101031760825673671E+06,       0.100998271623218010E+06,       0.100963081981794705E+06,
        0.100926251398063658E+06,       0.100882116391194853E+06,       0.100836110949086375E+06,       0.100789196010976768E+06,       0.100741656022242169E+06,
        0.100693739602509639E+06,       0.100645654807320738E+06,       0.100597565425804190E+06,       0.100549588305930272E+06,       0.100501791687992096E+06,
        0.100454194516198477E+06,       0.100406766687836353E+06,       0.100359430189551465E+06,       0.100303106797204193E+06,       0.100246577208372706E+06,
        0.100190531822652643E+06,       0.100135266216653603E+06,       0.100081062875707968E+06,       0.100028192493603376E+06,       0.999769161960119818E+05,
        0.999274886616365693E+05,       0.998801621121565840E+05,       0.998351911400472018E+05,       0.997962094163349393E+05,       0.997640534483473457E+05,
        0.997345240177219384E+05,       0.997076990988948673E+05,       0.996836794307263772E+05,       0.996625896600271371E+05,       0.996445791479565378E+05,
        0.996298224252568762E+05,       0.996185192726470996E+05,       0.996108943913202529E+05,       0.996171044733596500E+05,       0.996274341933858086E+05,
        0.996407368485686020E+05,       0.996564433077199938E+05,       0.996739662819337100E+05,       0.996926995456860750E+05,       0.997120167510192841E+05,
        0.997312700110226870E+05,       0.997492720049924683E+05,       0.997589945357419347E+05,       0.997672950870170171E+05,       0.997740082631510304E+05,
        0.997789569418504107E+05,       0.997819534179343900E+05,       0.997828018434580008E+05,       0.997813025467889238E+05,       0.997761547542830958E+05,
        0.997606903751367063E+05,       0.997380039112137747E+05,       0.997148807783809316E+05,       0.996925793721139198E+05,       0.996723316187614837E+05,
        0.996553186696160265E+05,       0.996426434711866459E+05,       0.996353006212308683E+05,       0.996360089851673401E+05,       0.996493081867637520E+05,
        0.996683800195190997E+05,       0.996929780547397386E+05,       0.997227658669395460E+05,       0.997573001543519495E+05,       0.997960150791931374E+05,
        0.998382096557535260E+05,       0.998830404070649238E+05,       0.999298323121304275E+05,       0.999742523604048474E+05,       0.100016965326181715E+06,
        0.100057253131543956E+06,       0.100094584675305145E+06,       0.100128612542877818E+06,       0.100159162106115866E+06,       0.100186212494174571E+06,
        0.100209869217876141E+06,       0.100230664541801205E+06,       0.100252215827535721E+06,       0.100272507526162837E+06,       0.100291578842935764E+06,
        0.100309849731348106E+06,       0.100327689967233746E+06,       0.100345394170965068E+06,       0.100363163535270942E+06,       0.100381092592034052E+06,
        0.100399259031973241E+06,       0.100417513798931104E+06,       0.100435580822035801E+06,       0.100453091252954211E+06,       0.100469603339999827E+06,
        0.100480151507121773E+06,       0.100489254638568047E+06,       0.100498595808049067E+06,       0.100508951548301586E+06,       0.100521040443233302E+06,
        0.100536087694824993E+06,       0.100554481106296153E+06,       0.100575842199618433E+06,       0.100600284600435130E+06,       0.100627894363922838E+06,
        0.100660998742818352E+06,       0.100699900685942383E+06,       0.100740240979155365E+06,       0.100780773089326132E+06,       0.100820325888548046E+06,
        0.100857002425394050E+06,       0.100889306549680012E+06,       0.100918410465244044E+06,       0.100943855527829830E+06,       0.100965216993375041E+06,
        0.100982104369596826E+06,       0.100988787448417890E+06,       0.100992039290643908E+06,       0.100992851817592629E+06,       0.100992148367721486E+06,
        0.100990754377491627E+06,       0.100989328864528783E+06,       0.100987939282731590E+06,       0.100987019598780156E+06,       0.100986810224360001E+06,
        0.100987461015865600E+06,       0.100989052975663959E+06,       0.100991630597561802E+06,       0.100995163025901697E+06,       0.101001875722349461E+06,
        0.101011088720900429E+06,       0.101021084899088091E+06,       0.101031663037972830E+06,       0.101042638294081626E+06,       0.101053858103835970E+06,
        0.101065218626100279E+06,       0.101076680586933391E+06,       0.101088283485301858E+06,       0.101099874970037970E+06,       0.101113089326713816E+06,
        0.101125428039884195E+06,       0.101136196176455385E+06,       0.101144782354753406E+06,       0.101150661981462021E+06,       0.101153397040916956E+06,
        0.101152632849470392E+06,       0.101148092219151222E+06,       0.101138825885236918E+06,       0.101125297346996245E+06,       0.101107998631323659E+06,
        0.101086896343469081E+06,       0.101061954484055474E+06,       0.101033133620494526E+06,       0.101000389988487950E+06,       0.100963674428856495E+06,
        0.100920035249967157E+06,       0.100864002050084426E+06,       0.100802954127500183E+06,       0.100739491656333426E+06,       0.100674607806506479E+06,
        0.100609142818467881E+06,       0.100543918229119721E+06,       0.100479729438758746E+06,       0.100417340423775575E+06,       0.100357818911458060E+06,
        0.100301549120910859E+06,       0.100249027161521051E+06,       0.100200821670612902E+06,       0.101087517829558172E+06,       0.101052015003826687E+06,
        0.101011788745108162E+06,       0.100964536778963855E+06,       0.100915488137692053E+06,       0.100864943012846241E+06,       0.100813190048196135E+06,
        0.100760500256302723E+06,       0.100707121731364154E+06,       0.100653275174801398E+06,       0.100599150242222226E+06,       0.100544902712618306E+06,
        0.100490652473024573E+06,       0.100436482304513964E+06,       0.100382437448442113E+06,       0.100320280351299210E+06,       0.100257427382579408E+06,
        0.100194846079550756E+06,       0.100132891655021755E+06,       0.100071918796184837E+06,       0.100012281557507449E+06,       0.999543340473443968E+05,
        0.998984318951125897E+05,       0.998449344820776314E+05,       0.997942079153267550E+05,       0.997466460297804297E+05,       0.997094928681285237E+05,
        0.996756279012622545E+05,       0.996450218538222252E+05,       0.996176735384205385E+05,       0.995936103776563396E+05,       0.995728884174646664E+05,
        0.995555917894421727E+05,       0.995418315732738702E+05,       0.995317440033937164E+05,       0.995262628136555868E+05,       0.995329410864949314E+05,
        0.995433141117427585E+05,       0.995568197318211314E+05,       0.995728823939344729E+05,       0.995909116272487881E+05,       0.996102999545491039E+05,
        0.996304204174830811E+05,       0.996506239397997124E+05,       0.996702368021630245E+05,       0.996815718025470851E+05,       0.996899469928969920E+05,
        0.996967323341972806E+05,       0.997018093255459680E+05,       0.997050766826754843E+05,       0.997064543685055542E+05,       0.997058891541211779E+05,
        0.997033620388164272E+05,       0.996988978495463380E+05,       0.996831868676393642E+05,       0.996664226445127570E+05,       0.996504367351514375E+05,
        0.996361908772876632E+05,       0.996245860820844246E+05,       0.996164411729444837E+05,       0.996124708057612588E+05,       0.996132638091558620E+05,
        0.996196649575229239E+05,       0.996367110923675500E+05,       0.996583825556631200E+05,       0.996843326520396949E+05,       0.997128691088688356E+05,
        0.997429147876210773E+05,       0.997758051592909760E+05,       0.998110107603276119E+05,       0.998478942000829556E+05,       0.998857114279977977E+05,
        0.999214491155317955E+05,       0.999550948845939129E+05,       0.999866837454055931E+05,       0.100015951080814193E+06,       0.100042763152220112E+06,
        0.100066833155271277E+06,       0.100088158247781059E+06,       0.100108078185884762E+06,       0.100126927297932227E+06,       0.100144951073682430E+06,
        0.100162306504082269E+06,       0.100179972902585811E+06,       0.100197255514410528E+06,       0.100214513504718459E+06,       0.100231716678680328E+06,
        0.100248516891677820E+06,       0.100264879167597144E+06,       0.100280677931150029E+06,       0.100295703143529230E+06,       0.100309668678237373E+06,
        0.100317822458752169E+06,       0.100323698725186405E+06,       0.100328766123466703E+06,       0.100333617686529382E+06,       0.100338870421945830E+06,
        0.100345146510504768E+06,       0.100353505811859010E+06,       0.100364091412822730E+06,       0.100377219192028511E+06,       0.100393145224109379E+06,
        0.100412076822805961E+06,       0.100436536362016341E+06,       0.100466993027333549E+06,       0.100499128955239808E+06,       0.100531867585847620E+06,
        0.100564210070354224E+06,       0.100595268938737849E+06,       0.100623389505981249E+06,       0.100648875381678285E+06,       0.100671545265182722E+06,
        0.100691215991390258E+06,       0.100707855569253967E+06,       0.100721531568851729E+06,       0.100729765774870320E+06,       0.100736382308921660E+06,
        0.100742049357786149E+06,       0.100747338931632839E+06,       0.100752699996680560E+06,       0.100758437644766876E+06,       0.100764492369211905E+06,
        0.100771174162651805E+06,       0.100778897781122723E+06,       0.100791202238176033E+06,       0.100805304746492911E+06,       0.100820453141876555E+06,
        0.100836553977341420E+06,       0.100853433691068960E+06,       0.100869804352758074E+06,       0.100885565873248357E+06,       0.100901263434718436E+06,
        0.100916755649211860E+06,       0.100931925490762223E+06,       0.100946862129343805E+06,       0.100964994999554750E+06,       0.100982379998277524E+06,
        0.100998599729598267E+06,       0.101013259118967748E+06,       0.101025997621651855E+06,       0.101036183051793079E+06,       0.101042991775159331E+06,
        0.101046219174794693E+06,       0.101045436783694371E+06,       0.101037979396283830E+06,       0.101026389136987622E+06,       0.101011353849770458E+06,
        0.100992765156084381E+06,       0.100970520839387638E+06,       0.100944522980413691E+06,       0.100914676733503889E+06,       0.100880889510173438E+06,
        0.100843070409204898E+06,       0.100794195318855112E+06,       0.100740849916230014E+06,       0.100684368608276331E+06,       0.100625515617689191E+06,
        0.100565057571482292E+06,       0.100503753672499588E+06,       0.100442348146381337E+06,       0.100381564680888332E+06,       0.100322120082476831E+06,
        0.100265427081164002E+06,       0.100211108587006820E+06,       0.100159852906932778E+06,       0.100112309293580329E+06,       0.101124201328911135E+06,
        0.101079108320663814E+06,       0.101031809144729792E+06,       0.100982479818601947E+06,       0.100931296727433786E+06,       0.100878431465452362E+06,
        0.100824045759680885E+06,       0.100768286540631874E+06,       0.100710530566360118E+06,       0.100651851143405918E+06,       0.100592641779612633E+06,
        0.100533088300546049E+06,       0.100473351995987294E+06,       0.100413568226339557E+06,       0.100347374189164038E+06,       0.100280419558277266E+06,
        0.100213466642138825E+06,       0.100146884874704396E+06,       0.100081054126754942E+06,       0.100016363564741026E+06,       0.999532111494706915E+05,
        0.998920037667682045E+05,       0.998331579776468134E+05,       0.997771013708717801E+05,       0.997242744959584961E+05,       0.996794911425569007E+05,
        0.996421673866169731E+05,       0.996083624063458992E+05,       0.995780558571076108E+05,       0.995512438908386830E+05,       0.995279390599935141E+05,
        0.995081697090995876E+05,       0.994919788171798573E+05,       0.994794222509916144E+05,       0.994705663858296175E+05,       0.994666304399983201E+05,
        0.994716729317709396E+05,       0.994803098980725772E+05,       0.994920284915772354E+05,       0.995062941002977459E+05,       0.995225510997954116E+05,
        0.995402235083560226E+05,       0.995587157137078175E+05,       0.995774134724761680E+05,       0.995956854178548674E+05,       0.996082099438724399E+05,
        0.996146714115503564E+05,       0.996198917096476653E+05,       0.996237772972328385E+05,       0.996262556600006501E+05,       0.996272811679797160E+05,
        0.996268420791924145E+05,       0.996249688472863927E+05,       0.996217438673883153E+05,       0.996165665480622556E+05,       0.996053672464558331E+05,
        0.995949919441781822E+05,       0.995861528017038072E+05,       0.995795026742108748E+05,       0.995756196555683418E+05,       0.995749923295157205E+05,
        0.995764918417123117E+05,       0.995811371618628909E+05,       0.995900021812679042E+05,       0.996053443416097725E+05,       0.996253126869847765E+05,
        0.996485392863536254E+05,       0.996747275639752770E+05,       0.997034975235640304E+05,       0.997343816924544808E+05,       0.997668244608898967E+05,
        0.998001857951137499E+05,       0.998337502953590738E+05,       0.998667425003782409E+05,       0.998964382191309269E+05,       0.999219732315580331E+05,
        0.999453769704884326E+05,       0.999669632680838986E+05,       0.999870458961453260E+05,       0.100005916456012012E+06,       0.100023824889774987E+06,
        0.100040963571971195E+06,       0.100057455775243085E+06,       0.100073413986486979E+06,       0.100089335775104671E+06,       0.100104815244426631E+06,
        0.100119703191363587E+06,       0.100134379227022902E+06,       0.100148369375800728E+06,       0.100161370783191393E+06,       0.100173213642796953E+06,
        0.100180378799944810E+06,       0.100185526497069281E+06,       0.100189324284954535E+06,       0.100192153267272603E+06,       0.100194434190503976E+06,
        0.100196610662858875E+06,       0.100198905421094794E+06,       0.100201850991823914E+06,       0.100206163107215340E+06,       0.100212230663632377E+06,
        0.100220378132198122E+06,       0.100230869811071767E+06,       0.100245444302250398E+06,       0.100264473811748554E+06,       0.100285188354245533E+06,
        0.100306907645131752E+06,       0.100328990026887506E+06,       0.100350863943610893E+06,       0.100371839758985952E+06,       0.100391444833452260E+06,
        0.100409831169643890E+06,       0.100426823791286341E+06,       0.100442350551841242E+06,       0.100456434485740057E+06,       0.100469179887128601E+06,
        0.100480095078871280E+06,       0.100490844862516460E+06,       0.100501773469729742E+06,       0.100513473090107072E+06,       0.100529036405637875E+06,
        0.100544944618372494E+06,       0.100561407314039185E+06,       0.100578441255079553E+06,       0.100596158161423402E+06,       0.100614688506316757E+06,
        0.100634037456854698E+06,       0.100654132781311564E+06,       0.100674831301503669E+06,       0.100695930204477670E+06,       0.100717182634869590E+06,
        0.100738316734543623E+06,       0.100757949561458212E+06,       0.100778269263575014E+06,       0.100798138776316147E+06,       0.100817212656416305E+06,
        0.100835135245772617E+06,       0.100851545416907000E+06,       0.100866083297882986E+06,       0.100878398135237148E+06,       0.100888156496614407E+06,
        0.100895050095971907E+06,       0.100897946875170004E+06,       0.100893038607802475E+06,       0.100884438418173842E+06,       0.100872056807847897E+06,
        0.100855733686039923E+06,       0.100836196267254127E+06,       0.100813309503127763E+06,       0.100786948600525633E+06,       0.100756997497101227E+06,
        0.100723347939641535E+06,       0.100681497385685245E+06,       0.100634489632593322E+06,       0.100584469640955329E+06,       0.100531975070484972E+06,
        0.100477580490852386E+06,       0.100421885399875624E+06,       0.100365503956835804E+06,       0.100309056337240749E+06,       0.100253161585176160E+06,
        0.100199112753698049E+06,       0.100147837599931416E+06,       0.100098570404209735E+06,       0.100051904767761502E+06,       0.100008417383464068E+06,
        0.101133829804470908E+06,       0.101086063734912168E+06,       0.101036163378778583E+06,       0.100984272823056410E+06,       0.100930541473297533E+06,
        0.100875120408097937E+06,       0.100818158832696005E+06,       0.100759800682388610E+06,       0.100700181428799915E+06,       0.100639425144117529E+06,
        0.100577641880169904E+06,       0.100514925420599073E+06,       0.100451351465310479E+06,       0.100382775391041228E+06,       0.100313407558045423E+06,
        0.100244124043691409E+06,       0.100175160300200252E+06,       0.100106643005048623E+06,       0.100038955227867787E+06,       0.999724957502307661E+05,
        0.999076781431158888E+05,       0.998449303055831406E+05,       0.997846944474534976E+05,       0.997274274929867825E+05,       0.996741803525597352E+05,
        0.996341923290063423E+05,       0.995977652427823923E+05,       0.995648719529626542E+05,       0.995354913787664409E+05,       0.995096084222995123E+05,
        0.994872134460891248E+05,       0.994683012796486000E+05,       0.994528697284307418E+05,       0.994409175579627627E+05,       0.994324419258456037E+05,
        0.994284685420939932E+05,       0.994314645232595940E+05,       0.994376508028579119E+05,       0.994465880324430618E+05,       0.994578122019961011E+05,
        0.994708370980191394E+05,       0.994851569440643361E+05,       0.995002493657292362E+05,       0.995155788435459253E+05,       0.995306008387735346E+05,
        0.995442855494334071E+05,       0.995482724169068970E+05,       0.995511559961705934E+05,       0.995528872179506288E+05,       0.995534386606523331E+05,
        0.995528106454166118E+05,       0.995510380683528929E+05,       0.995481980155677447E+05,       0.995444181794313772E+05,       0.995389426918443642E+05,
        0.995326299748121528E+05,       0.995248068651720969E+05,       0.995181203502452699E+05,       0.995131485287031392E+05,       0.995104093839186244E+05,
        0.995103487778951967E+05,       0.995133292577804386E+05,       0.995196200330811116E+05,       0.995293885226779821E+05,       0.995426939068978973E+05,
        0.995594831481808505E+05,       0.995804466354603064E+05,       0.996042013257502404E+05,       0.996303970501146687E+05,       0.996586123005633417E+05,
        0.996883528051014437E+05,       0.997188265847352159E+05,       0.997490367113701504E+05,       0.997788526495865081E+05,       0.998078707819837873E+05,
        0.998356993938613014E+05,       0.998619800562695164E+05,       0.998837326032437413E+05,       0.999030588156207523E+05,       0.999213959026974480E+05,
        0.999389528776631778E+05,       0.999559737390779337E+05,       0.999728528505193826E+05,       0.999889548460716323E+05,       0.100004292017804837E+06,
        0.100018822423468373E+06,       0.100032457501698547E+06,       0.100045070251751036E+06,       0.100056503593779649E+06,       0.100066444229329674E+06,
        0.100073267298309525E+06,       0.100078208907556284E+06,       0.100081428306994378E+06,       0.100083145646425299E+06,       0.100084490398295631E+06,
        0.100085214798590619E+06,       0.100085235536889129E+06,       0.100083644141418641E+06,       0.100082296767241191E+06,       0.100081573165770096E+06,
        0.100081814208376789E+06,       0.100083316094140551E+06,       0.100086326553815597E+06,       0.100092077248113128E+06,       0.100100913993150592E+06,
        0.100111107468981296E+06,       0.100122323217253404E+06,       0.100134231875447673E+06,       0.100146529461883110E+06,       0.100158953738958458E+06,
        0.100172103739167927E+06,       0.100185442550333013E+06,       0.100198870033114930E+06,       0.100214743046030431E+06,       0.100230501702414200E+06,
        0.100246186063517438E+06,       0.100261900880765723E+06,       0.100278280962620207E+06,       0.100294975745097370E+06,       0.100311878419328103E+06,
        0.100329065054564679E+06,       0.100346610730169734E+06,       0.100364576981339662E+06,       0.100382997190169379E+06,       0.100401860048637522E+06,
        0.100421460558640218E+06,       0.100441987614432976E+06,       0.100463274519939529E+06,       0.100485156332498926E+06,       0.100507667562079601E+06,
        0.100531755712309474E+06,       0.100555537683995659E+06,       0.100578784151641899E+06,       0.100601239956125326E+06,       0.100622628756313949E+06,
        0.100641873088256354E+06,       0.100658680264014634E+06,       0.100673598187900920E+06,       0.100686312726101605E+06,       0.100696503456104270E+06,
        0.100703849613094353E+06,       0.100704152415214849E+06,       0.100700762505721214E+06,       0.100694332357036590E+06,       0.100684801738842943E+06,
        0.100672137064367969E+06,       0.100656329651135165E+06,       0.100637393206196401E+06,       0.100615360755861184E+06,       0.100590281222544916E+06,
        0.100562215831141861E+06,       0.100526781016220033E+06,       0.100486348156266336E+06,       0.100442798181998849E+06,       0.100397163429546563E+06,
        0.100349807344903311E+06,       0.100301139976506107E+06,       0.100251607747954069E+06,       0.100201684250218939E+06,       0.100151862062679153E+06,
        0.100102645581508201E+06,       0.100056044918004729E+06,       0.100011301942910883E+06,       0.999684520456376777E+05,       0.999279531311431929E+05,
        0.998902646792392770E+05,       0.101126663346454399E+06,       0.101077325354608969E+06,       0.101025975734916894E+06,       0.100972737972671399E+06,
        0.100917744423974829E+06,       0.100861133803490855E+06,       0.100803048766821448E+06,       0.100743633625432005E+06,       0.100683032233185906E+06,
        0.100621386084403202E+06,       0.100558832663878042E+06,       0.100495211427552291E+06,       0.100428081646754872E+06,       0.100360053702616802E+06,
        0.100291421804985934E+06,       0.100222501857581025E+06,       0.100153629396011398E+06,       0.100085157752426705E+06,       0.100017456492403435E+06,
        0.999509101650603116E+05,       0.998859174013813172E+05,       0.998228903882164013E+05,       0.997622547363343474E+05,       0.997044497501409787E+05,
        0.996565808532324445E+05,       0.996171954030033376E+05,       0.995813735590216529E+05,       0.995490780595074320E+05,       0.995202664706442010E+05,
        0.994948916653312772E+05,       0.994731497863732366E+05,       0.994547373765991215E+05,       0.994395024448596523E+05,       0.994273918334258487E+05,
        0.994183417080185318E+05,       0.994131115873192466E+05,       0.994138210062121798E+05,       0.994170868554473127E+05,       0.994225572846895811E+05,
        0.994298923767942179E+05,       0.994385978253560606E+05,       0.994482495116238133E+05,       0.994584440096453618E+05,       0.994687785322086420E+05,
        0.994788546658055129E+05,       0.994882828035313869E+05,       0.994927040708071727E+05,       0.994917547439376503E+05,       0.994895539007886109E+05,
        0.994862075166797877E+05,       0.994818501581585733E+05,       0.994766470759525691E+05,       0.994707963627129502E+05,       0.994645310337857954E+05,
        0.994581208250226337E+05,       0.994518734280974313E+05,       0.994461348017268174E+05,       0.994415182672292285E+05,       0.994388346879257297E+05,
        0.994384357346413162E+05,       0.994406125032009149E+05,       0.994455917032776051E+05,       0.994535286747415666E+05,       0.994645016916688619E+05,
        0.994785078337676387E+05,       0.994954607091662765E+05,       0.995151903074341826E+05,       0.995379744989390892E+05,       0.995645762978403654E+05,
        0.995919660907828365E+05,       0.996199268533732247E+05,       0.996482101418556267E+05,       0.996765332991438627E+05,       0.997045938426658686E+05,
        0.997320840835444978E+05,       0.997587053657859215E+05,       0.997841813092843222E+05,       0.998082694645679585E+05,       0.998307708426059398E+05,
        0.998521847777656949E+05,       0.998731316336951131E+05,       0.998915223579208832E+05,       0.999088069900928822E+05,       0.999250655468217301E+05,
        0.999403321942196199E+05,       0.999545992766920099E+05,       0.999678219791941956E+05,       0.999799234377201792E+05,       0.999908557408674824E+05,
        0.100000288315772239E+06,       0.100007974659642932E+06,       0.100013912274213857E+06,       0.100018152445268570E+06,       0.100020792433534516E+06,
        0.100021965384116600E+06,       0.100021828600707202E+06,       0.100018978825766098E+06,       0.100014638020503815E+06,       0.100010038309740252E+06,
        0.100005576575099418E+06,       0.100001604858675491E+06,       0.999984320892866672E+05,       0.999963266886948113E+05,       0.999958737477183749E+05,
        0.999972975927051302E+05,       0.100000048030566773E+06,       0.100004042344745598E+06,       0.100009194673973179E+06,       0.100015426118827090E+06,
        0.100022673026545686E+06,       0.100031009563329135E+06,       0.100040766570146734E+06,       0.100051217540583049E+06,       0.100062248668533124E+06,
        0.100073786795171531E+06,       0.100085797503990121E+06,       0.100098280610450573E+06,       0.100111262656178049E+06,       0.100125001802413579E+06,
        0.100139645695878644E+06,       0.100154900063508263E+06,       0.100170710309353148E+06,       0.100187004814548171E+06,       0.100203682971120987E+06,
        0.100220602392753455E+06,       0.100237565502663623E+06,       0.100256278549938754E+06,       0.100276900404893633E+06,       0.100298794291387065E+06,
        0.100320557514765664E+06,       0.100342058165774986E+06,       0.100363130678741916E+06,       0.100383577435456726E+06,       0.100403171366828377E+06,
        0.100421659429775435E+06,       0.100438766794516225E+06,       0.100454201546808938E+06,       0.100467659691497232E+06,       0.100478830237807808E+06,
        0.100481024801078907E+06,       0.100479810484167552E+06,       0.100476403382797740E+06,       0.100470673041393165E+06,       0.100462504496619513E+06,
        0.100451800234604845E+06,       0.100438481209722173E+06,       0.100422487058078696E+06,       0.100403775642287073E+06,       0.100382322062990715E+06,
        0.100358117267813446E+06,       0.100327534199358997E+06,       0.100293850879764213E+06,       0.100257806725219358E+06,       0.100219741686727677E+06,
        0.100180023194298759E+06,       0.100139040711945461E+06,       0.100097200477411025E+06,       0.100054920551059535E+06,       0.100012626265403043E+06,
        0.999707461374165723E+05,       0.999303503014407033E+05,       0.998922229704366764E+05,       0.998554721656402544E+05,       0.998204850080980395E+05,
        0.997876409225251264E+05,       0.997573084048583696E+05,       0.101103863341862932E+06,       0.101054198041262367E+06,       0.101002678396138304E+06,
        0.100949414469850730E+06,       0.100894527371675096E+06,       0.100838147558637153E+06,       0.100780413214267071E+06,       0.100721468731159111E+06,
        0.100661463324523051E+06,       0.100600549803942500E+06,       0.100538495641508489E+06,       0.100474499779926511E+06,       0.100409614880186520E+06,
        0.100344074690081019E+06,       0.100278137807477731E+06,       0.100212086086552372E+06,       0.100146223109295490E+06,       0.100080872747272268E+06,
        0.100016377835126099E+06,       0.999530989729176799E+05,       0.998914134690468200E+05,       0.998317144291724107E+05,       0.997744099892116501E+05,
        0.997208338934957865E+05,       0.996799309689324291E+05,       0.996422327801534993E+05,       0.996077247089604498E+05,       0.995763830833266111E+05,
        0.995481752007196337E+05,       0.995230592311468208E+05,       0.995009839760444302E+05,       0.994818884619951277E+05,       0.994657013515687577E+05,
        0.994523401572802686E+05,       0.994417102486785589E+05,       0.994338127166474005E+05,       0.994291184813256987E+05,       0.994266081659517949E+05,
        0.994259833524572168E+05,       0.994269351914163999E+05,       0.994291475057475909E+05,       0.994323001129119220E+05,       0.994360724062380032E+05,
        0.994401472289394151E+05,       0.994442150616938598E+05,       0.994479785254193557E+05,       0.994511571742526139E+05,       0.994472284598653205E+05,
        0.994408965796853736E+05,       0.994339336034472362E+05,       0.994264710020695638E+05,       0.994186660048548511E+05,       0.994107025256855122E+05,
        0.994027916086733312E+05,       0.993951711926945572E+05,       0.993881049497915083E+05,       0.993818799057818542E+05,       0.993768025040628709E+05,
        0.993745371453054540E+05,       0.993758273945832625E+05,       0.993797480709728989E+05,       0.993864179439653672E+05,       0.993959015946626314E+05,
        0.994106666848780587E+05,       0.994280957797027659E+05,       0.994479062249146809E+05,       0.994699024606817256E+05,       0.994938326370272989E+05,
        0.995193970618178137E+05,       0.995462575961586117E+05,       0.995732238058578514E+05,       0.995996836683722795E+05,       0.996264076540508540E+05,
        0.996531520384603791E+05,       0.996796729134591151E+05,       0.997057352581914602E+05,       0.997311214531925361E+05,       0.997565307292698708E+05,
        0.997809628500159452E+05,       0.998041926037547237E+05,       0.998260922842872533E+05,       0.998465616497438023E+05,       0.998655323213428928E+05,
        0.998829702013785281E+05,       0.998988759405013552E+05,       0.999132835855504527E+05,       0.999267531384376343E+05,       0.999401187534305645E+05,
        0.999522829859957856E+05,       0.999629705900948175E+05,       0.999720750719777716E+05,       0.999795225775888684E+05,       0.999852704402040836E+05,
        0.999893033756584045E+05,       0.999916276698245056E+05,       0.999912215328864258E+05,       0.999874978505536856E+05,       0.999827294697511534E+05,
        0.999772668831095216E+05,       0.999714403004270425E+05,       0.999655543840146129E+05,       0.999598844544293243E+05,       0.999546738384171913E+05,
        0.999501503361758805E+05,       0.999464612795733119E+05,       0.999436472754112765E+05,       0.999417478240415512E+05,       0.999407845190346270E+05,
        0.999407674168311496E+05,       0.999417003681598144E+05,       0.999435850419050112E+05,       0.999466778359479795E+05,       0.999509741170870548E+05,
        0.999561184478715149E+05,       0.999620266396879451E+05,       0.999686260435519798E+05,       0.999758509523019893E+05,       0.999836356497705565E+05,
        0.999919049957114039E+05,       0.100000562486864073E+06,       0.100011784952549118E+06,       0.100025750768122278E+06,       0.100039950549839836E+06,
        0.100054145017178846E+06,       0.100068316891848794E+06,       0.100082450146767165E+06,       0.100096523400557431E+06,       0.100110501610887819E+06,
        0.100124326095454249E+06,       0.100137903024072584E+06,       0.100153035210029513E+06,       0.100168028234449826E+06,       0.100182528489386037E+06,
        0.100196311615898419E+06,       0.100209129758123207E+06,       0.100220714305906484E+06,       0.100227674075086179E+06,       0.100228582862959636E+06,
        0.100228182141282334E+06,       0.100226441566948473E+06,       0.100223301716988630E+06,       0.100218680617939594E+06,       0.100212480375930187E+06,
        0.100204593660852275E+06,       0.100193237399701000E+06,       0.100179608999797390E+06,       0.100163806561057383E+06,       0.100145763706322687E+06,
        0.100124166108882637E+06,       0.100097853920290698E+06,       0.100069603397772837E+06,       0.100039598196173276E+06,       0.100008052525304520E+06,
        0.999752085984543955E+05,       0.999413336779185047E+05,       0.999067168729345140E+05,       0.998716658233869821E+05,       0.998365033809807937E+05,
        0.998015643788216548E+05,       0.997673503212209471E+05,       0.997368095318123815E+05,       0.997072417009385681E+05,       0.996789372306682053E+05,
        0.996521942416031088E+05,       0.996273141486202512E+05,       0.996045978845247591E+05,       0.101067589111213412E+06,       0.101018770688517165E+06,
        0.100968154311929655E+06,       0.100916004392167699E+06,       0.100862587963118029E+06,       0.100807829042751429E+06,       0.100751860689524168E+06,
        0.100694824678955032E+06,       0.100636870575220571E+06,       0.100578085861079686E+06,       0.100518387120511878E+06,       0.100457910498338359E+06,
        0.100396827710058526E+06,       0.100335334776766380E+06,       0.100273650785659062E+06,       0.100212016619918053E+06,       0.100150693670614579E+06,
        0.100089962540906286E+06,       0.100030121749858867E+06,       0.999714864397286292E+05,       0.999143870864777564E+05,       0.998591682086720684E+05,
        0.998061870647466858E+05,       0.997614041189860436E+05,       0.997232133410041570E+05,       0.996877601571912237E+05,       0.996550329117300425E+05,
        0.996250097998356068E+05,       0.995976585142769036E+05,       0.995729358349222894E+05,       0.995507871467952355E+05,       0.995311458738776855E+05,
        0.995139328178480646E+05,       0.994990553930397000E+05,       0.994864067510919558E+05,       0.994758647909620777E+05,       0.994662936172032933E+05,
        0.994584116138104437E+05,       0.994520440064580325E+05,       0.994469670430250553E+05,       0.994429511205758317E+05,       0.994397638951787376E+05,
        0.994371735196124209E+05,       0.994349519828108314E+05,       0.994328785098660155E+05,       0.994307429622300406E+05,       0.994283491541375697E+05,
        0.994255179730021191E+05,       0.994164893114872393E+05,       0.994067289084808290E+05,       0.993968888922061742E+05,       0.993871232560968492E+05,
        0.993776052903232921E+05,       0.993685268314349669E+05,       0.993600967438642401E+05,       0.993525384531912714E+05,       0.993461969112091901E+05,
        0.993435709722199681E+05,       0.993430289823759958E+05,       0.993448240458555374E+05,       0.993518125064813066E+05,       0.993620332314667612E+05,
        0.993746322170980275E+05,       0.993895541802843509E+05,       0.994066995366652700E+05,       0.994259271220238734E+05,       0.994470579336317896E+05,
        0.994698797554098419E+05,       0.994941524985713913E+05,       0.995196140617028141E+05,       0.995459864926176379E+05,       0.995729822203312797E+05,
        0.996003101205446874E+05,       0.996273070851956145E+05,       0.996547798040555062E+05,       0.996819738131592894E+05,       0.997085378998868837E+05,
        0.997343278080748278E+05,       0.997592022275180498E+05,       0.997830289890008135E+05,       0.998056904289906088E+05,       0.998270877683784638E+05,
        0.998471443932554248E+05,       0.998658079734391795E+05,       0.998830514038870024E+05,       0.998996025676379795E+05,       0.999153229697452334E+05,
        0.999295566639472963E+05,       0.999422722019988432E+05,       0.999534500054842792E+05,       0.999630795823789667E+05,       0.999711562553596450E+05,
        0.999776774721563124E+05,       0.999826387612595136E+05,       0.999854644320731022E+05,       0.999828794177739328E+05,       0.999789847225893318E+05,
        0.999739838414557307E+05,       0.999680998532223457E+05,       0.999615553821963986E+05,       0.999545658866950980E+05,       0.999473341203756863E+05,
        0.999400456392968772E+05,       0.999327953721481608E+05,       0.999256989141568774E+05,       0.999189700236989156E+05,       0.999127048128768074E+05,
        0.999069798769329791E+05,       0.999018544683639047E+05,       0.998973722234758170E+05,       0.998935621850836178E+05,       0.998904388907014218E+05,
        0.998896448727687675E+05,       0.998900344972452294E+05,       0.998911970826382749E+05,       0.998931396187662176E+05,       0.998958769268335309E+05,
        0.998994275255013781E+05,       0.999038084460577520E+05,       0.999090289824781794E+05,       0.999150833667861443E+05,       0.999217240524284571E+05,
        0.999282473433497362E+05,       0.999348833579850179E+05,       0.999415375242985901E+05,       0.999481154404054105E+05,       0.999545171017064131E+05,
        0.999606302661866066E+05,       0.999663230149861483E+05,       0.999714356178636663E+05,       0.999757718627941504E+05,       0.999790900530105428E+05,
        0.999810939111108019E+05,       0.999819561511524662E+05,       0.999789948862129386E+05,       0.999752827398946683E+05,       0.999708888630344300E+05,
        0.999658466886194801E+05,       0.999601566475907457E+05,       0.999537895884533064E+05,       0.999466907368066168E+05,       0.999387840276392963E+05,
        0.999299766462147236E+05,       0.999201636218782805E+05,       0.999092323322767916E+05,       0.998970667923400615E+05,       0.998831789013588714E+05,
        0.998636939941647142E+05,       0.998431119746374316E+05,       0.998214963412640354E+05,       0.997970862666926550E+05,       0.997712444170942908E+05,
        0.997445906917362154E+05,       0.997173029439411330E+05,       0.996895795051780588E+05,       0.996616375682111830E+05,       0.996337113354519679E+05,
        0.996060500180081726E+05,       0.995789157595469587E+05,       0.995557562522905791E+05,       0.995337048495515774E+05,       0.995126888312002120E+05,
        0.994929130817774712E+05,       0.994745951235418033E+05,       0.994579612022724759E+05,       0.994432427594338078E+05,       0.101021034351216382E+06,
        0.100974523158164724E+06,       0.100926407272977900E+06,       0.100876804093661282E+06,       0.100825841471867636E+06,       0.100773656698396328E+06,
        0.100720395485641522E+06,       0.100666210969990992E+06,       0.100612099345619077E+06,       0.100557249279083626E+06,       0.100501677971650905E+06,
        0.100445572670880414E+06,       0.100389253853780203E+06,       0.100332968905338319E+06,       0.100276665148379936E+06,       0.100220537893264976E+06,
        0.100164799821054621E+06,       0.100109679736971462E+06,       0.100055421257730064E+06,       0.100002281430952105E+06,       0.999505292822571937E+05,
        0.999004442827473104E+05,       0.998530843548639095E+05,       0.998156761219489854E+05,       0.997805278523404413E+05,       0.997476323427424795E+05,
        0.997169731242686539E+05,       0.996885239311042969E+05,       0.996622481616842706E+05,       0.996380983225617529E+05,       0.996160154459489713E+05,
        0.995959284728124476E+05,       0.995777535943772964E+05,       0.995613935458951310E+05,       0.995467368475156691E+05,       0.995336569880241732E+05,
        0.995208266243795515E+05,       0.995087482639954542E+05,       0.994977965334250039E+05,       0.994878249241337762E+05,       0.994786826211323350E+05,
        0.994702168427006691E+05,       0.994622751834644587E+05,       0.994547079083998542E+05,       0.994473701327138842E+05,       0.994401238077413873E+05,
        0.994328394160198222E+05,       0.994254188335577346E+05,       0.994184404922492249E+05,       0.994087127432848210E+05,       0.993987930235803360E+05,
        0.993894574291334138E+05,       0.993808966627234331E+05,       0.993733080854502186E+05,       0.993668924009867187E+05,       0.993618498078672274E+05,
        0.993583756460734730E+05,       0.993566555807828554E+05,       0.993568603838800627E+05,       0.993591403923829785E+05,       0.993636197419046657E+05,
        0.993703904921866488E+05,       0.993811197203903430E+05,       0.993950856599565304E+05,       0.994111457979586703E+05,       0.994291602554974379E+05,
        0.994489675444759632E+05,       0.994703876196585625E+05,       0.994932253351752443E+05,       0.995172741944998997E+05,       0.995426559018634871E+05,
        0.995694776827033347E+05,       0.995970389008766942E+05,       0.996251091056232981E+05,       0.996534496905636333E+05,       0.996818187512539298E+05,
        0.997099760279327893E+05,       0.997374141751707793E+05,       0.997622618739524623E+05,       0.997862435467323085E+05,       0.998092414887019404E+05,
        0.998311505958143825E+05,       0.998518805596518214E+05,       0.998718102890837035E+05,       0.998910750046514877E+05,       0.999090219912788452E+05,
        0.999255559670365765E+05,       0.999405919139345788E+05,       0.999540538378546335E+05,       0.999658730563341524E+05,       0.999759860512857849E+05,
        0.999843319314751134E+05,       0.999908495555851987E+05,       0.999954743712658383E+05,       0.999944404784162907E+05,       0.999915968456238916E+05,
        0.999872439634975599E+05,       0.999816171531630534E+05,       0.999749362615833961E+05,       0.999674042229870247E+05,       0.999592064518093102E+05,
        0.999505109123499715E+05,       0.999414687118180882E+05,       0.999323665105546679E+05,       0.999233975283402833E+05,       0.999144981369005836E+05,
        0.999058003303556034E+05,       0.998974241845954093E+05,       0.998894782591478870E+05,       0.998820595750179200E+05,       0.998752530846157169E+05,
        0.998691305778080132E+05,       0.998637489957377547E+05,       0.998586746844062873E+05,       0.998541772928227729E+05,       0.998502966627068381E+05,
        0.998469966131329420E+05,       0.998442320106148400E+05,       0.998419453691209637E+05,       0.998400626589490130E+05,       0.998384883490106731E+05,
        0.998370997211475333E+05,       0.998357405118142487E+05,       0.998339247931384743E+05,       0.998316580178510631E+05,       0.998293639855545480E+05,
        0.998269017565975373E+05,       0.998241201967542729E+05,       0.998208528853709577E+05,       0.998098081032783375E+05,       0.997954370825381193E+05,
        0.997808296869748592E+05,       0.997662255405725009E+05,       0.997518145513712225E+05,       0.997377288090598740E+05,       0.997240360167264153E+05,
        0.997115902471897134E+05,       0.997002807779587602E+05,       0.996889928911353927E+05,       0.996776906921413611E+05,       0.996663184120892256E+05,
        0.996548031405013462E+05,       0.996430577981460665E+05,       0.996309842516777717E+05,       0.996172720856796950E+05,       0.995989960463366879E+05,
        0.995803026148819772E+05,       0.995612677891255880E+05,       0.995419614978694444E+05,       0.995224517021402135E+05,       0.995028080337064894E+05,
        0.994831049415358284E+05,       0.994634243322594411E+05,       0.994438577049017331E+05,       0.994245077928505052E+05,       0.994054897371244297E+05,
        0.993869318243143207E+05,       0.993690043020055746E+05,       0.993554308490509575E+05,       0.993412332136938494E+05,       0.993276308539287711E+05,
        0.993151162456799066E+05,       0.993038276851009432E+05,       0.992939167429839872E+05,       0.992855451787946949E+05,       0.992788820449725754E+05,
        0.100964847544612581E+06,       0.100921528597807934E+06,       0.100876819617514033E+06,       0.100830819119977881E+06,       0.100783635790840315E+06,
        0.100735387872604493E+06,       0.100686849362626730E+06,       0.100638850722815405E+06,       0.100589987206303587E+06,       0.100540391690949080E+06,
        0.100490207838124057E+06,       0.100439589213655403E+06,       0.100388698427470110E+06,       0.100337706295036201E+06,       0.100286791022897989E+06,
        0.100236137419730803E+06,       0.100185936133379830E+06,       0.100136382913311769E+06,       0.100087677896791603E+06,       0.100040024915916016E+06,
        0.999936308213850425E+05,       0.999487048175969685E+05,       0.999098959263045108E+05,       0.998760905821691704E+05,       0.998440744381323602E+05,
        0.998138388707919803E+05,       0.997853639904371375E+05,       0.997586190608742472E+05,       0.997335630315415328E+05,       0.997101451748205582E+05,
        0.996883058208672010E+05,       0.996679771815481945E+05,       0.996490842541338643E+05,       0.996315457942174835E+05,       0.996152753458579973E+05,
        0.996001823151213321E+05,       0.995855679555827810E+05,       0.995705558364965109E+05,       0.995563634129148850E+05,       0.995429286082849721E+05,
        0.995301928975228802E+05,       0.995181034121451230E+05,       0.995066149374921079E+05,       0.994956917495421949E+05,       0.994853092368055950E+05,
        0.994754552514231473E+05,       0.994661311329740856E+05,       0.994573523487461207E+05,       0.994491486954472930E+05,       0.994415640096655407E+05,
        0.994332401191460376E+05,       0.994242851325149240E+05,       0.994162875697421550E+05,       0.994093942955236271E+05,       0.994037502528714977E+05,
        0.993994957235938200E+05,       0.993967633485402912E+05,       0.993956749460767023E+05,       0.993963381773120200E+05,       0.993988431167032832E+05,
        0.994032587965396087E+05,       0.994096298031491460E+05,       0.994179730111528625E+05,       0.994282745493404218E+05,       0.994404870973938814E+05,
        0.994568186139204772E+05,       0.994754658271223161E+05,       0.994958964449326450E+05,       0.995177045414582390E+05,       0.995407458140571835E+05,
        0.995648609237595665E+05,       0.995898777201360062E+05,       0.996156137473152776E+05,       0.996418789751202567E+05,       0.996684786927591776E+05,
        0.996952164972683240E+05,       0.997218973051197536E+05,       0.997483303132390720E+05,       0.997743318352098577E+05,       0.997997279397391831E+05,
        0.998243568215117266E+05,       0.998484029817739647E+05,       0.998715185643880104E+05,       0.998929709407826740E+05,       0.999121391071011894E+05,
        0.999300598538423073E+05,       0.999466118827012979E+05,       0.999616803026846756E+05,       0.999751558213879034E+05,       0.999869336418048333E+05,
        0.999969120922718139E+05,       0.100004991024896648E+06,       0.100011070025070803E+06,       0.100011361902027944E+06,       0.100009689874259901E+06,
        0.100006354866167210E+06,       0.100001521961853068E+06,       0.999953569047140481E+05,       0.999880229251482233E+05,       0.999796782529097254E+05,
        0.999704742484093149E+05,       0.999605540801449097E+05,       0.999500518713602651E+05,       0.999395620634615480E+05,       0.999293797224061564E+05,
        0.999189780037119199E+05,       0.999084634603603772E+05,       0.998979305732036155E+05,       0.998874607924644370E+05,       0.998771215026191203E+05,
        0.998669648551638238E+05,       0.998570264274643996E+05,       0.998473236800365266E+05,       0.998378541987464268E+05,       0.998280094515223464E+05,
        0.998183015118441253E+05,       0.998087584599398106E+05,       0.997993088922536845E+05,       0.997898632369703118E+05,       0.997803110261358233E+05,
        0.997705176970055909E+05,       0.997603209573400527E+05,       0.997495267616314668E+05,       0.997338504371996823E+05,       0.997144148866953765E+05,
        0.996946194589021616E+05,       0.996748889962201501E+05,       0.996543973099300492E+05,       0.996333799061114987E+05,       0.996120632551793096E+05,
        0.995906575155593600E+05,       0.995693496108486434E+05,       0.995482968337894126E+05,       0.995276211300861032E+05,       0.995074041910853848E+05,
        0.994876834578204434E+05,       0.994684491110481467E+05,       0.994496420937635121E+05,       0.994311531852242333E+05,       0.994128231195840344E+05,
        0.993950629246981553E+05,       0.993796705843183881E+05,       0.993609699415756186E+05,       0.993418055421917088E+05,       0.993226794637357671E+05,
        0.993037059687493893E+05,       0.992849845648908376E+05,       0.992666033190360467E+05,       0.992486420429716236E+05,       0.992311752996093419E+05,
        0.992142751883332967E+05,       0.991980138777397078E+05,       0.991824658634138323E+05,       0.991677099373037345E+05,       0.991538308635238063E+05,
        0.991409207629147422E+05,       0.991303845164175582E+05,       0.991233478553789610E+05,       0.991173123854586884E+05,       0.991122941300806997E+05,
        0.991083274217430298E+05,       0.991054636978437338E+05,       0.991037699911700765E+05,       0.991033272031231463E+05,       0.991042282352598704E+05,
        0.991065760427079076E+05,       0.100899327711180042E+06,       0.100860014589195416E+06,       0.100819531202107522E+06,       0.100777959510744709E+06,
        0.100735390607726556E+06,       0.100694036465613695E+06,       0.100652089405901919E+06,       0.100609367247066592E+06,       0.100565963600471325E+06,
        0.100521982301190656E+06,       0.100477536683349797E+06,       0.100432748853070138E+06,       0.100387748961175384E+06,       0.100342674477306704E+06,
        0.100297669466538631E+06,       0.100252883868987425E+06,       0.100208472782261073E+06,       0.100164595745919316E+06,       0.100121416026401625E+06,
        0.100079099900142377E+06,       0.100037815931840771E+06,       0.999981416469988617E+05,       0.999662389876496309E+05,       0.999356748708466621E+05,
        0.999064575822306797E+05,       0.998785877324428584E+05,       0.998520583580002858E+05,       0.998268551135048328E+05,       0.998029565487271466E+05,
        0.997803344633126544E+05,       0.997589543309666333E+05,       0.997387757839643018E+05,       0.997197531476882141E+05,       0.997018360135869007E+05,
        0.996849698374662257E+05,       0.996690965483438340E+05,       0.996541551512074802E+05,       0.996382689559327409E+05,       0.996225861026435014E+05,
        0.996075569737299666E+05,       0.995931690202676109E+05,       0.995794128974490304E+05,       0.995662834351470083E+05,       0.995537804808199580E+05,
        0.995419095816340414E+05,       0.995306824727639178E+05,       0.995201173394836951E+05,       0.995102388219246932E+05,       0.995010777333177539E+05,
        0.994926704652096669E+05,       0.994850580565927958E+05,       0.994782849081547320E+05,       0.994712945317966660E+05,       0.994652135801002441E+05,
        0.994603804881314572E+05,       0.994568932856863394E+05,       0.994548423780885496E+05,       0.994543085284921108E+05,       0.994553608083860745E+05,
        0.994580545552721160E+05,       0.994624293810699601E+05,       0.994689205148530309E+05,       0.994771599445407046E+05,       0.994871232315969537E+05,
        0.994987933987223369E+05,       0.995121358180468815E+05,       0.995270974554495333E+05,       0.995436065119199775E+05,       0.995623452046183083E+05,
        0.995829609157189843E+05,       0.996045871363499173E+05,       0.996270734208106005E+05,       0.996502628846515872E+05,       0.996739938804089179E+05,
        0.996981017517049913E+05,       0.997224206254554738E+05,       0.997467852001343563E+05,       0.997710324871725461E+05,       0.997951466602976434E+05,
        0.998195365345201863E+05,       0.998432686447168817E+05,       0.998661797675172566E+05,       0.998881192989034753E+05,       0.999089497794278432E+05,
        0.999285470134942298E+05,       0.999467997752335650E+05,       0.999636091025751084E+05,       0.999788871899545629E+05,       0.999925558984901872E+05,
        0.100004544910230834E+06,       0.100014789560105870E+06,       0.100022807416958167E+06,       0.100024265952704969E+06,       0.100023783498597622E+06,
        0.100021339437537274E+06,       0.100017269778783608E+06,       0.100011871918673860E+06,       0.100005243624383627E+06,       0.999974886843563872E+05,
        0.999887143337349553E+05,       0.999790290942598513E+05,       0.999685409989449690E+05,       0.999573561671147618E+05,       0.999457665900857537E+05,
        0.999339297350767738E+05,       0.999216537925987359E+05,       0.999089986755408318E+05,       0.998960156700364460E+05,       0.998827458376240684E+05,
        0.998692184851955972E+05,       0.998554496711306274E+05,       0.998414407220986322E+05,       0.998266607131311466E+05,       0.998100194463602238E+05,
        0.997926225952954846E+05,       0.997741943883323111E+05,       0.997546758201429911E+05,       0.997340957313024119E+05,       0.997124527623238246E+05,
        0.996897658681415196E+05,       0.996660748766462057E+05,       0.996414402768971777E+05,       0.996159421531026164E+05,       0.995896781945527619E+05,
        0.995627607309631567E+05,       0.995353127665240754E+05,       0.995074630135256157E+05,       0.994793399566985754E+05,       0.994514054125879338E+05,
        0.994238487412724935E+05,       0.993966902679466439E+05,       0.993700475395201356E+05,       0.993440177799105440E+05,       0.993186743649216805E+05,
        0.992940638036397431E+05,       0.992702032829608506E+05,       0.992470788181921816E+05,       0.992246440384727030E+05,       0.992011645870204229E+05,
        0.991746701100545615E+05,       0.991489545634662645E+05,       0.991241218039765226E+05,       0.991002500071589602E+05,       0.990773923979805404E+05,
        0.990555784783537238E+05,       0.990348157029355934E+05,       0.990159736965085758E+05,       0.989981835313982592E+05,       0.989814199610305950E+05,
        0.989657585620708269E+05,       0.989512713805230014E+05,       0.989380287548638735E+05,       0.989261010103145527E+05,       0.989155600070171640E+05,
        0.989065271083586849E+05,       0.989035472935256403E+05,       0.989017382893972535E+05,       0.989010885106625501E+05,       0.989015950018414442E+05,
        0.989032643180148880E+05,       0.989061129372854630E+05,       0.989101672753579624E+05,       0.989154633681022387E+05,       0.989220462827519368E+05,
        0.989299693127524224E+05,       0.989392930054068274E+05,       0.100824204136130124E+06,       0.100789629875414903E+06,       0.100754101269738283E+06,
        0.100718965766187423E+06,       0.100683784943369043E+06,       0.100647901733698469E+06,       0.100611367338035154E+06,       0.100574242617115160E+06,
        0.100536597536512694E+06,       0.100498510595931759E+06,       0.100460068244709808E+06,       0.100421364285146075E+06,       0.100382499264969942E+06,
        0.100343579859943900E+06,       0.100304718247249199E+06,       0.100266031469940950E+06,       0.100227640792377366E+06,       0.100189671046138596E+06,
        0.100152249965554060E+06,       0.100115507511560325E+06,       0.100079575182221481E+06,       0.100047602801154819E+06,       0.100019322376832803E+06,
        0.999920409995853261E+05,       0.999657674355637573E+05,       0.999405058915761474E+05,       0.999162559646318405E+05,       0.998930126550737332E+05,
        0.998707664374257292E+05,       0.998495033822863334E+05,       0.998292053217475768E+05,       0.998098500498988724E+05,       0.997914115489896358E+05,
        0.997738602307620895E+05,       0.997571631813267886E+05,       0.997412843967411318E+05,       0.997261849951640761E+05,       0.997116241750995250E+05,
        0.996956516613714484E+05,       0.996802443385057850E+05,       0.996654141346137912E+05,       0.996511746410201595E+05,       0.996375414807133056E+05,
        0.996245325880948803E+05,       0.996121683814974822E+05,       0.996004718105865177E+05,       0.995894682617738144E+05,       0.995791853061816655E+05,
        0.995696522765213740E+05,       0.995608996615122596E+05,       0.995529583091799286E+05,       0.995458584335334599E+05,       0.995396284227406868E+05,
        0.995343367855710967E+05,       0.995305561580702051E+05,       0.995281233336275036E+05,       0.995270277929425938E+05,       0.995273063084702299E+05,
        0.995289897428417025E+05,       0.995321019769720151E+05,       0.995366588694784150E+05,       0.995426672761023801E+05,       0.995501241589093697E+05,
        0.995590158153962548E+05,       0.995693172571642208E+05,       0.995809917664462992E+05,       0.995939906564428093E+05,       0.996082532580851985E+05,
        0.996237071514999261E+05,       0.996402686551040679E+05,       0.996578435789826035E+05,       0.996763282420650648E+05,       0.996956299728876329E+05,
        0.997162410862197139E+05,       0.997372387307632453E+05,       0.997586353656998253E+05,       0.997808433601890720E+05,       0.998030187608370179E+05,
        0.998249872889569233E+05,       0.998465794208683947E+05,       0.998676313277232548E+05,       0.998879856224390824E+05,       0.999074918951320724E+05,
        0.999260070231147402E+05,       0.999433952465451439E+05,       0.999595280060564692E+05,       0.999742835440646595E+05,       0.999875462768208236E+05,
        0.999992059495608264E+05,       0.100009156592205647E+06,       0.100016063172606460E+06,       0.100019024917317467E+06,       0.100020084175617667E+06,
        0.100019327613303438E+06,       0.100016848817808917E+06,       0.100012745044390162E+06,       0.100007114161981110E+06,       0.100000051820447916E+06,
        0.999916488518789411E+05,       0.999819889104085451E+05,       0.999711463483044645E+05,       0.999591843210265215E+05,       0.999461531109617499E+05,
        0.999321525809828890E+05,       0.999172469778668019E+05,       0.999013989306642325E+05,       0.998846455567706289E+05,       0.998670119376398798E+05,
        0.998485130268999492E+05,       0.998291555936072982E+05,       0.998089401641651202E+05,       0.997878629283593327E+05,       0.997659175757975609E+05,
        0.997430970289848337E+05,       0.997193950386116485E+05,       0.996948076057053986E+05,       0.996688019987970183E+05,       0.996412728663371527E+05,
        0.996128531282160839E+05,       0.995835822131826571E+05,       0.995535100083936413E+05,       0.995226963046177698E+05,       0.994912096890770918E+05,
        0.994591258685886423E+05,       0.994265254172218556E+05,       0.993934909557864739E+05,       0.993601037847762636E+05,       0.993264400074980804E+05,
        0.992925661955399555E+05,       0.992585346639741329E+05,       0.992243784382298763E+05,       0.991926785386021656E+05,       0.991631423960881948E+05,
        0.991346701590620942E+05,       0.991043957205902552E+05,       0.990738404866020282E+05,       0.990437385072277393E+05,       0.990142493709584378E+05,
        0.989855195191612147E+05,       0.989576810877346288E+05,       0.989308511084253696E+05,       0.989051310684979690E+05,       0.988806068206827622E+05,
        0.988573488291608082E+05,       0.988354127318868268E+05,       0.988148401948802202E+05,       0.987956600302788138E+05,       0.987778895469693816E+05,
        0.987615361004738952E+05,       0.987465988074585912E+05,       0.987330703896907362E+05,       0.987209391124356771E+05,       0.987108234055703360E+05,
        0.987097019913824042E+05,       0.987103429529451387E+05,       0.987122111650228762E+05,       0.987153073516145814E+05,       0.987196321217762743E+05,
        0.987251875827369804E+05,       0.987319785667343094E+05,       0.987400135082831985E+05,       0.987493050090511242E+05,       0.987598701271371101E+05,
        0.987717304264797713E+05,       0.987849118205066625E+05,       0.987994442421061685E+05,       0.100725315299336173E+06,       0.100698574995327697E+06,
        0.100671977068823689E+06,       0.100644595052366465E+06,       0.100616468093977863E+06,       0.100587642901921921E+06,       0.100558173361375360E+06,
        0.100528120104899528E+06,       0.100497550042423565E+06,       0.100466272904751735E+06,       0.100434015096099785E+06,       0.100401562459773442E+06,
        0.100368989820934105E+06,       0.100336376879503077E+06,       0.100303807689072302E+06,       0.100271370122519947E+06,       0.100239155324566673E+06,
        0.100207257151323618E+06,       0.100175771596705425E+06,       0.100144796205413048E+06,       0.100114429472040734E+06,       0.100088940515445298E+06,
        0.100064277849083956E+06,       0.100040376776062651E+06,       0.100017243413296688E+06,       0.999948816446533019E+05,       0.999732929686431889E+05,
        0.999524763863759727E+05,       0.999324283249947912E+05,       0.999131425911760016E+05,       0.998946103486297798E+05,       0.998768201128693472E+05,
        0.998597577558295598E+05,       0.998434065122163738E+05,       0.998277469787591108E+05,       0.998127570968272776E+05,       0.997984121081719059E+05,
        0.997846844728672440E+05,       0.997711641937448148E+05,       0.997562547182444541E+05,       0.997418715469619347E+05,       0.997280378138771339E+05,
        0.997149197421024874E+05,       0.997024870178837737E+05,       0.996907061322415975E+05,       0.996795848806745926E+05,       0.996691347733205621E+05,
        0.996593714260480774E+05,       0.996503148183509184E+05,       0.996419894088608416E+05,       0.996344241017298482E+05,       0.996276520598402276E+05,
        0.996217103637612599E+05,       0.996166395185360743E+05,       0.996124828137155564E+05,       0.996092855454927922E+05,       0.996072490608482622E+05,
        0.996076113749229989E+05,       0.996091697144805221E+05,       0.996119324075692421E+05,       0.996159015340781625E+05,       0.996210724174448842E+05,
        0.996274331797853811E+05,       0.996349643746027868E+05,       0.996436387104583700E+05,       0.996534208777727908E+05,       0.996642674892599607E+05,
        0.996761271423777071E+05,       0.996889406096304010E+05,       0.997026411596077960E+05,       0.997171550083373149E+05,       0.997324018969322351E+05,
        0.997493713951271493E+05,       0.997669298086039198E+05,       0.997847561118552549E+05,       0.998027246306509041E+05,       0.998207116516734968E+05,
        0.998385964503245486E+05,       0.998562622533936083E+05,       0.998740649961419404E+05,       0.998916906165886030E+05,       0.999087089343172702E+05,
        0.999249770553750277E+05,       0.999403560696216737E+05,       0.999547111717594089E+05,       0.999679116588610341E+05,       0.999798308071318752E+05,
        0.999903456338236865E+05,       0.999993365533926699E+05,       0.100004220125714884E+06,       0.100007207317976179E+06,       0.100008572293640507E+06,
        0.100008322094038289E+06,       0.100006474067698131E+06,       0.100003053654514384E+06,       0.999980922203631635E+05,       0.999916249686873634E+05,
        0.999836889524048456E+05,       0.999743212064066029E+05,       0.999635570180646901E+05,       0.999514283507113723E+05,       0.999379624331032392E+05,
        0.999231805265346338E+05,       0.999068710521996836E+05,       0.998889830637409177E+05,       0.998698844492443604E+05,       0.998496268247692351E+05,
        0.998282550606056902E+05,       0.998058081407207792E+05,       0.997823201056188700E+05,       0.997578210428315797E+05,       0.997323380908236431E+05,
        0.997058964236216998E+05,       0.996785201849737350E+05,       0.996502333423933014E+05,       0.996210604331023060E+05,       0.995910271757503942E+05,
        0.995601609239409008E+05,       0.995275572850741737E+05,       0.994942010526460217E+05,       0.994602086162104097E+05,       0.994256424562004540E+05,
        0.993905674250224547E+05,       0.993550495610398939E+05,       0.993191545857771562E+05,       0.992829460972773086E+05,       0.992464834802344849E+05,
        0.992093627746182028E+05,       0.991704192318807618E+05,       0.991313574404489191E+05,       0.990923405318182195E+05,       0.990535358095906413E+05,
        0.990151121756168286E+05,       0.989772373919561505E+05,       0.989400752255912812E+05,       0.989077617710938066E+05,       0.988763612273478793E+05,
        0.988459508623079601E+05,       0.988166439660097676E+05,       0.987885464355162840E+05,       0.987617561295779306E+05,       0.987363624383705755E+05,
        0.987124460655073344E+05,       0.986900790161369223E+05,       0.986693247818405216E+05,       0.986502387102765642E+05,       0.986328685451310157E+05,
        0.986172551199377485E+05,       0.986034331877511868E+05,       0.985914323674813641E+05,       0.985849022212989948E+05,       0.985815381689221977E+05,
        0.985799833097597439E+05,       0.985801745721993211E+05,       0.985820463347552868E+05,       0.985855324877461535E+05,       0.985905682465279388E+05,
        0.985970917144189152E+05,       0.986050451971537113E+05,       0.986143762739106751E+05,       0.986250386326789885E+05,       0.986369926800004905E+05,
        0.986502059369656636E+05,       0.986646532347960892E+05,       0.986803686823803437E+05,       0.986978893846687570E+05,       0.100614832696455240E+06,
        0.100593867821148029E+06,       0.100572316446986515E+06,       0.100550197550235505E+06,       0.100527535703133908E+06,       0.100504360904461792E+06,
        0.100480708372667563E+06,       0.100456618304392017E+06,       0.100432135601374786E+06,       0.100407309568833982E+06,       0.100382193588466369E+06,
        0.100356844769226343E+06,       0.100331323579001226E+06,       0.100305693460217895E+06,       0.100280020432285120E+06,       0.100254372683605921E+06,
        0.100228820155686772E+06,       0.100203434121630358E+06,       0.100178286761032883E+06,       0.100153450733022924E+06,       0.100130475669895299E+06,
        0.100109956889046269E+06,       0.100089889070985242E+06,       0.100070296914338702E+06,       0.100051202164876013E+06,       0.100032623579079911E+06,
        0.100014576934231576E+06,       0.999970750815462088E+05,       0.999801280379814852E+05,       0.999637431114950741E+05,       0.999479250537698827E+05,
        0.999326762337752152E+05,       0.999179968250171223E+05,       0.999038849989644077E+05,       0.998903371169458405E+05,       0.998773479128125327E+05,
        0.998649106588674185E+05,       0.998530173079915839E+05,       0.998416586055586959E+05,       0.998308241656294995E+05,       0.998183931314519723E+05,
        0.998063026544255990E+05,       0.997946768033270637E+05,       0.997835353574148758E+05,       0.997728988116216497E+05,       0.997627886474906263E+05,
        0.997532275467060972E+05,       0.997442395412217011E+05,       0.997358500950898597E+05,       0.997280861143391958E+05,       0.997209758826208854E+05,
        0.997145489218259900E+05,       0.997088357784521941E+05,       0.997038677381365414E+05,       0.996996764724488748E+05,       0.996962936237215035E+05,
        0.996937503353465436E+05,       0.996920767365576030E+05,       0.996913013921977254E+05,       0.996914507293131610E+05,       0.996938892044791864E+05,
        0.996979235599974199E+05,       0.997029058021154924E+05,       0.997088141832942201E+05,       0.997156214047231770E+05,       0.997232945456081070E+05,
        0.997317950535919081E+05,       0.997416867970129533E+05,       0.997530959050235106E+05,       0.997652059203542885E+05,       0.997779192013086576E+05,
        0.997911354948921798E+05,       0.998047524629107502E+05,       0.998186662279794255E+05,       0.998327719289349043E+05,       0.998469642740837880E+05,
        0.998611380798811879E+05,       0.998751887820599950E+05,       0.998890129059611209E+05,       0.999025084828911640E+05,       0.999155753997843713E+05,
        0.999281156702924636E+05,       0.999400336166881025E+05,       0.999512359536410950E+05,       0.999616317670096760E+05,       0.999711323832548660E+05,
        0.999796511279028782E+05,       0.999849269357346784E+05,       0.999879656837563089E+05,       0.999896251175745128E+05,       0.999900253003605030E+05,
        0.999893361854775139E+05,       0.999873542140159407E+05,       0.999840556297011499E+05,       0.999794245840091753E+05,       0.999734518744631496E+05,
        0.999661337157758971E+05,       0.999574705623641785E+05,       0.999474659997932467E+05,       0.999361257217314414E+05,       0.999234566080410732E+05,
        0.999094659187412326E+05,       0.998941606177814683E+05,       0.998764809352623415E+05,       0.998560560817922524E+05,       0.998343967946635821E+05,
        0.998115510889874568E+05,       0.997875653304692096E+05,       0.997624843255732849E+05,       0.997363514996802405E+05,       0.997092091386610118E+05,
        0.996810986700549984E+05,       0.996520609610099054E+05,       0.996221366113048280E+05,       0.995913662211383053E+05,       0.995597906149207993E+05,
        0.995273916799414146E+05,       0.994941482859833632E+05,       0.994601365478679945E+05,       0.994253058448178053E+05,       0.993891469979643734E+05,
        0.993522589965478983E+05,       0.993147135957212886E+05,       0.992765913082987827E+05,       0.992379812368316198E+05,       0.991989807125657680E+05,
        0.991596947441791563E+05,       0.991202352822574612E+05,       0.990807203086648369E+05,       0.990412727632243623E+05,       0.990020193233719183E+05,
        0.989630890556004597E+05,       0.989246119604841224E+05,       0.988867174357804033E+05,       0.988495326844704396E+05,       0.988131810965392942E+05,
        0.987777806347563455E+05,       0.987434422556348145E+05,       0.987102683970903163E+05,       0.986800386904530314E+05,       0.986539370199152036E+05,
        0.986295226205249346E+05,       0.986068636404624995E+05,       0.985860239517589507E+05,       0.985670631337701197E+05,       0.985500365691113984E+05,
        0.985358556718200416E+05,       0.985278808654735767E+05,       0.985216145256253949E+05,       0.985170549437755544E+05,       0.985141907191163773E+05,
        0.985130023621957516E+05,       0.985134638334888878E+05,       0.985155439987927239E+05,       0.985192079865073320E+05,       0.985244184348827694E+05,
        0.985311366201568162E+05,       0.985393234591571963E+05,       0.985489403823850007E+05,       0.985599500758101349E+05,       0.985723170916025701E+05,
        0.985860083297847013E+05,       0.986009933943283249E+05,       0.986172448285415594E+05,       0.986347382357068564E+05,       0.986534522918489238E+05,
        0.100501068864754794E+06,       0.100484535396120875E+06,       0.100467601980879481E+06,       0.100450280398188552E+06,       0.100432586236747622E+06,
        0.100414538813697291E+06,       0.100396161067221547E+06,       0.100377479424244724E+06,       0.100358523644725865E+06,       0.100339326644139262E+06,
        0.100319924295798162E+06,       0.100300355214719486E+06,       0.100280660524754756E+06,       0.100260883610713514E+06,       0.100241069857193317E+06,
        0.100221266375801104E+06,       0.100201521722408346E+06,       0.100181885606032156E+06,       0.100162408590875246E+06,       0.100143141793000657E+06,
        0.100126731204709198E+06,       0.100111095964644017E+06,       0.100095755686584438E+06,       0.100080729264227775E+06,       0.100066034373636823E+06,
        0.100051687390123538E+06,       0.100037703324969872E+06,       0.100024095780550211E+06,       0.100010876922054129E+06,       0.999980574636844394E+05,
        0.999856466669404908E+05,       0.999736523483940109E+05,       0.999620808942374570E+05,       0.999509372788386972E+05,       0.999402250845782837E+05,
        0.999299465203828877E+05,       0.999201024366045604E+05,       0.999106923342315858E+05,       0.999017143668564822E+05,       0.998931653343625367E+05,
        0.998850406679233711E+05,       0.998765024783978733E+05,       0.998667989571770595E+05,       0.998574263414941233E+05,       0.998484104846885893E+05,
        0.998397772139483568E+05,       0.998315523922983994E+05,       0.998237619509676297E+05,       0.998164318901620281E+05,       0.998095882469221542E+05,
        0.998032570294378238E+05,       0.997974641179290484E+05,       0.997922351329589583E+05,       0.997875952728177945E+05,       0.997835691223818721E+05,
        0.997801804366022552E+05,       0.997774519024890033E+05,       0.997754048841174226E+05,       0.997740591557720181E+05,       0.997734326288465818E+05,
        0.997735410785172280E+05,       0.997747073495277582E+05,       0.997769755457649590E+05,       0.997800038461367949E+05,       0.997839110555756342E+05,
        0.997903666077980015E+05,       0.997975557260811329E+05,       0.998054075409305369E+05,       0.998138481350147340E+05,       0.998228007968337915E+05,
        0.998321862933507946E+05,       0.998419231581400672E+05,       0.998519279910743644E+05,       0.998621157651026879E+05,       0.998724001352771593E+05,
        0.998826937448957033E+05,       0.998929085234460072E+05,       0.999029559709882014E+05,       0.999127474237070273E+05,       0.999221942956127314E+05,
        0.999312082917789958E+05,       0.999397015890797338E+05,       0.999475869811254670E+05,       0.999547779849950166E+05,       0.999611889084034483E+05,
        0.999655508333875332E+05,       0.999687521058104176E+05,       0.999708756209590647E+05,       0.999718892905484245E+05,       0.999717672485314106E+05,
        0.999704891389138356E+05,       0.999680393573227484E+05,       0.999644062616458687E+05,       0.999595813666838658E+05,       0.999535585371076886E+05,
        0.999463331921408535E+05,       0.999379015343325445E+05,       0.999282598136142769E+05,       0.999174036365871580E+05,       0.999053273297332198E+05,
        0.998920233640268561E+05,       0.998774818472951010E+05,       0.998616900896773586E+05,       0.998432094200693391E+05,       0.998215258930813725E+05,
        0.997986442532860819E+05,       0.997746159978670912E+05,       0.997494898657428857E+05,       0.997233122677003994E+05,       0.996961277569055965E+05,
        0.996679795269207534E+05,       0.996389099249155406E+05,       0.996089609684258903E+05,       0.995781748547828611E+05,       0.995465944531801651E+05,
        0.995142637702681968E+05,       0.994812283811399975E+05,       0.994475358185973892E+05,       0.994132359146495874E+05,       0.993783810892878100E+05,
        0.993430265826917603E+05,       0.993072306281462952E+05,       0.992699361805924273E+05,       0.992322369590151648E+05,       0.991942880496349680E+05,
        0.991561790488717525E+05,       0.991180035697510175E+05,       0.990798588542613288E+05,       0.990418452912010980E+05,       0.990040658471643255E+05,
        0.989666254199359537E+05,       0.989296301250896213E+05,       0.988931865279689664E+05,       0.988574008344593603E+05,       0.988223780549877847E+05,
        0.987882211569994834E+05,       0.987550302217251592E+05,       0.987229016213559953E+05,       0.986919272327695508E+05,       0.986621937036891904E+05,
        0.986337817866148835E+05,       0.986067657550310105E+05,       0.985855251179539773E+05,       0.985675277620845591E+05,       0.985515831726142933E+05,
        0.985391751050558669E+05,       0.985310659201639937E+05,       0.985245080408891663E+05,       0.985195088048070465E+05,       0.985160685473306512E+05,
        0.985141813574870466E+05,       0.985138358391387155E+05,       0.985150158641151211E+05,       0.985177013051926042E+05,       0.985218687383599317E+05,
        0.985274921053063881E+05,       0.985345433285448526E+05,       0.985429928730166866E+05,       0.985528102493964543E+05,       0.985639644556170097E+05,
        0.985764243543491611E+05,       0.985901589852987236E+05,       0.986051378122090100E+05,       0.986213309053895937E+05,       0.986387090614195185E+05,
        0.986574141307979880E+05
};

#define NLON  81
#define NLAT 166

int main (int argc, char * argv[])
{
    size_t len, slen;
    grib_handle * h;
    const char * packingType[2] = {"grid_second_order", "grid_complex_spatial_differencing"};
    int ipackingType;
    const double zmiss = 9999999999.;
    long numberOfValues, numberOfDataPoints;
    int i, numberOfMissing;

    for (ipackingType = 0; ipackingType < 2; ipackingType++) {
        GRIB_CHECK (((h = grib_handle_new_from_samples (NULL, "regular_ll_pl_grib2")) == NULL), 0);
        GRIB_CHECK (grib_set_long (h, "Ni", NLON), 0);
        GRIB_CHECK (grib_set_long (h, "Nj", NLAT), 0);
        GRIB_CHECK (grib_set_double (h, "latitudeOfFirstGridPointInDegrees",  80.), 0);
        GRIB_CHECK (grib_set_double (h, "longitudeOfFirstGridPointInDegrees", -100.), 0);
        GRIB_CHECK (grib_set_double (h, "latitudeOfLastGridPointInDegrees",   0.) , 0);
        GRIB_CHECK (grib_set_double (h, "longitudeOfLastGridPointInDegrees",  65.), 0);
        GRIB_CHECK (grib_set_long (h, "iScansNegatively", 0), 0);
        GRIB_CHECK (grib_set_long (h, "jScansPositively", 0), 0);
        GRIB_CHECK (grib_set_long (h, "NV", 0), 0);
        slen = strlen ("sfc");
        GRIB_CHECK (grib_set_string (h, "typeOfFirstFixedSurface", "sfc", &slen), 0);

        GRIB_CHECK (grib_set_long (h, "bitsPerValue", 16), 0);
        slen = strlen (packingType[ipackingType]);
        GRIB_CHECK (grib_set_string (h, "packingType", packingType[ipackingType], &slen), 0);

        GRIB_CHECK (grib_set_long (h, "bitmapPresent", 1), 0);
        GRIB_CHECK (grib_set_double (h, "missingValue", zmiss), 0);

        for (i = 0, numberOfMissing = 0; i < NLON * NLAT; i += 100, numberOfMissing++) {
            values[i] = zmiss;
        }

        len = NLON * NLAT;
        GRIB_CHECK (grib_set_double_array (h, "values", values, len), 0);

        GRIB_CHECK (grib_get_long (h, "numberOfValues", &numberOfValues), 0);
        GRIB_CHECK (grib_get_long (h, "numberOfDataPoints", &numberOfDataPoints), 0);

        if (numberOfValues + numberOfMissing != numberOfDataPoints) {
            printf (" numberOfValues = %ld, numberOfDataPoints = %ld, numberOfMissing = %d\n", numberOfValues, numberOfDataPoints, numberOfMissing);
            printf (" numberOfValues appears to be incorrect\n");
            return 1;
        }

        GRIB_CHECK (grib_handle_delete (h), 0);
    }

    printf("ALL OK\n");
    return 0;
}
