info = {
    "name": "hr",
    "date_order": "DMY",
    "january": [
        "sij",
        "siječanj",
        "siječnja",
        "siječnju",
        "siječnjem"
    ],
    "february": [
        "velj",
        "veljača",
        "veljače",
        "veljači",
        "veljačom"
    ],
    "march": [
        "ožu",
        "ožujak",
        "ožujka",
        "ožujku",
        "ožujkom"
    ],
    "april": [
        "tra",
        "travanj",
        "travnja",
        "travnju",
        "travnjem"
    ],
    "may": [
        "svi",
        "svibanj",
        "svibnja",
        "svibnju",
        "svibnjem"
    ],
    "june": [
        "lip",
        "lipanj",
        "lipnja",
        "lipnju",
        "lipnjem"
    ],
    "july": [
        "srp",
        "srpanj",
        "srpnja",
        "srpnju",
        "srpnjem"
    ],
    "august": [
        "kol",
        "kolovoz",
        "kolovoza",
        "kolovozu",
        "kolovozom"
    ],
    "september": [
        "ruj",
        "rujan",
        "rujna",
        "rujnu",
        "rujnom"
    ],
    "october": [
        "lis",
        "listopad",
        "listopada",
        "listopadu",
        "listopadom"
    ],
    "november": [
        "stu",
        "studeni",
        "studenoga",
        "studenom",
        "studenomu",
        "studenome",
        "studenog",
        "studenim"
    ],
    "december": [
        "pro",
        "prosinac",
        "prosinca",
        "prosincu",
        "prosincem"
    ],
    "monday": [
        "pon",
        "ponedjeljak"
    ],
    "tuesday": [
        "uto",
        "utorak"
    ],
    "wednesday": [
        "sri",
        "srijeda"
    ],
    "thursday": [
        "čet",
        "četvrtak"
    ],
    "friday": [
        "pet",
        "petak"
    ],
    "saturday": [
        "sub",
        "subota"
    ],
    "sunday": [
        "ned",
        "nedjelja"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "g",
        "godina"
    ],
    "month": [
        "m",
        "mj",
        "mjesec"
    ],
    "week": [
        "tj",
        "tjedan"
    ],
    "day": [
        "d",
        "dan"
    ],
    "hour": [
        "h",
        "sat"
    ],
    "minute": [
        "min",
        "minuta"
    ],
    "second": [
        "s",
        "sekunda"
    ],
    "relative-type": {
        "0 day ago": [
            "danas"
        ],
        "0 hour ago": [
            "ovaj sat"
        ],
        "0 minute ago": [
            "ova minuta"
        ],
        "0 month ago": [
            "ovaj mj",
            "ovaj mjesec"
        ],
        "0 second ago": [
            "sad"
        ],
        "0 week ago": [
            "ovaj tj",
            "ovaj tjedan"
        ],
        "0 year ago": [
            "ove g",
            "ove god",
            "ove godine"
        ],
        "1 day ago": [
            "jučer",
            "jučer"
        ],
        "1 month ago": [
            "prošli mj",
            "prošli mjesec",
            "prošlog mjeseca",
            "prošlom mjesecu"
        ],
        "1 week ago": [
            "prošli tj",
            "prošli tjedan",
            "prošlog tjedna",
            "prošlom tjednu"
        ],
        "1 year ago": [
            "prošle g",
            "prošle god",
            "prošle godine",
            "prošla godina",
            "prošloj godini",
            "lani"
        ],
        "in 1 day": [
            "sutra",
            "sutra"
        ],
        "in 1 month": [
            "sljedeći mj",
            "sljedeći mjesec",
            "sljedećeg mjeseca",
            "sljedećem mjesecu",
            "idući mj",
            "idućeg mj",
            "idućem mj",
            "idući mjesec",
            "idućeg mjeseca",
            "idućem mjesecu"
        ],
        "in 1 week": [
            "sljedeći tj",
            "sljedeći tjedan",
            "sljedećeg tjedna",
            "sljedećem tjednu",
            "idući tj",
            "idućeg tj",
            "idućem tj",
            "idući tjedan",
            "idućeg tjedna",
            "idućem tjednu"
        ],
        "in 1 year": [
            "sljedeće g",
            "sljedeće god",
            "sljedeće godine",
            "sljedeća g",
            "sljedeća god",
            "sljedeća godina",
            "sljedećoj godini",
            "iduća g",
            "iduće g",
            "idućoj g",
            "iduća god",
            "iduće god",
            "idućoj god",
            "iduća godina",
            "iduće godine",
            "idućoj godini",
            "dogodine",
            "nagodinu"
        ],
        "in 2 day": [
            "prekosutra"
        ],
        "2 year ago": [
            "preklani"
        ],
        "2 day ago": [
            "prekjučer"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "prije (\\d+[.,]?\\d*) d",
            "prije (\\d+[.,]?\\d*) dan",
            "prije (\\d+[.,]?\\d*) dana"
        ],
        "\\1 hour ago": [
            "prije (\\d+[.,]?\\d*) h",
            "prije (\\d+[.,]?\\d*) sat",
            "prije (\\d+[.,]?\\d*) sati",
            "prije (\\d+[.,]?\\d*) sata"
        ],
        "\\1 minute ago": [
            "prije (\\d+[.,]?\\d*) min",
            "prije (\\d+[.,]?\\d*) minuta",
            "prije (\\d+[.,]?\\d*) minutu",
            "prije (\\d+[.,]?\\d*) minute"
        ],
        "\\1 month ago": [
            "prije (\\d+[.,]?\\d*) mj",
            "prije (\\d+[.,]?\\d*) mjesec",
            "prije (\\d+[.,]?\\d*) mjeseci",
            "prije (\\d+[.,]?\\d*) mjeseca"
        ],
        "\\1 second ago": [
            "prije (\\d+[.,]?\\d*) s",
            "prije (\\d+[.,]?\\d*) sekundi",
            "prije (\\d+[.,]?\\d*) sekundu",
            "prije (\\d+[.,]?\\d*) sekunde",
            "prije (\\d+[.,]?\\d*) sekundu"
        ],
        "\\1 week ago": [
            "prije (\\d+[.,]?\\d*) tj",
            "prije (\\d+[.,]?\\d*) tjedan",
            "prije (\\d+[.,]?\\d*) tjedana",
            "prije (\\d+[.,]?\\d*) tjedna"
        ],
        "\\1 year ago": [
            "prije (\\d+[.,]?\\d*) g",
            "prije (\\d+[.,]?\\d*) godina",
            "prije (\\d+[.,]?\\d*) godinu",
            "prije (\\d+[.,]?\\d*) godine"
        ],
        "in \\1 day": [
            "za (\\d+[.,]?\\d*) d",
            "za (\\d+[.,]?\\d*) dan",
            "za (\\d+[.,]?\\d*) dana"
        ],
        "in \\1 hour": [
            "za (\\d+[.,]?\\d*) h",
            "za (\\d+[.,]?\\d*) sat",
            "za (\\d+[.,]?\\d*) sati",
            "za (\\d+[.,]?\\d*) sata"
        ],
        "in \\1 minute": [
            "za (\\d+[.,]?\\d*) min",
            "za (\\d+[.,]?\\d*) minuta",
            "za (\\d+[.,]?\\d*) minutu",
            "za (\\d+[.,]?\\d*) minute"
        ],
        "in \\1 month": [
            "za (\\d+[.,]?\\d*) mj",
            "za (\\d+[.,]?\\d*) mjesec",
            "za (\\d+[.,]?\\d*) mjeseci",
            "za (\\d+[.,]?\\d*) mjeseca"
        ],
        "in \\1 second": [
            "za (\\d+[.,]?\\d*) s",
            "za (\\d+[.,]?\\d*) sekundi",
            "za (\\d+[.,]?\\d*) sekundu",
            "za (\\d+[.,]?\\d*) sekunde",
            "za (\\d+[.,]?\\d*) sekundu"
        ],
        "in \\1 week": [
            "za (\\d+[.,]?\\d*) tj",
            "za (\\d+[.,]?\\d*) tjedan",
            "za (\\d+[.,]?\\d*) tjedana",
            "za (\\d+[.,]?\\d*) tjedna"
        ],
        "in \\1 year": [
            "za (\\d+[.,]?\\d*) g",
            "za (\\d+[.,]?\\d*) godina",
            "za (\\d+[.,]?\\d*) godinu",
            "za (\\d+[.,]?\\d*) godine"
        ]
    },
    "locale_specific": {
        "hr-BA": {
            "name": "hr-BA"
        }
    },
    "in": [
        "u"
    ],
    "simplifications": [
        {
            "podne": "12:00"
        },
        {
            "ponoć": "00:00"
        }
    ],
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
