# Copyright (C) 2024 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from oslo_service._i18n import _


class BackendAlreadySelected(Exception):
    """Raised when init_backend() is called more than once."""
    pass


class BackendComponentNotAvailable(Exception):
    """Raised when a requested component is not available in the backend."""
    pass


class UnsupportedBackendError(Exception):
    """Raised when a component incompatible with threading backend is used."""
    def __init__(self, message=None):
        if message is None:
            message = _(
                "This component is not compatible with the threading backend. "
                "See the documentation for details about how to use the "
                "threading backend."
            )
        super().__init__(message)
