--TEST--
Test mkdir/rmdir cp936 path 
--SKIPIF--
<?php
include dirname(__FILE__) . DIRECTORY_SEPARATOR . "util.inc";

skip_if_not_win();
if (getenv("SKIP_SLOW_TESTS")) die("skip slow test");
skip_if_no_required_exts();
skip_if_wrong_cp(936, "oem");

?>
--INI--
internal_encoding=cp936
--FILE--
<?php
/*
#vim: set fileencoding=cp936
#vim: set encoding=cp936
*/

include dirname(__FILE__) . DIRECTORY_SEPARATOR . "util.inc";

$item = "yԇֹ·"; // cp936 string
$prefix = create_data("dir_cp936", $item . "5", 936);
$path = $prefix . DIRECTORY_SEPARATOR . "${item}5";

$subpath = $path . DIRECTORY_SEPARATOR . "${item}4";

/* The mb dirname exists*/
var_dump(file_exists($path));

var_dump(mkdir($subpath));
var_dump(file_exists($subpath));

get_basename_with_cp($subpath, 936);

var_dump(rmdir($subpath));
remove_data("dir_cp936");

?>
===DONE===
--EXPECTF--	
bool(true)
bool(true)
bool(true)
Active code page: 936
getting basename of %s\yԇֹ·5\yԇֹ·4
string(15) "yԇֹ·4"
bool(true)
string(%d) "%s\yԇֹ·5\yԇֹ·4"
Active code page: %d
bool(true)
===DONE===
