.\" *********************************** start of \input{common.tex}
.\" *********************************** end of \input{common.tex}
'\" t
.\" Manual page created with latex2man on Fri Sep 15 20:49:35 2023
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_GET\\_ELF\\_FILENAME" "3libunwind" "15 September 2023" "Programming Library " "Programming Library "
.SH NAME
unw_get_elf_filename
\-\- get backing elf filename 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_get_elf_filename(unw_cursor_t *cp,
char *bufp,
size_t
len,
unw_word_t *offp);
.br
.PP
.SH DESCRIPTION

.PP
The unw_get_elf_filename()
routine returns the backing elf 
filename of the current instruction pointer that created the stack frame 
identified by argument cp\&.
The bufp
argument is a pointer 
to a character buffer that is at least len
bytes long. This buffer 
is used to return the name of the procedure. The offp
argument is 
a pointer to a word that is used to return the byte offset of the instruction 
pointer saved in the stack frame identified by cp,
relative to the 
start of the elf file. For embedded system the symbol information may has 
been stripped from a program, then unw_get_proc_name()
may be 
completely unavailable, if the host side have the unstripped program with 
debuginfo, then can use addr2line
command tool on host to get the 
source file name and line number of the instruction pointer, with the elf 
filename in bufp
and address in offp\&.
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_get_elf_filename()
returns 0. 
Otherwise the negative value of one of the error codes below is 
returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_get_elf_filename()
is thread safe. If cursor cp
is 
in the local address space, this routine is also safe to use from a 
signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_ENOINFO
 Libunwind
was unable to determine 
the elf filename of the instruction pointer. 
.TP
UNW_ENOMEM
 The elf filename is too long to fit 
in the buffer provided. A truncated version of the name has been 
returned. 
.PP
.SH SEE ALSO

.PP
libunwind(3libunwind),
unw_get_proc_info(3libunwind)
unw_get_proc_name(3libunwind)
unw_get_elf_filename_by_ip(3libunwind)
addr2line(1addr2line)
.PP
.SH AUTHOR

.PP
Xiang Lin
.br
Email: \fBmyd.xia@gmail.com\fP
.br
.\" NOTE: This file is generated, DO NOT EDIT.
