/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 3.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef QT_BAMF_WINDOW_H
#define QT_BAMF_WINDOW_H

#include <QtCore/QObject>

#include <time.h>

#include "bamf-view.h"

class OrgAyatanaBamfWindowInterface;

class __attribute__ ((visibility ("default"))) BamfWindow: public BamfView
{
    Q_OBJECT

    Q_PROPERTY(uint xid READ xid)
    Q_PROPERTY(long last_active READ last_active)

friend class BamfFactory;

private:
    BamfWindow(QString path);
    ~BamfWindow();
    BamfWindow(BamfWindow const&);
    void operator=(BamfWindow const&);

public:
    Q_INVOKABLE BamfWindow * transient() const;

    // getters
    uint xid() const;
    long last_active() const;

private:
    OrgAyatanaBamfWindowInterface *m_window_proxy;
    time_t m_last_active;

private Q_SLOTS:
    void OnActiveChanged(bool new_state);
};

#endif

