// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// This file is used by Code Analysis to maintain SuppressMessage
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given
// a specific target and scoped to a namespace, type, member, etc.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Usage", "VSTHRD003:Avoid awaiting foreign Tasks", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageLoadContext.GetInstalledPackagesAsync~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.PackageCollection}")]
[assembly: SuppressMessage("Build", "CA2213:'PackageSourcesOptionsControl' contains field '_machineWidepackageSources' that is of IDisposable type 'BindingSource', but it is never disposed. Change the Dispose method on 'PackageSourcesOptionsControl' to call Close or Dispose on this field.", Justification = "'_machineWidepackageSources' field is disposed in 'PackageSourcesOptionsControl_Disposed' event handler", Scope = "member", Target = "~F:NuGet.Options.PackageSourcesOptionsControl._machineWidepackageSources")]
[assembly: SuppressMessage("Build", "CA2213:'PackageSourcesOptionsControl' contains field '_packageSources' that is of IDisposable type 'BindingSource', but it is never disposed. Change the Dispose method on 'PackageSourcesOptionsControl' to call Close or Dispose on this field.", Justification = "'_packageSources' field is disposed in 'PackageSourcesOptionsControl_Disposed' event handler", Scope = "member", Target = "~F:NuGet.Options.PackageSourcesOptionsControl._packageSources")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.DetailControlModel._projectVersionConstraints")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.DisplayVersion.AdditionalInfo")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.PreviewWindowModel.CopyGestures")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.ProgressDialogData.CurrentStep")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.ProgressDialogData.IsCancelable")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.ProgressDialogData.ProgressText")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.ProgressDialogData.TotalSteps")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.ProgressDialogData.WaitMessage")]
[assembly: SuppressMessage("Build", "CA1801:Parameter flags of method SelectChild is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.CheckedListBoxAccessibleObject.SelectChild(System.Windows.Forms.AccessibleSelection,System.Int32)")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, params object[])' could vary based on the current user's locale settings. Replace this call in 'GeneralOptionControl.localsCommandButton_OnClick(object, EventArgs)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.GeneralOptionControl.OnLocalsCommandButtonOnClick(System.Object,System.EventArgs)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'localsCommandButton_OnClick' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.GeneralOptionControl.OnLocalsCommandButtonOnClick(System.Object,System.EventArgs)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'OnActivated' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.GeneralOptionControl.OnActivated")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'OnApply' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.GeneralOptionControl.OnApply~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void GeneralOptionPage.OnApply(PageApplyEventArgs e)', validate parameter 'e' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.GeneralOptionPage.OnApply(Microsoft.VisualStudio.Shell.DialogPage.PageApplyEventArgs)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackageSourceOptionsPage.OnApply(PageApplyEventArgs e)', validate parameter 'e' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.PackageSourceOptionsPage.OnApply(Microsoft.VisualStudio.Shell.DialogPage.PageApplyEventArgs)")]
[assembly: SuppressMessage("Build", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.PackageSourcesOptionsControl.ApplyChangedSettingsAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1822:Member GetCheckBoxRectangleForListBoxItem does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.PackageSourcesOptionsControl.GetCheckBoxRectangleForListBoxItem(NuGet.Options.PackageSourceCheckedListBox,System.Int32)~System.Drawing.Rectangle")]
[assembly: SuppressMessage("Build", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.PackageSourcesOptionsControl.InitializeOnActivatedAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'AccessiblePackageIdentity.AccessiblePackageIdentity(PackageIdentity id)', validate parameter 'id' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.AccessiblePackageIdentity.#ctor(NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1305:'AccessiblePackageIdentity.AccessiblePackageIdentity(PackageIdentity)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, object, object)'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.AccessiblePackageIdentity.#ctor(NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'Convert.ToDouble(object)' could vary based on the current user's locale settings. Replace this call in 'AdditionConverter.Convert(object[], Type, object, CultureInfo)' with a call to 'Convert.ToDouble(object, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.AdditionConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object AdditionConverter.Convert(object[] values, Type targetType, object parameter, CultureInfo culture)', validate parameter 'values' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.AdditionConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.IndexOf(string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.UI.AuthorAndDownloadCount.UpdateControl()' with a call to 'string.IndexOf(string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.AuthorAndDownloadCount.UpdateControl")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object DateTimeConverter.Convert(object value, Type targetType, object parameter, CultureInfo culture)', validate parameter 'culture' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DateTimeConverter.Convert(System.Object,System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.Equals(string, string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.UI.DateTimeConverter.Convert(object, System.Type, object, System.Globalization.CultureInfo)' with a call to 'string.Equals(string, string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DateTimeConverter.Convert(System.Object,System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void DetailControlModel.AddBlockedVersions(NuGetVersion[] blockedVersions)', validate parameter 'blockedVersions' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DetailControlModel.AddBlockedVersions(NuGet.Versioning.NuGetVersion[])")]
[assembly: SuppressMessage("Build", "CA1822:Member ExplainPackageDeprecationReasons does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DetailControlModel.ExplainPackageDeprecationReasons(System.Collections.Generic.IReadOnlyCollection{System.String})~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member GetPackageDeprecationAlternatePackageText does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DetailControlModel.GetPackageDeprecationAlternatePackageText(NuGet.Protocol.AlternatePackageMetadata)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task DetailControlModel.SetCurrentPackageAsync(PackageItemViewModel searchResultPackage, ItemFilter filter, Func<PackageItemViewModel> getPackageItemViewModel)', validate parameter 'getPackageItemViewModel' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DetailControlModel.SetCurrentPackageAsync(NuGet.PackageManagement.UI.PackageItemViewModel,NuGet.PackageManagement.UI.ItemFilter,System.Func{NuGet.PackageManagement.UI.PackageItemViewModel})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'DetailedPackageMetadata.DetailedPackageMetadata(IPackageSearchMetadata serverData, PackageDeprecationMetadata deprecationMetadata, long? downloadCount)', validate parameter 'serverData' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DetailedPackageMetadata.#ctor(NuGet.Protocol.Core.Types.IPackageSearchMetadata,NuGet.Protocol.PackageDeprecationMetadata,System.Nullable{System.Int64})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'DisplayVersion.DisplayVersion(VersionRange range, string additionalInfo, bool isValidVersion = true, bool isCurrentInstalled = false, bool autoReferenced = false, bool isDeprecated = false, string versionFormat = \"N\")', validate parameter 'range' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DisplayVersion.#ctor(NuGet.Versioning.VersionRange,System.String,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String)")]
[assembly: SuppressMessage("Build", "CA1822:Member WaitForInitialResultsAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.InfiniteScrollList.WaitForInitialResultsAsync(NuGet.PackageManagement.UI.IItemLoader{NuGet.PackageManagement.UI.PackageItemViewModel},System.IProgress{NuGet.PackageManagement.UI.IItemLoaderState},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1801:Parameter parameter of method Convert is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.MessageLevelToBrushConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1303:Method 'object NotEqualConverter.Convert(object value, Type targetType, object parameter, CultureInfo culture)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"Parameter should not be null and should inherit from IComparable\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NotEqualConverter.Convert(System.Object,System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'NuGetProjectUpgradeDependencyItem.NuGetProjectUpgradeDependencyItem(PackageIdentity package, PackageWithDependants packageWithDependants)', validate parameter 'packageWithDependants' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NuGetProjectUpgradeDependencyItem.#ctor(NuGet.Packaging.Core.PackageIdentity,NuGet.PackageManagement.PackageWithDependants)")]
[assembly: SuppressMessage("Build", "CA1822:Member PromoteToTopLevelIfNeeded does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NuGetProjectUpgradeWindowModel.PromoteToTopLevelIfNeeded(NuGet.Packaging.PackageArchiveReader,NuGet.PackageManagement.UI.NuGetProjectUpgradeDependencyItem)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void NuGetUI.ShowError(Exception ex)', validate parameter 'ex' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NuGetUI.ShowError(System.Exception)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IModalProgressDialogSession> NuGetUIContext.StartModalProgressDialogAsync(string caption, ProgressDialogData initialData, INuGetUI uiService)', validate parameter 'initialData' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NuGetUIContext.StartModalProgressDialogAsync(System.String,NuGet.PackageManagement.UI.ProgressDialogData,NuGet.PackageManagement.UI.INuGetUI)~System.Threading.Tasks.Task{NuGet.PackageManagement.UI.IModalProgressDialogSession}")]
[assembly: SuppressMessage("Build", "CA1822:Member ShowFileConflictResolution does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NuGetUIProjectContext.ShowFileConflictResolution(System.String)~NuGet.ProjectManagement.FileConflictAction")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageDependencyMetadata.PackageDependencyMetadata(PackageDependency serverData)', validate parameter 'serverData' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageDependencyMetadata.#ctor(NuGet.Packaging.Core.PackageDependency)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageDetailControlModel.PackageDetailControlModel(INuGetSolutionManagerService solutionManager, IEnumerable<NuGetProject> nugetProjects)', validate parameter 'solutionManager' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageDetailControlModel.#ctor(NuGet.VisualStudio.Internal.Contracts.INuGetSolutionManagerService,System.Collections.Generic.IEnumerable{NuGet.VisualStudio.Internal.Contracts.IProjectContextInfo})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task PackageDetailControlModel.SetCurrentPackageAsync(PackageItemViewModel searchResultPackage, ItemFilter filter, Func<PackageItemViewModel> getPackageItemViewModel)', validate parameter 'getPackageItemViewModel' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageDetailControlModel.SetCurrentPackageAsync(NuGet.PackageManagement.UI.PackageItemViewModel,NuGet.PackageManagement.UI.ItemFilter,System.Func{NuGet.PackageManagement.UI.PackageItemViewModel})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'int PackageInstallationInfo.CompareTo(PackageInstallationInfo other)', validate parameter 'other' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageInstallationInfo.CompareTo(NuGet.PackageManagement.UI.PackageInstallationInfo)~System.Int32")]
[assembly: SuppressMessage("Build", "CA1822:Member VersionEquals does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageItemViewModel.VersionEquals(NuGet.Versioning.NuGetVersion,NuGet.Versioning.NuGetVersion)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.IndexOf(string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.UI.PackageLicenseUtilities.GenerateLicenseLinks(NuGet.Packaging.LicenseMetadata, string, System.Func<string, string>)' with a call to 'string.IndexOf(string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageLicenseUtilities.GenerateLicenseLinks(NuGet.Packaging.LicenseMetadata,System.String,System.Func{System.String,System.String})~System.Collections.Generic.IReadOnlyList{NuGet.PackageManagement.UI.IText}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'PackageLicenseUtilities.GenerateLicenseLinks(LicenseMetadata, string, Func<string, string>)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageLicenseUtilities.GenerateLicenseLinks(NuGet.Packaging.LicenseMetadata,System.String,System.Func{System.String,System.String})~System.Collections.Generic.IReadOnlyList{NuGet.PackageManagement.UI.IText}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void PackageManagerProvidersLabel.UpdateControl()' passes a literal string as parameter 'text' of a call to 'Run.Run(string text)'. Retrieve the following string(s) from a resource table instead: \", \".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageManagerProvidersLabel.UpdateControl")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.IndexOf(string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.UI.PackageManagerProvidersLabel.UpdateControl()' with a call to 'string.IndexOf(string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageManagerProvidersLabel.UpdateControl")]
[assembly: SuppressMessage("Build", "CA1822:Member SetConsolidationAutomationProperties does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageManagerTopPanel.SetConsolidationAutomationProperties(System.Windows.Controls.TabItem,System.Int32)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'UIRestorePackagesAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageRestoreBar.UIRestorePackagesAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'UserControl_Loaded' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageRestoreBar.UserControl_Loaded(System.Object,System.Windows.RoutedEventArgs)")]
[assembly: SuppressMessage("Build", "CA1801:Parameter currentVersion of method ShowUpdateBar is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.ProductUpdateBar.ShowUpdateBar(System.Version,System.Version)")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'int.Parse(string)' could vary based on the current user's locale settings. Replace this call in 'RadioBoolToIntConverter.Convert(object, Type, object, CultureInfo)' with a call to 'int.Parse(string, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.RadioBoolToIntConverter.Convert(System.Object,System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object RadioBoolToIntConverter.Convert(object value, Type targetType, object parameter, CultureInfo culture)', validate parameter 'parameter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.RadioBoolToIntConverter.Convert(System.Object,System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'RestartRequestBar.RestartRequestBar(IDeleteOnRestartManager deleteOnRestartManager, IVsShell4 vsRestarter)', validate parameter 'deleteOnRestartManager' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.RestartRequestBar.#ctor(NuGet.PackageManagement.IDeleteOnRestartManager,Microsoft.VisualStudio.Shell.Interop.IVsShell4)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void SolutionView.RestoreUserSettings(UserSettings userSettings)', validate parameter 'userSettings' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.SolutionView.RestoreUserSettings(NuGet.PackageManagement.UI.UserSettings)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void SolutionView.SaveSettings(UserSettings settings)', validate parameter 'settings' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.SolutionView.SaveSettings(NuGet.PackageManagement.UI.UserSettings)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object StringFormatConverter.Convert(object[] values, Type targetType, object parameter, CultureInfo culture)', validate parameter 'values' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.StringFormatConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, params object[])' could vary based on the current user's locale settings. Replace this call in 'StringFormatConverter.Convert(object[], Type, object, CultureInfo)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.StringFormatConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'Convert.ToDouble(object)' could vary based on the current user's locale settings. Replace this call in 'SubstractionConverter.Convert(object[], Type, object, CultureInfo)' with a call to 'Convert.ToDouble(object, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.SubstractionConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object SubstractionConverter.Convert(object[] values, Type targetType, object parameter, CultureInfo culture)', validate parameter 'values' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.SubstractionConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1822:Member GeneratePackageLicenseInfo does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.GeneratePackageLicenseInfo(NuGet.Protocol.Core.Types.IPackageSearchMetadata)~NuGet.PackageManagement.UI.PackageLicenseInfo")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'UIActionEngine.GetPackageMetadataAsync(IEnumerable<SourceRepository>, IEnumerable<PackageIdentity>, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.GetPackageMetadataAsync(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity},System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.List{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task UIActionEngine.PerformInstallOrUninstallAsync(INuGetUI uiService, UserAction userAction, CancellationToken token)', validate parameter 'uiService' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.PerformInstallOrUninstallAsync(NuGet.PackageManagement.UI.INuGetUI,NuGet.PackageManagement.UI.UserAction,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task UIActionEngine.PerformUpdateAsync(INuGetUI uiService, List<PackageIdentity> packagesToUpdate, CancellationToken token)', validate parameter 'uiService' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.PerformUpdateAsync(NuGet.PackageManagement.UI.INuGetUI,System.Collections.Generic.List{NuGet.Packaging.Core.PackageIdentity},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'LaunchExternalLink' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIUtility.LaunchExternalLink(System.Uri)")]
[assembly: SuppressMessage("Build", "CA1305:'UpdatePreviewResult.UpdatePreviewResult(PackageIdentity, PackageIdentity)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, params object[])'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UpdatePreviewResult.#ctor(NuGet.Packaging.Core.PackageIdentity,NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'UpdatePreviewResult.UpdatePreviewResult(PackageIdentity oldPackage, PackageIdentity newPackage)', validate parameter 'oldPackage' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UpdatePreviewResult.#ctor(NuGet.Packaging.Core.PackageIdentity,NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'UpgradeLogger.UpgradeLogger(string reportName, string backupPath)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"reportName\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UpgradeLogger.#ctor(System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA3075:Unsafe overload of 'LoadXml' method", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UpgradeLogger.#ctor(System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<IVsWindowFrame> VsUtility.GetDocumentWindows(IVsUIShell uiShell)', validate parameter 'uiShell' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.VsUtility.GetDocumentWindows(Microsoft.VisualStudio.Shell.Interop.IVsUIShell)~System.Collections.Generic.IEnumerable{Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageManagerControl VsUtility.GetPackageManagerControl(IVsWindowFrame windowFrame)', validate parameter 'windowFrame' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.VsUtility.GetPackageManagerControl(Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame)~NuGet.PackageManagement.UI.PackageManagerControl")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'bool.ToString()' could vary based on the current user's locale settings. Replace this call in 'CheckedListBoxItemAccessibleObject.Value.get' with a call to 'bool.ToString(IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Options.CheckedListBoxItemAccessibleObject.Value")]
[assembly: SuppressMessage("Build", "CA1303:Method 'int PackageSourceCheckedListBox.ItemHeight.get' passes a literal string as parameter 'text' of a call to 'SizeF Graphics.MeasureString(string text, Font font)'. Retrieve the following string(s) from a resource table instead: \"SampleText\".", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Options.PackageSourceCheckedListBox.ItemHeight")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void DetailControl.Control.set', validate parameter 'value' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.UI.DetailControl.Control")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property DetailControlModel.OptionsBlockedUrlText from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.UI.DetailControlModel.OptionsBlockedUrlText")]
[assembly: SuppressMessage("Build", "CA1822:Member ButtonMinWidth does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.UI.PreviewWindowModel.ButtonMinWidth")]
[assembly: SuppressMessage("Build", "CA1822:Member DoNotShowAgainMinWidth does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.UI.PreviewWindowModel.DoNotShowAgainMinWidth")]
[assembly: SuppressMessage("Build", "CA1501:'GeneralOptionControl' has an object hierarchy '7' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContainerControl, ScrollableControl, Control, Component, MarshalByRefObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Options.GeneralOptionControl")]
[assembly: SuppressMessage("Build", "CA1501:'PackageSourceCheckedListBox' has an object hierarchy '7' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'CheckedListBox, ListBox, ListControl, Control, Component, MarshalByRefObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Options.PackageSourceCheckedListBox")]
[assembly: SuppressMessage("Build", "CA1501:'PackageSourcesOptionsControl' has an object hierarchy '7' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContainerControl, ScrollableControl, Control, Component, MarshalByRefObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Options.PackageSourcesOptionsControl")]
[assembly: SuppressMessage("Build", "CA1501:'ActionsAndVersions' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ActionsAndVersions")]
[assembly: SuppressMessage("Build", "CA1501:'ArrowGlyphAdorner' has an object hierarchy '7' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'Adorner, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ArrowGlyphAdorner")]
[assembly: SuppressMessage("Build", "CA1501:'AuthorAndDownloadCount' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.AuthorAndDownloadCount")]
[assembly: SuppressMessage("Build", "CA1501:'DeprecatedFrameworkWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.DeprecatedFrameworkWindow")]
[assembly: SuppressMessage("Build", "CA1501:'DeprecationControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.DeprecationControl")]
[assembly: SuppressMessage("Build", "CA1501:'DetailControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.DetailControl")]
[assembly: SuppressMessage("Build", "CA1501:'FileConflictDialog' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.FileConflictDialog")]
[assembly: SuppressMessage("Build", "CA1501:'InfiniteScrollList' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.InfiniteScrollList")]
[assembly: SuppressMessage("Build", "CA1501:'InfiniteScrollListBox' has an object hierarchy '10' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'ListBox, Selector, ItemsControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.InfiniteScrollListBox")]
[assembly: SuppressMessage("Build", "CA1501:'LicenseAcceptanceWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.LicenseAcceptanceWindow")]
[assembly: SuppressMessage("Build", "CA1501:'LicenseFileWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.LicenseFileWindow")]
[assembly: SuppressMessage("Build", "CA1501:'LoadingStatusBar' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.LoadingStatusBar")]
[assembly: SuppressMessage("Build", "CA1501:'NuGetProjectUpgradeWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.NuGetProjectUpgradeWindow")]
[assembly: SuppressMessage("Build", "CA1501:'OptionsControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.OptionsControl")]
[assembly: SuppressMessage("Build", "CA1501:'PackageItemControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageItemControl")]
[assembly: SuppressMessage("Build", "CA1501:'PackageManagementFormatWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageManagementFormatWindow")]
[assembly: SuppressMessage("Build", "CA1501:'ListBoxToggleableItemsAutomationPeer' has an object hierarchy '8' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'ListBoxAutomationPeer, SelectorAutomationPeer, ItemsControlAutomationPeer, FrameworkElementAutomationPeer, UIElementAutomationPeer, AutomationPeer, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ListBoxToggleableItemsAutomationPeer")]
[assembly: SuppressMessage("Build", "CA1501:'ListViewToggleableItemsAutomationPeer' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'ListViewAutomationPeer, ListBoxAutomationPeer, SelectorAutomationPeer, ItemsControlAutomationPeer, FrameworkElementAutomationPeer, UIElementAutomationPeer, AutomationPeer, DispatcherObject, Object'", Justification = "Default WPF automation peer hierarchy", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ListViewToggleableItemsAutomationPeer")]
[assembly: SuppressMessage("Build", "CA1501:'ToggleableItemAutomationPeer' has an object hierarchy '6' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'ListBoxItemAutomationPeer, SelectorItemAutomationPeer, ItemAutomationPeer, AutomationPeer, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ToggleableItemAutomationPeer")]
[assembly: SuppressMessage("Build", "CA1501:'PackageManagerControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageManagerControl")]
[assembly: SuppressMessage("Build", "CA1501:'PackageManagerProvidersLabel' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "Default WPF Hierarchy", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageManagerProvidersLabel")]
[assembly: SuppressMessage("Build", "CA1501:'PackageItemDeprecationLabel' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "Default WPF Hierarchy", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageItemDeprecationLabel")]
[assembly: SuppressMessage("Build", "CA1501:'PackageManagerTopPanel' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageManagerTopPanel")]
[assembly: SuppressMessage("Build", "CA1501:'PackageMetadataControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageMetadataControl")]
[assembly: SuppressMessage("Build", "CA1501:'PackageRestoreBar' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageRestoreBar")]
[assembly: SuppressMessage("Build", "CA1501:'PreviewWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PreviewWindow")]
[assembly: SuppressMessage("Build", "CA1501:'PRMigratorBar' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PRMigratorBar")]
[assembly: SuppressMessage("Build", "CA1501:'ProductUpdateBar' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ProductUpdateBar")]
[assembly: SuppressMessage("Build", "CA1501:'ProjectsListView' has an object hierarchy '10' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'ListBox, Selector, ItemsControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ProjectsListView")]
[assembly: SuppressMessage("Build", "CA1501:'ProjectView' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ProjectView")]
[assembly: SuppressMessage("Build", "CA1501:'RestartRequestBar' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.RestartRequestBar")]
[assembly: SuppressMessage("Build", "CA1501:'SolutionView' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.SolutionView")]
[assembly: SuppressMessage("Build", "CA1501:'Spinner' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.Spinner")]
[assembly: SuppressMessage("Build", "CA1501:'VsDialogWindow' has an object hierarchy '11' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.VsDialogWindow")]
[assembly: SuppressMessage("Build", "CA1821:Remove empty Finalizers", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DataStreamFromComStream.Finalize")]
[assembly: SuppressMessage("ApiDesign", "RS0026:Do not add multiple public overloads with optional parameters", Justification = "API already shipped", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DisplayVersion.#ctor(NuGet.Versioning.NuGetVersion,System.String,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String)")]
[assembly: SuppressMessage("ApiDesign", "RS0026:Do not add multiple public overloads with optional parameters", Justification = "API already shipped", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DisplayVersion.#ctor(NuGet.Versioning.VersionRange,System.String,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String)")]
[assembly: SuppressMessage("ApiDesign", "RS0027:Public API with optional parameter(s) should have the most parameters amongst its public overloads.", Justification = "API already shipped", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.ProgressDialogData.#ctor(System.String,System.String,System.Boolean)")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackagesConfigToPackageReferenceMigrator.DoUpgradeAsync(NuGet.PackageManagement.UI.INuGetUIContext,NuGet.PackageManagement.UI.INuGetUI,NuGet.VisualStudio.Internal.Contracts.IProjectContextInfo,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.UI.NuGetProjectUpgradeDependencyItem},System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity},System.IProgress{NuGet.PackageManagement.UI.ProgressDialogData},System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.String}")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageSolutionDetailControlModel.UpdateInstalledVersionsAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.UpgradeNuGetProjectAsync(NuGet.PackageManagement.UI.INuGetUI,NuGet.VisualStudio.Internal.Contracts.IProjectContextInfo)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1501:'VulnerabilitiesControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "Default WPF class hierarchy", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.VulnerabilitiesControl")]
