/* Definitions of target machine for Mitsubishi D10V.
   Copyright (C) 1999, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 2, or (at your
   option) any later version.

   GCC is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING.  If not, write to the Free
   Software Foundation, 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA. */

/* Variables to hold compare operators until the appropriate branch or scc
   operation is done.  */
extern GTY(()) rtx d10v_compare_op0;
extern GTY(()) rtx d10v_compare_op1;

/* Functions defined in d10v.c.  */
extern void override_options           PARAMS ((void));
extern void debug_stack_info           PARAMS ((d10v_stack_t *));
extern int  direct_return              PARAMS ((void));
extern int  parallel_ldi               PARAMS ((HOST_WIDE_INT));
extern d10v_stack_t * d10v_stack_info  PARAMS ((void));

#ifdef RTX_CODE
extern int  gpr_operand PARAMS ((rtx, enum machine_mode));
extern int  accum_operand PARAMS ((rtx, enum machine_mode));
extern int  reg_or_0_operand PARAMS ((rtx, enum machine_mode));
extern int  reg_or_short_memory_operand PARAMS ((rtx, enum machine_mode));
extern int  arith16_operand PARAMS ((rtx, enum machine_mode));
extern int  arith_4bit_operand PARAMS ((rtx, enum machine_mode));
extern int  arith_nonnegative_operand PARAMS ((rtx, enum machine_mode));
extern int  arith32_operand PARAMS ((rtx, enum machine_mode));
extern int  arith64_operand PARAMS ((rtx, enum machine_mode));
extern int  arith_lower0_operand PARAMS ((rtx, enum machine_mode));
extern int  ldi_shift_operand PARAMS ((rtx, enum machine_mode));
extern int  pc_or_label_operand PARAMS ((rtx, enum machine_mode));
extern int  short_memory_operand PARAMS ((rtx, enum machine_mode));
extern int  cond_move_operand PARAMS ((rtx, enum machine_mode));
extern int  cond_exec_operand PARAMS ((rtx, enum machine_mode));
extern int  carry_operand PARAMS ((rtx, enum machine_mode));
extern int  f0_operand PARAMS ((rtx, enum machine_mode));
extern int  f1_operand PARAMS ((rtx, enum machine_mode));
extern int  f_operand PARAMS ((rtx, enum machine_mode));
extern int  f0_compare_operator PARAMS ((rtx, enum machine_mode));
extern int  compare_operator PARAMS ((rtx, enum machine_mode));
extern int  equality_operator PARAMS ((rtx, enum machine_mode));
extern int  signed_compare_operator PARAMS ((rtx, enum machine_mode));
extern int  unsigned_compare_operator PARAMS ((rtx, enum machine_mode));
extern int  unary_parallel_operator PARAMS ((rtx, enum machine_mode));
extern int  binary_parallel_operator PARAMS ((rtx, enum machine_mode));
extern int  extend_parallel_operator PARAMS ((rtx, enum machine_mode));
extern int  minmax_parallel_operator PARAMS ((rtx, enum machine_mode));
extern int  adjacent_memory_operands PARAMS ((rtx, rtx, rtx, int));
extern void d10v_expand_divmod PARAMS ((rtx *, int));
extern void initialize_trampoline PARAMS ((rtx, rtx, rtx));
extern enum machine_mode d10v_emit_comparison  PARAMS ((enum rtx_code, rtx, rtx, rtx, rtx, enum machine_mode, int));
extern void d10v_expand_branch PARAMS ((enum rtx_code, rtx));
extern void d10v_expand_setcc PARAMS ((enum rtx_code, rtx));
extern rtx  d10v_expand_compare PARAMS ((enum rtx_code));
extern int  d10v_expand_movcc PARAMS ((rtx[]));
extern const char *emit_move_word PARAMS ((rtx, rtx, rtx));
extern const char *emit_move_2words PARAMS ((rtx, rtx, rtx));
extern const char *emit_add PARAMS ((rtx *, rtx));
extern const char *emit_subtract PARAMS ((rtx *, rtx));
extern const char *emit_cond_move PARAMS ((rtx *, rtx));
extern rtx  d10v_split_logical_op PARAMS ((rtx *, enum rtx_code));
extern void d10v_output_addr_const PARAMS ((FILE *, rtx));
extern void print_operand_address PARAMS ((FILE *, rtx));
extern void print_operand PARAMS ((FILE *, rtx, int));
extern rtx  d10v_expand_builtin_saveregs PARAMS ((void));
extern int  d10v_legitimate_address_p PARAMS ((enum machine_mode, rtx, int));
extern rtx  d10v_legitimize_address PARAMS ((rtx, rtx, enum machine_mode, int));
extern int  d10v_mode_dependent_address_p PARAMS ((rtx));
extern rtx  d10v_subword PARAMS ((rtx, int, enum machine_mode, enum machine_mode));
extern void d10v_expand_builtin_va_start PARAMS ((tree));
extern rtx  d10v_expand_builtin_va_arg PARAMS ((tree, tree));
extern void d10v_expand_prologue PARAMS ((void));
extern void d10v_expand_epilogue PARAMS ((void));

#ifdef TREE_CODE
extern void init_cumulative_args PARAMS ((CUMULATIVE_ARGS *, tree, rtx, tree, int));
extern rtx  function_arg         PARAMS ((CUMULATIVE_ARGS *, enum machine_mode, tree, int));
#endif
#endif

#ifdef TREE_CODE
extern int  function_arg_boundary       PARAMS ((enum machine_mode, tree));
extern int  function_arg_callee_copies  PARAMS ((CUMULATIVE_ARGS *, enum machine_mode, tree, int));
extern void function_arg_advance        PARAMS ((CUMULATIVE_ARGS *, enum machine_mode, tree, int));
extern void d10v_setup_incoming_varargs PARAMS ((CUMULATIVE_ARGS *, enum machine_mode, tree, int *, int));
#endif
